/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.financeiro.faturamento.ExameBasico;
import jalis.laboratorio.financeiro.faturamento.PagadorBasico;
import jalis.laboratorio.financeiro.faturamento.PagamentoBasico;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RequisicaoBasica {
    private Integer codigoRequisicao = null;
    private Integer codigoPaciente = null;
    private String nomePaciente = null;
    private Date dataRequisicao = null;
    private String conselhoMedico = null;
    private String crmMedico = null;
    private String ufMedico = null;
    private String nomeMedico = null;
    private String nomePagador = null;
    private String cpfPagador = null;
    private ArrayList<Integer> listaCodigoNotaFiscal = null;
    private ArrayList<Long> listaNumeroNotaFiscal = null;
    private ArrayList<Long> listaRpsNotaFiscal = null;
    private ArrayList<String> listaSerieNotaFiscal = null;
    private BigDecimal valorTotal = null;
    private BigDecimal valorDevido = null;
    private final int casas = ParametrosGerais.getCasasPrecoExame();
    private final RoundingMode round = ParametrosGerais.getArredondamentoPrecoExame();
    ArrayList<ExameBasico> exames = null;
    ArrayList<PagamentoBasico> pagamentos = null;
    List<PagadorBasico> pagadores = null;

    public RequisicaoBasica(Integer codigoRequisicao, Integer codigoPaciente, String nomePaciente, Date dataRequisicao, String conselhoMedico, String crmMedico, String ufMedico, String nomeMedico, String nomePagador, String cpfPagador, BigDecimal valorTotal, BigDecimal valorPago) {
        this.codigoRequisicao = codigoRequisicao;
        this.codigoPaciente = codigoPaciente;
        this.nomePaciente = nomePaciente;
        this.dataRequisicao = dataRequisicao;
        this.conselhoMedico = conselhoMedico;
        this.crmMedico = crmMedico;
        this.ufMedico = ufMedico;
        this.nomeMedico = nomeMedico;
        this.nomePagador = nomePagador;
        this.cpfPagador = cpfPagador;
        this.valorTotal = valorTotal == null ? BigDecimal.ZERO : valorTotal;
        this.valorDevido = this.valorTotal.subtract(valorPago == null ? BigDecimal.ZERO : valorPago).setScale(this.casas, this.round);
        if (this.exames == null) {
            this.exames = new ArrayList();
        }
        if (this.pagamentos == null) {
            this.pagamentos = new ArrayList();
        }
        if (this.pagadores == null) {
            this.pagadores = new ArrayList<PagadorBasico>();
        }
        if (this.listaCodigoNotaFiscal == null) {
            this.listaCodigoNotaFiscal = new ArrayList<Integer>(){

                @Override
                public String toString() {
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < RequisicaoBasica.this.listaCodigoNotaFiscal.size(); ++i) {
                        if (buf.length() > 0) {
                            buf.append(", ");
                        }
                        buf.append(RequisicaoBasica.this.listaCodigoNotaFiscal.get(i));
                    }
                    return buf.toString();
                }
            };
        }
        if (this.listaNumeroNotaFiscal == null) {
            this.listaNumeroNotaFiscal = new ArrayList<Long>(){

                @Override
                public String toString() {
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < RequisicaoBasica.this.listaNumeroNotaFiscal.size(); ++i) {
                        if (RequisicaoBasica.this.listaNumeroNotaFiscal.get(i) == null) continue;
                        if (buf.length() > 0) {
                            buf.append(", ");
                        }
                        buf.append(RequisicaoBasica.this.listaNumeroNotaFiscal.get(i));
                    }
                    return buf.toString();
                }
            };
        }
        if (this.listaRpsNotaFiscal == null) {
            this.listaRpsNotaFiscal = new ArrayList<Long>(){

                @Override
                public String toString() {
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < RequisicaoBasica.this.listaRpsNotaFiscal.size(); ++i) {
                        if (RequisicaoBasica.this.listaRpsNotaFiscal.get(i) == null) continue;
                        if (buf.length() > 0) {
                            buf.append(", ");
                        }
                        buf.append(RequisicaoBasica.this.listaRpsNotaFiscal.get(i));
                    }
                    return buf.toString();
                }
            };
        }
        if (this.listaSerieNotaFiscal == null) {
            this.listaSerieNotaFiscal = new ArrayList();
        }
    }

    public void addPagador(PagadorBasico pagador, PagamentoBasico pgto) {
        pagador.setRequisicao(this);
        for (int i = 0; i < this.pagadores.size(); ++i) {
            if (!pagador.equals(this.pagadores.get(i))) continue;
            this.pagadores.get(i).setValorPago(this.pagadores.get(i).getValorPago().add(pagador.getValorPago()).setScale(this.casas, this.round));
            this.pagadores.get(i).getPagamentos().add(pgto);
            return;
        }
        this.pagadores.add(pagador);
    }

    public void addPagador(PagadorBasico pagador) {
        for (int i = 0; i < this.pagadores.size(); ++i) {
            if (!pagador.equals(this.pagadores.get(i))) continue;
            this.pagadores.get(i).setValorPago(this.pagadores.get(i).getValorPago().add(pagador.getValorPago()).setScale(this.casas, this.round));
            return;
        }
        this.pagadores.add(pagador);
    }

    public void addExame(ExameBasico exame) {
        this.exames.add(exame);
    }

    public void addPagamento(PagamentoBasico lancamento) {
        this.pagamentos.add(lancamento);
        if (!(lancamento.getCodigoNotaFiscal() == null || lancamento.getNumeroNotaFiscal() == null && lancamento.getRpsNotaFiscal() == null || lancamento.getSerieNotaFiscal() == null || this.listaCodigoNotaFiscal.contains(lancamento.getCodigoNotaFiscal()))) {
            this.listaCodigoNotaFiscal.add(lancamento.getCodigoNotaFiscal());
            this.listaNumeroNotaFiscal.add(lancamento.getNumeroNotaFiscal());
            this.listaRpsNotaFiscal.add(lancamento.getRpsNotaFiscal());
            this.listaSerieNotaFiscal.add(lancamento.getSerieNotaFiscal());
        }
    }

    public String toString() {
        if (this.codigoRequisicao == null) {
            return "";
        }
        return this.codigoRequisicao.toString();
    }

    public Integer getCodigoRequisicao() {
        return this.codigoRequisicao;
    }

    public void setCodigoRequisicao(Integer codigoRequisicao) {
        this.codigoRequisicao = codigoRequisicao;
    }

    public Integer getCodigoPaciente() {
        return this.codigoPaciente;
    }

    public void setCodigoPaciente(Integer codigoPaciente) {
        this.codigoPaciente = codigoPaciente;
    }

    public String getNomePaciente() {
        return this.nomePaciente;
    }

    public void setNomePaciente(String nomePaciente) {
        this.nomePaciente = nomePaciente;
    }

    public Date getDataRequisicao() {
        return this.dataRequisicao;
    }

    public void setDataRequisicao(Date dataRequisicao) {
        this.dataRequisicao = dataRequisicao;
    }

    public String getConselhoMedico() {
        return this.conselhoMedico;
    }

    public void setConselhoMedico(String conselhoMedico) {
        this.conselhoMedico = conselhoMedico;
    }

    public String getCrmMedico() {
        return this.crmMedico;
    }

    public void setCrmMedico(String crmMedico) {
        this.crmMedico = crmMedico;
    }

    public String getUfMedico() {
        return this.ufMedico;
    }

    public void setUfMedico(String ufMedico) {
        this.ufMedico = ufMedico;
    }

    public String getNomeMedico() {
        return this.nomeMedico;
    }

    public void setNomeMedico(String nomeMedico) {
        this.nomeMedico = nomeMedico;
    }

    public String getNomePagador() {
        return this.nomePagador;
    }

    public void setNomePagador(String nomePagador) {
        this.nomePagador = nomePagador;
    }

    public String getCpfPagador() {
        return this.cpfPagador;
    }

    public void setCpfPagador(String cpfPagador) {
        this.cpfPagador = cpfPagador;
    }

    public ArrayList<Integer> getListaCodigoNotaFiscal() {
        return this.listaCodigoNotaFiscal;
    }

    public void setListaCodigoNotaFiscal(ArrayList<Integer> listaCodigoNotaFiscal) {
        this.listaCodigoNotaFiscal = listaCodigoNotaFiscal;
    }

    public ArrayList<Long> getListaNumeroNotaFiscal() {
        return this.listaNumeroNotaFiscal;
    }

    public void setListaNumeroNotaFiscal(ArrayList<Long> listaNumeroNotaFiscal) {
        this.listaNumeroNotaFiscal = listaNumeroNotaFiscal;
    }

    public ArrayList<Long> getListaRpsNotaFiscal() {
        return this.listaRpsNotaFiscal;
    }

    public void setListaRpsNotaFiscal(ArrayList<Long> listaRpsNotaFiscal) {
        this.listaRpsNotaFiscal = listaRpsNotaFiscal;
    }

    public ArrayList<String> getListaSerieNotaFiscal() {
        return this.listaSerieNotaFiscal;
    }

    public void setListaSerieNotaFiscal(ArrayList<String> listaSerieNotaFiscal) {
        this.listaSerieNotaFiscal = listaSerieNotaFiscal;
    }

    public BigDecimal getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(BigDecimal valorTotal) {
        this.valorTotal = valorTotal;
    }

    public BigDecimal getValorDevido() {
        return this.valorDevido;
    }

    public void setValorDevido(BigDecimal valorDevido) {
        this.valorDevido = valorDevido;
    }

    public ArrayList<ExameBasico> getExames() {
        return this.exames;
    }

    public void setExames(ArrayList<ExameBasico> exames) {
        this.exames = exames;
    }

    public ArrayList<PagamentoBasico> getPagamentos() {
        return this.pagamentos;
    }

    public void setPagamentos(ArrayList<PagamentoBasico> pagamentos) {
        this.pagamentos = pagamentos;
    }

    public List<PagadorBasico> getPagadores() {
        return this.pagadores;
    }

    public void setPagadores(ArrayList<PagadorBasico> pagadores) {
        this.pagadores = pagadores;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.codigoRequisicao == null ? 0 : this.codigoRequisicao.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequisicaoBasica other = (RequisicaoBasica)obj;
        return !(this.codigoRequisicao == null ? other.codigoRequisicao != null : !this.codigoRequisicao.equals(other.codigoRequisicao));
    }
}

