/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.faturamento.EditorDadosFaturamento;
import jalis.util.Funcoes;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.Color;
import java.awt.Component;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class RenderRequisicoes
extends DefaultTableCellRenderer {
    RenderRequisicoes() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component result = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ModeloResultSet model = (ModeloResultSet)table.getModel();
        Registro reg = model.getRegistros().get(row);
        Color corForeground = table.getForeground();
        if (reg.getBoolean("req_deveguia")) {
            corForeground = Color.RED;
        }
        result.setForeground(corForeground);
        if (!(reg.getBoolean("guiaconferida") && reg.getValor("req_dataguiaconferida") != null || reg.getBoolean("gravarConferido"))) {
            ((JComponent)result).setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, EditorDadosFaturamento.COR_SEM_CONFERENCIA));
        } else {
            ((JComponent)result).setBorder(BorderFactory.createEmptyBorder());
        }
        Integer[] guias = null;
        String codigoRequisicao = reg.getString("req_codigo");
        if (!Funcoes.textoVazio(codigoRequisicao)) {
            try {
                guias = RecepcaoUtil.verificaMultiGuias(reg.getString("fil_codigo"), codigoRequisicao, false);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        JLabel label = (JLabel)result;
        if (guias != null) {
            label.setText("<html><u>" + value + "</u></html>");
        }
        return label;
    }
}

