/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Tipos;
import jalis.laboratorio.financeiro.faturamento.ConferenciaGuias;
import jalis.util.ScreenUtil;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class RenderExames
extends DefaultTableCellRenderer {
    RenderExames() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ModeloResultSet model = (ModeloResultSet)table.getModel();
        Registro reg = model.getRegistros().get(row);
        Color corExame = table.getSelectionForeground();
        Color[] cores = Tipos.getCorSituacaoExame(reg.getString("exr_situacao"));
        corExame = reg.getBoolean("exr_deveguia") ? ConferenciaGuias.COR_DEVE_GUIA : (reg.getBoolean("exr_naofaturar") ? ConferenciaGuias.COR_NAO_FATURAR : cores[1]);
        if (isSelected) {
            if (cores[0] != Color.WHITE) {
                this.setBackground(ScreenUtil.escurecerCor(cores[0], 20));
            } else {
                this.setBackground(table.getSelectionBackground());
            }
        } else {
            this.setBackground(cores[0]);
        }
        this.setForeground(corExame);
        return this;
    }
}

