/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.faturamento.BuscaFatura;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.laboratorio.util.faturamento.ImprimirFatura;
import jalis.laboratorio.util.faturamento.ImprimirResumoFatura;
import jalis.laboratorio.util.faturamento.LinhasTabela;
import jalis.util.ConvenioUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class ReimprimirFatura
extends FrmPadrao
implements ActionListener,
ThreadFinalizadaListener {
    private JPanel panelEsquerdo = new JPanel(new GridBagLayout());
    private JPanel panelDireito = new JPanel(new BorderLayout());
    private JPanel panelDireitoExames = new JPanel();
    private JPanel panelDireitoLegenda = new JPanel();
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelBotoesE = new JPanel(new FlowLayout(0));
    private JPanel panelBotoesD = new JPanel(new FlowLayout(2));
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonImprimir = new JButton("Imprimir");
    private JButton buttonNovo = new JButton("Novo");
    private JButton buttonConsultar = new JButton("Consultar");
    private JButton buttonFatura = new JButton();
    private JButton buttonCancelar = new JButton("Cancelar");
    private JPopupMenu menu = new JPopupMenu();
    private JPopupMenu menuImprimir = new JPopupMenu();
    private JLabel labelFatura = new JLabel("Fatura:");
    private TTextField txtFatura = new TTextField(5, 1);
    private int status = 1;
    private boolean imprimirAgrupada = false;
    private boolean isCarregando = false;

    public ReimprimirFatura() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ConferenciaFatura");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelEsquerdo, "West");
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelDireito, "Center");
        this.panelEsquerdo.setPreferredSize(new Dimension(150, 100));
        this.panelDireito.add((Component)this.panelDireitoExames, "Center");
        this.panelDireito.add((Component)this.panelDireitoLegenda, "South");
        FuncoesGerais.montaLegenda(this.panelDireitoLegenda);
        Funcoes.criaBarraDescricao(this, "Reimpress\u00e3o de Fatura", "Reimpress\u00e3o de Fatura", "financeiro/reimpressao-fatura.jpg");
        this.panelBotoes.add((Component)this.panelBotoesE, "West");
        this.panelBotoes.add((Component)this.panelBotoesD, "East");
        this.panelBotoesD.add(this.buttonNovo);
        this.panelBotoesD.add(this.buttonImprimir);
        this.panelBotoesD.add(this.buttonCancelar);
        this.panelBotoesD.add(this.buttonFechar);
        this.buttonImprimir.setVisible(Acesso.getAcesso(Long.parseLong("0600200800")));
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 1.0;
        cons.fill = 2;
        cons.anchor = 17;
        this.panelEsquerdo.add((Component)this.labelFatura, cons);
        cons.gridx = 1;
        cons.anchor = 13;
        cons.weightx = 0.0;
        cons.fill = 0;
        this.txtFatura.setPreferredSize(new Dimension(70, 20));
        this.txtFatura.setMinimumSize(new Dimension(70, 20));
        this.panelEsquerdo.add((Component)this.txtFatura, cons);
        cons.gridx = 2;
        this.buttonFatura.setPreferredSize(new Dimension(20, 20));
        this.buttonFatura.setMinimumSize(new Dimension(20, 20));
        this.panelEsquerdo.add((Component)this.buttonFatura, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 3;
        cons.anchor = 13;
        this.panelEsquerdo.add((Component)this.buttonConsultar, cons);
        cons.gridy = 2;
        cons.fill = 1;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        cons.gridwidth = 3;
        this.panelEsquerdo.add((Component)new JPanel(), cons);
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        this.buttonFechar.setMnemonic('F');
        this.buttonConsultar.setMnemonic('t');
        this.buttonNovo.setMnemonic('N');
        this.buttonImprimir.setMnemonic('I');
        this.buttonCancelar.setMnemonic('C');
        Funcoes.imagemPesquisa(this.buttonFatura);
        this.buttonFatura.setFocusable(false);
        this.buttonConsultar.setMargin(new Insets(2, 2, 2, 2));
        this.controlaCampos();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReimprimirFatura.this.novo();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.mensagem(ReimprimirFatura.this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                    ReimprimirFatura.this.limpaCampos();
                    ReimprimirFatura.this.status = 1;
                    ReimprimirFatura.this.controlaCampos();
                    ReimprimirFatura.this.buttonNovo.requestFocus();
                }
            }
        });
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Laboratorio.getInstancia().setInterromperInfoRequisicao(false);
                ReimprimirFatura.this.setVisible(false);
            }
        });
        this.buttonConsultar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReimprimirFatura.this.pesquisaFaturamento();
            }
        });
        this.buttonFatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReimprimirFatura.this.pesquisaFatura();
            }
        });
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReimprimirFatura.this.novo();
            }
        });
        this.buttonImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReimprimirFatura.this.imprimirFatura(ReimprimirFatura.this.imprimirAgrupada);
            }
        });
    }

    private void novo() {
        this.limpaCampos();
        this.status = 2;
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.txtFatura);
    }

    private void limpaCampos() {
        Laboratorio.getInstancia().setInterromperInfoRequisicao(false);
        this.txtFatura.clear();
        this.panelDireitoExames.removeAll();
        this.panelDireitoExames.repaint();
    }

    private void controlaCampos() {
        boolean habilita = this.status == 2;
        this.txtFatura.setEnabled(habilita && !this.isCarregando);
        this.buttonFatura.setEnabled(habilita && !this.isCarregando);
        this.buttonNovo.setEnabled(!habilita && !this.isCarregando);
        this.buttonImprimir.setEnabled(habilita && !this.isCarregando);
        this.buttonFechar.setEnabled(!habilita && !this.isCarregando);
        this.buttonConsultar.setEnabled(habilita && !this.isCarregando);
        this.buttonCancelar.setEnabled(habilita && !this.isCarregando);
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0600200800");
    }

    @Override
    public void pressioneiF2() {
        if (this.txtFatura.hasFocus()) {
            this.buttonFatura.doClick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pesquisaFaturamento() {
        if (!Funcoes.isNumeric(this.txtFatura.getText())) {
            Funcoes.mensagem(this, "C\u00f3digo da fatura n\u00e3o informado", 1);
            this.txtFatura.grabFocus();
            return;
        }
        this.buttonConsultar.setEnabled(false);
        this.panelDireitoExames.removeAll();
        this.panelDireitoExames.setLayout(null);
        Laboratorio.getInstancia().setInterromperInfoRequisicao(true);
        BuscaFatura consulta = new BuscaFatura((Frame)this.getTopLevelAncestor(), this.panelDireitoExames, this.buttonConsultar, true, true, false, this);
        consulta.setCodigoFatura(this.txtFatura.getText());
        consulta.start();
        if (!Funcoes.textoVazio(this.txtFatura.getText())) {
            Statement st;
            block6: {
                StringBuilder buf = new StringBuilder();
                buf.append("select a.con_codigo from fatura a ");
                buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
                buf.append("where a.fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                buf.append(" and a.fat_codigo = ");
                buf.append(this.txtFatura.getText());
                buf.append(" and a.fat_datacancelamento is null ");
                buf.append(" and b.con_faturaagrupada = true ");
                st = Conexao.getStatement();
                try {
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (!rs.next()) break block6;
                    this.imprimirAgrupada = true;
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaFatura (748)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    private void pesquisaFatura() {
        boolean retorno;
        Hashtable resultado = Pesquisas.fatura(this.getTopLevelAncestor());
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtFatura.setText(resultado.get("fat_codigo").toString());
        }
        this.txtFatura.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imprimirFatura(boolean agrupar) {
        LinhasTabela modeloFatura = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        if (modeloFatura == null || modeloFatura.getRowCount() == 0) {
            Funcoes.mensagem(this, "Nenhuma fatura selecionada", 2);
            return;
        }
        SplashMensagem telaEspera = SplashMensagem.getInstancia(this);
        telaEspera.mostrar("Gerando visualiza\u00e7\u00e3o da fatura. Aguarde...");
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        try {
            int codigoConvenio = -1;
            buf.setLength(0);
            buf.append("select con_codigo from fatura where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and fat_codigo = ");
            buf.append(this.txtFatura.getText());
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                codigoConvenio = rs.getInt("con_codigo");
            }
            rs.close();
            if (!Funcoes.textoVazio(this.txtFatura.getText())) {
                if (codigoConvenio > -1) {
                    ImprimirFatura.imprimir(Integer.parseInt(this.txtFatura.getText()), codigoConvenio, agrupar, true);
                    if (ConvenioUtil.isImprimirResumoFatura(Variaveis.filialPadrao, String.valueOf(codigoConvenio))) {
                        ImprimirResumoFatura.imprimir(Integer.parseInt(this.txtFatura.getText()), codigoConvenio);
                    }
                } else {
                    Funcoes.mensagem(this, "Nenhum conv\u00eanio foi encontrado para imprimir a confer\u00eancia", 2);
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConferenciaFatura");
        }
        finally {
            telaEspera.apagar();
        }
        Conexao.fecharStatement(st);
        this.buttonImprimir.setEnabled(true);
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isCarregando = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isCarregando = false;
        this.controlaCampos();
    }
}

