/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.laboratorio.financeiro.faturamento.PagamentoBasico;
import jalis.laboratorio.financeiro.faturamento.RequisicaoBasica;
import java.math.BigDecimal;
import java.util.ArrayList;

public class PagadorBasico {
    private String nomePagador = null;
    private String cpfPagador = null;
    private Integer codigoNotaFiscal = null;
    private BigDecimal valorPago = null;
    private Long numeroNotaFiscal = null;
    private Integer codigoLancamento = null;
    private RequisicaoBasica requisicao = null;
    private ArrayList<PagamentoBasico> pagamentos = null;

    public PagadorBasico(String nomePagador, String cpfPagador, BigDecimal valorPago, PagamentoBasico pgto) {
        this.nomePagador = nomePagador;
        this.cpfPagador = cpfPagador;
        this.valorPago = valorPago;
        this.codigoNotaFiscal = pgto.getCodigoNotaFiscal();
        this.numeroNotaFiscal = pgto.getNumeroNotaFiscal();
        this.codigoLancamento = pgto.getCodigoLancamento();
        if (this.pagamentos == null) {
            this.pagamentos = new ArrayList();
        }
        this.pagamentos.add(pgto);
    }

    public PagadorBasico(PagamentoBasico pgto) {
        if (pgto != null) {
            this.nomePagador = pgto.getNomePagador();
            this.cpfPagador = pgto.getCpfPagador();
            this.valorPago = pgto.getValorPagamento();
            this.codigoNotaFiscal = pgto.getCodigoNotaFiscal();
            this.numeroNotaFiscal = pgto.getNumeroNotaFiscal();
            this.codigoLancamento = pgto.getCodigoLancamento();
            if (this.pagamentos == null) {
                this.pagamentos = new ArrayList();
            }
            this.pagamentos.add(pgto);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof PagadorBasico) {
            PagadorBasico aux = (PagadorBasico)obj;
            if (!(this.codigoNotaFiscal == null || aux == null || aux.getNomePagador() == null || aux.cpfPagador == null || !aux.nomePagador.equalsIgnoreCase(this.nomePagador) || !aux.cpfPagador.equalsIgnoreCase(this.cpfPagador) || this.codigoNotaFiscal == null && aux.codigoNotaFiscal != null || aux.codigoNotaFiscal == null && this.codigoNotaFiscal != null || (aux.codigoNotaFiscal != null || this.codigoNotaFiscal != null) && aux.codigoNotaFiscal.intValue() != this.codigoNotaFiscal.intValue() || this.valorPago == null && aux.valorPago != null || aux.valorPago == null && this.valorPago != null || (aux.valorPago != null || this.valorPago != null) && aux.valorPago.intValue() != this.valorPago.intValue())) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.nomePagador;
    }

    public Integer getCodigoLancamento() {
        return this.codigoLancamento;
    }

    public void setCodigoLancamento(Integer codigoLancamento) {
        this.codigoLancamento = codigoLancamento;
    }

    public String getNomePagador() {
        return this.nomePagador;
    }

    public void setNomePagador(String nomePagador) {
        this.nomePagador = nomePagador;
    }

    public String getCpfPagador() {
        return this.cpfPagador;
    }

    public void setCpfPagador(String cpfPagador) {
        this.cpfPagador = cpfPagador;
    }

    public Integer getCodigoNotaFiscal() {
        return this.codigoNotaFiscal;
    }

    public void setCodigoNotaFiscal(Integer codigoNotaFiscal) {
        this.codigoNotaFiscal = codigoNotaFiscal;
    }

    public BigDecimal getValorPago() {
        return this.valorPago;
    }

    public void setValorPago(BigDecimal valorPago) {
        this.valorPago = valorPago;
    }

    public RequisicaoBasica getRequisicao() {
        return this.requisicao;
    }

    public void setRequisicao(RequisicaoBasica requisicao) {
        this.requisicao = requisicao;
    }

    public ArrayList<PagamentoBasico> getPagamentos() {
        return this.pagamentos;
    }

    public void setPagamentos(ArrayList<PagamentoBasico> pagamentos) {
        this.pagamentos = pagamentos;
    }

    public Long getNumeroNotaFiscal() {
        return this.numeroNotaFiscal;
    }

    public void setNumeroNotaFiscal(Long numeroNotaFiscal) {
        this.numeroNotaFiscal = numeroNotaFiscal;
    }
}

