/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.ServicoBean;
import jalis.model.bean.financeiro.FaturaReceberPagarBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.NotaFiscalServicoBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.FormaPagamentoVO;
import jalis.model.vo.cadastro.financeiro.SeriesVO;
import jalis.model.vo.cadastro.financeiro.ServicoVO;
import jalis.model.vo.financeiro.FaturaVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.financeiro.FormaPagamentoParcelaService;
import jalis.service.cadastro.financeiro.FormaPagamentoService;
import jalis.service.cadastro.financeiro.SeriesService;
import jalis.service.cadastro.financeiro.ServicoService;
import jalis.service.financeiro.FaturaReceberPagarService;
import jalis.service.financeiro.FaturaService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class JanelaPreviaFaturamento
extends AbstractDialogoOKCancelar
implements FocusListener,
KeyListener {
    private final int COLUNA_PARCELA_PARCELA = 0;
    private final int COLUNA_PARCELA_VENCIMENTO = 1;
    private final int COLUNA_PARCELA_VALOR_BRUTO = 2;
    private final int COLUNA_PARCELA_VALOR_LIQUIDO = 3;
    private final int COLUNA_PARCELA_BEAN = 4;
    private JLabel labelFormaPagamento = new JLabel("Forma Pagto.:");
    private JLabel labelDescFormaPagamento = new JLabel();
    private JLabel labelServico = new JLabel("Servi\u00e7o:");
    private JLabel labelDescServico = new JLabel();
    private JLabel labelParcela = new JLabel("Parcela");
    private JLabel labelVencimentoParcela = new JLabel("Vencimento");
    private JLabel labelValorParcela = new JLabel("Valor");
    private TTextField textFormaPagamento = new TTextField(5, 1);
    private TTextField textServico = new TTextField(5, 1);
    private TTextField textParcela = new TTextField(3, 1);
    private TTextField textDataParcela = new TTextField(10, 4);
    private TTextField textValorParcela = new TTextField(10, 2);
    private JButton buttonBuscaFormaPagamento = new JButton();
    private JButton buttonBuscaServico = new JButton();
    private JButton buttonOKDados = ComponenteFactory.novoJButton("OK", this);
    private JButton buttonBuscaDataParcela = ComponenteFactory.novoJButton(this, true);
    private ModeloGridTable modeloParcelas = new ModeloGridTable(new String[]{"Parc.", "Vencimento", "Bruto", "L\u00edquido"});
    private JTable tableParcelas = new JTable(this.modeloParcelas);
    private JScrollPane scrollParcelas = new JScrollPane(this.tableParcelas);
    private JPanel panelDados = new JPanel(new GridBagLayout());
    private JPanel panelParcelas = new JPanel(new BorderLayout());
    private FormaPagamentoVO formaPagamentoVO = null;
    private ConvenioVO convenioVO = null;
    private SeriesVO serieVO = null;
    private ServicoBean servicoBean = null;
    private Integer codigoFatura = null;
    private Integer codigoConvenio = null;
    private Double valorFatura = null;

    public static JanelaPreviaFaturamento getInstancia(Window pai, Integer codigoFatura, Integer codigoConvenio, Double valorFatura) {
        if (pai instanceof Frame) {
            return new JanelaPreviaFaturamento((Frame)pai, "Gerando pr\u00e9vias do faturamento", codigoFatura, codigoConvenio, valorFatura);
        }
        if (pai instanceof Dialog) {
            return new JanelaPreviaFaturamento((Dialog)pai, "Gerando pr\u00e9vias do faturamento", codigoFatura, codigoConvenio, valorFatura);
        }
        return null;
    }

    private JanelaPreviaFaturamento(Frame pai, String titulo, Integer codigoFatura, Integer codigoConvenio, Double valorFatura) {
        super(pai, titulo);
        this.codigoFatura = codigoFatura;
        this.codigoConvenio = codigoConvenio;
        this.valorFatura = valorFatura;
        this.montaTela();
    }

    private JanelaPreviaFaturamento(Dialog pai, String titulo, Integer codigoFatura, Integer codigoConvenio, Double valorFatura) {
        super(pai, titulo);
        this.codigoFatura = codigoFatura;
        this.codigoConvenio = codigoConvenio;
        this.valorFatura = valorFatura;
        this.montaTela();
    }

    private void montaTela() {
        this.montaPanelDados();
        this.montaPanelParcelas();
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)this.panelDados, "North");
        this.getPanelCentral().add((Component)this.panelParcelas, "Center");
        this.montaListeners();
        this.getBotaoCancelar().setVisible(false);
        this.getBotaoOK().setText("Salvar");
        this.getBotaoOK().setMnemonic('S');
        this.setSize(500, 300);
        ScreenUtil.requisitarFoco(this.textFormaPagamento);
        this.setUsuarioPodeCancelar(false);
        ((JComponent)this.getContentPane()).getActionMap().remove("escape");
        this.setLocationRelativeTo(this.getParent());
    }

    private void montaListeners() {
        this.textFormaPagamento.addFocusListener(this);
        this.textFormaPagamento.addKeyListener(this);
        this.textServico.addFocusListener(this);
        this.textServico.addKeyListener(this);
        this.buttonBuscaFormaPagamento.addActionListener(this);
        this.buttonBuscaServico.addActionListener(this);
        this.buttonOKDados.addActionListener(this);
        this.buttonBuscaDataParcela.addActionListener(this);
    }

    private void montaPanelParcelas() {
        this.panelParcelas.setBorder(new TitledBorder("Parcelas"));
        this.panelParcelas.add((Component)this.montaPanelEdicaoParcela(), "North");
        this.panelParcelas.add((Component)this.scrollParcelas, "Center");
        this.modeloParcelas.setColumnSize(new int[]{40, 90, 0, 0}, this.tableParcelas);
    }

    private void montaPanelDados() {
        ScreenUtil.setBorda(new JComponent[]{this.labelDescFormaPagamento, this.labelDescServico}, new TitledBorder(""));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelFormaPagamento.setDisplayedMnemonic('F');
        this.labelFormaPagamento.setLabelFor(this.textFormaPagamento);
        this.panelDados.add((Component)this.labelFormaPagamento, c);
        ++c.gridx;
        this.textFormaPagamento.setPreferredSize(new Dimension(70, 20));
        this.textFormaPagamento.setMinimumSize(new Dimension(70, 20));
        this.panelDados.add((Component)this.textFormaPagamento, c);
        ++c.gridx;
        this.buttonBuscaFormaPagamento.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaFormaPagamento.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonBuscaFormaPagamento);
        this.buttonBuscaFormaPagamento.setFocusable(false);
        this.panelDados.add((Component)this.buttonBuscaFormaPagamento, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.fill = 2;
        c.insets = new Insets(1, 1, 0, 1);
        this.labelDescFormaPagamento.setPreferredSize(new Dimension(20, 20));
        this.labelDescFormaPagamento.setMinimumSize(new Dimension(20, 20));
        this.panelDados.add((Component)this.labelDescFormaPagamento, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 0, 0);
        c.fill = 0;
        this.labelServico.setDisplayedMnemonic('e');
        this.labelServico.setLabelFor(this.textServico);
        this.panelDados.add((Component)this.labelServico, c);
        ++c.gridx;
        this.textServico.setPreferredSize(new Dimension(70, 20));
        this.textServico.setMinimumSize(new Dimension(70, 20));
        this.panelDados.add((Component)this.textServico, c);
        ++c.gridx;
        this.buttonBuscaServico.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaServico.setMinimumSize(new Dimension(20, 20));
        Funcoes.imagemPesquisa(this.buttonBuscaServico);
        this.buttonBuscaServico.setFocusable(false);
        this.panelDados.add((Component)this.buttonBuscaServico, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelDescServico.setPreferredSize(new Dimension(20, 20));
        this.labelDescServico.setMinimumSize(new Dimension(20, 20));
        this.panelDados.add((Component)this.labelDescServico, c);
    }

    private JPanel montaPanelEdicaoParcela() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel topo = new JPanel(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 17;
        g.gridx = 0;
        g.gridy = 0;
        this.labelParcela.setDisplayedMnemonic('l');
        this.labelParcela.setLabelFor(this.textParcela);
        topo.add((Component)this.labelParcela, g);
        g.gridx = 1;
        this.labelVencimentoParcela.setDisplayedMnemonic('n');
        this.labelVencimentoParcela.setLabelFor(this.textDataParcela);
        topo.add((Component)this.labelVencimentoParcela, g);
        g.gridx = 3;
        topo.add((Component)this.labelValorParcela, g);
        g.gridy = 1;
        g.gridx = 0;
        this.textParcela.setPreferredSize(new Dimension(50, 20));
        topo.add((Component)this.textParcela, g);
        g.gridx = 1;
        this.textDataParcela.setPreferredSize(new Dimension(85, 20));
        topo.add((Component)this.textDataParcela, g);
        g.gridx = 2;
        this.buttonBuscaDataParcela.setPreferredSize(new Dimension(20, 20));
        topo.add((Component)this.buttonBuscaDataParcela, g);
        g.gridx = 3;
        this.textValorParcela.setPreferredSize(new Dimension(80, 20));
        topo.add((Component)this.textValorParcela, g);
        g.gridx = 4;
        this.buttonOKDados.setPreferredSize(new Dimension(50, 20));
        this.buttonOKDados.setMnemonic('O');
        topo.add((Component)this.buttonOKDados, g);
        g.weightx = 1.0;
        topo.add((Component)new JLabel(), g);
        panel.add((Component)topo, "North");
        this.textDataParcela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(JanelaPreviaFaturamento.this.textDataParcela, JanelaPreviaFaturamento.this.buttonBuscaDataParcela, (JPanel)JanelaPreviaFaturamento.this.textDataParcela.getParent(), true);
                }
            }
        });
        this.tableParcelas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JanelaPreviaFaturamento.this.editarParcelas(JanelaPreviaFaturamento.this.tableParcelas.getSelectedRow());
                        }
                    });
                }
            }
        });
        this.tableParcelas.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && JanelaPreviaFaturamento.this.tableParcelas.getSelectedRow() > -1) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JanelaPreviaFaturamento.this.editarParcelas(JanelaPreviaFaturamento.this.tableParcelas.getSelectedRow());
                        }
                    });
                }
            }
        });
        return panel;
    }

    private void editarParcelas(int linha) {
        if (linha > -1 && linha < this.modeloParcelas.getRowCount()) {
            ReceberPagarBean b = (ReceberPagarBean)this.modeloParcelas.getValueAt(linha, 4);
            this.textParcela.setText(String.valueOf(b.getParcela()));
            this.textDataParcela.setText(Funcoes.formataData(b.getDataVencimento()));
            this.textValorParcela.setText(Funcoes.formataDecimal(b.getValorTotal()));
            this.textParcela.setEnabled(false);
            ScreenUtil.requisitarFoco(this.textDataParcela);
        }
    }

    @Override
    @Deprecated
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaFormaPagamento) {
            this.pesquisaFormaPagamento();
        } else if (e.getSource() == this.buttonBuscaServico) {
            this.pesquisaServico();
        } else if (e.getSource() == this.buttonOKDados) {
            if (!Funcoes.textoVazio(this.textParcela.getText()) && Funcoes.isNumeric(this.textParcela.getText()) && !Funcoes.textoVazio(this.textValorParcela.getText()) && Funcoes.isNumeric(this.textValorParcela.getText()) && Funcoes.verificaData(this.textDataParcela.getText())) {
                this.recalculaParcelaEdicao();
            } else if (this.modeloParcelas.getRowCount() == 0) {
                this.geraParcelas(true);
            }
        } else if (e.getSource() == this.getBotaoOK()) {
            this.ok = this.salvarParcelas(true);
            if (this.ok) {
                this.setVisible(false);
            }
        } else if (e.getSource() == this.buttonBuscaDataParcela) {
            Funcoes.mostraData(this.textDataParcela, this.buttonBuscaDataParcela, (JPanel)this.textDataParcela.getParent(), true);
        }
    }

    private boolean salvarParcelas(boolean mostrarMensagemErro) {
        if (this.modeloParcelas.getRowCount() == 0 && !this.geraParcelas(mostrarMensagemErro)) {
            return false;
        }
        FaturaVO faturaVO = null;
        try {
            faturaVO = (FaturaVO)new FaturaService().getVO(Variaveis.filialPadrao, this.codigoFatura.toString());
        }
        catch (Exception e2) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados da fatura.\n" + e2.getMessage(), e2.getStackTrace());
            return false;
        }
        SeriesVO serieVO = null;
        try {
            serieVO = (SeriesVO)new SeriesService().getVO(Variaveis.filialPadrao, ParametrosLocais.getParametro("serie"));
            if (serieVO == null) {
                ErrorLogger.mostraMensagem(this, "A s\u00e9rie padr\u00e3o n\u00e3o est\u00e1 configurada para a esta\u00e7\u00e3o.", null);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar a s\u00e9rie padr\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
        ReceberPagarService recPagService = new ReceberPagarService();
        FaturaReceberPagarService faturaRecPagService = new FaturaReceberPagarService();
        for (int i = 0; i < this.modeloParcelas.getRowCount(); ++i) {
            ReceberPagarBean tituloAux = (ReceberPagarBean)this.modeloParcelas.getValueAt(i, 4);
            if (tituloAux == null) continue;
            try {
                recPagService.gravaAutoCopiaSemCommit(tituloAux, 0, Variaveis.filialPadrao, null);
                FaturaReceberPagarBean fatRecPagBean = new FaturaReceberPagarBean();
                fatRecPagBean.setFilial(tituloAux.getFilial());
                fatRecPagBean.setReceberPagar((ReceberPagarVO)tituloAux.toVO());
                fatRecPagBean.setFatura(faturaVO);
                fatRecPagBean.setTipo("F");
                faturaRecPagService.insert(fatRecPagBean, null, Variaveis.filialPadrao, null);
                continue;
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar os t\u00edtulos de pr\u00e9via.\n" + e.getMessage(), e.getStackTrace());
                return false;
            }
        }
        try {
            Conexao.arquivaSQL();
            return true;
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gravar os dados.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
    }

    private boolean validaDados(boolean mostrarMensagemErro) {
        if (this.formaPagamentoVO == null) {
            if (mostrarMensagemErro) {
                Funcoes.mensagem(this.getPanelCentral().getTopLevelAncestor(), "A forma de pagamento deve ser informada.", 2);
                ScreenUtil.requisitarFoco(this.textFormaPagamento);
            }
            return false;
        }
        if (this.servicoBean == null) {
            if (mostrarMensagemErro) {
                Funcoes.mensagem(this.getPanelCentral().getTopLevelAncestor(), "O servi\u00e7o deve ser informado.", 2);
                ScreenUtil.requisitarFoco(this.textServico);
            }
            return false;
        }
        return true;
    }

    @Override
    public void focusLost(FocusEvent e) {
        int pos;
        if (e.getSource() == this.textFormaPagamento) {
            this.buscaFormaPagamento(this.textFormaPagamento.getText());
        } else if (e.getSource() == this.textServico) {
            this.buscaServico(this.textServico.getText());
            try {
                if (!Funcoes.textoVazio(this.textServico)) {
                    this.geraParcelas(true);
                }
            }
            catch (Exception e1) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar parcelas." + e1.getMessage(), e1.getStackTrace());
            }
        } else if (e.getSource() == this.textParcela && Funcoes.isNumeric(this.textParcela.getText()) && (pos = this.modeloParcelas.localizar(0, this.textParcela.getText())) > -1) {
            this.editarParcelas(pos);
        }
    }

    public boolean geraParcelas(boolean mostrarMensagemErro) {
        if (!this.validaDados(mostrarMensagemErro)) {
            return false;
        }
        Set listaFormaParcelas = null;
        try {
            listaFormaParcelas = new FormaPagamentoParcelaService().load(" where fil_codigo = " + this.formaPagamentoVO.getFilial().getCodigo() + " and fpg_codigo = " + this.formaPagamentoVO.getCodigo());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar as parcelas da forma da pagamento.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
        FilialVO filialVO = new FilialVO();
        filialVO.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO usuarioVO = new UsuarioVO();
        usuarioVO.setFilial(filialVO);
        usuarioVO.setCodigo(Variaveis.login);
        NotaFiscalBean nota = this.geraBeanNota();
        try {
            ArrayList<ReceberPagarBean> parcelas = FinanceiroUtil.gerarParcelas(nota.getSubTotal(), nota.getValor(), nota.getIssValor(), 0.0, 0.0, 0.0, 0.0, 0.0, nota.getValorISSRetido(), nota.getValorInssRetido(), nota.getValorCofinsRetido(), nota.getValorCsllRetido(), nota.getValorIrrfRetido(), nota.getValorPisRetido(), 0.0, nota.getDataEmissao(), "R", listaFormaParcelas);
            for (ReceberPagarBean tituloAux : parcelas) {
                tituloAux.setFilial(filialVO);
                tituloAux.setOrigem("F");
                tituloAux.setSituacao("F");
                tituloAux.setSerie(this.serieVO);
                tituloAux.setUsuario(usuarioVO);
                tituloAux.setTipoDocumento("D");
                tituloAux.setTipoCadastro("O");
                tituloAux.setNumeroDocumento(this.codigoFatura.toString());
                tituloAux.setConvenio(this.convenioVO);
                tituloAux.setDataHora(new Date());
                PanelPlanoContaCentroCusto panelPlanoCentro = new PanelPlanoContaCentroCusto(tituloAux, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, tituloAux.getFilial().getCodigo().toString());
                panelPlanoCentro.setTipoDebitoCredito("C");
                tituloAux = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes((AbstractThreadBean)tituloAux, panelPlanoCentro, 2, this.convenioVO);
            }
            this.adicionaParcelasGrid(parcelas);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel gerar os t\u00edtulos de pr\u00e9via.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
        return true;
    }

    private void recalculaParcelaEdicao() {
        boolean recalculaValores = false;
        int parcela = Integer.parseInt(this.textParcela.getText());
        BigDecimal novoValor = new BigDecimal(this.textValorParcela.getText());
        novoValor = novoValor.setScale(2, RoundingMode.HALF_UP);
        ReceberPagarBean aux2 = null;
        ArrayList<ReceberPagarBean> arrayRecPag = new ArrayList<ReceberPagarBean>();
        BigDecimal diferencaValores = null;
        for (int i = 0; i < this.modeloParcelas.getRowCount(); ++i) {
            arrayRecPag.add((ReceberPagarBean)this.modeloParcelas.getValueAt(i, 4));
        }
        for (ReceberPagarBean aux2 : arrayRecPag) {
            if (aux2.getParcela() != parcela) continue;
            diferencaValores = BigDecimal.valueOf(aux2.getValorTotal()).subtract(novoValor);
            diferencaValores = diferencaValores.setScale(2, RoundingMode.HALF_UP);
            PanelPlanoContaCentroCusto panelPlanoCentro = new PanelPlanoContaCentroCusto(aux2, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, aux2.getFilial().getCodigo().toString());
            panelPlanoCentro.setTipoDebitoCredito("C");
            BigDecimal auxValorPlano = BigDecimal.valueOf(aux2.getValor());
            auxValorPlano = auxValorPlano.subtract(diferencaValores);
            auxValorPlano = auxValorPlano.setScale(2, RoundingMode.HALF_UP);
            aux2.setValor(auxValorPlano.doubleValue());
            aux2 = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes((AbstractThreadBean)aux2, panelPlanoCentro, 2, this.convenioVO);
            if (aux2.getValorTotal().doubleValue() != novoValor.doubleValue()) {
                recalculaValores = true;
            }
            aux2.setValorTotal(novoValor.doubleValue());
            aux2.setDataVencimento(Funcoes.stringToDate(this.textDataParcela.getText()));
            break;
        }
        if (this.modeloParcelas.getRowCount() - 1 > 0 && recalculaValores) {
            Object[] mensagens = new String[]{"Todas", "Subsequentes"};
            int opcao = JOptionPane.showOptionDialog(this, "Deseja ratear a diferen\u00e7a sobre todas as outras parcelas ou sobre as parcelas subsequentes?", "Ratear diferen\u00e7a", 0, 2, null, mensagens, mensagens[0]);
            BigDecimal divDiferencaValores = null;
            if (opcao == 0) {
                if (diferencaValores != null) {
                    divDiferencaValores = diferencaValores.divide(BigDecimal.valueOf(this.modeloParcelas.getRowCount() - 1), RoundingMode.HALF_UP);
                    diferencaValores = diferencaValores.subtract(divDiferencaValores.multiply(BigDecimal.valueOf(this.modeloParcelas.getRowCount() - 1)));
                }
            } else if (diferencaValores != null) {
                divDiferencaValores = diferencaValores.divide(BigDecimal.valueOf(this.modeloParcelas.getRowCount() - parcela), RoundingMode.HALF_UP);
                diferencaValores = diferencaValores.subtract(divDiferencaValores.multiply(BigDecimal.valueOf(this.modeloParcelas.getRowCount() - parcela)));
            }
            if (divDiferencaValores != null) {
                divDiferencaValores = divDiferencaValores.setScale(2, RoundingMode.HALF_UP);
            }
            if (diferencaValores != null) {
                diferencaValores = diferencaValores.setScale(2, RoundingMode.HALF_UP);
            }
            Iterator<Object> it = arrayRecPag.iterator();
            boolean addDif = true;
            while (it.hasNext()) {
                aux2 = (ReceberPagarBean)it.next();
                if ((opcao != 0 || aux2.getParcela() == parcela) && (opcao != 1 || aux2.getParcela() <= parcela)) continue;
                PanelPlanoContaCentroCusto panelPlanoCentro = new PanelPlanoContaCentroCusto(aux2, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, aux2.getFilial().getCodigo().toString());
                panelPlanoCentro.setTipoDebitoCredito("C");
                BigDecimal auxValorPlano = BigDecimal.valueOf(aux2.getValor());
                auxValorPlano = !addDif ? auxValorPlano.add(divDiferencaValores) : auxValorPlano.add(divDiferencaValores).add(diferencaValores);
                auxValorPlano = auxValorPlano.setScale(2, RoundingMode.HALF_UP);
                BigDecimal auxValorTotal = BigDecimal.valueOf(aux2.getValorTotal());
                auxValorTotal = !addDif ? auxValorTotal.add(divDiferencaValores) : auxValorTotal.add(divDiferencaValores).add(diferencaValores);
                auxValorTotal = auxValorTotal.setScale(2, RoundingMode.HALF_UP);
                aux2.setValor(auxValorPlano.doubleValue());
                aux2.setValor(auxValorPlano.doubleValue());
                aux2.setValorTotal(auxValorTotal.doubleValue());
                aux2 = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes((AbstractThreadBean)aux2, panelPlanoCentro, 2, this.convenioVO);
                if (!addDif) continue;
                addDif = false;
            }
        }
        this.textParcela.clear();
        this.textDataParcela.clear();
        this.textValorParcela.clear();
        this.textParcela.setEnabled(true);
        this.textValorParcela.setEnabled(true);
        if (!this.textParcela.isEnabled()) {
            this.textParcela.setEnabled(true);
        }
        this.adicionaParcelasGrid(arrayRecPag);
    }

    private void adicionaParcelasGrid(ArrayList<ReceberPagarBean> parcelas) {
        this.modeloParcelas.clear();
        for (ReceberPagarBean r : parcelas) {
            this.modeloParcelas.addLine(new Object[]{String.valueOf(r.getParcela()), Funcoes.formataData(r.getDataVencimento()), Funcoes.formataDecimal(r.getValor()), Funcoes.formataDecimal(r.getValorTotal()), r});
        }
        this.modeloParcelas.ordenarColuna(0, 1);
    }

    private NotaFiscalBean geraBeanNota() {
        NotaFiscalBean bean = new NotaFiscalBean();
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        UsuarioVO usuario = new UsuarioVO();
        usuario.setCodigo(Variaveis.login);
        try {
            this.serieVO = (SeriesVO)new SeriesService().getVO(Variaveis.filialPadrao, ParametrosLocais.getParametro("serie"));
            if (this.serieVO == null) {
                ErrorLogger.mostraMensagem(this, "A s\u00e9rie padr\u00e3o n\u00e3o est\u00e1 configurada para a esta\u00e7\u00e3o.", null);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar a s\u00e9rie padr\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
        try {
            this.convenioVO = (ConvenioVO)new ConvenioService().getVO(Variaveis.filialPadrao, this.codigoConvenio.toString());
            if (this.serieVO == null) {
                ErrorLogger.mostraMensagem(this, "A s\u00e9rie padr\u00e3o n\u00e3o est\u00e1 configurada para a esta\u00e7\u00e3o.", null);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar a s\u00e9rie padr\u00e3o.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
        NotaFiscalServicoBean notaServico = new NotaFiscalServicoBean();
        notaServico.setFilial(filial);
        notaServico.setNotaFiscal((NotaFiscalVO)bean.toVO());
        notaServico.setServico((ServicoVO)this.servicoBean.toVO());
        notaServico.setValor(bean.getSubTotal());
        notaServico.setNaturezaOperacao(this.servicoBean.getNaturezaOperacao());
        notaServico.setTipoTributacao(this.servicoBean.getTipoTributacao());
        notaServico.setTributacaoMunicipal(this.servicoBean.getCodigoTributacaoMunicipio());
        bean.setFilial(filial);
        bean.setUsuario(usuario);
        bean.setSerie(this.serieVO);
        bean.setFormaPagamento(this.formaPagamentoVO);
        bean.setDataHora(new Date());
        bean.setDataEmissao(new Date());
        bean.setTipo("S");
        bean.setNumero(new Long(this.codigoFatura.intValue()));
        bean.setSubTotal(this.valorFatura);
        bean.setSituacao("A");
        bean.setTipoCadastro("O");
        bean.setConvenio(this.convenioVO);
        bean.setServico(notaServico);
        bean.setImpostoAcumulado(0.0);
        new NotaFiscalService().pegaValorImpostos(bean, true);
        return bean;
    }

    private void pesquisaFormaPagamento() {
        try {
            this.textFormaPagamento.setText("");
            this.labelDescFormaPagamento.setText("");
            this.formaPagamentoVO = (FormaPagamentoVO)new FormaPagamentoService().pesquisaVO(this.getPanelCentral().getTopLevelAncestor(), new FormaPagamentoVO(), "Pesquisando formas de pagamento", true);
            if (this.formaPagamentoVO != null) {
                this.textFormaPagamento.setText(String.valueOf(this.formaPagamentoVO.getCodigo()));
                this.labelDescFormaPagamento.setText(this.formaPagamentoVO.getDescricao());
            } else {
                this.labelDescFormaPagamento.setText("N\u00e3o cadastrado");
            }
            ScreenUtil.requisitarFoco(this.textFormaPagamento);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar as formas de pagamento.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void pesquisaServico() {
        try {
            this.textServico.setText("");
            this.labelDescServico.setText("");
            ServicoService serviceServico = new ServicoService();
            ServicoVO servicoVO = (ServicoVO)serviceServico.pesquisaVO(this.getPanelCentral().getTopLevelAncestor(), new ServicoVO(), "Pesquisando servi\u00e7os", true);
            if (servicoVO != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", servicoVO.getFilial().getCodigo());
                chaves.put("svc_codigo", servicoVO.getCodigo());
                this.servicoBean = (ServicoBean)serviceServico.getBean(chaves);
                if (this.servicoBean != null) {
                    this.textServico.setText(String.valueOf(this.servicoBean.getCodigo()));
                    this.labelDescServico.setText(this.servicoBean.getDescricao());
                } else {
                    this.labelDescServico.setText("N\u00e3o cadastrado");
                }
            } else {
                this.labelDescServico.setText("N\u00e3o cadastrado");
            }
            ScreenUtil.requisitarFoco(this.textServico);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os servi\u00e7os.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void buscaFormaPagamento(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textFormaPagamento.setText("");
            this.labelDescFormaPagamento.setText("");
            return;
        }
        try {
            this.formaPagamentoVO = (FormaPagamentoVO)new FormaPagamentoService().getVO(Variaveis.filialPadrao, codigo);
            if (this.formaPagamentoVO != null) {
                this.setFormaPagamento(this.formaPagamentoVO);
            } else {
                this.labelDescFormaPagamento.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar a forma de pagamento.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void buscaServico(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textServico.setText("");
            this.labelDescServico.setText("");
            return;
        }
        try {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", Variaveis.filialPadrao);
            chaves.put("svc_codigo", codigo);
            this.servicoBean = (ServicoBean)new ServicoService().getBean(chaves);
            if (this.servicoBean != null) {
                this.setServico(this.servicoBean);
            } else {
                this.labelDescServico.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar o servi\u00e7o.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    @Deprecated
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 113) {
            if (e.getSource() == this.textFormaPagamento) {
                this.pesquisaFormaPagamento();
            } else if (e.getSource() == this.textServico) {
                this.pesquisaServico();
            }
        }
    }

    @Override
    @Deprecated
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public JPanel getPanelCentral() {
        return super.getPanelCentral();
    }

    public void setListaPrevias(ArrayList<ReceberPagarBean> arrayList) {
        this.adicionaParcelasGrid(arrayList);
    }

    public ArrayList<ReceberPagarBean> getListaPrevias() {
        ArrayList<ReceberPagarBean> lista = new ArrayList<ReceberPagarBean>();
        for (int i = 0; i < this.modeloParcelas.getRowCount(); ++i) {
            lista.add((ReceberPagarBean)this.modeloParcelas.getValueAt(i, 4));
        }
        if (lista.size() > 0) {
            return lista;
        }
        return null;
    }

    public FormaPagamentoVO getFormaPagamento() {
        return this.formaPagamentoVO;
    }

    public void setFormaPagamento(FormaPagamentoVO formaPagamento) {
        this.formaPagamentoVO = formaPagamento;
        this.textFormaPagamento.setText(String.valueOf(formaPagamento.getCodigo()));
        this.labelDescFormaPagamento.setText(formaPagamento.getDescricao());
    }

    public void setServico(ServicoBean servico) {
        this.servicoBean = servico;
        this.textServico.setText(String.valueOf(servico.getCodigo()));
        this.labelDescServico.setText(servico.getDescricao());
    }

    public ServicoBean getServico() {
        return this.servicoBean;
    }
}

