/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.DialogNotaFiscalSaida;
import jalis.laboratorio.financeiro.NotaFiscalSaida;
import jalis.laboratorio.financeiro.faturamento.ExameBasico;
import jalis.laboratorio.financeiro.faturamento.ImprimirNotaFiscal;
import jalis.laboratorio.financeiro.faturamento.PagadorBasico;
import jalis.laboratorio.financeiro.faturamento.PagamentoBasico;
import jalis.laboratorio.financeiro.faturamento.RequisicaoBasica;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.recepcao.RequisicaoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.EstacaoVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.financeiro.ContaCorrenteVO;
import jalis.service.cadastro.PacienteService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.DBUtil;
import jalis.util.FocusTraversalOnArray;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.ValidaDoc;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImprimirNotaFiscalPessoaFisica
extends FrmCadPadrao
implements ThreadFinalizadaListener {
    private static final int COLUNA_PGTO_DATA = 0;
    private static final int COLUNA_PGTO_TIPO = 1;
    private static final int COLUNA_PGTO_DESCRICAO = 2;
    private static final int COLUNA_PGTO_USUARIO = 3;
    private static final int COLUNA_PGTO_VALOR = 4;
    private static final int COLUNA_PGTO_NOTA = 5;
    private static final int COLUNA_PGTO_OBJETO = 6;
    private final TTextField textPesquisa = new TTextField(14, 8);
    private JTable tableRequisicoes;
    private JTable tableExames;
    private JTable tablePagamentos;
    private JTable tablePagadores;
    private Border titled = BorderFactory.createTitledBorder("");
    private TTextField textFilial = new TTextField(8, 1);
    private JButton buttonBuscaFilial = ComponenteFactory.novoJButton(null, new Dimension(20, 20), new Dimension(20, 20), true);
    private JLabel labelFilial = ComponenteFactory.novoJLabel("Filial:", 'f', null, this.textFilial);
    private JLabel labelValorFilial = ComponenteFactory.novoJLabel("", new Dimension(100, 20), this.titled);
    protected JButton buttonEditarPagador = new JButton("Editar Pagador");
    protected JPanel panelPesquisa = new JPanel();
    protected JComboBox comboTipoPesquisa = new JComboBox<Object>(new Object[]{TipoPesquisa.PAGADOR, TipoPesquisa.PACIENTE, TipoPesquisa.REQUISICAO});
    private final JButton buttonPesquisa = new JButton("");
    private final JLabel labelPesquisa = new JLabel("");
    private final JButton buttonCarregar = new JButton("Carregar");
    private final JPanel panelDados = new JPanel();
    private final JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    protected JLabel labelVlrPaciente = new JLabel("");
    protected JLabel labelVlrRequisicao = new JLabel("");
    private final JLabel labelData = new JLabel("Data:");
    private final JLabel labelPaciente = new JLabel("Paciente:");
    protected JLabel labelVlrData = new JLabel("");
    private final JLabel labelMedico = new JLabel("M\u00e9dico:");
    protected JLabel labelVlrMedico = new JLabel("");
    private final JPanel panelExames = new JPanel();
    private final JPanel panelPagamentos = new JPanel();
    private final JPanel panelPagador = new JPanel();
    protected JLabel labelDevedor = new JLabel("Devedor:");
    protected JLabel labelVlrDevedor = new JLabel("");
    private final JLabel labelTotal = new JLabel("Total:");
    protected JLabel labelVlrTotal = new JLabel("");
    protected JPanel panelRequisicoes = new JPanel();
    private Timer timer = null;
    private final int casas = ParametrosGerais.getCasasPrecoExame();
    private final RoundingMode round = ParametrosGerais.getArredondamentoPrecoExame();
    private final ArrayList<RequisicaoBasica> requisicoes = new ArrayList();
    private String codigoPesquisa = "";
    private boolean isCarregandoDados = false;
    private boolean dadosCarregados = false;
    private static final Long ACESSO_ACESSAR = Long.parseLong("0600201300");
    private static final Long ACESSO_MODIFICAR_NUMERO_NOTA_FISCAL = Long.parseLong("0600201301");
    private static final Long ACESSO_EDITAR_PAGADOR = Long.parseLong("0600201302");
    private static final Long ACESSO_SALVAR_SEM_INFORMAR_PAGADOR = Long.parseLong("0600201303");
    private static final Long NAO_PERMITIR_ALTERAR_SERIE_NOTA = Long.parseLong("0600201304");
    private static final int TEMPO_TIMER = 30000;

    public ImprimirNotaFiscalPessoaFisica() {
        Funcoes.criaBarraDescricao(this, "Imprimir Notas Fiscais de Pessoa F\u00edsica", "Imprime a nota fiscal para pessoas f\u00edsicas", "financeiro/nota_fiscal_fisica.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelPesquisa, this.panelDados, this.labelVlrPaciente, this.labelVlrRequisicao, this.labelVlrData, this.labelVlrMedico, this.labelVlrDevedor, this.labelVlrTotal}, new TitledBorder(""));
        this.botaoEditar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.botaoSalvar.setText("Visualizar Nota Fiscal");
        this.botaoSalvar.setMnemonic('V');
        Funcoes.imagemPesquisa(this.buttonPesquisa);
        this.painelCentral.setLayout(new BorderLayout());
        this.painelCentral.add((Component)this.panelPesquisa, "North");
        GridBagLayout gbl_panelPesquisa = new GridBagLayout();
        this.panelPesquisa.setLayout(gbl_panelPesquisa);
        this.comboTipoPesquisa.setPreferredSize(new Dimension(100, 20));
        this.comboTipoPesquisa.setMinimumSize(new Dimension(100, 20));
        GridBagConstraints gbc_labelPagador = new GridBagConstraints();
        gbc_labelPagador.anchor = 17;
        gbc_labelPagador.insets = new Insets(0, 0, 5, 0);
        gbc_labelPagador.gridx = 0;
        gbc_labelPagador.gridy = 0;
        this.panelPesquisa.add((Component)this.labelFilial, gbc_labelPagador);
        this.textFilial.setPreferredSize(new Dimension(90, 20));
        this.textFilial.setMinimumSize(new Dimension(90, 20));
        ScreenUtil.requisitarFoco(this.textFilial);
        ++gbc_labelPagador.gridx;
        this.panelPesquisa.add((Component)this.textFilial, gbc_labelPagador);
        ++gbc_labelPagador.gridx;
        this.panelPesquisa.add((Component)this.buttonBuscaFilial, gbc_labelPagador);
        ++gbc_labelPagador.gridx;
        gbc_labelPagador.gridwidth = 5;
        gbc_labelPagador.fill = 2;
        this.labelValorFilial.setPreferredSize(new Dimension(90, 20));
        this.labelValorFilial.setMinimumSize(new Dimension(90, 20));
        this.panelPesquisa.add((Component)this.labelValorFilial, gbc_labelPagador);
        gbc_labelPagador.gridx = 0;
        gbc_labelPagador.gridy = 1;
        gbc_labelPagador.gridwidth = 3;
        this.comboTipoPesquisa.setPreferredSize(new Dimension(130, 20));
        this.comboTipoPesquisa.setMinimumSize(new Dimension(130, 20));
        this.panelPesquisa.add((Component)this.comboTipoPesquisa, gbc_labelPagador);
        this.textPesquisa.setPreferredSize(new Dimension(100, 20));
        this.textPesquisa.setMinimumSize(new Dimension(100, 20));
        GridBagConstraints gbc_textPagador = new GridBagConstraints();
        gbc_textPagador.anchor = 17;
        gbc_textPagador.insets = new Insets(0, 0, 5, 0);
        gbc_textPagador.gridx = 4;
        gbc_textPagador.gridy = 1;
        gbc_textPagador.fill = 0;
        this.panelPesquisa.add((Component)this.textPesquisa, gbc_textPagador);
        this.textPesquisa.setColumns(10);
        this.buttonPesquisa.setFocusable(false);
        this.buttonPesquisa.setPreferredSize(new Dimension(20, 20));
        this.buttonPesquisa.setMinimumSize(new Dimension(20, 20));
        GridBagConstraints gbc_buttonPesquisa = new GridBagConstraints();
        gbc_buttonPesquisa.anchor = 17;
        gbc_buttonPesquisa.insets = new Insets(0, 0, 5, 0);
        gbc_buttonPesquisa.gridx = 5;
        gbc_buttonPesquisa.gridy = 1;
        this.panelPesquisa.add((Component)this.buttonPesquisa, gbc_buttonPesquisa);
        this.labelPesquisa.setPreferredSize(new Dimension(20, 20));
        this.labelPesquisa.setMinimumSize(new Dimension(20, 20));
        GridBagConstraints gbc_labelNomePagador = new GridBagConstraints();
        gbc_labelNomePagador.weightx = 1.0;
        gbc_labelNomePagador.fill = 2;
        gbc_labelNomePagador.anchor = 17;
        gbc_labelNomePagador.insets = new Insets(0, 0, 5, 0);
        gbc_labelNomePagador.gridx = 6;
        gbc_labelNomePagador.gridy = 1;
        this.panelPesquisa.add((Component)this.labelPesquisa, gbc_labelNomePagador);
        this.buttonCarregar.setMnemonic('a');
        this.buttonCarregar.setMargin(new Insets(1, 1, 1, 1));
        this.buttonCarregar.setPreferredSize(new Dimension(80, 20));
        this.buttonCarregar.setMinimumSize(new Dimension(80, 20));
        GridBagConstraints gbc_buttonCarregar = new GridBagConstraints();
        gbc_buttonCarregar.insets = new Insets(0, 0, 5, 0);
        gbc_buttonCarregar.anchor = 17;
        gbc_buttonCarregar.gridx = 7;
        gbc_buttonCarregar.gridy = 1;
        this.panelPesquisa.add((Component)this.buttonCarregar, gbc_buttonCarregar);
        this.painelCentral.add((Component)this.panelDados, "Center");
        GridBagLayout gbl_panelDados = new GridBagLayout();
        this.panelDados.setLayout(gbl_panelDados);
        GridBagConstraints gbc_labelRequisicao = new GridBagConstraints();
        gbc_labelRequisicao.insets = new Insets(0, 0, 0, 0);
        gbc_labelRequisicao.anchor = 17;
        gbc_labelRequisicao.gridx = 0;
        gbc_labelRequisicao.gridy = 0;
        this.panelDados.add((Component)this.labelRequisicao, gbc_labelRequisicao);
        this.labelVlrPaciente.setMinimumSize(new Dimension(20, 20));
        this.labelVlrPaciente.setPreferredSize(new Dimension(20, 20));
        GridBagConstraints gbc_labelVlrPaciente = new GridBagConstraints();
        gbc_labelVlrPaciente.insets = new Insets(0, 0, 0, 0);
        gbc_labelVlrPaciente.fill = 2;
        gbc_labelVlrPaciente.gridwidth = 4;
        gbc_labelVlrPaciente.anchor = 17;
        gbc_labelVlrPaciente.gridx = 3;
        gbc_labelVlrPaciente.gridy = 0;
        this.panelDados.add((Component)this.labelVlrPaciente, gbc_labelVlrPaciente);
        this.labelVlrRequisicao.setHorizontalAlignment(4);
        this.labelVlrRequisicao.setMinimumSize(new Dimension(90, 20));
        this.labelVlrRequisicao.setPreferredSize(new Dimension(90, 20));
        GridBagConstraints gbc_labelVlrRequisicao = new GridBagConstraints();
        gbc_labelVlrRequisicao.insets = new Insets(0, 0, 0, 0);
        gbc_labelVlrRequisicao.anchor = 17;
        gbc_labelVlrRequisicao.gridx = 1;
        gbc_labelVlrRequisicao.gridy = 0;
        this.panelDados.add((Component)this.labelVlrRequisicao, gbc_labelVlrRequisicao);
        GridBagConstraints gbc_labelData = new GridBagConstraints();
        gbc_labelData.insets = new Insets(0, 0, 0, 0);
        gbc_labelData.anchor = 17;
        gbc_labelData.gridx = 0;
        gbc_labelData.gridy = 1;
        this.panelDados.add((Component)this.labelData, gbc_labelData);
        GridBagConstraints gbc_labelPaciente = new GridBagConstraints();
        gbc_labelPaciente.insets = new Insets(0, 20, 0, 0);
        gbc_labelPaciente.anchor = 17;
        gbc_labelPaciente.gridx = 2;
        gbc_labelPaciente.gridy = 0;
        this.panelDados.add((Component)this.labelPaciente, gbc_labelPaciente);
        this.labelVlrData.setMinimumSize(new Dimension(90, 20));
        this.labelVlrData.setPreferredSize(new Dimension(90, 20));
        GridBagConstraints gbc_labelVlrData = new GridBagConstraints();
        gbc_labelVlrData.insets = new Insets(0, 0, 0, 0);
        gbc_labelVlrData.anchor = 17;
        gbc_labelVlrData.gridx = 1;
        gbc_labelVlrData.gridy = 1;
        this.panelDados.add((Component)this.labelVlrData, gbc_labelVlrData);
        GridBagConstraints gbc_labelMedico = new GridBagConstraints();
        gbc_labelMedico.insets = new Insets(0, 20, 0, 0);
        gbc_labelMedico.anchor = 17;
        gbc_labelMedico.gridx = 2;
        gbc_labelMedico.gridy = 1;
        this.panelDados.add((Component)this.labelMedico, gbc_labelMedico);
        this.labelVlrMedico.setMinimumSize(new Dimension(20, 20));
        this.labelVlrMedico.setPreferredSize(new Dimension(20, 20));
        GridBagConstraints gbc_labelVlrMedico = new GridBagConstraints();
        gbc_labelVlrMedico.insets = new Insets(0, 0, 0, 0);
        gbc_labelVlrMedico.fill = 2;
        gbc_labelVlrMedico.weightx = 1.0;
        gbc_labelVlrMedico.anchor = 17;
        gbc_labelVlrMedico.gridx = 3;
        gbc_labelVlrMedico.gridy = 1;
        gbc_labelVlrMedico.gridwidth = 4;
        this.panelDados.add((Component)this.labelVlrMedico, gbc_labelVlrMedico);
        this.tableExames = new JTable(new ModeloGridTable(new String[]{"#", "C\u00f3digo", "Exame", "Material", "Valor"}));
        ((ModeloGridTable)this.tableExames.getModel()).setColumnSize(new int[]{25, 60, 0, 90, 80}, this.tableExames);
        this.panelExames.setBorder(new TitledBorder(null, "Exames", 4, 2, null, null));
        GridBagConstraints gbc_panelExames = new GridBagConstraints();
        gbc_panelExames.insets = new Insets(0, 0, 5, 0);
        gbc_panelExames.weighty = 1.0;
        gbc_panelExames.gridwidth = 7;
        gbc_panelExames.fill = 1;
        gbc_panelExames.gridx = 0;
        gbc_panelExames.gridy = 3;
        this.panelDados.add((Component)this.panelExames, gbc_panelExames);
        this.panelExames.setLayout(new BorderLayout());
        JScrollPane scrollExames = new JScrollPane(this.tableExames);
        this.panelExames.add(scrollExames);
        this.tablePagamentos = new JTable(new ModeloGridTable(new String[]{"Data", "Tipo", "Conta", "Usu\u00e1rio", "Valor", "Nota"}));
        ((ModeloGridTable)this.tablePagamentos.getModel()).setColumnSize(new int[]{150, 70, 0, 0, 80, 40}, this.tablePagamentos);
        this.tablePagamentos.getSelectionModel().setSelectionMode(2);
        this.panelPagamentos.setBorder(new TitledBorder(null, "Pagamentos", 4, 2, null, null));
        GridBagConstraints gbc_panelPagamentos = new GridBagConstraints();
        gbc_panelPagamentos.insets = new Insets(0, 0, 5, 0);
        gbc_panelPagamentos.weighty = 1.0;
        gbc_panelPagamentos.gridwidth = 7;
        gbc_panelPagamentos.fill = 1;
        gbc_panelPagamentos.gridx = 0;
        gbc_panelPagamentos.gridy = 4;
        this.panelDados.add((Component)this.panelPagamentos, gbc_panelPagamentos);
        this.panelPagamentos.setLayout(new BorderLayout());
        JScrollPane scrollPagamentos = new JScrollPane(this.tablePagamentos);
        this.panelPagamentos.add(scrollPagamentos);
        this.panelPagador.setBorder(new TitledBorder(null, "Dados dos Pagadores", 4, 2, null, null));
        GridBagConstraints gbc_panelPagador = new GridBagConstraints();
        gbc_panelPagador.insets = new Insets(0, 0, 5, 0);
        gbc_panelPagador.gridwidth = 7;
        gbc_panelPagador.fill = 1;
        gbc_panelPagador.gridx = 0;
        gbc_panelPagador.gridy = 5;
        gbc_panelPagador.weightx = 1.0;
        gbc_panelPagador.weighty = 0.7;
        this.panelDados.add((Component)this.panelPagador, gbc_panelPagador);
        GridBagLayout gbl_panelPagador = new GridBagLayout();
        this.panelPagador.setLayout(gbl_panelPagador);
        this.tablePagadores = new JTable(new ModeloGridTable(new String[]{"Nome", "CPF", "Valor", "Nota"}));
        ((ModeloGridTable)this.tablePagadores.getModel()).setColumnSize(new int[]{0, 120, 80, 50}, this.tablePagadores);
        JScrollPane scrollPagadores = new JScrollPane(this.tablePagadores);
        this.tablePagadores.setColumnSelectionAllowed(false);
        this.tablePagadores.setRowSelectionAllowed(true);
        this.tablePagadores.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!ImprimirNotaFiscalPessoaFisica.this.isCarregandoDados) {
                    ImprimirNotaFiscalPessoaFisica.this.controlaCampos();
                }
                ImprimirNotaFiscalPessoaFisica.this.habilitaBotoes();
                int linhaSelecionada = ImprimirNotaFiscalPessoaFisica.this.tablePagadores.getSelectedRow();
                if (linhaSelecionada > -1) {
                    PagadorBasico pagador = (PagadorBasico)ImprimirNotaFiscalPessoaFisica.this.tablePagadores.getModel().getValueAt(linhaSelecionada, 0);
                    ImprimirNotaFiscalPessoaFisica.this.tablePagamentos.getSelectionModel().clearSelection();
                    for (int i = 0; i < pagador.getPagamentos().size(); ++i) {
                        PagamentoBasico pagPagador = pagador.getPagamentos().get(i);
                        for (int b = 0; b < ImprimirNotaFiscalPessoaFisica.this.tablePagamentos.getRowCount(); ++b) {
                            PagamentoBasico pag = (PagamentoBasico)ImprimirNotaFiscalPessoaFisica.this.tablePagamentos.getModel().getValueAt(b, 6);
                            if (null == pagPagador || null == pag || !pagPagador.getCpfPagador().equals(pag.getCpfPagador()) || !pagPagador.getNomePagador().equalsIgnoreCase(pag.getNomePagador()) || null == pag.getCodigoNotaFiscal() || null == pagPagador.getCodigoNotaFiscal() || !pag.getCodigoNotaFiscal().equals(pagPagador.getCodigoNotaFiscal())) continue;
                            ImprimirNotaFiscalPessoaFisica.this.tablePagamentos.getSelectionModel().addSelectionInterval(b, b);
                        }
                    }
                }
            }
        });
        this.panelPagador.setLayout(new BorderLayout());
        this.panelPagador.add((Component)scrollPagadores, "Center");
        JPanel aux = new JPanel(new FlowLayout(2));
        this.buttonEditarPagador.setMnemonic('d');
        aux.add(this.buttonEditarPagador);
        this.panelPagador.add((Component)aux, "South");
        GridBagConstraints gbc_labelSubtotal = new GridBagConstraints();
        gbc_labelSubtotal.anchor = 17;
        gbc_labelSubtotal.gridx = 0;
        gbc_labelSubtotal.gridy = 2;
        this.panelDados.add((Component)this.labelTotal, gbc_labelSubtotal);
        this.labelVlrTotal.setHorizontalAlignment(4);
        this.labelVlrTotal.setPreferredSize(new Dimension(90, 20));
        this.labelVlrTotal.setMinimumSize(new Dimension(90, 20));
        GridBagConstraints gbc_labelVlrSubtotal = new GridBagConstraints();
        gbc_labelVlrSubtotal.anchor = 17;
        gbc_labelVlrSubtotal.gridx = 1;
        gbc_labelVlrSubtotal.gridy = 2;
        this.panelDados.add((Component)this.labelVlrTotal, gbc_labelVlrSubtotal);
        GridBagConstraints gbc_labelTotal = new GridBagConstraints();
        gbc_labelTotal.insets = new Insets(0, 20, 0, 0);
        gbc_labelTotal.anchor = 17;
        gbc_labelTotal.gridx = 2;
        gbc_labelTotal.gridy = 2;
        this.panelDados.add((Component)this.labelDevedor, gbc_labelTotal);
        this.labelVlrDevedor.setHorizontalAlignment(4);
        this.labelVlrDevedor.setPreferredSize(new Dimension(90, 20));
        this.labelVlrDevedor.setMinimumSize(new Dimension(90, 20));
        GridBagConstraints gbc_labelVlrTotal = new GridBagConstraints();
        gbc_labelVlrTotal.fill = 2;
        gbc_labelVlrTotal.anchor = 17;
        gbc_labelVlrTotal.gridwidth = 2;
        gbc_labelVlrTotal.gridx = 3;
        gbc_labelVlrTotal.gridy = 2;
        this.panelDados.add((Component)this.labelVlrDevedor, gbc_labelVlrTotal);
        this.painelCentral.add((Component)this.panelRequisicoes, "West");
        this.panelRequisicoes.setLayout(new BorderLayout());
        this.tableRequisicoes = new JTable(new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "RPS - N\u00famero NF"}));
        ((ModeloGridTable)this.tableRequisicoes.getModel()).setColumnSize(new int[]{60, 0}, this.tableRequisicoes);
        this.tableRequisicoes.setColumnSelectionAllowed(false);
        this.tableRequisicoes.setRowSelectionAllowed(true);
        this.tableRequisicoes.setFont(this.getFont().deriveFont(10.0f));
        this.tableRequisicoes.getTableHeader().setFont(this.tableRequisicoes.getTableHeader().getFont().deriveFont(10.0f));
        this.tableRequisicoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int aux = ImprimirNotaFiscalPessoaFisica.this.tableRequisicoes.getSelectedRow();
                if (aux >= 0) {
                    RequisicaoBasica requisicao = (RequisicaoBasica)ImprimirNotaFiscalPessoaFisica.this.tableRequisicoes.getModel().getValueAt(aux, 0);
                    ImprimirNotaFiscalPessoaFisica.this.preencheDadosRequisicao(requisicao);
                }
                if (!ImprimirNotaFiscalPessoaFisica.this.isCarregandoDados) {
                    ImprimirNotaFiscalPessoaFisica.this.controlaCampos();
                }
            }
        });
        JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
        scrollRequisicoes.setHorizontalScrollBarPolicy(31);
        scrollRequisicoes.setPreferredSize(new Dimension(210, 20));
        scrollRequisicoes.setMinimumSize(new Dimension(210, 20));
        this.panelRequisicoes.add(scrollRequisicoes);
        this.comboTipoPesquisa.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (((TipoPesquisa)((Object)ImprimirNotaFiscalPessoaFisica.this.comboTipoPesquisa.getSelectedItem())).codigo.intValue() == TipoPesquisa.PACIENTE.codigo.intValue() || ((TipoPesquisa)((Object)ImprimirNotaFiscalPessoaFisica.this.comboTipoPesquisa.getSelectedItem())).codigo.intValue() == TipoPesquisa.PAGADOR.codigo.intValue()) {
                        ImprimirNotaFiscalPessoaFisica.this.panelRequisicoes.setVisible(true);
                    } else {
                        ImprimirNotaFiscalPessoaFisica.this.panelRequisicoes.setVisible(false);
                    }
                    ImprimirNotaFiscalPessoaFisica.this.codigoPesquisa = "";
                    ImprimirNotaFiscalPessoaFisica.this.textPesquisa.clear();
                    ImprimirNotaFiscalPessoaFisica.this.labelPesquisa.setText("");
                    ImprimirNotaFiscalPessoaFisica.this.requisicoes.clear();
                    if (((TipoPesquisa)((Object)ImprimirNotaFiscalPessoaFisica.this.comboTipoPesquisa.getSelectedItem())).codigo.intValue() == TipoPesquisa.PACIENTE.codigo.intValue() || ((TipoPesquisa)((Object)ImprimirNotaFiscalPessoaFisica.this.comboTipoPesquisa.getSelectedItem())).codigo.intValue() == TipoPesquisa.REQUISICAO.codigo.intValue()) {
                        ImprimirNotaFiscalPessoaFisica.this.textPesquisa.setDocument(14, 1);
                    } else if (((TipoPesquisa)((Object)ImprimirNotaFiscalPessoaFisica.this.comboTipoPesquisa.getSelectedItem())).codigo.intValue() == TipoPesquisa.PAGADOR.codigo.intValue()) {
                        ImprimirNotaFiscalPessoaFisica.this.textPesquisa.setDocument(14, 8);
                    }
                }
                ImprimirNotaFiscalPessoaFisica.this.painelCentral.revalidate();
            }
        });
        this.buttonPesquisa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImprimirNotaFiscalPessoaFisica.this.pesquisar();
            }
        });
        this.buttonBuscaFilial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImprimirNotaFiscalPessoaFisica.this.buscaFilial();
            }
        });
        this.textPesquisa.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ImprimirNotaFiscalPessoaFisica.this.pesquisar();
                }
            }
        });
        this.buttonCarregar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] aux = StringUtil.getValor(ParametrosGerais.getFiliaisIntegracao(), "filiaisIntegracao").split(",");
                if (Arrays.asList(aux).contains(ImprimirNotaFiscalPessoaFisica.this.textFilial.getText())) {
                    ImprimirNotaFiscalPessoaFisica.this.carregaDados();
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Filial n\u00e3o permitida para a emiss\u00e3o de nota fiscal.", 2);
                }
            }
        });
        this.textFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ImprimirNotaFiscalPessoaFisica.this.buscaFilial();
                }
            }
        });
        this.textFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ImprimirNotaFiscalPessoaFisica.this.textFilial) {
                    ImprimirNotaFiscalPessoaFisica.this.labelValorFilial.setText(ImprimirNotaFiscalPessoaFisica.this.getDescricaoFilial(ImprimirNotaFiscalPessoaFisica.this.textFilial.getText()));
                }
            }
        });
        this.textPesquisa.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ImprimirNotaFiscalPessoaFisica.this.codigoPesquisa = ImprimirNotaFiscalPessoaFisica.this.textPesquisa.getText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!ImprimirNotaFiscalPessoaFisica.this.validaCampos()) {
                    return;
                }
                if (ImprimirNotaFiscalPessoaFisica.this.comboTipoPesquisa.getSelectedItem().equals((Object)TipoPesquisa.REQUISICAO)) {
                    ImprimirNotaFiscalPessoaFisica.this.processarNumeroTubo(null, ImprimirNotaFiscalPessoaFisica.this.textPesquisa);
                }
                if (Funcoes.textoVazio(ImprimirNotaFiscalPessoaFisica.this.textPesquisa)) {
                    ImprimirNotaFiscalPessoaFisica.this.limparDados();
                    return;
                }
                if (ImprimirNotaFiscalPessoaFisica.this.codigoPesquisa.equals(ImprimirNotaFiscalPessoaFisica.this.textPesquisa.getText())) {
                    return;
                }
                ImprimirNotaFiscalPessoaFisica.this.pesquisar(ImprimirNotaFiscalPessoaFisica.this.textPesquisa.getText());
            }
        });
        this.buttonEditarPagador.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ImprimirNotaFiscalPessoaFisica.this.tablePagadores.getSelectedRow() >= 0) {
                    if (!ImprimirNotaFiscalPessoaFisica.this.validaCampos()) {
                        return;
                    }
                    RequisicaoBasica requisicao = null;
                    requisicao = ImprimirNotaFiscalPessoaFisica.this.comboTipoPesquisa.getSelectedItem().equals((Object)TipoPesquisa.REQUISICAO) ? (RequisicaoBasica)ImprimirNotaFiscalPessoaFisica.this.tableRequisicoes.getModel().getValueAt(0, 0) : (RequisicaoBasica)ImprimirNotaFiscalPessoaFisica.this.tableRequisicoes.getModel().getValueAt(ImprimirNotaFiscalPessoaFisica.this.tableRequisicoes.getSelectedRow(), 0);
                    PagadorBasico pagador = (PagadorBasico)ImprimirNotaFiscalPessoaFisica.this.tablePagadores.getModel().getValueAt(ImprimirNotaFiscalPessoaFisica.this.tablePagadores.getSelectedRow(), 0);
                    JanelaEdicaoPagador janelaEdicao = new JanelaEdicaoPagador(Laboratorio.getInstancia(), pagador.getNomePagador(), pagador.getCpfPagador());
                    janelaEdicao.setVisible(true);
                    if (janelaEdicao.getOk()) {
                        int indexPagador = -1;
                        for (int x = 0; x < requisicao.pagadores.size(); ++x) {
                            if (!requisicao.pagadores.get(x).getCodigoLancamento().equals(pagador.getCodigoLancamento())) continue;
                            indexPagador = x;
                        }
                        requisicao.pagadores.remove(indexPagador);
                        pagador.setNomePagador(janelaEdicao.getNome());
                        pagador.setCpfPagador(janelaEdicao.getCpf());
                        requisicao.addPagador(pagador);
                        for (PagamentoBasico pgto : pagador.getPagamentos()) {
                            pgto.setNomePagador(pagador.getNomePagador());
                            pgto.setCpfPagador(pagador.getCpfPagador());
                        }
                        StringBuilder buf = new StringBuilder();
                        buf.append(" update lanctocaixa ");
                        buf.append("    set lcx_nomepagador = '").append(pagador.getNomePagador()).append("' ");
                        buf.append("       ,lcx_cpfpagador = '").append(pagador.getCpfPagador()).append("' ");
                        buf.append("  where fil_codigo = ? ");
                        buf.append("    and lcx_codigo = ? ");
                        buf.append("    and est_codigo = ? ");
                        PreparedStatement prst = Conexao.getPreparedStatement(buf.toString());
                        buf.setLength(0);
                        buf.append(" update notafiscal ");
                        buf.append("    set nfi_nomepagador = '").append(pagador.getNomePagador()).append("' ");
                        buf.append("\t\t\t  ,nfi_cpfpagador = '").append(pagador.getCpfPagador()).append("' ");
                        buf.append("  where fil_codigo = ?");
                        buf.append("\tand nfi_codigo = ?");
                        PreparedStatement prstNota = Conexao.getPreparedStatement(buf.toString());
                        try {
                            for (int i = 0; i < pagador.getPagamentos().size(); ++i) {
                                PagamentoBasico pgto = pagador.getPagamentos().get(i);
                                prst.setInt(1, Integer.parseInt(ImprimirNotaFiscalPessoaFisica.this.textFilial.getText()));
                                prst.setInt(2, pgto.getCodigoLancamento());
                                prst.setInt(3, pgto.getCodigoEstacao());
                                prst.executeUpdate();
                            }
                            if (pagador.getCodigoNotaFiscal() != null) {
                                prstNota.setInt(1, Integer.parseInt(ImprimirNotaFiscalPessoaFisica.this.textFilial.getText()));
                                prstNota.setInt(2, pagador.getCodigoNotaFiscal());
                                prstNota.executeUpdate();
                            }
                            Conexao.arquivaSQL();
                        }
                        catch (SQLException sqle) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            ErrorLogger.mostraMensagem(ImprimirNotaFiscalPessoaFisica.this, "N\u00e3o foi poss\u00edvel atualizar lan\u00e7amentos.\n" + sqle.getMessage(), sqle.getStackTrace());
                        }
                        ImprimirNotaFiscalPessoaFisica.this.preencheDadosRequisicao(requisicao);
                    }
                }
            }
        });
        this.montaTimer();
        this.setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{this.comboTipoPesquisa, this.textPesquisa, this.buttonCarregar, this.tableRequisicoes, this.tablePagadores, this.buttonEditarPagador}));
        this.controlaCampos();
    }

    private void montaTimer() {
        this.timer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ImprimirNotaFiscalPessoaFisica.this.isCarregandoDados && ImprimirNotaFiscalPessoaFisica.this.dadosCarregados) {
                    ImprimirNotaFiscalPessoaFisica.this.carregaDados();
                }
            }
        });
        this.timer.setRepeats(true);
    }

    private void buscaFilial() {
        Hashtable table = Pesquisas.filial(this.getTopLevelAncestor(), false);
        if (table != null) {
            this.textFilial.setText(table.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private String getDescricaoFilial(String filial) {
        if (Funcoes.textoVazio(filial)) {
            return "N\u00e3o cadastrado";
        }
        try {
            filial = StringUtil.removeZerosEsquerda(filial);
            this.textFilial.setText(filial);
            return DBUtil.getDescricao("fil_codigo", "fil_descricao", filial, "filiais_postocoleta", true);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da filial.\n" + e.getMessage(), e.getStackTrace());
            return "N\u00e3o cadastrado";
        }
    }

    private void carregaDados() {
        int selecaoRequisicao = this.tableRequisicoes.getSelectedRow();
        int selecaoExame = this.tableExames.getSelectedRow();
        int selecaoPagador = this.tablePagadores.getSelectedRow();
        int selecaoPagamento = this.tablePagamentos.getSelectedRow();
        if (!this.dadosCarregados) {
            this.limparDados();
        }
        if (Funcoes.textoVazio(this.textPesquisa)) {
            Funcoes.mensagem(this, "O paciente/pagador/requisi\u00e7\u00e3o deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textPesquisa);
            return;
        }
        if (((TipoPesquisa)((Object)this.comboTipoPesquisa.getSelectedItem())).codigo.intValue() == TipoPesquisa.PACIENTE.codigo.intValue()) {
            this.buscaDadosPaciente(Integer.parseInt(this.textPesquisa.getText()));
        } else if (((TipoPesquisa)((Object)this.comboTipoPesquisa.getSelectedItem())).codigo.intValue() == TipoPesquisa.PAGADOR.codigo.intValue()) {
            this.buscaDadosPagador(this.textPesquisa.getText());
        } else {
            this.buscaDadosRequisicao(this.textPesquisa.getText());
        }
        this.preencheListaRequisicoes();
        this.controlaCampos();
        if (selecaoRequisicao >= 0) {
            this.tableRequisicoes.getSelectionModel().setSelectionInterval(selecaoRequisicao, selecaoRequisicao);
        }
        if (selecaoExame >= 0) {
            this.tableExames.getSelectionModel().setSelectionInterval(selecaoExame, selecaoExame);
        }
        if (selecaoPagador > 0) {
            this.tablePagadores.getSelectionModel().setSelectionInterval(selecaoPagador, selecaoPagador);
        }
        if (selecaoPagamento >= 0) {
            this.tablePagamentos.getSelectionModel().setSelectionInterval(selecaoPagamento, selecaoPagamento);
        }
    }

    private void preencheDadosRequisicao(RequisicaoBasica requisicao) {
        if (requisicao == null) {
            return;
        }
        this.labelVlrRequisicao.setText(requisicao.getCodigoRequisicao().toString());
        this.labelVlrPaciente.setText(requisicao.getNomePaciente());
        this.labelVlrData.setText(requisicao.getDataRequisicao() == null ? "" : Funcoes.formataData("dd/MM/yyyy", requisicao.getDataRequisicao()));
        this.labelVlrMedico.setText((requisicao.getConselhoMedico() == null ? "" : requisicao.getConselhoMedico()) + " " + (requisicao.getCrmMedico() == null ? "" : requisicao.getCrmMedico()) + " " + (requisicao.getUfMedico() == null ? "" : requisicao.getUfMedico()) + " - " + (requisicao.getNomeMedico() == null ? "" : requisicao.getNomeMedico()));
        this.labelVlrTotal.setText(Funcoes.formataDecimal(requisicao.getValorTotal() == null ? 0.0 : requisicao.getValorTotal().doubleValue()));
        this.labelVlrDevedor.setText(Funcoes.formataDecimal(requisicao.getValorDevido() == null ? 0.0 : requisicao.getValorDevido().doubleValue()));
        ModeloGridTable modeloExameAux = new ModeloGridTable(new String[]{"#", "C\u00f3digo", "Exame", "Material", "Valor"});
        ArrayList<ExameBasico> exames = requisicao.exames;
        modeloExameAux.clear();
        for (int i = 0; i < exames.size(); ++i) {
            ExameBasico exame = exames.get(i);
            modeloExameAux.addLine(new Object[]{exame.ordemExame, exame.codigoExame, exame.descricaoExame, exame.descricaoMaterial, Funcoes.formataDecimal(exame.valorTotalExame == null ? 0.0 : exame.valorTotalExame.doubleValue())});
        }
        modeloExameAux.ordenarColunaSemTrocarSentido(0);
        this.tableExames.setModel(modeloExameAux);
        ((ModeloGridTable)this.tableExames.getModel()).setColumnSize(new int[]{25, 60, 0, 90, 80}, this.tableExames);
        ModeloGridTable modeloPagamentoAux = new ModeloGridTable(new String[]{"Data", "Tipo", "Conta", "Usu\u00e1rio", "Valor", "Nota"});
        ArrayList<PagamentoBasico> pagamentos = requisicao.pagamentos;
        modeloPagamentoAux.clear();
        for (int i = 0; i < pagamentos.size(); ++i) {
            PagamentoBasico pagamento = pagamentos.get(i);
            modeloPagamentoAux.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm:ss", pagamento.getDataPagamento()), pagamento.getTipoPagamento(), pagamento.getDescricaoContaPagamento(), pagamento.getUsuarioPagamento(), Funcoes.formataDecimal(pagamento.getValorPagamento().doubleValue()), pagamento.getNumeroNotaFiscal(), pagamento});
        }
        modeloPagamentoAux.ordenarColunaSemTrocarSentido(0);
        this.tablePagamentos.setModel(modeloPagamentoAux);
        ((ModeloGridTable)this.tablePagamentos.getModel()).setColumnSize(new int[]{130, 130, 0, 150, 80, 120}, this.tablePagamentos);
        ModeloGridTable modeloPagadoresAux = new ModeloGridTable(new String[]{"Nome", "CPF", "Valor", "Nota"});
        List<PagadorBasico> pagadores = requisicao.pagadores;
        modeloPagadoresAux.clear();
        int posSemNota = -1;
        for (int i = 0; i < pagadores.size(); ++i) {
            PagadorBasico pagador = pagadores.get(i);
            if (posSemNota == -1 && (pagador.getCodigoNotaFiscal() == null || pagador.getCodigoNotaFiscal() <= 0)) {
                posSemNota = i;
            }
            modeloPagadoresAux.addLine(new Object[]{pagador, pagador.getCpfPagador(), Funcoes.formataDecimal(pagador.getValorPago().doubleValue()), pagador.getNumeroNotaFiscal()});
        }
        modeloPagadoresAux.ordenarColunaSemTrocarSentido(0);
        this.tablePagadores.setModel(modeloPagadoresAux);
        ((ModeloGridTable)this.tablePagadores.getModel()).setColumnSize(new int[]{0, 120, 80, 120}, this.tablePagadores);
        if (this.tablePagadores.getRowCount() > 0) {
            if (posSemNota > -1) {
                this.tablePagadores.getSelectionModel().setSelectionInterval(posSemNota, posSemNota);
            } else {
                this.tablePagadores.getSelectionModel().setSelectionInterval(0, 0);
            }
        }
        if (requisicao.getValorDevido() == null || requisicao.getValorDevido().compareTo(BigDecimal.ZERO) > 0) {
            this.labelVlrDevedor.setForeground(Color.RED);
        } else {
            this.labelVlrDevedor.setForeground(Color.BLACK);
        }
    }

    @Override
    public void novo() {
        this.limpar();
        this.setStatus(2);
        this.textFilial.setText(Variaveis.filialPadrao);
        this.labelValorFilial.setText(this.getDescricaoFilial(this.textFilial.getText()));
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    @Override
    public void salvar() {
        if (this.tablePagadores.getSelectedRowCount() < 0) {
            Funcoes.mensagem(this, "Nenhum pagador foi selecionado", 2);
            return;
        }
        int linhaSelecionada = this.tablePagadores.getSelectedRow();
        if (linhaSelecionada >= 0) {
            boolean temNota;
            PagadorBasico pagador = (PagadorBasico)this.tablePagadores.getModel().getValueAt(linhaSelecionada, 0);
            if (Funcoes.textoVazio(pagador.getNomePagador()) || Funcoes.textoVazio(pagador.getCpfPagador())) {
                Funcoes.mensagem(this, "O nome e CPF do pagador devem ser informados.", 2);
                this.buttonEditarPagador.setEnabled(true);
                return;
            }
            if (!ValidaDoc.checkDoc(pagador.getCpfPagador(), 8)) {
                Funcoes.mensagem(this, "CPF do pagador inv\u00e1lido.", 2);
                this.buttonEditarPagador.setEnabled(true);
                return;
            }
            boolean bl = temNota = pagador.getCodigoNotaFiscal() != null && pagador.getCodigoNotaFiscal() > 0;
            if (temNota) {
                this.visualizarNotaFiscal(linhaSelecionada, pagador);
            } else {
                this.gerarNotaFiscal(pagador);
            }
        }
    }

    private void gerarNotaFiscal(PagadorBasico pagador) {
        DialogNotaFiscalSaida dialogNota = NotaFiscalSaida.novaInstancia(Laboratorio.getInstancia(), true, null, this.textFilial.getText());
        NotaFiscalSaida nota = null;
        if (dialogNota != null) {
            nota = dialogNota.getNotaFiscalSaida();
        }
        if (nota != null) {
            NotaFiscalBean notaBean;
            nota.setAcessos(ImprimirNotaFiscalPessoaFisica.getModuloModificarNumeroNotaFiscal(), -1L);
            nota.setDataEmissao(new Date());
            nota.setNomePagador(pagador.getNomePagador());
            nota.setCpfPagador(pagador.getCpfPagador());
            nota.setSubTotal(pagador.getValorPago().doubleValue());
            nota.setCadastro("P", pagador.getRequisicao().getCodigoPaciente().toString());
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(this.textFilial.getText()));
            HashSet<LancamentoBean> lancamentos = new HashSet<LancamentoBean>();
            for (int i = 0; i < pagador.getPagamentos().size(); ++i) {
                PagamentoBasico pgto = pagador.getPagamentos().get(i);
                if (!pgto.getNomePagador().equalsIgnoreCase(pagador.getNomePagador()) || !pgto.getCpfPagador().equals(pagador.getCpfPagador())) continue;
                EstacaoVO estacao = new EstacaoVO();
                estacao.setCodigo(pgto.getCodigoEstacao());
                ContaCorrenteVO conta = new ContaCorrenteVO();
                conta.setFilial(filial);
                conta.setReduzido(pgto.getReduzidoContaCorrente());
                LancamentoBean lancto = new LancamentoBean();
                lancto.setFilial(filial);
                lancto.setCodigo(pgto.getCodigoLancamento());
                lancto.setEstacao(estacao);
                lancto.setContaCorrente(conta);
                lancto.setDataVencimento(pgto.getDataPagamento());
                lancto.setValor(pgto.getValorPagamento().doubleValue());
                lancto.setValorTotal(pgto.getValorPagamento().doubleValue());
                lancto.setTipo("C");
                lancto.setTipoPagamento(Tipos.getTipoPagamento(pgto.getTipoPagamento()));
                lancto.setTipoOrigem("C");
                lancamentos.add(lancto);
            }
            RequisicaoBean requisicaoBean = this.getRequisicaoSelecionada();
            List<RequisicaoBean> requisicoes = Arrays.asList(requisicaoBean);
            nota.setRequisicaoBean(requisicoes);
            nota.setLancamentosPagamentos(lancamentos);
            if (dialogNota.getNotaFiscalSaida().isCadastroValidado()) {
                dialogNota.setVisible(true);
            }
            NotaFiscalBean notaFiscalBean = notaBean = nota != null ? nota.getRetorno() : null;
            if (notaBean != null) {
                pagador.setCodigoNotaFiscal(notaBean.getCodigo());
                for (int i = 0; i < pagador.getPagamentos().size(); ++i) {
                    PagamentoBasico pgto = pagador.getPagamentos().get(i);
                    if (!pgto.getNomePagador().equalsIgnoreCase(pagador.getNomePagador()) || !pgto.getCpfPagador().equalsIgnoreCase(pagador.getCpfPagador())) continue;
                    pagador.getPagamentos().get(i).setCodigoNotaFiscal(notaBean.getCodigo());
                    pagador.getPagamentos().get(i).setNumeroNotaFiscal(notaBean.getNumero());
                    pagador.getPagamentos().get(i).setRpsNotaFiscal(notaBean.getNumeroRps());
                    pagador.getPagamentos().get(i).setSerieNotaFiscal(notaBean.getSerie().getCodigo());
                }
                if (((TipoPesquisa)((Object)this.comboTipoPesquisa.getSelectedItem())).codigo.intValue() == TipoPesquisa.REQUISICAO.codigo.intValue()) {
                    RequisicaoBasica requisicao = (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(0, 0);
                    requisicao.getListaCodigoNotaFiscal().add(notaBean.getCodigo());
                    requisicao.getListaNumeroNotaFiscal().add(notaBean.getNumero());
                    requisicao.getListaRpsNotaFiscal().add(notaBean.getNumeroRps());
                    requisicao.getListaSerieNotaFiscal().add(notaBean.getSerie().getCodigo());
                } else {
                    RequisicaoBasica requisicao = null;
                    requisicao = this.comboTipoPesquisa.getSelectedItem().equals((Object)TipoPesquisa.REQUISICAO) ? (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(0, 0) : (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(this.tableRequisicoes.getSelectedRow(), 0);
                    requisicao.getListaCodigoNotaFiscal().add(notaBean.getCodigo());
                    requisicao.getListaNumeroNotaFiscal().add(notaBean.getNumero());
                    requisicao.getListaRpsNotaFiscal().add(notaBean.getNumeroRps());
                    requisicao.getListaSerieNotaFiscal().add(notaBean.getSerie().getCodigo());
                    ((ModeloGridTable)this.tableRequisicoes.getModel()).fireTableDataChanged();
                }
                if (notaBean != null) {
                    this.carregaDados();
                }
                this.habilitaBotoes();
                this.controlaCampos();
            }
        }
    }

    private void visualizarNotaFiscal(int linhaSelecionada, PagadorBasico pagador) {
        NotaFiscalBean notaBean = null;
        try {
            notaBean = (NotaFiscalBean)new NotaFiscalService().get(this.textFilial.getText(), String.valueOf(pagador.getCodigoNotaFiscal()));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados da nota fiscal.\n" + e.getMessage(), e.getStackTrace());
        }
        if (notaBean != null) {
            ImprimirNotaFiscal impressao = new ImprimirNotaFiscal(){

                @Override
                public void setVisible(boolean isVisible) {
                    if (!isVisible && this.getParent() != null) {
                        Container comp = this.getParent();
                        while (comp.getParent() != null) {
                            if (!((comp = comp.getParent()) instanceof JDialog)) continue;
                            comp.setVisible(false);
                        }
                    }
                }

                @Override
                public void fechar() {
                    this.setVisible(false);
                    ImprimirNotaFiscalPessoaFisica.this.carregaDados();
                }
            };
            RequisicaoBasica requisicao = null;
            requisicao = this.comboTipoPesquisa.getSelectedItem().equals((Object)TipoPesquisa.REQUISICAO) ? (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(0, 0) : (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(linhaSelecionada, 0);
            impressao.novo(notaBean, requisicao.getCodigoRequisicao(), true);
            impressao.configurarTelaPessoaFisica();
            impressao.controlaBotoes();
            JDialog dialog = new JDialog((Frame)Laboratorio.getInstancia(), true);
            dialog.setContentPane(impressao);
            dialog.setSize(new Dimension(650, 500));
            dialog.setTitle("Visualizando Nota Fiscal de Pessoa F\u00edsica");
            ScreenUtil.centralizar(dialog);
            dialog.setVisible(true);
        }
    }

    private RequisicaoBean getRequisicaoSelecionada() {
        try {
            boolean requisicao;
            boolean bl = requisicao = ((TipoPesquisa)((Object)this.comboTipoPesquisa.getSelectedItem())).codigo.intValue() == TipoPesquisa.REQUISICAO.codigo.intValue();
            if (requisicao) {
                String codRequisicao = this.textPesquisa.getText();
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", this.textFilial.getText());
                chaves.put("req_codigo", codRequisicao);
                return (RequisicaoBean)new RequisicaoService().getBean(chaves);
            }
            RequisicaoBasica requisicaoSelecionada = (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(this.tableRequisicoes.getSelectedRow(), 0);
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", this.textFilial.getText());
            chaves.put("req_codigo", requisicaoSelecionada.getCodigoRequisicao());
            return (RequisicaoBean)new RequisicaoService().getBean(chaves);
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "Erro ao buscar nota fiscal", e.getStackTrace());
            return null;
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.dadosCarregados = false;
            this.limpar();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    protected synchronized void controlaCampos() {
        boolean enabled = this.getStatus() == 2 && !this.isCarregandoDados;
        boolean requisicaoSelecionada = this.requisicoes.size() > 0 && (((TipoPesquisa)((Object)this.comboTipoPesquisa.getSelectedItem())).codigo.intValue() == TipoPesquisa.REQUISICAO.codigo.intValue() || this.tableRequisicoes.getSelectedRow() >= 0);
        boolean pagadorSelecionado = this.tablePagadores.getSelectedRow() >= 0;
        boolean podeEditarPagador = Acesso.getAcesso(ImprimirNotaFiscalPessoaFisica.getModuloEditarPagador());
        if (pagadorSelecionado) {
            PagadorBasico pagador = (PagadorBasico)this.tablePagadores.getModel().getValueAt(this.tablePagadores.getSelectedRow(), 0);
            String requisicao = null;
            int linhaSelecao = this.tableRequisicoes.getSelectedRow();
            if (linhaSelecao > -1) {
                requisicao = (String)this.tableRequisicoes.getValueAt(linhaSelecao, 1);
            }
            String numNota = null;
            if (!Funcoes.textoVazio(requisicao) && requisicao != null) {
                String[] dadoReq = requisicao.split("-");
                numNota = dadoReq[1].trim();
            }
            if (!Funcoes.textoVazio(numNota) && pagador.getCodigoNotaFiscal() != null) {
                podeEditarPagador = false;
            }
        }
        this.textFilial.setEnabled(enabled && this.requisicoes.size() == 0);
        this.comboTipoPesquisa.setEnabled(enabled && this.requisicoes.size() == 0);
        this.textPesquisa.setEnabled(enabled && this.requisicoes.size() == 0);
        this.buttonPesquisa.setEnabled(enabled && this.requisicoes.size() == 0);
        this.buttonCarregar.setEnabled(enabled && this.requisicoes.size() == 0);
        this.tableRequisicoes.setEnabled(enabled && this.requisicoes.size() > 0);
        this.tablePagadores.setEnabled(enabled && requisicaoSelecionada);
        this.buttonEditarPagador.setEnabled(enabled && requisicaoSelecionada && pagadorSelecionado && podeEditarPagador);
        this.botaoSalvar.setEnabled(enabled && requisicaoSelecionada && pagadorSelecionado);
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textFilial.getText())) {
            Funcoes.mensagem(this, "Filial n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(this.textFilial);
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    public static long getModuloAcesso() {
        return ACESSO_ACESSAR;
    }

    public static long getModuloModificarNumeroNotaFiscal() {
        return ACESSO_MODIFICAR_NUMERO_NOTA_FISCAL;
    }

    public static long getModuloEditarPagador() {
        return ACESSO_EDITAR_PAGADOR;
    }

    public static long getModuloSalvarSemInformarPagador() {
        return ACESSO_SALVAR_SEM_INFORMAR_PAGADOR;
    }

    public static long getBloqueiaAlteracaoSerie() {
        return NAO_PERMITIR_ALTERAR_SERIE_NOTA;
    }

    private void pesquisar() {
        if (((TipoPesquisa)((Object)this.comboTipoPesquisa.getSelectedItem())).codigo.equals(TipoPesquisa.PACIENTE.codigo)) {
            PacienteVO pacienteVO = new PacienteVO();
            pacienteVO = (PacienteVO)new PacienteService().pesquisaVO(Laboratorio.getInstancia(), pacienteVO, "Pesquisando pacientes", true, this.textFilial.getText());
            this.limparDados();
            if (pacienteVO != null) {
                this.textPesquisa.setText(String.valueOf(pacienteVO.getCodigo()));
                this.labelPesquisa.setText(pacienteVO.getNome());
                ScreenUtil.requisitarFoco(this.buttonCarregar);
            } else {
                this.labelPesquisa.setText("N\u00e3o cadastrado");
                ScreenUtil.requisitarFoco(this.textPesquisa);
            }
        } else if (((TipoPesquisa)((Object)this.comboTipoPesquisa.getSelectedItem())).codigo.equals(TipoPesquisa.PAGADOR.codigo)) {
            Hashtable pagador = Pesquisas.pagador(Laboratorio.getInstancia(), this.textFilial.getText());
            this.limparDados();
            if (pagador != null) {
                this.textPesquisa.setText(String.valueOf(pagador.get("cpfpagador")));
                this.labelPesquisa.setText(String.valueOf(pagador.get("nomepagador")));
                ScreenUtil.requisitarFoco(this.buttonCarregar);
            } else {
                this.labelPesquisa.setText("N\u00e3o cadastrado");
                ScreenUtil.requisitarFoco(this.textPesquisa);
            }
        } else {
            Hashtable resultado = Pesquisas.requisicao(Laboratorio.getInstancia(), this.textFilial.getText(), false, false, false);
            this.limparDados();
            if (resultado != null) {
                this.textPesquisa.setText(String.valueOf(resultado.get("req_codigo")));
                this.labelPesquisa.setText(String.valueOf(resultado.get("pac_nome")));
                ScreenUtil.requisitarFoco(this.buttonCarregar);
            } else {
                this.labelPesquisa.setText("N\u00e3o cadastrado");
                ScreenUtil.requisitarFoco(this.textPesquisa);
            }
        }
    }

    private void pesquisar(String codigo) {
        if (((TipoPesquisa)((Object)this.comboTipoPesquisa.getSelectedItem())).codigo.equals(TipoPesquisa.PACIENTE.codigo)) {
            PacienteVO paciente = null;
            try {
                paciente = (PacienteVO)new PacienteService().getVO(this.textFilial.getText(), codigo);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Paciente n\u00e3o identificado.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
            if (paciente != null) {
                this.labelPesquisa.setText(paciente.getNome());
            } else {
                this.labelPesquisa.setText("");
            }
        } else if (((TipoPesquisa)((Object)this.comboTipoPesquisa.getSelectedItem())).codigo.equals(TipoPesquisa.PAGADOR.codigo)) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select pac_nomepagador as nome ");
            buf.append("   from paciente ");
            buf.append("  where fil_codigo = ").append(this.textFilial.getText());
            buf.append("    and pac_cpfpagador = '").append(codigo).append("' ");
            try {
                ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs.next()) {
                    this.labelPesquisa.setText(rs.getString("nome"));
                }
                buf.setLength(0);
                buf.append(" select lcx_nomepagador as nome ");
                buf.append("   from lanctocaixa ");
                buf.append("  where fil_codigo = ").append(this.textFilial.getText());
                buf.append("    and lcx_cpfpagador = '").append(codigo).append("' ");
                rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs.next()) {
                    this.labelPesquisa.setText(rs.getString("nome"));
                }
                this.labelPesquisa.setText("");
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Pagador n\u00e3o identificado.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append(" select pac.pac_nome as nome ");
            buf.append("   from requisicao req ");
            buf.append("   join paciente pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
            buf.append("  where req.fil_codigo = ").append(this.textFilial.getText());
            buf.append("    and req.req_codigo = ").append(codigo);
            try {
                ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs.next()) {
                    this.labelPesquisa.setText(rs.getString("nome"));
                } else {
                    this.labelPesquisa.setText("");
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
        }
    }

    private void preencheListaRequisicoes() {
        ModeloGridTable modeloAux = null;
        if (this.requisicoes != null && this.requisicoes.size() > 0) {
            modeloAux = new ModeloGridTable(new String[]{"Requisi\u00e7\u00e3o", "RPS - N\u00famero NF"});
            for (int i = 0; i < this.requisicoes.size(); ++i) {
                modeloAux.addLine(new Object[]{this.requisicoes.get(i), this.requisicoes.get(i).getListaRpsNotaFiscal().toString() + " - " + this.requisicoes.get(i).getListaNumeroNotaFiscal().toString()});
            }
            this.tableRequisicoes.setModel(modeloAux);
            ((ModeloGridTable)this.tableRequisicoes.getModel()).setColumnSize(new int[]{60, 0}, this.tableRequisicoes);
            this.tableRequisicoes.setColumnSelectionAllowed(false);
            this.tableRequisicoes.setRowSelectionAllowed(true);
            this.tableRequisicoes.setFont(this.getFont().deriveFont(10.0f));
            this.tableRequisicoes.getTableHeader().setFont(this.tableRequisicoes.getTableHeader().getFont().deriveFont(10.0f));
            modeloAux.ordenarColuna(0, -1);
            this.preencheDadosRequisicao(this.requisicoes.get(0));
            this.dadosCarregados = true;
        }
        if (modeloAux != null && modeloAux.getRowCount() > 0) {
            this.tableRequisicoes.getSelectionModel().setSelectionInterval(0, 0);
        }
        if (((TipoPesquisa)((Object)this.comboTipoPesquisa.getSelectedItem())).codigo.intValue() == TipoPesquisa.PACIENTE.codigo.intValue() || ((TipoPesquisa)((Object)this.comboTipoPesquisa.getSelectedItem())).codigo.intValue() == TipoPesquisa.PAGADOR.codigo.intValue()) {
            ScreenUtil.requisitarFoco(this.tableRequisicoes);
        } else {
            ScreenUtil.requisitarFoco(this.tablePagadores);
        }
    }

    private void buscaDadosRequisicao(String codigoRequisicao) {
        if (!this.validaCampos()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.med_conselho as conselhoMedico ");
        buf.append("       ,req.med_crm as crmMedico ");
        buf.append("       ,req.med_uf as ufMedico ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,COALESCE(pac.pac_nomepagador, pac.pac_nome) as nomePagador ");
        buf.append("       ,COALESCE(pac.pac_cpfpagador, pac.pac_cpfpagador) as cpfPagador ");
        buf.append("       ,exr.exr_ordem as ordemExame ");
        buf.append("       ,exr.exa_codigo as codigoExame ");
        buf.append("       ,exa.exa_descricao as descricaoExame ");
        buf.append("       ,mco.mco_descricao as descricaoMaterial ");
        buf.append("       ,calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exr.exa_codigo, exr.mco_codigo, false, false, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo").append(") as valorTotalExame ");
        buf.append("       ,req.req_total as valorTotal ");
        buf.append("       ,req.req_totpago as valorPago ");
        buf.append("   from requisicao      req ");
        buf.append("   join paciente        pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join medico          med on req.fil_codigo = med.fil_codigo and req.med_conselho = med.med_conselho and req.med_crm = med.med_crm and req.med_uf = med.med_uf ");
        buf.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("   join examematcoleta  emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("   join exames          exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("   join materialcoleta  mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        buf.append("   join convenios       con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("  where req.fil_codigo = ").append(this.textFilial.getText());
        buf.append("    and req.req_codigo = ").append(codigoRequisicao);
        buf.append("    and NOT req.req_excluida ");
        buf.append("    and NOT exr.exr_excluido ");
        buf.append("    and req.req_total > 0 ");
        buf.append("  order by req.req_codigo ");
        this.requisicoes.clear();
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            int aux = -1;
            String nomePaciente = null;
            while (rs.next()) {
                RequisicaoBasica requisicao = null;
                if (aux != rs.getInt("codigoRequisicao")) {
                    requisicao = new RequisicaoBasica(rs.getInt("codigoRequisicao"), rs.getInt("codigoPaciente"), rs.getString("nomePaciente"), rs.getDate("dataRequisicao"), rs.getString("conselhoMedico"), rs.getString("crmMedico"), rs.getString("ufMedico"), rs.getString("nomeMedico"), rs.getString("nomePagador"), rs.getString("cpfPagador"), rs.getBigDecimal("valorTotal"), rs.getBigDecimal("valorPago"));
                    nomePaciente = rs.getString("nomePaciente");
                    this.requisicoes.add(requisicao);
                    aux = rs.getInt("codigoRequisicao");
                }
                do {
                    ExameBasico exame = new ExameBasico(rs.getInt("ordemExame"), rs.getString("codigoExame"), rs.getString("descricaoExame"), rs.getString("descricaoMaterial"), rs.getBigDecimal("valorTotalExame"));
                    if (requisicao == null) continue;
                    requisicao.addExame(exame);
                } while (rs.next());
                this.buscaPagamentos(requisicao);
            }
            if (this.requisicoes.size() > 0) {
                this.textPesquisa.setText(codigoRequisicao.toString());
                this.labelPesquisa.setText(nomePaciente == null ? "" : nomePaciente);
                ScreenUtil.requisitarFoco(this.buttonCarregar);
            } else {
                Funcoes.mensagem(this, "Nenhuma requisi\u00e7\u00e3o encontrada ou requisi\u00e7\u00e3o sem pagamento em balc\u00e3o.", 2);
            }
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da requisicao.\n" + sqle.getMessage(), sqle.getStackTrace());
            this.novo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDadosPaciente(Integer paciente) {
        if (!this.validaCampos()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select req.req_codigo as codigoRequisicao ");
        buf.append("       ,pac.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.med_conselho as conselhoMedico ");
        buf.append("       ,req.med_crm as crmMedico ");
        buf.append("       ,req.med_uf as ufMedico ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,COALESCE(pac.pac_nomepagador, pac.pac_nome) as nomePagador ");
        buf.append("       ,COALESCE(pac.pac_cpfpagador, pac.pac_cpfpagador) as cpfPagador ");
        buf.append("       ,exr.exr_ordem as ordemExame ");
        buf.append("       ,exr.exa_codigo as codigoExame ");
        buf.append("       ,exa.exa_descricao as descricaoExame ");
        buf.append("       ,mco.mco_descricao as descricaoMaterial ");
        buf.append("       ,calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exr.exa_codigo, exr.mco_codigo, false, false, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo").append(") as valorTotalExame ");
        buf.append("       ,req.req_total as valorTotal ");
        buf.append("       ,req.req_totpago as valorPago ");
        buf.append("   from requisicao      req ");
        buf.append("   join paciente        pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join medico          med on req.fil_codigo = med.fil_codigo and req.med_conselho = med.med_conselho and req.med_crm = med.med_crm and req.med_uf = med.med_uf ");
        buf.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("   join examematcoleta  emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("   join exames          exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("   join materialcoleta  mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        buf.append("   join convenios       con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("  where req.fil_codigo = ").append(this.textFilial.getText());
        buf.append("    and req.pac_codigo = ").append(paciente);
        buf.append("    and NOT req.req_excluida ");
        buf.append("    and NOT exr.exr_excluido ");
        buf.append("    and req.req_total > 0 ");
        buf.append("  order by req.req_codigo ");
        this.requisicoes.clear();
        SplashMensagem splash = null;
        try {
            splash = SplashMensagem.getInstancia(this);
            splash.mostrar("Buscando dados. Aguarde...");
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            int aux = -1;
            String nomePaciente = null;
            Integer codigoPaciente = null;
            while (rs.next()) {
                RequisicaoBasica requisicao = null;
                if (aux != rs.getInt("codigoRequisicao")) {
                    requisicao = new RequisicaoBasica(rs.getInt("codigoRequisicao"), rs.getInt("codigoPaciente"), rs.getString("nomePaciente"), rs.getDate("dataRequisicao"), rs.getString("conselhoMedico"), rs.getString("crmMedico"), rs.getString("ufMedico"), rs.getString("nomeMedico"), rs.getString("nomePagador"), rs.getString("cpfPagador"), rs.getBigDecimal("valorTotal"), rs.getBigDecimal("valorPago"));
                    nomePaciente = rs.getString("nomePaciente");
                    codigoPaciente = rs.getInt("codigoPaciente");
                    this.requisicoes.add(requisicao);
                    aux = rs.getInt("codigoRequisicao");
                }
                do {
                    if (aux != rs.getInt("codigoRequisicao")) {
                        rs.previous();
                        break;
                    }
                    ExameBasico exame = new ExameBasico(rs.getInt("ordemExame"), rs.getString("codigoExame"), rs.getString("descricaoExame"), rs.getString("descricaoMaterial"), rs.getBigDecimal("valorTotalExame"));
                    if (requisicao == null) continue;
                    requisicao.addExame(exame);
                } while (rs.next());
                this.buscaPagamentos(requisicao);
            }
            if (this.requisicoes.size() > 0) {
                this.textPesquisa.setText(codigoPaciente == null ? "" : codigoPaciente.toString());
                this.labelPesquisa.setText(nomePaciente == null ? "" : nomePaciente);
                ScreenUtil.requisitarFoco(this.buttonCarregar);
            } else {
                Funcoes.mensagem(this, "Nenhum pagamento localizado para o paciente.", 2);
            }
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados do paciente.\n" + sqle.getMessage(), sqle.getStackTrace());
            this.novo();
            return;
        }
        finally {
            if (splash != null) {
                splash.apagar();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDadosPagador(String pagador) {
        if (!this.validaCampos()) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select req.req_codigo as codigoRequisicao ");
        buf.append("       ,req.pac_codigo as codigoPaciente ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.med_conselho as conselhoMedico ");
        buf.append("       ,req.med_crm as crmMedico ");
        buf.append("       ,req.med_uf as ufMedico ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("       ,COALESCE(pac.pac_nomepagador, pac.pac_nome) as nomePagador ");
        buf.append("       ,COALESCE(pac.pac_cpfpagador, pac.pac_cpf) as cpfPagador ");
        buf.append("       ,exr.exr_ordem as ordemExame ");
        buf.append("       ,exr.exa_codigo as codigoExame ");
        buf.append("       ,exa.exa_descricao as descricaoExame ");
        buf.append("       ,mco.mco_descricao as descricaoMaterial ");
        buf.append("       ,calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exr.exa_codigo, exr.mco_codigo, false, false, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo").append(") as valorTotalExame ");
        buf.append("       ,req.req_total as valorTotal ");
        buf.append("       ,req.req_totpago as valorPago ");
        buf.append("   from requisicao      req ");
        buf.append("   join paciente        pac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join medico          med on req.fil_codigo = med.fil_codigo and req.med_conselho = med.med_conselho and req.med_crm = med.med_crm and req.med_uf = med.med_uf ");
        buf.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("   join examematcoleta  emc on exr.fil_codigo = emc.fil_codigo and exr.exa_codigo = emc.exa_codigo and exr.mco_codigo = emc.mco_codigo ");
        buf.append("   join exames          exa on exr.fil_codigo = exa.fil_codigo and exr.exa_codigo = exa.exa_codigo ");
        buf.append("   join materialcoleta  mco on exr.fil_codigo = mco.fil_codigo and exr.mco_codigo = mco.mco_codigo ");
        buf.append("   join convenios       con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        buf.append("  where req.fil_codigo = ").append(this.textFilial.getText());
        buf.append("    and (pac.pac_cpfpagador = '").append(pagador).append("' ");
        buf.append("         or pac_cpf = '").append(pagador).append("') ");
        buf.append("\t\tand req.req_total > 0 ");
        buf.append("\t\tand NOT req.req_excluida ");
        buf.append("  order by req.req_codigo ");
        this.requisicoes.clear();
        SplashMensagem splash = null;
        try {
            splash = SplashMensagem.getInstancia(this);
            splash.mostrar("Buscando dados. Aguarde...");
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            int aux = -1;
            String nomePagador = null;
            String cpfPagador = null;
            while (rs.next()) {
                RequisicaoBasica requisicao = null;
                if (aux != rs.getInt("codigoRequisicao")) {
                    requisicao = new RequisicaoBasica(rs.getInt("codigoRequisicao"), rs.getInt("codigoPaciente"), rs.getString("nomePaciente"), rs.getDate("dataRequisicao"), rs.getString("conselhoMedico"), rs.getString("crmMedico"), rs.getString("ufMedico"), rs.getString("nomeMedico"), rs.getString("nomePagador"), rs.getString("cpfPagador"), rs.getBigDecimal("valorTotal"), rs.getBigDecimal("valorPago"));
                    nomePagador = rs.getString("nomePagador");
                    cpfPagador = rs.getString("cpfPagador");
                    this.requisicoes.add(requisicao);
                    aux = rs.getInt("codigoRequisicao");
                }
                do {
                    if (aux != rs.getInt("codigoRequisicao")) {
                        rs.previous();
                        break;
                    }
                    ExameBasico exame = new ExameBasico(rs.getInt("ordemExame"), rs.getString("codigoExame"), rs.getString("descricaoExame"), rs.getString("descricaoMaterial"), rs.getBigDecimal("valorTotalExame"));
                    if (requisicao == null) continue;
                    requisicao.addExame(exame);
                } while (rs.next());
                this.buscaPagamentos(requisicao);
            }
            if (this.requisicoes.size() > 0) {
                this.textPesquisa.setText(cpfPagador == null ? "" : cpfPagador);
                this.labelPesquisa.setText(nomePagador == null ? "" : nomePagador);
                ScreenUtil.requisitarFoco(this.buttonCarregar);
            } else {
                Funcoes.mensagem(this, "Nenhum pagamento localizado para o pagador.", 2);
            }
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados do pagador.\n" + sqle.getMessage(), sqle.getStackTrace());
            this.novo();
            return;
        }
        finally {
            if (splash != null) {
                splash.apagar();
            }
        }
    }

    private void buscaPagamentos(RequisicaoBasica requisicao) {
        if (requisicao == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select distinct req.req_codigo ");
        buf.append("       ,lcx.lcx_datahora as dataHoraLancamento ");
        buf.append("       ,lcx.lcx_tipopagamento as tipoPagamentoLancamento ");
        buf.append("       ,cco.cco_reduzido as reduzidoContaCorrente ");
        buf.append("       ,cco.cco_conta as contaLancamento ");
        buf.append("       ,lcx.usr_codigo as codigoUsuarioLancamento ");
        buf.append("       ,lcx.lcx_valortotal as valorTotalLancamento ");
        buf.append("       ,coalesce(nfi.nfi_nomepagador, lcx.lcx_nomepagador) as nomePagador ");
        buf.append("       ,coalesce(nfi.nfi_cpfpagador, lcx.lcx_cpfpagador) as cpfPagador ");
        buf.append("       ,lcx.lcx_codigo as codigoLancamento ");
        buf.append("       ,lcx.est_codigo as codigoEstacao ");
        buf.append("       ,nfi.nfi_codigo as codigoNotaFiscal ");
        buf.append("       ,nfi.nfi_numero as numeroNotaFiscal ");
        buf.append("       ,nfi.nfi_numerorps as rpsNotaFiscal ");
        buf.append("       ,nfi.ser_codigo as serieNotaFiscal ");
        buf.append("       ,nfi.nfi_situacao as situacaoNotaFiscal");
        buf.append("   from requisicao             req ");
        buf.append("   join requisicaolanctocaixa  rlc on req.fil_codigo = rlc.fil_codigo and req.req_codigo = rlc.req_codigo ");
        buf.append("   join lanctocaixa            lcx on rlc.fil_codigo = lcx.fil_codigo and rlc.lcx_codigo = lcx.lcx_codigo and rlc.est_codigo = lcx.est_codigo ");
        buf.append("   join contacorrente          cco on lcx.fil_codigo = cco.fil_codigo and lcx.cco_reduzido = cco.cco_reduzido ");
        buf.append("   left join baixalanctocaixa  blc on lcx.fil_codigo = blc.fil_codigo and lcx.lcx_codigo = blc.lcx_codigo and lcx.est_codigo = blc.est_codigo ");
        buf.append("   left join baixa             bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo and bxa.bxa_datacancelado IS NULL ");
        buf.append("   left join baixareceberpagar brp on bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo ");
        buf.append("   left join receberpagar      rpg on brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and (rpg.usr_codcancelado IS NULL and rpg.rpg_datacancelado IS NULL) ");
        buf.append("   left join notafiscal        nfi on rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("', '").append("R").append("', '").append("X").append("')) ");
        buf.append("   or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao IN ('");
        buf.append("E").append("', '").append("X").append("', '");
        buf.append("A").append("', '").append("N").append("', '");
        buf.append("S").append("', '");
        buf.append("O").append("', '").append("R").append("' ))) ");
        buf.append("  where req.fil_codigo = ").append(this.textFilial.getText());
        buf.append("    and req.req_codigo = ").append(requisicao.getCodigoRequisicao());
        buf.append("    and NOT req.req_excluida ");
        buf.append("    and (lcx.usr_codcancelado IS NULL and lcx.lcx_datacancelado IS NULL) ");
        buf.append("  order by req.req_codigo ");
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                do {
                    PagamentoBasico pgto = new PagamentoBasico(rs.getInt("codigoLancamento"), rs.getInt("codigoEstacao"), rs.getTimestamp("dataHoraLancamento"), Tipos.tipoPagamento(rs.getString("tipoPagamentoLancamento")), rs.getString("contaLancamento"), rs.getString("codigoUsuarioLancamento"), rs.getBigDecimal("valorTotalLancamento"), rs.getInt("codigoNotaFiscal") == 0 ? null : Integer.valueOf(rs.getInt("codigoNotaFiscal")), rs.getLong("numeroNotaFiscal") == 0L ? null : Long.valueOf(rs.getLong("numeroNotaFiscal")), rs.getLong("rpsNotaFiscal") == 0L ? null : Long.valueOf(rs.getLong("rpsNotaFiscal")), rs.getString("serieNotaFiscal"), rs.getString("nomePagador"), rs.getString("cpfPagador"), rs.getInt("reduzidoContaCorrente"), rs.getString("situacaoNotaFiscal"));
                    requisicao.addPagamento(pgto);
                    if (pgto.getNomePagador() == null || pgto.getCpfPagador() == null) {
                        requisicao.addPagador(new PagadorBasico(requisicao.getNomePagador(), requisicao.getCpfPagador(), pgto.getValorPagamento(), pgto), pgto);
                        continue;
                    }
                    requisicao.addPagador(new PagadorBasico(pgto), pgto);
                } while (rs.next());
            }
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados da requisicao.\n" + sqle.getMessage(), sqle.getStackTrace());
            this.novo();
        }
    }

    protected void limpar() {
        this.textFilial.clear();
        this.labelValorFilial.setText("");
        this.textPesquisa.clear();
        this.labelPesquisa.setText("");
        this.requisicoes.clear();
        this.codigoPesquisa = "";
        this.limparDados();
    }

    private void limparDados() {
        this.labelVlrRequisicao.setText("");
        this.labelVlrPaciente.setText("");
        this.labelVlrData.setText("");
        this.labelVlrMedico.setText("");
        this.labelVlrTotal.setText("");
        this.labelVlrDevedor.setText("");
        ((ModeloGridTable)this.tableRequisicoes.getModel()).clear();
        ((ModeloGridTable)this.tablePagamentos.getModel()).clear();
        ((ModeloGridTable)this.tablePagadores.getModel()).clear();
        ((ModeloGridTable)this.tableExames.getModel()).clear();
    }

    @Override
    public void habilitaBotoes() {
        super.habilitaBotoes();
        if (this.botaoSalvar.isEnabled()) {
            boolean isSelecionado = this.tablePagadores.getSelectedRow() >= 0;
            this.botaoSalvar.setEnabled(isSelecionado);
            if (isSelecionado) {
                PagadorBasico pagador = (PagadorBasico)this.tablePagadores.getModel().getValueAt(this.tablePagadores.getSelectedRow(), 0);
                boolean temNota = false;
                String situacaoNota = null;
                Long numeroRps = null;
                for (int i = 0; i < this.tablePagamentos.getRowCount(); ++i) {
                    PagamentoBasico pgto = (PagamentoBasico)this.tablePagamentos.getModel().getValueAt(i, 6);
                    if (pgto.getCpfPagador() == null || !pgto.getCpfPagador().equals(pagador.getCpfPagador()) || pgto.getCodigoNotaFiscal() == null || pagador.getCodigoNotaFiscal() == null || pgto.getCodigoNotaFiscal().intValue() != pagador.getCodigoNotaFiscal().intValue()) continue;
                    temNota = true;
                    situacaoNota = pgto.getSituacaoNotaFiscal();
                    numeroRps = pgto.getRpsNotaFiscal();
                    break;
                }
                if (temNota && situacaoNota != null && (numeroRps == null && situacaoNota.equalsIgnoreCase("A") || situacaoNota.equalsIgnoreCase("I") || situacaoNota.equalsIgnoreCase("X") || numeroRps != null && situacaoNota.equalsIgnoreCase("X") || situacaoNota.equalsIgnoreCase("A") || situacaoNota.equalsIgnoreCase("C") || situacaoNota.equalsIgnoreCase("O") || situacaoNota.equalsIgnoreCase("R") || situacaoNota.equalsIgnoreCase("E") || situacaoNota.equalsIgnoreCase("S"))) {
                    this.botaoSalvar.setText("Visualizar Nota Fiscal");
                    this.botaoSalvar.setMnemonic('V');
                    this.botaoNovo.setEnabled(true);
                } else {
                    this.botaoSalvar.setText("Gerar Nota Fiscal");
                    this.botaoSalvar.setMnemonic('G');
                }
            }
        }
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isCarregandoDados = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isCarregandoDados = false;
        this.controlaCampos();
    }

    class JanelaEdicaoPagador
    extends JDialog {
        JLabel labelNome;
        TTextField textNome;
        JLabel labelCpf;
        TTextField textCpf;
        JButton buttonOK;
        JButton buttonCancelar;
        boolean isOk;

        public boolean getOk() {
            return this.isOk;
        }

        public String getNome() {
            return this.textNome.getText();
        }

        public String getCpf() {
            return this.textCpf.getText();
        }

        public JanelaEdicaoPagador(Frame owner, String nome, String cpf) {
            super(owner, true);
            this.labelNome = new JLabel("Nome:");
            this.textNome = new TTextField(100, 3);
            this.labelCpf = new JLabel("CPF:");
            this.textCpf = new TTextField(14, 8);
            this.buttonOK = new JButton("OK");
            this.buttonCancelar = new JButton("Cancelar");
            this.isOk = false;
            this.textNome.setText(nome);
            this.textCpf.setText(cpf);
            this.montaTela();
        }

        public JanelaEdicaoPagador(Dialog owner, String nome, String cpf) {
            super(owner, true);
            this.labelNome = new JLabel("Nome:");
            this.textNome = new TTextField(100, 3);
            this.labelCpf = new JLabel("CPF:");
            this.textCpf = new TTextField(14, 8);
            this.buttonOK = new JButton("OK");
            this.buttonCancelar = new JButton("Cancelar");
            this.isOk = false;
            this.textNome.setText(nome);
            this.textCpf.setText(cpf);
            this.montaTela();
        }

        public void montaTela() {
            this.setTitle("Alterar dados do pagador");
            this.setResizable(false);
            this.setSize(new Dimension(450, 100));
            ScreenUtil.centralizar(this);
            this.textCpf.setMinimumSize(new Dimension(120, 20));
            this.textCpf.setPreferredSize(new Dimension(120, 20));
            this.textNome.setMinimumSize(new Dimension(20, 20));
            this.textNome.setPreferredSize(new Dimension(20, 20));
            this.getContentPane().setLayout(new BorderLayout());
            JPanel panelPrinc = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(5, 0, 0, 0);
            c.fill = 2;
            panelPrinc.add((Component)this.labelNome, c);
            ++c.gridx;
            c.weightx = 1.0;
            panelPrinc.add((Component)this.textNome, c);
            ++c.gridx;
            c.weightx = 0.0;
            c.insets = new Insets(5, 20, 0, 0);
            panelPrinc.add((Component)this.labelCpf, c);
            ++c.gridx;
            c.insets = new Insets(5, 0, 0, 0);
            panelPrinc.add((Component)this.textCpf, c);
            this.textCpf.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (!(e.isTemporary() || Funcoes.textoVazio(JanelaEdicaoPagador.this.textCpf.getText().trim()) || ValidaDoc.checkDoc(JanelaEdicaoPagador.this.textCpf.getText(), 8))) {
                        Funcoes.mensagem(ImprimirNotaFiscalPessoaFisica.this, "O CPF informado \u00e9 inv\u00e1lido.", 2);
                        JanelaEdicaoPagador.this.textCpf.selectAll();
                        ScreenUtil.requisitarFoco(JanelaEdicaoPagador.this.textCpf);
                    }
                }
            });
            this.buttonOK.setMnemonic('O');
            this.buttonCancelar.setMnemonic('C');
            JPanel panelBotoes = new JPanel(new FlowLayout(2));
            panelBotoes.add(this.buttonOK);
            panelBotoes.add(this.buttonCancelar);
            this.getContentPane().add((Component)panelPrinc, "Center");
            this.getContentPane().add((Component)panelBotoes, "South");
            Funcoes.montaEnter((JComponent)panelPrinc);
            Funcoes.montaEnter((JComponent)panelBotoes);
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == JanelaEdicaoPagador.this.buttonOK) {
                        boolean podeSalvarSemPagador = Acesso.getAcesso(ImprimirNotaFiscalPessoaFisica.getModuloSalvarSemInformarPagador());
                        if (Funcoes.textoVazio(JanelaEdicaoPagador.this.textNome) && !podeSalvarSemPagador) {
                            Funcoes.mensagem(JanelaEdicaoPagador.this, "O nome do pagador deve ser informado.", 2);
                            ScreenUtil.requisitarFoco(JanelaEdicaoPagador.this.textNome);
                            return;
                        }
                        if (Funcoes.textoVazio(JanelaEdicaoPagador.this.textCpf.getText().trim()) && !podeSalvarSemPagador) {
                            Funcoes.mensagem(JanelaEdicaoPagador.this, "O CPF do pagador deve ser informado.", 2);
                            ScreenUtil.requisitarFoco(JanelaEdicaoPagador.this.textCpf);
                            return;
                        }
                        if (!Funcoes.textoVazio(JanelaEdicaoPagador.this.textCpf.getText().trim()) && !ValidaDoc.checkDoc(JanelaEdicaoPagador.this.textCpf.getText(), 8)) {
                            Funcoes.mensagem(ImprimirNotaFiscalPessoaFisica.this, "O CPF informado \u00e9 inv\u00e1lido.", 2);
                            JanelaEdicaoPagador.this.textCpf.selectAll();
                            ScreenUtil.requisitarFoco(JanelaEdicaoPagador.this.textCpf);
                            return;
                        }
                        JanelaEdicaoPagador.this.isOk = true;
                    } else {
                        JanelaEdicaoPagador.this.isOk = false;
                    }
                    JanelaEdicaoPagador.this.setVisible(false);
                }
            };
            this.buttonOK.addActionListener(actionListener);
            this.buttonCancelar.addActionListener(actionListener);
        }
    }

    private static enum TipoPesquisa {
        PAGADOR(0, "Pagador"),
        PACIENTE(1, "Paciente"),
        REQUISICAO(2, "Requisi\u00e7\u00e3o");

        public Integer codigo = null;
        public String descricao = null;

        private TipoPesquisa(int codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }
}

