/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.ExameBasico;
import jalis.laboratorio.financeiro.faturamento.ImprimirNotaFiscal;
import jalis.laboratorio.financeiro.faturamento.PagadorBasico;
import jalis.laboratorio.financeiro.faturamento.PagamentoBasico;
import jalis.laboratorio.financeiro.faturamento.RequisicaoBasica;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.service.cadastro.PacienteService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.service.financeiro.faturamento.ImprimirNotaFiscalEmpresaService;
import jalis.util.DBUtil;
import jalis.util.FocusTraversalOnArray;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.ValidaDoc;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImprimirNotaFiscalEmpresa
extends FrmCadPadrao
implements ThreadFinalizadaListener {
    public static final Long ACESSO_ACESSAR = Long.parseLong("0600301100");
    public static final Long NAO_PERMITIR_ALTERAR_SERIE = Long.parseLong("0600301101");
    private static final String PESQUISA_EMPRESA = "Empresa";
    private static final String PESQUISA_REQUISICAO = "Requisi\u00e7\u00e3o";
    private static final int COLUNA_PGTO_DATA = 0;
    private static final int COLUNA_PGTO_TIPO = 1;
    private static final int COLUNA_PGTO_DESCRICAO = 2;
    private static final int COLUNA_PGTO_USUARIO = 3;
    private static final int COLUNA_PGTO_VALOR = 4;
    private static final int COLUNA_PGTO_NOTA = 5;
    private static final int COLUNA_PGTO_OBJETO = 6;
    private static final int TEMPO_TIMER = 30000;
    public static final String TEXTO_FORMULARIO = "Imprimir Notas Fiscais para Empresa";
    public static final String TEXTO_DESCRICAO = "Imprime a nota fiscal para empresa";
    public static final String TEXTO_FORMULARIO_NOTA = "Nota Fiscal para Empresa";
    public static final String TEXTO_DESCRICAO_NOTA = "Emiss\u00e3o e impress\u00e3o de notas fiscais para empresa";
    public static final String PATH_ICONE = "financeiro/nota_fiscal_empresa.jpg";
    private JTable tableRequisicoes;
    private JTable tableExames;
    private JTable tablePagamentos;
    private JPanel painelPesquisa = new JPanel();
    private JPanel painelDados = new JPanel();
    private JPanel painelExames = new JPanel();
    private JPanel painelPagamentos = new JPanel();
    private JPanel painelRequisicoes = new JPanel();
    private Border titled = BorderFactory.createTitledBorder("");
    private TTextField textFilial = new TTextField(8, 1);
    private JButton buttonBuscaFilial = ComponenteFactory.novoJButton(null, new Dimension(20, 20), new Dimension(20, 20), true);
    private JLabel labelFilial = ComponenteFactory.novoJLabel("Filial:", 'f', null, this.textFilial);
    private JLabel labelValorFilial = ComponenteFactory.novoJLabel("", new Dimension(100, 20), this.titled);
    private TTextField textPesquisa = new TTextField(14, 1);
    private JLabel labelPesquisa = new JLabel("");
    private JLabel labelVlrEmpresa = new JLabel("");
    private JLabel labelVlrRequisicao = new JLabel("");
    private JLabel labelVlrData = new JLabel("");
    private JLabel labelVlrColetador = new JLabel("");
    private JLabel labelVlrDevedor = new JLabel("");
    private JLabel labelVlrTotal = new JLabel("");
    private JButton buttonPesquisa = new JButton("");
    private JButton buttonCarregar = new JButton("Carregar");
    private JComboBox comboTipoPesquisa = new JComboBox<Object>(new Object[]{"Empresa", "Requisi\u00e7\u00e3o"});
    private Timer timer = null;
    private boolean isCarregandoDados = false;
    private boolean dadosCarregados = false;
    private List<RequisicaoBasica> requisicoes = new ArrayList<RequisicaoBasica>();
    private String codigoPesquisa = "";
    private Integer[] guias;
    private final ImprimirNotaFiscalEmpresaService service = new ImprimirNotaFiscalEmpresaService();

    public ImprimirNotaFiscalEmpresa() {
        this.construirTela();
    }

    private void construirTela() {
        Funcoes.criaBarraDescricao(this, TEXTO_FORMULARIO, TEXTO_DESCRICAO, PATH_ICONE);
        ScreenUtil.setBorda(new Component[]{this.labelPesquisa, this.painelDados, this.labelVlrEmpresa, this.labelVlrRequisicao, this.labelVlrData, this.labelVlrColetador, this.labelVlrDevedor, this.labelVlrTotal}, new TitledBorder(""));
        this.adicionarBotoes();
        Funcoes.imagemPesquisa(this.buttonPesquisa);
        this.painelCentral.setLayout(new BorderLayout());
        this.construirPainelPesquisa();
        this.construirPainelDados();
        this.construirPainelRequisicoes();
        this.adicionarAcoes();
        this.montaTimer();
        this.setFocusTraversalPolicy(new FocusTraversalOnArray(new Component[]{this.comboTipoPesquisa, this.textPesquisa, this.buttonCarregar, this.tableRequisicoes}));
        this.controlaCampos();
    }

    private void montaTimer() {
        this.timer = new Timer(30000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ImprimirNotaFiscalEmpresa.this.isCarregandoDados && ImprimirNotaFiscalEmpresa.this.dadosCarregados) {
                    ImprimirNotaFiscalEmpresa.this.carregaDados();
                }
            }
        });
        this.timer.setRepeats(true);
    }

    private void construirPainelPesquisa() {
        this.painelPesquisa.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.painelPesquisa.add((Component)this.labelFilial, gbc);
        this.textFilial.setPreferredSize(new Dimension(90, 20));
        this.textFilial.setMinimumSize(new Dimension(90, 20));
        ScreenUtil.requisitarFoco(this.textFilial);
        ++gbc.gridx;
        this.painelPesquisa.add((Component)this.textFilial, gbc);
        ++gbc.gridx;
        this.painelPesquisa.add((Component)this.buttonBuscaFilial, gbc);
        ++gbc.gridx;
        gbc.gridwidth = 5;
        gbc.fill = 2;
        this.labelValorFilial.setPreferredSize(new Dimension(90, 20));
        this.labelValorFilial.setMinimumSize(new Dimension(90, 20));
        this.painelPesquisa.add((Component)this.labelValorFilial, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        this.comboTipoPesquisa.setPreferredSize(new Dimension(130, 20));
        this.comboTipoPesquisa.setMinimumSize(new Dimension(130, 20));
        this.painelPesquisa.add((Component)this.comboTipoPesquisa, gbc);
        this.textPesquisa.setPreferredSize(new Dimension(100, 20));
        this.textPesquisa.setMinimumSize(new Dimension(100, 20));
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.fill = 0;
        this.painelPesquisa.add((Component)this.textPesquisa, gbc);
        this.textPesquisa.setColumns(10);
        this.buttonPesquisa.setFocusable(false);
        this.buttonPesquisa.setPreferredSize(new Dimension(20, 20));
        this.buttonPesquisa.setMinimumSize(new Dimension(20, 20));
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.gridx = 5;
        gbc.gridy = 1;
        this.painelPesquisa.add((Component)this.buttonPesquisa, gbc);
        this.labelPesquisa.setPreferredSize(new Dimension(20, 20));
        this.labelPesquisa.setMinimumSize(new Dimension(20, 20));
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.gridx = 6;
        gbc.gridy = 1;
        this.painelPesquisa.add((Component)this.labelPesquisa, gbc);
        this.buttonCarregar.setMnemonic('a');
        this.buttonCarregar.setMargin(new Insets(1, 1, 1, 1));
        this.buttonCarregar.setPreferredSize(new Dimension(80, 20));
        this.buttonCarregar.setMinimumSize(new Dimension(80, 20));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.anchor = 17;
        gbc.gridx = 7;
        gbc.gridy = 1;
        this.painelPesquisa.add((Component)this.buttonCarregar, gbc);
        this.painelCentral.add((Component)this.painelPesquisa, "North");
    }

    private void construirPainelDados() {
        this.painelDados.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.painelDados.add((Component)new JLabel("Requisi\u00e7\u00e3o:"), gbc);
        this.labelVlrEmpresa.setMinimumSize(new Dimension(20, 20));
        this.labelVlrEmpresa.setPreferredSize(new Dimension(20, 20));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 2;
        gbc.gridwidth = 4;
        gbc.anchor = 17;
        gbc.gridx = 3;
        gbc.gridy = 0;
        this.painelDados.add((Component)this.labelVlrEmpresa, gbc);
        this.labelVlrRequisicao.setHorizontalAlignment(4);
        this.labelVlrRequisicao.setMinimumSize(new Dimension(90, 20));
        this.labelVlrRequisicao.setPreferredSize(new Dimension(90, 20));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 0;
        this.painelDados.add((Component)this.labelVlrRequisicao, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.painelDados.add((Component)new JLabel("Data:"), gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 20, 0, 0);
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 0;
        this.painelDados.add((Component)new JLabel("Empresa:"), gbc);
        this.labelVlrData.setMinimumSize(new Dimension(90, 20));
        this.labelVlrData.setPreferredSize(new Dimension(90, 20));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 1;
        this.painelDados.add((Component)this.labelVlrData, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 20, 0, 0);
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 1;
        this.painelDados.add((Component)new JLabel("Coletador:"), gbc);
        this.labelVlrColetador.setMinimumSize(new Dimension(20, 20));
        this.labelVlrColetador.setPreferredSize(new Dimension(20, 20));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 4;
        this.painelDados.add((Component)this.labelVlrColetador, gbc);
        this.tableExames = new JTable(new ModeloGridTable(new String[]{"#", "C\u00f3digo", "Exame", "Material", "Valor"}));
        ((ModeloGridTable)this.tableExames.getModel()).setColumnSize(new int[]{25, 60, 0, 90, 80}, this.tableExames);
        this.painelExames.setBorder(new TitledBorder(null, "Exames", 4, 2, null, null));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.weighty = 1.0;
        gbc.gridwidth = 7;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 3;
        this.painelDados.add((Component)this.painelExames, gbc);
        this.painelExames.setLayout(new BorderLayout());
        this.painelExames.add(new JScrollPane(this.tableExames));
        this.tablePagamentos = new JTable(new ModeloGridTable(new String[]{"Data", "Tipo", "Conta", "Usu\u00e1rio", "Valor", "Nota"}));
        ((ModeloGridTable)this.tablePagamentos.getModel()).setColumnSize(new int[]{150, 70, 0, 0, 80, 40}, this.tablePagamentos);
        this.tablePagamentos.getSelectionModel().setSelectionMode(2);
        this.painelPagamentos.setBorder(new TitledBorder(null, "Pagamentos", 4, 2, null, null));
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.weighty = 1.0;
        gbc.gridwidth = 7;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 4;
        this.painelDados.add((Component)this.painelPagamentos, gbc);
        this.painelPagamentos.setLayout(new BorderLayout());
        this.painelPagamentos.add(new JScrollPane(this.tablePagamentos));
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.painelDados.add((Component)new JLabel("Total:"), gbc);
        this.labelVlrTotal.setHorizontalAlignment(4);
        this.labelVlrTotal.setPreferredSize(new Dimension(90, 20));
        this.labelVlrTotal.setMinimumSize(new Dimension(90, 20));
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 2;
        this.painelDados.add((Component)this.labelVlrTotal, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 20, 0, 0);
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.gridy = 2;
        this.painelDados.add((Component)new JLabel("Devedor:"), gbc);
        this.labelVlrDevedor.setHorizontalAlignment(4);
        this.labelVlrDevedor.setPreferredSize(new Dimension(90, 20));
        this.labelVlrDevedor.setMinimumSize(new Dimension(90, 20));
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        gbc.gridx = 3;
        gbc.gridy = 2;
        this.painelDados.add((Component)this.labelVlrDevedor, gbc);
        this.painelCentral.add((Component)this.painelDados, "Center");
    }

    private void construirPainelRequisicoes() {
        this.painelRequisicoes.setLayout(new BorderLayout());
        this.tableRequisicoes = new JTable(new ModeloGridTable(new String[]{PESQUISA_REQUISICAO, "RPS - N\u00famero NF"}));
        ((ModeloGridTable)this.tableRequisicoes.getModel()).setColumnSize(new int[]{60, 0}, this.tableRequisicoes);
        this.tableRequisicoes.setColumnSelectionAllowed(false);
        this.tableRequisicoes.setRowSelectionAllowed(true);
        this.tableRequisicoes.setFont(this.getFont().deriveFont(10.0f));
        this.tableRequisicoes.getTableHeader().setFont(this.tableRequisicoes.getTableHeader().getFont().deriveFont(10.0f));
        JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
        scrollRequisicoes.setHorizontalScrollBarPolicy(31);
        scrollRequisicoes.setPreferredSize(new Dimension(210, 20));
        scrollRequisicoes.setMinimumSize(new Dimension(210, 20));
        this.painelRequisicoes.add(scrollRequisicoes);
        this.painelCentral.add((Component)this.painelRequisicoes, "West");
    }

    private void adicionarBotoes() {
        this.botaoEditar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.botaoSalvar.setText("Visualizar Nota Fiscal");
        this.botaoSalvar.setMnemonic('V');
    }

    private void adicionarAcoes() {
        this.tableRequisicoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int aux = ImprimirNotaFiscalEmpresa.this.tableRequisicoes.getSelectedRow();
                if (aux >= 0) {
                    RequisicaoBasica requisicao = (RequisicaoBasica)ImprimirNotaFiscalEmpresa.this.tableRequisicoes.getModel().getValueAt(aux, 0);
                    ImprimirNotaFiscalEmpresa.this.preencheDadosRequisicao(requisicao);
                }
                if (!ImprimirNotaFiscalEmpresa.this.isCarregandoDados) {
                    ImprimirNotaFiscalEmpresa.this.habilitaBotoes();
                    ImprimirNotaFiscalEmpresa.this.controlaCampos();
                }
            }
        });
        this.buttonPesquisa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImprimirNotaFiscalEmpresa.this.pesquisar();
            }
        });
        this.buttonBuscaFilial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImprimirNotaFiscalEmpresa.this.buscaFilial();
            }
        });
        this.textPesquisa.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ImprimirNotaFiscalEmpresa.this.pesquisar();
                }
            }
        });
        this.buttonCarregar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImprimirNotaFiscalEmpresa.this.carregaDados();
            }
        });
        this.textFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ImprimirNotaFiscalEmpresa.this.buscaFilial();
                }
            }
        });
        this.textFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.getSource() == ImprimirNotaFiscalEmpresa.this.textFilial) {
                    ImprimirNotaFiscalEmpresa.this.labelValorFilial.setText(ImprimirNotaFiscalEmpresa.this.getDescricaoFilial(ImprimirNotaFiscalEmpresa.this.textFilial.getText()));
                }
            }
        });
        this.textPesquisa.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ImprimirNotaFiscalEmpresa.this.codigoPesquisa = ImprimirNotaFiscalEmpresa.this.textPesquisa.getText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!ImprimirNotaFiscalEmpresa.this.validaCampos()) {
                    return;
                }
                if (ImprimirNotaFiscalEmpresa.this.comboTipoPesquisa.getSelectedItem().equals(ImprimirNotaFiscalEmpresa.PESQUISA_REQUISICAO)) {
                    ImprimirNotaFiscalEmpresa.this.processarNumeroTubo(null, ImprimirNotaFiscalEmpresa.this.textPesquisa);
                }
                if (Funcoes.textoVazio(ImprimirNotaFiscalEmpresa.this.textPesquisa)) {
                    ImprimirNotaFiscalEmpresa.this.limparDados();
                    return;
                }
                if (ImprimirNotaFiscalEmpresa.this.codigoPesquisa.equals(ImprimirNotaFiscalEmpresa.this.textPesquisa.getText())) {
                    return;
                }
                ImprimirNotaFiscalEmpresa.this.pesquisar(ImprimirNotaFiscalEmpresa.this.textPesquisa.getText());
            }
        });
    }

    private String getDescricaoFilial(String filial) {
        if (Funcoes.textoVazio(filial)) {
            return "N\u00e3o cadastrado";
        }
        try {
            filial = StringUtil.removeZerosEsquerda(filial);
            this.textFilial.setText(filial);
            return DBUtil.getDescricao("fil_codigo", "fil_descricao", filial, "filiais_postocoleta", true);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da filial.\n" + e.getMessage(), e.getStackTrace());
            return "N\u00e3o cadastrado";
        }
    }

    private void carregaDados() {
        int selecaoRequisicao = this.tableRequisicoes.getSelectedRow();
        int selecaoExame = this.tableExames.getSelectedRow();
        int selecaoPagamento = this.tablePagamentos.getSelectedRow();
        if (!this.dadosCarregados) {
            this.limparDados();
        }
        if (Funcoes.textoVazio(this.textPesquisa)) {
            Funcoes.mensagem(this, "A empresa/requisi\u00e7\u00e3o deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textPesquisa);
            return;
        }
        if (this.comboTipoPesquisa.getSelectedItem().equals(PESQUISA_EMPRESA)) {
            this.carregarDadosEmpresa();
        }
        if (this.comboTipoPesquisa.getSelectedItem().equals(PESQUISA_REQUISICAO)) {
            this.carregarDadosRequisicao();
        }
        this.preencheListaRequisicoes();
        this.controlaCampos();
        if (selecaoRequisicao >= 0) {
            this.tableRequisicoes.getSelectionModel().setSelectionInterval(selecaoRequisicao, selecaoRequisicao);
        }
        if (selecaoExame >= 0) {
            this.tableExames.getSelectionModel().setSelectionInterval(selecaoExame, selecaoExame);
        }
        if (selecaoPagamento >= 0) {
            this.tablePagamentos.getSelectionModel().setSelectionInterval(selecaoPagamento, selecaoPagamento);
        }
        this.habilitaBotoes();
        this.controlaCampos();
    }

    private void preencheListaRequisicoes() {
        ModeloGridTable modeloAux = null;
        if (this.requisicoes != null && this.requisicoes.size() > 0) {
            modeloAux = new ModeloGridTable(new String[]{PESQUISA_REQUISICAO, "RPS - N\u00famero NF"});
            for (int i = 0; i < this.requisicoes.size(); ++i) {
                modeloAux.addLine(new Object[]{this.requisicoes.get(i), this.requisicoes.get(i).getListaRpsNotaFiscal().toString() + " - " + this.requisicoes.get(i).getListaNumeroNotaFiscal().toString()});
            }
            this.tableRequisicoes.setModel(modeloAux);
            ((ModeloGridTable)this.tableRequisicoes.getModel()).setColumnSize(new int[]{60, 0}, this.tableRequisicoes);
            this.tableRequisicoes.setColumnSelectionAllowed(false);
            this.tableRequisicoes.setRowSelectionAllowed(true);
            this.tableRequisicoes.setFont(this.getFont().deriveFont(10.0f));
            this.tableRequisicoes.getTableHeader().setFont(this.tableRequisicoes.getTableHeader().getFont().deriveFont(10.0f));
            modeloAux.ordenarColuna(0, -1);
            this.preencheDadosRequisicao(this.requisicoes.get(0));
            this.dadosCarregados = true;
        }
        if (modeloAux != null && modeloAux.getRowCount() > 0) {
            this.tableRequisicoes.getSelectionModel().setSelectionInterval(0, 0);
        }
        ScreenUtil.requisitarFoco(this.tableRequisicoes);
    }

    private void preencheDadosRequisicao(RequisicaoBasica requisicao) {
        if (requisicao == null) {
            return;
        }
        this.labelVlrRequisicao.setText(requisicao.getCodigoRequisicao().toString());
        this.labelVlrEmpresa.setText(requisicao.getNomePaciente());
        this.labelVlrData.setText(requisicao.getDataRequisicao() == null ? "" : Funcoes.formataData("dd/MM/yyyy", requisicao.getDataRequisicao()));
        this.labelVlrColetador.setText((requisicao.getConselhoMedico() == null ? "" : requisicao.getConselhoMedico()) + " " + (requisicao.getCrmMedico() == null ? "" : requisicao.getCrmMedico()) + " " + (requisicao.getUfMedico() == null ? "" : requisicao.getUfMedico()) + " - " + (requisicao.getNomeMedico() == null ? "" : requisicao.getNomeMedico()));
        this.labelVlrTotal.setText(Funcoes.formataDecimal(requisicao.getValorTotal() == null ? 0.0 : requisicao.getValorTotal().doubleValue()));
        this.labelVlrDevedor.setText(Funcoes.formataDecimal(requisicao.getValorDevido() == null ? 0.0 : requisicao.getValorDevido().doubleValue()));
        ModeloGridTable modeloExameAux = new ModeloGridTable(new String[]{"#", "C\u00f3digo", "Exame", "Material", "Valor"});
        ArrayList<ExameBasico> exames = requisicao.exames;
        modeloExameAux.clear();
        for (int i = 0; i < exames.size(); ++i) {
            ExameBasico exame = exames.get(i);
            modeloExameAux.addLine(new Object[]{exame.ordemExame, exame.codigoExame, exame.descricaoExame, exame.descricaoMaterial, Funcoes.formataDecimal(exame.valorTotalExame == null ? 0.0 : exame.valorTotalExame.doubleValue())});
        }
        modeloExameAux.ordenarColunaSemTrocarSentido(0);
        this.tableExames.setModel(modeloExameAux);
        ((ModeloGridTable)this.tableExames.getModel()).setColumnSize(new int[]{25, 60, 0, 90, 80}, this.tableExames);
        ModeloGridTable modeloPagamentoAux = new ModeloGridTable(new String[]{"Data", "Tipo", "Conta", "Usu\u00e1rio", "Valor", "Nota"});
        ArrayList<PagamentoBasico> pagamentos = requisicao.pagamentos;
        modeloPagamentoAux.clear();
        for (int i = 0; i < pagamentos.size(); ++i) {
            PagamentoBasico pagamento = pagamentos.get(i);
            modeloPagamentoAux.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm:ss", pagamento.getDataPagamento()), pagamento.getTipoPagamento(), pagamento.getDescricaoContaPagamento(), pagamento.getUsuarioPagamento(), Funcoes.formataDecimal(pagamento.getValorPagamento().doubleValue()), pagamento.getNumeroNotaFiscal(), pagamento});
        }
        modeloPagamentoAux.ordenarColunaSemTrocarSentido(0);
        this.tablePagamentos.setModel(modeloPagamentoAux);
        ((ModeloGridTable)this.tablePagamentos.getModel()).setColumnSize(new int[]{130, 130, 0, 150, 80, 120}, this.tablePagamentos);
        if (requisicao.getValorDevido() == null || requisicao.getValorDevido().compareTo(BigDecimal.ZERO) > 0) {
            this.labelVlrDevedor.setForeground(Color.RED);
        } else {
            this.labelVlrDevedor.setForeground(Color.BLACK);
        }
    }

    private void carregarDadosEmpresa() {
        this.requisicoes.clear();
        SplashMensagem splash = null;
        try {
            splash = SplashMensagem.getInstancia(this);
            splash.mostrar("Buscando dados. Aguarde...");
            this.requisicoes = this.service.getRequisicoesPorEmpresa(this.textFilial.getText(), this.textPesquisa.getText());
            if (this.requisicoes.size() > 0) {
                ScreenUtil.requisitarFoco(this.buttonCarregar);
            } else {
                Funcoes.mensagem(this, "Nenhum pagamento localizado para a empresa.", 2);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os dados da empresa.\n".concat(e.getMessage()), e.getStackTrace());
            this.novo();
            return;
        }
        finally {
            if (splash != null) {
                splash.apagar();
            }
        }
    }

    private void carregarDadosRequisicao() {
        this.requisicoes.clear();
        String codFilial = this.textFilial.getText();
        String codRequisicao = this.textPesquisa.getText();
        try {
            if (this.guias.length == 0) {
                this.guias = RecepcaoUtil.verificaMultiGuias(codFilial, codRequisicao, true);
                if (this.guias.length > 1) {
                    String mensagemGuia = RecepcaoUtil.mensagemMultiGuias(codFilial, codRequisicao.toString());
                    mensagemGuia = mensagemGuia + "\nDeseja adicionar multiguias?";
                    if (Funcoes.mensagem(Laboratorio.getInstancia(), mensagemGuia.toString(), 4) == 1) {
                        this.guias = new Integer[]{Integer.valueOf(codRequisicao)};
                    }
                }
            }
            this.requisicoes = this.service.getRequisicoesPorCodigo(codFilial, this.guias);
            if (this.requisicoes.size() > 0) {
                ScreenUtil.requisitarFoco(this.buttonCarregar);
            } else {
                Funcoes.mensagem(this, "Nenhuma requisi\u00e7\u00e3o encontrada ou requisi\u00e7\u00e3o sem pagamento em balc\u00e3o.", 2);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da requisicao.\n" + e.getMessage(), e.getStackTrace());
            this.novo();
        }
    }

    private synchronized void controlaCampos() {
        boolean enabled = this.getStatus() == 2 && !this.isCarregandoDados;
        boolean requisicaoSelecionada = this.requisicoes.size() > 0 && this.tableRequisicoes.getSelectedRow() >= 0;
        boolean existePagamento = this.tablePagamentos.getRowCount() > 0;
        this.textFilial.setEnabled(enabled && this.requisicoes.size() == 0);
        this.comboTipoPesquisa.setEnabled(enabled && this.requisicoes.size() == 0);
        this.textPesquisa.setEnabled(enabled && this.requisicoes.size() == 0);
        this.buttonPesquisa.setEnabled(enabled && this.requisicoes.size() == 0);
        this.buttonCarregar.setEnabled(enabled && this.requisicoes.size() == 0);
        this.tableRequisicoes.setEnabled(enabled && this.requisicoes.size() > 0);
        this.botaoSalvar.setEnabled(enabled && requisicaoSelecionada && existePagamento);
    }

    private void pesquisar() {
        if (this.comboTipoPesquisa.getSelectedItem().equals(PESQUISA_EMPRESA)) {
            PacienteVO pacienteVO = new PacienteVO();
            pacienteVO = (PacienteVO)new PacienteService().pesquisaEmpresaVO(Laboratorio.getInstancia(), pacienteVO, "Pesquisando empresas", true, this.textFilial.getText());
            this.limparDados();
            if (pacienteVO != null) {
                this.textPesquisa.setText(String.valueOf(pacienteVO.getCodigo()));
                this.labelPesquisa.setText(pacienteVO.getNome());
                ScreenUtil.requisitarFoco(this.buttonCarregar);
            } else {
                this.labelPesquisa.setText("N\u00e3o cadastrado");
                ScreenUtil.requisitarFoco(this.textPesquisa);
            }
        } else {
            Hashtable resultado = Pesquisas.requisicao(Laboratorio.getInstancia(), this.textFilial.getText(), false, false, false);
            this.limparDados();
            if (resultado != null) {
                this.textPesquisa.setText(String.valueOf(resultado.get("req_codigo")));
                this.labelPesquisa.setText(String.valueOf(resultado.get("pac_nome")));
                ScreenUtil.requisitarFoco(this.buttonCarregar);
            } else {
                this.labelPesquisa.setText("N\u00e3o cadastrado");
                ScreenUtil.requisitarFoco(this.textPesquisa);
            }
        }
    }

    private void pesquisar(String codigo) {
        String nomePaciente = "";
        if (this.comboTipoPesquisa.getSelectedItem().equals(PESQUISA_EMPRESA)) {
            PacienteVO paciente = null;
            try {
                paciente = (PacienteVO)new PacienteService().getVO(this.textFilial.getText(), codigo);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Paciente n\u00e3o identificado.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
            nomePaciente = paciente != null ? paciente.getNome() : "";
            this.labelPesquisa.setText(nomePaciente);
        } else {
            try {
                nomePaciente = this.service.getNomePacientePorRequisicao(this.textFilial.getText(), codigo);
                this.labelPesquisa.setText(nomePaciente);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                return;
            }
        }
    }

    private void buscaFilial() {
        Hashtable table = Pesquisas.filial(this.getTopLevelAncestor(), false);
        if (table != null) {
            this.textFilial.setText(table.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isCarregandoDados = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isCarregandoDados = false;
        this.controlaCampos();
    }

    @Override
    public void novo() {
        this.limpar();
        this.setStatus(2);
        this.textFilial.setText(Variaveis.filialPadrao);
        this.labelValorFilial.setText(this.getDescricaoFilial(this.textFilial.getText()));
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    @Override
    public void salvar() {
        List<RequisicaoBasica> requisicoes = this.getRequisicoesSelecionadas();
        Optional<Integer> codEmpresa = requisicoes.stream().map(r -> r.getCodigoPaciente()).findAny();
        PacienteVO empresa = this.service.getEmpresaPorCodigo(codEmpresa.get());
        if (empresa != null && empresa.getCodigo() > 0) {
            String tipoPessoa = empresa.getTipoPessoa();
            int tipoDoc = tipoPessoa.equals("F") ? 8 : 7;
            String numDoc = tipoPessoa.equals("F") ? empresa.getCpf() : empresa.getCNPJ();
            String mensagem = String.format("%s da empresa inv\u00e1lido.", tipoPessoa.equals("F") ? "CPF" : "CNPJ");
            if (!ValidaDoc.checkDoc(numDoc, tipoDoc)) {
                Funcoes.mensagem(this, mensagem, 2);
                return;
            }
            BigDecimal valorPago = this.calcularValorPago(requisicoes);
            ArrayList<PagamentoBasico> pagamentos = new ArrayList<PagamentoBasico>();
            for (RequisicaoBasica req : requisicoes) {
                req.getPagamentos().forEach(p -> pagamentos.add((PagamentoBasico)p));
            }
            RequisicaoBasica requisicao = (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(this.tableRequisicoes.getSelectedRow(), 0);
            Optional pag = requisicao.getPagamentos().stream().findFirst();
            PagadorBasico pagadorBasico = null;
            pagadorBasico = new PagadorBasico((PagamentoBasico)pag.get());
            pagadorBasico.setCpfPagador(numDoc);
            pagadorBasico.setValorPago(valorPago);
            pagadorBasico.setRequisicao(requisicao);
            pagadorBasico.setPagamentos(pagamentos);
            Optional<PagamentoBasico> pagamento = requisicao.getPagamentos().stream().filter(p -> p.getCodigoNotaFiscal() != null && p.getCodigoNotaFiscal() > 0).findAny();
            if (pagamento.isPresent()) {
                this.visualizarNotaFiscal(this.tableRequisicoes.getSelectedRow(), pagamento.get().getCodigoNotaFiscal());
            } else {
                this.gerarNotaFiscal(requisicao, pagadorBasico, this.getNumeroMultiguias(requisicoes));
            }
        }
    }

    private Integer[] getNumeroMultiguias(List<RequisicaoBasica> requisicoes) {
        Integer[] guias = new Integer[requisicoes.size()];
        for (int i = 0; i < requisicoes.size(); ++i) {
            guias[i] = requisicoes.get(i).getCodigoRequisicao();
        }
        return guias;
    }

    private List<RequisicaoBasica> getRequisicoesSelecionadas() {
        ArrayList<RequisicaoBasica> requisicoesSelecionadas = new ArrayList<RequisicaoBasica>();
        if (this.isMultiguia()) {
            for (int i = 0; i < this.tableRequisicoes.getRowCount(); ++i) {
                RequisicaoBasica requisicao = (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(i, 0);
                if (!requisicao.getListaRpsNotaFiscal().isEmpty()) continue;
                requisicoesSelecionadas.add(requisicao);
            }
        }
        if (requisicoesSelecionadas.isEmpty()) {
            RequisicaoBasica requisicao = (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(this.tableRequisicoes.getSelectedRow(), 0);
            requisicoesSelecionadas.add(requisicao);
        }
        return requisicoesSelecionadas;
    }

    private BigDecimal calcularValorPago(List<RequisicaoBasica> requisicoesSelecionadas) {
        BigDecimal valorPago = BigDecimal.ZERO;
        if (this.isMultiguia()) {
            for (RequisicaoBasica requisicao : requisicoesSelecionadas) {
                valorPago = valorPago.add(requisicao.getPagamentos().stream().map(p -> p.getValorPagamento()).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        } else {
            RequisicaoBasica requisicao = (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(this.tableRequisicoes.getSelectedRow(), 0);
            valorPago = requisicao.getPagamentos().stream().map(p -> p.getValorPagamento()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return valorPago;
    }

    private boolean isMultiguia() {
        return this.comboTipoPesquisa.getSelectedItem().equals(PESQUISA_REQUISICAO) && this.tableRequisicoes.getRowCount() > 1;
    }

    private void gerarNotaFiscal(RequisicaoBasica requisicao, PagadorBasico pagadorBasico, Integer[] multiguia) {
        NotaFiscalBean notaBean = this.service.gerarNotaFiscal(this.textFilial.getText(), multiguia, pagadorBasico);
        if (notaBean != null) {
            if (this.comboTipoPesquisa.getSelectedItem().equals(PESQUISA_REQUISICAO)) {
                requisicao.getListaNumeroNotaFiscal().add(notaBean.getNumero());
                requisicao.getListaRpsNotaFiscal().add(notaBean.getNumeroRps());
                requisicao.getListaSerieNotaFiscal().add(notaBean.getSerie().getCodigo());
            } else {
                requisicao = this.comboTipoPesquisa.getSelectedItem().equals(PESQUISA_REQUISICAO) ? (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(0, 0) : (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(this.tableRequisicoes.getSelectedRow(), 0);
                requisicao.getListaCodigoNotaFiscal().add(notaBean.getCodigo());
                requisicao.getListaNumeroNotaFiscal().add(notaBean.getNumero());
                requisicao.getListaRpsNotaFiscal().add(notaBean.getNumeroRps());
                requisicao.getListaSerieNotaFiscal().add(notaBean.getSerie().getCodigo());
                ((ModeloGridTable)this.tableRequisicoes.getModel()).fireTableDataChanged();
            }
            if (notaBean != null) {
                this.carregaDados();
            }
            this.habilitaBotoes();
            this.controlaCampos();
        }
    }

    private void visualizarNotaFiscal(int linhaSelecionada, Integer codigoNotaFiscal) {
        NotaFiscalBean notaBean = null;
        try {
            notaBean = (NotaFiscalBean)new NotaFiscalService().get(this.textFilial.getText(), codigoNotaFiscal.toString());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados da nota fiscal.\n" + e.getMessage(), e.getStackTrace());
        }
        if (notaBean != null) {
            ImprimirNotaFiscal impressao = new ImprimirNotaFiscal(){

                @Override
                public void setVisible(boolean isVisible) {
                    if (!isVisible && this.getParent() != null) {
                        Container comp = this.getParent();
                        while (comp.getParent() != null) {
                            if (!((comp = comp.getParent()) instanceof JDialog)) continue;
                            comp.setVisible(false);
                        }
                    }
                }

                @Override
                public void fechar() {
                    this.setVisible(false);
                    ImprimirNotaFiscalEmpresa.this.carregaDados();
                }
            };
            RequisicaoBasica requisicao = null;
            requisicao = this.comboTipoPesquisa.getSelectedItem().equals(PESQUISA_REQUISICAO) ? (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(0, 0) : (RequisicaoBasica)this.tableRequisicoes.getModel().getValueAt(linhaSelecionada, 0);
            impressao.novo(notaBean, requisicao.getCodigoRequisicao(), true);
            impressao.configurarTelaPessoaFisica();
            impressao.controlaBotoes();
            JDialog dialog = new JDialog((Frame)Laboratorio.getInstancia(), true);
            dialog.setContentPane(impressao);
            dialog.setSize(new Dimension(650, 500));
            dialog.setTitle("Visualizando Nota Fiscal de Pessoa F\u00edsica");
            ScreenUtil.centralizar(dialog);
            dialog.setVisible(true);
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.dadosCarregados = false;
            this.limpar();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.textFilial.getText())) {
            Funcoes.mensagem(this, "Filial n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(this.textFilial);
            return false;
        }
        return true;
    }

    private void limpar() {
        this.guias = new Integer[0];
        this.textFilial.clear();
        this.labelValorFilial.setText("");
        this.textPesquisa.clear();
        this.labelPesquisa.setText("");
        this.requisicoes.clear();
        this.codigoPesquisa = "";
        this.limparDados();
    }

    private void limparDados() {
        this.labelVlrRequisicao.setText("");
        this.labelVlrEmpresa.setText("");
        this.labelVlrData.setText("");
        this.labelVlrColetador.setText("");
        this.labelVlrTotal.setText("");
        this.labelVlrDevedor.setText("");
        ((ModeloGridTable)this.tableRequisicoes.getModel()).clear();
        ((ModeloGridTable)this.tablePagamentos.getModel()).clear();
        ((ModeloGridTable)this.tableExames.getModel()).clear();
    }

    @Override
    public void habilitaBotoes() {
        super.habilitaBotoes();
        if (this.botaoSalvar.isEnabled()) {
            boolean temNota = false;
            String situacaoNota = null;
            Long numeroRps = null;
            for (int i = 0; i < this.tablePagamentos.getRowCount(); ++i) {
                PagamentoBasico pgto = (PagamentoBasico)this.tablePagamentos.getModel().getValueAt(i, 6);
                if (pgto.getCpfPagador() == null || pgto.getCodigoNotaFiscal() == null) continue;
                temNota = true;
                situacaoNota = pgto.getSituacaoNotaFiscal();
                numeroRps = pgto.getRpsNotaFiscal();
                break;
            }
            if (temNota && situacaoNota != null && (numeroRps == null && situacaoNota.equalsIgnoreCase("A") || situacaoNota.equalsIgnoreCase("I") || numeroRps != null && situacaoNota.equalsIgnoreCase("X") || situacaoNota.equalsIgnoreCase("A") || situacaoNota.equalsIgnoreCase("C") || situacaoNota.equalsIgnoreCase("O") || situacaoNota.equalsIgnoreCase("R") || situacaoNota.equalsIgnoreCase("E"))) {
                this.botaoSalvar.setText("Visualizar Nota Fiscal");
                this.botaoSalvar.setMnemonic('V');
                this.botaoNovo.setEnabled(true);
            } else {
                this.botaoSalvar.setText("Gerar Nota Fiscal");
                this.botaoSalvar.setMnemonic('G');
            }
        }
    }

    public static long getModuloAcesso() {
        return ACESSO_ACESSAR;
    }

    @Override
    public void excluir() {
    }

    @Override
    public void editar() {
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }
}

