/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.EstornoCancelamentoNota;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.Date;

public class ImprimirNotaFiscal
extends EstornoCancelamentoNota {
    public ImprimirNotaFiscal() {
        super("Reimprimir Nota Fiscal de Pessoa Jur\u00eddica", "Reimpress\u00e3o de notas fiscais de pessoa jur\u00eddica", true, true, "financeiro/reimprimir_nota_juridica.jpg", 1.0f, true);
        this.buttonImprimir.setVisible(true);
        this.buttonEstornarNF.setVisible(false);
        this.buttonCancelarNF.setVisible(false);
        this.buttonOpcoesNfse.setVisible(true);
    }

    private void marcarNota() {
        StringBuilder buf = new StringBuilder();
        buf.append(" update notafiscal ");
        buf.append("    set nfi_situacao = '").append("I").append("' ");
        buf.append("       ,usr_codimpressao = '").append(Variaveis.login).append("' ");
        buf.append("       ,nfi_datahoraimpressao = '" + Funcoes.formataData("yyyy/MM/dd", new Date()) + " " + Funcoes.formataHora(new Date(), true) + "' ");
        buf.append("  where fil_codigo = ").append(this.notaFiscalBean.getFilial().getCodigo().toString());
        buf.append("    and nfi_codigo = ").append(this.notaFiscalBean.getCodigo().toString());
        int aux = 0;
        try {
            aux = Conexao.executeUpdate(this.notaFiscalBean.getFilial().getCodigo().toString(), Conexao.getStatement(), buf.toString());
            Conexao.arquivaSQL();
            if (aux == 0) {
                throw new SQLException("A situa\u00e7\u00e3o da Nota Fiscal n\u00e3o p\u00f4de ser alterada.");
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ImprimirNotaFiscal:40");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void imprimirNotaFiscal() {
        this.buttonImprimir.setEnabled(false);
        if (this.notaFiscalBean.getSituacao().equals("I")) {
            if (Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal j\u00e1 foi impressa. Deseja reimprimir?", 4) != 0) {
                this.buttonImprimir.setEnabled(true);
                return;
            }
            try {
                new NotaFiscalService().imprimirNotaServico((NotaFiscalVO)this.notaFiscalBean.toVO());
                StringBuilder buf = new StringBuilder();
                buf.append(" update notafiscal ");
                buf.append("    set nfi_datahorareimpressao = '").append(Funcoes.formataData("yyyy/MM/dd", new Date()) + " " + Funcoes.formataHora(new Date(), true) + "' ");
                buf.append("       ,usr_codreimpressao = '").append(Variaveis.login).append("'");
                buf.append("  where nfi_codigo = ").append(this.notaFiscalBean.getCodigo());
                buf.append("    and fil_codigo = ").append(this.notaFiscalBean.getFilial().getCodigo());
                int i = Conexao.executeUpdate(this.notaFiscalBean.getFilial().getCodigo().toString(), Conexao.getStatement(), buf.toString());
                Conexao.arquivaSQL();
                if (i == 0) {
                    throw new SQLException("A nota fiscal " + this.notaFiscalBean.getCodigo() + " n\u00e3o foi encontrada.");
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel atualizar data de reimpress\u00e3o da nota fiscal." + ex.getMessage(), ex.getStackTrace(), "ImprimirNotaFiscal:68");
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {}
            }
        } else {
            try {
                new NotaFiscalService().imprimirNotaServico((NotaFiscalVO)this.notaFiscalBean.toVO());
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel imprimir a Nota Fiscal.\n" + e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        if (this.notaFiscalBean.getNumeroRps() == null) {
            this.marcarNota();
        }
        this.buttonImprimir.setEnabled(true);
        try {
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar altera\u00e7\u00f5es da nota.\n" + e.getMessage(), e.getStackTrace());
        }
        if (!this.isPessoaFisica()) {
            this.cancelar(true);
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600200600");
    }

    @Override
    protected boolean validaNF(NotaFiscalBean bean) {
        if (bean.getSituacao().equals("I")) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal j\u00e1 foi impressa.", 2);
        }
        return super.validaNF(bean);
    }

    @Override
    public void controlaBotoes() {
        if (this.notaFiscalBean != null) {
            this.buttonImprimir.setEnabled(true);
        } else {
            this.buttonImprimir.setEnabled(false);
        }
        super.controlaBotoes();
    }
}

