/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class FiltroDataConvenio
extends AbstractDialogoOKCancelar {
    private final TTextField textDataInicial = new TTextField(10, 4);
    private final TTextField textDataFinal = new TTextField(10, 4);
    private final JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private final JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);

    public FiltroDataConvenio(Frame pai) {
        super(pai, "Filtro");
        this.montaTela(pai);
        ScreenUtil.requisitarFoco(this.textDataInicial);
    }

    private void montaTela(Frame pai) {
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        this.setSize(new Dimension(250, 120));
        this.setLocationRelativeTo(pai);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panelCentral.add((Component)new JLabel("Data inicial:"), c);
        ++c.gridy;
        panelCentral.add((Component)new JLabel("Data final:"), c);
        c.gridx = 1;
        c.gridy = 0;
        this.textDataInicial.setPreferredSize(new Dimension(80, 20));
        this.textDataFinal.setPreferredSize(new Dimension(80, 20));
        c.weightx = 1.0;
        c.fill = 2;
        panelCentral.add((Component)this.textDataInicial, c);
        ++c.gridy;
        panelCentral.add((Component)this.textDataFinal, c);
        this.buttonDataInicial.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFinal.setPreferredSize(new Dimension(20, 20));
        c.weightx = 0.0;
        c.fill = 0;
        c.gridx = 2;
        c.gridy = 0;
        panelCentral.add((Component)this.buttonDataInicial, c);
        ++c.gridy;
        panelCentral.add((Component)this.buttonDataFinal, c);
        this.textDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(FiltroDataConvenio.this.textDataInicial, FiltroDataConvenio.this.buttonDataInicial, FiltroDataConvenio.this.getPanelCentral(), true);
                }
            }
        });
        this.textDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(FiltroDataConvenio.this.textDataFinal, FiltroDataConvenio.this.buttonDataFinal, FiltroDataConvenio.this.getPanelCentral(), true);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, this.getPanelCentral(), true);
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, this.getPanelCentral(), true);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public boolean acaoOk() {
        if (!Funcoes.verificaData(this.textDataInicial.getText()) || !Funcoes.verificaData(this.textDataFinal.getText())) {
            Funcoes.mensagem(this, "Data inv\u00e1lida", 1);
            return false;
        }
        return true;
    }

    public String getDataInicial() {
        return this.textDataInicial.getText();
    }

    public String getDataFinal() {
        return this.textDataFinal.getText();
    }

    public void setDataInicial(String data) {
        if (Funcoes.verificaData(data)) {
            this.textDataInicial.setText(data);
        }
    }

    public void setDataFinal(String data) {
        if (Funcoes.verificaData(data)) {
            this.textDataFinal.setText(data);
        }
    }
}

