/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.CampoResultado;
import jalis.laboratorio.financeiro.faturamento.DialogVencimentoFatura;
import jalis.laboratorio.financeiro.faturamento.FaturaExamesCompacta;
import jalis.laboratorio.financeiro.faturamento.SelecaoRequisicao;
import jalis.laboratorio.util.faturamento.BuscaRequisicoes;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.FilialFaturaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class FaturaLote
extends FrmCadPadrao
implements ActionListener,
KeyListener,
FocusListener,
ListSelectionListener,
TableModelListener {
    private static final long ACESSO_ACESSAR = Long.parseLong("0600201100");
    private static final long ACESSO_INCLUIR = Long.parseLong("0600201101");
    private static final String PARAMETROS_FATURA_LOTE = "FaturaLote.ultimoFiltro";
    private JButton buttonAdicionar = new JButton("Adicionar");
    private JButton buttonConvenio = new JButton();
    private JButton buttonPesquisar = new JButton();
    private JComboBox comboPesquisar = new JComboBox<Object>(new DefaultComboBoxModel<Object>(new Object[]{ItensCombo.Requisicao, ItensCombo.Guia_Requisicao, ItensCombo.Guia}));
    private JLabel labelConvenio = new JLabel("Conv\u00eanio:");
    private JLabel labelPaciente = new JLabel();
    private JLabel labelPesquisar = new JLabel("Pesquisar:");
    private JLabel labelVlrConvenio = new JLabel();
    private JPanel panelRequisicoes = new JPanel(new BorderLayout());
    private JPanel panelExames = new JPanel(new BorderLayout());
    private TTextField textConvenio = new TTextField(10, 1);
    private TTextField textRequisicaoGuia = new TTextField(20, 3);
    private JScrollPane scrollRequisicoes = new JScrollPane();
    private JScrollPane scrollExames = new JScrollPane();
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"#", "Requisi\u00e7\u00e3o", "Paciente", "Conv\u00eanio", "Guia"});
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"Sel.", "C\u00f3digo", "Exame", "Material", "Guia"}){

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(c);
        }
    };
    private JTable tableRequisicoes = new JTable(this.modeloRequisicoes);
    private JTable tableExames = new JTable(this.modeloExames);
    private ConvenioVO convenioSelecionado = null;
    private DadosFaturamento requisicaoAdicionando = null;
    private final int COLUNA_NUMERO_REQUISICAO = 0;
    private final int COLUNA_CODIGO_REQUISICAO = 1;
    private final int COLUNA_PACIENTE_REQUISICAO = 2;
    private final int COLUNA_CONVENIO_REQUISICAO = 3;
    private final int COLUNA_GUIA_REQUISICAO = 4;
    private final int COLUNA_OBJETO_REQUISICAO = 5;
    private final int COLUNA_SELECAO_EXAME = 0;
    private final int COLUNA_CODIGO_EXAME = 1;
    private final int COLUNA_DESCRICAO_EXAME = 2;
    private final int COLUNA_MATERIAL_EXAME = 3;
    private final int COLUNA_GUIA_EXAME = 4;
    private final int COLUNA_OBJETO_EXAME = 5;
    private boolean alterandoExames = false;

    public FaturaLote() {
        this.montaTela();
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    private void montaTela() {
        Funcoes.criaBarraDescricao(this, "Faturamento por Lote", "Busca de exames a faturar por requisi\u00e7\u00e3o/guia", "financeiro/faturamento_lote.jpg");
        ScreenUtil.setBorda(new Component[]{this.labelVlrConvenio, this.labelPaciente}, new TitledBorder(""));
        this.botaoExcluir.setVisible(false);
        this.botaoEditar.setVisible(false);
        this.botaoSalvar.setText("Faturar");
        this.botaoSalvar.setMnemonic('t');
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.labelConvenio.setDisplayedMnemonic('o');
        this.labelConvenio.setLabelFor(this.textConvenio);
        this.painelCentral.add((Component)this.labelConvenio, c);
        this.textConvenio.setPreferredSize(new Dimension(50, 20));
        c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        this.textConvenio.setPreferredSize(new Dimension(115, 20));
        this.textConvenio.setMinimumSize(new Dimension(115, 20));
        this.painelCentral.add((Component)this.textConvenio, c);
        this.buttonConvenio.setPreferredSize(new Dimension(20, 20));
        this.buttonConvenio.setMinimumSize(new Dimension(20, 20));
        this.buttonConvenio.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonConvenio);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        this.painelCentral.add((Component)this.buttonConvenio, c);
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 0;
        c.gridwidth = 4;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.labelVlrConvenio.setPreferredSize(new Dimension(20, 20));
        this.labelVlrConvenio.setMinimumSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.labelVlrConvenio, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 17;
        this.labelPesquisar.setDisplayedMnemonic('P');
        this.labelPesquisar.setLabelFor(this.comboPesquisar);
        this.painelCentral.add((Component)this.labelPesquisar, c);
        this.comboPesquisar.setPreferredSize(new Dimension(120, 20));
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.anchor = 17;
        c.gridwidth = 2;
        this.comboPesquisar.setPreferredSize(new Dimension(135, 20));
        this.comboPesquisar.setMinimumSize(new Dimension(135, 20));
        this.painelCentral.add((Component)this.comboPesquisar, c);
        this.textRequisicaoGuia.setPreferredSize(new Dimension(80, 20));
        c = new GridBagConstraints();
        c.gridx = 3;
        c.gridy = 1;
        c.gridwidth = 2;
        c.anchor = 17;
        c.gridwidth = 1;
        this.textRequisicaoGuia.setPreferredSize(new Dimension(100, 20));
        this.textRequisicaoGuia.setMinimumSize(new Dimension(100, 20));
        this.painelCentral.add((Component)this.textRequisicaoGuia, c);
        this.buttonPesquisar.setPreferredSize(new Dimension(20, 20));
        this.buttonPesquisar.setMinimumSize(new Dimension(20, 20));
        this.buttonPesquisar.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonPesquisar);
        c = new GridBagConstraints();
        c.gridx = 4;
        c.gridy = 1;
        c.anchor = 17;
        this.painelCentral.add((Component)this.buttonPesquisar, c);
        c = new GridBagConstraints();
        c.gridx = 5;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        c.weightx = 1.0;
        this.labelPaciente.setPreferredSize(new Dimension(20, 20));
        this.labelPaciente.setMinimumSize(new Dimension(20, 20));
        this.painelCentral.add((Component)this.labelPaciente, c);
        this.buttonAdicionar.setMargin(new Insets(0, 0, 0, 0));
        this.buttonAdicionar.setPreferredSize(new Dimension(90, 20));
        this.buttonAdicionar.setMinimumSize(new Dimension(90, 20));
        this.buttonAdicionar.setMnemonic('A');
        c = new GridBagConstraints();
        c.gridx = 6;
        c.gridy = 1;
        c.anchor = 17;
        this.painelCentral.add((Component)this.buttonAdicionar, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 7;
        c.fill = 1;
        c.anchor = 17;
        c.weighty = 1.0;
        this.painelCentral.add((Component)this.panelRequisicoes, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 7;
        c.fill = 1;
        c.anchor = 17;
        c.weighty = 1.0;
        this.painelCentral.add((Component)this.panelExames, c);
        this.scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
        this.scrollExames = new JScrollPane(this.tableExames);
        this.panelRequisicoes.setBorder(new TitledBorder("Requisi\u00e7\u00f5es (F3)"));
        this.panelRequisicoes.add((Component)this.scrollRequisicoes, "Center");
        this.panelExames.setBorder(new TitledBorder("Exames (F4)"));
        this.panelExames.add((Component)this.scrollExames, "Center");
        this.tableRequisicoes.setSelectionMode(0);
        this.tableExames.setSelectionMode(0);
        this.tableRequisicoes.getTableHeader().addMouseListener(this.modeloRequisicoes);
        this.tableExames.getTableHeader().addMouseListener(this.modeloExames);
        this.modeloRequisicoes.setColumnSize(new int[]{30, 120, 0, 0, 120}, this.tableRequisicoes);
        this.modeloExames.setColumnSize(new int[]{45, 80, 0, 150, 120}, this.tableExames);
        this.tableRequisicoes.getSelectionModel().addListSelectionListener(this);
        this.tableRequisicoes.addKeyListener(this);
        this.tableExames.addKeyListener(this);
        this.modeloExames.addTableModelListener(this);
        this.buttonConvenio.addActionListener(this);
        this.buttonPesquisar.addActionListener(this);
        this.textConvenio.addFocusListener(this);
        this.textRequisicaoGuia.addFocusListener(this);
        this.textConvenio.addKeyListener(this);
        this.textRequisicaoGuia.addKeyListener(this);
        this.buttonAdicionar.addActionListener(this);
        this.tableRequisicoes.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "sair");
        this.tableRequisicoes.getActionMap().put("sair", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        });
        this.tableExames.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "sair");
        this.tableExames.getActionMap().put("sair", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        });
        this.painelCentral.getInputMap(0).put(KeyStroke.getKeyStroke("F3"), "tecla_F3");
        this.painelCentral.getInputMap(2).put(KeyStroke.getKeyStroke("F3"), "tecla_F3");
        this.painelCentral.getInputMap(1).put(KeyStroke.getKeyStroke("F3"), "tecla_F3");
        this.painelCentral.getActionMap().put("tecla_F3", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FaturaLote.this.tableRequisicoes.getSelectedRow() == -1 && FaturaLote.this.tableRequisicoes.getRowCount() > 0) {
                    FaturaLote.this.tableRequisicoes.getSelectionModel().setSelectionInterval(0, 0);
                }
                ScreenUtil.requisitarFoco(FaturaLote.this.tableRequisicoes);
            }
        });
        this.painelCentral.getInputMap(0).put(KeyStroke.getKeyStroke("F4"), "tecla_F4");
        this.painelCentral.getInputMap(2).put(KeyStroke.getKeyStroke("F4"), "tecla_F4");
        this.painelCentral.getInputMap(1).put(KeyStroke.getKeyStroke("F4"), "tecla_F4");
        this.painelCentral.getActionMap().put("tecla_F4", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FaturaLote.this.tableExames.getSelectedRow() == -1 && FaturaLote.this.tableExames.getRowCount() > 0) {
                    FaturaLote.this.tableExames.getSelectionModel().setSelectionInterval(0, 0);
                }
                ScreenUtil.requisitarFoco(FaturaLote.this.tableExames);
            }
        });
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textConvenio);
        this.comboPesquisar.addFocusListener(this);
        this.modeloRequisicoes.ordenarColunaSemTrocarSentido(0);
        this.modeloExames.ordenarColunaSemTrocarSentido(4);
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.carregaParametrosUsuario();
        ScreenUtil.requisitarFoco(this.textConvenio);
    }

    private void carregaParametrosUsuario() {
        String tmp;
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_FATURA_LOTE);
        if (!Funcoes.textoVazio(parametros) && !Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "campoPesquisa"))) {
            if (tmp.equalsIgnoreCase(ItensCombo.Requisicao.toString())) {
                this.comboPesquisar.setSelectedItem((Object)ItensCombo.Requisicao);
            } else if (tmp.equalsIgnoreCase(ItensCombo.Guia_Requisicao.toString())) {
                this.comboPesquisar.setSelectedItem((Object)ItensCombo.Guia_Requisicao);
            } else if (tmp.equalsIgnoreCase(ItensCombo.Guia.toString())) {
                this.comboPesquisar.setSelectedItem((Object)ItensCombo.Guia);
            }
        }
    }

    private void gravaParametrosUsuario() {
        String param = "<campoPesquisa>" + this.comboPesquisar.getSelectedItem().toString() + "</campoPesquisa>";
        ParametrosUsuarios.setValor(PARAMETROS_FATURA_LOTE, param);
        ParametrosUsuarios.salvarParametros(true);
    }

    private void limparCampos() {
        this.textConvenio.clear();
        this.labelVlrConvenio.setText("");
        this.textRequisicaoGuia.clear();
        this.labelPaciente.setText("");
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
        this.convenioSelecionado = null;
        this.requisicaoAdicionando = null;
    }

    @Override
    public void salvar() {
        if (!this.validaCampos()) {
            return;
        }
        DialogVencimentoFatura dialogVencimento = new DialogVencimentoFatura((Window)this.getTopLevelAncestor(), null);
        ScreenUtil.centralizar(dialogVencimento);
        dialogVencimento.setVisible(true);
        if (!dialogVencimento.getOK()) {
            return;
        }
        Date vencimento = dialogVencimento.getVencimento();
        ArrayList<DadosFaturamento> lista = this.getDadosFaturar();
        try {
            int row = this.tableRequisicoes.getSelectedRow();
            JDialog dialog = new JDialog();
            FaturaExamesCompacta faturamento = new FaturaExamesCompacta(dialog, lista, vencimento, this.convenioSelecionado);
            faturamento.setBorder(ScreenUtil.criarBordaVazia());
            dialog.setSize(650, 550);
            dialog.setResizable(false);
            dialog.setModal(true);
            dialog.setContentPane(faturamento);
            dialog.setDefaultCloseOperation(0);
            dialog.setVisible(true);
            if (faturamento.getRetorno() != null) {
                this.novo();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void atualizaDadosAposFaturar() {
        DadosFaturamento requisicao;
        int i;
        if (this.haExamesNaoFaturados()) {
            int resp = Funcoes.mensagem(this, "H\u00e1 exames n\u00e3o selecionados do faturamento atual.\nDeseja criar um novo faturamento com os dados desses exames?", 4, true);
            if (resp == 1) {
                this.novo();
                return;
            }
        } else {
            this.novo();
            return;
        }
        ArrayList<DadosFaturamento> listaRequisicoes = new ArrayList<DadosFaturamento>();
        for (i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
            requisicao = (DadosFaturamento)this.modeloRequisicoes.getValueAt(i, 5);
            listaRequisicoes.add(requisicao);
        }
        this.modeloRequisicoes.clear();
        for (i = 0; i < listaRequisicoes.size(); ++i) {
            requisicao = (DadosFaturamento)listaRequisicoes.get(i);
            ArrayList listaClone = (ArrayList)requisicao.getExames().clone();
            requisicao.getExames().clear();
            for (int j = 0; j < listaClone.size(); ++j) {
                DadosExameFaturamento exame = (DadosExameFaturamento)listaClone.get(j);
                if (exame == null || exame.getFaturado()) continue;
                requisicao.adicionaExame(exame);
            }
            if (requisicao.getExamesCount() <= 0) continue;
            this.modeloRequisicoes.addLine(new Object[]{this.modeloRequisicoes.getRowCount() + 1, requisicao.getRequisicao(), requisicao.getNomePaciente(), requisicao.getConvenioFantasia(), requisicao.getGuiaPrincipal(), requisicao});
        }
        this.modeloRequisicoes.ordenarColunaSemTrocarSentido(this.modeloRequisicoes.getColunaOrdenacao());
        this.controlaCampos();
        this.tableRequisicoes.getSelectionModel().setSelectionInterval(0, 0);
    }

    @Override
    public void cancelar() {
        if (!this.haExamesNaoFaturados() || Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    @Deprecated
    public void excluir() {
    }

    @Override
    @Deprecated
    public void editar() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || !this.haExamesNaoFaturados() || this.haExamesNaoFaturados() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    private boolean haExamesNaoFaturados() {
        for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
            DadosFaturamento requisicao = (DadosFaturamento)this.modeloRequisicoes.getValueAt(i, 5);
            for (int j = 0; j < requisicao.getExamesCount(); ++j) {
                DadosExameFaturamento exame = requisicao.getExame(j);
                if (exame.getFaturado()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean validaCampos() {
        ArrayList<DadosFaturamento> lista = this.getDadosFaturar();
        if (lista == null) {
            Funcoes.mensagem(this, "Nenhum exame selecionado para faturamento.", 2);
            return false;
        }
        return true;
    }

    private ArrayList<DadosFaturamento> getDadosFaturar() {
        ArrayList<DadosFaturamento> listaRetorno = new ArrayList<DadosFaturamento>();
        for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
            DadosFaturamento requisicao = (DadosFaturamento)this.modeloRequisicoes.getValueAt(i, 5);
            DadosFaturamento requisicaoClone = requisicao.clone();
            if (requisicaoClone.getExamesCount() <= 0) continue;
            listaRetorno.add(requisicaoClone);
            Collections.sort(requisicaoClone.getExames(), new Comparator<DadosExameFaturamento>(){

                @Override
                public int compare(DadosExameFaturamento o1, DadosExameFaturamento o2) {
                    return o1.getOrdemExame().compareTo(o2.getOrdemExame());
                }
            });
        }
        if (listaRetorno.size() > 0) {
            return listaRetorno;
        }
        return null;
    }

    @Override
    @Deprecated
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    @Deprecated
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    public static long getModuloAcesso() {
        return ACESSO_ACESSAR;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonConvenio) {
            this.buscaConvenio();
        } else if (e.getSource() == this.buttonPesquisar) {
            this.buscaRequisicao();
        } else if (e.getSource() == this.buttonAdicionar) {
            this.adicionarRequisicao();
        }
    }

    private void buscaRequisicao() {
        Hashtable hash = Pesquisas.requisicao(this.getTopLevelAncestor(), Variaveis.filialPadrao, false, true, null, null, this.convenioSelecionado.getCodigo().toString(), false, false, false, false);
        if (hash != null) {
            this.comboPesquisar.setSelectedItem((Object)ItensCombo.Requisicao);
            this.textRequisicaoGuia.setText(hash.get("req_codigo").toString());
            this.labelPaciente.setText(hash.get("pac_nome").toString());
        } else {
            this.textRequisicaoGuia.clear();
            this.labelPaciente.setText("");
        }
        ScreenUtil.requisitarFoco(this.textRequisicaoGuia);
    }

    private void buscaConvenio() {
        Hashtable conv = Pesquisas.convenio(Laboratorio.getInstancia(), Variaveis.filialPadrao, true, false);
        if (conv != null) {
            try {
                StringBuilder where = new StringBuilder();
                where.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                where.append("   and con_codigo = ").append(conv.get("con_codigo"));
                Set convenio = new ConvenioService().loadVO(where.toString());
                if (convenio != null && convenio.size() > 0) {
                    ConvenioVO auxVO = (ConvenioVO)convenio.iterator().next();
                    this.textConvenio.setText(auxVO.getCodigo().toString());
                    this.preencheDadosConvenio(auxVO);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Conv\u00eanio n\u00e3o identificado.\n" + e.getMessage(), e.getStackTrace());
            }
        } else {
            this.preencheDadosConvenio(null);
        }
    }

    private void buscaConvenio(String filial, String codigoConvenio) {
        try {
            StringBuilder where = new StringBuilder();
            where.append(" where fil_codigo = ").append(filial);
            where.append("   and con_codigo = ").append(codigoConvenio);
            Set convenio = new ConvenioService().loadVO(where.toString());
            Set filiais = new FilialFaturaService().loadVO(where.toString());
            if (convenio != null && convenio.size() > 0) {
                ConvenioVO auxVO = (ConvenioVO)convenio.iterator().next();
                this.textConvenio.setText(auxVO.getCodigo().toString());
                this.preencheDadosConvenio(auxVO);
            } else {
                this.preencheDadosConvenio(null);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "Conv\u00eanio n\u00e3o identificado.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void preencheDadosConvenio(ConvenioVO convenioVO) {
        this.convenioSelecionado = convenioVO;
        if (convenioVO != null) {
            this.labelVlrConvenio.setText(convenioVO.getFantasia());
        } else {
            this.labelVlrConvenio.setText("");
            this.textRequisicaoGuia.clear();
            this.labelVlrConvenio.setText("N\u00e3o cadastrado");
        }
        this.controlaCampos();
        if (this.convenioSelecionado != null) {
            ScreenUtil.requisitarFoco(this.comboPesquisar);
        } else if (!Funcoes.textoVazio(this.textConvenio.getText())) {
            this.textConvenio.selectAll();
            ScreenUtil.requisitarFoco(this.textConvenio);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 113) {
            if (e.getSource() == this.textConvenio) {
                this.buscaConvenio();
            } else if (e.getSource() == this.textRequisicaoGuia) {
                this.buscaRequisicao();
            }
        } else if (e.getKeyCode() == 32) {
            if (e.getSource() == this.tableExames) {
                this.selecaoExame();
            }
        } else if (e.getKeyCode() == 127 && e.getSource() == this.tableRequisicoes) {
            this.removerRequisicao();
        }
    }

    private void selecaoExame() {
        int col = this.tableExames.getSelectedColumn();
        int row = this.tableExames.getSelectedRow();
        if (row > -1) {
            DadosExameFaturamento exame = (DadosExameFaturamento)this.modeloExames.getValueAt(row, 5);
            if (col != 0) {
                this.modeloExames.setValueAt(!exame.getFaturar(), row, 0);
            }
        }
    }

    private void acaoSelecionar(int col, int row, DadosExameFaturamento exame) {
        int resp;
        boolean acao = exame.getFaturar();
        String guiaAtual = exame.getCodigoGuia();
        int qtde = 0;
        for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
            DadosExameFaturamento aux = (DadosExameFaturamento)this.modeloExames.getValueAt(i, 5);
            if ((guiaAtual == null && aux.getCodigoGuia() == null || guiaAtual != null && aux.getCodigoGuia() != null && guiaAtual.equalsIgnoreCase(aux.getCodigoGuia())) && ++qtde > 1) break;
        }
        if (qtde > 1 && (resp = Funcoes.mensagem(this, "Deseja " + (acao ? "selecionar" : "desselecionar") + " os exames com a mesma guia?", 4, true)) == 0) {
            for (int i = 0; i < this.modeloExames.getRowCount(); ++i) {
                if (i == row) continue;
                DadosExameFaturamento aux = (DadosExameFaturamento)this.modeloExames.getValueAt(i, 5);
                if ((guiaAtual != null || aux.getCodigoGuia() != null) && (guiaAtual == null || aux.getCodigoGuia() == null || !guiaAtual.equalsIgnoreCase(aux.getCodigoGuia()))) continue;
                aux.setFaturar(acao);
                this.modeloExames.setValueAt(acao, i, 0);
            }
        }
        this.controlaCampos();
    }

    private void removerRequisicao() {
        int resp;
        int row = this.tableRequisicoes.getSelectedRow();
        if (row > -1 && (resp = Funcoes.mensagem(this, "Deseja remover a requisi\u00e7\u00e3o?", 4)) == 0) {
            this.modeloRequisicoes.removeLine(row);
        }
    }

    @Override
    @Deprecated
    public void keyTyped(KeyEvent e) {
    }

    @Override
    @Deprecated
    public void keyReleased(KeyEvent e) {
    }

    @Override
    @Deprecated
    public void focusGained(FocusEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pesquisar() {
        if (this.convenioSelecionado == null) {
            Funcoes.mensagem(this, "O conv\u00eanio deve ser selecionado.", 2);
            ScreenUtil.requisitarFoco(this.textConvenio);
            return;
        }
        if (Funcoes.textoVazio(this.textRequisicaoGuia)) {
            Funcoes.mensagem(this, "A requisi\u00e7\u00e3o/guia deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textRequisicaoGuia);
            return;
        }
        SplashMensagem splash = SplashMensagem.getInstancia(this);
        splash.mostrar("Pesquisando, aguarde.");
        try {
            if (this.comboPesquisar.getSelectedItem().equals((Object)ItensCombo.Requisicao)) {
                this.processarNumeroTubo(null, this.textRequisicaoGuia);
            }
            String codigoRequisicao = this.comboPesquisar.getSelectedItem().equals((Object)ItensCombo.Requisicao) ? this.textRequisicaoGuia.getText() : null;
            String guiaRequisicao = this.comboPesquisar.getSelectedItem().equals((Object)ItensCombo.Guia_Requisicao) ? this.textRequisicaoGuia.getText() : null;
            String guiaExame = this.comboPesquisar.getSelectedItem().equals((Object)ItensCombo.Guia) ? this.textRequisicaoGuia.getText() : null;
            BuscaRequisicoes buscaReq = new BuscaRequisicoes();
            String sql = buscaReq.sqlRequisicoes(Conexao.getStatement(), Variaveis.filialPadrao.toString(), this.convenioSelecionado.getCodigo().toString(), codigoRequisicao, guiaRequisicao, guiaExame, true, true);
            ArrayList<DadosFaturamento> listaFat = buscaReq.buscaDadosFaturamento(sql);
            this.verificaDadosEncontrados(listaFat);
            this.limparDadosRequisicoesEncontradas(listaFat);
            if (listaFat != null && listaFat.size() > 0) {
                DadosExameFaturamento exame;
                int i;
                DadosFaturamento requisicao = null;
                if (listaFat.size() > 1) {
                    try {
                        SelecaoRequisicao selecao = new SelecaoRequisicao((Window)this.getTopLevelAncestor(), listaFat);
                        ScreenUtil.centralizar(selecao);
                        selecao.setVisible(true);
                        requisicao = selecao.getRetorno();
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel iniciar a janela de sele\u00e7\u00e3o de requisi\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                        splash.apagar();
                        return;
                    }
                } else {
                    requisicao = listaFat.get(0);
                }
                if (requisicao == null) {
                    this.textRequisicaoGuia.selectAll();
                    ScreenUtil.requisitarFoco(this.textRequisicaoGuia);
                    return;
                }
                if (guiaExame != null) {
                    ArrayList<DadosExameFaturamento> exames = requisicao.getExames();
                    for (i = 0; i < exames.size(); ++i) {
                        exame = exames.get(i);
                        if (exame.getCodigoGuia() == null || exame.getCodigoGuia().equalsIgnoreCase(guiaExame)) continue;
                        exames.remove(exame);
                        --i;
                    }
                }
                DadosFaturamento requisicaoEncontrada = null;
                for (i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                    DadosFaturamento aux = (DadosFaturamento)this.modeloRequisicoes.getValueAt(i, 5);
                    if (requisicao.getRequisicao() != aux.getRequisicao()) continue;
                    requisicaoEncontrada = aux;
                    break;
                }
                if (requisicaoEncontrada != null) {
                    for (i = 0; i < requisicao.getExames().size(); ++i) {
                        exame = requisicao.getExames().get(i);
                        for (int j = 0; j < requisicaoEncontrada.getExames().size(); ++j) {
                            DadosExameFaturamento aux = requisicaoEncontrada.getExames().get(j);
                            if (!exame.getCodigoExame().equalsIgnoreCase(aux.getCodigoExame())) continue;
                            requisicao.getExames().set(i, exame);
                        }
                    }
                }
                if (requisicaoEncontrada != null) {
                    for (i = 0; i < requisicaoEncontrada.getExames().size(); ++i) {
                        exame = requisicaoEncontrada.getExames().get(i);
                        boolean encontrado = false;
                        for (int j = 0; j < requisicao.getExames().size(); ++j) {
                            DadosExameFaturamento aux = requisicao.getExames().get(j);
                            if (!exame.getCodigoExame().equalsIgnoreCase(aux.getCodigoExame())) continue;
                            encontrado = true;
                            break;
                        }
                        if (encontrado) continue;
                        requisicao.adicionaExame(exame);
                    }
                }
                if (requisicao != null) {
                    this.labelPaciente.setText(requisicao.getNomePaciente());
                    this.requisicaoAdicionando = requisicao;
                    this.controlaCampos();
                }
                ScreenUtil.requisitarFoco(this.buttonAdicionar);
            } else {
                this.textRequisicaoGuia.selectAll();
                ScreenUtil.requisitarFoco(this.textRequisicaoGuia);
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar requisi\u00e7\u00f5es.\n" + e1.getMessage(), e1.getStackTrace());
        }
        finally {
            splash.apagar();
        }
    }

    private void verificaDadosEncontrados(ArrayList<DadosFaturamento> lista) {
        int qtdeFaturadas = 0;
        int qtdeNaoFaturar = 0;
        int qtdeOk = 0;
        if (lista != null) {
            for (int i = 0; i < lista.size(); ++i) {
                DadosFaturamento requisicao = lista.get(i);
                ArrayList<DadosExameFaturamento> exames = requisicao.getExames();
                for (int j = 0; exames != null && j < exames.size(); ++j) {
                    DadosExameFaturamento exame = exames.get(j);
                    if (exame.getFaturado()) {
                        ++qtdeFaturadas;
                        continue;
                    }
                    if (!exame.getFaturar()) {
                        ++qtdeNaoFaturar;
                        continue;
                    }
                    ++qtdeOk;
                }
            }
        }
        if (qtdeOk == 0) {
            if (qtdeFaturadas == 0 && qtdeNaoFaturar == 0) {
                Funcoes.mensagem(this, "Requisi\u00e7\u00e3o inexistente.", 2);
            } else {
                StringBuilder buf = new StringBuilder();
                buf.append("Nenhum exame a faturar para a requisi\u00e7\u00e3o.");
                if (qtdeFaturadas == 1) {
                    buf.append("\nFoi encontrado 1 exame faturado.");
                } else if (qtdeFaturadas > 1) {
                    buf.append("\nForam encontrados ").append(qtdeFaturadas).append(" exames faturados.");
                }
                if (qtdeNaoFaturar == 1) {
                    buf.append("\nFoi encontrado 1 exame marcado para n\u00e3o faturar.");
                } else if (qtdeNaoFaturar > 1) {
                    buf.append("\nForam encontrados ").append(qtdeNaoFaturar).append(" exames marcados para n\u00e3o faturar.");
                }
                Funcoes.mensagem(this, buf.toString(), 2);
            }
            this.textRequisicaoGuia.clear();
            ScreenUtil.requisitarFoco(this.textRequisicaoGuia);
        }
    }

    private void limparDadosRequisicoesEncontradas(ArrayList<DadosFaturamento> lista) {
        if (lista != null) {
            for (int i = 0; i < lista.size(); ++i) {
                DadosFaturamento requisicao = lista.get(i);
                if (requisicao == null) continue;
                ArrayList<DadosExameFaturamento> exames = requisicao.getExames();
                for (int j = 0; exames != null && j < exames.size(); ++j) {
                    DadosExameFaturamento exame = exames.get(j);
                    if (!this.isExameRequisicaoInserido(requisicao.getRequisicao(), exame.getCodigoExame(), exame.getCodigoMaterial()) && !exame.getFaturado() && exame.getFaturar()) continue;
                    exames.remove(exame);
                    --j;
                }
                if (requisicao.getExamesCount() != 0) continue;
                lista.remove(requisicao);
                --i;
            }
        }
    }

    private void controlaCampos() {
        boolean enabled = this.getStatus() == 2;
        boolean convenioAux = this.convenioSelecionado != null;
        boolean requisicaoAux = this.requisicaoAdicionando != null;
        this.textConvenio.setEnabled(enabled && this.modeloRequisicoes.getRowCount() == 0);
        this.buttonConvenio.setEnabled(enabled && this.modeloRequisicoes.getRowCount() == 0);
        this.comboPesquisar.setEnabled(enabled && convenioAux);
        this.textRequisicaoGuia.setEnabled(enabled && convenioAux);
        this.buttonPesquisar.setEnabled(enabled && convenioAux);
        this.buttonAdicionar.setEnabled(enabled && requisicaoAux);
        this.botaoSalvar.setEnabled(this.getDadosFaturar() != null);
        this.tableRequisicoes.setFocusable(this.modeloRequisicoes.getRowCount() > 0);
        this.tableExames.setFocusable(this.modeloExames.getRowCount() > 0);
    }

    private void adicionarRequisicao() {
        if (this.requisicaoAdicionando != null) {
            int i;
            int posicao = -1;
            for (i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                DadosFaturamento aux = (DadosFaturamento)this.modeloRequisicoes.getValueAt(i, 5);
                if (aux.getCodigoFilial() != this.requisicaoAdicionando.getCodigoFilial() || aux.getRequisicao() != this.requisicaoAdicionando.getRequisicao()) continue;
                posicao = i;
                break;
            }
            if (posicao > -1) {
                this.modeloRequisicoes.setValueAt(this.requisicaoAdicionando, posicao, 5);
                this.modeloRequisicoes.fireTableDataChanged();
                this.tableRequisicoes.getSelectionModel().setSelectionInterval(posicao, posicao);
            } else {
                this.modeloRequisicoes.addLine(new Object[]{this.modeloRequisicoes.getRowCount() + 1, this.requisicaoAdicionando.getRequisicao(), this.requisicaoAdicionando.getNomePaciente(), this.requisicaoAdicionando.getConvenioFantasia(), this.requisicaoAdicionando.getGuiaPrincipal(), this.requisicaoAdicionando});
                for (i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                    if (Integer.parseInt(this.modeloRequisicoes.getValueAt(i, 0).toString()) != this.modeloRequisicoes.getRowCount()) continue;
                    this.tableRequisicoes.getSelectionModel().setSelectionInterval(i, i);
                    break;
                }
            }
        }
        this.modeloRequisicoes.ordenarColunaSemTrocarSentido(this.modeloRequisicoes.getColunaOrdenacao());
        if (this.requisicaoAdicionando != null) {
            this.selecionarRequisicao(this.requisicaoAdicionando.getRequisicao());
        }
        this.textRequisicaoGuia.clear();
        this.labelPaciente.setText("");
        this.requisicaoAdicionando = null;
        this.gravaParametrosUsuario();
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.textRequisicaoGuia);
    }

    private void selecionarRequisicao(int codigoRequisicao) {
        for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
            DadosFaturamento aux = (DadosFaturamento)this.modeloRequisicoes.getValueAt(i, 5);
            if (codigoRequisicao != aux.getRequisicao()) continue;
            this.tableRequisicoes.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    protected boolean isExameRequisicaoInserido(int codigoRequisicao, String codigoExame, int codigoMaterial) {
        for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
            DadosFaturamento aux = (DadosFaturamento)this.modeloRequisicoes.getValueAt(i, 5);
            if (codigoRequisicao != aux.getRequisicao()) continue;
            for (int j = 0; j < aux.getExamesCount(); ++j) {
                DadosExameFaturamento exame = aux.getExame(j);
                if (!codigoExame.equalsIgnoreCase(exame.getCodigoExame()) || codigoMaterial != exame.getCodigoMaterial()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (!e.isTemporary()) {
            if (e.getSource() == this.textConvenio) {
                if (!Funcoes.textoVazio(this.textConvenio)) {
                    if (this.convenioSelecionado == null || this.convenioSelecionado.getCodigo() != Integer.parseInt(this.textConvenio.getText())) {
                        this.buscaConvenio(Variaveis.filialPadrao.toString(), this.textConvenio.getText());
                    }
                } else {
                    this.preencheDadosConvenio(null);
                }
            } else if (e.getSource() == this.textRequisicaoGuia && e.getOppositeComponent() != this.comboPesquisar) {
                if (!Funcoes.textoVazio(this.textRequisicaoGuia)) {
                    this.pesquisar();
                }
            } else if (e.getSource() == this.comboPesquisar) {
                this.textRequisicaoGuia.setDocument(CampoResultado.Tipo.TEXTO.codigo);
                if (this.comboPesquisar.getSelectedItem().equals((Object)ItensCombo.Requisicao)) {
                    this.textRequisicaoGuia.setDocument(CampoResultado.Tipo.NUMERO.codigo);
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        DadosFaturamento req;
        int row = this.tableRequisicoes.getSelectedRow();
        this.modeloExames.clear();
        if (row > -1 && (req = (DadosFaturamento)this.modeloRequisicoes.getValueAt(row, 5)) != null) {
            ArrayList<DadosExameFaturamento> exames = req.getExames();
            this.alterandoExames = true;
            if (exames != null) {
                for (int i = 0; i < exames.size(); ++i) {
                    DadosExameFaturamento exame = exames.get(i);
                    if (exame == null) continue;
                    this.modeloExames.addLine(new Object[]{exame.getFaturar(), exame.getCodigoExame(), exame.getNomeExame(), exame.getDescricaoMaterial(), exame.getCodigoGuia(), exame});
                }
                this.modeloExames.ordenarColunaSemTrocarSentido(this.modeloExames.getColunaOrdenacao());
                this.alterandoExames = false;
            }
        }
    }

    @Override
    public void tableChanged(final TableModelEvent e) {
        final int row = e.getFirstRow();
        if (row > -1 && this.modeloExames.getRowCount() > row && !this.alterandoExames && e.getType() == 0) {
            final DadosExameFaturamento exame = (DadosExameFaturamento)this.modeloExames.getValueAt(row, 5);
            if (exame != null) {
                exame.setFaturar(!exame.getFaturar());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (row > -1 && e.getColumn() > -1) {
                        FaturaLote.this.alterandoExames = true;
                        FaturaLote.this.acaoSelecionar(e.getColumn(), row, exame);
                        FaturaLote.this.alterandoExames = false;
                    }
                }
            });
        }
    }

    private static enum ItensCombo {
        Requisicao(0, "Requisi\u00e7\u00e3o"),
        Guia_Requisicao(1, "Guia Principal"),
        Guia(2, "Guia dos Exames");

        int codigo = -1;
        String descricao = "";

        private ItensCombo(int codigo, String descricao) {
            this.codigo = codigo;
            this.descricao = descricao;
        }

        public String toString() {
            return this.descricao;
        }
    }
}

