/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.TelaLocalizar;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DadosTotalGeral;
import jalis.comum.informacao.InfoRequisicao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.DialogVencimentoFatura;
import jalis.laboratorio.financeiro.faturamento.FaturaExames;
import jalis.laboratorio.util.faturamento.Calculos;
import jalis.laboratorio.util.faturamento.EditorDadosFaturamento;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.laboratorio.util.faturamento.LinhasTabela;
import jalis.laboratorio.util.faturamento.SelecaoListener;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class FaturaExamesCompacta
extends FaturaExames {
    private JTable tabela = null;
    private LinhasTabela modeloTabela = null;
    private JScrollPane scroll = null;
    private Window owner = null;
    private JMenuItem itemVencimentoFatura = new JMenuItem("Alterar o vencimento da fatura");
    private ArrayList<DadosFaturamento> dados = null;
    private ConvenioVO convenio = null;
    private ArrayList<DadosFaturamento> retorno = null;
    private boolean acessoAlterarTodosCamposEletronico = Acesso.getAcesso(Long.parseLong("0600200115"));

    public FaturaExamesCompacta(final Window owner, ArrayList<DadosFaturamento> dados, Date vencimento, ConvenioVO convenio) throws Exception {
        int i;
        if (dados == null || convenio == null) {
            throw new Exception("Sem dados para construir o faturamento.");
        }
        if (vencimento == null) {
            throw new Exception("A data de vencimento da fatura n\u00e3o foi informada.");
        }
        this.owner = owner;
        this.dados = dados;
        this.convenio = convenio;
        this.dataVencimento = vencimento;
        this.panelEsquerdo.setVisible(false);
        this.itemFiltrarConvenio.setVisible(false);
        this.buttonNovo.setVisible(false);
        this.itemDataFatura.setVisible(false);
        this.menu.add(this.itemVencimentoFatura);
        this.itemVencimentoFatura.addActionListener(this);
        ActionListener[] listeners = this.buttonCancelar.getActionListeners();
        for (i = 0; i < listeners.length; ++i) {
            this.buttonCancelar.removeActionListener(listeners[i]);
        }
        this.buttonCancelar.addActionListener(this);
        listeners = this.buttonSalvar.getActionListeners();
        for (i = 0; i < listeners.length; ++i) {
            this.buttonSalvar.removeActionListener(listeners[i]);
        }
        this.buttonSalvar.addActionListener(this);
        listeners = this.buttonFechar.getActionListeners();
        for (i = 0; i < listeners.length; ++i) {
            this.buttonFechar.removeActionListener(listeners[i]);
        }
        this.buttonFechar.addActionListener(this);
        this.tabela = new JTable();
        this.modeloTabela = new LinhasTabela();
        this.tabela.setModel(this.modeloTabela);
        this.scroll = new JScrollPane(this.tabela);
        this.tabela.setSelectionMode(0);
        this.tabela.setShowGrid(false);
        StringBuilder buf = new StringBuilder();
        buf.append("<html>Ctrl + I - informa\u00e7\u00f5es da requisi\u00e7\u00e3o<br>");
        buf.append("F2 - localizar requisi\u00e7\u00e3o</html>");
        this.tabela.setToolTipText(buf.toString());
        this.tabela.setDefaultRenderer(Object.class, new EditorDadosFaturamento(this.tabela, true, convenio.getOrdemFatura(), this.acessoAlterarTodosCamposEletronico));
        this.tabela.setDefaultEditor(Object.class, new EditorDadosFaturamento(this.tabela, true, convenio.getOrdemFatura(), this.acessoAlterarTodosCamposEletronico));
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (FaturaExamesCompacta.this.tabela.getSelectedRow() >= 0) {
                    EditorDadosFaturamento editor = (EditorDadosFaturamento)FaturaExamesCompacta.this.tabela.getCellEditor(FaturaExamesCompacta.this.tabela.getSelectedRow(), 0);
                    if (e.getKeyCode() == 32) {
                        JCheckBox check = editor.getCheckBoxRequisicao();
                        if (check != null) {
                            check.doClick();
                        }
                    } else if (e.getKeyCode() == 37) {
                        editor.recolher();
                        FuncoesGerais.repaintTabela(FaturaExamesCompacta.this.panelDireitoExames, FaturaExamesCompacta.this.tabela.getSelectedRow());
                    } else if (e.getKeyCode() == 39) {
                        editor.expandir();
                        FuncoesGerais.repaintTabela(FaturaExamesCompacta.this.panelDireitoExames, FaturaExamesCompacta.this.tabela.getSelectedRow());
                    } else if (e.getKeyCode() == 113) {
                        TelaLocalizar localizar = new TelaLocalizar((Dialog)owner);
                        localizar.adicionaCampo("Requisi\u00e7\u00e3o", "Paciente", "Matr\u00edcula", "Titular");
                        localizar.setVisible(true);
                        if (localizar.isOK()) {
                            int campo = localizar.getPosicaoCampo();
                            int linha = -1;
                            String buscar = campo == 0 ? Funcoes.preencheZero(localizar.getTexto(), 8) : localizar.getTexto();
                            for (int i = 0; i < FaturaExamesCompacta.this.tabela.getRowCount(); ++i) {
                                if (!(FaturaExamesCompacta.this.tabela.getValueAt(i, 0) instanceof DadosFaturamento)) continue;
                                DadosFaturamento dados = (DadosFaturamento)FaturaExamesCompacta.this.tabela.getValueAt(i, 0);
                                if (campo == 0 && Funcoes.isNumeric(buscar) && dados.getRequisicao() == Integer.parseInt(buscar)) {
                                    linha = i;
                                    break;
                                }
                                if (campo == 1 && dados.getNomePaciente().toUpperCase().startsWith(buscar.toUpperCase())) {
                                    linha = i;
                                    break;
                                }
                                if (campo == 0 && dados.getMatricula().equalsIgnoreCase(buscar)) {
                                    linha = i;
                                    break;
                                }
                                if (campo != 0 || !dados.getNomeTitular().equalsIgnoreCase(buscar)) continue;
                                linha = i;
                                break;
                            }
                            if (linha > -1) {
                                FaturaExamesCompacta.this.tabela.setRowSelectionInterval(linha, linha);
                                FaturaExamesCompacta.this.tabela.scrollRectToVisible(FaturaExamesCompacta.this.tabela.getCellRect(linha, 0, false));
                            }
                        }
                    } else if (e.getKeyCode() == 73 && e.isControlDown() && FaturaExamesCompacta.this.tabela.getSelectedRow() > -1 && FaturaExamesCompacta.this.tabela.getValueAt(FaturaExamesCompacta.this.tabela.getSelectedRow(), 0) instanceof DadosFaturamento && owner instanceof Laboratorio) {
                        GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)((Laboratorio)owner).getRootPane().getGlassPane();
                        InfoRequisicao info = new InfoRequisicao((Dialog)owner, glassPaneMensagem);
                        DadosFaturamento dados = (DadosFaturamento)FaturaExamesCompacta.this.tabela.getValueAt(FaturaExamesCompacta.this.tabela.getSelectedRow(), 0);
                        info.setRequisicao(String.valueOf(dados.getCodigoFilial()), dados.getRequisicao());
                        info.setVisible(true);
                        ((Laboratorio)owner).getRootPane().setGlassPane(glassPaneMensagem);
                    }
                }
            }
        });
        ((EditorDadosFaturamento)this.tabela.getDefaultEditor(Object.class)).addSelecaoListener(new SelecaoListener(){

            @Override
            public void selecionado() {
                try {
                    if (FaturaExamesCompacta.this.modeloTabela.getValueAt(FaturaExamesCompacta.this.tabela.getSelectedRow(), 0) instanceof DadosFaturamento) {
                        FaturaExamesCompacta.this.getLinhaTotalGeral((DadosTotalGeral)FaturaExamesCompacta.this.modeloTabela.getValueAt(FaturaExamesCompacta.this.modeloTabela.getRowCount() - 1, 0));
                        FuncoesGerais.repaintTabela(FaturaExamesCompacta.this.panelDireitoExames);
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "BuscaRequisicoes");
                }
            }
        });
        this.tabela.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (FaturaExamesCompacta.this.tabela.getSelectedRow() == FaturaExamesCompacta.this.tabela.getRowCount() - 1) {
                    FaturaExamesCompacta.this.tabela.getSelectionModel().clearSelection();
                }
            }
        });
        this.codigoConvenio = convenio.getCodigo().toString();
        for (int i2 = 0; i2 < dados.size(); ++i2) {
            this.modeloTabela.adicionaLinha(dados.get(i2));
            DadosFaturamento requisicao = dados.get(i2);
            Date data = requisicao.getDataFaturaRequisicao();
            if (this.dataInicio == null || data.compareTo(this.dataInicio) < 0) {
                this.dataInicio = data;
            }
            if (this.dataFim != null && data.compareTo(this.dataFim) <= 0) continue;
            this.dataFim = data;
        }
        DadosTotalGeral linhaTotal = this.getLinhaTotalGeral(null);
        this.modeloTabela.adicionaLinha(linhaTotal);
        this.tabela.getSelectionModel().removeIndexInterval(this.modeloTabela.getRowCount() - 1, this.modeloTabela.getRowCount() - 1);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FuncoesGerais.repaintTabela(FaturaExamesCompacta.this.tabela);
                FaturaExamesCompacta.this.panelDireitoExames.setLayout(new BorderLayout());
                FaturaExamesCompacta.this.panelDireitoExames.add((Component)FaturaExamesCompacta.this.scroll, "Center");
                FaturaExamesCompacta.this.panelDireitoExames.revalidate();
                FaturaExamesCompacta.this.status = 2;
                FaturaExamesCompacta.this.controlaCampos();
            }
        });
    }

    private DadosTotalGeral getLinhaTotalGeral(DadosTotalGeral linhaTotal) {
        int qtdeRequisicoes = 0;
        int qtdeExames = 0;
        BigDecimal totalExamesCH = BigDecimal.ZERO;
        BigDecimal totalExames = BigDecimal.ZERO;
        BigDecimal totalMateriais = BigDecimal.ZERO;
        for (int i = 0; i < this.dados.size(); ++i) {
            Calculos.calculaTotalRequisicao(this.dados.get(i));
            DadosFaturamento aux = this.dados.get(i);
            totalExamesCH = totalExamesCH.add(aux.getValorTotalCH());
            totalExames = totalExames.add(aux.getValorTotalExames());
            totalMateriais = totalMateriais.add(aux.getValorTotalMateriais());
            int qtdeExamesAux = 0;
            for (int j = 0; j < this.dados.get(i).getExamesCount(); ++j) {
                DadosExameFaturamento auxExame = this.dados.get(i).getExame(j);
                if (!auxExame.getFaturar()) continue;
                ++qtdeExamesAux;
            }
            if (qtdeExamesAux > 0) {
                ++qtdeRequisicoes;
            }
            qtdeExames += qtdeExamesAux;
        }
        if (linhaTotal == null) {
            linhaTotal = new DadosTotalGeral();
            linhaTotal.setVencimento(new Date());
            linhaTotal.setDescricaoAcrescimo(null);
            linhaTotal.setDescricaoDesconto(null);
            linhaTotal.setCodigoFatura(null);
            linhaTotal.setMensagem(null);
            linhaTotal.setAdicional(BigDecimal.ZERO);
            linhaTotal.setCobranca(BigDecimal.ZERO);
            linhaTotal.setPercentualBonus(BigDecimal.ZERO);
            linhaTotal.setPercentualAcrescimo(BigDecimal.ZERO);
            linhaTotal.setCodigoConvenio(this.convenio.getCodigo());
        }
        linhaTotal.setQtdeRequisicoes(qtdeRequisicoes);
        linhaTotal.setQtdeExames(qtdeExames);
        linhaTotal.setTotalExamesCH(totalExamesCH);
        linhaTotal.setTotalExames(totalExames);
        linhaTotal.setTotalMateriais(totalMateriais);
        BigDecimal total = totalExames.add(totalMateriais);
        linhaTotal.setTotal(total.subtract(total.multiply(linhaTotal.getPercentualBonus()).divide(new BigDecimal("100"), 4, ParametrosGerais.getArredondamentoPrecoExame())).add(linhaTotal.getAdicional()).add(linhaTotal.getCobranca()));
        return linhaTotal;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.buttonCancelar) {
            if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                this.retorno = null;
                this.owner.setVisible(false);
            }
        } else if (e.getSource() == this.buttonSalvar) {
            this.faturaSalva = this.salvar();
            if (!this.faturaSalva) {
                return;
            }
            ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(this.panelDireitoExames).getDefaultRenderer(Object.class)).setCheckBoxVisivel(false);
            ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(this.panelDireitoExames).getDefaultEditor(Object.class)).setCheckBoxVisivel(false);
            FuncoesGerais.removeExamesDeselecionadosFaturamento(this.panelDireitoExames);
            FuncoesGerais.repaintTabela(this.panelDireitoExames);
            this.setRetorno();
            this.controlaCampos();
        } else if (e.getSource() == this.buttonFechar) {
            if (this.faturaSalva) {
                this.owner.setVisible(false);
                this.setRetorno();
            } else if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                this.retorno = null;
                this.owner.setVisible(false);
            }
        } else if (e.getSource() == this.itemVencimentoFatura) {
            DialogVencimentoFatura dialog = new DialogVencimentoFatura(this.owner, this.dataVencimento);
            ScreenUtil.centralizar(dialog);
            dialog.setVisible(true);
            this.dataVencimento = dialog.getVencimento();
        }
    }

    private void setRetorno() {
        for (int i = 0; i < this.dados.size(); ++i) {
            DadosFaturamento requisicao = this.dados.get(i);
            if (requisicao == null) continue;
            for (int j = 0; j < requisicao.getExamesCount(); ++j) {
                DadosExameFaturamento exame = requisicao.getExame(j);
                if (exame == null || !exame.getFaturar()) continue;
                exame.setFaturado(true);
            }
        }
        this.retorno = this.dados;
    }

    public ArrayList<DadosFaturamento> getRetorno() {
        return this.retorno;
    }

    public ConvenioVO getConvenio() {
        return this.convenio;
    }
}

