/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosExamePaiAgrupamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DadosTotalGeral;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.financeiro.DialogNotaFiscalSaida;
import jalis.laboratorio.financeiro.NotaFiscalSaida;
import jalis.laboratorio.financeiro.faturamento.AlteraGuiasFaturamento;
import jalis.laboratorio.financeiro.faturamento.FaturaExamesCompacta;
import jalis.laboratorio.financeiro.faturamento.FiltroDataConvenio;
import jalis.laboratorio.financeiro.faturamento.ListaValoresExamesPai;
import jalis.laboratorio.financeiro.faturamento.TelaDeveGuiaExame;
import jalis.laboratorio.financeiro.faturamento.TelaReplicarDadosGuia;
import jalis.laboratorio.financeiro.faturamento.ValorExamePai;
import jalis.laboratorio.financeiro.util.NotaFiscalFatura;
import jalis.laboratorio.resultados.DialogoResultadosAnteriores;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.faturamento.AlterarDataFatura;
import jalis.laboratorio.util.faturamento.AlterarMensagem;
import jalis.laboratorio.util.faturamento.BuscaRequisicoes;
import jalis.laboratorio.util.faturamento.Calculos;
import jalis.laboratorio.util.faturamento.EditorDadosFaturamento;
import jalis.laboratorio.util.faturamento.ExamesNaoFaturar;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.laboratorio.util.faturamento.ImprimirFatura;
import jalis.laboratorio.util.faturamento.ImprimirResumoFatura;
import jalis.laboratorio.util.faturamento.LinhasTabela;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.FabricaFaturaEletronica;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.JanelaProblemasFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.JanelaProblemasFaturamentoEletronicoBPA;
import jalis.laboratorio.util.faturamento.eletronico.Resuline;
import jalis.laboratorio.util.faturamento.eletronico.SLine;
import jalis.laboratorio.util.faturamento.eletronico.SantaCasaMiguelopolis;
import jalis.laboratorio.util.faturamento.eletronico.Util;
import jalis.laboratorio.util.faturamento.eletronico.VisualizaErros;
import jalis.laboratorio.util.faturamento.eletronico.VisualizaErrosBPA;
import jalis.laboratorio.util.faturamento.eletronico.tiss.TipoAtendimento;
import jalis.laboratorio.util.impressao.ImprimirGuia;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.service.financeiro.FaturaExamesService;
import jalis.service.financeiro.FaturaService;
import jalis.util.ArraysUtil;
import jalis.util.CheckItemFiltro;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class FaturaExames
extends FrmPadrao
implements ActionListener,
ThreadFinalizadaListener {
    private static final String PARAMETROS_FATURA_EXAMES = "FaturaExames.ultimoFiltro";
    private final GridBagLayout grid = new GridBagLayout();
    private final GridBagConstraints constraints = new GridBagConstraints();
    protected final JPanel panelEsquerdo = new JPanel(this.grid);
    private final JPanel panelDireito = new JPanel(new GridBagLayout());
    protected final JPanel panelDireitoExames = new JPanel();
    private final JPanel panelDireitoObs = new JPanel(new GridBagLayout());
    private final JPanel panelDireitoLegenda = new JPanel();
    private final JTextArea textObs = new JTextArea();
    private final TitledBorder titledObs = new TitledBorder("Observa\u00e7\u00f5es do conv\u00eanio");
    private final JPanel panelBotoes = new JPanel(new BorderLayout());
    private final JPanel panelBotoesE = new JPanel(new FlowLayout(0));
    private final JPanel panelBotoesD = new JPanel(new FlowLayout(2));
    private final JButton buttonOpcoes = new JButton("Op\u00e7\u00f5es \u25bc");
    protected final JButton buttonFechar = new JButton("Fechar");
    protected final JButton buttonSalvar = new JButton("Salvar");
    protected final JButton buttonCancelar = new JButton("Cancelar");
    private final JButton buttonImprimir = new JButton("Imprimir \u25bc");
    private final JButton buttonEletronico = new JButton("Eletr\u00f4nico");
    protected final JButton buttonNovo = new JButton("Novo");
    protected final JButton buttonFaturar = new JButton("Faturar");
    private final JLabel labelDataInicio = new JLabel("Data in\u00edcio:");
    private final JLabel labelHoraInicio = new JLabel("Hora in\u00edcio:");
    private final JLabel labelDataFim = new JLabel("Data final:");
    private final JLabel labelHoraFim = new JLabel("Hora final:");
    private final JLabel labelVencimento = new JLabel("Vencimento:");
    private final TTextField txtDataInicio = new TTextField(10, 4);
    private final TTextField txtDataFim = new TTextField(10, 4);
    private final TTextField txtHoraInicio = new TTextField(5, 6);
    private final TTextField txtHoraFim = new TTextField(5, 6);
    private final TTextField txtVencimento = new TTextField(10, 4);
    private final JButton buttonDataInicio = new JButton();
    private final JButton buttonDataFim = new JButton();
    private final JButton buttonVencimento = new JButton();
    private final JCheckBox checkConferidas = ComponenteFactory.novoJCheckBox("Apenas conferidas", '\u0000', null, "<html>Pesquisa apenas as requisi\u00e7\u00f5es que j\u00e1<br>estejam com as guias conferidas</html>");
    private final JCheckBox checkComResultado = ComponenteFactory.novoJCheckBox("Apenas com resultado", '\u0000', null, "<html>Pesquisa apenas as requisi\u00e7\u00f5es que j\u00e1<br>foram realizadas e que estejam com situa\u00e7\u00e3o (de todos os exames) acima de 'conferidas'</html>");
    private final CheckItemFiltro itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
    private final CheckItemFiltro itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
    private final CheckItemFiltro itemEstacao = new CheckItemFiltro("Esta\u00e7\u00e3o", "Filtrar", "Filtrando esta\u00e7\u00f5es", "");
    private final CheckItemFiltro itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
    private final CheckItemFiltro itemSetor = new CheckItemFiltro("Setor", "Filtrar", "Filtrando setores", "fil_codigo = " + Variaveis.filialPadrao);
    private final CheckItemFiltro itemGrupo = new CheckItemFiltro("Grupo", "Filtrar", "Filtrando grupos", "fil_codigo = " + Variaveis.filialPadrao);
    private final CheckItemFiltro itemMedico = new CheckItemFiltro("M\u00e9dico", "Filtrar", "Filtrando m\u00e9dicos", "fil_codigo = " + Variaveis.filialPadrao, new int[]{0, 1, 2}, true);
    private final CheckItemFiltro itemSituacao = new CheckItemFiltro("Situa\u00e7\u00e3o", "Filtrar", "Filtrando situa\u00e7\u00f5es", "fil_codigo = " + Variaveis.filialPadrao);
    private final CheckItemFiltro itemSituacaoExames = new CheckItemFiltro("Situa\u00e7\u00e3o Exames", "Filtrar", "Filtrando situa\u00e7\u00f5es dos exames", "fil_codigo = " + Variaveis.filialPadrao);
    private final CheckItemFiltro itemPaciente = new CheckItemFiltro("Paciente", "Filtrar", "Filtrando pacientes", "fil_codigo in (" + FaturaExames.buscaFiliaisFatura() + ")", new int[]{0, 1}, true);
    private final CheckItemFiltro itemExame = new CheckItemFiltro("Exame", "Filtrar", "Filtrando exames", "fil_codigo = " + Variaveis.filialPadrao);
    private final CheckItemFiltro itemUnidadeSaude = new CheckItemFiltro("Unidade de sa\u00fade", "Filtrar", "Filtrando unidade de sa\u00fade", "fil_codigo = " + Variaveis.filialPadrao, true);
    private final CheckItemFiltro itemEmpresa = new CheckItemFiltro("Empresa", "Filtrar", "Filtrando empresa", "fil_codigo = " + Variaveis.filialPadrao, true);
    protected final JPopupMenu menu = new JPopupMenu();
    protected final JMenuItem itemDataFatura = new JMenuItem("Alterar data de fatura");
    private final JMenuItem itemAdicional = new JMenuItem("Alterar adicional");
    private final JMenuItem itemDespesas = new JMenuItem("Alterar despesas de cobran\u00e7a");
    private final JMenuItem itemDesconto = new JMenuItem("Alterar desconto");
    private final JMenuItem itemMensagem = new JMenuItem("Alterar mensagem");
    private final JMenuItem itemDeveGuia = new JMenuItem("Marcar/Desmarcar sem pedido/guia");
    private final JMenuItem itemDeveGuiaExame = new JMenuItem("Marcar/Desmarcar exame sem guia");
    private final JMenuItem itemMarcarFaturamento = new JMenuItem("Marcar exames para n\u00e3o faturar");
    private final JMenuItem itemAlterarGuiaExames = new JMenuItem("Alterar a guia/data guia");
    private final JMenuItem itemReplicarGuia = new JMenuItem("Replicar dados de guia");
    protected final JMenu itemFiltrarConvenio = new JMenu("Filtrar conv\u00eanios");
    private final JMenuItem itemConfigurarFiltroConvenio = new JMenuItem("Configurar");
    private final JMenuItem itemRemoverFiltroConvenio = new JMenuItem("Remover");
    private final JMenuItem itemVisualizarResultado = new JMenuItem("Visualizar resultados");
    private final JCheckBoxMenuItem itemCheckVerificarNaoConferidos = new JCheckBoxMenuItem("Verificar n\u00e3o conferidos");
    private final JCheckBoxMenuItem itemCheckExibirMarcadosNaoFaturar = new JCheckBoxMenuItem("Exibir exames para n\u00e3o faturar");
    private final JPopupMenu menuImprimir = new JPopupMenu();
    private final JMenuItem itemImprimirFatura = ComponenteFactory.novoJMenuItem(this.menuImprimir, "Fatura", (ActionListener)this);
    private final JMenuItem itemImprimirNota = ComponenteFactory.novoJMenuItem("Nota fiscal", this);
    private final JMenu itemImprimirGuia = new JMenu("Guia");
    private final JMenu itemImprimirGuiaExameSolicitados = new JMenu("Guia de exames solicitados");
    private final JMenuItem itemImprimirGuiaSelecionada = new JMenuItem("Requisi\u00e7\u00e3o selecionada");
    private final JMenuItem itemImprimirTodasGuias = new JMenuItem("Todas as requisi\u00e7\u00f5es");
    private final JMenuItem itemImprimirGuiaExameSelecionada = new JMenuItem("Requisi\u00e7\u00e3o selecionada");
    private final JMenuItem itemImprimirTodasGuiasExames = new JMenuItem("Todas as requisi\u00e7\u00f5es");
    private final JMenu itemImprimirResultado = new JMenu("Resultado");
    private final JMenuItem itemImprimirResultadoSelecionado = new JMenuItem("Requisi\u00e7\u00e3o selecionada");
    private final JMenuItem itemImprimirTodosResultados = new JMenuItem("Todas as requisi\u00e7\u00f5es");
    protected int status = 1;
    private int codigoFatura = -1;
    protected boolean faturaSalva = false;
    private boolean imprimirAgrupada = false;
    private String dataInicialConvenios;
    private String dataFinalConvenios;
    private boolean faturaConferida = false;
    private boolean notaFiscalAssociada = false;
    private boolean executandoBusca = false;
    protected Date dataVencimento = null;
    protected Date dataInicio = null;
    protected Date dataFim = null;
    protected String codigoConvenio = null;
    private static String impressoraSelecionada;
    final Color foregroundObs = this.titledObs.getTitleColor();
    private boolean acessoAlterarTodosCamposFatEletronico = false;
    private static final Long ACESSO_SUBSTITUIR_GUIAS_REPLICACAO;
    private static final Long ACESSO_PERMITIR_VARIOS_PACIENTES;
    Timer chamaAtencao = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FaturaExames.this.titledObs.setTitleColor(FaturaExames.this.titledObs.getTitleColor() == FaturaExames.this.foregroundObs ? Color.red : FaturaExames.this.foregroundObs);
            FaturaExames.this.panelDireitoObs.revalidate();
            FaturaExames.this.panelDireitoObs.repaint();
        }
    });

    public FaturaExames() {
        try {
            this.jbInit(true);
            String parametros = ParametrosUsuarios.getValor(PARAMETROS_FATURA_EXAMES);
            if (!Funcoes.textoVazio(parametros)) {
                String tmp = StringUtil.getValor(parametros, "verificarconferidos");
                if (!Funcoes.textoVazio(tmp)) {
                    this.itemCheckVerificarNaoConferidos.setSelected(Boolean.valueOf(tmp));
                }
                if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "exibirnaofaturar"))) {
                    this.itemCheckExibirMarcadosNaoFaturar.setSelected(Boolean.valueOf(tmp));
                } else {
                    this.itemCheckExibirMarcadosNaoFaturar.setSelected(true);
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "FaturaExames");
        }
    }

    private void jbInit(boolean mostrarFiltros) throws Exception {
        this.setLayout(new BorderLayout());
        if (mostrarFiltros) {
            this.add((Component)this.panelEsquerdo, "West");
        }
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelDireito, "Center");
        this.panelEsquerdo.setPreferredSize(new Dimension(210, 100));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        p.add((Component)this.panelDireitoObs, c);
        ++c.gridy;
        c.weighty = 0.0;
        p.add((Component)this.panelDireitoLegenda, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelDireito.add((Component)this.panelDireitoExames, c);
        ++c.gridy;
        c.weighty = 0.0;
        this.panelDireito.add((Component)p, c);
        FuncoesGerais.montaLegenda(this.panelDireitoLegenda);
        Funcoes.criaBarraDescricao(this, "Exames", "Sele\u00e7\u00e3o dos exames a serem faturados", "financeiro/cons_fat_exm.jpg");
        this.panelDireitoObs.setVisible(false);
        GridBagConstraints x = new GridBagConstraints();
        x.anchor = 18;
        x.fill = 1;
        x.weightx = 1.0;
        x.weighty = 1.0;
        JScrollPane sp = new JScrollPane(this.textObs);
        sp.setPreferredSize(new Dimension(80, 60));
        this.panelDireitoObs.setMinimumSize(new Dimension(80, 60));
        this.panelDireitoObs.add((Component)sp, x);
        this.panelDireitoObs.setBorder(this.titledObs);
        this.textObs.setFont(new Font(this.textObs.getFont().getName(), 0, 10));
        this.textObs.setEditable(false);
        this.textObs.setWrapStyleWord(true);
        this.textObs.setLineWrap(true);
        this.panelBotoes.add((Component)this.panelBotoesE, "West");
        this.panelBotoes.add((Component)this.panelBotoesD, "East");
        this.panelBotoesD.add(this.buttonNovo);
        this.panelBotoesD.add(this.buttonSalvar);
        this.panelBotoesD.add(this.buttonCancelar);
        this.panelBotoesD.add(this.buttonImprimir);
        this.panelBotoesD.add(this.buttonEletronico);
        this.panelBotoesD.add(this.buttonFechar);
        this.panelBotoesE.add(this.buttonOpcoes);
        this.menu.add(this.itemAdicional);
        this.menu.add(this.itemDespesas);
        this.menu.add(this.itemDesconto);
        this.menu.add(this.itemMensagem);
        this.menu.add(this.itemDataFatura);
        this.menu.add(this.itemDeveGuia);
        this.menu.add(this.itemDeveGuiaExame);
        this.menu.add(this.itemMarcarFaturamento);
        this.menu.add(this.itemAlterarGuiaExames);
        this.menu.add(this.itemReplicarGuia);
        this.menu.add(this.itemFiltrarConvenio);
        this.menu.add(this.itemVisualizarResultado);
        this.menu.add(this.itemCheckVerificarNaoConferidos);
        this.menu.add(this.itemCheckExibirMarcadosNaoFaturar);
        this.itemFiltrarConvenio.add(this.itemConfigurarFiltroConvenio);
        this.itemFiltrarConvenio.add(this.itemRemoverFiltroConvenio);
        this.menuImprimir.add(this.itemImprimirFatura);
        this.menuImprimir.add(this.itemImprimirNota);
        this.menuImprimir.add(this.itemImprimirGuia);
        this.menuImprimir.add(this.itemImprimirGuiaExameSolicitados);
        this.itemImprimirGuia.add(this.itemImprimirGuiaSelecionada);
        this.itemImprimirGuia.add(this.itemImprimirTodasGuias);
        this.menuImprimir.add(this.itemImprimirResultado);
        this.itemImprimirResultado.add(this.itemImprimirResultadoSelecionado);
        this.itemImprimirResultado.add(this.itemImprimirTodosResultados);
        this.itemImprimirGuiaExameSolicitados.add(this.itemImprimirGuiaExameSelecionada);
        this.itemImprimirGuiaExameSolicitados.add(this.itemImprimirTodasGuiasExames);
        this.buttonSalvar.setVisible(Acesso.getAcesso(Long.parseLong("0600200101")));
        this.buttonImprimir.setVisible(Acesso.getAcesso(Long.parseLong("0600200101")) || Acesso.getAcesso(Long.parseLong("0600200111")));
        this.itemDesconto.setVisible(Acesso.getAcesso(Long.parseLong("0600200102")));
        this.itemAdicional.setVisible(Acesso.getAcesso(Long.parseLong("0600200103")));
        this.itemDespesas.setVisible(Acesso.getAcesso(Long.parseLong("0600200104")));
        this.itemMensagem.setVisible(Acesso.getAcesso(Long.parseLong("0600200105")));
        this.itemDataFatura.setVisible(Acesso.getAcesso(Long.parseLong("0600200106")));
        this.itemDeveGuia.setVisible(Acesso.getAcesso(Long.parseLong("0600200108")));
        this.itemDeveGuiaExame.setVisible(Acesso.getAcesso(Long.parseLong("0600200108")));
        this.itemMarcarFaturamento.setVisible(Acesso.getAcesso(Long.parseLong("0600200110")));
        this.buttonEletronico.setVisible(Acesso.getAcesso(Long.parseLong("0600200109")));
        this.itemAlterarGuiaExames.setVisible(Acesso.getAcesso(Long.parseLong("0600200114")));
        this.acessoAlterarTodosCamposFatEletronico = Acesso.getAcesso(Long.parseLong("0600200115"));
        this.itemVisualizarResultado.setVisible(Acesso.getAcesso(Long.parseLong("0600200120")));
        this.itemImprimirFatura.setVisible(Acesso.getAcesso(Long.parseLong("0600200101")));
        this.itemImprimirNota.setVisible(Acesso.getAcesso(Long.parseLong("0600200111")));
        this.itemImprimirGuia.setVisible(Acesso.getAcesso(Long.parseLong("0600200107")));
        this.itemImprimirGuiaExameSolicitados.setVisible(Acesso.getAcesso(Long.parseLong("0600200107")));
        this.itemImprimirResultado.setVisible(Acesso.getAcesso(Long.parseLong("0600200119")));
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemEstacao.setDados("estacoes", new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemEstacao.setColunaHint(1);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemSetor.setDados("setores", new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSetor.setColunaHint(1);
        this.itemGrupo.setDados("grupo", new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemGrupo.setColunaHint(1);
        this.itemMedico.setDados("medico", new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "C\u00f3digo", "UF", "Nome"}, new int[]{30, 70, 30, 0}, 4, false, true, false);
        this.itemMedico.setColunaHint(4);
        this.itemSituacao.setDados("situacao", new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSituacao.setColunaHint(1);
        this.itemPaciente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, 2, true, true, false);
        this.itemPaciente.setColunaHint(2);
        this.itemPaciente.setSql("select distinct pac_codigo, pac_nome from paciente");
        this.itemExame.setDados("exames", new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemExame.setColunaHint(1);
        this.itemUnidadeSaude.setDados("unidadesaude", new String[]{"uns_codigo", "uns_descricao", "uns_endereco"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Endere\u00e7o"}, new int[]{70, 0, 0});
        this.itemUnidadeSaude.setColunaHint(0);
        this.itemEmpresa.setDados("entidade", new String[]{"ent_codigo", "ent_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemSituacaoExames.setDados(null, new String[]{"", ""}, new String[]{"Sit.", "Descri\u00e7\u00e3o"}, new int[]{50, 0});
        this.itemSituacaoExames.setColunaHint(1);
        ArrayList<Object[]> listaSituacoes = new ArrayList<Object[]>();
        listaSituacoes.add(new Object[]{"", "Sem resultado"});
        listaSituacoes.add(new Object[]{"L", "Lan\u00e7ado"});
        listaSituacoes.add(new Object[]{"C", "Conferido"});
        listaSituacoes.add(new Object[]{"I", "Impresso"});
        listaSituacoes.add(new Object[]{"T", "A coletar"});
        listaSituacoes.add(new Object[]{"F", "Falta material"});
        listaSituacoes.add(new Object[]{"R", "Recoleta"});
        listaSituacoes.add(new Object[]{"A", "Faturamento"});
        listaSituacoes.add(new Object[]{"P", "Salvo parcial"});
        listaSituacoes.add(new Object[]{"E", "Entregue"});
        listaSituacoes.add(new Object[]{"O", "Repeti\u00e7\u00e3o"});
        this.itemSituacaoExames.setConsultaFixa(listaSituacoes);
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        this.buttonNovo.setMnemonic('N');
        this.buttonSalvar.setMnemonic('S');
        this.buttonCancelar.setMnemonic('C');
        this.buttonImprimir.setMnemonic('I');
        this.buttonEletronico.setMnemonic('E');
        this.buttonFechar.setMnemonic('F');
        this.buttonFaturar.setMnemonic('t');
        this.buttonOpcoes.setMnemonic('O');
        Funcoes.imagemPesquisa(this.buttonDataInicio);
        Funcoes.imagemPesquisa(this.buttonDataFim);
        Funcoes.imagemPesquisa(this.buttonVencimento);
        this.buttonDataInicio.setFocusable(false);
        this.buttonDataFim.setFocusable(false);
        this.buttonVencimento.setFocusable(false);
        this.buttonOpcoes.setFocusable(false);
        if (mostrarFiltros) {
            this.montaFiltros();
        }
        this.buttonFaturar.setMargin(new Insets(2, 2, 2, 2));
        this.controlaCampos();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FaturaExames.this.novo();
            }
        });
        this.buttonOpcoes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaturaExames.this.menu.show(FaturaExames.this.panelBotoesE, FaturaExames.this.buttonOpcoes.getX(), FaturaExames.this.buttonOpcoes.getY() + FaturaExames.this.buttonOpcoes.getHeight());
            }
        });
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Laboratorio.getInstancia().setInterromperInfoRequisicao(false);
                FaturaExames.this.setVisible(false);
            }
        });
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaturaExames.this.novo();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.mensagem(FaturaExames.this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                    FaturaExames.this.itemConvenio.clear();
                    FaturaExames.this.limpaCampos();
                    FaturaExames.this.status = 1;
                    FaturaExames.this.controlaCampos();
                    FaturaExames.this.buttonNovo.requestFocus();
                }
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
                FaturaExames.this.faturaSalva = FaturaExames.this.salvar();
                if (!FaturaExames.this.faturaSalva) {
                    return;
                }
                ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(FaturaExames.this.panelDireitoExames).getDefaultRenderer(Object.class)).setCheckBoxVisivel(false);
                ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(FaturaExames.this.panelDireitoExames).getDefaultEditor(Object.class)).setCheckBoxVisivel(false);
                FuncoesGerais.removeExamesDeselecionadosFaturamento(FaturaExames.this.panelDireitoExames);
                FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames);
                FaturaExames.this.controlaCampos();
                Funcoes.mensagem(FaturaExames.this, "Fatura salva com o c\u00f3digo: " + FaturaExames.this.codigoFatura + ".", 5);
                System.gc();
            }
        });
        this.buttonEletronico.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block81: {
                    block80: {
                        block79: {
                            block78: {
                                block76: {
                                    if (!FuncoesGerais.haExamesFaturamento(FaturaExames.this.panelDireitoExames)) {
                                        Funcoes.mensagem(FaturaExames.this, "Nenhum exame selecionado para o faturamento eletr\u00f4nico.", 2);
                                        return;
                                    }
                                    validado = false;
                                    convenios = null;
                                    convenios = FaturaExames.this instanceof FaturaExamesCompacta != false ? new String[]{((FaturaExamesCompacta)FaturaExames.this).getConvenio().getCodigo().toString()} : FaturaExames.access$500(FaturaExames.this).getSelecionados(0);
                                    stTemp = Conexao.getStatement();
                                    fat = null;
                                    protocolo = "";
                                    situacoes = null;
                                    xml = null;
                                    try {
                                        if (convenios == null || convenios.length <= 0) break block76;
                                        buf = new StringBuilder("select con_faturaeletronica from convenios where fil_codigo = ");
                                        buf.append(Variaveis.filialPadrao);
                                        buf.append(" and con_codigo = ");
                                        buf.append(convenios[0]);
                                        rs = Conexao.executeQuery(stTemp, buf);
                                        if (!rs.next() || !(validado = Util.validaConfiguracaoConvenio(rs.getString("con_faturaeletronica")))) break block76;
                                        xml = rs.getString("con_faturaeletronica");
                                        protocolo = StringUtil.getValor(xml, "protocolo");
                                        fat = FabricaFaturaEletronica.novoFaturamentoEletronico(protocolo);
                                        situacoes = fat.situacoesPermitidasExame(xml);
                                    }
                                    catch (Exception ex) {
                                        try {
                                            ErrorLogger.mostraMensagem(FaturaExames.this, ex.getMessage(), ex.getStackTrace(), "FaturaExames (305)");
                                        }
                                        catch (Throwable var11_12) {
                                            Conexao.fecharStatement(new Statement[]{stTemp});
                                            throw var11_12;
                                        }
                                        Conexao.fecharStatement(new Statement[]{stTemp});
                                    }
                                }
                                Conexao.fecharStatement(new Statement[]{stTemp});
                                if (!validado || fat == null) {
                                    Funcoes.mensagem(FaturaExames.this, "O faturamento eletr\u00f4nico n\u00e3o pode ser conclu\u00eddo pois n\u00e3o existe uma configura\u00e7\u00e3o para o conv\u00eanio", 1);
                                    return;
                                }
                                FaturaExames.access$800(FaturaExames.this).setEnabled(false);
                                reg = ((AbstractFaturamentoEletronico)fat).parseXMLConfiguracao(xml);
                                linhas = FuncoesGerais.pegaModeloFatura(FaturaExames.this.panelDireitoExames);
                                requisicoes = new ArrayList<DadosFaturamento>();
                                for (i = 0; i < linhas.getRowCount(); ++i) {
                                    if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento)) continue;
                                    requisicoes.add((DadosFaturamento)linhas.getValueAt(i, 1));
                                }
                                qtdeErros = 0;
                                ((AbstractFaturamentoEletronico)fat).verificaErrosFatura(requisicoes, reg);
                                for (i = 0; i < requisicoes.size(); ++i) {
                                    requisicao = requisicoes.get(i);
                                    if (!requisicao.haProblemas()) continue;
                                    ++qtdeErros;
                                }
                                if (qtdeErros > 0 && reg != null) {
                                    janela = null;
                                    janelaBPA = null;
                                    if (protocolo.equalsIgnoreCase("BPA")) {
                                        todososMedicosPossuemCbos = FaturaExames.this.verificarSeTodosOsMedicosPossuemCbos(requisicoes);
                                        if (!todososMedicosPossuemCbos) {
                                            FaturaExames.access$800(FaturaExames.this).setEnabled(true);
                                            return;
                                        }
                                        janelaBPA = new JanelaProblemasFaturamentoEletronicoBPA((Window)Laboratorio.getInstancia(), FaturaExames.access$900(FaturaExames.this));
                                        janelaBPA.preencheValores(requisicoes, reg, (AbstractFaturamentoEletronico)fat);
                                        janelaBPA.setVisible(true);
                                        linhas.removeListenerLinhasRemovidas();
                                        rodape = null;
                                        for (i = 0; i < linhas.getRowCount(); ++i) {
                                            if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento)) {
                                                rodape = linhas.getValueAt(i, 1);
                                            }
                                            linhas.removeLinha(i--);
                                        }
                                        requisicoesAtualizadas = janelaBPA.getRequisicoes();
                                        for (i = 0; i < requisicoesAtualizadas.size(); ++i) {
                                            linhas.adicionaLinha(requisicoesAtualizadas.get(i));
                                        }
                                        linhas.adicionaLinha(rodape);
                                        FuncoesGerais.atualizaModeloFatura(FaturaExames.this.panelDireitoExames);
                                        if (janelaBPA.haProblemas()) {
                                            Funcoes.mensagem(FaturaExames.this, "N\u00e3o \u00e9 poss\u00edvel gerar o faturamento eletr\u00f4nico, pois, ainda h\u00e1 informa\u00e7\u00f5es a serem corrigidas.", 2);
                                            FaturaExames.access$800(FaturaExames.this).setEnabled(true);
                                            return;
                                        }
                                    } else {
                                        janela = new JanelaProblemasFaturamentoEletronico((Window)Laboratorio.getInstancia(), FaturaExames.access$900(FaturaExames.this), reg.getValor("versaoArquivo").toString());
                                        janela.preencheValores(requisicoes, reg, (AbstractFaturamentoEletronico)fat);
                                        janela.setVisible(true);
                                        linhas.removeListenerLinhasRemovidas();
                                        rodape = null;
                                        for (i = 0; i < linhas.getRowCount(); ++i) {
                                            if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento)) {
                                                rodape = linhas.getValueAt(i, 1);
                                            }
                                            linhas.removeLinha(i--);
                                        }
                                        requisicoesAtualizadas = janela.getRequisicoes();
                                        for (i = 0; i < requisicoesAtualizadas.size(); ++i) {
                                            linhas.adicionaLinha(requisicoesAtualizadas.get(i));
                                        }
                                        linhas.adicionaLinha(rodape);
                                        FuncoesGerais.atualizaModeloFatura(FaturaExames.this.panelDireitoExames);
                                        if (janela.haProblemas()) {
                                            Funcoes.mensagem(FaturaExames.this, "N\u00e3o \u00e9 poss\u00edvel gerar o faturamento eletr\u00f4nico, pois, ainda h\u00e1 informa\u00e7\u00f5es a serem corrigidas.", 2);
                                            FaturaExames.access$800(FaturaExames.this).setEnabled(true);
                                            return;
                                        }
                                    }
                                }
                                if (protocolo.equalsIgnoreCase("TISS") && reg.getValor("tipoAtendimento").equals(TipoAtendimento.TIPO_ATENDIMENTO_SITUACAO.getDescricao())) {
                                    for (i = 0; linhas != null && i < linhas.getRowCount(); ++i) {
                                        if (!(linhas.getValueAt(i, 0) instanceof DadosFaturamento) || !((DadosFaturamento)linhas.getValueAt(i, 1)).getFaturar() || ((DadosFaturamento)linhas.getValueAt(i, 1)).getCodigoSituacao() != -1) continue;
                                        Funcoes.mensagem(FaturaExames.this, "O faturamento eletr\u00f4nico n\u00e3o pode ser conclu\u00eddo. Verifique as situa\u00e7\u00f5es das requisi\u00e7\u00f5es", 2);
                                        return;
                                    }
                                }
                                telaEspera = SplashMensagem.getInstancia(FaturaExames.this);
                                telaEspera.mostrar("Gerando faturamento eletr\u00f4nico. Aguarde...");
                                if (situacoes != null) {
                                    linhas = FuncoesGerais.pegaModeloFatura(FaturaExames.this.panelDireitoExames);
                                    removeuExame = false;
                                    if (linhas != null) {
                                        remover = false;
                                        for (i = 0; i < linhas.getRowCount(); ++i) {
                                            if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento)) continue;
                                            dados = (DadosFaturamento)linhas.getValueAt(i, 1);
                                            exames = dados.getExames();
                                            contagemRemovidos = 0;
                                            for (DadosExameFaturamento exame : exames) {
                                                if (!exame.getFaturar() || ArraysUtil.indice(situacoes, exame.getSituacaoExame()) >= 0) continue;
                                                if (!remover) {
                                                    v0 = remover = Funcoes.mensagem(FaturaExames.this, "Alguns exames n\u00e3o podem ser faturados, pois a situa\u00e7\u00e3o atual do exame n\u00e3o pode ser faturada.\nDeseja remover esses exames do faturamento atual?", 4) == 0;
                                                }
                                                if (!remover) {
                                                    Funcoes.mensagem(FaturaExames.this, "O faturamento foi cancelado por n\u00e3o atender \u00e0s situa\u00e7\u00f5es exigidas.", 1);
                                                    FaturaExames.access$800(FaturaExames.this).setEnabled(true);
                                                    telaEspera.apagar();
                                                    return;
                                                }
                                                exame.setFaturar(false);
                                                removeuExame = true;
                                                ++contagemRemovidos;
                                                Calculos.calculaTotalRequisicao(dados);
                                            }
                                            if (contagemRemovidos != exames.size()) continue;
                                            dados.setFaturar(false);
                                        }
                                        if (removeuExame) {
                                            stCalculo = Conexao.getStatement();
                                            try {
                                                tabela = FuncoesGerais.pegaTabela(FaturaExames.this.panelDireitoExames);
                                                Calculos.calculaTotal(stCalculo, linhas.getRowCount() - 1, tabela, linhas);
                                                tabela.revalidate();
                                                tabela.repaint();
                                            }
                                            catch (Exception ex) {
                                                try {
                                                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "FaturaExames : 460");
                                                }
                                                catch (Throwable var22_54) {
                                                    Conexao.fecharStatement(new Statement[]{stCalculo});
                                                    throw var22_54;
                                                }
                                                Conexao.fecharStatement(new Statement[]{stCalculo});
                                            }
                                            Conexao.fecharStatement(new Statement[]{stCalculo});
                                        }
                                        if (remover) {
                                            Funcoes.mensagem(FaturaExames.this, "Alguns exames foram desmarcados do faturamento, confira as requisi\u00e7\u00f5es antes de continuar.", 2);
                                            FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames);
                                            FaturaExames.access$800(FaturaExames.this).setEnabled(true);
                                            telaEspera.apagar();
                                            return;
                                        }
                                    }
                                }
                                if (!FaturaExames.this.faturaSalva) {
                                    resp = Funcoes.mensagem(FaturaExames.this, "\u00c9 necess\u00e1rio salvar a fatura para gerar o faturamento eletr\u00f4nico.\nDeseja salvar?", 4);
                                    if (resp == 1) {
                                        telaEspera.apagar();
                                        return;
                                    }
                                    FaturaExames.this.faturaSalva = FaturaExames.this.salvar();
                                    if (!FaturaExames.this.faturaSalva) {
                                        return;
                                    }
                                    ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(FaturaExames.this.panelDireitoExames).getDefaultRenderer(Object.class)).setCheckBoxVisivel(false);
                                    ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(FaturaExames.this.panelDireitoExames).getDefaultEditor(Object.class)).setCheckBoxVisivel(false);
                                    FuncoesGerais.removeExamesDeselecionadosFaturamento(FaturaExames.this.panelDireitoExames);
                                    FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames);
                                    FaturaExames.this.controlaCampos();
                                }
                                if (!FaturaExames.this.faturaSalva || FaturaExames.access$700(FaturaExames.this) <= -1 || convenios == null || convenios.length <= 0) break block81;
                                st = Conexao.getStatement();
                                if (!validado) ** GOTO lbl298
                                if (!fat.solicitarDiretorioNoInicio()) ** GOTO lbl232
                                path = "";
                                file = ComponenteFactory.novoJFileChooser();
                                file.setFileSelectionMode(1);
                                if (file.showSaveDialog(FaturaExames.this) != 0) break block78;
                                path = file.getSelectedFile().getAbsolutePath();
                                break block79;
                            }
                            Conexao.fecharStatement(new Statement[]{st});
                            if (telaEspera != null) {
                                telaEspera.apagar();
                            }
                            FaturaExames.access$800(FaturaExames.this).setEnabled(true);
                            return;
                        }
                        try {
                            arquivos = fat.criarArquivo(FaturaExames.this.getTopLevelAncestor(), FaturaExames.access$700(FaturaExames.this), convenios[0], path);
                            telaEspera.apagar();
                            contaArquivos = 0;
                            if (arquivos != null && arquivos.size() > 0) {
                                for (ArquivoFaturamentoEletronico arquivo : arquivos) {
                                    if (Funcoes.textoVazio(arquivo.getXML())) continue;
                                    extensao = FabricaFaturaEletronica.getExtensaoArquivo(protocolo, xml);
                                    nomeArquivo = path + "\\" + arquivo.getNome() + (extensao == null ? "" : "." + extensao);
                                    StringUtil.escreverArquivoTexto(nomeArquivo, arquivo.getXML(), fat.getCodificacaoArquivo());
                                    if (!protocolo.equalsIgnoreCase(SLine.getNomeProtocolo())) {
                                        Funcoes.mensagem(FaturaExames.this, "Arquivo criado com sucesso.\n" + nomeArquivo, 2);
                                        continue;
                                    }
                                    ++contaArquivos;
                                }
                                if (protocolo.equalsIgnoreCase(SLine.getNomeProtocolo())) {
                                    if (contaArquivos == arquivos.size()) {
                                        Funcoes.mensagem(FaturaExames.this, "Arquivo(s) criado(s) com sucesso.", 2);
                                    } else if (contaArquivos == 0) {
                                        Funcoes.mensagem(FaturaExames.this, "Nenhum arquivo gerado.", 2);
                                    } else {
                                        Funcoes.mensagem(FaturaExames.this, "N\u00e3o foi poss\u00edvel gerar todos os arquivos.", 2);
                                    }
                                }
                            }
                            break block80;
lbl232:
                            // 1 sources

                            arquivos = fat.criarArquivo(FaturaExames.this.getTopLevelAncestor(), FaturaExames.access$700(FaturaExames.this), convenios[0], "");
                            telaEspera.apagar();
                            if (!protocolo.equalsIgnoreCase(Resuline.getNomeProtocolo())) {
                                if (arquivos != null && arquivos.size() > 0) {
                                    contaArquivos = 0;
                                    for (ArquivoFaturamentoEletronico arquivo : arquivos) {
                                        if (Funcoes.textoVazio(arquivo.getXML())) continue;
                                        file = ComponenteFactory.novoJFileChooser();
                                        extensao = FabricaFaturaEletronica.getExtensaoArquivo(protocolo, xml);
                                        if (extensao != null) {
                                            file.setFileFilter(ComponenteFactory.novoFileFilter("Arquivos de Faturamento", new String[]{extensao}));
                                        }
                                        file.setSelectedFile(new File(arquivo.getNome()));
                                        if (file.showSaveDialog(FaturaExames.this) != 0) continue;
                                        path = null;
                                        path = extensao != null ? StringUtil.concatenarExtensao(file.getSelectedFile().getAbsolutePath(), "." + extensao) : file.getSelectedFile().getAbsolutePath();
                                        StringUtil.escreverArquivoTexto(path, arquivo.getXML(), fat.getCodificacaoArquivo());
                                        if (!protocolo.equalsIgnoreCase(SLine.getNomeProtocolo())) {
                                            Funcoes.mensagem(FaturaExames.this, "Arquivo criado com sucesso.\n" + path, 2);
                                            continue;
                                        }
                                        ++contaArquivos;
                                    }
                                    if (protocolo.equalsIgnoreCase(SLine.getNomeProtocolo())) {
                                        if (contaArquivos == arquivos.size()) {
                                            Funcoes.mensagem(FaturaExames.this, "Arquivo(s) criado(s) com sucesso.", 2);
                                        } else if (contaArquivos == 0) {
                                            Funcoes.mensagem(FaturaExames.this, "Nenhum arquivo gerado.", 2);
                                        } else {
                                            Funcoes.mensagem(FaturaExames.this, "N\u00e3o foi poss\u00edvel gerar todos os arquivos.", 2);
                                        }
                                    }
                                }
                            } else if (arquivos != null && arquivos.size() > 0) {
                                contaArquivos = 0;
                                for (ArquivoFaturamentoEletronico arquivo : arquivos) {
                                    if (Funcoes.textoVazio(arquivo.getXML()) && arquivo.getConteudo() == null) continue;
                                    if (arquivo.getNome().contains("xml")) {
                                        StringUtil.escreverArquivoTexto(arquivo.getNome(), arquivo.getXML(), fat.getCodificacaoArquivo());
                                    } else if (arquivo.getNome().contains("pdf")) {
                                        file = new File(arquivo.getNome());
                                        fileWriter = new FileOutputStream(file);
                                        fileWriter.write(arquivo.getConteudo());
                                        fileWriter.close();
                                        System.gc();
                                    }
                                    ++contaArquivos;
                                }
                                if (protocolo.equalsIgnoreCase(Resuline.getNomeProtocolo())) {
                                    if (contaArquivos == arquivos.size()) {
                                        Funcoes.mensagem(FaturaExames.this, "Arquivo(s) criado(s) com sucesso.", 2);
                                    } else if (contaArquivos == 0) {
                                        Funcoes.mensagem(FaturaExames.this, "Nenhum arquivo gerado.", 2);
                                    } else {
                                        Funcoes.mensagem(FaturaExames.this, "N\u00e3o foi poss\u00edvel gerar todos os arquivos.", 2);
                                    }
                                }
                            }
                            if (arquivos != null && arquivos.size() > 0 && !StringUtil.isEmpty(arquivos.get(0).getNome()) && protocolo.equalsIgnoreCase(SantaCasaMiguelopolis.getNomeProtocolo())) {
                                Funcoes.mensagem(FaturaExames.this, "Arquivo criado com sucesso.\n" + arquivos.get(0).getNome(), 2);
                            }
                            break block80;
lbl298:
                            // 1 sources

                            Funcoes.mensagem(FaturaExames.this, "O conv\u00eanio selecionado n\u00e3o est\u00e1 habilitado para criar arquivos de faturamento", 1);
                        }
                        catch (Exception ex) {
                            try {
                                ErrorLogger.mostraMensagem(FaturaExames.this, ex.getMessage(), ex.getStackTrace(), "FaturaExames (256)");
                            }
                            catch (Throwable var23_56) {
                                Conexao.fecharStatement(new Statement[]{st});
                                if (telaEspera != null) {
                                    telaEspera.apagar();
                                }
                                FaturaExames.access$800(FaturaExames.this).setEnabled(true);
                                throw var23_56;
                            }
                            Conexao.fecharStatement(new Statement[]{st});
                            if (telaEspera != null) {
                                telaEspera.apagar();
                            }
                            FaturaExames.access$800(FaturaExames.this).setEnabled(true);
                        }
                    }
                    Conexao.fecharStatement(new Statement[]{st});
                    if (telaEspera != null) {
                        telaEspera.apagar();
                    }
                    FaturaExames.access$800(FaturaExames.this).setEnabled(true);
                }
            }
        });
        this.buttonImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaturaExames.this.itemImprimirFatura.setText(FaturaExames.this.imprimirAgrupada ? "Fatura agrupada" : "Fatura");
                FaturaExames.this.menuImprimir.show(FaturaExames.this.panelBotoesD, FaturaExames.this.buttonImprimir.getX(), FaturaExames.this.buttonImprimir.getY() + FaturaExames.this.buttonImprimir.getHeight());
            }
        });
        this.buttonFaturar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tmp = "<verificarconferidos>" + FaturaExames.this.itemCheckVerificarNaoConferidos.isSelected() + "</verificarconferidos>";
                tmp = tmp + "<exibirnaofaturar>" + FaturaExames.this.itemCheckExibirMarcadosNaoFaturar.isSelected() + "</exibirnaofaturar>";
                ParametrosUsuarios.setValor(FaturaExames.PARAMETROS_FATURA_EXAMES, tmp);
                ParametrosUsuarios.salvarParametros(true);
                if (!Funcoes.textoVazio(FaturaExames.this.txtVencimento)) {
                    FaturaExames.this.dataVencimento = Funcoes.getData("dd/MM/yyyy", FaturaExames.this.txtVencimento.getText());
                }
                if (!Funcoes.textoVazio(FaturaExames.this.txtDataInicio)) {
                    FaturaExames.this.dataInicio = Funcoes.getData("dd/MM/yyyy", FaturaExames.this.txtDataInicio.getText());
                }
                if (!Funcoes.textoVazio(FaturaExames.this.txtDataFim)) {
                    FaturaExames.this.dataFim = Funcoes.getData("dd/MM/yyyy", FaturaExames.this.txtDataFim.getText());
                }
                FaturaExames.this.pesquisaFaturamento();
                System.gc();
            }
        });
        this.buttonDataInicio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(FaturaExames.this.txtDataInicio, FaturaExames.this.buttonDataInicio, FaturaExames.this.panelEsquerdo, true);
            }
        });
        this.buttonDataFim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(FaturaExames.this.txtDataFim, FaturaExames.this.buttonDataFim, FaturaExames.this.panelEsquerdo, true);
            }
        });
        this.buttonVencimento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(FaturaExames.this.txtVencimento, FaturaExames.this.buttonVencimento, FaturaExames.this.panelEsquerdo, true);
            }
        });
        this.itemAdicional.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(FaturaExames.this.panelDireitoExames);
                if (linhas != null && linhas.getValueAt(linhas.getRowCount() - 1, 0) instanceof DadosTotalGeral) {
                    DadosTotalGeral dados = (DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0);
                    FuncoesGerais.mudaValor((Window)FaturaExames.this.getTopLevelAncestor(), 1, dados);
                    FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames);
                    FaturaExames.this.faturaSalva = false;
                }
            }
        });
        this.itemDesconto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(FaturaExames.this.panelDireitoExames);
                if (linhas != null && linhas.getValueAt(linhas.getRowCount() - 1, 0) instanceof DadosTotalGeral) {
                    DadosTotalGeral dados = (DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0);
                    FuncoesGerais.mudaValor((Window)FaturaExames.this.getTopLevelAncestor(), 3, dados);
                    FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames);
                    FaturaExames.this.faturaSalva = false;
                }
            }
        });
        this.itemDespesas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(FaturaExames.this.panelDireitoExames);
                if (linhas != null && linhas.getValueAt(linhas.getRowCount() - 1, 0) instanceof DadosTotalGeral) {
                    DadosTotalGeral dados = (DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0);
                    FuncoesGerais.mudaValor((Window)FaturaExames.this.getTopLevelAncestor(), 2, dados);
                    FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames);
                    FaturaExames.this.faturaSalva = false;
                }
            }
        });
        this.itemMensagem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(FaturaExames.this.panelDireitoExames);
                if (linhas != null && linhas.getValueAt(linhas.getRowCount() - 1, 0) instanceof DadosTotalGeral) {
                    DadosTotalGeral dados = (DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0);
                    AlterarMensagem msg = new AlterarMensagem((Window)FaturaExames.this.getTopLevelAncestor());
                    msg.setMensagem(dados.getMensagem());
                    msg.setVisible(true);
                    if (msg.isOK()) {
                        dados.setMensagem(msg.getMensagem());
                    }
                    FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames);
                    FaturaExames.this.faturaSalva = false;
                }
            }
        });
        this.itemConfigurarFiltroConvenio.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block6: {
                    FiltroDataConvenio filtro = new FiltroDataConvenio((Frame)FaturaExames.this.getTopLevelAncestor());
                    filtro.setVisible(true);
                    if (!filtro.getOK()) break block6;
                    FaturaExames.this.dataInicialConvenios = filtro.getDataInicial();
                    FaturaExames.this.dataFinalConvenios = filtro.getDataFinal();
                    Statement st = Conexao.getStatement();
                    boolean selecaoOK = false;
                    try {
                        StringBuilder buf = new StringBuilder("select distinct a.con_codigo, b.con_fantasia from requisicao a ");
                        buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
                        buf.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo ");
                        buf.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo and c.exa_codigo = d.exa_codigo and c.mco_codigo = d.mco_codigo ");
                        buf.append("left join exames e on a.fil_codigo = e.fil_codigo and c.exa_codigo = e.exa_codigo ");
                        buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
                        buf.append(" and a.req_dtfatura >= '").append(Funcoes.formataData("MM/dd/yyyy", FaturaExames.this.dataInicialConvenios)).append("' ");
                        buf.append(" and a.req_dtfatura <= '").append(Funcoes.formataData("MM/dd/yyyy", FaturaExames.this.dataFinalConvenios)).append("' ");
                        buf.append(" and a.req_excluida = false ");
                        buf.append(" and c.exr_excluido = false ");
                        buf.append(" and d.emc_proibido = false and e.exa_proibido = false ");
                        buf.append(" and (c.exr_naofaturar <> true or c.exr_naofaturar is null) ");
                        buf.append(" and c.exr_datafatura is null ");
                        buf.append(" and c.exr_datacortesia is null ");
                        buf.append(" and (case b.con_fatfmaterial when false then c.exr_situacao <> '");
                        buf.append("F").append("' else c.exr_situacao <> '.' end) ");
                        buf.append(" and (case b.con_faturarrecoleta when false then c.exr_situacao <> '");
                        buf.append("R").append("' else c.exr_situacao <> '..' end) ");
                        buf.append("order by a.con_codigo ");
                        ResultSet rs = Conexao.executeQuery(st, buf);
                        ArrayList<Object[]> lista = new ArrayList<Object[]>();
                        while (rs.next()) {
                            lista.add(new Object[]{rs.getInt("con_codigo"), rs.getString("con_fantasia")});
                        }
                        FaturaExames.this.itemConvenio.setConsultaFixa(lista);
                        selecaoOK = lista.size() > 0;
                    }
                    catch (Exception e2) {
                        try {
                            ErrorLogger.mostraMensagem(FaturaExames.this, e2.getMessage(), e2.getStackTrace(), "FaturaExames: 588");
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            throw throwable;
                        }
                        Conexao.fecharStatement(st);
                    }
                    Conexao.fecharStatement(st);
                    if (selecaoOK) {
                        FaturaExames.this.itemConvenio.setSelected(true);
                        FaturaExames.this.itemConvenio.setTitulo("<html>Conv\u00eanio<font color='red'>***</font></html>");
                        FaturaExames.this.txtDataInicio.setText(Funcoes.formataData("dd/MM/yyyy", FaturaExames.this.dataInicialConvenios));
                        FaturaExames.this.txtDataFim.setText(Funcoes.formataData("dd/MM/yyyy", FaturaExames.this.dataFinalConvenios));
                    }
                }
            }
        });
        this.itemRemoverFiltroConvenio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaturaExames.this.itemConvenio.setTitulo("Conv\u00eanio");
                FaturaExames.this.itemConvenio.clear();
                FaturaExames.this.itemConvenio.removerConsultaFixa();
                FaturaExames.this.itemConvenio.setSelected(false);
                FaturaExames.this.dataInicialConvenios = null;
                FaturaExames.this.dataFinalConvenios = null;
            }
        });
        this.itemMarcarFaturamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FaturaExames.this.marcarExameParaNaoFaturar();
                FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames);
                FaturaExames.this.faturaSalva = false;
            }
        });
        this.itemVisualizarResultado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer linha = FuncoesGerais.pegaLinhaSelecionada(FaturaExames.this.panelDireitoExames);
                if (linha > -1) {
                    LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(FaturaExames.this.panelDireitoExames);
                    int codigoRequisicao = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getRequisicao();
                    String codigoFilial = String.valueOf(((DadosFaturamento)linhas.getValueAt(linha, 1)).getCodigoFilial());
                    String nomePaciente = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getNomePaciente();
                    DialogoResultadosAnteriores dialogo = DialogoResultadosAnteriores.novaInstancia(FaturaExames.this.getTopLevelAncestor());
                    if (dialogo != null) {
                        boolean mostrar = false;
                        mostrar = dialogo.setRequisicao((Window)FaturaExames.this.getTopLevelAncestor(), codigoFilial, nomePaciente, String.valueOf(codigoRequisicao));
                        if (mostrar) {
                            dialogo.setVisible(true);
                        }
                    }
                }
            }
        });
        this.itemDataFatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(FaturaExames.this.panelDireitoExames);
                int linha = FuncoesGerais.pegaLinhaSelecionada(FaturaExames.this.panelDireitoExames);
                if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento) {
                    AlterarDataFatura msg = new AlterarDataFatura((Window)FaturaExames.this.getTopLevelAncestor());
                    Date dataFatura = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getDataFaturaRequisicao();
                    int codigoRequisicao = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getRequisicao();
                    int filialRequisicao = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getCodigoFilial();
                    msg.setData(Funcoes.formataData(dataFatura));
                    msg.setVisible(true);
                    if (msg.isOK()) {
                        dataFatura = Funcoes.stringToDate(msg.getData());
                        boolean removeLinha = false;
                        if (!(FaturaExames.this instanceof FaturaExamesCompacta) && (dataFatura.after(Funcoes.stringToDate(FaturaExames.this.txtDataFim.getText())) || dataFatura.before(Funcoes.stringToDate(FaturaExames.this.txtDataInicio.getText())))) {
                            if (Funcoes.mensagem(FaturaExames.this, "A data de fatura informada n\u00e3o est\u00e1 no intervalo de datas selecionadas.\n Confirma a retirada da requisi\u00e7\u00e3o do faturamento?", 4) == 1) {
                                return;
                            }
                            removeLinha = true;
                        }
                        DadosFaturamento dadosFatura = (DadosFaturamento)linhas.getValueAt(linha, 1);
                        dadosFatura.setDataFaturaRequisicao(dataFatura);
                        try {
                            Statement st = Conexao.getStatement();
                            StringBuilder buf = new StringBuilder("update requisicao set req_dtfatura = '");
                            buf.append(Funcoes.formataData("MM/dd/yyyy", dataFatura));
                            buf.append("', usr_codigo = '");
                            buf.append(Variaveis.login);
                            buf.append("' where fil_codigo = ");
                            buf.append(filialRequisicao);
                            buf.append(" and req_codigo = ");
                            buf.append(codigoRequisicao);
                            Conexao.execute(String.valueOf(filialRequisicao), st, buf.toString());
                            buf.delete(0, buf.length());
                            buf.append("insert into requisicaousuario (fil_codigo, req_codigo, usr_codigo, reu_data) values (");
                            buf.append(filialRequisicao);
                            buf.append(", ");
                            buf.append(codigoRequisicao);
                            buf.append(", '");
                            buf.append(Variaveis.login);
                            buf.append("', '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date())).append("')");
                            Conexao.execute(String.valueOf(filialRequisicao), st, buf.toString());
                            for (int i = 0; i < dadosFatura.getExamesCount(); ++i) {
                                DadosExameFaturamento exm = dadosFatura.getExame(i);
                                ExportaFiliais.gravaRequisicao(filialRequisicao, codigoRequisicao, exm.getCodigoExame(), exm.getCodigoMaterial(), "U", "U");
                            }
                            if (removeLinha) {
                                linhas.removeLinha(linha);
                            }
                            Conexao.arquivaSQL();
                            FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames);
                            FaturaExames.this.faturaSalva = false;
                        }
                        catch (Exception ex) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ErrorLogger.mostraMensagem(FaturaExames.this, ex.getMessage(), ex.getStackTrace(), "FaturaExames (508)");
                        }
                    }
                }
            }
        });
        this.itemImprimirResultado.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                FaturaExames.this.itemImprimirResultadoSelecionado.setEnabled(FuncoesGerais.pegaLinhaSelecionada(FaturaExames.this.panelDireitoExames) > -1);
            }

            @Override
            @Deprecated
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            @Deprecated
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.itemImprimirGuia.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                FaturaExames.this.itemImprimirGuiaSelecionada.setEnabled(FuncoesGerais.pegaLinhaSelecionada(FaturaExames.this.panelDireitoExames) > -1);
            }

            @Override
            @Deprecated
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            @Deprecated
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.itemImprimirGuiaSelecionada.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread("Impress\u00e3o de guia - Jalis"){

                    @Override
                    public void run() {
                        FaturaExames.this.imprimirGuia(false, 0);
                    }
                }.start();
            }
        });
        this.itemImprimirTodasGuias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread("Impress\u00e3o de guia - Jalis"){

                    @Override
                    public void run() {
                        FaturaExames.this.imprimirGuia(true, 0);
                    }
                }.start();
            }
        });
        this.itemImprimirResultadoSelecionado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread("Impress\u00e3o de resultado - Jalis"){

                    @Override
                    public void run() {
                        FaturaExames.this.imprimirResultado(false);
                    }
                }.start();
            }
        });
        this.itemImprimirTodosResultados.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread("Impress\u00e3o de resultado - Jalis"){

                    @Override
                    public void run() {
                        int confirmacao = JOptionPane.showOptionDialog(FaturaExames.this, "Ser\u00e3o impressos os resultados de todas as requisi\u00e7\u00f5es da fatura.\nDeseja continuar?", "Confirma Impress\u00e3o", 0, 3, ImagemUtils.carregaImagemJalis("dialog_question.gif"), new Object[]{"Sim", "N\u00e3o"}, "N\u00e3o");
                        if (confirmacao == 0) {
                            FaturaExames.this.imprimirResultado(true);
                        }
                    }
                }.start();
            }
        });
        this.itemImprimirGuiaExameSolicitados.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                FaturaExames.this.itemImprimirGuiaExameSelecionada.setEnabled(FuncoesGerais.pegaLinhaSelecionada(FaturaExames.this.panelDireitoExames) > -1);
            }

            @Override
            @Deprecated
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            @Deprecated
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.itemImprimirGuiaExameSelecionada.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread("Impress\u00e3o de guia - Jalis"){

                    @Override
                    public void run() {
                        FaturaExames.this.imprimirGuia(false, 1);
                    }
                }.start();
            }
        });
        this.itemImprimirTodasGuiasExames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread("Impress\u00e3o de guia - Jalis"){

                    @Override
                    public void run() {
                        FaturaExames.this.imprimirGuia(true, 1);
                    }
                }.start();
            }
        });
        this.itemDeveGuia.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block10: {
                    LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(FaturaExames.this.panelDireitoExames);
                    int linha = FuncoesGerais.pegaLinhaSelecionada(FaturaExames.this.panelDireitoExames);
                    if (linhas == null || linha <= -1 || !(linhas.getValueAt(linha, 1) instanceof DadosFaturamento)) break block10;
                    boolean deviaGuia = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getDeveGuia();
                    boolean deveGuia = !((DadosFaturamento)linhas.getValueAt(linha, 1)).getDeveGuia();
                    ((DadosFaturamento)linhas.getValueAt(linha, 1)).setDeveGuia(deveGuia);
                    int filial = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getCodigoFilial();
                    int codigoRequisicao = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getRequisicao();
                    Statement st = Conexao.getStatement();
                    Statement st2 = Conexao.getStatement();
                    Statement st3 = Conexao.getStatement();
                    try {
                        StringBuilder bui = new StringBuilder("update requisicao set req_deveguia = ");
                        bui.append(deveGuia ? "TRUE" : "FALSE");
                        bui.append(" where fil_codigo = ");
                        bui.append(filial);
                        bui.append(" and req_codigo = ");
                        bui.append(codigoRequisicao);
                        Conexao.execute(String.valueOf(filial), st, bui.toString());
                        if (Variaveis.exportarWebFilial) {
                            if (deveGuia) {
                                String[] comandoRequisicao = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoRequisicao", IntegracaoUtil.formataCodigoRequisicao(String.valueOf(filial), String.valueOf(codigoRequisicao), st)};
                                DBUtil.insereExportaWeb(String.valueOf(filial), st, "requisicao", "D", comandoRequisicao);
                            } else if (deviaGuia) {
                                FuncoesGerais.reenviarRequisicaoWeb(st3, st2, String.valueOf(filial), String.valueOf(codigoRequisicao));
                            }
                        }
                        Conexao.arquivaSQL();
                    }
                    catch (Exception ex) {
                        try {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ErrorLogger.mostraMensagem(FaturaExames.this, ex.getMessage(), ex.getStackTrace(), "FaturaExames");
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            Conexao.fecharStatement(st2, st3);
                            throw throwable;
                        }
                        Conexao.fecharStatement(st);
                        Conexao.fecharStatement(st2, st3);
                    }
                    Conexao.fecharStatement(st);
                    Conexao.fecharStatement(st2, st3);
                    FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames, linha);
                    FaturaExames.this.faturaSalva = false;
                }
            }
        });
        this.itemDeveGuiaExame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(FaturaExames.this.panelDireitoExames);
                int linha = FuncoesGerais.pegaLinhaSelecionada(FaturaExames.this.panelDireitoExames);
                ArrayList<DadosExameFaturamento> listaExames = null;
                DadosFaturamento dados = null;
                if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento) {
                    dados = (DadosFaturamento)linhas.getValueAt(linha, 1);
                    listaExames = dados.getExames();
                }
                if (listaExames != null && listaExames.size() > 0) {
                    TelaDeveGuiaExame telaDeveGuiaExame = new TelaDeveGuiaExame((Frame)Laboratorio.getInstancia(), listaExames);
                    telaDeveGuiaExame.setVisible(true);
                    try {
                        StringBuilder buf = new StringBuilder();
                        buf.append(" update examerequisicao ");
                        buf.append("    set exr_deveguia = ? ");
                        buf.append("  where fil_codigo = ? ");
                        buf.append("    and req_codigo = ? ");
                        buf.append("    and exa_codigo = ? ");
                        buf.append("    and mco_codigo = ? ");
                        PreparedStatement st = Conexao.getPreparedStatement(buf.toString());
                        for (int i = 0; i < listaExames.size(); ++i) {
                            DadosExameFaturamento exame = listaExames.get(i);
                            st.setBoolean(1, exame.getDeveGuia());
                            st.setInt(2, dados.getCodigoFilial());
                            st.setInt(3, dados.getRequisicao());
                            st.setString(4, exame.getCodigoExame());
                            st.setInt(5, exame.getCodigoMaterial());
                            st.executeUpdate();
                        }
                        Conexao.arquivaSQL();
                    }
                    catch (SQLException sqle) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(FaturaExames.this, "N\u00e3o foi poss\u00edvel atualizar dados dos exames.\n" + sqle.getMessage(), sqle.getStackTrace());
                    }
                    FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames, linha);
                    FaturaExames.this.faturaSalva = false;
                }
            }
        });
        this.itemAlterarGuiaExames.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block26: {
                    Statement stCon;
                    int linha;
                    block25: {
                        StringBuilder buf = new StringBuilder();
                        buf.append(" update examerequisicao ");
                        buf.append("    set exr_deveguia = ? ");
                        buf.append("       ,exr_guia = ? ");
                        buf.append("       ,exr_validadeguia = ? ");
                        buf.append("       ,exr_dataguia = ? ");
                        buf.append("  where fil_codigo = ? ");
                        buf.append("    and req_codigo = ? ");
                        buf.append("    and exa_codigo = ? ");
                        buf.append("    and mco_codigo = ? ");
                        PreparedStatement prstNormal = Conexao.getPreparedStatement(buf.toString());
                        buf.setLength(0);
                        buf.append(" update examerequisicaoguiaagrupada ");
                        buf.append("    set exg_guia = ? ");
                        buf.append("       ,exg_validadeguia = ? ");
                        buf.append("       ,exg_deveguia = ? ");
                        buf.append("       ,exg_dataguia = ? ");
                        buf.append("  where fil_codigo = ? ");
                        buf.append("    and exa_codigo = ? ");
                        buf.append("    and exa_codfilho = ? ");
                        buf.append("    and mco_codigo = ? ");
                        buf.append("    and mco_codfilho = ? ");
                        buf.append("    and req_codigo = ? ");
                        PreparedStatement prstAgrupado = Conexao.getPreparedStatement(buf.toString());
                        Dialog telaAlteracao = null;
                        ArrayList<DadosExameFaturamento> listaExames = null;
                        DadosFaturamento dados = null;
                        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(FaturaExames.this.panelDireitoExames);
                        linha = FuncoesGerais.pegaLinhaSelecionada(FaturaExames.this.panelDireitoExames);
                        if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento) {
                            dados = (DadosFaturamento)linhas.getValueAt(linha, 1);
                            telaAlteracao = new AlteraGuiasFaturamento((Frame)Laboratorio.getInstancia(), dados.getCodigoConvenio() != dados.getCodigoConvenioPrincipal(), Acesso.getAcesso(Long.parseLong("0600200116")));
                            ((AlteraGuiasFaturamento)telaAlteracao).setGuiasRequisicao(dados.getGuia(), dados.getGuiaPrincipal(), dados.isGuiaConferida());
                            listaExames = dados.getExames();
                            if (listaExames != null) {
                                for (int i = 0; i < listaExames.size(); ++i) {
                                    DadosExameFaturamento exame = listaExames.get(i);
                                    ((AlteraGuiasFaturamento)telaAlteracao).adicionarExame(dados.getCodigoFilial(), dados.getCodigoConvenio(), exame);
                                }
                            }
                        }
                        if (telaAlteracao == null) break block26;
                        telaAlteracao.setVisible(true);
                        if (((AbstractDialogoOKCancelar)telaAlteracao).getOK()) {
                            boolean isConsiderarGuiasConferidas = ((AlteraGuiasFaturamento)telaAlteracao).getConsiderarGuiasConferidas();
                            dados.setGuiaConferida(dados.isGuiaConferida() ? true : isConsiderarGuiasConferidas);
                            dados.setGuia(((AlteraGuiasFaturamento)telaAlteracao).getGuiaRequisicao());
                            dados.setGuiaPrincipal(((AlteraGuiasFaturamento)telaAlteracao).getGuiaPrincipalRequisicao());
                            try {
                                buf.setLength(0);
                                buf.append(" update requisicao ");
                                buf.append("    set req_guia = ? ");
                                buf.append("    ,req_guiaprincipal = ? ");
                                if (isConsiderarGuiasConferidas) {
                                    buf.append("  ,req_dataguiaconferida = COALESCE(req_dataguiaconferida, localtimestamp) ");
                                    buf.append("  ,usr_codguiaconferida = COALESCE(usr_codguiaconferida, ?) ");
                                }
                                buf.append("  where fil_codigo = ").append(dados.getCodigoFilial());
                                buf.append("    and req_codigo = ").append(dados.getRequisicao());
                                PreparedStatement prst = Conexao.getPreparedStatement(buf.toString());
                                prst.setString(1, dados.getGuia() == null ? null : StringUtil.textoDB(dados.getGuia()).trim());
                                prst.setString(2, dados.getGuiaPrincipal() == null ? null : StringUtil.textoDB(dados.getGuiaPrincipal()).trim());
                                if (isConsiderarGuiasConferidas) {
                                    prst.setString(3, Variaveis.login);
                                }
                                prst.executeUpdate();
                            }
                            catch (SQLException sqle) {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                ErrorLogger.mostraMensagem(FaturaExames.this, "N\u00e3o foi poss\u00edvel atualizar os dados da requisi\u00e7\u00e3o.\n" + sqle.getMessage(), sqle.getStackTrace());
                            }
                            ArrayList<DadosExameFaturamento> listaExamesConfigurados = ((AlteraGuiasFaturamento)telaAlteracao).getExames();
                            block17: for (int i = 0; i < listaExamesConfigurados.size(); ++i) {
                                DadosExameFaturamento exameAlterado = listaExamesConfigurados.get(i);
                                if (listaExames == null) continue;
                                for (int j = 0; j < listaExames.size(); ++j) {
                                    DadosExameFaturamento exame = listaExames.get(i);
                                    if (!exame.getCodigoExame().equalsIgnoreCase(exameAlterado.getCodigoExame())) continue;
                                    exame.setDeveGuia(exameAlterado.getDeveGuia());
                                    exame.setCodigoGuia(exameAlterado.getCodigoGuia());
                                    exame.setValidadeGuia(exameAlterado.getValidadeGuia());
                                    exame.setDataGuia(exameAlterado.getDataGuia());
                                    try {
                                        if (exame.getCodigoExame().equalsIgnoreCase(exame.getExamePai().getCodigo())) {
                                            prstNormal.setBoolean(1, exame.getDeveGuia());
                                            prstNormal.setString(2, exame.getCodigoGuia() == null ? null : exame.getCodigoGuia().trim());
                                            prstNormal.setDate(3, exame.getValidadeGuia() == null ? null : new java.sql.Date(exame.getValidadeGuia().getTime()));
                                            prstNormal.setDate(4, exame.getDataGuia() == null ? null : new java.sql.Date(exame.getDataGuia().getTime()));
                                            prstNormal.setInt(5, dados.getCodigoFilial());
                                            prstNormal.setInt(6, dados.getRequisicao());
                                            prstNormal.setString(7, exame.getCodigoExame());
                                            prstNormal.setInt(8, exame.getCodigoMaterial());
                                            prstNormal.executeUpdate();
                                            continue block17;
                                        }
                                        prstAgrupado.setString(1, exame.getCodigoGuia().trim());
                                        prstAgrupado.setDate(2, exame.getValidadeGuia() == null ? null : new java.sql.Date(exame.getValidadeGuia().getTime()));
                                        prstAgrupado.setBoolean(3, exame.getDeveGuia());
                                        prstAgrupado.setDate(4, exame.getDataGuia() == null ? null : new java.sql.Date(exame.getDataGuia().getTime()));
                                        prstAgrupado.setInt(5, dados.getCodigoFilial());
                                        prstAgrupado.setString(6, exame.getExamePai().getCodigo());
                                        prstAgrupado.setString(7, exame.getCodigoExame());
                                        prstAgrupado.setInt(8, exame.getExamePai().getMaterial());
                                        prstAgrupado.setInt(9, exame.getCodigoMaterial());
                                        prstAgrupado.setInt(10, dados.getRequisicao());
                                        prstAgrupado.executeUpdate();
                                    }
                                    catch (SQLException sqle) {
                                        try {
                                            Conexao.anulaSQL();
                                        }
                                        catch (SQLException sQLException) {
                                            // empty catch block
                                        }
                                        ErrorLogger.mostraMensagem(FaturaExames.this, "N\u00e3o foi poss\u00edvel atualizar dados do exame.\n" + sqle.getMessage(), sqle.getStackTrace());
                                    }
                                    continue block17;
                                }
                            }
                            try {
                                Conexao.arquivaSQL();
                            }
                            catch (SQLException e1) {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (SQLException exameAlterado) {
                                    // empty catch block
                                }
                                ErrorLogger.mostraMensagem(FaturaExames.this, "N\u00e3o foi poss\u00edvel gravar altera\u00e7\u00f5es.\n" + e1.getMessage(), e1.getStackTrace());
                            }
                        }
                        buf.setLength(0);
                        buf.append(" select con_faturaeletronica ");
                        buf.append("   from convenios ");
                        buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                        buf.append("    and con_codigo = ").append(dados.getCodigoConvenio());
                        stCon = Conexao.getStatement();
                        try {
                            String xml;
                            ResultSet rs = Conexao.executeQuery(stCon, buf);
                            if (!rs.next() || (xml = rs.getString("con_faturaeletronica")) == null || Funcoes.textoVazio(xml)) break block25;
                            String protocolo = StringUtil.getValor(xml, "protocolo");
                            FaturamentoEletronico fat = FabricaFaturaEletronica.novoFaturamentoEletronico(protocolo);
                            Registro reg = ((AbstractFaturamentoEletronico)((Object)fat)).parseXMLConfiguracao(xml);
                            ArrayList<DadosFaturamento> lista = new ArrayList<DadosFaturamento>();
                            lista.add(dados);
                            ((AbstractFaturamentoEletronico)((Object)fat)).verificaErrosFatura(lista, reg);
                        }
                        catch (Exception ex) {
                            try {
                                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel validar os dados para o faturamento eletr\u00f4nico.\n" + ex.getMessage(), ex.getStackTrace());
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(stCon);
                                throw throwable;
                            }
                            Conexao.fecharStatement(stCon);
                        }
                    }
                    Conexao.fecharStatement(stCon);
                    FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames, linha);
                    FaturaExames.this.faturaSalva = false;
                }
            }
        });
        this.itemReplicarGuia.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block28: {
                    TelaReplicarDadosGuia tela = new TelaReplicarDadosGuia((Frame)Laboratorio.getInstancia(), null);
                    tela.setVisible(true);
                    SplashMensagem splash = null;
                    try {
                        if (!tela.getOK()) break block28;
                        splash = SplashMensagem.getInstancia(FaturaExames.this);
                        splash.mostrar("Aguarde, os dados das guias est\u00e3o sendo atualizados.");
                        boolean isSubstituirGuias = tela.getSubstituirGuias();
                        StringBuilder buf = new StringBuilder();
                        buf.append(" update requisicao ");
                        if (isSubstituirGuias) {
                            buf.append("    set req_guiaprincipal = ? ");
                            buf.append("       ,req_guia = ? ");
                        } else {
                            buf.append("    set req_guiaprincipal = COALESCE(NULLIF(TRIM(req_guiaprincipal), ''), ?) ");
                            buf.append("       ,req_guia = COALESCE(NULLIF(TRIM(req_guia), ''), ?) ");
                        }
                        buf.append("  where fil_codigo = ? ");
                        buf.append("    and req_codigo = ? ");
                        PreparedStatement prstRequisicao = Conexao.getPreparedStatement(buf.toString());
                        buf.setLength(0);
                        buf.append(" update examerequisicao ");
                        if (isSubstituirGuias) {
                            buf.append("    set exr_guia = ? ");
                            buf.append("       ,exr_validadeguia = ? ");
                            buf.append("       ,exr_dataguia = ? ");
                        } else {
                            buf.append("    set exr_guia = COALESCE(NULLIF(TRIM(exr_guia), ''), ?) ");
                            buf.append("       ,exr_validadeguia = COALESCE(exr_validadeguia, ?) ");
                            buf.append("       ,exr_dataguia = COALESCE(exr_dataguia, ?) ");
                        }
                        buf.append("  where fil_codigo = ? ");
                        buf.append("    and req_codigo = ? ");
                        buf.append("    and exa_codigo = ? ");
                        buf.append("    and mco_codigo = ? ");
                        PreparedStatement prstExameNormal = Conexao.getPreparedStatement(buf.toString());
                        buf.setLength(0);
                        buf.append(" update examerequisicaoguiaagrupada ");
                        if (isSubstituirGuias) {
                            buf.append("    set exg_guia = ? ");
                            buf.append("       ,exg_validadeguia = ? ");
                            buf.append("       ,exg_dataguia = ? ");
                        } else {
                            buf.append("    set exg_guia = COALESCE(NULLIF(TRIM(exg_guia), ''), ?) ");
                            buf.append("       ,exg_validadeguia = COALESCE(exg_validadeguia, ?) ");
                            buf.append("       ,exg_dataguia = COALESCE(exg_dataguia, ?) ");
                        }
                        buf.append("  where fil_codigo = ? ");
                        buf.append("    and req_codigo = ? ");
                        buf.append("    and exa_codigo = ? ");
                        buf.append("    and exa_codfilho = ? ");
                        buf.append("    and mco_codigo = ? ");
                        buf.append("    and mco_codfilho = ? ");
                        PreparedStatement prstExameAgrupado = Conexao.getPreparedStatement(buf.toString());
                        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(FaturaExames.this.panelDireitoExames);
                        for (int i = 0; i < linhas.getRowCount(); ++i) {
                            DadosFaturamento requisicao;
                            if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento) || !(requisicao = (DadosFaturamento)linhas.getValueAt(i, 1)).getFaturar()) continue;
                            if (tela.getGuiaPrincipal() != null && (isSubstituirGuias || Funcoes.textoVazio(requisicao.getGuiaPrincipal()))) {
                                requisicao.setGuiaPrincipal(tela.getGuiaPrincipal());
                            }
                            if (tela.getGuiaRequisicao() != null && (isSubstituirGuias || Funcoes.textoVazio(requisicao.getGuia()))) {
                                requisicao.setGuia(tela.getGuiaRequisicao());
                            }
                            try {
                                prstRequisicao.setString(1, tela.getGuiaPrincipal());
                                prstRequisicao.setString(2, tela.getGuiaRequisicao());
                                prstRequisicao.setInt(3, requisicao.getCodigoFilial());
                                prstRequisicao.setInt(4, requisicao.getRequisicao());
                                prstRequisicao.executeUpdate();
                                Conexao.arquivaSQL();
                            }
                            catch (SQLException sqle) {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                ErrorLogger.mostraMensagem(FaturaExames.this, "N\u00e3o foi poss\u00edvel atualizar a guia principal da requisi\u00e7\u00e3o (Fil.: " + requisicao.getCodigoFilial() + ", Req.: " + requisicao.getRequisicao() + ").\n" + sqle.getMessage(), sqle.getStackTrace());
                            }
                            ArrayList<DadosExameFaturamento> listaExames = requisicao.getExames();
                            if (listaExames == null || tela.getGuiaExames() == null && tela.getValidadeGuia() == null && tela.getDataGuia() == null) continue;
                            DadosExameFaturamento exame = null;
                            try {
                                for (int j = 0; j < listaExames.size(); ++j) {
                                    exame = listaExames.get(j);
                                    if (!exame.getFaturar()) continue;
                                    if (tela.getGuiaExames() != null && (isSubstituirGuias || Funcoes.textoVazio(exame.getCodigoGuia()))) {
                                        exame.setCodigoGuia(tela.getGuiaExames());
                                    }
                                    if (tela.getDataGuia() != null && (isSubstituirGuias || exame.getDataGuia() == null)) {
                                        exame.setDataGuia(tela.getDataGuia());
                                    }
                                    if (tela.getValidadeGuia() != null && (isSubstituirGuias || exame.getValidadeGuia() == null)) {
                                        exame.setValidadeGuia(tela.getValidadeGuia());
                                    }
                                    if (exame.getCodigoExame().equalsIgnoreCase(exame.getExamePai().getCodigo())) {
                                        prstExameNormal.setString(1, tela.getGuiaExames());
                                        prstExameNormal.setDate(2, tela.getValidadeGuia() == null ? null : new java.sql.Date(tela.getValidadeGuia().getTime()));
                                        prstExameNormal.setDate(3, tela.getDataGuia() == null ? null : new java.sql.Date(tela.getDataGuia().getTime()));
                                        prstExameNormal.setInt(4, requisicao.getCodigoFilial());
                                        prstExameNormal.setInt(5, requisicao.getRequisicao());
                                        prstExameNormal.setString(6, exame.getCodigoExame());
                                        prstExameNormal.setInt(7, exame.getCodigoMaterial());
                                        prstExameNormal.executeUpdate();
                                        continue;
                                    }
                                    prstExameAgrupado.setString(1, tela.getGuiaExames());
                                    prstExameAgrupado.setDate(2, tela.getValidadeGuia() == null ? null : new java.sql.Date(tela.getValidadeGuia().getTime()));
                                    prstExameAgrupado.setDate(3, tela.getDataGuia() == null ? null : new java.sql.Date(tela.getDataGuia().getTime()));
                                    prstExameAgrupado.setInt(4, requisicao.getCodigoFilial());
                                    prstExameAgrupado.setInt(5, requisicao.getRequisicao());
                                    prstExameAgrupado.setString(6, exame.getExamePai().getCodigo());
                                    prstExameAgrupado.setString(7, exame.getCodigoExame());
                                    prstExameAgrupado.setInt(8, exame.getExamePai().getMaterial());
                                    prstExameAgrupado.setInt(9, exame.getCodigoMaterial());
                                    prstExameAgrupado.executeUpdate();
                                }
                                Conexao.arquivaSQL();
                                continue;
                            }
                            catch (SQLException sqle) {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (SQLException sQLException) {
                                    // empty catch block
                                }
                                buf.setLength(0);
                                buf.append("Erro ao atualizar dados dos exames (");
                                buf.append("Fil.: ").append(requisicao.getCodigoFilial());
                                buf.append(", Req.: ").append(requisicao.getRequisicao());
                                if (exame.getCodigoExame().equalsIgnoreCase(exame.getExamePai().getCodigo())) {
                                    buf.append(", Exa.: ").append(exame.getCodigoExame());
                                    buf.append(", Mat.: ").append(exame.getCodigoMaterial());
                                } else {
                                    buf.append(", Exa. pai: ").append(exame.getExamePai().getCodigo());
                                    buf.append(", Mat. pai: ").append(exame.getExamePai().getMaterial());
                                    buf.append(", Exa. filho: ").append(exame.getCodigoExame());
                                    buf.append(", Mat. filho: ").append(exame.getCodigoMaterial());
                                }
                                buf.append(").\n");
                                ErrorLogger.mostraMensagem(FaturaExames.this, buf.toString() + sqle.getMessage(), sqle.getStackTrace());
                            }
                        }
                        FuncoesGerais.repaintTabela(FaturaExames.this.panelDireitoExames);
                        FaturaExames.this.faturaSalva = false;
                    }
                    finally {
                        if (splash != null) {
                            splash.apagar();
                        }
                    }
                }
            }
        });
    }

    protected boolean verificarSeTodosOsMedicosPossuemCbos(ArrayList<DadosFaturamento> requisicoes) {
        HashMap<String, String> medicosSemCBOS = new HashMap<String, String>();
        for (DadosFaturamento requisicao : requisicoes) {
            String crmDoMedico = requisicao.getCRMMedico();
            String ufDoMedico = requisicao.getUFMedico();
            String nomeDoMedico = requisicao.getNomeMedico();
            String xmlDoCbo = requisicao.getXmlCbo();
            if (!Funcoes.textoVazio(xmlDoCbo) || medicosSemCBOS.containsKey(crmDoMedico)) continue;
            medicosSemCBOS.put(crmDoMedico, crmDoMedico + " - " + ufDoMedico + " - " + nomeDoMedico);
        }
        if (!medicosSemCBOS.isEmpty() && null != medicosSemCBOS) {
            VisualizaErrosBPA.novaInstancia(Laboratorio.getInstancia(), "M\u00e9dicos sem CBOS informado.", medicosSemCBOS, true);
            return false;
        }
        return true;
    }

    private void imprimirGuia(boolean imprimirTodas, int tipoGuia) {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        ArrayList<String> errosGeracao = new ArrayList<String>();
        if (imprimirTodas) {
            ImprimirGuia.validarImprimirGuias(tipoGuia, linhas, errosGeracao, false, this);
            if (!errosGeracao.isEmpty()) {
                VisualizaErros ve = VisualizaErros.novaInstancia(this.getTopLevelAncestor(), "Configura\u00e7\u00f5es incorretas para imprimir as guias verifique!", errosGeracao);
                if (ve != null) {
                    ve.dispose();
                }
            } else {
                ImprimirGuia.validarImprimirGuias(tipoGuia, linhas, errosGeracao, true, this);
            }
            FuncoesGerais.repaintTabela(this.panelDireitoExames);
        } else {
            Integer linha;
            Integer n = linha = imprimirTodas ? null : Integer.valueOf(FuncoesGerais.pegaLinhaSelecionada(this.panelDireitoExames));
            if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento) {
                ImprimirGuia.validarImprimirGuia(tipoGuia, linhas, errosGeracao, false, this, linha);
                if (!errosGeracao.isEmpty()) {
                    VisualizaErros ve = VisualizaErros.novaInstancia(this.getTopLevelAncestor(), "Configura\u00e7\u00f5es incorretas para imprimir as guias verifique!", errosGeracao);
                    if (ve != null) {
                        ve.dispose();
                    }
                } else {
                    ImprimirGuia.validarImprimirGuia(tipoGuia, linhas, errosGeracao, true, this, linha);
                }
                FuncoesGerais.repaintTabela(this.panelDireitoExames, linha);
            } else {
                Funcoes.mensagem(this, "Nenhuma requisi\u00e7\u00e3o selecionada.", 2);
            }
        }
        this.faturaSalva = false;
    }

    private void novo() {
        this.limpaCampos();
        this.status = 2;
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.txtDataInicio);
        if (this.itemConvenio.isSelected() && null != this.itemConvenio.getConsultaFixa()) {
            this.validarConveniosSelecionado();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validarConveniosSelecionado() {
        Statement st = Conexao.getStatement();
        boolean selecaoOK = false;
        try {
            StringBuilder buf = new StringBuilder("select distinct a.con_codigo, b.con_fantasia from requisicao a ");
            buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
            buf.append("left join examerequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo ");
            buf.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo and c.exa_codigo = d.exa_codigo and c.mco_codigo = d.mco_codigo ");
            buf.append("left join exames e on a.fil_codigo = e.fil_codigo and c.exa_codigo = e.exa_codigo ");
            buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and a.req_dtfatura >= '").append(Funcoes.formataData("MM/dd/yyyy", this.dataInicialConvenios)).append("' ");
            buf.append(" and a.req_dtfatura <= '").append(Funcoes.formataData("MM/dd/yyyy", this.dataFinalConvenios)).append("' ");
            buf.append(" and a.req_excluida = false ");
            buf.append(" and c.exr_excluido = false ");
            buf.append(" and d.emc_proibido = false and e.exa_proibido = false ");
            buf.append(" and (c.exr_naofaturar <> true or c.exr_naofaturar is null) ");
            buf.append(" and c.exr_datafatura is null ");
            buf.append(" and c.exr_datacortesia is null ");
            buf.append(" and (case b.con_fatfmaterial when false then c.exr_situacao <> '");
            buf.append("F").append("' else c.exr_situacao <> '.' end) ");
            buf.append(" and (case b.con_faturarrecoleta when false then c.exr_situacao <> '");
            buf.append("R").append("' else c.exr_situacao <> '..' end) ");
            buf.append("order by a.con_codigo ");
            ResultSet rs = Conexao.executeQuery(st, buf);
            ArrayList<Object[]> lista = new ArrayList<Object[]>();
            while (rs.next()) {
                lista.add(new Object[]{rs.getInt("con_codigo"), rs.getString("con_fantasia")});
            }
            this.itemConvenio.setConsultaFixa(lista);
            selecaoOK = lista.size() > 0;
        }
        catch (Exception e2) {
            try {
                ErrorLogger.mostraMensagem(this, e2.getMessage(), e2.getStackTrace(), "FaturaExames: 588");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        if (selecaoOK) {
            this.itemConvenio.setSelected(true);
        }
    }

    private void imprimirResultado(boolean imprimirTodos) {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        if (imprimirTodos) {
            for (int i = 0; i < linhas.getRowCount(); ++i) {
                if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento) || !((DadosFaturamento)linhas.getValueAt(i, 1)).getFaturar()) continue;
                int codigoRequisicao = ((DadosFaturamento)linhas.getValueAt(i, 1)).getRequisicao();
                String codigoFilial = String.valueOf(((DadosFaturamento)linhas.getValueAt(i, 1)).getCodigoFilial());
                try {
                    RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(impressoraSelecionada, this.getTopLevelAncestor(), codigoFilial, String.valueOf(codigoRequisicao), true, false, false);
                    if (!Funcoes.textoVazio(impressoraSelecionada)) continue;
                    impressoraSelecionada = retorno.getImpressoraSelecionada();
                    continue;
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FaturaExames (1879)");
                }
            }
            FuncoesGerais.repaintTabela(this.panelDireitoExames);
        } else {
            Integer linha;
            Integer n = linha = imprimirTodos ? null : Integer.valueOf(FuncoesGerais.pegaLinhaSelecionada(this.panelDireitoExames));
            if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento && ((DadosFaturamento)linhas.getValueAt(linha, 1)).getFaturar()) {
                ArrayList<DadosExameFaturamento> exames = null;
                ArrayList<String> arrayExames = null;
                ArrayList<String> arrayMateriais = null;
                DadosFaturamento dados = (DadosFaturamento)linhas.getValueAt(linha, 1);
                try {
                    ExamesNaoFaturar examesNaoFaturar = ExamesNaoFaturar.getNovaInstancia(this.getTopLevelAncestor());
                    examesNaoFaturar.setTitle("Selecionar exames");
                    examesNaoFaturar.setExames(String.valueOf(dados.getCodigoFilial()), dados.getExames());
                    examesNaoFaturar.setVisible(true);
                    if (!examesNaoFaturar.isOK()) {
                        return;
                    }
                    exames = examesNaoFaturar.getExamesDesmarcados();
                }
                catch (Exception e) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel selecionar os exames para impress\u00e3o", 1);
                    return;
                }
                if (exames != null) {
                    for (int i = 0; i < dados.getExamesCount(); ++i) {
                        DadosExameFaturamento auxExame = dados.getExame(i);
                        if (exames.contains(auxExame)) continue;
                        if (arrayExames == null) {
                            arrayExames = new ArrayList<String>();
                        }
                        if (arrayMateriais == null) {
                            arrayMateriais = new ArrayList<String>();
                        }
                        arrayExames.add(auxExame.getExamePai() != null ? auxExame.getExamePai().getCodigo() : auxExame.getCodigoExame());
                        arrayMateriais.add(String.valueOf(auxExame.getExamePai() != null ? auxExame.getExamePai().getMaterial() : auxExame.getCodigoMaterial().intValue()));
                    }
                }
                int codigoRequisicao = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getRequisicao();
                String codigoFilial = String.valueOf(((DadosFaturamento)linhas.getValueAt(linha, 1)).getCodigoFilial());
                try {
                    RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(impressoraSelecionada, this.getTopLevelAncestor(), codigoFilial, String.valueOf(codigoRequisicao), true, ParametrosGerais.getConferencia(), null, arrayExames != null ? arrayExames.toArray(new String[arrayExames.size()]) : null, arrayMateriais != null ? arrayMateriais.toArray(new String[arrayMateriais.size()]) : null, false, "", false, false, null, false, "", false, false, false);
                    if (Funcoes.textoVazio(impressoraSelecionada)) {
                        impressoraSelecionada = retorno.getImpressoraSelecionada();
                    }
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FaturaExames (1896)");
                }
                FuncoesGerais.repaintTabela(this.panelDireitoExames, linha);
            } else {
                Funcoes.mensagem(this, "Nenhuma requisi\u00e7\u00e3o selecionada para impress\u00e3o.", 2);
            }
        }
        this.faturaSalva = false;
    }

    public void montaFiltros() {
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 1.0;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.panelEsquerdo.add((Component)this.itemColeta, this.constraints);
        this.constraints.gridy = 1;
        this.panelEsquerdo.add((Component)this.itemDestino, this.constraints);
        this.constraints.gridy = 2;
        this.panelEsquerdo.add((Component)this.itemEstacao, this.constraints);
        this.constraints.gridy = 3;
        this.panelEsquerdo.add((Component)this.itemConvenio, this.constraints);
        this.constraints.gridy = 4;
        this.panelEsquerdo.add((Component)this.itemSetor, this.constraints);
        this.constraints.gridy = 5;
        this.panelEsquerdo.add((Component)this.itemGrupo, this.constraints);
        this.constraints.gridy = 6;
        this.panelEsquerdo.add((Component)this.itemMedico, this.constraints);
        this.constraints.gridy = 7;
        this.panelEsquerdo.add((Component)this.itemSituacao, this.constraints);
        this.constraints.gridy = 8;
        this.panelEsquerdo.add((Component)this.itemPaciente, this.constraints);
        this.constraints.gridy = 9;
        this.panelEsquerdo.add((Component)this.itemExame, this.constraints);
        this.constraints.gridy = 10;
        this.panelEsquerdo.add((Component)this.itemSituacaoExames, this.constraints);
        this.constraints.gridy = 11;
        this.panelEsquerdo.add((Component)this.itemUnidadeSaude, this.constraints);
        this.constraints.gridy = 12;
        this.panelEsquerdo.add((Component)this.itemEmpresa, this.constraints);
        this.constraints.gridy = 13;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 1;
        this.constraints.weightx = 0.0;
        this.panelEsquerdo.add((Component)this.labelDataInicio, this.constraints);
        this.constraints.gridy = 14;
        this.panelEsquerdo.add((Component)this.labelDataFim, this.constraints);
        this.constraints.gridy = 15;
        this.panelEsquerdo.add((Component)this.labelHoraInicio, this.constraints);
        this.constraints.gridy = 16;
        this.panelEsquerdo.add((Component)this.labelHoraFim, this.constraints);
        this.constraints.gridy = 17;
        this.panelEsquerdo.add((Component)this.labelVencimento, this.constraints);
        this.constraints.gridx = 2;
        this.constraints.gridy = 13;
        this.buttonDataInicio.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicio.setMinimumSize(new Dimension(20, 20));
        this.panelEsquerdo.add((Component)this.buttonDataInicio, this.constraints);
        this.constraints.gridy = 14;
        this.buttonDataFim.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFim.setMinimumSize(new Dimension(20, 20));
        this.panelEsquerdo.add((Component)this.buttonDataFim, this.constraints);
        this.constraints.gridy = 17;
        this.buttonVencimento.setPreferredSize(new Dimension(20, 20));
        this.buttonVencimento.setMinimumSize(new Dimension(20, 20));
        this.panelEsquerdo.add((Component)this.buttonVencimento, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 13;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 1;
        this.constraints.weightx = 1.0;
        this.txtDataInicio.setPreferredSize(new Dimension(90, 20));
        this.txtDataInicio.setMinimumSize(new Dimension(90, 20));
        this.panelEsquerdo.add((Component)this.txtDataInicio, this.constraints);
        this.constraints.gridy = 14;
        this.txtDataFim.setPreferredSize(new Dimension(90, 20));
        this.txtDataFim.setMinimumSize(new Dimension(90, 20));
        this.panelEsquerdo.add((Component)this.txtDataFim, this.constraints);
        this.constraints.gridy = 15;
        this.txtHoraInicio.setPreferredSize(new Dimension(90, 20));
        this.txtHoraInicio.setMinimumSize(new Dimension(90, 20));
        this.panelEsquerdo.add((Component)this.txtHoraInicio, this.constraints);
        this.constraints.gridy = 16;
        this.txtHoraFim.setPreferredSize(new Dimension(90, 20));
        this.txtHoraFim.setMinimumSize(new Dimension(90, 20));
        this.panelEsquerdo.add((Component)this.txtHoraFim, this.constraints);
        this.constraints.gridy = 17;
        this.txtVencimento.setPreferredSize(new Dimension(90, 20));
        this.txtVencimento.setMinimumSize(new Dimension(90, 20));
        this.panelEsquerdo.add((Component)this.txtVencimento, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 18;
        this.constraints.gridwidth = 3;
        this.panelEsquerdo.add((Component)this.checkConferidas, this.constraints);
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            this.constraints.gridy = 19;
            this.panelEsquerdo.add((Component)this.checkComResultado, this.constraints);
        }
        ++this.constraints.gridy;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 0.0;
        this.buttonFaturar.setPreferredSize(new Dimension(100, 20));
        this.buttonFaturar.setMinimumSize(new Dimension(100, 20));
        this.panelEsquerdo.add((Component)this.buttonFaturar, this.constraints);
        ++this.constraints.gridy;
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.panelEsquerdo.add((Component)new JPanel(), this.constraints);
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0600200100");
    }

    @Override
    public void pressioneiF2() {
        if (this.txtDataInicio.hasFocus()) {
            Funcoes.mostraData(this.txtDataInicio, this.buttonDataInicio, this.panelEsquerdo, true);
        } else if (this.txtDataFim.hasFocus()) {
            Funcoes.mostraData(this.txtDataFim, this.buttonDataFim, this.panelEsquerdo, true);
        } else if (this.txtVencimento.hasFocus()) {
            Funcoes.mostraData(this.txtVencimento, this.buttonVencimento, this.panelEsquerdo, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pesquisaFaturamento() {
        if (!Funcoes.verificaData(this.txtDataInicio.getText()) || !Funcoes.verificaData(this.txtDataFim.getText())) {
            Funcoes.mensagem(this, "Data inv\u00e1lida para faturamento", 1);
            this.txtDataInicio.grabFocus();
            return;
        }
        if (!Funcoes.textoVazio(this.txtHoraInicio.getText()) && !Funcoes.verificaHora(this.txtHoraInicio.getText()) || !Funcoes.textoVazio(this.txtHoraFim.getText()) && !Funcoes.verificaHora(this.txtHoraFim.getText())) {
            Funcoes.mensagem(this, "Hora inv\u00e1lida para faturamento", 1);
            this.txtHoraInicio.grabFocus();
            return;
        }
        if (!Funcoes.verificaData(this.txtVencimento.getText())) {
            Funcoes.mensagem(this, "Data inv\u00e1lida para vencimento", 1);
            this.txtVencimento.grabFocus();
            return;
        }
        if (!this.itemConvenio.isSelected() || this.itemConvenio.isSelected() && (this.itemConvenio.getSelecionados(0) == null || this.itemConvenio.getSelecionados(0).length <= 0)) {
            Funcoes.mensagem(this, "Nenhum conv\u00eanio foi selecionado", 1);
            return;
        }
        try {
            FaturaExamesService serviceFatura = new FaturaExamesService();
            String ordemFaturaAnterior = "";
            for (String convenio : this.itemConvenio.getSelecionados()) {
                String ordemFatura = serviceFatura.getTipoOrdemFaturaConvenio(Conexao.getStatement(), Variaveis.filialPadrao, convenio);
                if (this.validarOrdenacaoFatura(ordemFatura, ordemFaturaAnterior)) {
                    Funcoes.mensagem(this, "Conv\u00eanios selecionados com ordena\u00e7\u00e3o de faturas diferentes.", 1);
                    return;
                }
                ordemFaturaAnterior = ordemFatura;
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FaturaExames (934)");
        }
        this.buttonFaturar.setEnabled(false);
        this.panelDireitoExames.removeAll();
        Laboratorio.getInstancia().setInterromperInfoRequisicao(true);
        BuscaRequisicoes consulta = new BuscaRequisicoes((Frame)this.getTopLevelAncestor(), this.panelDireitoExames, this.buttonFaturar, true, this.itemCheckVerificarNaoConferidos.isSelected(), this.itemCheckExibirMarcadosNaoFaturar.isSelected());
        if (this.itemColeta.isSelected()) {
            consulta.setFiltroColeta(this.itemColeta.getSelecionados(0));
        }
        if (this.itemDestino.isSelected()) {
            consulta.setFiltroDestino(this.itemDestino.getSelecionados(0));
        }
        if (this.itemEstacao.isSelected()) {
            consulta.setFiltroEstacao(this.itemEstacao.getSelecionados(0));
        }
        if (this.itemConvenio.isSelected()) {
            consulta.setFiltroConvenio(this.itemConvenio.getSelecionados(0));
        }
        if (this.itemSetor.isSelected()) {
            consulta.setFiltroSetor(this.itemSetor.getSelecionados(0));
        }
        if (this.itemGrupo.isSelected()) {
            consulta.setFiltroGrupo(this.itemGrupo.getSelecionados(0));
        }
        if (this.itemMedico.isSelected()) {
            consulta.setFiltroMedicoConselho(this.itemMedico.getSelecionadosAvancado(0));
            consulta.setFiltroMedicoCrm(this.itemMedico.getSelecionadosAvancado(1));
            consulta.setFiltroMedicoUF(this.itemMedico.getSelecionadosAvancado(2));
        }
        if (this.itemSituacao.isSelected()) {
            consulta.setFiltroSituacao(this.itemSituacao.getSelecionados(0));
        }
        if (this.itemPaciente.isSelected()) {
            consulta.setFiltroPaciente(this.itemPaciente.getSelecionadosAvancado(0));
        }
        if (this.itemExame.isSelected()) {
            consulta.setFiltroExame(this.itemExame.getSelecionados(0));
        }
        if (this.itemUnidadeSaude.isSelected()) {
            consulta.setFiltroUnidadeSaude(this.itemUnidadeSaude.getSelecionados(0));
        }
        if (this.itemSituacaoExames.isSelected()) {
            consulta.setFiltroSituacaoExames(this.itemSituacaoExames.getSelecionados(0));
        }
        if (this.itemEmpresa.isSelected()) {
            consulta.setFiltroEmpresa(this.itemEmpresa.getSelecionados(0));
        }
        consulta.setDataInicio(this.txtDataInicio.getText());
        consulta.setDataFim(this.txtDataFim.getText());
        consulta.setHoraInicio(this.txtHoraInicio.getText());
        consulta.setHoraFim(this.txtHoraFim.getText());
        consulta.setApenasConferidas(this.checkConferidas.isSelected());
        consulta.setApenasComResultado(this.checkComResultado.isSelected());
        consulta.addThreadListener(this);
        consulta.start();
        if (this.itemConvenio.isSelected() && this.itemConvenio.getSelecionados(0).length > 0) {
            Statement st;
            block35: {
                StringBuilder buf = new StringBuilder();
                buf.append("select b.con_codigo from convenios b ");
                buf.append("where b.fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                buf.append(" and b.con_codigo = ");
                buf.append(this.itemConvenio.getSelecionados(0)[0]);
                buf.append(" and b.con_faturaagrupada = true ");
                st = Conexao.getStatement();
                try {
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (!rs.next()) break block35;
                    this.imprimirAgrupada = true;
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FaturaExames (934)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
        String[] conv = this.itemConvenio.getSelecionados(0);
        StringBuilder bui = new StringBuilder();
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_observ ");
        buf.append("       ,con_faturaeletronica ");
        buf.append("   from convenios ");
        buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and con_codigo in (");
        for (String c : conv) {
            if (bui.length() > 0) {
                bui.append(", ");
            }
            bui.append(c);
        }
        buf.append(bui.toString());
        buf.append(")");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            bui.setLength(0);
            while (rs.next()) {
                if (Funcoes.textoVazio(rs.getString("con_observ"))) continue;
                bui.append(rs.getString("con_observ")).append("\n\n");
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FaturaExames: 934");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        if (bui.length() > 0) {
            this.textObs.setText(bui.toString());
            ScreenUtil.posicionaTextoTopo(this.textObs);
            this.panelDireitoObs.setVisible(true);
            this.chamaAtencao.start();
        } else {
            this.panelDireitoObs.setVisible(false);
        }
    }

    private boolean validarOrdenacaoFatura(String ordemFatura, String ordemFaturaAnterior) {
        return !Funcoes.textoVazio(ordemFaturaAnterior) && !ordemFatura.equals(ordemFaturaAnterior) && (ordemFatura.equals("S") || ordemFaturaAnterior.equals("S"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marcarExameParaNaoFaturar() {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        int linha = FuncoesGerais.pegaLinhaSelecionada(this.panelDireitoExames);
        if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento) {
            ExamesNaoFaturar examesNaoFaturar;
            boolean atualizarTotal;
            SalvaDados salvar;
            Statement st;
            DadosFaturamento dados;
            block13: {
                dados = (DadosFaturamento)linhas.getValueAt(linha, 1);
                st = Conexao.getStatement();
                salvar = new SalvaDados("examerequisicao", 2);
                salvar.adicionaCampo("fil_codigo", 2, false, true);
                salvar.adicionaCampo("req_codigo", 2, true, true);
                salvar.adicionaCampo("exa_codigo", 0, true, true);
                salvar.adicionaCampo("mco_codigo", 2, true, true);
                salvar.adicionaCampo("exr_naofaturar", 4, true, false);
                salvar.adicionaCampo("usr_codnaofaturar", 0, true, false);
                salvar.setValor("fil_codigo", dados.getCodigoFilial());
                salvar.setValor("req_codigo", dados.getRequisicao());
                atualizarTotal = false;
                examesNaoFaturar = ExamesNaoFaturar.getNovaInstancia(this.getTopLevelAncestor());
                examesNaoFaturar.setExames(String.valueOf(dados.getCodigoFilial()), dados.getExames());
                examesNaoFaturar.setVisible(true);
                if (examesNaoFaturar.isOK()) break block13;
                Conexao.fecharStatement(st);
                return;
            }
            try {
                ArrayList<DadosExameFaturamento> exames = examesNaoFaturar.getExamesDesmarcados();
                int contadorFaturar = 0;
                for (int i = 0; i < dados.getExamesCount(); ++i) {
                    DadosExameFaturamento auxExame = dados.getExame(i);
                    salvar.setValor("exa_codigo", auxExame.getExamePai() != null ? auxExame.getExamePai().getCodigo() : auxExame.getCodigoExame());
                    salvar.setValor("mco_codigo", auxExame.getExamePai() != null ? auxExame.getExamePai().getMaterial() : auxExame.getCodigoMaterial().intValue());
                    if (exames.contains(auxExame)) {
                        salvar.setValor("exr_naofaturar", true);
                        salvar.setValor("usr_codnaofaturar", Variaveis.login);
                        Conexao.execute(String.valueOf(dados.getCodigoFilial()), st, salvar.getComando());
                        if (auxExame.getFaturar()) {
                            atualizarTotal = true;
                        }
                        auxExame.setMarcadoNaoFaturar(false);
                        auxExame.setFaturar(false);
                        continue;
                    }
                    salvar.setValor("exr_naofaturar", false);
                    salvar.setValor("usr_codnaofaturar", null);
                    Conexao.execute(String.valueOf(dados.getCodigoFilial()), st, salvar.getComando());
                    if (!auxExame.getFaturar()) {
                        atualizarTotal = true;
                    }
                    auxExame.setMarcadoNaoFaturar(true);
                    auxExame.setFaturar(true);
                    ++contadorFaturar;
                }
                dados.setFaturar(contadorFaturar > 0);
                if (atualizarTotal) {
                    Calculos.calculaTotalRequisicao(dados);
                    Calculos.calculaTotal(st, linhas.getRowCount() - 1, FuncoesGerais.pegaTabela(this.panelDireitoExames), linhas);
                }
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FaturaExames (858)");
                    ex.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    public void controlaCampos() {
        boolean habilita = this.status == 2 && !this.executandoBusca;
        this.itemColeta.setEnabled(habilita && !this.faturaSalva);
        this.itemDestino.setEnabled(habilita && !this.faturaSalva);
        this.itemEstacao.setEnabled(habilita && !this.faturaSalva);
        this.itemConvenio.setEnabled(habilita && !this.faturaSalva);
        this.itemSetor.setEnabled(habilita && !this.faturaSalva);
        this.itemGrupo.setEnabled(habilita && !this.faturaSalva);
        this.itemMedico.setEnabled(habilita && !this.faturaSalva);
        this.itemSituacao.setEnabled(habilita && !this.faturaSalva);
        this.itemPaciente.setEnabled(habilita && !this.faturaSalva);
        this.itemExame.setEnabled(habilita && !this.faturaSalva);
        this.itemUnidadeSaude.setEnabled(habilita && !this.faturaSalva);
        this.itemEmpresa.setEnabled(habilita && !this.faturaSalva);
        this.itemSituacaoExames.setEnabled(habilita && !this.faturaSalva);
        this.itemReplicarGuia.setEnabled(habilita && this.itemPaciente.getSelecionadosAvancado() != null && (this.itemPaciente.getSelecionadosAvancado().length == 1 || this.itemPaciente.getSelecionadosAvancado().length > 1 && Acesso.getAcesso(ACESSO_PERMITIR_VARIOS_PACIENTES)));
        this.txtDataInicio.setEnabled(habilita && !this.faturaSalva);
        this.txtDataFim.setEnabled(habilita && !this.faturaSalva);
        this.txtHoraInicio.setEnabled(habilita && !this.faturaSalva);
        this.txtHoraFim.setEnabled(habilita && !this.faturaSalva);
        this.txtVencimento.setEnabled(habilita && !this.faturaSalva);
        this.buttonDataFim.setEnabled(habilita && !this.faturaSalva);
        this.buttonDataInicio.setEnabled(habilita && !this.faturaSalva);
        this.buttonVencimento.setEnabled(habilita && !this.faturaSalva);
        this.checkConferidas.setEnabled(habilita && !this.faturaSalva);
        this.checkComResultado.setEnabled(habilita && !this.faturaSalva);
        if (!this.executandoBusca) {
            this.buttonNovo.setEnabled(!habilita || this.faturaSalva);
            this.buttonFechar.setEnabled(!habilita || this.faturaSalva);
        } else {
            this.buttonNovo.setEnabled(false);
            this.buttonFechar.setEnabled(false);
        }
        this.buttonSalvar.setEnabled(habilita && !this.faturaSalva && !this.faturaConferida && FuncoesGerais.pegaTabela(this.panelDireitoExames) != null && FuncoesGerais.pegaTabela(this.panelDireitoExames).getModel().getRowCount() > 0 && this.codigoFatura <= 0);
        this.buttonCancelar.setEnabled(habilita && !this.faturaSalva);
        this.buttonImprimir.setEnabled(habilita && FuncoesGerais.pegaTabela(this.panelDireitoExames) != null && FuncoesGerais.pegaTabela(this.panelDireitoExames).getModel().getRowCount() > 0);
        this.buttonEletronico.setEnabled(habilita && FuncoesGerais.pegaTabela(this.panelDireitoExames) != null && FuncoesGerais.pegaTabela(this.panelDireitoExames).getModel().getRowCount() > 0);
        this.buttonOpcoes.setEnabled(habilita && !this.faturaSalva);
        this.buttonFaturar.setEnabled(habilita && !this.faturaSalva);
        this.itemImprimirNota.setEnabled(habilita && !this.notaFiscalAssociada);
    }

    private void limpaCampos() {
        Laboratorio.getInstancia().setInterromperInfoRequisicao(false);
        this.codigoFatura = -1;
        this.faturaSalva = false;
        this.itemColeta.clear();
        this.itemDestino.clear();
        this.itemEstacao.clear();
        if (this.itemConvenio.getConsultaFixa() == null) {
            this.itemConvenio.clear();
        }
        this.itemSetor.clear();
        this.itemGrupo.clear();
        this.itemMedico.clear();
        this.itemSituacao.clear();
        this.itemPaciente.clear();
        this.itemExame.clear();
        this.itemUnidadeSaude.clear();
        this.itemEmpresa.clear();
        this.txtDataInicio.clear();
        this.txtDataFim.clear();
        this.txtHoraInicio.clear();
        this.txtHoraFim.clear();
        this.txtVencimento.clear();
        this.itemSituacaoExames.clear();
        this.faturaConferida = false;
        this.faturaSalva = false;
        this.notaFiscalAssociada = false;
        this.chamaAtencao.stop();
        this.titledObs.setTitleColor(this.foregroundObs);
        this.panelDireitoObs.setVisible(false);
        if (this.dataInicialConvenios != null && this.dataFinalConvenios != null) {
            this.txtDataInicio.setText(Funcoes.formataData("dd/MM/yyyy", this.dataInicialConvenios));
            this.txtDataFim.setText(Funcoes.formataData("dd/MM/yyyy", this.dataFinalConvenios));
        }
        this.panelDireitoExames.removeAll();
        this.panelDireitoExames.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean salvar() {
        DadosTotalGeral total;
        String msg;
        SplashMensagem splash;
        StringBuilder buf;
        Statement st;
        LinhasTabela modeloFatura;
        boolean retorno;
        block49: {
            retorno = true;
            System.gc();
            modeloFatura = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
            if (modeloFatura == null || modeloFatura.getRowCount() == 1 && modeloFatura.getValueAt(0, 0) instanceof DadosTotalGeral) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 requisi\u00e7\u00f5es \u00e0 serem faturadas", 2);
                return false;
            }
            if (!FuncoesGerais.haExamesFaturamento(this.panelDireitoExames)) {
                Funcoes.mensagem(this, "Deve haver pelo menos um exame selecionado para salvar o faturamento.", 2);
                return false;
            }
            st = Conexao.getStatement();
            buf = new StringBuilder();
            splash = SplashMensagem.getInstancia(this);
            msg = "Aguarde, salvando dados do faturamento. ";
            splash.mostrar(msg);
            if (modeloFatura.getValueAt(modeloFatura.getRowCount() - 1, 0) instanceof DadosTotalGeral) {
                total = (DadosTotalGeral)modeloFatura.getValueAt(modeloFatura.getRowCount() - 1, 0);
                break block49;
            }
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel obter dados para faturamento", 1);
            boolean bl = false;
            Conexao.fecharStatement(st);
            splash.apagar();
            System.gc();
            return bl;
        }
        try {
            String codigo = DBUtil.getSequencia(st, "fatura", true);
            this.codigoFatura = Integer.parseInt(codigo);
            if (this.itemConvenio.getSelecionados(0) != null) {
                this.codigoConvenio = this.itemConvenio.getSelecionados(0)[0];
            }
            buf.delete(0, buf.length());
            buf.append(" insert ");
            buf.append("   into fatura (fil_codigo ");
            buf.append("               ,fat_codigo ");
            buf.append("               ,fat_dtemis ");
            buf.append("               ,fat_dtvenc ");
            buf.append("               ,fat_dtinicio ");
            buf.append("               ,fat_dtfim ");
            buf.append("               ,fat_qtderequisicao ");
            buf.append("               ,fat_qtdeexames ");
            buf.append("               ,fat_totalexames ");
            buf.append("               ,fat_totalexamesch ");
            buf.append("               ,fat_totalmateriais ");
            buf.append("               ,fat_percdesconto ");
            buf.append("               ,fat_percacrescimo ");
            buf.append("               ,fat_despcobranca ");
            buf.append("               ,fat_adicional ");
            buf.append("               ,fat_mensagem ");
            buf.append("               ,con_codigo ");
            buf.append("               ,usr_codigo ");
            buf.append("               ,fat_datahora ");
            buf.append("               ,fat_descricaoacrescimo ");
            buf.append("               ,fat_descricaodesconto ");
            buf.append("               ,fat_qtdeguias ");
            buf.append(" ) ");
            buf.append(" values (").append(Variaveis.filialPadrao);
            buf.append("        ,").append(codigo);
            buf.append("        ,current_date ");
            buf.append("        ,'").append(Funcoes.formataData("MM/dd/yyyy", this.dataVencimento)).append("' ");
            buf.append("        ,'").append(Funcoes.formataData("MM/dd/yyyy", this.dataInicio)).append("' ");
            buf.append("        ,'").append(Funcoes.formataData("MM/dd/yyyy", this.dataFim)).append("' ");
            buf.append("        ,").append(total.getQtdeRequisicoes());
            buf.append("        ,").append(total.getQtdeExames());
            buf.append("        ,").append(Funcoes.limpaDecimal(String.valueOf(total.getTotalExames())));
            buf.append("        ,").append(Funcoes.limpaDecimal(String.valueOf(total.getTotalExamesCH())));
            buf.append("        ,").append(Funcoes.limpaDecimal(String.valueOf(total.getTotalMateriais())));
            buf.append("        ,").append(Funcoes.limpaDecimal(String.valueOf(total.getPercentualBonus())));
            buf.append("        ,").append(Funcoes.limpaDecimal(String.valueOf(total.getPercentualAcrescimo())));
            buf.append("        ,").append(Funcoes.limpaDecimal(String.valueOf(total.getCobranca())));
            buf.append("        ,").append(Funcoes.limpaDecimal(String.valueOf(total.getAdicional())));
            buf.append("        ,").append(total.getMensagem() == null ? " null " : " '" + total.getMensagem() + "' ");
            buf.append("        ,").append(this.codigoConvenio);
            buf.append("        ,'").append(Variaveis.login).append("' ");
            buf.append("        ,current_timestamp ");
            buf.append("        ,").append(total.getDescricaoAcrescimo() == null ? " null " : " '" + total.getDescricaoAcrescimo() + "' ");
            buf.append("        ,").append(total.getDescricaoDesconto() == null ? " null " : " '" + total.getDescricaoDesconto() + "' ");
            buf.append("        ,").append(total.getQtdeGuias());
            buf.append(" ) ");
            Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
            System.gc();
            ListaValoresExamesPai listaExamesPai = new ListaValoresExamesPai();
            for (int i = 0; i < modeloFatura.getRowCount() - 1; ++i) {
                DadosFaturamento dados = (DadosFaturamento)modeloFatura.getValueAt(i, 0);
                splash.setText(msg + i * 100 / modeloFatura.getRowCount() + "%");
                if (!dados.getFaturar()) continue;
                FaturaExamesService serviceFaturaExames = new FaturaExamesService();
                serviceFaturaExames.insert(codigo, Variaveis.filialPadrao, dados);
                listaExamesPai.clear();
                for (int j = 0; j < dados.getExamesCount(); ++j) {
                    DadosExameFaturamento exame = dados.getExame(j);
                    if (!exame.getFaturar()) continue;
                    buf.delete(0, buf.length());
                    buf.append(" insert ");
                    buf.append("   into faturaexamerequisicao (fil_codigo ");
                    buf.append("                              ,fil_kodigo ");
                    buf.append("                              ,fat_codigo ");
                    buf.append("                              ,req_codigo ");
                    buf.append("                              ,exa_codigo ");
                    buf.append("                              ,mco_codigo ");
                    buf.append("                              ,fer_total ");
                    buf.append("                              ,fer_totalch ");
                    buf.append("                              ,fer_totalmateriais ");
                    buf.append("                              ,exa_codfilho ");
                    buf.append("                              ,mco_codfilho ");
                    buf.append("                              ,fer_valorch ");
                    buf.append("                              ,fer_vlrbalcaoconvenio ");
                    buf.append("                              ,fer_ordem ");
                    buf.append("                              ,fer_custocbhpm ");
                    buf.append("                              ,fer_ucocbhpm ");
                    buf.append("                              ,fer_portecbhpm ");
                    buf.append("                              ,fer_valorportecbhpm ");
                    buf.append("                              ,met_codigo) ");
                    buf.append(" values (").append(Variaveis.filialPadrao);
                    buf.append("        ,").append(String.valueOf(dados.getCodigoFilial()));
                    buf.append("        ,").append(codigo);
                    buf.append("        ,").append(dados.getRequisicao());
                    DadosExamePaiAgrupamento examePai = exame.getExamePai();
                    if (examePai != null && !exame.isExamePaiAgrupamentoRequisicao()) {
                        buf.append(", '").append(examePai.getCodigo()).append("' ");
                        buf.append(", ").append(String.valueOf(examePai.getMaterial()));
                    } else {
                        buf.append(", '").append(exame.getCodigoExame()).append("' ");
                        buf.append(", ").append(String.valueOf(exame.getCodigoMaterial()));
                    }
                    buf.append(", ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorExame())));
                    buf.append(", ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCHExame())));
                    buf.append(", ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorMaterial())));
                    buf.append(", '").append(exame.getCodigoExame()).append("' ");
                    buf.append(", ").append(exame.getCodigoMaterial());
                    buf.append(", ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCH())));
                    buf.append(", ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorBalcao())));
                    buf.append(", ").append(j);
                    if (dados.isTabelaTipoCBHPM()) {
                        buf.append(", ").append(Funcoes.limpaDecimal(String.valueOf(exame.getCustoCBHPM())));
                        buf.append(", ").append(Funcoes.limpaDecimal(String.valueOf(exame.getUcoCBHPM())));
                        if (exame.getPorteCBHPM() != null) {
                            buf.append(", '").append(String.valueOf(exame.getPorteCBHPM())).append("' ");
                        } else {
                            buf.append(", null ");
                        }
                        buf.append(", ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorPorteCBHPM())));
                    } else {
                        buf.append(", null ");
                        buf.append(", null ");
                        buf.append(", null ");
                        buf.append(", null ");
                    }
                    buf.append(", ").append(exame.getCodigoMetodologia());
                    buf.append(")");
                    Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
                    if (exame.getExamePai() == null || exame.getExamePai().getCodigo().equalsIgnoreCase(exame.getCodigoExame()) || exame.isExamePaiAgrupamentoRequisicao()) {
                        buf.delete(0, buf.length());
                        buf.append(" update examerequisicao ");
                        if (exame.isConvenioRepasse()) {
                            buf.append("  set exr_datafaturarepasse = current_timestamp ");
                            buf.append("     ,usr_codfaturarepasse = '").append(Variaveis.login).append("' ");
                            buf.append("     ,exr_valorchrepasse = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCHRepasse())));
                            buf.append("     ,exr_valorchexamerepasse = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCHExameRepasse())));
                            if (!dados.isTabelaTipoCBHPM()) {
                                buf.append("   ,exr_valorcustorepasse = null ");
                                buf.append("   ,exr_valorucorepasse = null ");
                                buf.append("   ,exr_valorporterepasse = null ");
                                buf.append("   ,exr_porterepasse = null ");
                            } else {
                                buf.append("   ,exr_valorcustorepasse = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getCustoCBHPMRepasse())));
                                buf.append("   ,exr_valorucorepasse = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getUcoCBHPMRepasse())));
                                buf.append("   ,exr_valorporterepasse = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorPorteCBHPMRepasse())));
                                buf.append("   ,exr_porterepasse = '").append(StringUtil.textoDB(exame.getPorteCBHPMRepasse())).append("' ");
                            }
                        } else {
                            buf.append("  set exr_datafatura = current_timestamp ");
                            buf.append("     ,usr_codfatura = '").append(Variaveis.login).append("' ");
                            buf.append("     ,exr_vlrch = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCH())));
                            buf.append("     ,exr_vlrchexame = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCHExame())));
                            if (!dados.isTabelaTipoCBHPM()) {
                                buf.append("   ,exr_valorcusto = null ");
                                buf.append("   ,exr_valoruco = null ");
                                buf.append("   ,exr_valorporte = null ");
                                buf.append("   ,exr_porte = null ");
                            } else {
                                buf.append("   ,exr_valorcusto = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getCustoCBHPM())));
                                buf.append("   ,exr_valoruco = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getUcoCBHPM())));
                                buf.append("   ,exr_valorporte = ").append(Funcoes.limpaDecimal(String.valueOf(exame.getValorPorteCBHPM())));
                                buf.append("   ,exr_porte = '").append(StringUtil.textoDB(exame.getPorteCBHPM())).append("' ");
                            }
                        }
                        buf.append(", exr_vlrbalcaoconvenio = ");
                        buf.append(Funcoes.limpaDecimal(String.valueOf(exame.getValorBalcao())));
                        if (!exame.isConvenioRepasse()) {
                            buf.append(" , exr_deveguia = ").append(exame.getDeveGuia());
                            buf.append(" , exr_guia = '").append(StringUtil.textoDB(exame.getCodigoGuia()).trim()).append("' ");
                            if (exame.getValidadeGuia() != null) {
                                buf.append(" , exr_validadeguia = '").append(exame.getValidadeGuia()).append("' ");
                            } else {
                                buf.append(" , exr_validadeguia = null ");
                            }
                        }
                        buf.append(" where fil_codigo = ").append(dados.getCodigoFilial());
                        buf.append("   and req_codigo = ").append(dados.getRequisicao());
                        buf.append("   and exa_codigo = '").append(exame.getCodigoExame()).append("' ");
                        buf.append("   and mco_codigo = ").append(String.valueOf(exame.getCodigoMaterial()));
                        Conexao.execute(String.valueOf(dados.getCodigoFilial()), st, buf.toString());
                        if (examePai != null && !exame.isExamePaiAgrupamentoRequisicao()) {
                            ExportaFiliais.gravaRequisicao(dados.getCodigoFilial(), dados.getRequisicao(), examePai.getCodigo(), examePai.getMaterial(), "U", "U");
                            continue;
                        }
                        ExportaFiliais.gravaRequisicao(dados.getCodigoFilial(), dados.getRequisicao(), exame.getCodigoExame(), exame.getCodigoMaterial(), "U", "U");
                        continue;
                    }
                    if (exame.isExamePaiAgrupamentoRequisicao()) continue;
                    listaExamesPai.adicionaValorExame(exame.getExamePai().getCodigo(), exame.getExamePai().getMaterial(), exame.getValorCHExame(), exame.getValorCH());
                    buf.delete(0, buf.length());
                    buf.append(" update examerequisicaoguiaagrupada ");
                    buf.append("    set exg_deveguia = ").append(exame.getDeveGuia());
                    if (exame.getCodigoGuia() != null) {
                        buf.append("       ,exg_guia = '").append(exame.getCodigoGuia()).append("' ");
                    } else {
                        buf.append("       ,exg_guia = null ");
                    }
                    if (exame.getValidadeGuia() != null) {
                        buf.append("       ,exg_validadeguia = '").append(exame.getValidadeGuia()).append("' ");
                    } else {
                        buf.append("       ,exg_validadeguia = null ");
                    }
                    if (exame.getDataGuia() != null) {
                        buf.append("       ,exg_dataguia = '").append(exame.getDataGuia()).append("' ");
                    } else {
                        buf.append("       ,exg_dataguia = null ");
                    }
                    buf.append("  where fil_codigo = ").append(dados.getCodigoFilial());
                    buf.append("    and exa_codigo = '").append(examePai.getCodigo()).append("' ");
                    buf.append("    and exa_codfilho = '").append(exame.getCodigoExame()).append("' ");
                    buf.append("    and mco_codigo = ").append(String.valueOf(examePai.getMaterial()));
                    buf.append("    and mco_codfilho = ").append(String.valueOf(exame.getCodigoMaterial()));
                    buf.append("    and req_codigo = ").append(dados.getRequisicao());
                    int qtde = Conexao.executeUpdate(String.valueOf(dados.getCodigoFilial()), st, buf.toString());
                    if (qtde != 0) continue;
                    buf.delete(0, buf.length());
                    buf.append(" insert into examerequisicaoguiaagrupada(fil_codigo, exa_codigo, exa_codfilho, mco_codigo, mco_codfilho, req_codigo, exg_guia, exg_validadeguia, exg_dataguia, exg_deveguia) ");
                    buf.append("      values(").append(dados.getCodigoFilial());
                    buf.append("            ,'").append(examePai.getCodigo()).append("' ");
                    buf.append("            ,'").append(exame.getCodigoExame()).append("' ");
                    buf.append("            ,").append(String.valueOf(examePai.getMaterial()));
                    buf.append("            ,").append(String.valueOf(exame.getCodigoMaterial()));
                    buf.append("            ,").append(dados.getRequisicao());
                    if (exame.getCodigoGuia() != null) {
                        buf.append("            ,'").append(exame.getCodigoGuia()).append("' ");
                    } else {
                        buf.append("            ,null ");
                    }
                    if (exame.getValidadeGuia() != null) {
                        buf.append("          ,'").append(exame.getValidadeGuia()).append("' ");
                    } else {
                        buf.append("          ,null ");
                    }
                    if (exame.getDataGuia() != null) {
                        buf.append("          ,'").append(exame.getDataGuia()).append("' ");
                    } else {
                        buf.append("          ,null ");
                    }
                    buf.append("            ,").append(exame.getDeveGuia());
                    buf.append(") ");
                    Conexao.executeUpdate(String.valueOf(dados.getCodigoFilial()), st, buf.toString());
                }
                System.gc();
                ArrayList<ValorExamePai> listaValores = listaExamesPai.lista;
                for (int j = 0; j < listaValores.size(); ++j) {
                    ValorExamePai exame = listaValores.get(j);
                    buf.delete(0, buf.length());
                    buf.append(" update examerequisicao ");
                    buf.append("    set ");
                    if (dados.getCodigoConvenio() != dados.getCodigoConvenioPrincipal()) {
                        buf.append("  exr_valorchrepasse = ").append(Funcoes.limpaDecimal(String.valueOf(exame.valorCH.setScale(2, RoundingMode.HALF_UP).doubleValue())));
                        buf.append(" ,exr_valorchexamerepasse = ").append(Funcoes.limpaDecimal(String.valueOf(exame.valorCHExame.setScale(2, RoundingMode.HALF_UP).doubleValue())));
                        buf.append(" ,exr_datafaturarepasse = current_timestamp ");
                        buf.append(" ,usr_codfaturarepasse = '").append(Variaveis.login).append("' ");
                    } else {
                        buf.append("  exr_vlrch = ").append(Funcoes.limpaDecimal(String.valueOf(exame.valorCH.setScale(2, RoundingMode.HALF_UP).doubleValue())));
                        buf.append(" ,exr_vlrchexame = ").append(Funcoes.limpaDecimal(String.valueOf(exame.valorCHExame.setScale(2, RoundingMode.HALF_UP).doubleValue())));
                        buf.append(" ,exr_datafatura = current_timestamp ");
                        buf.append(" ,usr_codfatura = '").append(Variaveis.login).append("' ");
                    }
                    buf.append(" where fil_codigo = ").append(dados.getCodigoFilial());
                    buf.append("   and req_codigo = ").append(dados.getRequisicao());
                    buf.append("   and exa_codigo = '").append(exame.codigoExame).append("' ");
                    buf.append("   and mco_codigo = ").append(exame.codigoMaterial);
                    Conexao.execute(String.valueOf(dados.getCodigoFilial()), st, buf.toString());
                }
                buf.delete(0, buf.length());
                buf.append(" update requisicao ");
                buf.append("    set ");
                if (dados.getCodigoConvenio() == dados.getCodigoConvenioPrincipal()) {
                    buf.append("  req_guia = '").append(dados.getGuia() == null || dados.getGuia().equals("-1") ? "" : dados.getGuia()).append("' ");
                    buf.append(" ,req_guiaprincipal = '").append(dados.getGuiaPrincipal() == null || dados.getGuiaPrincipal().equals("-1") ? "" : dados.getGuiaPrincipal()).append("' ");
                } else {
                    buf.append("  req_guiarepasse = '").append(dados.getGuiaRepasse() == null || dados.getGuiaRepasse().equals("-1") ? "" : dados.getGuiaRepasse()).append("' ");
                    buf.append(" ,req_guiaprincipalrepasse = '").append(dados.getGuiaPrincipal() == null || dados.getGuiaPrincipal().equals("-1") ? "" : dados.getGuiaPrincipal()).append("' ");
                    if (dados.getValidadeGuiaRepasse() != null) {
                        buf.append(" ,req_validadeguiarepasse = '").append(dados.getValidadeGuiaRepasse()).append("' ");
                    } else {
                        buf.append(" ,req_validadeguiarepasse = null ");
                    }
                }
                buf.append(" where fil_codigo = ").append(dados.getCodigoFilial());
                buf.append("   and req_codigo = ").append(dados.getRequisicao());
                Conexao.execute(String.valueOf(dados.getCodigoFilial()), st, buf.toString());
            }
            Conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                retorno = false;
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FaturaExames (1045)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                splash.apagar();
                System.gc();
                throw throwable;
            }
            Conexao.fecharStatement(st);
            splash.apagar();
            System.gc();
        }
        Conexao.fecharStatement(st);
        splash.apagar();
        System.gc();
        return retorno;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.itemImprimirFatura) {
            this.imprimirFatura(this.imprimirAgrupada);
        } else if (e.getSource() == this.itemImprimirNota) {
            this.imprimirNota();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imprimirFatura(boolean agrupar) {
        if (!this.faturaSalva) {
            int resp = Funcoes.mensagem(this, "A impress\u00e3o salvar\u00e1 a(s) fatura(s) automaticamente.\nDeseja continuar?", 4);
            if (resp == 1) {
                return;
            }
            this.faturaSalva = this.salvar();
            if (!this.faturaSalva) {
                return;
            }
            if (this.codigoFatura > -1) {
                ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(this.panelDireitoExames).getDefaultRenderer(Object.class)).setCheckBoxVisivel(false);
                ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(this.panelDireitoExames).getDefaultEditor(Object.class)).setCheckBoxVisivel(false);
                FuncoesGerais.removeExamesDeselecionadosFaturamento(this.panelDireitoExames);
                FuncoesGerais.repaintTabela(this.panelDireitoExames);
            }
            this.controlaCampos();
        }
        this.buttonImprimir.setEnabled(false);
        if (this.faturaSalva && this.codigoFatura > -1) {
            SplashMensagem telaEspera = SplashMensagem.getInstancia(this);
            try {
                int convenio = -1;
                if (this instanceof FaturaExamesCompacta) {
                    convenio = ((FaturaExamesCompacta)this).getConvenio().getCodigo();
                } else if (this.itemConvenio.getSelecionados(0).length > 0 && Funcoes.isNumeric(this.itemConvenio.getSelecionados(0)[0])) {
                    convenio = Integer.parseInt(this.itemConvenio.getSelecionados(0)[0]);
                }
                if (convenio > -1) {
                    telaEspera.mostrar("Gerando visualiza\u00e7\u00e3o da fatura. Aguarde...");
                    if (ConvenioUtil.isImprimirResumoFatura(Variaveis.filialPadrao, String.valueOf(convenio))) {
                        ImprimirResumoFatura.imprimir(this.codigoFatura, convenio, this instanceof FaturaExamesCompacta);
                    }
                    ImprimirFatura.imprimir(this.codigoFatura, convenio, agrupar, this instanceof FaturaExamesCompacta);
                } else {
                    Funcoes.mensagem(this, "Nenhum conv\u00eanio foi selecionado para imprimir", 2);
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FaturaExames");
            }
            finally {
                telaEspera.apagar();
            }
        }
        this.buttonImprimir.setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imprimirNota() {
        block36: {
            boolean[] conferidas;
            Double total;
            String[] faturas;
            int convenio;
            block33: {
                block37: {
                    Statement st;
                    block32: {
                        boolean notaImpressa;
                        Statement st_;
                        block31: {
                            st_ = Conexao.getStatement();
                            notaImpressa = false;
                            try {
                                String nota = null;
                                if (this.codigoFatura > -1) {
                                    nota = FuncoesGerais.validaNotaFiscalEmitida(st_, Variaveis.filialPadrao, String.valueOf(this.codigoFatura), "");
                                }
                                if (Funcoes.textoVazio(nota)) break block31;
                                Funcoes.mensagem(this, "Nota fiscal j\u00e1 emitida com o n\u00famero " + String.valueOf(nota), 2);
                                notaImpressa = true;
                            }
                            catch (Exception ex) {
                                try {
                                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FaturaExames: 1319");
                                }
                                catch (Throwable throwable) {
                                    Conexao.fecharStatement(st_);
                                    throw throwable;
                                }
                                Conexao.fecharStatement(st_);
                            }
                        }
                        Conexao.fecharStatement(st_);
                        if (notaImpressa) {
                            return;
                        }
                        if (!this.faturaConferida) {
                            int resp = Funcoes.mensagem(this, "Salvar/Imprimir a Nota Fiscal conferir\u00e1 a(s) fatura(s) automaticamente.\nDeseja continuar?", 4);
                            if (resp == 1) {
                                return;
                            }
                            if (!this.faturaSalva) {
                                this.faturaSalva = this.salvar();
                                if (!this.faturaSalva) {
                                    return;
                                }
                                ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(this.panelDireitoExames).getDefaultRenderer(Object.class)).setCheckBoxVisivel(false);
                                ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(this.panelDireitoExames).getDefaultEditor(Object.class)).setCheckBoxVisivel(false);
                                FuncoesGerais.removeExamesDeselecionadosFaturamento(this.panelDireitoExames);
                                FuncoesGerais.repaintTabela(this.panelDireitoExames);
                            }
                            this.controlaCampos();
                        }
                        this.buttonImprimir.setEnabled(false);
                        if (!this.faturaSalva || this.codigoFatura <= -1) break block36;
                        NotaFiscalFatura f = NotaFiscalFatura.novainstancia(this.getTopLevelAncestor());
                        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
                        if (linhas == null || !(linhas.getValueAt(linhas.getRowCount() - 1, 0) instanceof DadosTotalGeral)) {
                            return;
                        }
                        DadosTotalGeral dados = (DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0);
                        int n = convenio = Funcoes.isNumeric(this.codigoConvenio) ? Integer.parseInt(this.codigoConvenio) : -1;
                        if (this.itemConvenio.getSelecionados(0) != null && this.itemConvenio.getSelecionados(0).length > 0 && Funcoes.isNumeric(this.itemConvenio.getSelecionados(0)[0])) {
                            convenio = Integer.parseInt(this.itemConvenio.getSelecionados(0)[0]);
                        }
                        f.setFaturaAtual(String.valueOf(this.codigoFatura), Funcoes.formataData(new Date()), Funcoes.formataDecimal(dados.getTotal().doubleValue()));
                        f.setVisible(true);
                        if (!f.getOK()) break block36;
                        faturas = new String[]{String.valueOf(this.codigoFatura)};
                        total = dados.getTotal().doubleValue();
                        conferidas = null;
                        if (f.getOpcaoSelecionada() != 2) break block37;
                        faturas = f.getFaturasSelecionadas();
                        conferidas = new boolean[faturas.length];
                        FaturaService serviceFatura = new FaturaService();
                        try {
                            for (int i = 0; i < faturas.length; ++i) {
                                conferidas[i] = serviceFatura.isFaturaConferida(Variaveis.filialPadrao, faturas[i]);
                            }
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar a situa\u00e7\u00e3o das faturas.\n" + e.getMessage(), e.getStackTrace(), "ConferenciaFatura: imprimiNota");
                            return;
                        }
                        total = 0.0;
                        StringBuilder buf = new StringBuilder();
                        for (String s : faturas) {
                            if (buf.length() > 0) {
                                buf.append(", ");
                            }
                            buf.append(s);
                        }
                        String tmp = buf.toString();
                        buf.setLength(0);
                        buf.append("select sum(fat_totalexames + fat_totalmateriais + fat_adicional + fat_despcobranca + ((fat_totalexames + fat_totalmateriais) * fat_percacrescimo / 100) - ((fat_totalexames + fat_totalmateriais) * fat_percdesconto / 100)) as total from fatura fat ");
                        buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                        buf.append(" and fat_codigo in (").append(tmp).append(")");
                        buf.append(" and fat.fat_datacancelamento is null ");
                        st = Conexao.getStatement();
                        try {
                            ResultSet rs = Conexao.executeQuery(st, buf);
                            if (!rs.next()) break block32;
                            total = rs.getDouble("total");
                        }
                        catch (Exception e) {
                            try {
                                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "FaturaExames: 1354");
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(st);
                                throw throwable;
                            }
                            Conexao.fecharStatement(st);
                            break block33;
                        }
                    }
                    Conexao.fecharStatement(st);
                    break block33;
                }
                try {
                    conferidas = new boolean[]{new FaturaService().isFaturaConferida(Variaveis.filialPadrao, faturas[0])};
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar a situa\u00e7\u00e3o das faturas.\n" + e.getMessage(), e.getStackTrace(), "ConferenciaFatura: imprimiNota");
                    return;
                }
            }
            DialogNotaFiscalSaida dialogNota = NotaFiscalSaida.novaInstancia((Window)this.getTopLevelAncestor(), false, null);
            NotaFiscalSaida nota = null;
            if (dialogNota != null) {
                nota = dialogNota.getNotaFiscalSaida();
            }
            if (nota != null) {
                nota.setFilial(Variaveis.filialPadrao);
                nota.setAcessos(600200112L, 600200113L);
                nota.setDataEmissao(new Date());
                nota.setCadastro("O", String.valueOf(convenio));
                nota.setSubTotal(total);
                nota.setFaturasRelacionadas(faturas);
                nota.setFaturasConferidas(conferidas);
                dialogNota.setVisible(true);
            }
        }
        this.buttonImprimir.setEnabled(true);
        if (this.codigoFatura > -1) {
            Statement st;
            block34: {
                StringBuilder buf = new StringBuilder();
                buf.append(" select fat.fat_dtconferencia ");
                buf.append("       ,nfi.nfi_situacao ");
                buf.append("   from fatura fat ");
                buf.append("   left join faturanotafiscal fnf on fat.fil_codigo = fnf.fil_codigo and fat.fat_codigo = fnf.fat_codigo ");
                buf.append("   left join notafiscal nfi on fnf.fil_codigo = nfi.fil_codigo and fnf.nfi_codigo = nfi.nfi_codigo ");
                buf.append("                    and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
                buf.append("                     or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao IN ('").append("X").append("', '").append("A").append("', '").append("N").append("', '").append("O").append("') ) ) ");
                buf.append("  where fat.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and fat.fat_codigo = ").append(this.codigoFatura);
                st = Conexao.getStatement();
                try {
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        this.faturaConferida = rs.getString("fat_dtconferencia") != null;
                        this.notaFiscalAssociada = rs.getString("nfi_situacao") != null;
                        break block34;
                    }
                    this.faturaConferida = false;
                    this.notaFiscalAssociada = false;
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
        this.controlaCampos();
    }

    private ReceberPagarBean getReceberPagarBasicoComissao(ReceberPagarBean recpag) {
        if (recpag == null) {
            recpag = new ReceberPagarBean();
        }
        recpag.setSituacao("A");
        recpag.setDataHora(new Date());
        recpag.setTipo("P");
        recpag.setTipoDocumento("D");
        recpag.setTipoJuro("V");
        recpag.setPercentualMulta(0.0);
        recpag.setPercentualDesconto(0.0);
        recpag.setPercentualAcrescimo(0.0);
        recpag.setIrrfPercentual(0.0);
        recpag.setIssPercentual(0.0);
        recpag.setPisPercentual(0.0);
        recpag.setCsllPercentual(0.0);
        recpag.setCofinsPercentual(0.0);
        recpag.setInssPercentual(0.0);
        recpag.setValorMulta(0.0);
        recpag.setValorDesconto(0.0);
        recpag.setValorAcrescimo(0.0);
        recpag.setTaxa(0.0);
        recpag.setIrrfValor(0.0);
        recpag.setIssValor(0.0);
        recpag.setPisValor(0.0);
        recpag.setCsllValor(0.0);
        recpag.setCofinsValor(0.0);
        recpag.setInssValor(0.0);
        recpag.setPercentualJuro(0.0);
        recpag.setValorJuro(0.0);
        recpag.setNumeroDocumento(null);
        recpag.setCodigoDocumento(null);
        recpag.setDataProcessamento(new Date());
        recpag.setTipoCadastro("R");
        return recpag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String buscaFiliaisFatura() {
        ArrayList<String> listaFiliais = new ArrayList<String>();
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        try {
            rs = Conexao.executeQuery(st, " select distinct(fil_codfat) from filialfatura where fil_codigo = " + Variaveis.filialPadrao);
            listaFiliais.add(Variaveis.filialPadrao);
            while (rs.next()) {
                listaFiliais.add(rs.getString("fil_codfat"));
            }
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "FaturaExames");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                Conexao.fecharResultSet(rs);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            Conexao.fecharResultSet(rs);
        }
        Conexao.fecharStatement(st);
        Conexao.fecharResultSet(rs);
        return StringUtil.implode(listaFiliais, ", ");
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.executandoBusca = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.executandoBusca = false;
        this.controlaCampos();
    }

    public static Long getAcessoSubstituirGuiasReplicacao() {
        return ACESSO_SUBSTITUIR_GUIAS_REPLICACAO;
    }

    public static Long getAcessoPermitirFiltrarVariosPaciente() {
        return ACESSO_PERMITIR_VARIOS_PACIENTES;
    }

    static /* synthetic */ JButton access$800(FaturaExames x0) {
        return x0.buttonEletronico;
    }

    static /* synthetic */ boolean access$900(FaturaExames x0) {
        return x0.acessoAlterarTodosCamposFatEletronico;
    }

    static {
        ACESSO_SUBSTITUIR_GUIAS_REPLICACAO = Long.parseLong("0600200117");
        ACESSO_PERMITIR_VARIOS_PACIENTES = Long.parseLong("0600200118");
    }
}

