/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.financeiro.ExportarFaturasVO;
import jalis.service.financeiro.ExportarFaturasService;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ExportarFaturas
extends FrmPadrao
implements ActionListener,
KeyListener,
ListSelectionListener,
FocusListener,
TableCellRenderer {
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_CONVENIO = 1;
    private final int COLUNA_EMISSAO = 2;
    private final int COLUNA_VENCIMENTO = 3;
    private final int COLUNA_TOTAL_FATURA = 4;
    private final int COLUNA_TOTAL_FISICO_QUIM = 5;
    private final int COLUNA_TOTAL_MICRO = 6;
    private final int COLUNA_TOTAL_OUTROS = 7;
    private final int COLUNA_DATA_ENVIO = 8;
    private final int COLUNA_DADOS = 9;
    private final int QTDE_COLUNAS = 10;
    private final String CONVENIO = "Conv\u00eanio";
    private final GridBagLayout grid = new GridBagLayout();
    private final GridBagConstraints constraints = new GridBagConstraints();
    protected final JPanel panelEsquerdo = new JPanel(this.grid);
    private final JPanel panelCentral = new JPanel(new BorderLayout());
    private final JPanel panelCentralDados = new JPanel(new BorderLayout());
    private final JPanel panelBotoes = new JPanel(new BorderLayout());
    private final JPanel panelBotoesDireita = new JPanel(new FlowLayout(2));
    private final JPanel panelBotoesEsquerda = new JPanel(new FlowLayout(0));
    protected final JButton buttonConsultar = new JButton("Consultar");
    protected final JButton buttonGerarArquivo = new JButton("Gerar arquivo");
    protected final JButton buttonFechar = new JButton("Fechar");
    private final JLabel labelDataInicio = new JLabel("Data in\u00edcio:");
    private final JLabel labelDataFim = new JLabel("Data final:");
    private final TTextField txtDataInicio = new TTextField(10, 4);
    private final TTextField txtDataFim = new TTextField(10, 4);
    private final JButton buttonDataInicio = new JButton();
    private final JButton buttonDataFim = new JButton();
    private final String[] ordem = new String[]{"C\u00f3digo", "Conv\u00eanio"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final CheckItemFiltro itemFilial = new CheckItemFiltro("Filial", "Filtrar", "Filtrando Filial", null);
    private final CheckItemFiltro itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando Conv\u00eanio", "fil_codigo = " + Variaveis.filialPadrao);
    private final JLabel labelOrdem = new JLabel("Ordem:");
    private final JComboBox comboOrdem = new JComboBox<String>(this.ordem);
    private final JCheckBox checkFiltrarPorVencimento = new JCheckBox("Filtrar por vencimento");
    private final JCheckBox checkReenviarArquivo = new JCheckBox("Reenviar arquivo");
    private ModeloGridTable modeloDados = new ModeloGridTable(new String[]{"C\u00f3digo", "Conv\u00eanio", "Emiss\u00e3o", "Vencimento", "Total Fatura", "Tot. F\u00edsico-qu\u00edm.", "Tot. Microbi\u00f3lg.", "Tot. Outros-Terc.", "Dt. de Envio", "Fatura"});
    private JTable tableDados = ComponenteFactory.novoJTable((TableModel)this.modeloDados, (ListSelectionListener)this, new int[0]);
    private JScrollPane scroll = new JScrollPane(this.tableDados);
    private ExportarFaturasService service = new ExportarFaturasService();

    public ExportarFaturas() {
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelEsquerdo, "West");
        this.panelCentral.add((Component)this.panelBotoes, "South");
        this.panelCentral.add((Component)this.panelCentralDados, "Center");
        this.add((Component)this.panelCentral, "Center");
        GridBagConstraints c = new GridBagConstraints();
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        Funcoes.criaBarraDescricao(this, "Exportar Faturas (Arquivo xml)", "Gerar arquivo xml para importa\u00e7\u00e3o das Faturas em software de terceiros", "financeiro/exportar_fatura.jpg");
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        this.buttonGerarArquivo.setMnemonic('G');
        this.buttonFechar.setMnemonic('F');
        this.panelBotoesDireita.add((Component)this.buttonGerarArquivo, c);
        this.panelBotoesDireita.add((Component)this.buttonFechar, c);
        this.panelBotoes.add((Component)this.panelBotoesDireita, "East");
        Funcoes.imagemPesquisa(this.buttonDataInicio);
        Funcoes.imagemPesquisa(this.buttonDataFim);
        this.buttonDataInicio.setFocusable(false);
        this.buttonDataFim.setFocusable(false);
        this.montaFiltros();
        this.buttonConsultar.setMargin(new Insets(2, 2, 2, 2));
        this.buttonGerarArquivo.setEnabled(false);
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarFaturas.this.setVisible(false);
            }
        });
        this.buttonDataInicio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ExportarFaturas.this.txtDataInicio, ExportarFaturas.this.buttonDataInicio, ExportarFaturas.this.panelEsquerdo, true);
            }
        });
        this.buttonDataFim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(ExportarFaturas.this.txtDataFim, ExportarFaturas.this.buttonDataFim, ExportarFaturas.this.panelEsquerdo, true);
            }
        });
        this.buttonConsultar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportarFaturas.this.consultarFaturas();
            }
        });
        this.buttonGerarArquivo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ExportarFaturas.this.validaDados()) {
                    ExportarFaturas.this.gerarArquivoFaturamento();
                }
            }
        });
    }

    private void montaFiltros() {
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.gridwidth = 3;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.panelEsquerdo.add((Component)this.itemFilial, this.constraints);
        this.constraints.gridy = 1;
        this.panelEsquerdo.add((Component)this.itemConvenio, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.constraints.fill = 0;
        this.panelEsquerdo.add((Component)this.labelDataInicio, this.constraints);
        ++this.constraints.gridx;
        this.constraints.gridwidth = 1;
        this.txtDataInicio.setPreferredSize(new Dimension(115, 20));
        this.txtDataInicio.setMinimumSize(new Dimension(115, 20));
        this.panelEsquerdo.add((Component)this.txtDataInicio, this.constraints);
        ++this.constraints.gridx;
        this.constraints.gridwidth = 1;
        this.buttonDataInicio.setPreferredSize(new Dimension(20, 20));
        this.buttonDataInicio.setMinimumSize(new Dimension(20, 20));
        this.panelEsquerdo.add((Component)this.buttonDataInicio, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.panelEsquerdo.add((Component)this.labelDataFim, this.constraints);
        ++this.constraints.gridx;
        this.constraints.gridwidth = 1;
        this.txtDataFim.setPreferredSize(new Dimension(115, 20));
        this.txtDataFim.setMinimumSize(new Dimension(115, 20));
        this.panelEsquerdo.add((Component)this.txtDataFim, this.constraints);
        ++this.constraints.gridx;
        this.constraints.gridwidth = 1;
        this.buttonDataFim.setPreferredSize(new Dimension(20, 20));
        this.buttonDataFim.setMinimumSize(new Dimension(20, 20));
        this.panelEsquerdo.add((Component)this.buttonDataFim, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 4;
        this.constraints.gridwidth = 1;
        this.panelEsquerdo.add((Component)this.labelOrdem, this.constraints);
        ++this.constraints.gridx;
        this.constraints.gridwidth = 2;
        this.comboOrdem.setPreferredSize(new Dimension(135, 20));
        this.comboOrdem.setMinimumSize(new Dimension(135, 20));
        this.panelEsquerdo.add((Component)this.comboOrdem, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 5;
        this.constraints.gridwidth = 3;
        this.panelEsquerdo.add((Component)this.checkFiltrarPorVencimento, this.constraints);
        this.constraints.gridy = 6;
        this.panelEsquerdo.add((Component)this.checkReenviarArquivo, this.constraints);
        this.constraints.fill = 0;
        ++this.constraints.gridy;
        this.constraints.weighty = 1.0;
        this.panelEsquerdo.add((Component)new JPanel(), this.constraints);
        ++this.constraints.gridy;
        this.constraints.gridx = 1;
        this.constraints.gridwidth = 2;
        this.constraints.anchor = 13;
        this.constraints.weighty = 0.0;
        this.buttonConsultar.setPreferredSize(new Dimension(100, 20));
        this.buttonConsultar.setMinimumSize(new Dimension(100, 20));
        this.buttonConsultar.setMnemonic('t');
        this.panelEsquerdo.add((Component)this.buttonConsultar, this.constraints);
    }

    private void gerarArquivoFaturamento() {
        XMLStringBuilder xml = new XMLStringBuilder();
        String path = "";
        JFileChooser file = ComponenteFactory.novoJFileChooser();
        file.setFileSelectionMode(2);
        if (!this.isCaminhoSelecionado(file)) {
            return;
        }
        path = file.getSelectedFile().getAbsolutePath();
        try {
            xml.abrir("faturas");
            for (int i = 0; i < this.modeloDados.getRowCount(); ++i) {
                ExportarFaturasVO fat = (ExportarFaturasVO)this.modeloDados.getValueAt(i, 9);
                xml.abrir("fatura");
                xml.escrever("codigo", fat.getFatura().getCodigo().toString());
                xml.escrever("data", fat.getFatura().getDataEmissao().toString());
                xml.escrever("vencimento", fat.getFatura().getVencimento().toString());
                xml.escrever("codigo-cliente", fat.getFatura().getConvenio().getCodigo().toString());
                xml.escrever("fantasia-cliente", fat.getFatura().getConvenio().getFantasia());
                xml.escrever("total", this.getValor(fat.getFatura().getValorTotal()));
                xml.escrever("acrescimo", this.getValor(fat.getFatura().getPercentualAcrescimo()));
                xml.escrever("desconto", this.getValor(fat.getFatura().getPercentualDesconto()));
                xml.abrir("rateios");
                xml.abrir("rateio");
                xml.escrever("tipo", "01");
                xml.escrever("valor", this.getValor(fat.getTotalFisicoQuimico()));
                xml.fechar("rateio");
                xml.abrir("rateio");
                xml.escrever("tipo", "02");
                xml.escrever("valor", this.getValor(fat.getTotalMicrobiologico()));
                xml.fechar("rateio");
                xml.abrir("rateio");
                xml.escrever("tipo", "03");
                xml.escrever("valor", this.getValor(fat.getTotalOutros()));
                xml.fechar("rateio");
                xml.abrir("rateio");
                xml.escrever("tipo", "04");
                xml.escrever("valor", this.getValor(fat.getTotalCromatografia()));
                xml.fechar("rateio");
                xml.fechar("rateios");
                xml.fechar("fatura");
            }
            xml.fechar("faturas");
            String nomeArquivo = path + ".xml";
            StringUtil.escreverArquivoTexto(nomeArquivo, xml.getXML(), "UTF-8");
            this.registrarDataArquivo();
            Funcoes.mensagem(this, "Arquivo gerado com sucesso!", 2);
            this.controlaCampos();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ExportarFaturas: 312");
        }
    }

    private String getValor(Double valor) {
        if (this.isNull(valor)) {
            return String.valueOf(Funcoes.formataDecimal(new Double(0.0)));
        }
        return String.valueOf(Funcoes.formataDecimal(valor));
    }

    private boolean isNull(Double valor) {
        return valor == null;
    }

    private boolean isCaminhoSelecionado(JFileChooser file) {
        return file.showSaveDialog(this) == 0;
    }

    private void registrarDataArquivo() throws SQLException {
        for (int i = 0; i < this.modeloDados.getRowCount(); ++i) {
            ExportarFaturasVO fat = (ExportarFaturasVO)this.modeloDados.getValueAt(i, 9);
            this.service.atualizarDataArquivo(fat);
        }
    }

    private void consultarFaturas() {
        if (this.validaCampos()) {
            Integer[] filiais = this.getFiltroFiliais();
            Integer[] convenios = this.getFiltroConvenio();
            String ordem = this.comboOrdem.getSelectedItem().toString();
            try {
                this.montaTableDados();
                ArrayList<ExportarFaturasVO> faturas = this.service.consultaFaturas(filiais, convenios, ordem, this.txtDataInicio.getText(), this.txtDataFim.getText(), this.checkFiltrarPorVencimento.isSelected(), this.checkReenviarArquivo.isSelected());
                if (!this.carregouBean(faturas)) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    return;
                }
                for (ExportarFaturasVO fat : faturas) {
                    this.modeloDados.addLine(new Object[]{fat.getFatura().getCodigo(), fat.getFatura().getConvenio().getFantasia(), Funcoes.formataData(fat.getFatura().getDataEmissao()), Funcoes.formataData(fat.getFatura().getVencimento()), Funcoes.formataDecimal(fat.getFatura().getValorTotal()), Funcoes.formataDecimal(fat.getTotalFisicoQuimico()), Funcoes.formataDecimal(fat.getTotalMicrobiologico()), Funcoes.formataDecimal(fat.getTotalOutros()), Funcoes.formataData(fat.getFatura().getDataArquivo()), fat});
                }
                this.buttonGerarArquivo.setEnabled(true);
                this.panelCentralDados.updateUI();
                this.modeloDados.fireTableDataChanged();
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ExportarFaturas: 276");
            }
        }
    }

    private void montaTableDados() {
        this.modeloDados.clear();
        this.modeloDados.setColumnSize(new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, this.tableDados);
        this.tableDados.getTableHeader().addMouseListener(this.modeloDados);
        this.tableDados.addFocusListener(this);
        this.tableDados.setDefaultRenderer(String.class, this);
        this.tableDados.addKeyListener(this);
        this.panelCentralDados.add(this.scroll);
        this.modeloDados.ordenarColuna(0);
    }

    private Integer[] getFiltroConvenio() {
        Integer[] convenios = new Integer[this.itemConvenio.getSelecionados().length];
        for (int i = 0; i < this.itemConvenio.getSelecionados().length; ++i) {
            convenios[i] = Integer.parseInt(this.itemConvenio.getSelecionados()[i]);
        }
        return convenios;
    }

    private Integer[] getFiltroFiliais() {
        if (!this.isFiltroSelecionado(this.itemFilial)) {
            Integer[] filiais = new Integer[this.itemFilial.getSelecionados().length];
            for (int i = 0; i < this.itemFilial.getSelecionados().length; ++i) {
                filiais[i] = Integer.parseInt(this.itemFilial.getSelecionados()[i]);
            }
            return filiais;
        }
        return new Integer[]{Integer.parseInt(Variaveis.filialPadrao)};
    }

    private boolean validaCampos() {
        if (!Funcoes.verificaData(this.txtDataInicio.getText()) || !Funcoes.verificaData(this.txtDataFim.getText())) {
            Funcoes.mensagem(this, "Per\u00edodo de consulta incorreto.\nPreencha os campos Data inicial e Data final.", 1);
            this.txtDataInicio.grabFocus();
            return false;
        }
        if (this.isFiltroSelecionado(this.itemConvenio)) {
            Funcoes.mensagem(this, "Nenhum conv\u00eanio foi selecionado", 1);
            return false;
        }
        return true;
    }

    private boolean validaDados() {
        return this.modeloDados.getRowCount() > 0;
    }

    private boolean isFiltroSelecionado(CheckItemFiltro itemFiltro) {
        return !itemFiltro.isSelected() || itemFiltro.isSelected() && (itemFiltro.getSelecionados(0) == null || itemFiltro.getSelecionados(0).length <= 0);
    }

    private boolean carregouBean(ArrayList<ExportarFaturasVO> fatBean) {
        return fatBean != null && fatBean.size() > 0;
    }

    private boolean isDataFinalMaior() {
        return Funcoes.comparaData(this.txtDataInicio.getText(), this.txtDataFim.getText()) >= 0;
    }

    private void controlaCampos() {
        this.modeloDados.clear();
    }

    @Override
    public void pressioneiF2() {
        if (this.txtDataInicio.hasFocus()) {
            Funcoes.mostraData(this.txtDataInicio, this.buttonDataInicio, this.panelEsquerdo, true);
        } else if (this.txtDataFim.hasFocus()) {
            Funcoes.mostraData(this.txtDataFim, this.buttonDataFim, this.panelEsquerdo, true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600300900");
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.isDelete(e) && this.contemLinhasSelecionada()) {
            int row = this.tableDados.getSelectedRow();
            this.modeloDados.removeLine(row);
            this.modeloDados.fireTableDataChanged();
        }
    }

    private boolean contemLinhasSelecionada() {
        return this.tableDados.getSelectedRow() > -1;
    }

    private boolean isDelete(KeyEvent e) {
        return e.getKeyCode() == 127;
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel labelRenderer = new JLabel();
        labelRenderer.setFont(table.getFont());
        labelRenderer.setText(value.toString());
        if (this.isColumnValorTotal(column)) {
            labelRenderer.setHorizontalAlignment(4);
            return labelRenderer;
        }
        return labelRenderer;
    }

    private boolean isColumnValorTotal(int column) {
        return column == 4 || column == 5 || column == 6 || column == 7;
    }
}

