/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DadosTotalGeral;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.faturamento.BuscaFatura;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.model.bean.financeiro.FaturaNotaFiscalBean;
import jalis.model.bean.financeiro.FaturaReceberPagarBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.financeiro.FaturaVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.service.financeiro.FaturaNotaFiscalService;
import jalis.service.financeiro.FaturaReceberPagarService;
import jalis.service.financeiro.FaturaService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.Funcoes;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class EstornoFatura
extends FrmPadrao
implements ThreadFinalizadaListener {
    private JPanel panelEsquerdo = new JPanel(new GridBagLayout());
    private JPanel panelDireito = new JPanel(new BorderLayout());
    private JPanel panelDireitoExames = new JPanel();
    private JPanel panelDireitoLegenda = new JPanel();
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelBotoesE = new JPanel(new FlowLayout(0));
    private JPanel panelBotoesD = new JPanel(new FlowLayout(2));
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonEstornar = new JButton("Estornar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JButton buttonNovo = new JButton("Novo");
    private JButton buttonConsultar = new JButton("Consultar");
    private JLabel labelFatura = new JLabel("Fatura:");
    private TTextField txtFatura = new TTextField(5, 1);
    private JButton buttonFatura = new JButton();
    private boolean executandoBusca = false;
    private int status = 1;
    private BuscaFatura consulta;

    public EstornoFatura() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "EstornoFatura (46)");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelEsquerdo, "West");
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelDireito, "Center");
        this.panelEsquerdo.setPreferredSize(new Dimension(150, 100));
        this.panelDireito.add((Component)this.panelDireitoExames, "Center");
        this.panelDireito.add((Component)this.panelDireitoLegenda, "South");
        FuncoesGerais.montaLegenda(this.panelDireitoLegenda);
        Funcoes.criaBarraDescricao(this, "Estorno", "Estorno de faturamento", "financeiro/estorno_fatura.jpg");
        this.panelBotoes.add((Component)this.panelBotoesE, "West");
        this.panelBotoes.add((Component)this.panelBotoesD, "East");
        this.panelBotoesD.add(this.buttonNovo);
        this.panelBotoesD.add(this.buttonEstornar);
        this.panelBotoesD.add(this.buttonCancelar);
        this.panelBotoesD.add(this.buttonFechar);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 1.0;
        cons.fill = 2;
        cons.anchor = 17;
        this.panelEsquerdo.add((Component)this.labelFatura, cons);
        cons.gridx = 1;
        cons.anchor = 13;
        cons.weightx = 0.0;
        cons.fill = 0;
        this.txtFatura.setPreferredSize(new Dimension(70, 20));
        this.txtFatura.setMinimumSize(new Dimension(70, 20));
        this.panelEsquerdo.add((Component)this.txtFatura, cons);
        cons.gridx = 2;
        this.buttonFatura.setPreferredSize(new Dimension(20, 20));
        this.buttonFatura.setMinimumSize(new Dimension(20, 20));
        this.panelEsquerdo.add((Component)this.buttonFatura, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 3;
        cons.anchor = 13;
        this.panelEsquerdo.add((Component)this.buttonConsultar, cons);
        cons.gridy = 2;
        cons.fill = 1;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        cons.gridwidth = 3;
        this.panelEsquerdo.add((Component)new JPanel(), cons);
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        this.buttonFechar.setMnemonic('F');
        this.buttonConsultar.setMnemonic('t');
        this.buttonNovo.setMnemonic('N');
        this.buttonEstornar.setMnemonic('S');
        this.buttonCancelar.setMnemonic('C');
        Funcoes.imagemPesquisa(this.buttonFatura);
        this.buttonFatura.setFocusable(false);
        this.buttonConsultar.setMargin(new Insets(2, 2, 2, 2));
        this.controlaCampos();
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstornoFatura.this.setVisible(false);
            }
        });
        this.buttonConsultar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstornoFatura.this.pesquisaFaturamento();
                System.gc();
            }
        });
        this.buttonFatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstornoFatura.this.pesquisaFatura();
            }
        });
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EstornoFatura.this.limpaCampos();
                EstornoFatura.this.status = 2;
                EstornoFatura.this.controlaCampos();
                EstornoFatura.this.txtFatura.requestFocus();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.mensagem(EstornoFatura.this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                    EstornoFatura.this.limpaCampos();
                    EstornoFatura.this.status = 1;
                    EstornoFatura.this.controlaCampos();
                    EstornoFatura.this.buttonNovo.requestFocus();
                }
            }
        });
        this.buttonEstornar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EstornoFatura.this.consulta == null) {
                    return;
                }
                System.gc();
                boolean conferida = EstornoFatura.this.consulta.getConferida();
                if (Funcoes.mensagem(EstornoFatura.this, conferida ? "Confirma o estorno da confer\u00eancia da fatura?" : "Confirmar o estorno da fatura?", 4) == 0) {
                    EstornoFatura.this.salvar();
                    EstornoFatura.this.limpaCampos();
                    EstornoFatura.this.status = 1;
                    EstornoFatura.this.controlaCampos();
                    EstornoFatura.this.buttonNovo.requestFocus();
                }
                System.gc();
            }
        });
    }

    private void limpaCampos() {
        this.txtFatura.clear();
        this.panelDireitoExames.removeAll();
        this.panelDireitoExames.repaint();
    }

    private void controlaCampos() {
        boolean habilita;
        boolean bl = habilita = this.status == 2;
        boolean faturaCarregada = FuncoesGerais.pegaTabela(this.panelDireitoExames) == null ? false : FuncoesGerais.pegaTabela(this.panelDireitoExames).getModel().getRowCount() > 0;
        this.txtFatura.setEnabled(habilita && !this.executandoBusca && !faturaCarregada);
        this.buttonFatura.setEnabled(habilita && !this.executandoBusca && !faturaCarregada);
        this.buttonConsultar.setEnabled(habilita && !this.executandoBusca && !faturaCarregada);
        this.buttonNovo.setEnabled(!habilita && !this.executandoBusca);
        this.buttonEstornar.setEnabled(habilita && !this.executandoBusca && faturaCarregada);
        this.buttonCancelar.setEnabled(habilita && !this.executandoBusca);
        this.buttonFechar.setEnabled(!habilita && !this.executandoBusca);
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0600200300");
    }

    @Override
    public void pressioneiF2() {
        if (this.txtFatura.hasFocus()) {
            this.buttonFatura.doClick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pesquisaFaturamento() {
        boolean notaImpressa;
        Statement st_;
        block7: {
            st_ = Conexao.getStatement();
            notaImpressa = false;
            try {
                String nota = null;
                if (!Funcoes.textoVazio(this.txtFatura.getText())) {
                    nota = FuncoesGerais.validaNotaFiscalImpressa(st_, Variaveis.filialPadrao, this.txtFatura.getText());
                }
                if (Funcoes.textoVazio(nota)) break block7;
                Funcoes.mensagem(this, "A fatura n\u00e3o poder\u00e1 ser estornada pois possui uma ou mais notas associadas.\nNota(s): [" + nota + "]", 2);
                notaImpressa = true;
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "EstornoFatura: 208");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st_);
                    throw throwable;
                }
                Conexao.fecharStatement(st_);
            }
        }
        Conexao.fecharStatement(st_);
        if (notaImpressa) {
            return;
        }
        if (!Funcoes.isNumeric(this.txtFatura.getText())) {
            Funcoes.mensagem(this, "C\u00f3digo da fatura n\u00e3o informado", 1);
            this.txtFatura.grabFocus();
            return;
        }
        this.buttonConsultar.setEnabled(false);
        this.panelDireitoExames.removeAll();
        this.panelDireitoExames.setLayout(null);
        this.consulta = new BuscaFatura((Frame)this.getTopLevelAncestor(), this.panelDireitoExames, this.buttonConsultar, false, false, false, this);
        this.consulta.addThreadListener(this);
        this.consulta.setPararSeConferida(false);
        this.consulta.setCodigoFatura(this.txtFatura.getText());
        this.consulta.start();
    }

    private void pesquisaFatura() {
        Hashtable resultado = Pesquisas.fatura(this.getTopLevelAncestor());
        if (resultado != null) {
            this.txtFatura.setText(resultado.get("fat_codigo").toString());
        }
        this.txtFatura.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean salvar() {
        block28: {
            block27: {
                retorno = true;
                modeloFatura = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
                if (!Funcoes.isNumeric(this.txtFatura.getText())) {
                    Funcoes.mensagem(this, "C\u00f3digo da fatura n\u00e3o informado.", 1);
                    this.txtFatura.grabFocus();
                    return false;
                }
                if (modeloFatura == null || modeloFatura.getRowCount() == 1 && modeloFatura.getValueAt(0, 0) instanceof DadosTotalGeral) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 requisi\u00e7\u00f5es na fatura selecionada.", 2);
                    return false;
                }
                notaFatura = null;
                try {
                    notaFatura = new FaturaNotaFiscalService().getNotaFiscalFatura(Variaveis.filialPadrao, this.txtFatura.getText());
                }
                catch (Exception e) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel buscar informa\u00e7\u00f5es das notas fiscais.", 2);
                    return false;
                }
                if (notaFatura != null && !(nota = notaFatura.getNotaFiscal()).getSituacao().equalsIgnoreCase("E") && !nota.getSituacao().equalsIgnoreCase("C")) {
                    msg = new StringBuilder();
                    msg.append("A nota fiscal n\u00famero: ").append(nota.getNumero()).append(", s\u00e9rie: ").append(nota.getSerie().getCodigo()).append(" associada \u00e0 essa fatura\n");
                    msg.append("est\u00e1 com a situa\u00e7\u00e3o: \"").append(Tipos.tipoSituacaoNotaFiscal(nota.getSituacao(), nota.getNumeroRps() != null)).append("\".\n");
                    msg.append("Por favor, ").append(nota.getSituacao().equalsIgnoreCase("I") != false ? "CANCELE" : "ESTORNE").append(" a nota fiscal antes de estornar a fatura.");
                    Funcoes.mensagem(this, msg.toString(), 2);
                    return false;
                }
                st = Conexao.getStatement();
                splash = SplashMensagem.getInstancia(this);
                splash.addThreadListener(this);
                buf = new StringBuilder();
                podeCommitar = true;
                listaPreviasFaturamento = null;
                try {
                    listaPreviasFaturamento = new FaturaReceberPagarService().getListaPreviasFaturamento(Variaveis.filialPadrao, this.txtFatura.getText());
                }
                catch (ThreadDaoException e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar lista de pr\u00e9vias de recebimento do faturamento.\n" + e.getMessage(), e.getStackTrace());
                    var10_15 = false;
                    Conexao.fecharStatement(new Statement[]{st});
                    splash.apagar();
                    System.gc();
                    return var10_15;
                }
                serviceRecPag = new ReceberPagarService();
                dataCancelamento = new Date();
                if (listaPreviasFaturamento == null) ** GOTO lbl65
                resp = Funcoes.mensagem(this, "H\u00e1 pr\u00e9vias de faturamento geradas para a fatura.\nEstornar a fatura cancelar\u00e1 as pr\u00e9vias.\nDeseja estornar?", 4);
                if (resp != 1) break block27;
                var12_19 = false;
                Conexao.fecharStatement(new Statement[]{st});
                splash.apagar();
                System.gc();
                return var12_19;
            }
            try {
                for (ReceberPagarVO recVo : listaPreviasFaturamento) {
                    serviceRecPag.cancelarReceberPagar(recVo.getFilial().getCodigo().toString(), recVo.getCodigo().toString(), dataCancelamento, Variaveis.login);
                }
lbl65:
                // 2 sources

                if (!this.consulta.getConferida()) {
                    msg = "Aguarde, estornando as requisi\u00e7\u00f5es da fatura. ";
                    splash.mostrar(msg);
                    System.gc();
                    for (i = 0; i < modeloFatura.getRowCount() - 1; ++i) {
                        dados = (DadosFaturamento)modeloFatura.getValueAt(i, 0);
                        splash.setText(msg + i * 100 / modeloFatura.getRowCount() + "%");
                        for (j = 0; j < dados.getExamesCount(); ++j) {
                            exame = dados.getExame(j);
                            buf.delete(0, buf.length());
                            buf.append("update examerequisicao set ");
                            if (FuncoesGerais.convenioRepasseFaturado(st, dados)) {
                                buf.append("exr_datafaturarepasse = null, ");
                                buf.append("usr_codfaturarepasse = null ");
                            } else {
                                buf.append("exr_datafatura = null, ");
                                buf.append("usr_codfatura = null ");
                            }
                            buf.append("where fil_codigo = ");
                            buf.append(dados.getCodigoFilial());
                            buf.append(" and req_codigo = ");
                            buf.append(dados.getRequisicao());
                            examePai = exame.getExamePai();
                            if (examePai != null) {
                                buf.append("and exa_codigo = '");
                                buf.append(examePai.getCodigo());
                                buf.append("' and mco_codigo = ");
                                buf.append(String.valueOf(examePai.getMaterial()));
                            } else {
                                buf.append("and exa_codigo = '");
                                buf.append(exame.getCodigoExame());
                                buf.append("' and mco_codigo = ");
                                buf.append(String.valueOf(exame.getCodigoMaterial()));
                            }
                            Conexao.execute(String.valueOf(dados.getCodigoFilial()), st, buf.toString());
                            if (examePai != null) {
                                ExportaFiliais.gravaRequisicao(dados.getCodigoFilial(), dados.getRequisicao(), examePai.getCodigo(), examePai.getMaterial(), "U", "U");
                                continue;
                            }
                            ExportaFiliais.gravaRequisicao(dados.getCodigoFilial(), dados.getRequisicao(), exame.getCodigoExame(), exame.getCodigoMaterial(), "U", "U");
                        }
                    }
                    buf.delete(0, buf.length());
                    buf.append("update fatura set fat_datacancelamento = current_timestamp, usr_codcancelamento = '").append(Variaveis.login).append("'");
                    buf.append(" where fil_codigo = ");
                    buf.append(Variaveis.filialPadrao);
                    buf.append(" and fat_codigo = ");
                    buf.append(this.txtFatura.getText());
                    Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
                } else {
                    buf.delete(0, buf.length());
                    buf.append("update fatura set fat_dtconferencia = null, usr_codconferencia = null where ");
                    buf.append("fil_codigo = ");
                    buf.append(Variaveis.filialPadrao);
                    buf.append(" and fat_codigo = ");
                    buf.append(this.txtFatura.getText());
                    Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
                    podeCommitar = this.removerComissao(Variaveis.filialPadrao, this.txtFatura.getText());
                }
                if (podeCommitar) {
                    v0 = podeCommitar = this.verificaComissaoManualGerada(Variaveis.filialPadrao, this.txtFatura.getText()) == false;
                }
                if (podeCommitar) {
                    Conexao.arquivaSQL();
                    break block28;
                }
                Conexao.anulaSQL();
            }
            catch (Exception ex) {
                try {
                    retorno = false;
                    try {
                        Conexao.anulaSQL();
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "EstornoFatura (352)");
                    }
                    catch (SQLException var7_11) {
                        // empty catch block
                    }
                }
                catch (Throwable var17_26) {
                    Conexao.fecharStatement(new Statement[]{st});
                    splash.apagar();
                    System.gc();
                    throw var17_26;
                }
                Conexao.fecharStatement(new Statement[]{st});
                splash.apagar();
                System.gc();
            }
        }
        Conexao.fecharStatement(new Statement[]{st});
        splash.apagar();
        System.gc();
        Conexao.fecharStatement(new Statement[]{st});
        return retorno;
    }

    private boolean verificaComissaoManualGerada(String filial, String codigoFatura) {
        StringBuilder buf = new StringBuilder();
        buf.append(" select count(1) as qtde ");
        buf.append("   from faturareceberpagar ");
        buf.append("  where fil_codigo = ").append(filial);
        buf.append("    and fat_codigo = ").append(codigoFatura);
        buf.append("    and frp_tipo = '").append("C").append("' ");
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                if (rs.getInt("qtde") > 0) {
                    Funcoes.mensagem(this, "Foram geradas comiss\u00f5es manuais para essa fatura.\nN\u00e3o \u00e9 poss\u00edvel estornar a fatura.\nRemova as comiss\u00f5es e tente novamente.", 2);
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (SQLException e) {
            return false;
        }
    }

    private boolean removerComissao(String filial, String codigoFatura) throws Exception {
        ArrayList<ReceberPagarBean> listaRecPag = new FaturaService().getTitulosComissaoFatura(filial, codigoFatura);
        ReceberPagarService serviceRecPag = new ReceberPagarService();
        FaturaReceberPagarService serviceFaturaRecPag = new FaturaReceberPagarService();
        Set<FaturaNotaFiscalBean> lista = null;
        FaturaNotaFiscalBean nota = new FaturaNotaFiscalService().getNotaFiscalFatura(filial, codigoFatura);
        if (nota != null && nota.getNotaFiscal() != null && nota.getNotaFiscal().getCodigo() != null) {
            try {
                lista = new FaturaNotaFiscalService().getFaturasNotaFiscal(filial, nota.getNotaFiscal().getCodigo().toString());
            }
            catch (Exception e2) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados da fatura. - " + e2.getMessage(), 2);
            }
        } else {
            FaturaVO fatura = new FaturaVO();
            fatura.setCodigo(Integer.parseInt(codigoFatura));
            FilialVO filialVO = new FilialVO();
            filialVO.setCodigo(Integer.parseInt(filial));
            fatura.setFilial(filialVO);
            FaturaNotaFiscalBean fatNota = new FaturaNotaFiscalBean();
            fatNota.setFilial(filialVO);
            fatNota.setFatura(fatura);
            HashSet<FaturaNotaFiscalBean> set = new HashSet<FaturaNotaFiscalBean>();
            set.add(fatNota);
            lista = set;
        }
        if (lista != null) {
            for (FaturaNotaFiscalBean aux : lista) {
                if (listaRecPag == null) continue;
                for (int i = 0; i < listaRecPag.size(); ++i) {
                    ReceberPagarBean recPag;
                    ReceberPagarBean recPagOriginal = recPag = listaRecPag.get(i);
                    ReceberPagarVO recPagAux = serviceRecPag.getUltimoEstadoReceberPagar((ReceberPagarVO)recPag.toVO());
                    if ((recPag = (ReceberPagarBean)serviceRecPag.get(recPagAux.getFilial().getCodigo().toString(), recPagAux.getCodigo().toString())).getOrigem() != null && recPag.getOrigem().equalsIgnoreCase("C") && recPag.getSituacao() != null && !recPag.getSituacao().equalsIgnoreCase("A") && !recPag.getSituacao().equalsIgnoreCase("C") && !recPag.getSituacao().equalsIgnoreCase("X")) {
                        StringBuilder buf = new StringBuilder();
                        buf.append("O t\u00edtulo a pagar de comiss\u00e3o (c\u00f3d.: ").append(recPag.getCodigo()).append(") est\u00e1 com a situa\u00e7\u00e3o \"").append(Tipos.tipoSituacaoReceberPagar(recPag.getSituacao())).append("\".\n");
                        buf.append("N\u00e3o \u00e9 poss\u00edvel remover as comiss\u00f5es e estornar a confer\u00eancia da fatura.\n");
                        if (recPag.getSituacao().equalsIgnoreCase("Q")) {
                            buf.append("Estorne as baixas");
                        } else if (recPag.getSituacao().equalsIgnoreCase("L")) {
                            buf.append("Desfa\u00e7a o parcelamento");
                        } else if (recPag.getSituacao().equalsIgnoreCase("G")) {
                            buf.append("Desfa\u00e7a o agrupamento");
                        }
                        buf.append(" do t\u00edtulo a pagar para poder estornar a confer\u00eancia da fatura.");
                        Funcoes.mensagem(Laboratorio.getInstancia(), buf.toString(), 2);
                        Conexao.anulaSQL();
                        return false;
                    }
                    recPag.setSituacao("X");
                    serviceRecPag.gravaAutoCopiaSemCommit(recPag, 1, aux.getFilial().getCodigo().toString(), null);
                    FaturaReceberPagarBean fatRecPagBean = new FaturaReceberPagarBean();
                    fatRecPagBean.setFilial(aux.getFilial());
                    fatRecPagBean.setFatura(aux.getFatura());
                    fatRecPagBean.setReceberPagar((ReceberPagarVO)recPagOriginal.toVO());
                    serviceFaturaRecPag.gravaAutoCopiaSemCommit(fatRecPagBean, 2, aux.getFilial().getCodigo().toString(), null);
                }
                StringBuilder buf = new StringBuilder();
                buf.append(" update fatura ");
                buf.append("    set fat_datacomissao = null ");
                buf.append("       ,usr_codcomissao = null ");
                buf.append("\twhere\tfil_codigo = ").append(aux.getFilial().getCodigo().toString());
                buf.append("    and fat_codigo = ").append(aux.getFatura().getCodigo().toString());
                Conexao.execute(aux.getFilial().getCodigo().toString(), Conexao.getStatement(), buf.toString());
                return true;
            }
        }
        return true;
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.executandoBusca = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.executandoBusca = false;
        this.controlaCampos();
    }
}

