/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.detalhes.Detalhes;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.DialogComposicao;
import jalis.laboratorio.recepcao.util.SolicitarMotivoCancelamento;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.financeiro.ServicoVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class EstornoCancelamentoNotaFiscalPessoaFisica
extends FrmCadPadrao {
    private static final String DESCRICAO_BOTAO_CANCELAR = "Cancelar NF";
    private static final String DESCRICAO_BOTAO_ESTORNAR = "Estornar NF";
    private static final String DESCRICAO_BOTAO_ATUALIZAR = "Atualizar NF";
    private NotaFiscalService service = new NotaFiscalService();
    private NotaFiscalBean notaFiscalBean = null;
    private ModeloGridTable modeloServicos = new ModeloGridTable(new String[]{"C\u00f3d.", "Servi\u00e7o", "Valor"});
    private JTable tableServicos = new JTable(this.modeloServicos);
    private ModeloGridTable modeloParcelas = new ModeloGridTable(new String[]{"Parc.", "Vencto.", "Subtotal", "Total", "Obs."});
    private JTable tableParcelas = new JTable(this.modeloParcelas);
    private JTextArea textObservacao = new JTextArea();
    private JScrollPane scrObservacao = new JScrollPane(this.textObservacao);
    private TTextField textNota = new TTextField(15, 1);
    private TTextField textRPS = new TTextField(8, 1);
    private TTextField textCodCad = new TTextField(8, 1);
    private TTextField textCadastro = new TTextField(150, 3);
    private TTextField textEmissao = new TTextField(10, 4);
    private TTextField textUsuario = new TTextField(80, 3);
    private TTextField textCodSerie = new TTextField(2, 3);
    private TTextField textDescSerie = new TTextField(80, 3);
    private TTextField textValor = new TTextField(18, 2, 2);
    private TTextField textImpostos = new TTextField(18, 2, 2);
    private TTextField textTotal = new TTextField(18, 2, 2);
    private TTextField textCodFormaPgto = new TTextField(5, 1);
    private TTextField textDescFormaPgto = new TTextField(40, 3);
    private TTextField textPaciente = new TTextField();
    private TTextField textRequisicao = new TTextField();
    private TTextField textData = new TTextField();
    private TTextField textMedico = new TTextField();
    private JLabel labelTipoCadastro = new JLabel("");
    private JLabel labelSituacaoNotaImpressa = new JLabel("");
    private JLabel labelRPS = new JLabel("RPS:");
    private JLabel labelNota = new JLabel("N\u00famero:");
    private JLabel labelTipoCadastroRotulo = new JLabel("Tipo Cadastro:");
    private JLabel labelCodCad = new JLabel("C\u00f3d. Cad.:");
    private JLabel labelCadastro = new JLabel("Cadastro:");
    private JLabel labelEmissao = new JLabel("Emiss\u00e3o:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelSerie = new JLabel("S\u00e9rie:");
    private JLabel labelFormaPgto = new JLabel("Forma Pagto.:");
    private JLabel labelValor = new JLabel("Subtotal:");
    private JLabel labelImpostos = new JLabel("(-) Imp.:");
    private JLabel labelTotal = new JLabel("Total:");
    private JLabel labelObservacao = new JLabel("Observa\u00e7\u00e3o");
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelPaciente = new JLabel("Paciente:");
    private JLabel labelMedico = new JLabel("M\u00e9dico:");
    private DetalhesImpostos detalhesImpostos = new DetalhesImpostos(2);
    private JButton buttonComposicao = new JButton("...");

    public EstornoCancelamentoNotaFiscalPessoaFisica() {
        Funcoes.criaBarraDescricao(this, "Estorno/Cancelamento de Nota Fiscal de Pessoa F\u00edsica", "Estorna/Cancela a nota fiscal de pessoas f\u00edsicas", "financeiro/estorno_cancelamento_nf_fisica.jpg");
        this.montaTela();
    }

    private void montaTela() {
        ScreenUtil.setBorda(new Component[]{this.labelTipoCadastro, this.labelSituacaoNotaImpressa}, new TitledBorder(""));
        this.botaoExcluir.setVisible(false);
        this.botaoEditar.setText(DESCRICAO_BOTAO_CANCELAR);
        this.botaoSalvar.setText(DESCRICAO_BOTAO_ESTORNAR);
        this.modeloServicos.setColumnSize(new int[]{60, 0, 70}, this.tableServicos);
        this.modeloParcelas.setColumnSize(new int[]{49, 80, 70, 70, 0}, this.tableParcelas);
        this.modeloServicos.ordenarColuna(0);
        this.modeloParcelas.ordenarColuna(0);
        this.textRPS.setPreferredSize(new Dimension(100, 20));
        this.textRPS.setMinimumSize(new Dimension(100, 20));
        this.textNota.setPreferredSize(new Dimension(130, 20));
        this.textNota.setMinimumSize(new Dimension(130, 20));
        this.textCodCad.setPreferredSize(new Dimension(130, 20));
        this.textCodCad.setMinimumSize(new Dimension(130, 20));
        this.textCadastro.setPreferredSize(new Dimension(320, 20));
        this.textCadastro.setMinimumSize(new Dimension(320, 20));
        this.textEmissao.setPreferredSize(new Dimension(100, 20));
        this.textEmissao.setMinimumSize(new Dimension(100, 20));
        this.textUsuario.setPreferredSize(new Dimension(150, 20));
        this.textUsuario.setMinimumSize(new Dimension(150, 20));
        this.textCodSerie.setPreferredSize(new Dimension(40, 20));
        this.textCodSerie.setMinimumSize(new Dimension(40, 20));
        this.textDescSerie.setPreferredSize(new Dimension(280, 20));
        this.textDescSerie.setMinimumSize(new Dimension(280, 20));
        this.textValor.setPreferredSize(new Dimension(100, 20));
        this.textValor.setMinimumSize(new Dimension(100, 20));
        this.textImpostos.setPreferredSize(new Dimension(130, 20));
        this.textImpostos.setMinimumSize(new Dimension(130, 20));
        this.textTotal.setPreferredSize(new Dimension(100, 20));
        this.textTotal.setMinimumSize(new Dimension(100, 20));
        this.textCodFormaPgto.setPreferredSize(new Dimension(40, 20));
        this.textCodFormaPgto.setMinimumSize(new Dimension(40, 20));
        this.textDescFormaPgto.setPreferredSize(new Dimension(280, 20));
        this.textDescFormaPgto.setMinimumSize(new Dimension(280, 20));
        this.labelTipoCadastro.setPreferredSize(new Dimension(100, 20));
        this.labelTipoCadastro.setMinimumSize(new Dimension(100, 20));
        this.buttonComposicao.setPreferredSize(new Dimension(30, 20));
        this.buttonComposicao.setMinimumSize(new Dimension(30, 20));
        this.buttonComposicao.setMargin(new Insets(1, 1, 1, 1));
        this.buttonComposicao.setToolTipText("Mostrar composi\u00e7\u00e3o dos impostos");
        this.buttonComposicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EstornoCancelamentoNotaFiscalPessoaFisica.this.notaFiscalBean != null) {
                    DialogComposicao.invocaTela((Window)EstornoCancelamentoNotaFiscalPessoaFisica.this.getTopLevelAncestor(), EstornoCancelamentoNotaFiscalPessoaFisica.this.notaFiscalBean);
                }
            }
        });
        this.labelSituacaoNotaImpressa.setPreferredSize(new Dimension(200, 20));
        this.labelSituacaoNotaImpressa.setMinimumSize(new Dimension(200, 20));
        this.labelSituacaoNotaImpressa.setHorizontalAlignment(4);
        this.scrObservacao.setPreferredSize(new Dimension(20, 30));
        this.scrObservacao.setMinimumSize(new Dimension(20, 30));
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JScrollPane scrollServicos = new JScrollPane(this.tableServicos);
        scrollServicos.setPreferredSize(new Dimension(200, 120));
        scrollServicos.setMinimumSize(new Dimension(200, 120));
        scrollServicos.setVerticalScrollBarPolicy(20);
        JScrollPane scrollParcelas = new JScrollPane(this.tableParcelas);
        scrollParcelas.setPreferredSize(new Dimension(200, 120));
        scrollParcelas.setMinimumSize(new Dimension(200, 120));
        scrollParcelas.setVerticalScrollBarPolicy(20);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(4, 2, 0, 0);
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelRPS), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textRPS, c);
        c.gridwidth = 1;
        c.gridx += 3;
        this.painelCentral.add(new JPanel().add(new JLabel(" ")), c);
        c.gridx += 2;
        this.painelCentral.add((Component)this.labelNota, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textNota, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(4, 2, 0, 4);
        this.painelCentral.add(new JPanel().add(this.labelSituacaoNotaImpressa), c);
        c.anchor = 17;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(2, 2, 0, 0);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add(new JPanel().add(this.labelTipoCadastroRotulo), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.labelTipoCadastro, c);
        c.gridx += 4;
        c.gridwidth = 1;
        this.painelCentral.add((Component)new JLabel(" "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelCodCad), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textCodCad, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelCadastro), c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textCadastro, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelEmissao), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textEmissao, c);
        c.gridx += 4;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        this.painelCentral.add((Component)new JLabel(" "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelUsuario), c);
        ++c.gridx;
        c.gridwidth = 5;
        c.fill = 2;
        this.painelCentral.add((Component)this.textUsuario, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelSerie), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 0);
        this.painelCentral.add((Component)this.textCodSerie, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 0, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescSerie, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelFormaPgto), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 0);
        this.painelCentral.add((Component)this.textCodFormaPgto, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 0, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescFormaPgto, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelValor), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textValor, c);
        c.gridx += 4;
        c.gridwidth = 1;
        this.painelCentral.add((Component)new JLabel(" "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelImpostos), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 0);
        this.painelCentral.add((Component)this.textImpostos, c);
        ++c.gridx;
        c.insets = new Insets(2, 0, 0, 4);
        this.painelCentral.add((Component)this.buttonComposicao, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        this.painelCentral.add((Component)new JLabel(" "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelTotal), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        this.painelCentral.add((Component)this.textTotal, c);
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelObservacao, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.scrObservacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 12;
        c.fill = 2;
        this.painelCentral.add((Component)this.detalhesImpostos, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 12;
        c.insets = new Insets(2, 2, 0, 4);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel painelInterno = new JPanel();
        painelInterno.setBorder(BorderFactory.createEtchedBorder());
        painelInterno.setLayout(new GridBagLayout());
        this.painelCentral.add((Component)painelInterno, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.3;
        c.weighty = 0.35;
        c.gridwidth = 1;
        c.fill = 1;
        JPanel panelServicos = ComponenteFactory.novoJPanelBorderLayout("Servi\u00e7os", scrollServicos);
        panelServicos.setPreferredSize(new Dimension(200, 200));
        painelInterno.add((Component)panelServicos, c);
        c.gridx += 2;
        c.weightx = 0.65;
        JPanel panelParcelas = ComponenteFactory.novoJPanelBorderLayout("Parcelas", scrollParcelas);
        panelParcelas.setPreferredSize(new Dimension(200, 200));
        painelInterno.add((Component)panelParcelas, c);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        painelInterno.add((Component)this.montaPanelRequisicao(), c);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        Funcoes.montaEnter((JComponent)this.painelCentral);
        this.controlaCampos();
    }

    private JPanel montaPanelRequisicao() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00e3o"));
        GridBagLayout gbl_panelDados = new GridBagLayout();
        panel.setLayout(gbl_panelDados);
        GridBagConstraints gbc_labelRequisicao = new GridBagConstraints();
        gbc_labelRequisicao.insets = new Insets(0, 0, 0, 0);
        gbc_labelRequisicao.anchor = 17;
        gbc_labelRequisicao.gridx = 0;
        gbc_labelRequisicao.gridy = 0;
        panel.add((Component)this.labelRequisicao, gbc_labelRequisicao);
        this.textPaciente.setMinimumSize(new Dimension(20, 20));
        this.textPaciente.setPreferredSize(new Dimension(20, 20));
        GridBagConstraints gbc_labelVlrPaciente = new GridBagConstraints();
        gbc_labelVlrPaciente.insets = new Insets(0, 0, 0, 0);
        gbc_labelVlrPaciente.fill = 2;
        gbc_labelVlrPaciente.gridwidth = 4;
        gbc_labelVlrPaciente.anchor = 17;
        gbc_labelVlrPaciente.gridx = 3;
        gbc_labelVlrPaciente.gridy = 0;
        panel.add((Component)this.textPaciente, gbc_labelVlrPaciente);
        this.textRequisicao.setHorizontalAlignment(4);
        this.textRequisicao.setMinimumSize(new Dimension(90, 20));
        this.textRequisicao.setPreferredSize(new Dimension(90, 20));
        GridBagConstraints gbc_labelVlrRequisicao = new GridBagConstraints();
        gbc_labelVlrRequisicao.insets = new Insets(0, 0, 0, 0);
        gbc_labelVlrRequisicao.anchor = 17;
        gbc_labelVlrRequisicao.gridx = 1;
        gbc_labelVlrRequisicao.gridy = 0;
        panel.add((Component)this.textRequisicao, gbc_labelVlrRequisicao);
        GridBagConstraints gbc_labelData = new GridBagConstraints();
        gbc_labelData.insets = new Insets(0, 0, 0, 0);
        gbc_labelData.anchor = 17;
        gbc_labelData.gridx = 0;
        gbc_labelData.gridy = 1;
        panel.add((Component)this.labelData, gbc_labelData);
        GridBagConstraints gbc_labelPaciente = new GridBagConstraints();
        gbc_labelPaciente.insets = new Insets(0, 20, 0, 0);
        gbc_labelPaciente.anchor = 17;
        gbc_labelPaciente.gridx = 2;
        gbc_labelPaciente.gridy = 0;
        panel.add((Component)this.labelPaciente, gbc_labelPaciente);
        this.textData.setMinimumSize(new Dimension(90, 20));
        this.textData.setPreferredSize(new Dimension(90, 20));
        GridBagConstraints gbc_labelVlrData = new GridBagConstraints();
        gbc_labelVlrData.insets = new Insets(0, 0, 0, 0);
        gbc_labelVlrData.anchor = 17;
        gbc_labelVlrData.gridx = 1;
        gbc_labelVlrData.gridy = 1;
        panel.add((Component)this.textData, gbc_labelVlrData);
        GridBagConstraints gbc_labelMedico = new GridBagConstraints();
        gbc_labelMedico.insets = new Insets(0, 20, 0, 0);
        gbc_labelMedico.anchor = 17;
        gbc_labelMedico.gridx = 2;
        gbc_labelMedico.gridy = 1;
        panel.add((Component)this.labelMedico, gbc_labelMedico);
        this.textMedico.setMinimumSize(new Dimension(20, 20));
        this.textMedico.setPreferredSize(new Dimension(20, 20));
        GridBagConstraints gbc_labelVlrMedico = new GridBagConstraints();
        gbc_labelVlrMedico.insets = new Insets(0, 0, 0, 0);
        gbc_labelVlrMedico.fill = 2;
        gbc_labelVlrMedico.weightx = 1.0;
        gbc_labelVlrMedico.anchor = 17;
        gbc_labelVlrMedico.gridx = 3;
        gbc_labelVlrMedico.gridy = 1;
        gbc_labelVlrMedico.gridwidth = 4;
        panel.add((Component)this.textMedico, gbc_labelVlrMedico);
        return panel;
    }

    public void controlaCampos() {
        this.textRPS.setEnabled(false);
        this.textNota.setEnabled(false);
        this.textCadastro.setEnabled(false);
        this.textCodCad.setEnabled(false);
        this.textEmissao.setEnabled(false);
        this.textUsuario.setEnabled(false);
        this.textCodSerie.setEnabled(false);
        this.textDescSerie.setEnabled(false);
        this.textValor.setEnabled(false);
        this.textImpostos.setEnabled(false);
        this.textTotal.setEnabled(false);
        this.textCodFormaPgto.setEnabled(false);
        this.textDescFormaPgto.setEnabled(false);
        this.labelTipoCadastro.setEnabled(false);
        this.textObservacao.setEnabled(false);
        this.scrObservacao.setEnabled(false);
        this.textRequisicao.setEnabled(false);
        this.textPaciente.setEnabled(false);
        this.textData.setEnabled(false);
        this.textMedico.setEnabled(false);
        this.buttonComposicao.setEnabled(this.getStatus() == 2);
        this.controlaBotoes();
    }

    protected void controlaBotoes() {
        if (this.notaFiscalBean != null) {
            this.botaoCancelar.setEnabled(true);
            this.botaoFechar.setEnabled(true);
            this.botaoNovo.setEnabled(false);
            String situacao = this.notaFiscalBean.getSituacao();
            if (this.notaFiscalBean.getNumeroRps() == null) {
                if (situacao.equals("I")) {
                    this.botaoEditar.setEnabled(true);
                    this.botaoSalvar.setEnabled(false);
                } else if (situacao.equals("A")) {
                    this.botaoEditar.setEnabled(false);
                    this.botaoSalvar.setEnabled(true);
                }
            } else {
                if (situacao.equals("N") || situacao.equals("S")) {
                    this.botaoEditar.setText(DESCRICAO_BOTAO_ATUALIZAR);
                }
                this.botaoEditar.setEnabled(true);
                this.botaoSalvar.setEnabled(false);
            }
        } else {
            this.botaoCancelar.setEnabled(false);
            this.botaoEditar.setEnabled(false);
            this.botaoSalvar.setEnabled(false);
            this.botaoFechar.setEnabled(true);
            this.botaoNovo.setEnabled(true);
        }
    }

    @Override
    public void novo() {
        this.cancelar();
        NotaFiscalBean bean = this.pesquisar();
        if (bean != null) {
            this.setStatus(2);
            this.preencheDadosRequisicao(bean);
            this.controlaCampos();
            this.painelCentral.grabFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void preencheDadosRequisicao(NotaFiscalBean bean) {
        if (bean == null) {
            return;
        }
        this.notaFiscalBean = bean;
        StringBuilder buf = new StringBuilder();
        buf.append(" select req.req_codigo as codigoRequisicao ");
        buf.append("       ,pac.pac_nome as nomePaciente ");
        buf.append("       ,req.req_data as dataRequisicao ");
        buf.append("       ,req.med_conselho as conselhoMedico ");
        buf.append("       ,req.med_crm as crmMedico ");
        buf.append("       ,req.med_uf as ufMedico ");
        buf.append("       ,med.med_nome as nomeMedico ");
        buf.append("   from notafiscal      \t\t\t\tnfi ");
        buf.append("   join receberpagar      \t\t\trpg on nfi.fil_codigo = rpg.fil_codigo and nfi.nfi_codigo = rpg.nfi_codigo and (rpg.usr_codcancelado IS NULL and rpg.rpg_datacancelado IS NULL) ");
        buf.append("   join baixareceberpagar \t\t\tbrp on rpg.fil_codigo = brp.fil_codigo and rpg.rpg_codigo = brp.rpg_codigo ");
        buf.append("   join baixa             \t\t\tbxa on brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo and bxa.bxa_datacancelado IS NULL ");
        buf.append("   join baixalanctocaixa  \t\t\tblc on bxa.fil_codigo = blc.fil_codigo and bxa.bxa_codigo = blc.bxa_codigo ");
        buf.append("   join lanctocaixa            \tlcx on blc.fil_codigo = lcx.fil_codigo and blc.lcx_codigo = lcx.lcx_codigo and blc.est_codigo = lcx.est_codigo ");
        buf.append("   join requisicaolanctocaixa  \trlc on lcx.fil_codigo = rlc.fil_codigo and lcx.lcx_codigo = rlc.lcx_codigo and lcx.est_codigo = rlc.est_codigo ");
        buf.append("   join requisicao             \treq on rlc.fil_codigo = req.fil_codigo and rlc.req_codigo = req.req_codigo ");
        buf.append("   join paciente        \t\t\t\tpac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
        buf.append("   join medico          \t\t\t\tmed on req.fil_codigo = med.fil_codigo and req.med_conselho = med.med_conselho and req.med_crm = med.med_crm and req.med_uf = med.med_uf ");
        buf.append("  where nfi.fil_codigo = ").append(bean.getFilial().getCodigo());
        buf.append("    and nfi.nfi_codigo = ").append(bean.getCodigo());
        buf.append("    and NOT req.req_excluida ");
        buf.append("    and (lcx.usr_codcancelado IS NULL and lcx.lcx_datacancelado IS NULL) ");
        buf.append("    and nfi.nfi_tipo = '").append("F").append("' ");
        buf.append("  order by req.req_codigo ");
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        rs = st.executeQuery(buf.toString());
        if (rs.next()) {
            this.preencherDados(rs);
        } else {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar os dados associados \u00e0 nota fiscal.", 2);
        }
        if (rs == null) return;
        try {
            rs.close();
            Conexao.fecharStatement(st);
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return;
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar dados associados \u00e0 nota fiscal.\n" + e.getMessage(), e.getStackTrace());
                if (rs == null) return;
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
            try {
                rs.close();
                Conexao.fecharStatement(st);
                return;
            }
            catch (SQLException e3) {
                e3.printStackTrace();
            }
            return;
        }
    }

    private void preencherDados(ResultSet rs) throws SQLException {
        if (rs == null) {
            return;
        }
        this.textRequisicao.setText(rs.getString("codigoRequisicao"));
        this.textPaciente.setText(rs.getString("nomePaciente"));
        this.textData.setText(Funcoes.formataData(rs.getDate("dataRequisicao")));
        this.textMedico.setText(rs.getString("conselhoMedico") + " " + rs.getString("crmMedico") + " " + rs.getString("ufMedico") + " - " + rs.getString("nomeMedico"));
        if (this.notaFiscalBean.getNumero() != null) {
            this.textNota.setText(this.notaFiscalBean.getNumero().toString());
        }
        if (this.notaFiscalBean.getNumeroRps() != null) {
            this.textRPS.setText(this.notaFiscalBean.getNumeroRps().toString());
        }
        if (this.notaFiscalBean.getSituacao().equals("I")) {
            this.labelSituacaoNotaImpressa.setText("Impress\u00e3o: " + Funcoes.formataData("dd/MM/yyyy HH:mm", this.notaFiscalBean.getDataHoraImpressao()) + " por " + this.notaFiscalBean.getUsuarioImpressao().getCodigo() + ".");
        } else {
            this.labelSituacaoNotaImpressa.setText(Tipos.tipoSituacaoNotaFiscal(this.notaFiscalBean.getSituacao(), this.notaFiscalBean.getNumeroRps() != null));
        }
        AbstractThreadVO cadastroVO = null;
        if (this.notaFiscalBean.getTipoCadastro().equals("P")) {
            cadastroVO = this.notaFiscalBean.getPaciente();
            this.textCadastro.setText(((PacienteVO)cadastroVO).getNome());
            this.textCodCad.setText(((PacienteVO)cadastroVO).getCodigo().toString());
            this.labelTipoCadastro.setText(Tipos.tipoCadastro("P"));
        } else if (this.notaFiscalBean.getTipoCadastro().equals("O")) {
            cadastroVO = this.notaFiscalBean.getConvenio();
            if (cadastroVO != null) {
                this.textCadastro.setText(((ConvenioVO)cadastroVO).getFantasia());
                this.textCodCad.setText(((ConvenioVO)cadastroVO).getCodigo().toString());
                this.labelTipoCadastro.setText(Tipos.tipoCadastro("O"));
            }
        } else {
            cadastroVO = this.notaFiscalBean.getEntidade();
            if (cadastroVO != null) {
                this.textCadastro.setText(((EntidadeVO)cadastroVO).getFantasia());
                this.textCodCad.setText(((EntidadeVO)cadastroVO).getCodigo().toString());
                this.labelTipoCadastro.setText(Tipos.tipoCadastro(((EntidadeVO)cadastroVO).getTipo()));
            }
        }
        this.textEmissao.setText(Funcoes.formataData("dd/MM/yyyy", this.notaFiscalBean.getDataEmissao()));
        this.textUsuario.setText(this.notaFiscalBean.getUsuario().getDescricao());
        this.textCodSerie.setText(this.notaFiscalBean.getSerie().getCodigo().toString());
        this.textDescSerie.setText(this.notaFiscalBean.getSerie().getDescricao());
        this.textValor.setText(Funcoes.formataDecimal(this.textValor.getMaskDecimal(), this.notaFiscalBean.getSubTotal()));
        this.textImpostos.setText(Funcoes.formataDecimal(this.textImpostos.getMaskDecimal(), this.notaFiscalBean.getCofinsValor() + this.notaFiscalBean.getCsllValor() + this.notaFiscalBean.getInssValor() + this.notaFiscalBean.getIrrfValor() + this.notaFiscalBean.getIssValor() + this.notaFiscalBean.getPisValor()));
        this.textTotal.setText(Funcoes.formataDecimal(this.textTotal.getMaskDecimal(), this.notaFiscalBean.getValor()));
        this.textCodFormaPgto.setText(this.notaFiscalBean.getFormaPagamento().getCodigo().toString());
        this.textDescFormaPgto.setText(this.notaFiscalBean.getFormaPagamento().getDescricao());
        this.textObservacao.setText(this.notaFiscalBean.getObservacao() == null ? "" : this.notaFiscalBean.getObservacao());
        if (this.notaFiscalBean.getServico() != null && this.notaFiscalBean.getServico().getServico() != null) {
            ServicoVO servico = this.notaFiscalBean.getServico().getServico();
            Object[] linha = new Object[4];
            linha[0] = servico.getCodigo();
            linha[1] = servico.getDescricao();
            linha[2] = Funcoes.formataDecimal("0.00", this.notaFiscalBean.getSubTotal());
            this.modeloServicos.addLine(linha);
        }
        if (this.notaFiscalBean.getParcelas() != null) {
            Object[] array = this.notaFiscalBean.getParcelas().toArray();
            for (int i = 0; i < array.length; ++i) {
                Object[] linha = new Object[]{((ReceberPagarBean)array[i]).getParcela(), Funcoes.formataData("dd/MM/yyyy", ((ReceberPagarBean)array[i]).getDataVencimento()), Funcoes.formataDecimal("0.00", ((ReceberPagarBean)array[i]).getValor()), Funcoes.formataDecimal("0.00", ((ReceberPagarBean)array[i]).getValorTotal()), ((ReceberPagarBean)array[i]).getObservacao()};
                this.modeloParcelas.addLine(linha);
            }
        }
        this.detalhesImpostos.setValores(this.notaFiscalBean.getInssValor(), this.notaFiscalBean.getIssValor(), this.notaFiscalBean.getPisValor(), this.notaFiscalBean.getCofinsValor(), this.notaFiscalBean.getCsllValor(), this.notaFiscalBean.getIrrfValor(), this.notaFiscalBean.getInssPercentual(), this.notaFiscalBean.getIssPercentual(), this.notaFiscalBean.getPisPercentual(), this.notaFiscalBean.getCofinsPercentual(), this.notaFiscalBean.getCsllPercentual(), this.notaFiscalBean.getIrrfPercentual());
        this.modeloServicos.ordenarColuna(0);
        this.modeloParcelas.ordenarColuna(0);
    }

    protected NotaFiscalBean pesquisar() {
        try {
            NotaFiscalService service = new NotaFiscalService();
            AbstractThreadVO vo = service.pesquisaEstornoCancelamentoPessoaFisicaVO(this.getTopLevelAncestor(), new NotaFiscalVO(), "Pesquisando Notas Fiscais", true, "P");
            if (vo != null) {
                NotaFiscalBean notaFiscalBean = (NotaFiscalBean)new NotaFiscalService().get(((NotaFiscalVO)vo).getFilial().getCodigo().toString(), ((NotaFiscalVO)vo).getCodigo().toString());
                if (notaFiscalBean != null) {
                    if (this.validaNF(notaFiscalBean)) {
                        return notaFiscalBean;
                    }
                    return null;
                }
                return null;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    protected boolean validaNF(NotaFiscalBean bean) {
        if (bean.getNumeroRps() == null) {
            if (bean.getSituacao().equals("C")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal j\u00e1 foi \"Cancelada\".", 2);
                return false;
            }
            if (bean.getSituacao().equals("E")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal j\u00e1 foi \"Estornada\".", 2);
                return false;
            }
        } else {
            String situacao = bean.getSituacao();
            if (situacao.equals("C")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal j\u00e1 foi \"Cancelada\".", 2);
                return false;
            }
            if (situacao.equals("S")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O cancelamento da Nota fiscal est\u00e1 pendente no servidor.\nClique em \"Atualizar NF\" para consultar o status do cancelamento", 2);
            }
            if (situacao.equals("N")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "O cancelamento da Nota fiscal est\u00e1 pendente no servidor.\nClique em \"Atualizar NF\" para consultar o status do cancelamento", 2);
            }
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600201000");
    }

    @Override
    public void salvar() {
        this.cancelarEstornaNF(false);
    }

    @Override
    public void cancelar() {
        this.limparCampos();
        this.setStatus(1);
        this.notaFiscalBean = null;
        this.controlaCampos();
    }

    private void limparCampos() {
        this.textRPS.clear();
        this.textNota.setText("");
        this.textCadastro.setText("");
        this.textCodCad.setText("");
        this.textEmissao.setText("");
        this.labelSituacaoNotaImpressa.setText("");
        this.textUsuario.setText("");
        this.textCodSerie.setText("");
        this.textDescSerie.setText("");
        this.textValor.setText("");
        this.textImpostos.setText("");
        this.textTotal.setText("");
        this.textCodFormaPgto.setText("");
        this.textDescFormaPgto.setText("");
        this.modeloServicos.clear();
        this.modeloParcelas.clear();
        this.labelTipoCadastro.setText("");
        this.textObservacao.setText("");
        this.detalhesImpostos.setValores(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.textRequisicao.clear();
        this.textPaciente.clear();
        this.textData.clear();
        this.textMedico.clear();
        this.botaoEditar.setText(DESCRICAO_BOTAO_CANCELAR);
    }

    @Override
    public void excluir() {
    }

    @Override
    public void editar() {
        if (this.botaoEditar.getText().equals(DESCRICAO_BOTAO_CANCELAR)) {
            this.cancelarEstornaNF(true);
        }
        if (this.botaoEditar.getText().equals(DESCRICAO_BOTAO_ATUALIZAR)) {
            this.atualizarNotaFiscal();
        }
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    @Override
    public boolean validaCampos() {
        return false;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    public void cancelarEstornaNF(boolean cancelaNF) {
        if (Funcoes.mensagem(this, "Voc\u00ea realmente deseja" + (cancelaNF ? " cancelar " : " estornar ") + "a nota fiscal?", 4) == 0) {
            SolicitarMotivoCancelamento telaMotivoCancelamento = new SolicitarMotivoCancelamento(Laboratorio.getInstancia(), "Motivo de Cancelamento", false);
            telaMotivoCancelamento.setVisible(true);
            if (!telaMotivoCancelamento.getOK()) {
                return;
            }
            if (telaMotivoCancelamento == null || telaMotivoCancelamento.getCodigoMotivo() == -1 || telaMotivoCancelamento.getCancelado()) {
                Funcoes.mensagem(this, "O Motivo de Cancelamento da Nota Fiscal n\u00e3o foi selecionado.\nO" + (cancelaNF ? " cancelamento" : " estorno") + " ser\u00e1 abortado.", 2);
                return;
            }
            try {
                String msg = new NotaFiscalService().cancelarEstornaNFPessoaFisica(cancelaNF, this.notaFiscalBean, telaMotivoCancelamento);
                this.exibirMensagem(msg, cancelaNF);
            }
            catch (Exception e) {
                this.anularSQL();
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void atualizarNotaFiscal() {
        try {
            NotaFiscalService notaService = new NotaFiscalService();
            String msg = notaService.atualizarSolicitacaoCancelamentoNFSe(this.notaFiscalBean);
            this.exibirMensagem(msg, true);
        }
        catch (Exception e) {
            this.anularSQL();
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
    }

    private void exibirMensagem(String mensagem, boolean cancelaNF) throws SQLException {
        if (!Funcoes.textoVazio(mensagem)) {
            Conexao.arquivaSQL();
            if (this.notaFiscalBean.getNumeroRps() == null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal n\u00famero: \"" + this.notaFiscalBean.getNumero() + "\" foi" + (cancelaNF ? " cancelada " : " estornada ") + "com sucesso.", 5);
            } else if (cancelaNF) {
                Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 5);
            }
        } else {
            Conexao.anulaSQL();
            Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 2);
        }
        this.cancelar();
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class DetalhesImpostos
    extends Detalhes {
        private Double valorInss;
        private Double valorIss;
        private Double valorPis;
        private Double valorCofins;
        private Double valorCsll;
        private Double valorIrrf;
        private Double percInss;
        private Double percIss;
        private Double percPis;
        private Double percCofins;
        private Double percCsll;
        private Double percIrrf;

        public DetalhesImpostos(int situacao) {
            super(situacao);
            this.valorInss = new Double(0.0);
            this.valorIss = new Double(0.0);
            this.valorPis = new Double(0.0);
            this.valorCofins = new Double(0.0);
            this.valorCsll = new Double(0.0);
            this.valorIrrf = new Double(0.0);
            this.percInss = new Double(0.0);
            this.percIss = new Double(0.0);
            this.percPis = new Double(0.0);
            this.percCofins = new Double(0.0);
            this.percCsll = new Double(0.0);
            this.percIrrf = new Double(0.0);
            this.valorInss = new Double(0.0);
            this.valorIss = new Double(0.0);
            this.valorPis = new Double(0.0);
            this.valorCofins = new Double(0.0);
            this.valorCsll = new Double(0.0);
            this.valorIrrf = new Double(0.0);
            this.percInss = new Double(0.0);
            this.percIss = new Double(0.0);
            this.percPis = new Double(0.0);
            this.percCofins = new Double(0.0);
            this.percCsll = new Double(0.0);
            this.percIrrf = new Double(0.0);
            this.setFont(this.getFont().deriveFont(11.0f));
        }

        @Override
        public void montaExpandido() {
            this.setPreferredSize(new Dimension(10, 40));
            super.montaExpandido();
        }

        @Override
        public void montaReduzido() {
            this.setPreferredSize(new Dimension(10, 20));
            super.montaReduzido();
        }

        public void setValores(Double valorInss, Double valorIss, Double valorPis, Double valorCofins, Double valorCsll, Double valorIrrf, Double percInss, Double percIss, Double percPis, Double percCofins, Double percCsll, Double percIrrf) {
            this.valorInss = valorInss;
            this.valorIss = valorIss;
            this.valorPis = valorPis;
            this.valorCofins = valorCofins;
            this.valorCsll = valorCsll;
            this.valorIrrf = valorIrrf;
            this.percInss = percInss;
            this.percIss = percIss;
            this.percPis = percPis;
            this.percCofins = percCofins;
            this.percCsll = percCsll;
            this.percIrrf = percIrrf;
            this.atualizarDados();
        }

        @Override
        protected void atualizarDados() {
            StringBuilder html = new StringBuilder();
            if (this.getSituacao() == 2) {
                this.limpaDados();
                html.append("<html>");
                html.append("<table>");
                html.append("<font size=20>");
                html.append("<tr>");
                html.append("<td><b>Detalhes dos Impostos").append("</b></td>");
                html.append("</tr>");
                html.append("</font>");
                html.append("</table>");
                html.append("</html>");
            } else {
                html.append("<html>");
                html.append("<table>");
                html.append("<font size=20>");
                html.append("<tr>");
                html.append("<td><b>Inss: ").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorInss == null ? "" : Funcoes.formataDecimal("0.00", this.valorInss)).append("</td>");
                html.append("<td width=15>-</td>");
                html.append("<td align=\"right\" width=40>").append(this.percInss == null ? "" : Funcoes.formataDecimal("0.00", this.percInss)).append("%</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Iss: ").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorIss == null ? "" : Funcoes.formataDecimal("0.00", this.valorIss)).append("</td>");
                html.append("<td width=15>-</td>");
                html.append("<td align=\"right\" width=40>").append(this.percIss == null ? "" : Funcoes.formataDecimal("0.00", this.percIss)).append("%</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Pis: ").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorPis == null ? "" : Funcoes.formataDecimal("0.00", this.valorPis)).append("</td>");
                html.append("<td width=15>-</td>");
                html.append("<td align=\"right\" width=40>").append(this.percPis == null ? "" : Funcoes.formataDecimal("0.00", this.percPis)).append("%</td>");
                html.append("</tr>");
                html.append("<tr>");
                html.append("<td><b>Cofins: ").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorCofins == null ? "" : Funcoes.formataDecimal("0.00", this.valorCofins)).append("</td>");
                html.append("<td width=15>-</td>");
                html.append("<td align=\"right\" width=40>").append(this.percCofins == null ? "" : Funcoes.formataDecimal("0.00", this.percCofins)).append("%</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Csll: ").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorCsll == null ? "" : Funcoes.formataDecimal("0.00", this.valorCsll)).append("</td>");
                html.append("<td width=15>-</td>");
                html.append("<td align=\"right\" width=40>").append(this.percCsll == null ? "" : Funcoes.formataDecimal("0.00", this.percCsll)).append("%</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Irrf: ").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorIrrf == null ? "" : Funcoes.formataDecimal("0.00", this.valorIrrf)).append("</td>");
                html.append("<td width=15>-</td>");
                html.append("<td align=\"right\" width=40>").append(this.percIrrf == null ? "" : Funcoes.formataDecimal("0.00", this.percIrrf)).append("%</td>");
                html.append("</tr>");
                html.append("</font>");
                html.append("</table>");
                html.append("</html>");
            }
            this.setDetalhes(html.toString());
            this.repaint();
        }
    }
}

