/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Tipos;
import jalis.comum.detalhes.Detalhes;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.financeiro.faturamento.DialogComposicao;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.MedicoVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.financeiro.ServicoVO;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.service.financeiro.faturamento.EstornoCancelamentoNotaFiscalEmpresaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class EstornoCancelamentoNotaFiscalEmpresa
extends FrmCadPadrao {
    public static final Long ACESSO_ACESSAR = Long.parseLong("0600201500");
    private final EstornoCancelamentoNotaFiscalEmpresaService service;
    private NotaFiscalBean notaFiscalBean = null;
    private ModeloGridTable modeloServicos = new ModeloGridTable(new String[]{"C\u00f3d.", "Servi\u00e7o", "Valor"});
    private JTable tableServicos = new JTable(this.modeloServicos);
    private ModeloGridTable modeloParcelas = new ModeloGridTable(new String[]{"Parc.", "Vencto.", "Subtotal", "Total", "Obs."});
    private JTable tableParcelas = new JTable(this.modeloParcelas);
    private JTextArea textObservacao = new JTextArea();
    private JScrollPane scrObservacao = new JScrollPane(this.textObservacao);
    private TTextField textNota = new TTextField(15, 1);
    private TTextField textRPS = new TTextField(8, 1);
    private TTextField textCodCad = new TTextField(8, 1);
    private TTextField textCadastro = new TTextField(150, 3);
    private TTextField textEmissao = new TTextField(10, 4);
    private TTextField textUsuario = new TTextField(80, 3);
    private TTextField textCodSerie = new TTextField(2, 3);
    private TTextField textDescSerie = new TTextField(80, 3);
    private TTextField textValor = new TTextField(18, 2, 2);
    private TTextField textImpostos = new TTextField(18, 2, 2);
    private TTextField textTotal = new TTextField(18, 2, 2);
    private TTextField textCodFormaPgto = new TTextField(5, 1);
    private TTextField textDescFormaPgto = new TTextField(40, 3);
    private TTextField textEmpresa = new TTextField();
    private TTextField textRequisicao = new TTextField();
    private TTextField textData = new TTextField();
    private TTextField textColetador = new TTextField();
    private JLabel labelTipoCadastro = new JLabel("");
    private JLabel labelSituacaoNotaImpressa = new JLabel("");
    private JLabel labelRPS = new JLabel("RPS:");
    private JLabel labelNota = new JLabel("N\u00famero:");
    private JLabel labelTipoCadastroRotulo = new JLabel("Tipo Cadastro:");
    private JLabel labelCodCad = new JLabel("C\u00f3d. Cad.:");
    private JLabel labelCadastro = new JLabel("Cadastro:");
    private JLabel labelEmissao = new JLabel("Emiss\u00e3o:");
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private JLabel labelSerie = new JLabel("S\u00e9rie:");
    private JLabel labelFormaPgto = new JLabel("Forma Pagto.:");
    private JLabel labelValor = new JLabel("Subtotal:");
    private JLabel labelImpostos = new JLabel("(-) Imp.:");
    private JLabel labelTotal = new JLabel("Total:");
    private JLabel labelObservacao = new JLabel("Observa\u00e7\u00e3o");
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelEmpresa = new JLabel("Empresa:");
    private JLabel labelColetador = new JLabel("Coletador:");
    private DetalhesImpostos detalhesImpostos = new DetalhesImpostos(2);
    private JButton buttonComposicao = new JButton("...");

    public EstornoCancelamentoNotaFiscalEmpresa() {
        Funcoes.criaBarraDescricao(this, "Estorno/Cancelamento de Nota Fiscal para Empresa", "Estorna/Cancela a nota fiscal para empresa", "financeiro/estorno_cancelamento_nf_empresa.jpg");
        this.service = new EstornoCancelamentoNotaFiscalEmpresaService();
        this.montaTela();
    }

    private void montaTela() {
        ScreenUtil.setBorda(new Component[]{this.labelTipoCadastro, this.labelSituacaoNotaImpressa}, new TitledBorder(""));
        this.botaoExcluir.setVisible(false);
        this.botaoEditar.setText("Cancelar NF");
        this.botaoSalvar.setText("Estornar NF");
        this.modeloServicos.setColumnSize(new int[]{60, 0, 70}, this.tableServicos);
        this.modeloParcelas.setColumnSize(new int[]{49, 80, 70, 70, 0}, this.tableParcelas);
        this.modeloServicos.ordenarColuna(0);
        this.modeloParcelas.ordenarColuna(0);
        Dimension d = new Dimension(100, 20);
        this.textRPS.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.textRPS.setMinimumSize(d);
        d = new Dimension(130, 20);
        this.textNota.setPreferredSize(d);
        d = new Dimension(130, 20);
        this.textNota.setMinimumSize(d);
        d = new Dimension(130, 20);
        this.textCodCad.setPreferredSize(d);
        d = new Dimension(130, 20);
        this.textCodCad.setMinimumSize(d);
        d = new Dimension(320, 20);
        this.textCadastro.setPreferredSize(d);
        d = new Dimension(320, 20);
        this.textCadastro.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.textEmissao.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.textEmissao.setMinimumSize(d);
        d = new Dimension(150, 20);
        this.textUsuario.setPreferredSize(d);
        d = new Dimension(150, 20);
        this.textUsuario.setMinimumSize(d);
        d = new Dimension(40, 20);
        this.textCodSerie.setPreferredSize(d);
        d = new Dimension(40, 20);
        this.textCodSerie.setMinimumSize(d);
        d = new Dimension(280, 20);
        this.textDescSerie.setPreferredSize(d);
        d = new Dimension(280, 20);
        this.textDescSerie.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.textValor.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.textValor.setMinimumSize(d);
        d = new Dimension(130, 20);
        this.textImpostos.setPreferredSize(d);
        d = new Dimension(130, 20);
        this.textImpostos.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.textTotal.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.textTotal.setMinimumSize(d);
        d = new Dimension(40, 20);
        this.textCodFormaPgto.setPreferredSize(d);
        d = new Dimension(40, 20);
        this.textCodFormaPgto.setMinimumSize(d);
        d = new Dimension(280, 20);
        this.textDescFormaPgto.setPreferredSize(d);
        d = new Dimension(280, 20);
        this.textDescFormaPgto.setMinimumSize(d);
        d = new Dimension(100, 20);
        this.labelTipoCadastro.setPreferredSize(d);
        d = new Dimension(100, 20);
        this.labelTipoCadastro.setMinimumSize(d);
        d = new Dimension(30, 20);
        this.buttonComposicao.setPreferredSize(d);
        d = new Dimension(30, 20);
        this.buttonComposicao.setMinimumSize(d);
        this.buttonComposicao.setMargin(new Insets(1, 1, 1, 1));
        this.buttonComposicao.setToolTipText("Mostrar composi\u00e7\u00e3o dos impostos");
        this.buttonComposicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EstornoCancelamentoNotaFiscalEmpresa.this.notaFiscalBean != null) {
                    DialogComposicao.invocaTela((Window)EstornoCancelamentoNotaFiscalEmpresa.this.getTopLevelAncestor(), EstornoCancelamentoNotaFiscalEmpresa.this.notaFiscalBean);
                }
            }
        });
        d = new Dimension(200, 20);
        this.labelSituacaoNotaImpressa.setPreferredSize(d);
        d = new Dimension(200, 20);
        this.labelSituacaoNotaImpressa.setMinimumSize(d);
        this.labelSituacaoNotaImpressa.setHorizontalAlignment(4);
        d = new Dimension(20, 30);
        this.scrObservacao.setPreferredSize(d);
        this.scrObservacao.setMinimumSize(d);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JScrollPane scrollServicos = new JScrollPane(this.tableServicos);
        scrollServicos.setPreferredSize(new Dimension(200, 120));
        scrollServicos.setMinimumSize(new Dimension(200, 120));
        scrollServicos.setVerticalScrollBarPolicy(20);
        JScrollPane scrollParcelas = new JScrollPane(this.tableParcelas);
        scrollParcelas.setPreferredSize(new Dimension(200, 120));
        scrollParcelas.setMinimumSize(new Dimension(200, 120));
        scrollParcelas.setVerticalScrollBarPolicy(20);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(4, 2, 0, 0);
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelRPS), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textRPS, c);
        c.gridwidth = 1;
        c.gridx += 3;
        this.painelCentral.add(new JPanel().add(new JLabel(" ")), c);
        c.gridx += 2;
        this.painelCentral.add((Component)this.labelNota, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textNota, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(4, 2, 0, 4);
        this.painelCentral.add(new JPanel().add(this.labelSituacaoNotaImpressa), c);
        c.anchor = 17;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(2, 2, 0, 0);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add(new JPanel().add(this.labelTipoCadastroRotulo), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.labelTipoCadastro, c);
        c.gridx += 4;
        c.gridwidth = 1;
        this.painelCentral.add((Component)new JLabel(" "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelCodCad), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textCodCad, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelCadastro), c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textCadastro, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelEmissao), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textEmissao, c);
        c.gridx += 4;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        this.painelCentral.add((Component)new JLabel(" "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelUsuario), c);
        ++c.gridx;
        c.gridwidth = 5;
        c.fill = 2;
        this.painelCentral.add((Component)this.textUsuario, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelSerie), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 0);
        this.painelCentral.add((Component)this.textCodSerie, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 0, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescSerie, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelFormaPgto), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 0);
        this.painelCentral.add((Component)this.textCodFormaPgto, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 0, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescFormaPgto, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelValor), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textValor, c);
        c.gridx += 4;
        c.gridwidth = 1;
        this.painelCentral.add((Component)new JLabel(" "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelImpostos), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 0);
        this.painelCentral.add((Component)this.textImpostos, c);
        ++c.gridx;
        c.insets = new Insets(2, 0, 0, 4);
        this.painelCentral.add((Component)this.buttonComposicao, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        this.painelCentral.add((Component)new JLabel(" "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelTotal), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        this.painelCentral.add((Component)this.textTotal, c);
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelObservacao, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.scrObservacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 12;
        c.fill = 2;
        this.painelCentral.add((Component)this.detalhesImpostos, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 12;
        c.insets = new Insets(2, 2, 0, 4);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel painelInterno = new JPanel();
        painelInterno.setBorder(BorderFactory.createEtchedBorder());
        painelInterno.setLayout(new GridBagLayout());
        this.painelCentral.add((Component)painelInterno, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.3;
        c.weighty = 0.35;
        c.gridwidth = 1;
        c.fill = 1;
        JPanel panelServicos = ComponenteFactory.novoJPanelBorderLayout("Servi\u00e7os", scrollServicos);
        panelServicos.setPreferredSize(new Dimension(200, 200));
        painelInterno.add((Component)panelServicos, c);
        c.gridx += 2;
        c.weightx = 0.65;
        JPanel panelParcelas = ComponenteFactory.novoJPanelBorderLayout("Parcelas", scrollParcelas);
        panelParcelas.setPreferredSize(new Dimension(200, 200));
        painelInterno.add((Component)panelParcelas, c);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        painelInterno.add((Component)this.montaPanelRequisicao(), c);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        Funcoes.montaEnter((JComponent)this.painelCentral);
        this.controlaCampos();
    }

    private JPanel montaPanelRequisicao() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00e3o"));
        GridBagLayout gbl_panelDados = new GridBagLayout();
        panel.setLayout(gbl_panelDados);
        GridBagConstraints gbc_labelRequisicao = new GridBagConstraints();
        gbc_labelRequisicao.insets = new Insets(0, 0, 0, 0);
        gbc_labelRequisicao.anchor = 17;
        gbc_labelRequisicao.gridx = 0;
        gbc_labelRequisicao.gridy = 0;
        panel.add((Component)this.labelRequisicao, gbc_labelRequisicao);
        this.textEmpresa.setMinimumSize(new Dimension(20, 20));
        this.textEmpresa.setPreferredSize(new Dimension(20, 20));
        GridBagConstraints gbc_labelVlrEmpresa = new GridBagConstraints();
        gbc_labelVlrEmpresa.insets = new Insets(0, 0, 0, 0);
        gbc_labelVlrEmpresa.fill = 2;
        gbc_labelVlrEmpresa.anchor = 17;
        gbc_labelVlrEmpresa.gridx = 1;
        gbc_labelVlrEmpresa.gridy = 1;
        gbc_labelVlrEmpresa.gridwidth = 6;
        panel.add((Component)this.textEmpresa, gbc_labelVlrEmpresa);
        this.textRequisicao.setMinimumSize(new Dimension(90, 20));
        this.textRequisicao.setPreferredSize(new Dimension(90, 20));
        GridBagConstraints gbc_labelVlrRequisicao = new GridBagConstraints();
        gbc_labelVlrRequisicao.insets = new Insets(0, 0, 0, 0);
        gbc_labelVlrRequisicao.fill = 2;
        gbc_labelVlrRequisicao.anchor = 17;
        gbc_labelVlrRequisicao.gridx = 1;
        gbc_labelVlrRequisicao.gridy = 0;
        gbc_labelVlrRequisicao.gridwidth = 6;
        panel.add((Component)this.textRequisicao, gbc_labelVlrRequisicao);
        GridBagConstraints gbc_labelEmpresa = new GridBagConstraints();
        gbc_labelEmpresa.insets = new Insets(0, 0, 0, 0);
        gbc_labelEmpresa.anchor = 17;
        gbc_labelEmpresa.gridx = 0;
        gbc_labelEmpresa.gridy = 1;
        panel.add((Component)this.labelEmpresa, gbc_labelEmpresa);
        GridBagConstraints gbc_labelData = new GridBagConstraints();
        gbc_labelData.insets = new Insets(0, 0, 0, 0);
        gbc_labelData.anchor = 17;
        gbc_labelData.gridx = 0;
        gbc_labelData.gridy = 2;
        panel.add((Component)this.labelData, gbc_labelData);
        this.textData.setMinimumSize(new Dimension(90, 20));
        this.textData.setPreferredSize(new Dimension(90, 20));
        GridBagConstraints gbc_labelVlrData = new GridBagConstraints();
        gbc_labelVlrData.insets = new Insets(0, 0, 0, 0);
        gbc_labelVlrData.anchor = 17;
        gbc_labelVlrData.gridx = 1;
        gbc_labelVlrData.gridy = 2;
        panel.add((Component)this.textData, gbc_labelVlrData);
        GridBagConstraints gbc_labelColetador = new GridBagConstraints();
        gbc_labelColetador.insets = new Insets(0, 20, 0, 0);
        gbc_labelColetador.anchor = 17;
        gbc_labelColetador.gridx = 2;
        gbc_labelColetador.gridy = 2;
        panel.add((Component)this.labelColetador, gbc_labelColetador);
        this.textColetador.setMinimumSize(new Dimension(20, 20));
        this.textColetador.setPreferredSize(new Dimension(20, 20));
        GridBagConstraints gbc_labelVlrColetador = new GridBagConstraints();
        gbc_labelVlrColetador.insets = new Insets(0, 0, 0, 0);
        gbc_labelVlrColetador.fill = 2;
        gbc_labelVlrColetador.weightx = 1.0;
        gbc_labelVlrColetador.anchor = 17;
        gbc_labelVlrColetador.gridx = 3;
        gbc_labelVlrColetador.gridy = 2;
        gbc_labelVlrColetador.gridwidth = 4;
        panel.add((Component)this.textColetador, gbc_labelVlrColetador);
        return panel;
    }

    public static long getModuloAcesso() {
        return ACESSO_ACESSAR;
    }

    @Override
    public void novo() {
        this.cancelar();
        this.notaFiscalBean = this.service.pesquisar();
        if (this.notaFiscalBean != null) {
            this.setStatus(2);
            try {
                this.preencherDados(this.service.getDadosRequisicao(this.notaFiscalBean));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados associados \u00e0 nota fiscal.\n" + e.getMessage(), e.getStackTrace());
            }
            this.controlaCampos();
            this.painelCentral.grabFocus();
        }
    }

    @Override
    public void salvar() {
        this.service.cancelarEstornaNF(this.notaFiscalBean, false);
        this.cancelar();
    }

    @Override
    public void cancelar() {
        this.limparCampos();
        this.setStatus(1);
        this.notaFiscalBean = null;
        this.controlaCampos();
    }

    @Override
    public void excluir() {
    }

    @Override
    public void editar() {
        this.service.cancelarEstornaNF(this.notaFiscalBean, true);
        this.cancelar();
    }

    @Override
    public void fechar() {
        this.setVisible(false);
    }

    public void controlaCampos() {
        this.textRPS.setEnabled(false);
        this.textNota.setEnabled(false);
        this.textCadastro.setEnabled(false);
        this.textCodCad.setEnabled(false);
        this.textEmissao.setEnabled(false);
        this.textUsuario.setEnabled(false);
        this.textCodSerie.setEnabled(false);
        this.textDescSerie.setEnabled(false);
        this.textValor.setEnabled(false);
        this.textImpostos.setEnabled(false);
        this.textTotal.setEnabled(false);
        this.textCodFormaPgto.setEnabled(false);
        this.textDescFormaPgto.setEnabled(false);
        this.labelTipoCadastro.setEnabled(false);
        this.textObservacao.setEnabled(false);
        this.scrObservacao.setEnabled(false);
        this.textRequisicao.setEnabled(false);
        this.textEmpresa.setEnabled(false);
        this.textData.setEnabled(false);
        this.textColetador.setEnabled(false);
        this.buttonComposicao.setEnabled(this.getStatus() == 2);
        this.controlaBotoes();
    }

    protected void controlaBotoes() {
        if (this.notaFiscalBean != null) {
            this.botaoCancelar.setEnabled(true);
            this.botaoFechar.setEnabled(true);
            this.botaoNovo.setEnabled(false);
            if (this.notaFiscalBean.getNumeroRps() == null) {
                if (this.notaFiscalBean.getSituacao().equals("I")) {
                    this.botaoEditar.setEnabled(true);
                    this.botaoSalvar.setEnabled(false);
                } else if (this.notaFiscalBean.getSituacao().equals("A")) {
                    this.botaoEditar.setEnabled(false);
                    this.botaoSalvar.setEnabled(true);
                }
            } else {
                this.botaoEditar.setEnabled(true);
                this.botaoSalvar.setEnabled(false);
            }
        } else {
            this.botaoCancelar.setEnabled(false);
            this.botaoEditar.setEnabled(false);
            this.botaoSalvar.setEnabled(false);
            this.botaoFechar.setEnabled(true);
            this.botaoNovo.setEnabled(true);
        }
    }

    private void limparCampos() {
        this.textRPS.clear();
        this.textNota.setText("");
        this.textCadastro.setText("");
        this.textCodCad.setText("");
        this.textEmissao.setText("");
        this.labelSituacaoNotaImpressa.setText("");
        this.textUsuario.setText("");
        this.textCodSerie.setText("");
        this.textDescSerie.setText("");
        this.textValor.setText("");
        this.textImpostos.setText("");
        this.textTotal.setText("");
        this.textCodFormaPgto.setText("");
        this.textDescFormaPgto.setText("");
        this.modeloServicos.clear();
        this.modeloParcelas.clear();
        this.labelTipoCadastro.setText("");
        this.textObservacao.setText("");
        this.detalhesImpostos.setValores(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.textRequisicao.clear();
        this.textEmpresa.clear();
        this.textData.clear();
        this.textColetador.clear();
    }

    @Override
    public boolean validaCampos() {
        return false;
    }

    private void preencherDados(RequisicaoVO requisicao) throws SQLException {
        if (requisicao == null) {
            return;
        }
        PacienteVO empresa = requisicao.getPaciente();
        MedicoVO coletador = requisicao.getMedico();
        String requisicoesMultiguia = this.service.getMultiguiasRequisicao(this.notaFiscalBean.getFilial().getCodigo(), this.notaFiscalBean.getCodigo());
        this.textRequisicao.setText(requisicoesMultiguia);
        this.textEmpresa.setText(empresa.getNome());
        this.textData.setText(Funcoes.formataData(requisicao.getData()));
        this.textColetador.setText(coletador.getConselho() + " " + coletador.getCrm() + " " + coletador.getUf() + " - " + coletador.getNome());
        if (this.notaFiscalBean.getNumero() != null) {
            this.textNota.setText(this.notaFiscalBean.getNumero().toString());
        }
        if (this.notaFiscalBean.getNumeroRps() != null) {
            this.textRPS.setText(this.notaFiscalBean.getNumeroRps().toString());
        }
        String situacao = this.notaFiscalBean.getSituacao().equals("I") ? "Impress\u00e3o: " + Funcoes.formataData("dd/MM/yyyy HH:mm", this.notaFiscalBean.getDataHoraImpressao()) + " por " + this.notaFiscalBean.getUsuarioImpressao().getCodigo() + "." : Tipos.tipoSituacaoNotaFiscal(this.notaFiscalBean.getSituacao(), this.notaFiscalBean.getNumeroRps() != null);
        this.labelSituacaoNotaImpressa.setText(situacao);
        AbstractThreadVO cadastroVO = null;
        if (this.notaFiscalBean.getTipoCadastro().equals("E")) {
            cadastroVO = this.notaFiscalBean.getPaciente();
            this.textCadastro.setText(((PacienteVO)cadastroVO).getNome());
            this.textCodCad.setText(((PacienteVO)cadastroVO).getCodigo().toString());
            this.labelTipoCadastro.setText(Tipos.tipoCadastro("E"));
        } else if (this.notaFiscalBean.getTipoCadastro().equals("O")) {
            cadastroVO = this.notaFiscalBean.getConvenio();
            if (cadastroVO != null) {
                this.textCadastro.setText(((ConvenioVO)cadastroVO).getFantasia());
                this.textCodCad.setText(((ConvenioVO)cadastroVO).getCodigo().toString());
                this.labelTipoCadastro.setText(Tipos.tipoCadastro("O"));
            }
        } else {
            cadastroVO = this.notaFiscalBean.getEntidade();
            if (cadastroVO != null) {
                this.textCadastro.setText(((EntidadeVO)cadastroVO).getFantasia());
                this.textCodCad.setText(((EntidadeVO)cadastroVO).getCodigo().toString());
                this.labelTipoCadastro.setText(Tipos.tipoCadastro(((EntidadeVO)cadastroVO).getTipo()));
            }
        }
        this.textEmissao.setText(Funcoes.formataData("dd/MM/yyyy", this.notaFiscalBean.getDataEmissao()));
        this.textUsuario.setText(this.notaFiscalBean.getUsuario().getDescricao());
        this.textCodSerie.setText(this.notaFiscalBean.getSerie().getCodigo().toString());
        this.textDescSerie.setText(this.notaFiscalBean.getSerie().getDescricao());
        this.textValor.setText(Funcoes.formataDecimal(this.textValor.getMaskDecimal(), this.notaFiscalBean.getSubTotal()));
        this.textImpostos.setText(Funcoes.formataDecimal(this.textImpostos.getMaskDecimal(), this.notaFiscalBean.getCofinsValor() + this.notaFiscalBean.getCsllValor() + this.notaFiscalBean.getInssValor() + this.notaFiscalBean.getIrrfValor() + this.notaFiscalBean.getIssValor() + this.notaFiscalBean.getPisValor()));
        this.textTotal.setText(Funcoes.formataDecimal(this.textTotal.getMaskDecimal(), this.notaFiscalBean.getValor()));
        this.textCodFormaPgto.setText(this.notaFiscalBean.getFormaPagamento().getCodigo().toString());
        this.textDescFormaPgto.setText(this.notaFiscalBean.getFormaPagamento().getDescricao());
        this.textObservacao.setText(this.notaFiscalBean.getObservacao() == null ? "" : this.notaFiscalBean.getObservacao());
        if (this.notaFiscalBean.getServico() != null && this.notaFiscalBean.getServico().getServico() != null) {
            ServicoVO servico = this.notaFiscalBean.getServico().getServico();
            Object[] linha = new Object[4];
            linha[0] = servico.getCodigo();
            linha[1] = servico.getDescricao();
            linha[2] = Funcoes.formataDecimal("0.00", this.notaFiscalBean.getSubTotal());
            this.modeloServicos.addLine(linha);
        }
        if (this.notaFiscalBean.getParcelas() != null) {
            Object[] array = this.notaFiscalBean.getParcelas().toArray();
            for (int i = 0; i < array.length; ++i) {
                Object[] linha = new Object[]{((ReceberPagarBean)array[i]).getParcela(), Funcoes.formataData("dd/MM/yyyy", ((ReceberPagarBean)array[i]).getDataVencimento()), Funcoes.formataDecimal("0.00", ((ReceberPagarBean)array[i]).getValor()), Funcoes.formataDecimal("0.00", ((ReceberPagarBean)array[i]).getValorTotal()), ((ReceberPagarBean)array[i]).getObservacao()};
                this.modeloParcelas.addLine(linha);
            }
        }
        this.detalhesImpostos.setValores(this.notaFiscalBean.getInssValor(), this.notaFiscalBean.getIssValor(), this.notaFiscalBean.getPisValor(), this.notaFiscalBean.getCofinsValor(), this.notaFiscalBean.getCsllValor(), this.notaFiscalBean.getIrrfValor(), this.notaFiscalBean.getInssPercentual(), this.notaFiscalBean.getIssPercentual(), this.notaFiscalBean.getPisPercentual(), this.notaFiscalBean.getCofinsPercentual(), this.notaFiscalBean.getCsllPercentual(), this.notaFiscalBean.getIrrfPercentual());
        this.modeloServicos.ordenarColuna(0);
        this.modeloParcelas.ordenarColuna(0);
    }

    @Override
    public String getRetornoParaPesquisa() {
        return null;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    private class DetalhesImpostos
    extends Detalhes {
        private Double valorInss;
        private Double valorIss;
        private Double valorPis;
        private Double valorCofins;
        private Double valorCsll;
        private Double valorIrrf;
        private Double percInss;
        private Double percIss;
        private Double percPis;
        private Double percCofins;
        private Double percCsll;
        private Double percIrrf;

        public DetalhesImpostos(int situacao) {
            super(situacao);
            this.valorInss = new Double(0.0);
            this.valorIss = new Double(0.0);
            this.valorPis = new Double(0.0);
            this.valorCofins = new Double(0.0);
            this.valorCsll = new Double(0.0);
            this.valorIrrf = new Double(0.0);
            this.percInss = new Double(0.0);
            this.percIss = new Double(0.0);
            this.percPis = new Double(0.0);
            this.percCofins = new Double(0.0);
            this.percCsll = new Double(0.0);
            this.percIrrf = new Double(0.0);
            this.valorInss = new Double(0.0);
            this.valorIss = new Double(0.0);
            this.valorPis = new Double(0.0);
            this.valorCofins = new Double(0.0);
            this.valorCsll = new Double(0.0);
            this.valorIrrf = new Double(0.0);
            this.percInss = new Double(0.0);
            this.percIss = new Double(0.0);
            this.percPis = new Double(0.0);
            this.percCofins = new Double(0.0);
            this.percCsll = new Double(0.0);
            this.percIrrf = new Double(0.0);
            this.setFont(this.getFont().deriveFont(11.0f));
        }

        @Override
        public void montaExpandido() {
            this.setPreferredSize(new Dimension(10, 40));
            super.montaExpandido();
        }

        @Override
        public void montaReduzido() {
            this.setPreferredSize(new Dimension(10, 20));
            super.montaReduzido();
        }

        public void setValores(Double valorInss, Double valorIss, Double valorPis, Double valorCofins, Double valorCsll, Double valorIrrf, Double percInss, Double percIss, Double percPis, Double percCofins, Double percCsll, Double percIrrf) {
            this.valorInss = valorInss;
            this.valorIss = valorIss;
            this.valorPis = valorPis;
            this.valorCofins = valorCofins;
            this.valorCsll = valorCsll;
            this.valorIrrf = valorIrrf;
            this.percInss = percInss;
            this.percIss = percIss;
            this.percPis = percPis;
            this.percCofins = percCofins;
            this.percCsll = percCsll;
            this.percIrrf = percIrrf;
            this.atualizarDados();
        }

        @Override
        protected void atualizarDados() {
            StringBuilder html = new StringBuilder();
            if (this.getSituacao() == 2) {
                this.limpaDados();
                html.append("<html>");
                html.append("<table>");
                html.append("<font size=20>");
                html.append("<tr>");
                html.append("<td><b>Detalhes dos Impostos").append("</b></td>");
                html.append("</tr>");
                html.append("</font>");
                html.append("</table>");
                html.append("</html>");
            } else {
                html.append("<html>");
                html.append("<table>");
                html.append("<font size=20>");
                html.append("<tr>");
                html.append("<td><b>Inss: ").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorInss == null ? "" : Funcoes.formataDecimal("0.00", this.valorInss)).append("</td>");
                html.append("<td width=15>-</td>");
                html.append("<td align=\"right\" width=40>").append(this.percInss == null ? "" : Funcoes.formataDecimal("0.00", this.percInss)).append("%</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Iss: ").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorIss == null ? "" : Funcoes.formataDecimal("0.00", this.valorIss)).append("</td>");
                html.append("<td width=15>-</td>");
                html.append("<td align=\"right\" width=40>").append(this.percIss == null ? "" : Funcoes.formataDecimal("0.00", this.percIss)).append("%</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Pis: ").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorPis == null ? "" : Funcoes.formataDecimal("0.00", this.valorPis)).append("</td>");
                html.append("<td width=15>-</td>");
                html.append("<td align=\"right\" width=40>").append(this.percPis == null ? "" : Funcoes.formataDecimal("0.00", this.percPis)).append("%</td>");
                html.append("</tr>");
                html.append("<tr>");
                html.append("<td><b>Cofins: ").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorCofins == null ? "" : Funcoes.formataDecimal("0.00", this.valorCofins)).append("</td>");
                html.append("<td width=15>-</td>");
                html.append("<td align=\"right\" width=40>").append(this.percCofins == null ? "" : Funcoes.formataDecimal("0.00", this.percCofins)).append("%</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Csll: ").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorCsll == null ? "" : Funcoes.formataDecimal("0.00", this.valorCsll)).append("</td>");
                html.append("<td width=15>-</td>");
                html.append("<td align=\"right\" width=40>").append(this.percCsll == null ? "" : Funcoes.formataDecimal("0.00", this.percCsll)).append("%</td>");
                html.append("<td width=30>-</td>");
                html.append("<td><b>Irrf: ").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorIrrf == null ? "" : Funcoes.formataDecimal("0.00", this.valorIrrf)).append("</td>");
                html.append("<td width=15>-</td>");
                html.append("<td align=\"right\" width=40>").append(this.percIrrf == null ? "" : Funcoes.formataDecimal("0.00", this.percIrrf)).append("%</td>");
                html.append("</tr>");
                html.append("</font>");
                html.append("</table>");
                html.append("</html>");
            }
            this.setDetalhes(html.toString());
            this.repaint();
        }
    }
}

