/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.detalhes.Detalhes;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.DialogNotaFiscalSaida;
import jalis.laboratorio.financeiro.NotaFiscalSaida;
import jalis.laboratorio.financeiro.faturamento.DialogComposicao;
import jalis.laboratorio.financeiro.faturamento.integracao.SistemaEmissaoNFSe;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.IntegracaoEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.RespostaEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.StatusNota;
import jalis.laboratorio.recepcao.util.SolicitarMotivoCancelamento;
import jalis.laboratorio.util.EmailUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.FaturaBean;
import jalis.model.bean.financeiro.FaturaNotaFiscalBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.NotaFiscalServicoBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.dao.financeiro.FaturaDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.ServicoVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.AbstractThreadService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TAvisoLabel;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class EstornoCancelamentoNota
extends FrmPadrao
implements ActionListener,
ThreadFinalizadaListener {
    private static final int TEMPO_TIMER = 10000;
    private Timer timer = null;
    protected JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    protected JButton buttonCancelarNF = ComponenteFactory.novoJButton("Cancelar NF", 'l', this);
    protected JButton buttonEstornarNF = ComponenteFactory.novoJButton("Estornar NF", 'E', this);
    protected JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    protected JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    protected JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this);
    protected JButton buttonOpcoesNfse = ComponenteFactory.novoJButton("Op\u00e7\u00f5es NFSe", 'O', this);
    protected JButton buttonReenviar = ComponenteFactory.novoJButton("Reenviar", 'R', this);
    protected JButton buttonCorrigir = ComponenteFactory.novoJButton("Corrigir", 'G', this);
    protected JButton buttonSincronizar = ComponenteFactory.novoJButton("Sincronizar", 'S', this);
    private JPanel painelCentral = new JPanel(new GridBagLayout());
    private int status;
    private AbstractThreadService service = null;
    protected NotaFiscalBean notaFiscalBean = null;
    Set<NotaFiscalServicoBean> servicos = null;
    Set<ReceberPagarBean> parcelas = null;
    Set<FaturaNotaFiscalBean> faturasNotaFiscal = null;
    AbstractThreadVO cadastroVO = null;
    private JLabel labelNota = new JLabel("N\u00famero:");
    private TTextField textNota = new TTextField(15, 1);
    private JLabel labelRPS = new JLabel("RPS:");
    private TTextField textRPS = new TTextField(8, 1);
    private JLabel labelCadastro = new JLabel("Cadastro:");
    private TTextField textCadastro = new TTextField(150, 3);
    private JLabel labelCodCad = new JLabel("C\u00f3d. Cad.:");
    private TTextField textCodCad = new TTextField(12, 1);
    private JLabel labelTipoCadastroRotulo = new JLabel("Tipo Cadastro:");
    private JLabel labelTipoCadastro = new JLabel("");
    private JLabel labelEmissao = new JLabel("Emiss\u00e3o:");
    private TTextField textEmissao = new TTextField(10, 4);
    private TAvisoLabel labelSituacaoNotaImpressa = new TAvisoLabel();
    private JLabel labelUsuario = new JLabel("Usu\u00e1rio:");
    private TTextField textUsuario = new TTextField(80, 3);
    private JLabel labelSerie = new JLabel("S\u00e9rie:");
    private TTextField textCodSerie = new TTextField(2, 3);
    private TTextField textDescSerie = new TTextField(80, 3);
    private JLabel labelValor = new JLabel("Valor Bruto:");
    private TTextField textValor = new TTextField(18, 2, 2);
    private JLabel labelImpostos = new JLabel("(-) Imp.:");
    private TTextField textImpostos = new TTextField(18, 2, 2);
    private JLabel labelTotal = new JLabel("Valor L\u00edquido:");
    private TTextField textTotal = new TTextField(18, 2, 2);
    private JLabel labelFormaPgto = new JLabel("Forma Pagto.:");
    private TTextField textCodFormaPgto = new TTextField(5, 1);
    private TTextField textDescFormaPgto = new TTextField(40, 3);
    private ModeloGridTable modeloServicos = new ModeloGridTable(new String[]{"C\u00f3d.", "Servi\u00e7o", "Valor"});
    private JTable tableServicos = new JTable(this.modeloServicos);
    private ModeloGridTable modeloParcelas = new ModeloGridTable(new String[]{"Parc.", "Vencto.", "Subtotal", "Total", "Obs."});
    private JTable tableParcelas = new JTable(this.modeloParcelas);
    private ModeloGridTable modeloFaturas = new ModeloGridTable(new String[]{"C\u00f3digo", "Vencto.", "Data In\u00edcio", "Data Fim", "Mensagem", "Subtotal", "Total"});
    private JTable tableFaturas = new JTable(this.modeloFaturas);
    private JButton buttonComposicao = new JButton("...");
    private JTextArea textObservacao = new JTextArea();
    private JLabel labelObservacao = new JLabel("Observa\u00e7\u00e3o");
    private JScrollPane scrObservacao = new JScrollPane(this.textObservacao);
    private JPopupMenu menuOpcoesNfse = new JPopupMenu();
    private JMenuItem itemEnviarEmail = new JMenuItem("Enviar E-mail");
    private JMenuItem itemBaixarXML = new JMenuItem("Baixar XML");
    private JMenuItem itemBaixarPDF = new JMenuItem("Baixar PDF");
    private DetalhesImpostos detalhesImpostos = new DetalhesImpostos(2);
    private boolean isPessoaFisica = false;
    private boolean dadosCarregados = false;
    private boolean isCarregandoDados = false;
    private boolean isApresentarBotaoImprimir = false;
    private boolean acessoEnviarEmail = Acesso.getAcesso(EstornoCancelamentoNota.getAcessoEmail());
    JPanel panelFaturas = null;
    private Integer codigoRequisicao = null;
    private SistemaEmissaoNFSe sistemaEmissaoNFSe = Laboratorio.sistemaEmissorNFSe;

    public EstornoCancelamentoNota() {
        this.buttonImprimir.setVisible(false);
        this.itemEnviarEmail.setVisible(false);
        this.itemBaixarXML.setVisible(false);
        this.itemBaixarPDF.setVisible(false);
        this.buttonReenviar.setVisible(false);
        this.buttonCorrigir.setVisible(false);
        this.buttonSincronizar.setVisible(false);
        this.buttonOpcoesNfse.setVisible(false);
        this.montaTela("Estorno/Cancelamento de Nota Fiscal de Pessoa Jur\u00eddica", "Estorno/Cancelamento de notas fiscais emitidas para pessoa jur\u00eddica", true, true, "financeiro/estorno_cancelamento_nf.jpg", 1.0f, this.buttonNovo, this.buttonCancelarNF, this.buttonEstornarNF, this.buttonImprimir, this.buttonOpcoesNfse, this.buttonReenviar, this.buttonSincronizar, this.buttonCancelar, this.buttonFechar);
    }

    public EstornoCancelamentoNota(String titulo, String descricao, boolean adicionaBotoes, boolean adicionaBarraDescricao, String imagem, float propComps, boolean isApresentarBotaoImprimir) {
        this.montaTela(titulo, descricao, adicionaBotoes, adicionaBarraDescricao, imagem, propComps, this.buttonNovo, this.buttonCancelarNF, this.buttonEstornarNF, this.buttonImprimir, this.buttonOpcoesNfse, this.buttonReenviar, this.buttonSincronizar, this.buttonCorrigir, this.buttonCancelar, this.buttonFechar);
        this.isApresentarBotaoImprimir = isApresentarBotaoImprimir;
    }

    protected void imprimirNotaFiscal() {
        boolean impressaoOk = false;
        try {
            NotaFiscalService serviceNota = new NotaFiscalService();
            impressaoOk = serviceNota.imprimirNotaServico((NotaFiscalVO)this.notaFiscalBean.toVO());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel imprimir a Nota Fiscal.\n" + e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void reenviar() {
        boolean isEletronica;
        boolean bl = isEletronica = this.notaFiscalBean.getSerie().isRelacionarNfse() == false;
        if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.ENOTAS) {
            try {
                IntegracaoEnotas integracaoEnotas = new IntegracaoEnotas(this.notaFiscalBean);
                integracaoEnotas.enviarNotaFiscalEletronica();
                this.labelSituacaoNotaImpressa.setAviso(null);
                this.notaFiscalBean.setSituacao("X");
                this.labelSituacaoNotaImpressa.setText(Tipos.tipoSituacaoNotaFiscal(this.notaFiscalBean.getSituacao(), isEletronica));
                this.timer.start();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private boolean consultarNotaFiscal() {
        boolean isEletronica;
        boolean consultaNota = false;
        boolean bl = isEletronica = this.notaFiscalBean.getSerie().isRelacionarNfse() == false;
        if (this.sistemaEmissaoNFSe.equals((Object)SistemaEmissaoNFSe.ENOTAS)) {
            IntegracaoEnotas integracao = new IntegracaoEnotas(this.notaFiscalBean);
            try {
                this.labelSituacaoNotaImpressa.setAviso(null);
                this.labelSituacaoNotaImpressa.setText(Tipos.tipoSituacaoNotaFiscal(this.notaFiscalBean.getSituacao(), isEletronica));
                this.timer.start();
                if (this.notaFiscalBean.getSituacao().equals("S")) {
                    this.atualizarCancelamentoNFSe(integracao);
                } else {
                    consultaNota = integracao.notaFiscalAutorizada(this.notaFiscalBean.getChaveNfse());
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                return false;
            }
        }
        return consultaNota;
    }

    private void atualizarCancelamentoNFSe(IntegracaoEnotas integracao) throws Exception {
        RespostaEnotas respostaConsulta = integracao.consultarNotaFiscal(this.notaFiscalBean.getChaveNfse());
        String mensagem = "";
        StatusNota sn = StatusNota.fromString(respostaConsulta.getData().getStatus());
        if (sn != null && sn.cancelado()) {
            UsuarioVO usuarioCanc = new UsuarioVO();
            usuarioCanc.setCodigo(Variaveis.login);
            this.notaFiscalBean.setUsuarioCancelada(usuarioCanc);
            this.notaFiscalBean.setDataHoraCancelada(new Date());
            this.notaFiscalBean.setSituacao("C");
            new NotaFiscalService().gravaAutoCopiaSemCommit(this.notaFiscalBean, 1, Variaveis.filialPadrao, null);
            Conexao.arquivaSQL();
            String linkPDF = respostaConsulta.getData().getLinkDownloadPDF();
            new Thread(() -> integracao.atualizarPDF(linkPDF, null)).start();
            String linkXML = respostaConsulta.getData().getLinkDownloadXML();
            new Thread(() -> integracao.atualizarXML(linkXML)).start();
            mensagem = "Nota fiscal n\u00famero: \"" + this.notaFiscalBean.getNumero() + "\" foi cancelada com sucesso.";
        } else {
            mensagem = sn != null && sn.processandoCancelamento() ? "A solicita\u00e7\u00e3o de cancelamento da nota fiscal n\u00famero " + this.notaFiscalBean.getNumero() + " n\u00e3o foi conclu\u00edda no servidor.\nTente consultar novamente em alguns minutos" : " O status da nota fiscal n\u00famero " + this.notaFiscalBean.getNumero() + " foi atualizado para " + respostaConsulta.getData().getStatus() + "\nN\u00e3o foi poss\u00edvel concluir o cancelamento";
        }
        Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 2);
    }

    public boolean corrigirNota() {
        if (this.notaFiscalBean == null) {
            return false;
        }
        DialogNotaFiscalSaida dialogNota = NotaFiscalSaida.novaInstancia(Laboratorio.getInstancia(), this.notaFiscalBean, this.codigoRequisicao, this.isPessoaFisica, null, String.valueOf(this.notaFiscalBean.getFilial().getCodigo()));
        NotaFiscalSaida nota = dialogNota.getNotaFiscalSaida();
        dialogNota.setVisible(true);
        if (nota.getRetorno() != null) {
            this.notaFiscalBean = nota.getRetorno();
            return true;
        }
        return false;
    }

    public void cancelarEstornaNF(boolean cancelaNF) {
        if (Funcoes.mensagem(this, "Voc\u00ea realmente deseja" + (cancelaNF ? " cancelar " : " estornar ") + "a nota fiscal?", 4) == 0) {
            SolicitarMotivoCancelamento telaMotivoCancelamento = new SolicitarMotivoCancelamento(Laboratorio.getInstancia(), "Motivo de Cancelamento", false);
            telaMotivoCancelamento.setVisible(true);
            if (!telaMotivoCancelamento.getOK()) {
                return;
            }
            if (telaMotivoCancelamento == null || telaMotivoCancelamento.getCodigoMotivo() == -1 || telaMotivoCancelamento.getCancelado()) {
                Funcoes.mensagem(this, "O Motivo de Cancelamento da Nota Fiscal n\u00e3o foi selecionado.\nO" + (cancelaNF ? " cancelamento" : " estorno") + " ser\u00e1 abortado.", 2);
                return;
            }
            try {
                CharSequence msg;
                StringBuilder listaCodigos = new StringBuilder();
                for (ReceberPagarBean aux : this.parcelas) {
                    if (aux.getSituacao() == null || aux.getSituacao().equalsIgnoreCase("A")) continue;
                    if (listaCodigos.length() > 0) {
                        listaCodigos.append(", ").append(aux.getCodigo());
                        continue;
                    }
                    listaCodigos.append(aux.getCodigo());
                }
                if (listaCodigos.length() > 0 && !this.notaFiscalBean.getTipo().equals("F")) {
                    msg = new StringBuilder();
                    if (this.notaFiscalBean.getNumeroRps() == null) {
                        if (listaCodigos.length() == 1) {
                            ((StringBuilder)msg).append("O t\u00edtulo: \"").append(listaCodigos.toString()).append("\", filial: ").append(this.notaFiscalBean.getFilial().getCodigo()).append(" n\u00e3o est\u00e1 aberto.\n");
                        } else {
                            ((StringBuilder)msg).append("Os t\u00edtulos: \"").append(listaCodigos.toString()).append("\", filial: ").append(this.notaFiscalBean.getFilial().getCodigo()).append(" n\u00e3o est\u00e3o abertos.\n");
                        }
                        ((StringBuilder)msg).append("N\u00e3o \u00e9 poss\u00edvel ").append(cancelaNF ? "cancelar" : "estornar").append(" a nota fiscal se os t\u00edtulos n\u00e3o estiverem ABERTOS.\n");
                        ((StringBuilder)msg).append("Por favor, verifique.");
                        Funcoes.mensagem(this, ((StringBuilder)msg).toString(), 2);
                        return;
                    }
                    ((StringBuilder)msg).append("A nota fiscal eletr\u00f4nica n\u00e3o poder\u00e1 ser cancelada com erro na gera\u00e7\u00e3o.\n");
                    ((StringBuilder)msg).append("Ser\u00e1 necess\u00e1rio corrigi-la antes de efetuar o seu cancelamento.\n");
                    ((StringBuilder)msg).append("Deseja corrigir a nota fiscal com RPS: " + this.notaFiscalBean.getNumeroRps() + "?");
                    if (Funcoes.mensagem(this, ((StringBuilder)msg).toString(), 4) == 0 && !this.corrigirNota()) {
                        return;
                    }
                }
                msg = null;
                try {
                    SplashMensagem splash = SplashMensagem.getInstancia(this);
                    splash.mostrar("Estornando nota fiscal. Por favor aguarde..");
                    msg = new NotaFiscalService().cancelarEstornaNF(cancelaNF, this.notaFiscalBean, this.parcelas, telaMotivoCancelamento);
                    splash.apagar();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Conexao.anulaSQL();
                }
                if (!Funcoes.textoVazio((String)msg)) {
                    Conexao.arquivaSQL();
                    Funcoes.mensagem(Laboratorio.getInstancia(), (String)msg, 5);
                    this.atualizaSituacao(this.notaFiscalBean);
                } else {
                    Conexao.anulaSQL();
                    Funcoes.mensagem(Laboratorio.getInstancia(), (String)msg, 2);
                }
                this.cancelar(true);
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            }
        }
    }

    public void fechar() {
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.notaFiscalBean != null) {
            if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                this.setVisible(false);
            }
        } else {
            this.setVisible(false);
        }
    }

    public boolean cancelar(boolean pularMensagem) {
        this.limparCampos();
        this.setStatus(1);
        this.notaFiscalBean = null;
        this.controlaCampos();
        this.dadosCarregados = false;
        this.timer.stop();
        return true;
    }

    protected void montaTela(String titulo, String descricao, boolean adicionaBotoes, boolean adicionaBarraDescricao, String imagem, float propComps, Component ... botoes) {
        this.setLayout(new BorderLayout());
        this.add((Component)this.painelCentral, "Center");
        this.service = new NotaFiscalService();
        Funcoes.montaEnter((JComponent)this.painelCentral);
        if (adicionaBotoes) {
            this.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, botoes), "South");
            this.itemEnviarEmail.setVisible(new EmailUtil().podeEnviarEmailNotaFiscal(this.notaFiscalBean == null ? Variaveis.filialPadrao : this.notaFiscalBean.getFilial().getCodigo().toString()));
        }
        if (adicionaBarraDescricao) {
            Funcoes.criaBarraDescricao(this, titulo, descricao, imagem);
        }
        ScreenUtil.setBorda(new Component[]{this.labelTipoCadastro, this.labelSituacaoNotaImpressa}, new TitledBorder(""));
        this.modeloServicos.setColumnSize(new int[]{60, 0, 70}, this.tableServicos);
        this.modeloParcelas.setColumnSize(new int[]{49, 80, 70, 70, 0}, this.tableParcelas);
        this.modeloFaturas.setColumnSize(new int[]{60, 80, 80, 80, 0, 70, 70}, this.tableFaturas);
        this.modeloServicos.ordenarColuna(0);
        this.modeloParcelas.ordenarColuna(0);
        this.modeloFaturas.ordenarColuna(0);
        this.buttonNovo.addActionListener(event -> this.novo("", true));
        this.buttonFechar.addActionListener(event -> {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.fechar();
        });
        this.buttonImprimir.addActionListener(event -> this.imprimirNotaFiscal());
        this.itemEnviarEmail.addActionListener(event -> new Thread(){

            @Override
            public void run() {
                if (!NotaFiscalService.enviarEmailNFSe(EstornoCancelamentoNota.this.notaFiscalBean)) {
                    Funcoes.mensagem(EstornoCancelamentoNota.this, "O envio e-mail de nota fiscal eletr\u00f4nica n\u00e3o est\u00e1 ativado.", 2);
                } else {
                    Funcoes.mensagem(EstornoCancelamentoNota.this, "A NFS-e foi enviada para o email com sucesso.", 2);
                }
            }
        }.start());
        this.buttonReenviar.addActionListener(event -> SwingUtilities.invokeLater(this::reenviar));
        this.buttonSincronizar.addActionListener(event -> SwingUtilities.invokeLater(() -> {
            SplashMensagem splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
            splash.mostrar("Sincronizando nota fiscal. Por favor aguarde..");
            this.consultarNotaFiscal();
            this.preencherCampos(this.notaFiscalBean);
            splash.apagar();
            this.controlaSinconizarCorrigir();
            this.cancelar(true);
        }));
        this.buttonCorrigir.addActionListener(event -> {
            if (this.corrigirNota()) {
                this.preencherCampos(this.notaFiscalBean);
            }
        });
        this.buttonCancelar.addActionListener(event -> {
            this.timer.stop();
            this.cancelar(false);
        });
        this.buttonCancelarNF.addActionListener(event -> this.cancelarEstornaNF(true));
        this.buttonEstornarNF.addActionListener(event -> this.cancelarEstornaNF(false));
        this.textRPS.setPreferredSize(new Dimension((int)(100.0f * propComps), 20));
        this.textRPS.setMinimumSize(new Dimension((int)(100.0f * propComps), 20));
        this.textNota.setPreferredSize(new Dimension((int)(130.0f * propComps), 20));
        this.textNota.setMinimumSize(new Dimension((int)(130.0f * propComps), 20));
        this.textNota.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    EstornoCancelamentoNota.this.novo("", true);
                } else if (e.getKeyCode() == 10 || e.getKeyCode() == 9) {
                    EstornoCancelamentoNota.this.novo(" where nfi_numero = " + EstornoCancelamentoNota.this.textNota.getText() + " and fil_codigo = " + Variaveis.filialPadrao + " ", false);
                }
            }
        });
        this.textCodCad.setPreferredSize(new Dimension((int)(130.0f * propComps), 20));
        this.textCodCad.setMinimumSize(new Dimension((int)(130.0f * propComps), 20));
        this.textCadastro.setPreferredSize(new Dimension((int)(320.0f * propComps), 20));
        this.textCadastro.setMinimumSize(new Dimension((int)(320.0f * propComps), 20));
        this.textEmissao.setPreferredSize(new Dimension((int)(100.0f * propComps), 20));
        this.textEmissao.setMinimumSize(new Dimension((int)(100.0f * propComps), 20));
        this.textUsuario.setPreferredSize(new Dimension((int)(150.0f * propComps), 20));
        this.textUsuario.setMinimumSize(new Dimension((int)(150.0f * propComps), 20));
        this.textCodSerie.setUpperCase(true);
        this.textCodSerie.setPreferredSize(new Dimension((int)(40.0f * propComps), 20));
        this.textCodSerie.setMinimumSize(new Dimension((int)(40.0f * propComps), 20));
        this.textDescSerie.setPreferredSize(new Dimension((int)(280.0f * propComps), 20));
        this.textDescSerie.setMinimumSize(new Dimension((int)(280.0f * propComps), 20));
        this.textValor.setPreferredSize(new Dimension((int)(100.0f * propComps), 20));
        this.textValor.setMinimumSize(new Dimension((int)(100.0f * propComps), 20));
        this.textImpostos.setPreferredSize(new Dimension((int)(130.0f * propComps), 20));
        this.textImpostos.setMinimumSize(new Dimension((int)(130.0f * propComps), 20));
        this.textTotal.setPreferredSize(new Dimension((int)(100.0f * propComps), 20));
        this.textTotal.setMinimumSize(new Dimension((int)(100.0f * propComps), 20));
        this.textCodFormaPgto.setPreferredSize(new Dimension((int)(40.0f * propComps), 20));
        this.textCodFormaPgto.setMinimumSize(new Dimension((int)(40.0f * propComps), 20));
        this.textDescFormaPgto.setPreferredSize(new Dimension((int)(280.0f * propComps), 20));
        this.textDescFormaPgto.setMinimumSize(new Dimension((int)(280.0f * propComps), 20));
        this.labelTipoCadastro.setPreferredSize(new Dimension((int)(100.0f * propComps), 20));
        this.labelTipoCadastro.setMinimumSize(new Dimension((int)(100.0f * propComps), 20));
        this.buttonComposicao.setPreferredSize(new Dimension((int)(30.0f * propComps), 20));
        this.buttonComposicao.setMinimumSize(new Dimension((int)(30.0f * propComps), 20));
        this.buttonComposicao.setMargin(new Insets(1, 1, 1, 1));
        this.buttonComposicao.setToolTipText("Mostrar composi\u00e7\u00e3o dos impostos");
        this.buttonComposicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EstornoCancelamentoNota.this.notaFiscalBean != null) {
                    DialogComposicao.invocaTela((Window)EstornoCancelamentoNota.this.getTopLevelAncestor(), EstornoCancelamentoNota.this.notaFiscalBean);
                }
            }
        });
        this.labelSituacaoNotaImpressa.setPreferredSize(new Dimension(200, 20));
        this.labelSituacaoNotaImpressa.setMinimumSize(new Dimension(200, 20));
        this.labelSituacaoNotaImpressa.setHorizontalAlignment(4);
        this.scrObservacao.setPreferredSize(new Dimension(20, 30));
        this.scrObservacao.setMinimumSize(new Dimension(20, 30));
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JScrollPane scrollServicos = new JScrollPane(this.tableServicos);
        scrollServicos.setPreferredSize(new Dimension((int)(200.0f * propComps), 120));
        scrollServicos.setMinimumSize(new Dimension((int)(200.0f * propComps), 120));
        scrollServicos.setVerticalScrollBarPolicy(20);
        JScrollPane scrollParcelas = new JScrollPane(this.tableParcelas);
        scrollParcelas.setPreferredSize(new Dimension((int)(200.0f * propComps), 120));
        scrollParcelas.setMinimumSize(new Dimension((int)(200.0f * propComps), 120));
        scrollParcelas.setVerticalScrollBarPolicy(20);
        JScrollPane scrollFaturas = new JScrollPane(this.tableFaturas);
        scrollFaturas.setPreferredSize(new Dimension((int)(400.0f * propComps), 120));
        scrollFaturas.setMinimumSize(new Dimension((int)(400.0f * propComps), 120));
        scrollFaturas.setVerticalScrollBarPolicy(20);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(4, 2, 0, 0);
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelRPS), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textRPS, c);
        c.gridwidth = 1;
        c.gridx += 3;
        this.painelCentral.add(new JPanel().add(new JLabel(" ")), c);
        c.gridx += 2;
        this.painelCentral.add((Component)this.labelNota, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.textNota, c);
        ++c.gridx;
        c.gridwidth = 4;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(4, 2, 0, 4);
        this.painelCentral.add(new JPanel().add(this.labelSituacaoNotaImpressa), c);
        c.anchor = 17;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(2, 2, 0, 0);
        c.weightx = 0.0;
        c.gridwidth = 1;
        c.fill = 0;
        this.painelCentral.add(new JPanel().add(this.labelTipoCadastroRotulo), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.labelTipoCadastro, c);
        c.gridx += 4;
        c.gridwidth = 1;
        this.painelCentral.add((Component)new JLabel(" "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelCodCad), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textCodCad, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelCadastro), c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textCadastro, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelEmissao), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textEmissao, c);
        c.gridx += 4;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        this.painelCentral.add((Component)new JLabel(" "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelUsuario), c);
        ++c.gridx;
        c.gridwidth = 5;
        c.fill = 2;
        this.painelCentral.add((Component)this.textUsuario, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelSerie), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 0);
        this.painelCentral.add((Component)this.textCodSerie, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 0, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescSerie, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelFormaPgto), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 0);
        this.painelCentral.add((Component)this.textCodFormaPgto, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 0, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.textDescFormaPgto, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add(new JPanel().add(this.labelValor), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.textValor, c);
        c.gridx += 4;
        c.gridwidth = 1;
        this.painelCentral.add((Component)new JLabel(" "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelImpostos), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 0);
        this.painelCentral.add((Component)this.textImpostos, c);
        ++c.gridx;
        c.insets = new Insets(2, 0, 0, 4);
        this.painelCentral.add((Component)this.buttonComposicao, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        this.painelCentral.add((Component)new JLabel(" "), c);
        ++c.gridx;
        this.painelCentral.add(new JPanel().add(this.labelTotal), c);
        ++c.gridx;
        c.gridwidth = 1;
        c.insets = new Insets(2, 2, 0, 4);
        this.painelCentral.add((Component)this.textTotal, c);
        c.insets = new Insets(2, 2, 0, 0);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelObservacao, c);
        ++c.gridx;
        c.gridwidth = 11;
        c.insets = new Insets(2, 2, 0, 4);
        c.fill = 2;
        this.painelCentral.add((Component)this.scrObservacao, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 12;
        c.fill = 2;
        this.painelCentral.add((Component)this.detalhesImpostos, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 12;
        c.insets = new Insets(2, 2, 0, 4);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel painelInterno = new JPanel();
        painelInterno.setBorder(BorderFactory.createEtchedBorder());
        painelInterno.setLayout(new GridBagLayout());
        this.painelCentral.add((Component)painelInterno, c);
        c.fill = 0;
        c.insets = new Insets(2, 2, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.3;
        c.weighty = 0.35;
        c.gridwidth = 1;
        c.fill = 1;
        JPanel panelServicos = ComponenteFactory.novoJPanelBorderLayout("Servi\u00e7os", scrollServicos);
        panelServicos.setPreferredSize(new Dimension(200, 200));
        painelInterno.add((Component)panelServicos, c);
        c.gridx += 2;
        c.weightx = 0.65;
        JPanel panelParcelas = ComponenteFactory.novoJPanelBorderLayout("Parcelas", scrollParcelas);
        panelParcelas.setPreferredSize(new Dimension(200, 200));
        painelInterno.add((Component)panelParcelas, c);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.5;
        c.fill = 1;
        this.panelFaturas = ComponenteFactory.novoJPanelBorderLayout("Faturas", scrollFaturas);
        this.panelFaturas.setPreferredSize(new Dimension(200, 200));
        painelInterno.add((Component)this.panelFaturas, c);
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.menuOpcoesNfse.add(this.itemEnviarEmail);
        this.menuOpcoesNfse.add(this.itemBaixarXML);
        this.menuOpcoesNfse.add(this.itemBaixarPDF);
        this.itemEnviarEmail.addActionListener(this);
        this.itemBaixarXML.addActionListener(this);
        this.itemBaixarPDF.addActionListener(this);
        this.montaTimer();
        this.controlaCampos();
        this.controlaBotoes();
    }

    public void novo(String where, boolean mostraTelaPesquisa) {
        this.cancelar(false);
        AbstractThreadBean bean = this.pesquisar(where, mostraTelaPesquisa);
        if (bean != null) {
            this.setStatus(2);
            this.preencherCampos((NotaFiscalBean)bean);
            this.controlaCampos();
            this.painelCentral.grabFocus();
        }
    }

    public void novo(String where, boolean mostraTelaPesquisa, boolean pularMensagemCancelamento) {
        this.cancelar(pularMensagemCancelamento);
        AbstractThreadBean bean = this.pesquisar(where, mostraTelaPesquisa);
        if (bean != null) {
            this.setStatus(2);
            this.controlaCampos();
            this.preencherCampos((NotaFiscalBean)bean);
            this.painelCentral.grabFocus();
        }
    }

    public void novo(NotaFiscalBean bean, Integer codigoRequisicao, boolean pularMensagemCancelamento) {
        this.cancelar(pularMensagemCancelamento);
        if (bean != null) {
            this.codigoRequisicao = codigoRequisicao;
            this.notaFiscalBean = bean;
            this.setStatus(2);
            this.controlaCampos();
            this.preencherCampos(bean);
            this.painelCentral.grabFocus();
        }
    }

    public void montaTimer() {
        this.timer = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EstornoCancelamentoNota.this.dadosCarregados) {
                    String situacaoAtual;
                    SplashMensagem splash = SplashMensagem.getInstancia(EstornoCancelamentoNota.this);
                    NotaFiscalBean notaBean = null;
                    try {
                        notaBean = (NotaFiscalBean)new NotaFiscalService().get(Variaveis.filialPadrao, EstornoCancelamentoNota.this.notaFiscalBean.getCodigo().toString());
                        if (notaBean != null) {
                            EstornoCancelamentoNota.this.notaFiscalBean = notaBean;
                        }
                    }
                    catch (Exception ex) {
                        ErrorLogger.mostraMensagem(EstornoCancelamentoNota.this, "N\u00e3o foi poss\u00edvel carregar dados da nota fiscal.\n" + ex.getMessage(), ex.getStackTrace());
                    }
                    String string = situacaoAtual = EstornoCancelamentoNota.this.notaFiscalBean != null && EstornoCancelamentoNota.this.notaFiscalBean.getSituacao() != null ? EstornoCancelamentoNota.this.notaFiscalBean.getSituacao() : "";
                    if (notaBean != null && notaBean.getSituacao() != null && notaBean.getSituacao().equals(situacaoAtual)) {
                        EstornoCancelamentoNota.this.atualizaSituacao(notaBean);
                    }
                }
            }
        });
        this.timer.setRepeats(true);
        this.timer.start();
    }

    private void preencherCampos(NotaFiscalBean bean) {
        this.limparCampos();
        if (bean != null) {
            Object[] linha;
            Object[] array;
            if (bean.getNumero() != null) {
                this.textNota.setText(bean.getNumero().toString());
            }
            if (bean.getNumeroRps() != null) {
                Long rps = bean.getNumeroRps();
                if (bean.getNumeroRps() < 0L) {
                    rps = rps * -1L;
                }
                this.textRPS.setText(String.valueOf(rps));
            }
            this.atualizaSituacao(bean);
            if (bean.getTipoCadastro().equals("P")) {
                this.cadastroVO = bean.getPaciente();
                this.textCadastro.setText(((PacienteVO)this.cadastroVO).getNome());
                this.textCodCad.setText(((PacienteVO)this.cadastroVO).getCodigo().toString());
                this.labelTipoCadastro.setText(Tipos.tipoCadastro("P"));
            } else if (bean.getTipoCadastro().equals("O")) {
                this.cadastroVO = bean.getConvenio();
                if (this.cadastroVO != null) {
                    this.textCadastro.setText(((ConvenioVO)this.cadastroVO).getFantasia());
                    this.textCodCad.setText(((ConvenioVO)this.cadastroVO).getCodigo().toString());
                    this.labelTipoCadastro.setText(Tipos.tipoCadastro("O"));
                }
            } else {
                this.cadastroVO = bean.getEntidade();
                if (this.cadastroVO != null) {
                    this.textCadastro.setText(((EntidadeVO)this.cadastroVO).getFantasia());
                    this.textCodCad.setText(((EntidadeVO)this.cadastroVO).getCodigo().toString());
                    this.labelTipoCadastro.setText(Tipos.tipoCadastro(((EntidadeVO)this.cadastroVO).getTipo()));
                }
            }
            this.textEmissao.setText(Funcoes.formataData("dd/MM/yyyy", bean.getDataEmissao()));
            this.textUsuario.setText(bean.getUsuario().getDescricao());
            this.textCodSerie.setText(bean.getSerie().getCodigo().toString());
            this.textDescSerie.setText(bean.getSerie().getDescricao());
            this.textValor.setText(Funcoes.formataDecimal(this.textValor.getMaskDecimal(), bean.getSubTotal()));
            this.textImpostos.setText(Funcoes.formataDecimal(this.textImpostos.getMaskDecimal(), bean.getCofinsValor() + bean.getCsllValor() + bean.getInssValor() + bean.getIrrfValor() + bean.getPisValor()));
            this.textTotal.setText(Funcoes.formataDecimal(this.textTotal.getMaskDecimal(), bean.getValor()));
            this.textCodFormaPgto.setText(bean.getFormaPagamento().getCodigo().toString());
            this.textDescFormaPgto.setText(bean.getFormaPagamento().getDescricao());
            this.textObservacao.setText(bean.getObservacao() == null ? "" : bean.getObservacao());
            this.notaFiscalBean = bean;
            if (bean.getServico() != null && bean.getServico().getServico() != null) {
                ServicoVO servico = bean.getServico().getServico();
                Object[] linha2 = new Object[4];
                linha2[0] = servico.getCodigo();
                linha2[1] = servico.getDescricao();
                linha2[2] = Funcoes.formataDecimal("0.00", bean.getSubTotal());
                this.modeloServicos.addLine(linha2);
            }
            this.parcelas = bean.getParcelas();
            if (this.parcelas != null) {
                array = this.parcelas.toArray();
                for (int i = 0; i < array.length; ++i) {
                    linha = new Object[]{((ReceberPagarBean)array[i]).getParcela(), Funcoes.formataData("dd/MM/yyyy", ((ReceberPagarBean)array[i]).getDataVencimento()), Funcoes.formataDecimal("0.00", ((ReceberPagarBean)array[i]).getValor()), Funcoes.formataDecimal("0.00", ((ReceberPagarBean)array[i]).getValorTotal()), ((ReceberPagarBean)array[i]).getObservacao()};
                    this.modeloParcelas.addLine(linha);
                }
            }
            this.faturasNotaFiscal = bean.getFaturasNotaFiscal();
            if (this.faturasNotaFiscal != null) {
                array = this.faturasNotaFiscal.toArray();
                for (int i = 0; i < array.length; ++i) {
                    linha = new Object[7];
                    FaturaNotaFiscalBean aux = (FaturaNotaFiscalBean)array[i];
                    FaturaDao dao = new FaturaDao();
                    FaturaBean fat = null;
                    try {
                        fat = (FaturaBean)dao.getBean(aux.getFilial().getCodigo().toString(), aux.getFatura().getCodigo().toString());
                    }
                    catch (ThreadDaoException ex) {
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "EstornoCancelamentoNota:730");
                    }
                    if (fat != null) {
                        linha[0] = fat.getCodigo();
                        linha[1] = Funcoes.formataData("dd/MM/yyyy", fat.getVencimento());
                        linha[2] = Funcoes.formataData("dd/MM/yyyy", fat.getDataInicio());
                        linha[3] = Funcoes.formataData("dd/MM/yyyy", fat.getDataFim());
                        linha[4] = fat.getMensagem();
                        linha[5] = Funcoes.formataDecimal("0.00", fat.getValorTotalExames());
                        BigDecimal valorLiq = BigDecimal.valueOf(fat.getValorTotalExames() == null ? 0.0 : fat.getValorTotalExames());
                        valorLiq = valorLiq.add(BigDecimal.valueOf(fat.getValorTotalMateriais() == null ? 0.0 : fat.getValorTotalMateriais()));
                        valorLiq = valorLiq.add(BigDecimal.valueOf(fat.getValorAdicional() == null ? 0.0 : fat.getValorAdicional()));
                        valorLiq = valorLiq.add(BigDecimal.valueOf(fat.getValorDespCobranca() == null ? 0.0 : fat.getValorDespCobranca()));
                        if (fat.getPercentualDesconto() != null && fat.getPercentualDesconto() > 0.0) {
                            BigDecimal vlExamesMateriais = BigDecimal.valueOf(fat.getValorTotalExames() == null ? 0.0 : fat.getValorTotalExames());
                            vlExamesMateriais = vlExamesMateriais.add(BigDecimal.valueOf(fat.getValorTotalMateriais() == null ? 0.0 : fat.getValorTotalMateriais()));
                            vlExamesMateriais = vlExamesMateriais.multiply(BigDecimal.valueOf(fat.getPercentualDesconto() == null ? 0.0 : fat.getPercentualDesconto()));
                            vlExamesMateriais = vlExamesMateriais.divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP);
                            valorLiq = valorLiq.subtract(vlExamesMateriais);
                        }
                        valorLiq = valorLiq.setScale(2, RoundingMode.HALF_UP);
                        linha[6] = Funcoes.formataDecimal("0.00", valorLiq.doubleValue());
                    }
                    this.modeloFaturas.addLine(linha);
                }
            }
            this.detalhesImpostos.setValores(bean.getInssValor(), bean.getIssValor(), bean.getPisValor(), bean.getCofinsValor(), bean.getCsllValor(), bean.getIrrfValor(), bean.getValorISSRetido(), 0.0, bean.getInssPercentual(), bean.getIssPercentual(), bean.getPisPercentual(), bean.getCofinsPercentual(), bean.getCsllPercentual(), bean.getIrrfPercentual(), bean.getPercentualISSRetido());
            this.modeloServicos.ordenarColuna(0);
            this.modeloParcelas.ordenarColuna(0);
            this.modeloFaturas.ordenarColuna(0);
            this.controlaBotoes();
            this.dadosCarregados = true;
        }
    }

    private void atualizaSituacao(NotaFiscalBean bean) {
        boolean isEletronica;
        boolean bl = isEletronica = bean.getSerie().isRelacionarNfse() == false;
        if (bean.getSituacao().equals("I")) {
            this.labelSituacaoNotaImpressa.setText("Impresso em " + Funcoes.formataData("dd/MM/yyyy HH:mm", bean.getDataHoraImpressao()) + " por " + bean.getUsuarioImpressao().getCodigo() + ".");
        } else {
            this.labelSituacaoNotaImpressa.setText(Tipos.tipoSituacaoNotaFiscal(bean.getSituacao(), isEletronica));
            if (bean.getSituacao().equals("A")) {
                this.labelSituacaoNotaImpressa.setAviso(null);
                this.timer.stop();
            } else if (bean.getSituacao().equalsIgnoreCase("E") || bean.getSituacao().equalsIgnoreCase("R") || bean.getSituacao().equalsIgnoreCase("O")) {
                this.labelSituacaoNotaImpressa.setQuebrarLinha(true);
                this.labelSituacaoNotaImpressa.setAviso(Funcoes.formataData("dd/MM/yyyy HH:mm", bean.getDataStatusNfse()) + " - " + bean.getMotivoNfse(), 1);
                this.timer.stop();
            } else if (bean.getSituacao().equalsIgnoreCase("N")) {
                this.labelSituacaoNotaImpressa.setQuebrarLinha(true);
                this.labelSituacaoNotaImpressa.setAviso(Funcoes.formataData("dd/MM/yyyy HH:mm", bean.getDataStatusNfse()) + " - " + bean.getMotivoCancelamento(), 1);
                this.timer.stop();
            } else {
                this.labelSituacaoNotaImpressa.setAviso(null);
            }
            this.controlaBotoes();
        }
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void controlaCampos() {
        this.textRPS.setEnabled(false);
        this.textNota.setEnabled(false);
        this.textCadastro.setEnabled(false);
        this.textCodCad.setEnabled(false);
        this.textEmissao.setEnabled(false);
        this.textUsuario.setEnabled(false);
        this.textCodSerie.setEnabled(false);
        this.textDescSerie.setEnabled(false);
        this.textValor.setEnabled(false);
        this.textImpostos.setEnabled(false);
        this.textTotal.setEnabled(false);
        this.textCodFormaPgto.setEnabled(false);
        this.textDescFormaPgto.setEnabled(false);
        this.labelTipoCadastro.setEnabled(false);
        this.textObservacao.setEnabled(false);
        this.scrObservacao.setEnabled(false);
        this.buttonComposicao.setEnabled(this.status == 2 && !this.isCarregandoDados);
        this.buttonOpcoesNfse.setEnabled(false);
        this.controlaBotoes();
    }

    protected void controlaBotoes() {
        boolean podeEnviarEmail = new EmailUtil().podeEnviarEmailNotaFiscal(this.notaFiscalBean == null ? Variaveis.filialPadrao : this.notaFiscalBean.getFilial().getCodigo().toString());
        boolean podeBaixarPdf = false;
        boolean podeBaixarXml = false;
        if (this.notaFiscalBean != null) {
            podeBaixarPdf = this.notaFiscalBean.getPdfRps() != null;
            podeBaixarXml = this.notaFiscalBean.getXmlNfse() != null;
            this.buttonEstornarNF.setVisible(!NotaFiscalService.isGerarNotaFiscalEletronica(this.notaFiscalBean.getSerie()));
            this.buttonCancelar.setEnabled(!this.isCarregandoDados);
            this.buttonFechar.setEnabled(!this.isCarregandoDados);
            this.buttonNovo.setEnabled(false);
            if (this.notaFiscalBean.getNumeroRps() == null && this.notaFiscalBean.getSerie().isRelacionarNfse().booleanValue()) {
                this.buttonOpcoesNfse.setVisible(false);
                this.buttonImprimir.setVisible(this.isApresentarBotaoImprimir);
                this.buttonImprimir.setEnabled(true);
                if (this.notaFiscalBean.getSituacao().equals("I")) {
                    this.buttonCancelarNF.setEnabled(!this.isCarregandoDados);
                    this.buttonEstornarNF.setEnabled(false);
                } else if (this.notaFiscalBean.getSituacao().equals("A")) {
                    this.buttonCancelarNF.setEnabled(false);
                    this.buttonEstornarNF.setEnabled(!this.isCarregandoDados);
                }
            } else {
                this.buttonCancelarNF.setEnabled(!this.isCarregandoDados);
                this.buttonEstornarNF.setEnabled(false);
                if (this.notaFiscalBean.getSituacao().equalsIgnoreCase("X") && this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.ENOTAS && !Funcoes.textoVazio(this.notaFiscalBean.getChaveNfse()) && this.notaFiscalBean.getNumero() == null && this.notaFiscalBean.getNumeroRps() == null) {
                    this.buttonReenviar.setVisible(false);
                    this.buttonSincronizar.setVisible(true);
                    this.buttonSincronizar.setText("Atualizar");
                    this.buttonCorrigir.setVisible(!this.buttonSincronizar.isVisible());
                    this.buttonImprimir.setVisible(false);
                    this.buttonOpcoesNfse.setVisible(false);
                } else if (this.notaFiscalBean.getSituacao().equalsIgnoreCase("O") || this.notaFiscalBean.getSituacao().equalsIgnoreCase("X")) {
                    this.buttonReenviar.setVisible(!this.isCarregandoDados && this.sistemaEmissaoNFSe.equals((Object)SistemaEmissaoNFSe.ENOTAS));
                    this.buttonCorrigir.setVisible(!this.buttonSincronizar.isVisible() || !this.buttonImprimir.isVisible());
                    this.buttonImprimir.setVisible(false);
                    this.buttonOpcoesNfse.setVisible(false);
                } else if (this.notaFiscalBean.getSituacao().equalsIgnoreCase("X")) {
                    this.buttonReenviar.setVisible(!this.isCarregandoDados);
                    this.buttonCorrigir.setVisible(!this.buttonSincronizar.isVisible());
                    this.buttonImprimir.setVisible(false);
                    this.buttonOpcoesNfse.setVisible(false);
                } else if (this.notaFiscalBean.getSituacao().equalsIgnoreCase("A")) {
                    this.buttonReenviar.setVisible(false);
                    this.buttonCorrigir.setVisible(!this.buttonImprimir.isVisible());
                    this.buttonSincronizar.setVisible(false);
                    this.buttonImprimir.setVisible(!this.isCarregandoDados && this.isApresentarBotaoImprimir);
                    this.buttonOpcoesNfse.setVisible(!this.isCarregandoDados);
                    this.buttonOpcoesNfse.setEnabled(true);
                } else if (this.notaFiscalBean.getSituacao().equalsIgnoreCase("D") || this.notaFiscalBean.getSituacao().equalsIgnoreCase("R")) {
                    this.buttonImprimir.setVisible(false);
                    this.buttonOpcoesNfse.setVisible(false);
                    this.buttonReenviar.setVisible(false);
                    this.buttonCorrigir.setVisible(!this.buttonSincronizar.isVisible());
                } else if (this.notaFiscalBean.getSituacao().equalsIgnoreCase("E")) {
                    this.buttonReenviar.setVisible(false);
                    this.buttonCorrigir.setVisible(!this.buttonSincronizar.isVisible());
                    this.buttonImprimir.setVisible(false);
                    this.buttonOpcoesNfse.setVisible(false);
                } else if (this.notaFiscalBean.getSituacao().equalsIgnoreCase("S")) {
                    this.buttonCorrigir.setVisible(false);
                    this.buttonImprimir.setVisible(false);
                    this.buttonOpcoesNfse.setVisible(false);
                    this.buttonSincronizar.setVisible(true);
                    this.buttonSincronizar.setText("Atualizar");
                    this.buttonCancelarNF.setEnabled(false);
                }
            }
        } else {
            this.buttonCancelar.setEnabled(false);
            this.buttonCancelarNF.setEnabled(false);
            this.buttonEstornarNF.setEnabled(false);
            this.buttonFechar.setEnabled(!this.isCarregandoDados);
            this.buttonNovo.setEnabled(!this.isCarregandoDados);
            this.buttonReenviar.setVisible(false);
            this.buttonCorrigir.setVisible(!this.buttonSincronizar.isVisible());
            this.buttonImprimir.setVisible(false);
            this.buttonOpcoesNfse.setVisible(false);
            this.buttonSincronizar.setVisible(false);
        }
        this.itemBaixarPDF.setVisible(podeBaixarPdf);
        this.itemBaixarXML.setVisible(podeBaixarXml);
        this.buttonOpcoesNfse.setEnabled(this.notaFiscalBean != null && (podeEnviarEmail || podeBaixarPdf || podeBaixarXml));
    }

    public void limparCampos() {
        this.textRPS.clear();
        this.textNota.setText("");
        this.textCadastro.setText("");
        this.textCodCad.setText("");
        this.textEmissao.setText("");
        this.labelSituacaoNotaImpressa.setText("");
        this.textUsuario.setText("");
        this.textCodSerie.setText("");
        this.textDescSerie.setText("");
        this.textValor.setText("");
        this.textImpostos.setText("");
        this.textTotal.setText("");
        this.textCodFormaPgto.setText("");
        this.textDescFormaPgto.setText("");
        this.modeloServicos.clear();
        this.modeloParcelas.clear();
        this.modeloFaturas.clear();
        this.labelTipoCadastro.setText("");
        this.textObservacao.setText("");
        this.detalhesImpostos.setValores(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    protected boolean validaNF(NotaFiscalBean bean) {
        if (bean.getNumeroRps() != null) {
            if (bean.getSituacao().equals("D") || bean.getSituacao().equals("N")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Gera\u00e7\u00e3o de nota fiscal com erro, verifique as configura\u00e7\u00f5es obrigat\u00f3rias.", 2);
                return false;
            }
        } else {
            if (bean.getSituacao().equals("C")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal j\u00e1 foi \"Cancelada\".", 2);
                return false;
            }
            if (bean.getSituacao().equals("E")) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal j\u00e1 foi \"Estornada\".", 2);
                return false;
            }
        }
        return true;
    }

    protected AbstractThreadBean pesquisar(String where, boolean mostraTelaPesquisa) {
        try {
            AbstractThreadVO vo = null;
            Hashtable retorno = null;
            if (!mostraTelaPesquisa) {
                Set setNF = this.service.loadVO(where);
                Iterator it = setNF.iterator();
                if (it.hasNext()) {
                    vo = (AbstractThreadVO)it.next();
                } else {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "A nota fiscal n\u00e3o foi encontrada.", 2);
                }
                if (vo != null) {
                    this.notaFiscalBean = (NotaFiscalBean)((NotaFiscalService)this.service).get(Variaveis.filialPadrao, ((NotaFiscalVO)vo).getCodigo().toString());
                }
                if (this.notaFiscalBean != null) {
                    if (this.validaNF(this.notaFiscalBean)) {
                        return this.notaFiscalBean;
                    }
                    return null;
                }
                return null;
            }
            retorno = ((NotaFiscalService)this.service).pesquisaEstornoCancelamentoPessoaJuridicaVO(this.getTopLevelAncestor(), "Pesquisando Notas Fiscais", true);
            if (retorno != null) {
                this.notaFiscalBean = (NotaFiscalBean)((NotaFiscalService)this.service).get(Variaveis.filialPadrao, retorno.get("nfi_codigo").toString());
                if (this.notaFiscalBean != null) {
                    if (this.validaNF(this.notaFiscalBean)) {
                        return this.notaFiscalBean;
                    }
                    return null;
                }
                return null;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "EstornoCancelamentoNota:850");
        }
        return null;
    }

    public int getStatus() {
        return this.status;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600200500");
    }

    public static long getAcessoEmail() {
        return Long.parseLong("0600200501");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOpcoesNfse) {
            this.abrirPopupOpcoesNfse();
        } else if (e.getSource() == this.itemBaixarXML) {
            this.baixarXML();
        } else if (e.getSource() == this.itemBaixarPDF) {
            this.baixarPDF();
        }
    }

    private void abrirPopupOpcoesNfse() {
        Point p = this.buttonOpcoesNfse.getLocation();
        p.x = this.buttonOpcoesNfse.getWidth();
        p.y -= 36;
        this.menuOpcoesNfse.show(this.buttonOpcoesNfse, p.x, p.y);
    }

    private void baixarXML() {
        try {
            String caminho;
            byte[] xml = this.getObjetoBD(this.notaFiscalBean.getXmlNfse());
            if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID) {
                String caminho2;
                if (xml != null && (caminho2 = this.getDestinoSalvarArquivo("Arquivo XML", ".xml")) != null) {
                    if (!caminho2.endsWith(".xml")) {
                        caminho2 = caminho2 + ".xml";
                    }
                    if (this.salvarArquivo(caminho2, xml)) {
                        Funcoes.mensagem(this, "O arquivo foi salvo com sucesso.", 5);
                    } else {
                        Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel salvar o arquivo.", 2);
                    }
                }
            } else if (xml != null && (caminho = this.getDestinoSalvarArquivo("Arquivo ZIP", ".zip")) != null) {
                if (!caminho.endsWith(".zip")) {
                    caminho = caminho + ".zip";
                }
                if (this.salvarArquivo(caminho, xml)) {
                    Funcoes.mensagem(this, "O arquivo foi salvo com sucesso.", 5);
                } else {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel salvar o arquivo.", 2);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void baixarPDF() {
        try {
            String caminho;
            byte[] xml = this.getObjetoBD(this.notaFiscalBean.getPdfRps());
            if (xml != null && (caminho = this.getDestinoSalvarArquivo("Arquivo PDF", ".pdf")) != null) {
                if (!caminho.endsWith(".pdf")) {
                    caminho = caminho + ".pdf";
                }
                if (this.salvarArquivo(caminho, xml)) {
                    Funcoes.mensagem(this, "O arquivo foi salvo com sucesso.", 5);
                } else {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel salvar o arquivo.", 2);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar PDF.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean salvarArquivo(String caminho, byte[] dados) {
        File arquivo = new File(caminho);
        FileOutputStream fos = null;
        try {
            arquivo.createNewFile();
            fos = new FileOutputStream(arquivo);
            fos.write(dados, 0, dados.length);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar arquivo.\n" + e.getMessage(), e.getStackTrace());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            arquivo = null;
            System.gc();
        }
    }

    private String getDestinoSalvarArquivo(String descricaoArquivo, String extensaoArquivo) {
        JFileChooser file = ComponenteFactory.novoJFileChooser();
        file.setFileFilter(ComponenteFactory.novoFileFilter(descricaoArquivo, extensaoArquivo));
        if (file.showSaveDialog(this) == 0) {
            return file.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private byte[] getObjetoBD(Long oid) throws SQLException {
        LargeObjectManager lobj = ((PGConnection)Conexao.getConnection()).getLargeObjectAPI();
        LargeObject obj = lobj.open(oid.longValue(), 262144);
        byte[] retorno = new byte[obj.size()];
        obj.read(retorno, 0, obj.size());
        obj.close();
        return retorno;
    }

    private void controlaSinconizarCorrigir() {
        this.buttonSincronizar.setVisible(!this.permitirSincronizar());
        this.buttonCorrigir.setVisible(this.notaFiscalBean.getSituacao().equals("R"));
    }

    private boolean permitirSincronizar() {
        return this.notaFiscalBean.getSituacao().equals("A") || this.notaFiscalBean.getSituacao().equals("C") || this.notaFiscalBean.getSituacao().equals("R");
    }

    public void configurarTelaPessoaFisica() {
        Funcoes.criaBarraDescricao(this, "Impress\u00e3o de Nota Fiscal de Pessoa F\u00edsica", "Impress\u00e3o de notas fiscais de pessoa f\u00edsica", "financeiro/imprimir_nota_fiscal.jpg");
        this.isPessoaFisica = true;
        if (this.panelFaturas != null) {
            this.panelFaturas.setVisible(false);
            if (this.panelFaturas.getParent() != null) {
                this.panelFaturas.getParent().repaint();
            }
        }
        this.buttonNovo.setVisible(false);
        this.buttonCancelar.setVisible(false);
        this.buttonImprimir.setVisible(this.notaFiscalBean.getChaveRpsNfse() != null && this.isApresentarBotaoImprimir);
    }

    public boolean isPessoaFisica() {
        return this.isPessoaFisica;
    }

    public void pararTimer() {
        this.timer.stop();
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.isCarregandoDados = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.isCarregandoDados = false;
        this.controlaCampos();
    }

    private class DetalhesImpostos
    extends Detalhes {
        private Double valorInss;
        private Double valorIss;
        private Double valorPis;
        private Double valorCofins;
        private Double valorCsll;
        private Double valorIrrf;
        private Double valorIssRetido;
        private Double valorOutrasRetencoes;
        private Double percInss;
        private Double percIss;
        private Double percPis;
        private Double percCofins;
        private Double percCsll;
        private Double percIrrf;
        private Double percIssRetido;

        public DetalhesImpostos(int situacao) {
            super(situacao);
            this.valorInss = new Double(0.0);
            this.valorIss = new Double(0.0);
            this.valorPis = new Double(0.0);
            this.valorCofins = new Double(0.0);
            this.valorCsll = new Double(0.0);
            this.valorIrrf = new Double(0.0);
            this.valorIssRetido = new Double(0.0);
            this.valorOutrasRetencoes = new Double(0.0);
            this.percInss = new Double(0.0);
            this.percIss = new Double(0.0);
            this.percPis = new Double(0.0);
            this.percCofins = new Double(0.0);
            this.percCsll = new Double(0.0);
            this.percIrrf = new Double(0.0);
            this.percIssRetido = new Double(0.0);
            this.valorInss = new Double(0.0);
            this.valorIss = new Double(0.0);
            this.valorPis = new Double(0.0);
            this.valorCofins = new Double(0.0);
            this.valorCsll = new Double(0.0);
            this.valorIrrf = new Double(0.0);
            this.valorIssRetido = new Double(0.0);
            this.valorOutrasRetencoes = new Double(0.0);
            this.percInss = new Double(0.0);
            this.percIss = new Double(0.0);
            this.percPis = new Double(0.0);
            this.percCofins = new Double(0.0);
            this.percCsll = new Double(0.0);
            this.percIrrf = new Double(0.0);
            this.percIssRetido = new Double(0.0);
            this.setFont(this.getFont().deriveFont(11.0f));
        }

        @Override
        public void montaExpandido() {
            this.setPreferredSize(new Dimension(10, 40));
            super.montaExpandido();
        }

        @Override
        public void montaReduzido() {
            this.setPreferredSize(new Dimension(10, 20));
            super.montaReduzido();
        }

        public void setValores(Double valorInss, Double valorIss, Double valorPis, Double valorCofins, Double valorCsll, Double valorIrrf, Double valorIssRetido, Double valorOutrasRetencoes, Double percInss, Double percIss, Double percPis, Double percCofins, Double percCsll, Double percIrrf, Double percIssRetido) {
            this.valorInss = valorInss;
            this.valorIss = valorIss;
            this.valorPis = valorPis;
            this.valorCofins = valorCofins;
            this.valorCsll = valorCsll;
            this.valorIrrf = valorIrrf;
            this.valorIssRetido = valorIssRetido;
            this.valorOutrasRetencoes = valorOutrasRetencoes;
            this.percInss = percInss;
            this.percIss = percIss;
            this.percPis = percPis;
            this.percCofins = percCofins;
            this.percCsll = percCsll;
            this.percIrrf = percIrrf;
            this.percIssRetido = percIssRetido;
            this.atualizarDados();
        }

        @Override
        protected void atualizarDados() {
            StringBuilder html = new StringBuilder();
            if (this.getSituacao() == 2) {
                this.limpaDados();
                html.append("<html>");
                html.append("<table>");
                html.append("<font size=20>");
                html.append("<tr>");
                html.append("<td><b>Detalhes dos Impostos").append("</b></td>");
                html.append("</tr>");
                html.append("</font>");
                html.append("</table>");
                html.append("</html>");
            } else {
                html.append("<html>");
                html.append("<table>");
                html.append("<font size=20>");
                html.append("<tr>");
                html.append("<td><b>Inss: ").append("</b></td>");
                html.append("<td align=\"right\" width=40>").append(this.valorInss == null ? "" : Funcoes.formataDecimal("0.00", this.valorInss)).append("</td>");
                html.append("<td width=10>-</td>");
                html.append("<td align=\"right\" width=35>").append(this.percInss == null ? "" : Funcoes.formataDecimal("0.00", this.percInss)).append("%</td>");
                html.append("<td width=20>-</td>");
                html.append("<td><b>Iss: ").append("</b></td>");
                html.append("<td align=\"right\" width=40>").append(this.valorIss == null ? "" : Funcoes.formataDecimal("0.00", this.valorIss)).append("</td>");
                html.append("<td width=10>-</td>");
                html.append("<td align=\"right\" width=35>").append(this.percIss == null ? "" : Funcoes.formataDecimal("0.00", this.percIss)).append("%</td>");
                html.append("<td width=20>-</td>");
                html.append("<td><b>Pis: ").append("</b></td>");
                html.append("<td align=\"right\" width=40>").append(this.valorPis == null ? "" : Funcoes.formataDecimal("0.00", this.valorPis)).append("</td>");
                html.append("<td width=10>-</td>");
                html.append("<td align=\"right\" width=35>").append(this.percPis == null ? "" : Funcoes.formataDecimal("0.00", this.percPis)).append("%</td>");
                html.append("<td width=20>-</td>");
                html.append("<td><b>Iss Ret.: ").append("</b></td>");
                html.append("<td align=\"right\" width=40>").append(this.valorIssRetido == null ? "" : Funcoes.formataDecimal("0.00", this.valorIssRetido)).append("</td>");
                html.append("<td width=10>-</td>");
                html.append("<td align=\"right\" width=35>").append(this.percIssRetido == null ? "" : Funcoes.formataDecimal("0.00", this.percIssRetido)).append("%</td>");
                html.append("</tr>");
                html.append("<tr>");
                html.append("<td><b>Csll: ").append("</b></td>");
                html.append("<td align=\"right\" width=40>").append(this.valorCsll == null ? "" : Funcoes.formataDecimal("0.00", this.valorCsll)).append("</td>");
                html.append("<td width=10>-</td>");
                html.append("<td align=\"right\" width=35>").append(this.percCsll == null ? "" : Funcoes.formataDecimal("0.00", this.percCsll)).append("%</td>");
                html.append("<td width=20>-</td>");
                html.append("<td><b>Irrf: ").append("</b></td>");
                html.append("<td align=\"right\" width=40>").append(this.valorIrrf == null ? "" : Funcoes.formataDecimal("0.00", this.valorIrrf)).append("</td>");
                html.append("<td width=10>-</td>");
                html.append("<td align=\"right\" width=35>").append(this.percIrrf == null ? "" : Funcoes.formataDecimal("0.00", this.percIrrf)).append("%</td>");
                html.append("<td width=20>-</td>");
                html.append("<td><b>Cofins: ").append("</b></td>");
                html.append("<td align=\"right\" width=40>").append(this.valorCofins == null ? "" : Funcoes.formataDecimal("0.00", this.valorCofins)).append("</td>");
                html.append("<td width=10>-</td>");
                html.append("<td align=\"right\" width=35>").append(this.percCofins == null ? "" : Funcoes.formataDecimal("0.00", this.percCofins)).append("%</td>");
                html.append("<td width=20>-</td>");
                html.append("<td><b>Outras Ret.: ").append("</b></td>");
                html.append("<td align=\"right\" width=40>").append(this.valorOutrasRetencoes == null ? "" : Funcoes.formataDecimal("0.00", this.valorOutrasRetencoes)).append("</td>");
                html.append("</tr>");
                html.append("</font>");
                html.append("</table>");
                html.append("</html>");
            }
            this.setDetalhes(html.toString());
            this.repaint();
        }
    }

    class TipoCadastro {
        public String tipo;
        public String nome;

        public TipoCadastro(String tipo, String nome) {
            this.tipo = tipo;
            this.nome = nome;
        }

        public String toString() {
            return this.nome;
        }
    }
}

