/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

class DialogoFiltroGuias
extends JDialog
implements ActionListener {
    private final boolean ACESSO_FILIAL = Acesso.getAcesso(600200411L);
    private static final String SELECIONADO = "selecionado";
    private static final String FILTRO_USUARIO = "ConferenciaGuias.dataFatura";
    private static final String FILTRO_NAO_LISTAR_FATURADAS = "ConferenciaGuias.naoListarFaturadas";
    private static final String FILTRO_NAO_LISTAR_CONFERIDAS = "ConferenciaGuias.naoListarConferidas";
    private final JButton buttonConsultar = ComponenteFactory.novoJButton("Consultar", '\u0000', this);
    private final JButton buttonDesmarcarTodos = ComponenteFactory.novoJButton("Desmarcar Todos", 'D', this);
    private final JButton buttonMarcarTodos = ComponenteFactory.novoJButton("Selecionar Todos", 'S', this);
    private final JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private final JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private final JButton buttonDataIni = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private final JButton buttonDataFin = ComponenteFactory.novoJButton(this, null, new Dimension(20, 20), true);
    private final TTextField textDataIni = new TTextField(0, 4);
    private final TTextField textDataFin = new TTextField(0, 4);
    private final JCheckBox checkDataFatura = new JCheckBox("Filtrar por data de fatura");
    private final JCheckBox checkNaoListarFaturadas = new JCheckBox("N\u00e3o listar faturadas");
    private final JCheckBox checkNaoListarConferidas = new JCheckBox("N\u00e3o listar conferidas");
    private final ModeloResultSet modReq = this.ACESSO_FILIAL ? new ModeloResultSet("Filial", "fil_codigo", "Requisi\u00e7\u00e3o", "req_codigo", "Paciente", "pac_nome", "Data", "req_data", "", "selecionado") : new ModeloResultSet("Requisi\u00e7\u00e3o", "req_codigo", "Paciente", "pac_nome", "Data", "req_data", "", "selecionado");
    private CheckItemFiltro itemColeta;
    private CheckItemFiltro itemDestino;
    private CheckItemFiltro itemConvenio;
    private CheckItemFiltro itemMedico;
    private CheckItemFiltro itemSituacao;
    private CheckItemFiltro itemFilial;
    private CheckItemFiltro itemPaciente;
    private boolean ok;

    public static DialogoFiltroGuias novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new DialogoFiltroGuias((Frame)pai);
        }
        if (pai instanceof Dialog) {
            return new DialogoFiltroGuias((Dialog)pai);
        }
        return null;
    }

    public DialogoFiltroGuias(Frame pai) {
        super(pai, "Sele\u00e7\u00e3o de requisi\u00e7\u00f5es", true);
        this.iniciar();
    }

    public DialogoFiltroGuias(Dialog pai) {
        super(pai, "Sele\u00e7\u00e3o de requisi\u00e7\u00f5es", true);
        this.iniciar();
    }

    public boolean getOk() {
        return this.ok;
    }

    public List<Registro> getRequisicoesSelecionados() {
        ArrayList<Registro> sel = new ArrayList<Registro>();
        for (Registro reg : this.modReq.getRegistros()) {
            if (!reg.getBoolean(SELECIONADO)) continue;
            sel.add(reg);
        }
        return sel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            this.ok = o == this.buttonOK;
            this.dispose();
        } else if (o == this.buttonMarcarTodos || o == this.buttonDesmarcarTodos) {
            boolean marcar = o == this.buttonMarcarTodos;
            for (Registro reg : this.modReq.getRegistros()) {
                reg.setValor(SELECIONADO, marcar);
            }
            this.modReq.fireTableDataChanged();
        } else if (o == this.buttonDataIni) {
            Funcoes.mostraData(this.textDataIni, this.buttonDataIni, (JPanel)this.buttonDataIni.getParent(), true);
        } else if (o == this.buttonDataFin) {
            Funcoes.mostraData(this.textDataFin, this.buttonDataFin, (JPanel)this.buttonDataFin.getParent(), true);
        } else if (o == this.buttonConsultar) {
            this.consultarRequisicoes();
        }
    }

    private void consultarRequisicoes() {
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                this.modReq.limpar();
                ResultSet res = Conexao.executeQuery(st, this.getSelect());
                while (res.next()) {
                    Registro reg = new Registro(res);
                    this.modReq.addRegistro(reg);
                }
                this.modReq.fireTableDataChanged();
                this.modReq.ordenarColunaSemMudarSentido(this.modReq.getColunaOrdenada());
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "DialogoFiltroEntregarResultado (638)");
            }
        }
    }

    private String getSelect() {
        StringBuilder bui = new StringBuilder();
        ParametrosUsuarios.setValor(FILTRO_USUARIO, this.checkDataFatura.isSelected() ? "1" : "0");
        ParametrosUsuarios.setValor(FILTRO_NAO_LISTAR_CONFERIDAS, this.checkNaoListarConferidas.isSelected() ? "1" : "0");
        ParametrosUsuarios.setValor(FILTRO_NAO_LISTAR_FATURADAS, this.checkNaoListarFaturadas.isSelected() ? "1" : "0");
        try {
            bui.append(" select distinct a.req_codigo ");
            bui.append("      ,a.fil_codigo ");
            bui.append("      ,a.req_data ");
            bui.append("      ,a.req_hora ");
            bui.append("      ,b.pac_nome ");
            bui.append("      ,false as ").append(SELECIONADO);
            bui.append("      ,COUNT(fat.fat_codigo) as qtdeFatura ");
            bui.append("  from requisicao a ");
            bui.append("  left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
            bui.append("  left join faturarequisicao fre on a.fil_codigo = fre.fil_kodigo and a.req_codigo = fre.req_codigo ");
            bui.append("  left join fatura fat on fre.fil_codigo = fat.fil_codigo and fre.fat_codigo = fat.fat_codigo and fat.fat_datacancelamento IS NULL ");
            bui.append(" where a.req_excluida = false ");
            if (this.checkNaoListarConferidas.isSelected()) {
                bui.append(" and a.req_dataguiaconferida IS NULL ");
            }
            String campoData = " a.req_data ";
            if (this.checkDataFatura.isSelected()) {
                campoData = " a.req_dtfatura ";
            }
            if (Funcoes.verificaData(this.textDataIni.getText())) {
                bui.append(" and ").append(campoData).append(" >= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", this.textDataIni.getText())).append("' ");
            }
            if (Funcoes.verificaData(this.textDataFin.getText())) {
                bui.append(" and ").append(campoData).append(" <= '");
                bui.append(Funcoes.formataData("MM/dd/yyyy", this.textDataFin.getText())).append("' ");
            }
            if (this.itemFilial.getSelecionados() != null && this.itemFilial.getSelecionados().length > 0) {
                this.addExpressao(bui, " a.fil_codigo ", this.itemFilial, true);
            } else {
                bui.append(" and a.fil_codigo = ").append(Variaveis.filialPadrao);
            }
            if (this.itemColeta.isSelected() && this.itemColeta.getSelecionados() != null && this.itemColeta.getSelecionados().length > 0) {
                this.addExpressao(bui, "a.col_codigo", this.itemColeta, true);
            }
            if (this.itemDestino.isSelected() && this.itemDestino.getSelecionados() != null && this.itemDestino.getSelecionados().length > 0) {
                this.addExpressao(bui, "a.des_codigo", this.itemDestino, true);
            }
            if (this.itemConvenio.isSelected() && this.itemConvenio.getSelecionados() != null && this.itemConvenio.getSelecionados().length > 0) {
                this.addExpressao(bui, "a.con_codigo", this.itemConvenio, false);
            }
            if (this.itemSituacao.isSelected() && this.itemSituacao.getSelecionados() != null && this.itemSituacao.getSelecionados().length > 0) {
                this.addExpressao(bui, "a.sit_codigo", this.itemSituacao, false);
            }
            if (this.itemPaciente.isSelected() && this.itemPaciente.getSelecionadosAvancado() != null && this.itemPaciente.getSelecionadosAvancado().length > 0) {
                this.addExpressao(bui, "a.pac_codigo", this.itemPaciente, false);
            }
            if (this.itemMedico.isSelected() && this.itemMedico.getSelecionadosAvancado() != null && this.itemMedico.getSelecionadosAvancado().length > 0) {
                String[] conselho = this.itemMedico.getSelecionadosAvancado(0);
                String[] crm = this.itemMedico.getSelecionadosAvancado(1);
                String[] uf = this.itemMedico.getSelecionadosAvancado(2);
                if (crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                    bui.append(" and (");
                    for (int i = 0; i < crm.length; ++i) {
                        bui.append(" (a.med_conselho = '");
                        bui.append(conselho[i]);
                        bui.append("' and a.med_crm = '");
                        bui.append(crm[i]);
                        bui.append("' and a.med_uf = '");
                        bui.append(uf[i]);
                        bui.append("') ");
                        if (i >= crm.length - 1) continue;
                        bui.append(" or ");
                    }
                    bui.append(") ");
                }
            }
            bui.append(" group by a.fil_codigo, a.req_codigo, a.req_data, a.req_hora, b.pac_nome, selecionado ");
            if (this.checkNaoListarFaturadas.isSelected()) {
                bui.append(" having COUNT(fat.fat_codigo) = 0 ");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "DialogoFiltroGuias (631)");
        }
        return bui.toString();
    }

    private void addExpressao(StringBuilder bui, String campo, CheckItemFiltro itemFiltro, boolean aspas) {
        if (itemFiltro.isPesquisaAvancada()) {
            if (itemFiltro.getSelecionadosAvancado(0) != null && itemFiltro.getSelecionadosAvancado(0).length > 0) {
                bui.append(" and \n  ");
                bui.append(ImpressaoResultados.getExpressao(campo, itemFiltro.getSelecionadosAvancado(0), aspas));
                bui.append(" ");
            }
        } else if (itemFiltro.getSelecionados() != null && itemFiltro.getSelecionados().length > 0) {
            bui.append(" and \n  ");
            bui.append(ImpressaoResultados.getExpressao(campo, itemFiltro.getSelecionados(), aspas));
            bui.append(" ");
        }
    }

    private void iniciar() {
        this.checkDataFatura.setSelected(ParametrosUsuarios.getValor(FILTRO_USUARIO) != null && ParametrosUsuarios.getValor(FILTRO_USUARIO).equals("1"));
        this.checkNaoListarConferidas.setSelected(ParametrosUsuarios.getValor(FILTRO_NAO_LISTAR_CONFERIDAS) != null && ParametrosUsuarios.getValor(FILTRO_NAO_LISTAR_CONFERIDAS).equals("1"));
        this.checkNaoListarFaturadas.setSelected(ParametrosUsuarios.getValor(FILTRO_NAO_LISTAR_FATURADAS) != null && ParametrosUsuarios.getValor(FILTRO_NAO_LISTAR_FATURADAS).equals("1"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelAux = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)panelAux, "South");
        panelAux.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonMarcarTodos, this.buttonDesmarcarTodos), "West");
        panelAux.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar), "East");
        panelAux = ComponenteFactory.novoJPanel(new BorderLayout(), BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.getContentPane().add((Component)panelAux, "Center");
        this.modReq.setColunaEditavel(SELECIONADO);
        JTable table = this.ACESSO_FILIAL ? ComponenteFactory.novoJTable((TableModel)this.modReq, 40, 75, 0, 85, 25) : ComponenteFactory.novoJTable((TableModel)this.modReq, 75, 0, 85, 25);
        table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String valor = "";
                if (value != null) {
                    valor = column == (DialogoFiltroGuias.this.ACESSO_FILIAL ? 3 : 2) ? Funcoes.formataData("dd/MM/yyyy", Funcoes.stringToDate("yyyy/MM/dd", value.toString())) : value.toString();
                }
                this.setValue(valor);
                return this;
            }
        });
        JScrollPane scroll = new JScrollPane(table);
        scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, 250));
        panelAux.add((Component)scroll, "Center");
        this.itemFilial = new CheckItemFiltro("Filial", "Filtrar", "Filtrando filiais", null);
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        this.itemColeta = new CheckItemFiltro("Coleta", "Filtrar", "Filtrando coletas", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemColeta.setDados("coletas", new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemColeta.setColunaHint(1);
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemDestino = new CheckItemFiltro("Destino", "Filtrar", "Filtrando destinos", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemDestino.setDados("destino", new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemDestino.setColunaHint(1);
        this.itemMedico = new CheckItemFiltro("M\u00e9dicos", "Filtrar", "Filtrando m\u00e9dicos", "fil_codigo = " + Variaveis.filialPadrao, true);
        this.itemMedico.setDados("medico", new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "C\u00f3digo", "UF", "Descri\u00e7\u00e3o"}, new int[]{70, 70, 30, 0}, 1, false, true, false);
        this.itemMedico.setColunaHint(1);
        this.itemSituacao = new CheckItemFiltro("Situa\u00e7\u00e3o", "Filtrar", "Filtrando situa\u00e7\u00f5es", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemSituacao.setDados("situacao", new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.itemSituacao.setColunaHint(1);
        this.itemPaciente = new CheckItemFiltro("Paciente", "Filtrar", "Filtrando pacientes", "fil_codigo = " + Variaveis.filialPadrao, true);
        this.itemPaciente.setDados("paciente", new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, 1, false, true, false);
        this.itemPaciente.setColunaHint(1);
        panelAux = ComponenteFactory.novoJPanel(new GridBagLayout(), BorderFactory.createTitledBorder("Filtros"));
        this.getContentPane().add((Component)panelAux, "North");
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.insets = new Insets(1, 1, 1, 10);
        cons.gridwidth = 1;
        cons.gridheight = 1;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridx = 0;
        cons.gridy = 0;
        if (this.ACESSO_FILIAL) {
            panelAux.add((Component)this.itemFilial, cons);
        } else {
            panelAux.add((Component)this.itemPaciente, cons);
        }
        ++cons.gridy;
        panelAux.add((Component)this.itemColeta, cons);
        ++cons.gridy;
        panelAux.add((Component)this.itemConvenio, cons);
        ++cons.gridy;
        panelAux.add((Component)this.itemDestino, cons);
        ++cons.gridy;
        panelAux.add((Component)this.itemMedico, cons);
        cons.gridy = 0;
        ++cons.gridx;
        panelAux.add((Component)this.itemSituacao, cons);
        if (this.ACESSO_FILIAL) {
            ++cons.gridy;
            panelAux.add((Component)this.itemPaciente, cons);
        }
        ++cons.gridy;
        panelAux.add((Component)this.checkDataFatura, cons);
        ++cons.gridy;
        panelAux.add((Component)this.checkNaoListarConferidas, cons);
        ++cons.gridy;
        panelAux.add((Component)this.checkNaoListarFaturadas, cons);
        cons.gridy = 0;
        ++cons.gridx;
        int x = cons.gridx++;
        cons.gridwidth = 1;
        cons.insets = new Insets(1, 1, 1, 1);
        panelAux.add((Component)new JLabel("Data Inicial:"), cons);
        this.textDataIni.setPreferredSize(new Dimension(90, 20));
        this.textDataIni.setMinimumSize(new Dimension(90, 20));
        panelAux.add((Component)this.textDataIni, cons);
        cons.insets = new Insets(1, 0, 1, 0);
        this.buttonDataIni.setFocusable(false);
        ++cons.gridx;
        panelAux.add((Component)this.buttonDataIni, cons);
        ++cons.gridy;
        cons.gridx = x;
        panelAux.add((Component)new JLabel("Data Final:"), cons);
        this.textDataFin.setPreferredSize(new Dimension(90, 20));
        this.textDataFin.setMinimumSize(new Dimension(90, 20));
        ++cons.gridx;
        panelAux.add((Component)this.textDataFin, cons);
        ++cons.gridx;
        panelAux.add((Component)this.buttonDataFin, cons);
        cons.gridwidth = 2;
        cons.gridy += 3;
        cons.gridx = x + 1;
        cons.insets = new Insets(0, 0, 0, 0);
        JPanel panel = new JPanel(new FlowLayout(2, 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 1));
        panel.add(this.buttonConsultar);
        panelAux.add((Component)panel, cons);
        Funcoes.montaEnter((JComponent)this.getContentPane());
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(113, 0, true), "F2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogoFiltroGuias.this.textDataIni.hasFocus()) {
                    Funcoes.mostraData(DialogoFiltroGuias.this.textDataIni, DialogoFiltroGuias.this.buttonDataIni, (JPanel)DialogoFiltroGuias.this.buttonDataIni.getParent(), true);
                } else if (DialogoFiltroGuias.this.textDataFin.hasFocus()) {
                    Funcoes.mostraData(DialogoFiltroGuias.this.textDataFin, DialogoFiltroGuias.this.buttonDataFin, (JPanel)DialogoFiltroGuias.this.buttonDataFin.getParent(), true);
                }
            }
        });
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        table.getTableHeader().addMouseListener(this.modReq);
        this.modReq.setOrdenarColunas(true);
        this.modReq.ordenarColuna(0, 1);
    }
}

