/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

class DialogVencimentoFatura
extends JDialog
implements ActionListener,
KeyListener {
    JLabel labelMensagem = new JLabel("Vencimento da fatura:");
    TTextField textData = new TTextField(10, 4);
    JButton buttonData = new JButton();
    JButton buttonOk = new JButton("OK");
    JButton buttonCancelar = new JButton("Cancelar");
    JPanel panelCentral = new JPanel(new GridBagLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private Date vencimento = null;
    private boolean ok = false;

    public DialogVencimentoFatura(Window owner, Date vencimento) {
        super(owner, "Informe o vencimento");
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        if (vencimento != null) {
            this.textData.setText(Funcoes.formataData("dd/MM/yyyy", vencimento));
        }
        this.labelMensagem.setDisplayedMnemonic('V');
        this.labelMensagem.setLabelFor(this.textData);
        this.buttonOk.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.textData.setPreferredSize(new Dimension(100, 20));
        this.textData.setMinimumSize(new Dimension(100, 20));
        this.buttonData.setPreferredSize(new Dimension(20, 20));
        this.buttonData.setMinimumSize(new Dimension(20, 20));
        this.buttonData.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonData);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.panelCentral, "Center");
        panel.add((Component)this.panelBotoes, "South");
        this.panelCentral.setBorder(ScreenUtil.criarBordaVazia());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.insets = new Insets(1, 1, 1, 0);
        c.gridx = 0;
        this.panelCentral.add((Component)this.labelMensagem, c);
        ++c.gridx;
        this.panelCentral.add((Component)this.textData, c);
        ++c.gridx;
        c.insets = new Insets(1, 0, 1, 0);
        this.panelCentral.add((Component)this.buttonData, c);
        this.panelBotoes.add(this.buttonOk);
        this.panelBotoes.add(this.buttonCancelar);
        this.buttonOk.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.buttonData.addActionListener(this);
        this.textData.addKeyListener(this);
        Funcoes.montaEnter((JComponent)panel);
        this.pack();
    }

    public Date getVencimento() {
        return this.vencimento;
    }

    public boolean getOK() {
        return this.ok;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.ok = false;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonOk) {
            if (Funcoes.textoVazio(this.textData)) {
                Funcoes.mensagem(this, "A data de vencimento deve ser informada.", 2);
                return;
            }
            Calendar calAtual = Calendar.getInstance();
            calAtual.setTime(new Date());
            calAtual.set(11, 0);
            calAtual.set(12, 0);
            calAtual.set(13, 0);
            calAtual.set(14, 0);
            if (calAtual.getTime().compareTo(Funcoes.getData("dd/MM/yyyy", this.textData.getText())) > 0) {
                Funcoes.mensagem(this, "A data de vencimento n\u00e3o pode ser inferior \u00e0 data atual.", 2);
                return;
            }
            this.vencimento = Funcoes.getData("dd/MM/yyyy", this.textData.getText());
            this.ok = true;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonData) {
            Funcoes.mostraData(this.textData, this.buttonData, this.panelCentral, true);
        }
    }

    @Override
    @Deprecated
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getSource() == this.textData && e.getKeyCode() == 113) {
            Funcoes.mostraData(this.textData, this.buttonData, this.panelCentral, true);
        }
    }

    @Override
    @Deprecated
    public void keyReleased(KeyEvent e) {
    }
}

