/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

class DialogNotas
extends JDialog
implements ActionListener {
    private static final int COLUNA_FILIAL = 0;
    private static final int COLUNA_FATURA = 1;
    private static final int COLUNA_DATA_FATURA = 2;
    private static final int COLUNA_REQUISICAO = 3;
    private static final int COLUNA_EXAMES = 4;
    private static final int COLUNA_SELECAO = 5;
    private boolean flagAlteracao = false;
    private boolean ok = false;
    private Integer codigoFatura = null;
    private Integer codigoRequisicao = null;
    private ModeloGridTable modelExames = new ModeloGridTable(new String[]{"Filial", "Fatura", "Data Fatura", "Requisi\u00e7\u00e3o", "Exames", "Sel."}){

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 5) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 5;
        }
    };
    private JTable tableExames = null;
    private JScrollPane scrollExames = null;
    private JPanel panelNotas = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonOk = ComponenteFactory.novoJButton("Ok", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private String nota = null;

    public DialogNotas(Dialog owner, String nota) {
        super(owner);
        this.nota = nota;
        this.montaTela();
    }

    public boolean getOk() {
        return this.ok;
    }

    public DialogNotas(Frame owner, String nota) {
        super(owner);
        this.nota = nota;
        this.montaTela();
    }

    private void montaTela() {
        this.setModal(true);
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        this.setTitle("Escolha a nota a ser auditada");
        this.panelNotas.setBorder(new TitledBorder("Notas encontradas"));
        panel.add((Component)this.panelNotas, "Center");
        panel.add((Component)this.panelBotoes, "South");
        this.panelBotoes.add(this.buttonOk);
        this.panelBotoes.add(this.buttonCancelar);
        this.tableExames = new JTable(this.modelExames);
        this.scrollExames = new JScrollPane(this.tableExames);
        this.modelExames.setColumnSize(new int[]{50, 60, 90, 85, 0, 25}, this.tableExames);
        this.tableExames.getTableHeader().addMouseListener(this.modelExames);
        this.panelNotas.add((Component)this.scrollExames, "Center");
        this.setResizable(false);
        this.setSize(600, 250);
        ScreenUtil.centralizar(this);
        this.modelExames.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                boolean valor;
                int row;
                if (DialogNotas.this.flagAlteracao) {
                    return;
                }
                if (e.getColumn() == 5 && (row = DialogNotas.this.tableExames.getSelectedRow()) >= 0 && (valor = ((Boolean)DialogNotas.this.modelExames.getValueAt(row, 5)).booleanValue())) {
                    for (int i = 0; i < DialogNotas.this.modelExames.getRowCount(); ++i) {
                        if (i == row) continue;
                        DialogNotas.this.flagAlteracao = true;
                        DialogNotas.this.modelExames.setValueAt(false, i, 5);
                        DialogNotas.this.flagAlteracao = false;
                    }
                }
            }
        });
        this.preencheDados();
    }

    private void preencheDados() {
        if (this.nota == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select fat.fil_codigo ");
        buf.append("       ,fat.fat_codigo ");
        buf.append("       ,fat.fat_dtemis ");
        buf.append("       ,fer.req_codigo ");
        buf.append("       ,array_to_string(array_agg(distinct fer.exa_codigo), ', ') as exames ");
        buf.append("   from faturaexamerequisicao fer ");
        buf.append("   join fatura fat on fer.fil_codigo = fat.fil_codigo and fer.fat_codigo = fat.fat_codigo ");
        buf.append("   join requisicao req on fer.fil_kodigo = req.fil_codigo and fer.req_codigo = req.req_codigo ");
        buf.append("   join examerequisicao exr on fer.fil_kodigo = exr.fil_codigo and fer.req_codigo = exr.req_codigo and fer.exa_codigo = exr.exa_codigo and fer.mco_codigo = exr.mco_codigo ");
        buf.append("  where fer.fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("    and fer.fer_notaipergs = ").append(this.nota);
        buf.append("    and req.req_excluida = false ");
        buf.append("    and exr.exr_excluido = false ");
        buf.append("    and fat.fat_datacancelamento is null ");
        buf.append("  group by fat.fil_codigo ");
        buf.append("          ,fat.fat_codigo ");
        buf.append("          ,fat.fat_dtemis ");
        buf.append("          ,fer.req_codigo ");
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            while (rs.next()) {
                this.modelExames.addLine(new Object[]{rs.getInt("fil_codigo"), rs.getInt("fat_codigo"), Funcoes.formataData("dd/MM/yyyy", rs.getDate("fat_dtemis")), rs.getInt("req_codigo"), rs.getString("exames"), false});
            }
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(this.getOwner(), "N\u00e3o foi poss\u00edvel buscar os dados das notas.\n" + sqle.getMessage(), sqle.getStackTrace());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOk) {
            for (int i = 0; i < this.modelExames.getRowCount(); ++i) {
                this.ok = (Boolean)this.modelExames.getValueAt(i, 5);
                if (!this.ok) continue;
                this.codigoFatura = Integer.parseInt(this.modelExames.getValueAt(i, 1).toString());
                this.codigoRequisicao = Integer.parseInt(this.modelExames.getValueAt(i, 3).toString());
                this.setVisible(false);
                return;
            }
            Funcoes.mensagem(this.getOwner(), "Selecione uma nota.", 2);
        } else if (e.getSource() == this.buttonCancelar) {
            this.setVisible(false);
        }
    }

    public Integer getCodigoFatura() {
        return this.codigoFatura;
    }

    public Integer getCodigoRequisicao() {
        return this.codigoRequisicao;
    }
}

