/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.service.financeiro.NotaFiscalService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class DialogComposicao
extends AbstractDialogoOKCancelar {
    private JTable tabelaNotas = new JTable();
    private JScrollPane scroll;

    public static void invocaTela(Window pai, NotaFiscalBean bean) {
        if (pai instanceof Frame) {
            new DialogComposicao((Frame)pai, bean);
        } else if (pai instanceof Dialog) {
            new DialogComposicao((Dialog)pai, bean);
        }
    }

    private DialogComposicao(Frame pai, NotaFiscalBean bean) {
        super(pai, "Composi\u00e7\u00e3o da Nota Fiscal");
        this.montaTela(bean);
    }

    private DialogComposicao(Dialog pai, NotaFiscalBean bean) {
        super(pai, "Composi\u00e7\u00e3o da Nota Fiscal");
        this.montaTela(bean);
    }

    private void montaTela(NotaFiscalBean bean) {
        if (bean == null) {
            return;
        }
        ArrayList<NotaFiscalVO> composicao = new NotaFiscalService().getComposicaoImpostosNota(bean);
        DefaultTableModel model = new DefaultTableModel(new Object[0][], new String[]{"N\u00famero", "S\u00e9rie", "Subtotal"}){

            public Class getColumnClass(int column) {
                Class returnValue = Object.class;
                if (this.getRowCount() > 0 && column >= 0 && column < this.getColumnCount() && this.getValueAt(0, column) != null) {
                    returnValue = this.getValueAt(0, column).getClass();
                }
                return returnValue;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tabelaNotas.setModel(model);
        this.tabelaNotas.getColumnModel().getColumn(0).setMinWidth(130);
        this.tabelaNotas.getColumnModel().getColumn(0).setMaxWidth(130);
        this.tabelaNotas.getColumnModel().getColumn(0).setPreferredWidth(130);
        this.tabelaNotas.getColumnModel().getColumn(1).setMinWidth(60);
        this.tabelaNotas.getColumnModel().getColumn(1).setMaxWidth(60);
        this.tabelaNotas.getColumnModel().getColumn(1).setPreferredWidth(60);
        this.tabelaNotas.getColumnModel().getColumn(2).setMinWidth(120);
        this.tabelaNotas.getColumnModel().getColumn(2).setMaxWidth(120);
        this.tabelaNotas.getColumnModel().getColumn(2).setPreferredWidth(120);
        TableRowSorter<TableModel> sorterTitulos = new TableRowSorter<TableModel>(this.tabelaNotas.getModel());
        this.tabelaNotas.setRowSorter(sorterTitulos);
        for (NotaFiscalVO aux : composicao) {
            Object[] linha = new Object[]{aux.getNumero(), aux.getSerie().getCodigo(), Funcoes.formataDecimal(aux.getSubTotal())};
            model.addRow(linha);
        }
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 18;
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.scroll = new JScrollPane(this.tabelaNotas);
        panel.add((Component)this.scroll, c);
        Funcoes.montaEnter((JComponent)panel);
        this.getBotaoCancelar().setVisible(false);
        this.pack();
        this.setResizable(false);
        this.setSize(300, 200);
        ScreenUtil.centralizar(this);
        this.setVisible(true);
    }
}

