/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Tipos;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class DialogAssociacoes
extends AbstractDialogoOKCancelar {
    private static final int COLUNA_RPS = 0;
    private static final int COLUNA_SERIE = 1;
    private static final int COLUNA_NUMERO = 2;
    private static final int COLUNA_VALOR_BRUTO = 3;
    private static final int COLUNA_VALOR_LIQUIDO = 4;
    private static final int COLUNA_EMISSAO = 5;
    private static final int COLUNA_SITUACAO = 6;
    private static final int COLUNA_DESCRICAO = 7;
    private JTable tabela = new JTable();
    private JScrollPane scroll = null;
    ModeloGridTable modelo = null;
    private ArrayList<NotaFiscalBean> lista = null;

    public static void invocaTela(Window pai, ArrayList<NotaFiscalBean> lista) {
        if (pai instanceof Frame) {
            new DialogAssociacoes((Frame)pai, lista);
        } else if (pai instanceof Dialog) {
            new DialogAssociacoes((Dialog)pai, lista);
        }
    }

    private DialogAssociacoes(Frame pai, ArrayList<NotaFiscalBean> lista) {
        super(pai, "Notas Associadas");
        this.lista = lista;
        this.montaTela();
        this.carregaDados();
        this.setVisible(true);
    }

    private DialogAssociacoes(Dialog pai, ArrayList<NotaFiscalBean> lista) {
        super(pai, "Notas Associadas");
        this.lista = lista;
        this.montaTela();
        this.carregaDados();
        this.setVisible(true);
    }

    public void montaTela() {
        this.setTitle("Notas Associadas");
        this.modelo = new ModeloGridTable(new String[]{"RPS", "S\u00e9r.", "N\u00famero", "Vl. Bruto", "Vl. L\u00edquido", "Emiss\u00e3o", "Situa\u00e7\u00e3o", "Descri\u00e7\u00e3o"});
        this.tabela.setModel(this.modelo);
        this.scroll = new JScrollPane(this.tabela);
        this.modelo.setColumnSize(new int[]{60, 40, 70, 80, 80, 90, 80, 0}, this.tabela);
        this.tabela.getTableHeader().addMouseListener(this.modelo);
        this.getBotaoCancelar().setVisible(false);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)this.scroll, "Center");
        this.setResizable(false);
        this.setSize(700, 250);
        ScreenUtil.centralizar(this);
    }

    private void carregaDados() {
        if (this.lista == null) {
            return;
        }
        for (NotaFiscalBean nota : this.lista) {
            this.modelo.addLine(new Object[]{nota.getNumeroRps(), nota.getSerie().getCodigo(), nota.getNumero(), Funcoes.formataDecimal(nota.getValor()), Funcoes.formataDecimal(nota.getValorLiquido().doubleValue()), Funcoes.formataData("dd/MM/yyyy", nota.getDataEmissao()), Tipos.tipoSituacaoNotaFiscal(nota.getSituacao(), nota.getNumeroRps() != null), nota.getMotivoNfse()});
        }
        this.modelo.ordenarColuna(2);
    }
}

