/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.dados.DadosMaterialUtilizado;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DadosMaterialFaturamento;
import jalis.comum.detalhes.DetalhesExpandidoListener;
import jalis.comum.detalhes.DetalhesRequisicaoFatura;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.comum.padroes.FrmCadPadraoBean;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.financeiro.faturamento.AlteraGuiasFaturamento;
import jalis.laboratorio.financeiro.faturamento.AlterarGuiaMatricula;
import jalis.laboratorio.financeiro.faturamento.DialogoFiltroGuias;
import jalis.laboratorio.financeiro.faturamento.RenderExames;
import jalis.laboratorio.financeiro.faturamento.RenderRequisicoes;
import jalis.laboratorio.financeiro.faturamento.SelecionarExamesConferenciaGuias;
import jalis.laboratorio.recepcao.AutorizacaoExame;
import jalis.laboratorio.recepcao.Requisicao;
import jalis.laboratorio.recepcao.util.PedirTitular;
import jalis.laboratorio.recepcao.util.PedirToken;
import jalis.laboratorio.recepcao.util.SolicitarValidadeGuia;
import jalis.laboratorio.resultados.DialogoResultadosAnteriores;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.faturamento.Calculos;
import jalis.laboratorio.util.faturamento.EditorDadosFaturamento;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.model.AbstractThreadBean;
import jalis.service.financeiro.ConferenciaGuiasService;
import jalis.util.ArraysUtil;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConferenciaGuias
extends FrmCadPadraoBean
implements ActionListener,
ListSelectionListener,
DetalhesExpandidoListener,
ThreadFinalizadaListener {
    private final long CODIGO_ACESSO_VALORES = 600200406L;
    private final boolean ACESSO_TITULAR = Acesso.getAcesso(600200401L);
    private final boolean ACESSO_DEVE_GUIA = Acesso.getAcesso(600200402L);
    private final boolean ACESSO_APENAS_FATURAMENTO = Acesso.getAcesso(600200403L);
    private final boolean ACESSO_NAO_FATURAR = Acesso.getAcesso(600200404L);
    private final boolean ACESSO_AUTORIZACAO = Acesso.getAcesso(600200405L);
    private final boolean ACESSO_VALORES = Acesso.getAcesso(600200406L);
    private final boolean ACESSO_CONFERIR = Acesso.getAcesso(600200407L);
    private final boolean ACESSO_ALTERAR_MATRICULA_GUIA = Acesso.getAcesso(600200408L);
    private final boolean ACESSO_ALTERAR_DATA_GUIA = Acesso.getAcesso(600200409L);
    private final boolean ACESSO_ALTERAR_REQUISICAO = Acesso.getAcesso(600200410L);
    private final boolean ACESSO_FILIAL = Acesso.getAcesso(600200411L);
    private final boolean ACESSO_IMPRIMIR_RESULTADO = Acesso.getAcesso(Long.parseLong("0600200412"));
    private final boolean ACESSO_VISUALIZAR_RESULTADO = Acesso.getAcesso(Long.parseLong("0600200413"));
    protected static final Color COR_DEVE_GUIA = Color.RED;
    protected static final Color COR_NAO_FATURAR = Color.BLUE;
    protected static final Color COR_CONFERIDO = new Color(180, 255, 180);
    protected static final Color COR_GRAVAR = new Color(130, 235, 120);
    private static final int EXAME_CODIGO = 0;
    private static final int EXAME_DESCRICAO = 1;
    private static final int EXAME_MATERIAL = 2;
    private final String CAMPO_EXAMES = "examesrequisicao";
    private final String CAMPO_GRAVAR_REQUISICAO = "gravardados";
    private final String CAMPO_GRAVAR_EXAME = "gravardadosexame";
    private final String CAMPO_REMOVER = "removerconferencia";
    private final String CAMPO_ALTERADA_MATRICULA = "matriculaalterada";
    private final String CAMPO_ALTERADA_VALIDADE = "validadealterada";
    private final int TAMANHO_DIFERENCA = 50;
    private final JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private final JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this);
    private final JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private final JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private final JButton buttonConferir = ComponenteFactory.novoJButton("Conferir", 'e', this);
    private final JButton buttonConferirTodos = ComponenteFactory.novoJButton("Conferir todos", 't', this);
    private final JButton buttonRemover = ComponenteFactory.novoJButton("Remover Confer\u00eancia", 'R', this);
    private final JButton buttonFiltrar = ComponenteFactory.novoJButton("Filtrar", 'i', this);
    private final JButton buttonOpcoes = ComponenteFactory.novoJButton("Op\u00e7\u00f5es \u25bc", 'p', this);
    private final ModeloResultSet modeloRequisicao = this.ACESSO_FILIAL ? new ModeloResultSet("Filial", "fil_codigo", "C\u00f3digo", "req_codigo", "Paciente", "pac_nome", "Conv\u00eanio", "con_fantasia", "Matr\u00edcula", "req_matricula", "Guia", "req_guia", "Valor", "valor") : new ModeloResultSet("C\u00f3digo", "req_codigo", "Paciente", "pac_nome", "Conv\u00eanio", "con_fantasia", "Matr\u00edcula", "req_matricula", "Guia", "req_guia", "Valor", "valor");
    private final ModeloResultSet modeloExame = this.ACESSO_VALORES ? new ModeloResultSet("C\u00f3digo", "exa_codigo", "Descri\u00e7\u00e3o", "exa_descricao", "Mat", "mco_abreviatura", "AMB/CBHPM", "codigoAMB", "Guia", "exr_guia", "Data Guia", "exr_dataguia", "Valor", "valortotalexame", "Sit.", "exr_situacao") : new ModeloResultSet("C\u00f3digo", "exa_codigo", "Mat", "mco_abreviatura", "Descri\u00e7\u00e3o", "exa_descricao", "Guia", "exr_guia", "AMB/CBHPM", "codigoAMB", "Data Guia", "exr_dataguia", "Sit.", "exr_situacao");
    private final JTable tableRequisicao = new JTable(this.modeloRequisicao);
    private final JTable tableExame = new JTable(this.modeloExame);
    private final JButton buttonRequisicao = ComponenteFactory.novoJButton(this, true);
    private final TTextField textRequisicao = new TTextField(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo(), 1);
    private final JLabel labelFilial = new JLabel("Filial:");
    private final TTextField textFilial = new TTextField(8, 1);
    private final JButton buttonFilial = ComponenteFactory.novoJButton(this, true);
    private final JLabel labelVlrFilial = new JLabel("");
    private final JPanel panelOpcoes = new JPanel(new FlowLayout(0));
    private final JPopupMenu menu = new JPopupMenu();
    private final JMenuItem itemTitular = ComponenteFactory.novoJMenuItem(this.menu, "Titular", '\u0000', this);
    private final JMenuItem itemMarcarGuia = ComponenteFactory.novoJMenuItem(this.menu, "Marcar Deve guia/pedido", 'g', this);
    private final JMenuItem itemApenasFaturamento = ComponenteFactory.novoJMenuItem(this.menu, "Marcar como apenas faturamento", '\u0000', this);
    private final JMenuItem itemAutorizacao = ComponenteFactory.novoJMenuItem(this.menu, "Autoriza\u00e7\u00e3o", '\u0000', this);
    private final JMenuItem itemNaoFaturar = ComponenteFactory.novoJMenuItem(this.menu, "Marcar para n\u00e3o faturar", '\u0000', this);
    private final JMenuItem itemAlterarGuia = ComponenteFactory.novoJMenuItem(this.menu, "Alterar data/guia requisi\u00e7\u00e3o/exames", '\u0000', this);
    private final JMenuItem itemAlterarRequisicao = ComponenteFactory.novoJMenuItem(this.menu, "Alterar requisi\u00e7\u00e3o", '\u0000', this);
    private final JMenuItem itemToken = ComponenteFactory.novoJMenuItem(this.menu, "Informa\u00e7\u00f5es de token", '\u0000', this);
    private final JMenu menuImprimir = ComponenteFactory.novoJMenu(this.menu, "Imprimir", 'I');
    private final JMenuItem itemComprovante = ComponenteFactory.novoJMenuItem(this.menuImprimir, "Comprovante", '\u0000', this);
    private final JMenuItem itemRecibo = ComponenteFactory.novoJMenuItem(this.menuImprimir, "Recibo", '\u0000', this);
    private final JMenuItem itemAnexo = ComponenteFactory.novoJMenuItem(this.menuImprimir, "Anexo de faturamento", '\u0000', this);
    private final JMenu itemImprimirResultado = ComponenteFactory.novoJMenu(this.menuImprimir, "Resultado", '\u0000');
    private final JMenuItem itemImprimirResultadoSelecionado = ComponenteFactory.novoJMenuItem(this.itemImprimirResultado, "Requisi\u00e7ao selecionada", '\u0000', this);
    private final JMenuItem itemImprimirResultadoTodos = ComponenteFactory.novoJMenuItem(this.itemImprimirResultado, "Todas as requisi\u00e7\u00f5es", '\u0000', this);
    private final JMenuItem itemGuia = ComponenteFactory.novoJMenuItem(this.menuImprimir, "Guia", '\u0000', this);
    private final JMenuItem itemGuiaExameSolicitado = ComponenteFactory.novoJMenuItem(this.menuImprimir, "Guia de exames solicitados", '\u0000', this);
    private final JMenuItem itemAnexoCobranca = ComponenteFactory.novoJMenuItem(this.menuImprimir, "Anexo de cobran\u00e7a", '\u0000', this);
    private final JMenuItem itemVisualizarResultado = ComponenteFactory.novoJMenuItem(this.menu, "Visualizar Resultado", '\u0000', this);
    JScrollPane scrollReq = new JScrollPane(this.tableRequisicao);
    JPanel panelReq = ComponenteFactory.novoJPanelBorderLayout("Requisi\u00e7\u00f5es", this.scrollReq);
    JPanel panelDetalhesBotoes = new JPanel(new BorderLayout());
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    DetalhesRequisicaoFatura detalhe = new DetalhesRequisicaoFatura(2);
    private ConferenciaGuiasService service = new ConferenciaGuiasService();
    private String conferenciaToken = "";

    public ConferenciaGuias() {
        this.montaTela();
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Confer\u00eancia de guias", "Confer\u00eancia das guias recebidas na recep\u00e7\u00e3o para faturamento", "financeiro/conferencia_guia.jpg");
        this.panelOpcoes.add(this.buttonFiltrar);
        this.panelOpcoes.add(this.buttonOpcoes);
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelBotoes.add(this.buttonFechar);
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.fill = 2;
        c.weightx = 1.0;
        p.add((Component)this.getPanelLegenda(), c);
        ++c.gridy;
        p.add((Component)this.panelOpcoes, c);
        ++c.gridx;
        p.add((Component)this.panelBotoes, c);
        JPanel panel = new JPanel(new GridBagLayout());
        this.add((Component)panel, "Center");
        this.add((Component)p, "South");
        this.panelReq.add((Component)this.panelDetalhesBotoes, "South");
        this.panelDetalhesBotoes.add((Component)this.detalhe, "Center");
        this.panelDetalhesBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonConferir, this.buttonConferirTodos, this.buttonRemover), "South");
        this.panelDetalhesBotoes.setPreferredSize(new Dimension(10, 50));
        c = new GridBagConstraints();
        c.gridy = 1;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        panel.add((Component)this.panelReq, c);
        c.gridx = 0;
        c.gridy = 2;
        panel.add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", new JScrollPane(this.tableExame)), c);
        this.textFilial.setPreferredSize(new Dimension(50, 20));
        this.textFilial.setMinimumSize(new Dimension(50, 20));
        this.buttonFilial.setPreferredSize(new Dimension(20, 20));
        this.buttonFilial.setMinimumSize(new Dimension(20, 20));
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        JPanel p2 = null;
        p2 = this.ACESSO_FILIAL ? ComponenteFactory.novoJPanelFlowLayout(0, this.labelFilial, this.textFilial, this.buttonFilial, this.labelVlrFilial, new JLabel("     "), new JLabel("Requisi\u00e7\u00e3o:"), this.textRequisicao, this.buttonRequisicao) : ComponenteFactory.novoJPanelFlowLayout(0, new JLabel("Requisi\u00e7\u00e3o:"), this.textRequisicao, this.buttonRequisicao);
        ((FlowLayout)p2.getLayout()).setHgap(0);
        this.textRequisicao.setPreferredSize(new Dimension(80, 20));
        this.textRequisicao.setMinimumSize(new Dimension(80, 20));
        this.buttonRequisicao.setPreferredSize(new Dimension(20, 20));
        this.buttonRequisicao.setMinimumSize(new Dimension(20, 20));
        p2.setPreferredSize(new Dimension(100, 25));
        panel.add((Component)p2, c);
        this.modeloRequisicao.setOrdenarColunas(true);
        this.tableRequisicao.getTableHeader().addMouseListener(this.modeloRequisicao);
        this.tableRequisicao.setToolTipText("Espa\u00e7o - Alterar matr\u00edcula ou guia");
        this.tableRequisicao.getTableHeader().setResizingAllowed(true);
        this.tableRequisicao.setRowHeight(20);
        if (this.ACESSO_FILIAL) {
            this.modeloRequisicao.setTamanhoColunas(this.tableRequisicao, 40, 65, 0, 0, 150, 110, 80);
        } else {
            this.modeloRequisicao.setTamanhoColunas(this.tableRequisicao, 65, 0, 0, 150, 110, 80);
        }
        if (this.ACESSO_VALORES) {
            this.modeloExame.setTamanhoColunas(this.tableExame, 50, 0, 30, 100, 130, 80, 80, 20);
        } else {
            this.modeloExame.setTamanhoColunas(this.tableExame, 50, 0, 30, 100, 130, 80, 20);
        }
        this.tableRequisicao.setDefaultRenderer(Object.class, new RenderRequisicoes());
        this.tableRequisicao.setDefaultRenderer(Integer.class, new RenderRequisicoes());
        this.tableExame.setDefaultRenderer(Object.class, new RenderExames());
        this.tableExame.setDefaultRenderer(String.class, new RenderExames());
        this.tableExame.setDefaultRenderer(Date.class, new RenderExames());
        this.detalhe.addDetalhesExpandidoListener(this);
        this.textFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    ConferenciaGuias.this.pesquisaFilial();
                }
            }
        });
        this.textRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    if (ConferenciaGuias.this.ACESSO_FILIAL) {
                        ConferenciaGuias.this.pesquisaRequisicao(Funcoes.textoVazio(ConferenciaGuias.this.textFilial) ? Variaveis.filialPadrao : ConferenciaGuias.this.textFilial.getText());
                    } else {
                        ConferenciaGuias.this.pesquisaRequisicao(Variaveis.filialPadrao);
                    }
                }
            }
        });
        this.textRequisicao.addFocusListener(new FocusAdapter(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void focusLost(FocusEvent e) {
                boolean tuboValido = false;
                String etiquetaDigitada = ConferenciaGuias.this.textRequisicao.getText();
                if (Funcoes.textoVazio(ConferenciaGuias.this.textRequisicao)) return;
                if (e.getSource() == ConferenciaGuias.this.textRequisicao) {
                    tuboValido = ConferenciaGuias.this.processarNumeroTubo(ConferenciaGuias.this.textFilial, ConferenciaGuias.this.textRequisicao);
                }
                String filial = null;
                if (ConferenciaGuias.this.ACESSO_FILIAL) {
                    if (Funcoes.textoVazio(ConferenciaGuias.this.textFilial)) {
                        Funcoes.mensagem(ConferenciaGuias.this, "A filial deve ser selecionada.", 2);
                        ScreenUtil.requisitarFoco(ConferenciaGuias.this.textFilial);
                        return;
                    }
                    filial = ConferenciaGuias.this.textFilial.getText();
                } else if (tuboValido) {
                    if (!ConferenciaGuias.this.textFilial.getText().equalsIgnoreCase(Variaveis.filialPadrao)) {
                        ConferenciaGuias.this.textFilial.setText(Variaveis.filialPadrao);
                        ConferenciaGuias.this.textRequisicao.clear();
                        Funcoes.mensagem(ConferenciaGuias.this, "O usu\u00e1rio atual n\u00e3o possui acesso para carregar requisi\u00e7\u00f5es de outras filiais.", 2);
                        ScreenUtil.requisitarFoco(ConferenciaGuias.this.textRequisicao);
                        return;
                    }
                    filial = ConferenciaGuias.this.textFilial.getText();
                } else {
                    filial = Variaveis.filialPadrao;
                }
                Registro r = ConferenciaGuias.this.buscaRequisicao(filial, ConferenciaGuias.this.textRequisicao.getTextDB());
                if (r == null) {
                    ConferenciaGuias.this.textRequisicao.clear();
                    ScreenUtil.requisitarFoco(ConferenciaGuias.this.textRequisicao);
                    return;
                }
                if (r.getValor("examesrequisicao") == null) {
                    Funcoes.mensagem(ConferenciaGuias.this, "A requisi\u00e7\u00e3o n\u00e3o possui exames permitidos.", 2);
                    ConferenciaGuias.this.textRequisicao.clear();
                    ScreenUtil.requisitarFoco(ConferenciaGuias.this.textRequisicao);
                    return;
                }
                ConferenciaGuias.this.adicionaGrid(r, true);
            }
        });
        this.tableRequisicao.getSelectionModel().addListSelectionListener(this);
        this.tableRequisicao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ConferenciaGuias.this.controlaMenu();
            }
        });
        this.tableRequisicao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ConferenciaGuias.this.controlaMenu();
            }
        });
        this.tableExame.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ConferenciaGuias.this.controlaMenu();
            }
        });
        this.tableRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127 && ConferenciaGuias.this.tableRequisicao.getSelectedRow() > -1 && Funcoes.mensagem(ConferenciaGuias.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    ConferenciaGuias.this.modeloRequisicao.removerRegistro(ConferenciaGuias.this.tableRequisicao.getSelectedRow());
                    ConferenciaGuias.this.tableRequisicao.revalidate();
                    ConferenciaGuias.this.tableRequisicao.getSelectionModel().clearSelection();
                    ConferenciaGuias.this.tableRequisicao.getSelectionModel().setSelectionInterval(0, 0);
                    if (ConferenciaGuias.this.modeloRequisicao.getRegistros().size() == 0) {
                        ConferenciaGuias.this.modeloExame.limpar();
                        ConferenciaGuias.this.modeloExame.fireTableDataChanged();
                    }
                    ConferenciaGuias.this.controlaMenu();
                    ConferenciaGuias.this.controlaBotoes(false);
                } else if (e.getKeyCode() == 32 && ConferenciaGuias.this.tableRequisicao.getSelectedRow() > -1) {
                    ConferenciaGuias.this.alterarGuiaMatricula(ConferenciaGuias.this.tableRequisicao.getSelectedRow());
                }
            }
        });
        this.modeloRequisicao.ordenarColuna(0, 1);
        this.modeloExame.ordenarColuna(0, 1);
        this.controlaCampos();
    }

    private void alterarGuiaMatricula(int linha) {
        Registro reg = this.modeloRequisicao.getRegistro(linha);
        AlterarGuiaMatricula alterar = AlterarGuiaMatricula.novaInstancia(this.getTopLevelAncestor());
        alterar.setConvenio(reg.getString("fil_codigo"), reg.getString("con_codigo"));
        alterar.setGuia(reg.getString("req_guia"));
        alterar.setMatricula(reg.getString("req_matricula"));
        alterar.setLocationRelativeTo(this.getTopLevelAncestor());
        alterar.setVisible(true);
        if (alterar.getOK()) {
            reg.setValor("req_guia", alterar.getGuia());
            reg.setValor("req_matricula", alterar.getMatricula());
            reg.setValor("matriculaalterada", true);
            reg.setValor("gravardados", true);
            reg.setValor("removerconferencia", false);
            this.modeloRequisicao.fireTableDataChanged();
        }
    }

    private void perguntarToken() {
        Registro req = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
        PedirToken pedirToken = new PedirToken((Frame)this.getTopLevelAncestor(), req.getString("con_mascaratoken"), req.getBoolean("con_exigirtoken"));
        pedirToken.setToken(req.getString("req_token"));
        pedirToken.setMascaraToken(req.getString("con_mascaratoken"));
        pedirToken.setObrigaToken(req.getBoolean("con_exigirtoken"));
        String alteraToken = req.getString("req_token");
        pedirToken.setVisible(true);
        if (pedirToken.getOK()) {
            req.setValor("req_token", pedirToken.getToken());
            if (!alteraToken.equalsIgnoreCase(pedirToken.getToken())) {
                req.setValor("gravardados", true);
            }
        }
    }

    private void alterarRequisicao(int linha) {
        int resp;
        Registro reg;
        if (linha >= 0 && (reg = this.modeloRequisicao.getRegistro(linha)) != null && (resp = Funcoes.mensagem(this, "As modifica\u00e7\u00f5es da requisi\u00e7\u00e3o " + reg.getString("req_codigo") + " ser\u00e3o perdidas.\nDeseja prosseguir?", 4)) == 0) {
            Requisicao requisicao = new Requisicao(Variaveis.tipoFilialPadrao);
            requisicao.setFecharAoSalvar(true);
            requisicao.setCodigoRequisicao(reg.getValor("fil_codigo").toString(), reg.getValor("req_codigo").toString(), false);
            JDialog diag = new JDialog((Frame)Laboratorio.getInstancia(), true);
            diag.setContentPane(requisicao);
            diag.setPreferredSize(new Dimension(700, 600));
            diag.setMinimumSize(new Dimension(790, 650));
            diag.setLocationRelativeTo(Laboratorio.getInstancia());
            diag.setVisible(true);
            Registro novaReq = this.buscaRequisicao(reg.getValor("fil_codigo").toString(), reg.getValor("req_codigo").toString());
            this.modeloRequisicao.removerRegistro(linha);
            this.adicionaGrid(novaReq, false);
            FuncoesGerais.repaintTabela(this.tableRequisicao);
            this.detalhe.atualizar();
            int exameSelecionado = this.tableExame.getSelectedRow();
            FuncoesGerais.repaintTabela(this.tableExame);
            for (int i = 0; i < this.modeloRequisicao.getRowCount(); ++i) {
                if (this.modeloRequisicao.getRegistro(i) != novaReq) continue;
                this.tableRequisicao.clearSelection();
                this.tableRequisicao.setRowSelectionInterval(i, i);
                break;
            }
            this.tableExame.clearSelection();
            if (exameSelecionado > -1 && exameSelecionado < this.tableExame.getRowCount()) {
                this.tableExame.setRowSelectionInterval(exameSelecionado, exameSelecionado);
            } else {
                this.tableExame.setRowSelectionInterval(0, 0);
            }
            this.controlaMenu();
        }
    }

    private void alterarGuia(int linha) {
        Dialog telaAlteracao = null;
        Registro req = this.modeloRequisicao.getRegistro(linha);
        if (req != null && linha > -1) {
            telaAlteracao = new AlteraGuiasFaturamento((Frame)Laboratorio.getInstancia(), req.getInt("codigoConvenio") != req.getInt("codigoRepasse"), false);
            try {
                ((AlteraGuiasFaturamento)telaAlteracao).setGuiasRequisicao(req.getString("req_guia"), req.getString("req_guiaprincipal"), false);
            }
            catch (Exception e1) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel iniciar a janela de edi\u00e7\u00e3o de guias.\n" + e1.getMessage(), e1.getStackTrace());
                return;
            }
            for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
                Registro exame = this.modeloExame.getRegistro(i);
                String codigoExame = exame.getString("exa_codigo");
                String nomeExame = exame.getString("exa_descricao");
                Integer codigoMaterial = exame.getInt("mco_codigo");
                String mnemonicoMaterial = exame.getString("mco_abreviatura");
                String codigoGuia = exame.getString("exr_guia");
                Integer qtdeExamesGuia = exame.getInt("con_examesporguia");
                Boolean exigeGuia = exame.getBoolean("con_codigoguia");
                Boolean exigeValidade = exame.getBoolean("con_validadeguia");
                Date dataGuia = null;
                Date validadeGuia = null;
                try {
                    dataGuia = exame.getDate("exr_dataguia");
                    validadeGuia = exame.getDate("exr_validadeguia");
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                Boolean deveGuia = exame.getBoolean("exr_deveguia");
                ((AlteraGuiasFaturamento)telaAlteracao).adicionarExame(codigoExame, nomeExame, codigoGuia, dataGuia, deveGuia, qtdeExamesGuia, exigeGuia, exigeValidade, validadeGuia, mnemonicoMaterial, codigoMaterial);
            }
        }
        if (telaAlteracao != null) {
            telaAlteracao.setVisible(true);
            if (((AbstractDialogoOKCancelar)telaAlteracao).getOK()) {
                req.setValor("req_guia", ((AlteraGuiasFaturamento)telaAlteracao).getGuiaRequisicao());
                req.setValor("req_guiaprincipal", ((AlteraGuiasFaturamento)telaAlteracao).getGuiaPrincipalRequisicao());
                req.setValor("gravardados", true);
                ArrayList<DadosExameFaturamento> listaExamesConfigurados = ((AlteraGuiasFaturamento)telaAlteracao).getExames();
                block5: for (int i = 0; i < listaExamesConfigurados.size(); ++i) {
                    DadosExameFaturamento exameAlt = listaExamesConfigurados.get(i);
                    for (int j = 0; j < this.modeloExame.getRowCount(); ++j) {
                        Registro exame = this.modeloExame.getRegistro(j);
                        if (!exame.getString("exa_codigo").equalsIgnoreCase(exameAlt.getCodigoExame()) || exame.getInt("mco_codigo") != exameAlt.getCodigoMaterial().intValue()) continue;
                        exame.setValor("exr_guia", StringUtil.textoDB(exameAlt.getCodigoGuia()).trim());
                        exame.setValor("exr_dataguia", exameAlt.getDataGuia() == null ? "" : Funcoes.formataData(exameAlt.getDataGuia()));
                        exame.setValor("exr_validadeguia", exameAlt.getValidadeGuia() == null ? "" : Funcoes.formataData(exameAlt.getValidadeGuia()));
                        exame.setValor("exr_deveguia", exameAlt.getDeveGuia());
                        exame.setValor("gravardadosexame", true);
                        continue block5;
                    }
                }
                FuncoesGerais.repaintTabela(this.tableRequisicao);
                this.detalhe.atualizar();
                int exameSelecionado = this.tableExame.getSelectedRow();
                FuncoesGerais.repaintTabela(this.tableExame);
                for (int i = 0; i < this.modeloRequisicao.getRowCount(); ++i) {
                    if (this.modeloRequisicao.getRegistro(i) != req) continue;
                    this.tableRequisicao.clearSelection();
                    this.tableRequisicao.setRowSelectionInterval(i, i);
                    break;
                }
                this.tableExame.clearSelection();
                if (exameSelecionado > -1 && exameSelecionado < this.tableExame.getRowCount()) {
                    this.tableExame.setRowSelectionInterval(exameSelecionado, exameSelecionado);
                } else {
                    this.tableExame.setRowSelectionInterval(0, 0);
                }
                this.controlaMenu();
            }
        }
    }

    private void alterarDataGuia(int linha) {
        Registro reg = this.modeloRequisicao.getRegistro(linha);
        Date dataValidade = null;
        Date dataGuia = null;
        Date dataRequisicao = null;
        try {
            dataValidade = reg.getDate("req_validadeguia");
            dataGuia = reg.getDate("req_dataguia");
            dataRequisicao = reg.getString("req_data") == null || Funcoes.textoVazio(reg.getString("req_data")) ? new Date() : reg.getDate("req_data");
        }
        catch (Exception exception) {
            // empty catch block
        }
        SolicitarValidadeGuia validade = this.getTopLevelAncestor() instanceof Dialog ? new SolicitarValidadeGuia((Dialog)this.getTopLevelAncestor(), reg.getBoolean("con_validadeguia"), reg.getInt("con_diasvalidade"), dataRequisicao) : new SolicitarValidadeGuia((Frame)this.getTopLevelAncestor(), reg.getBoolean("con_validadeguia"), reg.getInt("con_diasvalidade"), dataRequisicao);
        if (dataValidade != null) {
            validade.setValidade(dataValidade);
        }
        if (reg.getString("req_data") != null) {
            validade.setData(Funcoes.stringToDate(reg.getString("req_data")));
        }
        validade.setDeveGuia(reg.getBoolean("req_deveguia"));
        validade.setDias(reg.getInt("con_diasvalidade"));
        validade.setVisible(true);
        boolean deveGuia = false;
        boolean atualizar = false;
        if (validade.getOK() == 0) {
            deveGuia = validade.getDeveGuia();
            atualizar = true;
        } else if (validade.getOK() == 1) {
            Funcoes.mensagem(this, "A data de validade da guia expirou", 2);
        } else {
            dataValidade = validade.getValidade();
            atualizar = true;
        }
        validade = null;
        if (atualizar) {
            reg.setValor("req_deveguia", deveGuia);
            reg.setValor("req_validadeguia", dataValidade);
            reg.setValor("req_dataguia", dataGuia);
            reg.setValor("validadealterada", true);
            reg.setValor("gravardados", true);
            reg.setValor("removerconferencia", false);
            this.modeloRequisicao.fireTableDataChanged();
            this.detalhe.setRequisicao(reg);
        }
    }

    private void controlaMenu() {
        Registro r;
        this.itemTitular.setVisible(this.ACESSO_TITULAR && this.tableRequisicao.getSelectedRow() > -1);
        this.itemAlterarGuia.setVisible(this.ACESSO_ALTERAR_DATA_GUIA && this.tableRequisicao.getSelectedRow() > -1);
        this.itemMarcarGuia.setVisible(this.ACESSO_DEVE_GUIA && this.tableRequisicao.getSelectedRow() > -1);
        this.menuImprimir.setVisible(this.tableRequisicao.getSelectedRow() > -1);
        this.itemApenasFaturamento.setVisible(this.ACESSO_APENAS_FATURAMENTO && this.tableExame.getSelectedRow() > -1);
        this.itemAutorizacao.setVisible(this.ACESSO_AUTORIZACAO && this.tableExame.getSelectedRow() > -1);
        this.itemNaoFaturar.setVisible(this.ACESSO_NAO_FATURAR && this.tableExame.getSelectedRow() > -1 && this.tableRequisicao.getSelectedRow() > -1);
        this.itemAlterarRequisicao.setVisible(this.ACESSO_ALTERAR_REQUISICAO && this.tableRequisicao.getSelectedRow() > -1);
        this.itemVisualizarResultado.setVisible(this.validarAcessoImprimirVisualizarResultado() && this.ACESSO_VISUALIZAR_RESULTADO);
        this.itemImprimirResultado.setVisible(this.validarAcessoImprimirVisualizarResultado() && this.ACESSO_IMPRIMIR_RESULTADO);
        if (this.tableRequisicao.getSelectedRow() > -1) {
            r = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
            this.itemMarcarGuia.setText(r == null || r.getBoolean("req_deveguia") ? "Desmarcar deve guia/pedido" : "Marcar deve guia/pedido");
        }
        if (this.tableExame.getSelectedRow() > -1) {
            r = this.modeloExame.getRegistro(this.tableExame.getSelectedRow());
            this.itemNaoFaturar.setText(r.getBoolean("exr_naofaturar") ? "Marcar para faturar" : "Marcar para n\u00e3o faturar");
            this.itemApenasFaturamento.setVisible(this.itemApenasFaturamento.isVisible() && (Funcoes.textoVazio(r.getString("exr_situacao")) || r.getString("exr_situacao").equalsIgnoreCase("A")));
            if (r.getString("exr_situacao").equalsIgnoreCase("A")) {
                this.itemApenasFaturamento.setText("Desmarcar como apenas faturamento");
            } else {
                this.itemApenasFaturamento.setText("Marcar como apenas faturamento");
            }
        }
    }

    private boolean validarAcessoImprimirVisualizarResultado() {
        boolean validado = false;
        if (this.linhaSelecionada()) {
            for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
                Registro registro = this.modeloExame.getRegistro(i);
                String situacao = registro.getString("exr_situacao");
                if (!this.isConferidoImpresso(situacao)) continue;
                validado = true;
                break;
            }
        }
        return validado;
    }

    private void controlaBotoes(boolean isCarregandoDados) {
        int row = this.tableRequisicao.getSelectedRow();
        Registro r = row > -1 ? this.modeloRequisicao.getRegistro(row) : null;
        boolean jaConferida = r != null && (r.getBoolean("guiaconferida") || r.getBoolean("gravarConferido")) && !r.getBoolean("removerconferencia");
        boolean todasConferidas = true;
        for (int i = 0; i < this.modeloRequisicao.getRowCount(); ++i) {
            if ((this.modeloRequisicao.getRegistro(i).getBoolean("guiaconferida") || this.modeloRequisicao.getRegistro(i).getBoolean("gravarConferido")) && !this.modeloRequisicao.getRegistro(i).getBoolean("removerconferencia")) continue;
            todasConferidas = false;
            break;
        }
        this.buttonNovo.setEnabled(this.getStatus() == 1 && !isCarregandoDados);
        this.buttonFechar.setEnabled(this.getStatus() == 1 && !isCarregandoDados);
        this.buttonSalvar.setEnabled(this.tableRequisicao.getRowCount() > 0 && !isCarregandoDados);
        this.buttonCancelar.setEnabled(this.getStatus() != 1 && !isCarregandoDados);
        this.buttonConferir.setEnabled(this.tableRequisicao.getRowCount() > 0 && this.tableRequisicao.getSelectedRow() > -1 && !jaConferida && row > -1 && !isCarregandoDados);
        this.buttonConferirTodos.setEnabled(this.modeloRequisicao.getRowCount() > 0 && !todasConferidas && !isCarregandoDados);
        this.buttonRemover.setEnabled(this.tableRequisicao.getSelectedRow() > -1 && row > -1 && r != null && !r.getBoolean("removerconferencia") && !isCarregandoDados);
        this.buttonFiltrar.setEnabled(this.getStatus() == 2 && !isCarregandoDados);
        this.buttonOpcoes.setEnabled(this.tableRequisicao.getRowCount() > 0 && !isCarregandoDados);
        this.buttonSalvar.setVisible(this.ACESSO_CONFERIR);
    }

    @Override
    public void fechar() {
        if (this.getParent() != null) {
            this.getParent().removeAll();
        }
        this.setVisible(false);
    }

    @Override
    public void cancelar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonNovo) {
            this.novo();
        } else if (o == this.buttonFechar) {
            this.fechar();
        } else if (o == this.buttonCancelar) {
            this.cancelar();
        } else if (o == this.buttonOpcoes) {
            this.controlaMenu();
            this.menu.show(this.panelOpcoes, this.buttonOpcoes.getX(), this.buttonOpcoes.getY() + this.buttonOpcoes.getHeight());
        } else if (o == this.buttonRequisicao) {
            this.pesquisaRequisicao(Funcoes.textoVazio(this.textFilial) ? Variaveis.filialPadrao : this.textFilial.getText());
        } else if (o == this.buttonFiltrar) {
            this.filtrar();
        } else if (o == this.buttonConferir) {
            this.conferir(this.tableRequisicao.getSelectedRow(), true);
        } else if (o == this.buttonConferirTodos) {
            int resposta = Funcoes.mensagem(this, "Confirma a confer\u00eancia de todas as guias selecionadas?", 4);
            if (resposta == 1) {
                return;
            }
            int linhaSelecionada = this.tableRequisicao.getSelectedRow();
            for (int i = 0; i < this.modeloRequisicao.getRowCount(); ++i) {
                this.conferir(i, false);
            }
            this.modeloRequisicao.fireTableDataChanged();
            this.tableRequisicao.revalidate();
            this.tableRequisicao.setRowSelectionInterval(linhaSelecionada, linhaSelecionada);
        } else if (o == this.itemTitular) {
            this.perguntarTitular();
        } else if (o == this.itemMarcarGuia) {
            this.deveGuia();
        } else if (o == this.itemComprovante) {
            this.imprimirComprovante();
        } else if (o == this.itemGuia) {
            this.imprimirGuia(0);
        } else if (o == this.itemGuiaExameSolicitado) {
            this.imprimirGuia(1);
        } else if (o == this.itemRecibo) {
            this.imprimirRecibo();
        } else if (o == this.itemAnexo) {
            this.imprimirAnexo();
        } else if (o == this.itemAnexoCobranca) {
            this.imprimirAnexoCobranca();
        } else if (o == this.itemApenasFaturamento) {
            this.apenasFaturamento();
        } else if (o == this.itemAutorizacao) {
            this.codigoAutorizacao();
        } else if (o == this.itemNaoFaturar) {
            this.naoFaturar();
        } else if (o == this.itemImprimirResultadoSelecionado) {
            this.imprimirSelecionado();
        } else if (o == this.itemImprimirResultadoTodos) {
            this.imprimirTodos();
        } else if (o == this.itemVisualizarResultado) {
            this.visualizarResultado();
        } else if (o == this.buttonSalvar) {
            this.salvar();
        } else if (o == this.buttonRemover) {
            this.removerConferencia();
        } else if (o == this.itemAlterarGuia) {
            this.alterarGuia(this.tableRequisicao.getSelectedRow());
        } else if (o == this.itemAlterarRequisicao) {
            this.alterarRequisicao(this.tableRequisicao.getSelectedRow());
        } else if (o == this.itemToken) {
            this.perguntarToken();
        } else if (o == this.buttonFilial) {
            this.pesquisaFilial();
        }
    }

    private void imprimirSelecionado() {
        Registro req = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
        Registro[] requisicaoExames = (Registro[])req.getValor("examesrequisicao");
        SelecionarExamesConferenciaGuias sel = SelecionarExamesConferenciaGuias.novaInstancia(Laboratorio.getInstancia(), "Selecionar Exames");
        sel.setListaExames(requisicaoExames);
        sel.setVisible(true);
        if (sel.getOK()) {
            Registro[] registros = sel.getExames();
            this.imprimirResultadoExames(registros, req);
        }
    }

    private void imprimirTodos() {
        int[] linha = ArraysUtil.getArrayIndexado(this.tableRequisicao.getRowCount());
        if (this.podeImprimir()) {
            this.imprimirResultado(linha);
        }
    }

    private boolean podeImprimir() {
        int resposta = Funcoes.mensagem(this, "Ser\u00e3o impressos os resultados de todas as requisi\u00e7\u00f5es listadas. \nDeseja continuar?", 4);
        return resposta == 0;
    }

    private void removerConferencia() {
        int linha = this.tableRequisicao.getSelectedRow();
        if (linha > -1) {
            Registro r = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
            r.setValor("req_dataguiaconferida", null);
            r.setValor("usr_codguiaconferida", null);
            r.setValor("gravarConferido", false);
            r.setValor("removerconferencia", true);
            r.setValor("gravardados", true);
            this.modeloRequisicao.fireTableDataChanged();
            this.tableRequisicao.setRowSelectionInterval(linha, linha);
            ScreenUtil.requisitarFoco(this.tableRequisicao);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void salvarRequisicao(Registro r) {
        this.validarApenasFaturamento();
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        Statement st3 = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            if (r.getBoolean("gravardados")) {
                Registro[] exames = (Registro[])r.getValor("examesrequisicao");
                buf.setLength(0);
                buf.append("update requisicao set  ");
                buf.append("req_deveguia = ").append(r.getBoolean("req_deveguia") ? "true" : "false").append(", ");
                if (r.getBoolean("deviaguia") || r.getBoolean("req_deveguia")) {
                    buf.append("usr_codrecebeuguia = ").append(r.getBoolean("deviaguia") ? "'" + StringUtil.textoDB(Variaveis.login) + "'" : "null").append(", ");
                    buf.append("req_datarecebeuguia = ").append(r.getBoolean("deviaguia") ? "'" + Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date()) + "'" : "null").append(", ");
                }
                buf.append("req_titular = '").append(StringUtil.textoDB(r.getString("req_titular"))).append("' ");
                if (r.getBoolean("gravarConferido")) {
                    buf.append(",req_dataguiaconferida = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date())).append("', ");
                    buf.append("usr_codguiaconferida = '").append(StringUtil.textoDB(Variaveis.login)).append("' ");
                } else if (r.getBoolean("removerconferencia")) {
                    buf.append(",req_dataguiaconferida = null, usr_codguiaconferida = null ");
                }
                if (r.getBoolean("matriculaalterada")) {
                    buf.append(", req_matricula = '").append(StringUtil.textoDB(r.getString("req_matricula"))).append("' ");
                    buf.append(", req_guia = '").append(StringUtil.textoDB(r.getString("req_guia"))).append("' ");
                }
                buf.append(", req_validadeguia = ");
                if (r.getDate("req_validadeguia") != null) {
                    buf.append("'").append(Funcoes.formataData("MM/dd/yyyy", r.getDate("req_validadeguia"))).append("' ");
                } else {
                    buf.append("null");
                }
                buf.append(", req_guiaprincipal = ").append(r.getString("req_guiaprincipal") == null ? " null " : "'" + r.getString("req_guiaprincipal") + "' ");
                buf.append(", req_token = '").append(this.conferenciaToken).append("'");
                buf.append(" where fil_codigo = ").append(r.getString("fil_codigo"));
                buf.append(" and req_codigo = ").append(r.getString("req_codigo"));
                Conexao.execute(r.getString("fil_codigo"), st, buf.toString());
                buf.setLength(0);
                buf.append("insert into requisicaousuario (fil_codigo, req_codigo, usr_codigo, reu_data) values (");
                buf.append(r.getString("fil_codigo"));
                buf.append(", ");
                buf.append(r.getString("req_codigo"));
                buf.append(", '");
                buf.append(Variaveis.login);
                buf.append("', '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss.SSS", new Date())).append("')");
                Conexao.execute(r.getString("fil_codigo"), st, buf.toString());
                for (Registro exame : exames) {
                    if (!exame.getBoolean("gravardadosexame")) continue;
                    buf.setLength(0);
                    if (this.isAgrupamento(exame)) {
                        buf.append(" update examerequisicao ");
                        buf.append("    set ");
                        buf.append("       exr_codautorizacao = '").append(StringUtil.textoDB(exame.getString("exr_codautorizacao"))).append("' ");
                        buf.append("       ,exr_naofaturar = ").append(exame.getBoolean("exr_naofaturar") ? "true" : "false");
                        buf.append("\t\t\t ,usr_codnaofaturar = ").append(exame.getBoolean("exr_naofaturar") ? "'" + StringUtil.textoDB(Variaveis.login) + "'" : "null");
                        buf.append("       ,exr_guia = ").append(exame.getString("exr_guia") == null ? " null " : "'" + StringUtil.textoDB(exame.getString("exr_guia")).trim() + "' ");
                        buf.append("       ,exr_validadeguia = ").append(exame.getDate("exr_validadeguia") == null ? " null " : "'" + exame.getDate("exr_validadeguia") + "' ");
                        buf.append("       ,exr_deveguia = ").append(exame.getBoolean("exr_deveguia"));
                        buf.append("       ,exr_dataautorizacao = ").append(exame.getDate("exr_dataautorizacao") == null ? " null " : "'" + exame.getDate("exr_dataautorizacao") + "' ");
                        buf.append("       ,exr_datavalidadeautorizacao = ").append(exame.getDate("exr_datavalidadeautorizacao") == null ? " null " : "'" + exame.getDate("exr_datavalidadeautorizacao") + "' ");
                        if (exame.getString("exr_situacao").equals("A")) {
                            buf.append("     ,exr_datadigita = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm", new Date())).append("' ");
                            buf.append("     ,exr_situacao = '").append("A").append("' ");
                        }
                        buf.append("  where fil_codigo = ").append(r.getString("fil_codigo"));
                        buf.append("    and req_codigo = ").append(r.getString("req_codigo"));
                        buf.append("    and exa_codigo = '").append(StringUtil.textoDB(exame.getString("exa_codigo"))).append("'");
                        buf.append("    and mco_codigo = ").append(exame.getString("mco_codigo"));
                        DBUtil.gravaLogSituacaoExameRequisicao(st, r.getString("fil_codigo"), r.getString("req_codigo"), exame.getString("exa_codigo"), exame.getString("mco_codigo"), exame.getString("exr_situacao"), false);
                        Conexao.execute(r.getString("fil_codigo"), st, buf.toString());
                    } else {
                        buf.setLength(0);
                        buf.append(" update examerequisicao ");
                        buf.append("    set exr_naofaturar = ").append(exame.getBoolean("exr_naofaturar") ? "true" : "false");
                        if (exame.getBoolean("exr_naofaturar")) {
                            buf.append("       ,usr_codnaofaturar = '").append(exame.getString("usr_codnaofaturar")).append("' ");
                        } else {
                            buf.append("       ,usr_codnaofaturar = null ");
                        }
                        buf.append("  where fil_codigo = ").append(r.getString("fil_codigo"));
                        buf.append("    and req_codigo = ").append(r.getString("req_codigo"));
                        buf.append("    and exa_codigo = '").append(StringUtil.textoDB(exame.getString("codigoexamepai"))).append("'");
                        buf.append("    and mco_codigo = ").append(exame.getString("materialexamepai"));
                        Conexao.executeUpdate(r.getString("fil_codigo"), st, buf.toString());
                        buf.setLength(0);
                        buf.append(" update examerequisicaoguiaagrupada ");
                        buf.append("    set exg_guia = ").append(exame.getString("exr_guia") == null ? " null " : "'" + StringUtil.textoDB(exame.getString("exr_guia")).trim() + "' ");
                        buf.append("       ,exg_validadeguia = ").append(exame.getDate("exr_validadeguia") == null ? " null " : "'" + exame.getDate("exr_validadeguia") + "' ");
                        buf.append("       ,exg_deveguia = ").append(exame.getBoolean("exr_deveguia"));
                        buf.append("  where fil_codigo = ").append(r.getString("fil_codigo"));
                        buf.append("    and req_codigo = ").append(r.getString("req_codigo"));
                        buf.append("    and exa_codigo = '").append(exame.getString("codigoexamepai")).append("' ");
                        buf.append("    and mco_codigo = ").append(exame.getString("materialexamepai"));
                        buf.append("    and exa_codfilho = '").append(exame.getString("exa_codigo")).append("' ");
                        buf.append("    and mco_codfilho = ").append(exame.getString("mco_codigo"));
                        int qtde = Conexao.executeUpdate(r.getString("fil_codigo"), st, buf.toString());
                        if (qtde == 0) {
                            buf.delete(0, buf.length());
                            buf.append(" insert into examerequisicaoguiaagrupada ");
                            buf.append("      values(").append(r.getString("fil_codigo"));
                            buf.append("            ,'").append(exame.getString("codigoexamepai")).append("' ");
                            buf.append("            ,'").append(exame.getString("exa_codigo")).append("' ");
                            buf.append("            ,").append(exame.getInt("materialexamepai"));
                            buf.append("            ,").append(exame.getInt("mco_codigo"));
                            buf.append("            ,").append(r.getString("req_codigo"));
                            if (exame.getString("exr_guia") != null) {
                                buf.append("            ,'").append(StringUtil.textoDB(exame.getString("exr_guia")).trim()).append("' ");
                            } else {
                                buf.append("            ,null ");
                            }
                            if (exame.getDate("exr_validadeguia") != null) {
                                buf.append("          ,'").append(exame.getDate("exr_validadeguia")).append("' ");
                            } else {
                                buf.append("          ,null ");
                            }
                            buf.append("            ,").append(exame.getBoolean("exr_deveguia"));
                            buf.append(") ");
                            Conexao.executeUpdate(r.getString("fil_codigo"), st, buf.toString());
                        }
                    }
                    ExportaFiliais.gravaRequisicao(Integer.parseInt(r.getString("fil_codigo")), Integer.parseInt(r.getString("req_codigo")), exame.getString("exa_codigo"), exame.getInt("mco_codigo"), "U", "U");
                }
                if (Variaveis.exportarWebFilial) {
                    if (r.getBoolean("req_deveguia")) {
                        String[] comandoRequisicao = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoRequisicao", IntegracaoUtil.formataCodigoRequisicao(r.getString("fil_codigo"), r.getString("req_codigo"), st)};
                        DBUtil.insereExportaWeb(r.getString("fil_codigo"), st, "requisicao", "D", comandoRequisicao);
                    } else {
                        FuncoesGerais.reenviarRequisicaoWeb(st3, st2, r.getString("fil_codigo"), r.getString("req_codigo"));
                    }
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2, st3);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2, st3);
        }
        Conexao.fecharStatement(st, st2, st3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void salvar() {
        Statement st3;
        Statement st2;
        Statement st;
        block11: {
            this.validarApenasFaturamento();
            List<Registro> registros = this.modeloRequisicao.getRegistros();
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            st3 = Conexao.getStatement();
            try {
                for (Registro req : registros) {
                    Registro[] exames = (Registro[])req.getValor("examesrequisicao");
                    if (req.getBoolean("con_exigirtoken") && Funcoes.textoVazio(PedirToken.limpaMascaraToken(req.getString("req_token")))) {
                        Funcoes.mensagem(this, "O token n\u00e3o foi informado.", 2);
                        this.perguntarToken();
                        break block11;
                    }
                    if (!req.getBoolean("gravardados")) continue;
                    this.service.updateDadosRequisicao(req);
                    this.service.insertRequisicaoUsuario(req);
                    for (Registro exame : exames) {
                        if (!exame.getBoolean("gravardadosexame")) continue;
                        this.service.atualizaDadosExamesAgrupados(req, exame);
                        ExportaFiliais.gravaRequisicao(Integer.parseInt(req.getString("fil_codigo")), Integer.parseInt(req.getString("req_codigo")), exame.getString("exa_codigo"), exame.getInt("mco_codigo"), "U", "U");
                    }
                    if (!Variaveis.exportarWebFilial) continue;
                    if (req.getBoolean("req_deveguia")) {
                        String[] comandoRequisicao = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoRequisicao", IntegracaoUtil.formataCodigoRequisicao(req.getString("fil_codigo"), req.getString("req_codigo"), st)};
                        DBUtil.insereExportaWeb(req.getString("fil_codigo"), st, "requisicao", "D", comandoRequisicao);
                        continue;
                    }
                    FuncoesGerais.reenviarRequisicaoWeb(st3, st2, req.getString("fil_codigo"), req.getString("req_codigo"));
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaGuias (396)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2, st3);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2, st3);
            }
            Conexao.fecharStatement(st, st2, st3);
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
            return;
        }
        Conexao.fecharStatement(st, st2, st3);
    }

    private boolean isAgrupamento(Registro exame) {
        return !exame.getBoolean("agrupado");
    }

    private boolean jaFaturado(Registro r) {
        try {
            return r.getDate("exr_datafatura") != null;
        }
        catch (ParseException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void apenasFaturamento() {
        int linha = this.tableExame.getSelectedRow();
        if (linha > -1) {
            Registro r = this.modeloExame.getRegistro(this.tableExame.getSelectedRow());
            Registro req = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
            if (this.jaFaturado(r)) {
                Funcoes.mensagem(this, "A situa\u00e7\u00e3o n\u00e3o pode ser alterada pois o exame j\u00e1 foi faturado", 1);
            } else if (!Funcoes.textoVazio(r.getString("exr_situacao")) && !r.getString("exr_situacao").equalsIgnoreCase("A")) {
                Funcoes.mensagem(this, "O exame n\u00e3o pode ser marcado para Apenas Faturamento se a situa\u00e7\u00e3o for diferente de Sem Resultado", 1);
            } else if (r.getBoolean("exr_naofaturar")) {
                Funcoes.mensagem(this, "O exame n\u00e3o pode ser marcado como Apenas Faturamento pois ele n\u00e3o ser\u00e1 faturado", 1);
            } else {
                if (r.getString("exr_situacao").equalsIgnoreCase("A")) {
                    r.setValor("exr_situacao", null);
                } else {
                    r.setValor("exr_situacao", "A");
                }
                req.setValor("gravardados", true);
                r.setValor("gravardadosexame", true);
                FuncoesGerais.repaintTabela(this.tableExame);
                if (Variaveis.exportarWebFilial) {
                    Statement st2 = Conexao.getStatement();
                    Statement st3 = Conexao.getStatement();
                    try {
                        FuncoesGerais.reenviarRequisicaoWeb(st3, st2, req.getString("fil_codigo"), req.getString("req_codigo"));
                    }
                    catch (Exception e) {
                        try {
                            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaGuias: 1141");
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st2, st3);
                            throw throwable;
                        }
                        Conexao.fecharStatement(st2, st3);
                    }
                    Conexao.fecharStatement(st2, st3);
                }
            }
            this.tableExame.setRowSelectionInterval(linha, linha);
            ScreenUtil.requisitarFoco(this.tableExame);
        }
    }

    private void visualizarResultado() {
        boolean mostrar;
        Registro req = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
        int codigoRequisicao = Integer.valueOf(req.getString("req_codigo"));
        String codigoFilial = String.valueOf(req.getString("fil_codigo"));
        String nomePaciente = req.getString("pac_nome");
        DialogoResultadosAnteriores dialogo = DialogoResultadosAnteriores.novaInstancia(this.getTopLevelAncestor());
        if (this.isNotNull(dialogo) && (mostrar = dialogo.setRequisicao((Window)this.getTopLevelAncestor(), codigoFilial, nomePaciente, String.valueOf(codigoRequisicao)))) {
            dialogo.setVisible(true);
        }
    }

    private boolean isNotNull(DialogoResultadosAnteriores dialogo) {
        return dialogo != null;
    }

    private void imprimirResultado() {
        Integer linha = this.tableExame.getSelectedRow();
        Object exames = null;
        ArrayList<String> arrayExames = new ArrayList<String>();
        ArrayList<String> arrayMateriais = new ArrayList<String>();
        Registro r = this.modeloExame.getRegistro(this.tableExame.getSelectedRow());
        Registro req = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
        String codigoRequisicao = req.getString("req_codigo");
        String codigoFilial = req.getString("fil_codigo");
        arrayExames.add(r.getString("exa_codigo"));
        arrayMateriais.add(r.getString("mco_codigo"));
        try {
            RetornoImpressaoResultados retornoImpressaoResultados = ImpressaoResultados.imprimirExames(null, this.getTopLevelAncestor(), codigoFilial, codigoRequisicao, true, ParametrosGerais.getConferencia(), null, arrayExames != null ? arrayExames.toArray(new String[arrayExames.size()]) : null, arrayMateriais != null ? arrayMateriais.toArray(new String[arrayMateriais.size()]) : null, false, "", false, false, null, false, "", false, false, false);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FaturaExames (1896)");
        }
    }

    private void imprimirResultado(int[] linhas) {
        for (int i : linhas) {
            Object exames = null;
            Registro req = this.modeloRequisicao.getRegistro(i);
            Registro[] requisicaoExames = (Registro[])req.getValor("examesrequisicao");
            this.imprimirResultadoExames(requisicaoExames, req);
        }
    }

    private void imprimirResultadoExames(Registro[] requisicaoExames, Registro req) {
        ArrayList<String> arrayExames = new ArrayList<String>();
        ArrayList<String> arrayMateriais = new ArrayList<String>();
        for (Registro r : requisicaoExames) {
            if (!this.isNotNull(r) || !this.isConferidoImpresso(r.getString("exr_situacao"))) continue;
            arrayExames.add(r.getString("exa_codigo"));
            arrayMateriais.add(r.getString("mco_codigo"));
        }
        try {
            String codigoRequisicao = req.getString("req_codigo");
            String codigoFilial = req.getString("fil_codigo");
            RetornoImpressaoResultados retornoImpressaoResultados = ImpressaoResultados.imprimirExames(null, this.getTopLevelAncestor(), codigoFilial, codigoRequisicao, true, ParametrosGerais.getConferencia(), null, arrayExames != null ? arrayExames.toArray(new String[arrayExames.size()]) : null, arrayMateriais != null ? arrayMateriais.toArray(new String[arrayMateriais.size()]) : null, false, "", false, false, null, false, "", false, false, false);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FaturaExames (1896)");
        }
    }

    private boolean isNotNull(Registro r) {
        return r != null;
    }

    private boolean isConferidoImpresso(String situacao) {
        return situacao.equals("C") || situacao.equals("I");
    }

    private boolean linhaSelecionada() {
        return this.tableRequisicao.getSelectedRow() > -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void naoFaturar() {
        int linhaExame = this.tableExame.getSelectedRow();
        int linhaRequisicao = this.tableRequisicao.getSelectedRow();
        if (linhaExame <= -1 || linhaRequisicao <= -1) return;
        Registro r = this.modeloExame.getRegistro(linhaExame);
        Registro req = this.modeloRequisicao.getRegistro(linhaRequisicao);
        if (this.jaFaturado(r)) {
            Funcoes.mensagem(this, "O exame n\u00e3o pode ser alterado pois j\u00e1 foi faturado", 1);
        } else if (!Funcoes.textoVazio(r.getString("exr_situacao")) && r.getString("exr_situacao").equalsIgnoreCase("A")) {
            Funcoes.mensagem(this, "O exame n\u00e3o pode ser marcado para n\u00e3o faturar devido \u00e0 situa\u00e7\u00e3o de " + Tipos.tipoSituacaoExame(r.getString("exr_situacao")), 2);
        } else {
            Boolean faturar = !r.getBoolean("exr_naofaturar");
            Double valor = Double.parseDouble(Funcoes.limpaDecimal((String)req.getValor("valor")));
            if (r.getBoolean("agrupado")) {
                int resp = Funcoes.mensagem(this, "O exame \u00e9 agrupado. Todos os exames do agrupamento ser\u00e3o alterados.\nDeseja prosseguir com a altera\u00e7\u00e3o?", 4, true);
                if (resp != 0) return;
                String codigoExamePai = r.getString("codigoexamepai");
                for (int i = 0; i < this.tableExame.getRowCount(); ++i) {
                    r = this.modeloExame.getRegistro(i);
                    if (!r.getString("codigoexamepai").equalsIgnoreCase(codigoExamePai)) continue;
                    r.setValor("exr_naofaturar", faturar);
                    r.setValor("usr_codnaofaturar", r.getBoolean("exr_naofaturar") ? Variaveis.login : "");
                    req.setValor("gravardados", true);
                    r.setValor("gravardadosexame", true);
                    Double valorExame = Double.parseDouble(Funcoes.limpaDecimal((String)r.getValor("valortotalexame")));
                    valor = faturar == false ? Double.valueOf(valor + valorExame) : Double.valueOf(valor - valorExame);
                }
            } else {
                r.setValor("exr_naofaturar", faturar);
                r.setValor("usr_codnaofaturar", r.getBoolean("exr_naofaturar") ? Variaveis.login : "");
                req.setValor("gravardados", true);
                r.setValor("gravardadosexame", true);
                Double valorExame = Double.parseDouble(Funcoes.limpaDecimal((String)r.getValor("valortotalexame")));
                valor = faturar == false ? Double.valueOf(valor + valorExame) : Double.valueOf(valor - valorExame);
            }
            req.setValor("valor", Funcoes.formataDecimal(valor));
            FuncoesGerais.repaintTabela(this.tableRequisicao);
            FuncoesGerais.repaintTabela(this.tableExame);
        }
        this.tableRequisicao.setRowSelectionInterval(linhaRequisicao, linhaRequisicao);
        this.tableExame.setRowSelectionInterval(linhaExame, linhaExame);
        this.controlaMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validarApenasFaturamento() {
        List<Registro> registros = this.modeloRequisicao.getRegistros();
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            for (Registro r : registros) {
                Registro[] exames;
                if (!r.getBoolean("gravardados") || (exames = (Registro[])r.getValor("examesrequisicao")) == null) continue;
                for (Registro exame : exames) {
                    String situacao;
                    if (!exame.getBoolean("gravardadosexame") || !exame.getString("exr_situacao").equals("A")) continue;
                    buf.setLength(0);
                    buf.append("select exr_situacao from examerequisicao ");
                    buf.append("                   where fil_codigo = ").append(r.getString("fil_codigo"));
                    buf.append("                     and req_codigo = ").append(r.getString("req_codigo"));
                    buf.append("                     and exa_codigo = '").append(exame.getString("exa_codigo")).append("' ");
                    buf.append("                     and mco_codigo = ").append(exame.getString("mco_codigo"));
                    ResultSet rs = Conexao.executeQuery(st, buf);
                    if (!rs.next() || !(situacao = rs.getString(1)).equals("L") && !situacao.equals("C") && !situacao.equals("I") && !situacao.equals("E") && !situacao.equals("P")) continue;
                    Funcoes.mensagem(this, "O exame " + exame.getString("exa_descricao") + " da requisi\u00e7\u00e3o " + r.getString("req_codigo") + " j\u00e1 possui resultado.\nA situa\u00e7\u00e3o de Apenas faturamento n\u00e3o pode ser utilizada.\nA situa\u00e7\u00e3o ser\u00e1 alterada para " + Tipos.tipoSituacaoExame(situacao) + ".", 2);
                    exame.setValor("exr_situacao", situacao);
                }
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void deveGuia() {
        int linha = this.tableRequisicao.getSelectedRow();
        if (linha > -1) {
            Registro r = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
            if (r.getBoolean("req_deveguia")) {
                r.setValor("req_deveguia", false);
                r.setValor("req_datarecebeuguia", null);
                r.setValor("usr_codrecebeuguia", "");
                for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
                    Registro exame = this.modeloExame.getRegistro(i);
                    exame.setValor("exr_deveguia", false);
                    exame.setValor("gravardadosexame", true);
                }
            } else {
                r.setValor("req_deveguia", true);
                r.setValor("req_datarecebeuguia", new Date());
                r.setValor("usr_codrecebeuguia", Variaveis.login);
                for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
                    Registro exame = this.modeloExame.getRegistro(i);
                    exame.setValor("exr_deveguia", true);
                    exame.setValor("gravardadosexame", true);
                }
            }
            r.setValor("gravardados", true);
            this.modeloRequisicao.fireTableDataChanged();
            this.tableRequisicao.setRowSelectionInterval(linha, linha);
            ScreenUtil.requisitarFoco(this.tableRequisicao);
        }
    }

    private void codigoAutorizacao() {
        Registro r;
        int i;
        AutorizacaoExame telaAutorizacao = this.getTopLevelAncestor() instanceof Frame ? new AutorizacaoExame((Frame)this.getTopLevelAncestor(), true) : new AutorizacaoExame((Dialog)this.getTopLevelAncestor(), true);
        Date data = null;
        Date validade = null;
        DadosMaterial material = null;
        String autorizacao = "";
        String examePai = "";
        Registro req = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
        for (i = 0; i < this.modeloExame.getRowCount(); ++i) {
            r = this.modeloExame.getRegistro(i);
            try {
                data = r.getDate("exr_dataautorizacao");
                validade = r.getDate("exr_datavalidadeautorizacao");
                autorizacao = r.getString("exr_codautorizacao");
                examePai = r.getString("codigoexamepai");
                try {
                    material = ExameUtil.getDadosMaterial(req.getString("fil_codigo"), r.getInt("mco_codigo"));
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do material do exame.\n" + e.getMessage(), e.getStackTrace());
                }
            }
            catch (ParseException e1) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar data/validade da guia.\n" + e1.getMessage(), e1.getStackTrace());
                return;
            }
            telaAutorizacao.adicionarExames(this.modeloExame.getValueAt(i, 0).toString(), material, this.modeloExame.getValueAt(i, 1).toString(), autorizacao, data, validade, examePai);
        }
        if (telaAutorizacao.getCountExames() > 0) {
            if (this.tableExame.getSelectedRow() > -1) {
                String codigo = this.modeloExame.getValueAt(this.tableExame.getSelectedRow(), 0).toString();
                telaAutorizacao.setExameSelecionado(codigo, String.valueOf(material.getCodigo()));
            }
            telaAutorizacao.setVisible(true);
            for (i = 0; i < telaAutorizacao.getCountExames(); ++i) {
                r = this.modeloExame.getRegistro(i);
                r.setValor("exr_codautorizacao", telaAutorizacao.getAutorizacao(i));
                r.setValor("exr_dataautorizacao", telaAutorizacao.getData(i));
                r.setValor("exr_datavalidadeautorizacao", telaAutorizacao.getValidade(i));
                req.setValor("gravardados", true);
                r.setValor("gravardadosexame", true);
                this.tableExame.setRowSelectionInterval(i, i);
            }
            ScreenUtil.requisitarFoco(this.tableExame);
        }
    }

    private void imprimirComprovante() {
        if (this.tableRequisicao.getSelectedRow() > -1) {
            final Registro r = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
            new Thread("Thread - imprimir comprovante"){

                @Override
                public void run() {
                    try {
                        Impressao.imprimirComprovante(r.getString("fil_codigo"), r.getString("req_codigo"));
                        Conexao.arquivaSQL();
                    }
                    catch (IOException | SQLException ex) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (SQLException ec) {
                            ec.printStackTrace();
                        }
                        ErrorLogger.mostraMensagem(ConferenciaGuias.this, ex.getMessage(), ex.getStackTrace(), "ConferenciaGuias (295)");
                    }
                }
            }.start();
        }
    }

    private void imprimirRecibo() {
        if (this.tableRequisicao.getSelectedRow() > -1) {
            final Registro r = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
            new Thread("Thread - imprimir recibo"){

                @Override
                public void run() {
                    try {
                        Impressao.imprimirRecibo(r.getString("fil_codigo"), r.getString("req_codigo"));
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(ConferenciaGuias.this, ex.getMessage(), ex.getStackTrace(), "ConferenciaGuias (313)");
                    }
                }
            }.start();
        }
    }

    private void imprimirAnexo() {
        if (this.tableRequisicao.getSelectedRow() > -1) {
            final Registro r = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
            new Thread("Thread - imprimir anexo"){

                @Override
                public void run() {
                    try {
                        Impressao.imprimirAnexo(r.getString("fil_codigo"), r.getString("req_codigo"));
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(ConferenciaGuias.this, ex.getMessage(), ex.getStackTrace(), "ConferenciaGuias (313)");
                    }
                }
            }.start();
        }
    }

    private void imprimirAnexoCobranca() {
        if (this.tableRequisicao.getSelectedRow() > -1) {
            final Registro r = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
            new Thread("Thread - imprimir anexo de cobran\u00e7a"){

                @Override
                public void run() {
                    try {
                        Impressao.imprimirAnexoCobranca(r.getString("fil_codigo"), r.getString("req_codigo"));
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(ConferenciaGuias.this, ex.getMessage(), ex.getStackTrace());
                    }
                }
            }.start();
        }
    }

    private void imprimirGuia(int tipoGuia) {
        if (this.tableRequisicao.getSelectedRow() > -1) {
            final Registro r = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
            final int guiaExame = tipoGuia;
            if (r.getBoolean("req_deveguia")) {
                Funcoes.mensagem(this.getTopLevelAncestor(), "A requisi\u00e7\u00e3o est\u00e1 com a guia devedora", 2);
            } else {
                new Thread("Thread - imprimir guia"){

                    @Override
                    public void run() {
                        try {
                            int resp = Funcoes.mensagem(ConferenciaGuias.this, "A requisi\u00e7\u00e3o deve ser salva antes da impress\u00e3o.\nDeseja salvar?", 4);
                            if (resp != 0) {
                                return;
                            }
                            r.setValor("gravardados", true);
                            ConferenciaGuias.this.salvarRequisicao(r);
                            Impressao.imprimirGuia(Laboratorio.getInstancia(), r.getString("fil_codigo"), r.getString("req_codigo"), false, guiaExame);
                        }
                        catch (SQLException ex) {
                            ErrorLogger.mostraMensagem(ConferenciaGuias.this, ex.getMessage(), ex.getStackTrace(), "ConferenciaGuias (343)");
                        }
                    }
                }.start();
            }
        }
    }

    private void perguntarTitular() {
        int linha = this.tableRequisicao.getSelectedRow();
        if (linha > -1) {
            Registro r = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
            PedirTitular pedirTitular = this.getTopLevelAncestor() instanceof Dialog ? new PedirTitular((Dialog)this.getTopLevelAncestor()) : new PedirTitular((Frame)this.getTopLevelAncestor());
            if (Funcoes.textoVazio(r.getString("req_titular"))) {
                pedirTitular.setTitular(r.getString("pac_nome"));
            } else {
                pedirTitular.setTitular(r.getString("req_titular"));
            }
            pedirTitular.setAlterarTitular(this.ACESSO_TITULAR);
            pedirTitular.setVisible(true);
            r.setValor("req_titular", pedirTitular.getTitular());
            r.setValor("gravardados", true);
            pedirTitular.dispose();
            this.modeloRequisicao.fireTableDataChanged();
            this.tableRequisicao.setRowSelectionInterval(linha, linha);
        }
    }

    private void conferir(int linha, boolean atualizar) {
        Registro r;
        if (linha > -1 && (r = this.modeloRequisicao.getRegistro(linha)) != null) {
            r.setValor("gravarConferido", true);
            r.setValor("gravardados", true);
            r.setValor("removerconferencia", false);
            if (atualizar) {
                this.modeloRequisicao.fireTableDataChanged();
                this.tableRequisicao.revalidate();
                this.tableRequisicao.setRowSelectionInterval(linha, linha);
                ScreenUtil.requisitarFoco(this.tableRequisicao);
            }
        }
        this.controlaBotoes(false);
    }

    private void adicionaGrid(Registro r, boolean devolverFoco) {
        if (r != null && this.naoContemRequisicao(this.modeloRequisicao, r)) {
            int colunaOrdernada = this.modeloRequisicao.getColunaOrdenada();
            if (r.getValor("examesrequisicao") == null) {
                return;
            }
            this.modeloRequisicao.addRegistro(r);
            this.modeloRequisicao.ordenarColunaSemMudarSentido(colunaOrdernada);
            for (int i = 0; i < this.modeloRequisicao.getRowCount(); ++i) {
                if (this.modeloRequisicao.getRegistro(i) != r) continue;
                this.tableRequisicao.setRowSelectionInterval(i, i);
                this.tableRequisicao.scrollRectToVisible(this.tableRequisicao.getCellRect(i, 0, false));
                break;
            }
        }
        this.controlaBotoes(false);
        this.controlaMenu();
        if (devolverFoco) {
            this.textRequisicao.clear();
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
    }

    private boolean naoContemRequisicao(ModeloResultSet modeloRequisicao, Registro r) {
        boolean contemRequisicao = modeloRequisicao.contemValor("req_codigo", r.getString("req_codigo"));
        boolean contemFilial = modeloRequisicao.contemValor("fil_codigo", r.getString("fil_codigo"));
        if (!contemRequisicao) {
            return true;
        }
        return contemRequisicao && !contemFilial;
    }

    private void filtrar() {
        DialogoFiltroGuias dialogo = DialogoFiltroGuias.novaInstancia(this.getTopLevelAncestor());
        dialogo.setLocationRelativeTo(this.getTopLevelAncestor());
        dialogo.setVisible(true);
        if (dialogo.getOk()) {
            this.setCursor(new Cursor(3));
            SplashMensagem splashMensagem = SplashMensagem.getInstancia(this);
            splashMensagem.mostrar("Carregando requisi\u00e7\u00f5es... 0%");
            List<Registro> registros = dialogo.getRequisicoesSelecionados();
            int qtde = registros.size();
            int i = 0;
            for (Registro r : registros) {
                int perc = 100 * ++i / qtde;
                splashMensagem.setText("Carregando requisi\u00e7\u00f5es... " + perc + "%");
                if (this.modeloRequisicao.contemValor("req_codigo", r.getString("req_codigo"))) continue;
                this.adicionaGrid(this.buscaRequisicao(r), false);
                this.tableRequisicao.revalidate();
            }
            this.setCursor(new Cursor(0));
            splashMensagem.apagar();
            if (this.tableRequisicao.getRowCount() > 0) {
                this.tableRequisicao.setRowSelectionInterval(0, 0);
                ScreenUtil.requisitarFoco(this.tableRequisicao);
            }
            this.controlaBotoes(false);
        }
    }

    private Registro buscaRequisicao(Registro r) {
        if (r.possuiCampo("req_codigo") && r.possuiCampo("fil_codigo")) {
            return this.buscaRequisicao(r.getString("fil_codigo"), r.getString("req_codigo"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Registro buscaRequisicao(String filial, String codigo) {
        Statement st;
        Registro retorno;
        block27: {
            if (!Funcoes.isNumeric(codigo)) {
                return null;
            }
            DadosFaturamento requisicao = new DadosFaturamento();
            retorno = null;
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            try {
                buf.append(" select a.req_codigo ");
                buf.append("       ,a.fil_codigo ");
                buf.append("       ,b.pac_nome ");
                buf.append("       ,c.con_fantasia ");
                buf.append("       ,a.req_dataguiaconferida ");
                buf.append("       ,a.usr_codguiaconferida ");
                buf.append("       ,d.med_nome ");
                buf.append("       ,(a.req_dataguiaconferida is not null) as guiaConferida ");
                buf.append("       ,false as gravarConferido ");
                buf.append("       ,a.req_deveguia ");
                buf.append("       ,c.con_codigo ");
                buf.append("       ,c.con_examesporguia ");
                buf.append("       ,c.con_codigoguia ");
                buf.append("       ,c.con_validadeguia ");
                buf.append("       ,a.req_titular ");
                buf.append("       ,a.req_datarecebeuguia ");
                buf.append("       ,a.usr_codrecebeuguia ");
                buf.append("       ,a.req_deveguia as deviaguia ");
                buf.append("       ,(a.req_dataguiaconferida is null) as removerConferencia ");
                buf.append("       ,a.req_matricula ");
                buf.append("       ,a.req_guia ");
                buf.append("       ,a.sit_codigo ");
                buf.append("       ,e.sit_descricao ");
                buf.append("       ,a.req_data ");
                buf.append("       ,a.req_dtfatura ");
                buf.append("       ,a.usr_codigo ");
                buf.append("       ,a.req_dataguia ");
                buf.append("       ,a.req_validadeguia ");
                buf.append("       ,a.req_token");
                buf.append("       ,c.con_diasvalidade ");
                buf.append("       ,c.con_exigirtoken ");
                buf.append("       ,c.con_mascaratoken ");
                buf.append("       ,a.req_guiaprincipal ");
                buf.append("       ,rep.con_codigo as codigoRepasse");
                buf.append("       ,rep.con_fantasia as convenioRepasse");
                buf.append("       ,uns.uns_codigo ");
                buf.append("       ,uns.uns_descricao ");
                buf.append("   from requisicao \t\t\t\t\t\ta ");
                buf.append("   left join paciente \t\t\t\tb \ton a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
                buf.append("   left join convenios \t\t\t\tc \ton a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
                buf.append("   left join medico \t\t\t\t\td \ton a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and a.med_crm = d.med_crm and a.med_uf = d.med_uf ");
                buf.append("   left join situacao \t\t\t\te \ton a.fil_codigo = e.fil_codigo and a.sit_codigo = e.sit_codigo ");
                buf.append("   left join convenios\t\t\t\trep on a.fil_codigo = rep.fil_codigo and a.con_codrepasse = rep.con_codigo ");
                buf.append("   left join unidadesaude     uns on a.fil_codigo = uns.fil_codigo and a.uns_codigo = uns.uns_codigo ");
                buf.append("  where a.fil_codigo = ").append(filial);
                buf.append("    and a.req_codigo = ").append(codigo);
                buf.append("    and a.req_excluida = false ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (rs.next()) {
                    retorno = new Registro(rs);
                    retorno.setValor("req_codigo", rs.getString("req_codigo"));
                    retorno.setValor("gravardados", false);
                    buf.setLength(0);
                    buf.append(" select a.exa_codigo ");
                    buf.append("       ,a.mco_codigo ");
                    buf.append("       ,a.exr_situacao ");
                    buf.append("       ,a.exr_codautorizacao ");
                    buf.append("       ,a.exr_dataautorizacao ");
                    buf.append("       ,a.exr_datavalidadeautorizacao ");
                    buf.append("       ,b.exa_descricao ");
                    buf.append("       ,b.exa_tipobpa");
                    buf.append("       ,c.mco_abreviatura ");
                    buf.append("       ,a.exr_naofaturar ");
                    buf.append("       ,a.usr_codnaofaturar ");
                    buf.append("       ,a.exr_datafatura ");
                    buf.append("       ,a.exr_validadeguia ");
                    buf.append("       ,a.exr_dataguia ");
                    buf.append("       ,a.exr_guia ");
                    buf.append("       ,a.exr_deveguia ");
                    buf.append("       ,d.con_examesporguia ");
                    buf.append("       ,d.con_codigoguia ");
                    buf.append("       ,d.con_validadeguia ");
                    buf.append(" \t\t\t ,count(COALESCE(agr.exa_codigo, agr2.exa_codigo)) as agrupamento ");
                    buf.append("   from examerequisicao \t\t\t\t\t\t\ta ");
                    buf.append("   left join exames\t \t\t\t\t\t\t\t\t\tb \t\ton a.fil_codigo \t\t= b.fil_codigo \t\tand a.exa_codigo \t\t= b.exa_codigo ");
                    buf.append("   left join materialcoleta \t\t\t\t\tc \t\ton a.fil_codigo \t\t= c.fil_codigo \t\tand a.mco_codigo \t\t= c.mco_codigo ");
                    buf.append("   left join examematcoleta \t\t\t\t\tg \t\ton a.fil_codigo \t\t= g.fil_codigo \t\tand a.exa_codigo \t\t= g.exa_codigo \t\tand a.mco_codigo \t\t= g.mco_codigo ");
                    buf.append("   left join examesetor \t\t\t\t\t\t\th \t\ton b.fil_codigo \t\t= h.fil_codigo \t\tand b.exa_codigo \t\t= h.exa_codigo \t\tand h.ese_default \t= true ");
                    buf.append("   left join requisicao \t\t\t        r     on a.fil_codigo     = r.fil_codigo    and a.req_codigo    = r.req_codigo ");
                    buf.append("   left join convenios \t\t\t\t        d     on r.fil_codigo     = d.fil_codigo    and r.con_codigo    = d.con_codigo ");
                    buf.append("   left join agrupaexameconvenio \t\t\taec  \ton a.fil_codigo  \t = aec.fil_codigo  and a.exa_codigo  \t = aec.exa_codigo  and a.mco_codigo  \t = aec.mco_codigo  and d.con_codigo  \t = aec.con_codigo  and aec.aec_tipo \t= '").append("F").append("' ");
                    buf.append("   left join agrupaexameconvenio \t\t\taec2 \ton a.fil_codigo  \t = aec2.fil_codigo and a.exa_codigo    = aec2.exa_codigo and a.mco_codigo    = aec2.mco_codigo and aec2.aec_tipo   = '").append("F").append("' and aec2.aec_ignorarconvenio = true ");
                    buf.append("   left join exameagrupaexameconvenio agr  \ton aec.fil_codigo  = agr.fil_codigo  and aec.exa_codigo  = agr.exa_codigo  and aec.mco_codigo  = agr.mco_codigo  and aec.con_codigo  = agr.con_codigo  and agr.aec_tipo \t= '").append("F").append("' ");
                    buf.append("   left join exameagrupaexameconvenio agr2 \ton aec2.fil_codigo = agr2.fil_codigo and aec2.exa_codigo = agr2.exa_codigo and aec2.mco_codigo = agr2.mco_codigo and aec2.con_codigo = agr2.con_codigo and agr2.aec_tipo = '").append("F").append("' and agr.fil_codigo IS NULL ");
                    buf.append("  where a.fil_codigo = ").append(filial);
                    buf.append("    and a.req_codigo = ").append(codigo);
                    buf.append("    and a.exr_excluido = false ");
                    buf.append("  group by a.exa_codigo ");
                    buf.append("       \t\t,a.mco_codigo ");
                    buf.append("       \t\t,a.exr_situacao ");
                    buf.append("      \t\t,a.exr_codautorizacao ");
                    buf.append("          ,a.exr_dataautorizacao ");
                    buf.append("          ,a.exr_datavalidadeautorizacao ");
                    buf.append("       \t\t,b.exa_descricao ");
                    buf.append("          ,b.exa_tipobpa");
                    buf.append("       \t\t,c.mco_abreviatura ");
                    buf.append("       \t\t,a.exr_naofaturar ");
                    buf.append("       \t\t,a.usr_codnaofaturar ");
                    buf.append("       \t\t,a.exr_datafatura ");
                    buf.append("          ,a.exr_dataguia ");
                    buf.append("       \t\t,a.exr_validadeguia ");
                    buf.append("       \t\t,a.exr_guia ");
                    buf.append("       \t\t,a.exr_deveguia ");
                    buf.append("          ,d.con_examesporguia ");
                    buf.append("          ,d.con_codigoguia ");
                    buf.append("          ,d.con_validadeguia ");
                    buf.append("       \t\t,a.exr_ordem ");
                    buf.append("          ,h.set_codigo ");
                    buf.append("          ,g.emc_pagina ");
                    buf.append("          ,g.emc_ordem ");
                    buf.append("  order by ");
                    if (ParametrosGerais.getOrdemComprovante().equals("A")) {
                        buf.append(" a.exr_ordem ");
                    } else {
                        String adicionar = "";
                        if (ParametrosGerais.getOrdenarSetor()) {
                            buf.append(" h.set_codigo ");
                            adicionar = ",";
                        }
                        if (ParametrosGerais.getOrdemComprovante().equals("C")) {
                            buf.append(adicionar).append(" a.exa_codigo ");
                        } else if (ParametrosGerais.getOrdemComprovante().equals("P")) {
                            buf.append(adicionar).append(" g.emc_pagina, g.emc_ordem, a.exa_codigo, a.mco_codigo ");
                        }
                    }
                    rs = Conexao.executeQuery(st, buf);
                    ArrayList<Registro> registros = new ArrayList<Registro>();
                    while (rs.next()) {
                        DadosExameFaturamento exameFat;
                        DadosConvenios convenio;
                        DadosExames exame;
                        DadosMaterial mat;
                        Registro r;
                        ResultSet rsAgrupa;
                        Statement stAgrupa;
                        StringBuilder agrupa;
                        ExameUtil.corrigeAgrupamentoExame(Integer.parseInt(filial), Integer.parseInt(codigo), rs.getString("exa_codigo"), rs.getInt("mco_codigo"), retorno.getInt("con_codigo"));
                        if (rs.getInt("agrupamento") > 0) {
                            agrupa = new StringBuilder();
                            agrupa.append(" select a.exa_kodigo as exa_codigo ");
                            agrupa.append("       ,d.mco_abreviatura as mco_abreviatura ");
                            agrupa.append("       ,b.exa_descricao as exa_descricao ");
                            agrupa.append("       ,exg.exg_guia as exr_guia ");
                            agrupa.append("       ,exg.exg_validadeguia as exr_validadeguia ");
                            agrupa.append("       ,exg.exg_dataguia as exr_dataguia ");
                            agrupa.append("       ,c.mco_codigo ");
                            agrupa.append("       ,exr.exr_codautorizacao ");
                            agrupa.append("       ,exr.exr_dataautorizacao ");
                            agrupa.append("       ,exr.exr_datavalidadeautorizacao ");
                            agrupa.append("       ,exg.exg_deveguia as exr_deveguia ");
                            agrupa.append("       ,COALESCE(exr.met_codigo, c.met_codigo) as codigoMetodo");
                            agrupa.append("   from exameagrupaexameconvenio a ");
                            agrupa.append("   left join exames              b on a.fil_codigo = b.fil_codigo and a.exa_kodigo = b.exa_codigo ");
                            agrupa.append("   left join examematcoleta      c on a.fil_codigo = c.fil_codigo and a.exa_kodigo = c.exa_codigo and a.mco_kodigo = c.mco_codigo ");
                            agrupa.append("   left join materialcoleta \t\t\td on a.fil_codigo = d.fil_codigo and c.mco_codigo = d.mco_codigo ");
                            agrupa.append("   left join examerequisicaoguiaagrupada exg on a.fil_codigo = exg.fil_codigo and a.exa_kodigo = exg.exa_codfilho and a.mco_kodigo = exg.mco_codfilho and a.exa_codigo = exg.exa_codigo and a.mco_codigo = exg.mco_codigo ");
                            agrupa.append("   left join examerequisicao     exr on a.fil_codigo = exr.fil_codigo and a.exa_codigo = exr.exa_codigo and a.mco_codigo = exr.mco_codigo and exg.req_codigo = exr.req_codigo ");
                            agrupa.append("   left join convenios           con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
                            agrupa.append("  where a.fil_codigo = ").append(filial);
                            agrupa.append("    and a.exa_codigo = '").append(rs.getString("exa_codigo")).append("' ");
                            agrupa.append("    and a.mco_codigo = ").append(rs.getString("mco_codigo"));
                            agrupa.append("    and a.aec_tipo   = '").append("F").append("' ");
                            agrupa.append("    and a.con_codigo = ").append(String.valueOf(retorno.getInt("con_codigo")));
                            agrupa.append("    and exg.req_codigo = ").append(codigo);
                            stAgrupa = Conexao.getStatement();
                            rsAgrupa = stAgrupa.executeQuery(agrupa.toString());
                            if (rsAgrupa.next()) {
                                rsAgrupa.beforeFirst();
                            } else {
                                agrupa.delete(0, agrupa.length());
                                agrupa.append(" select eae.exa_kodigo as exa_codigo ");
                                agrupa.append("       ,d.mco_abreviatura as mco_abreviatura ");
                                agrupa.append("       ,b.exa_descricao as exa_descricao ");
                                agrupa.append("       ,exg.exg_guia as exr_guia ");
                                agrupa.append("       ,exg.exg_validadeguia as exr_validadeguia ");
                                agrupa.append("       ,exg.exg_dataguia as exr_dataguia ");
                                agrupa.append("       ,c.mco_codigo ");
                                agrupa.append("       ,exg.exg_deveguia as exr_deveguia ");
                                agrupa.append("       ,COALESCE(exr.met_codigo, c.met_codigo) as codigoMetodo");
                                agrupa.append("   from agrupaexameconvenio a ");
                                agrupa.append("   join exameagrupaexameconvenio eae on a.fil_codigo = eae.fil_codigo and a.exa_codigo = eae.exa_codigo and a.mco_codigo = eae.mco_codigo and eae.aec_tipo = '").append("F").append("' and a.con_codigo = eae.con_codigo ");
                                agrupa.append("   left join exames              b on eae.fil_codigo = b.fil_codigo and eae.exa_kodigo = b.exa_codigo ");
                                agrupa.append("   left join examematcoleta      c on eae.fil_codigo = c.fil_codigo and eae.exa_kodigo = c.exa_codigo and eae.mco_kodigo = c.mco_codigo ");
                                agrupa.append("   left join materialcoleta \t\t\td on a.fil_codigo = d.fil_codigo and c.mco_codigo = d.mco_codigo ");
                                agrupa.append("   left join examerequisicaoguiaagrupada exg on a.fil_codigo = exg.fil_codigo and eae.exa_kodigo = exg.exa_codfilho and eae.mco_kodigo = exg.mco_codfilho and a.exa_codigo = exg.exa_codigo and a.mco_codigo = exg.mco_codigo ");
                                agrupa.append("   left join examerequisicao     exr on a.fil_codigo = exr.fil_codigo and a.exa_codigo = exr.exa_codigo and a.mco_codigo = exr.mco_codigo and exg.req_codigo = exr.req_codigo ");
                                agrupa.append("   left join convenios           con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
                                agrupa.append("  where a.fil_codigo = ").append(filial);
                                agrupa.append("    and a.exa_codigo = '").append(rs.getString("exa_codigo")).append("' ");
                                agrupa.append("    and a.mco_codigo = ").append(rs.getString("mco_codigo"));
                                agrupa.append("    and a.aec_tipo   = '").append("F").append("' ");
                                agrupa.append("    and a.aec_ignorarconvenio = true ");
                                agrupa.append("    and exg.req_codigo = ").append(codigo);
                                rsAgrupa = stAgrupa.executeQuery(agrupa.toString());
                            }
                            while (rsAgrupa.next()) {
                                r = new Registro(rsAgrupa);
                                mat = ExameUtil.getDadosMaterial(filial, r.getInt("mco_codigo"));
                                exame = ExameUtil.getDadosExame(filial, r.getString("exa_codigo"), mat);
                                convenio = ConvenioUtil.getDadosConvenios(filial, retorno.getInt("con_codigo"));
                                int p = ExameUtil.calculaPrecoExame(filial, exame, mat, convenio, false, true, false, Integer.parseInt(codigo), null, rsAgrupa.getInt("codigoMetodo"));
                                r.setValor("codigoAMB", ExameUtil.getCodigoAMB(filial, exame.getCodigo(), mat.getCodigo(), retorno.getInt("con_codigo"), retorno.getInt("codigoMetodo")));
                                r.setValor("valortotalexame", Funcoes.formataDecimal(exame.getValor().doubleValue()));
                                r.setValor("exr_validadeguia", Funcoes.formataData("dd/MM/yyyy", rsAgrupa.getDate("exr_validadeguia")));
                                r.setValor("exr_dataguia", Funcoes.formataData("dd/MM/yyyy", rs.getDate("exr_dataguia")));
                                r.setValor("exr_deveguia", rsAgrupa.getString("exr_deveguia") == null ? rs.getBoolean("exr_deveguia") : rsAgrupa.getBoolean("exr_deveguia"));
                                r.setValor("gravardadosexame", false);
                                r.setValor("agrupado", true);
                                r.setValor("codigoexamepai", rs.getString("exa_codigo"));
                                r.setValor("materialexamepai", rs.getInt("mco_codigo"));
                                r.setValor("exr_situacao", rs.getString("exr_situacao"));
                                r.setValor("exr_naofaturar", exame.getNaoFaturar() || rs.getBoolean("exr_naofaturar"));
                                exameFat = this.getExameFaturamento(exame, mat, convenio, p, r, rs);
                                if (exameFat == null) continue;
                                exameFat.setFaturar(!rs.getBoolean("exr_naofaturar"));
                                exameFat.setCodigoUsuarioNaoFaturar(rs.getBoolean("exr_naofaturar") ? Variaveis.login : "");
                                exameFat.setTipoBPA(rs.getString("exa_tipobpa"));
                                requisicao.adicionaExame(exameFat);
                                registros.add(r);
                            }
                            continue;
                        }
                        agrupa = new StringBuilder();
                        agrupa.append(" select eae.exa_kodigo as exa_codigo ");
                        agrupa.append("   from agrupaexameconvenio \t\t\ta ");
                        agrupa.append("   join exameagrupaexameconvenio eae on a.fil_codigo = eae.fil_codigo and a.exa_codigo = eae.exa_codigo and eae.aec_tipo = '").append("F").append("' and a.con_codigo = eae.con_codigo and a.mco_codigo = eae.mco_codigo ");
                        agrupa.append("  where a.fil_codigo = ").append(filial);
                        agrupa.append("    and a.con_codigo = ").append(String.valueOf(retorno.getInt("con_codigo")));
                        agrupa.append("    and a.exa_codigo = '").append(rs.getString("exa_codigo")).append("' ");
                        agrupa.append("    and a.aec_tipo   = '").append("F").append("' ");
                        agrupa.append("    and a.aec_ignorarmaterial = true ");
                        stAgrupa = Conexao.getStatement();
                        rsAgrupa = null;
                        rsAgrupa = stAgrupa.executeQuery(agrupa.toString());
                        if (rsAgrupa.next()) {
                            rsAgrupa.beforeFirst();
                        } else {
                            agrupa.delete(0, agrupa.length());
                            agrupa.append(" select eae.exa_kodigo as exa_codigo ");
                            agrupa.append("       ,eae.mco_kodigo as mco_codigo ");
                            agrupa.append("   from agrupaexameconvenio \t\t\ta ");
                            agrupa.append("   join exameagrupaexameconvenio eae on a.fil_codigo = eae.fil_codigo and a.exa_codigo = eae.exa_codigo and eae.aec_tipo = '").append("F").append("' and a.con_codigo = eae.con_codigo and a.mco_codigo = eae.mco_codigo ");
                            agrupa.append("  where a.fil_codigo = ").append(filial);
                            agrupa.append("    and a.aec_ignorarconvenio = true ");
                            agrupa.append("    and a.exa_codigo = '").append(rs.getString("exa_codigo")).append("' ");
                            agrupa.append("    and a.aec_tipo   = '").append("F").append("' ");
                            agrupa.append("    and a.aec_ignorarmaterial = true ");
                            stAgrupa = Conexao.getStatement();
                            rsAgrupa = stAgrupa.executeQuery(agrupa.toString());
                        }
                        if (rsAgrupa.next()) {
                            do {
                                String codigoFilial = filial;
                                DadosConvenios convenio2 = ConvenioUtil.getDadosConvenios(codigoFilial, retorno.getInt("con_codigo"));
                                agrupa.delete(0, agrupa.length());
                                agrupa.append(" select a.mco_codigo ");
                                agrupa.append("   from examematcoleta a ");
                                agrupa.append("  where a.fil_codigo = ").append(filial);
                                agrupa.append("    and a.exa_codigo = '").append(rsAgrupa.getString("exa_codigo")).append("' ");
                                agrupa.append("    and a.mco_codigo = ").append(rs.getInt("mco_codigo"));
                                Statement stMaterial = Conexao.getStatement();
                                ResultSet rsMaterial = Conexao.executeQuery(stMaterial, agrupa.toString());
                                DadosMaterial mat2 = null;
                                DadosExames exame2 = null;
                                if (rsMaterial.next()) {
                                    mat2 = ExameUtil.getDadosMaterial(codigoFilial, rsMaterial.getInt("mco_codigo"));
                                    exame2 = ExameUtil.getDadosExame(codigoFilial, rsAgrupa.getString("exa_codigo"), mat2);
                                } else {
                                    agrupa.delete(0, agrupa.length());
                                    agrupa.append(" select a.mco_codigo ");
                                    agrupa.append("   from examematcoleta a ");
                                    agrupa.append("  where a.fil_codigo = ").append(filial);
                                    agrupa.append("    and a.exa_codigo = '").append(rsAgrupa.getString("exa_codigo")).append("' ");
                                    agrupa.append("    and a.emc_default = true ");
                                    rsMaterial = Conexao.executeQuery(stMaterial, agrupa.toString());
                                    if (!rsMaterial.next()) {
                                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Material padr\u00e3o do exame " + rsAgrupa.getString("exa_codigo") + " n\u00e3o encontrado.", null);
                                        continue;
                                    }
                                    mat2 = ExameUtil.getDadosMaterial(codigoFilial, rsMaterial.getInt("mco_codigo"));
                                    exame2 = ExameUtil.getDadosExame(codigoFilial, rsAgrupa.getString("exa_codigo"), mat2);
                                }
                                StringBuilder bufGuia = new StringBuilder();
                                bufGuia.append(" select exg.exg_guia ");
                                bufGuia.append("       ,exg.exg_validadeguia ");
                                bufGuia.append("       ,exg.exg_dataguia ");
                                bufGuia.append("       ,exg.exg_deveguia ");
                                bufGuia.append("       ,COALESCE(exr.met_codigo, emc.met_codigo) as codigoMetodo ");
                                bufGuia.append("   from examerequisicaoguiaagrupada exg ");
                                bufGuia.append("   join examerequisicao exr on exr.fil_codigo = exg.fil_codigo and exr.req_codigo = exg.req_codigo and exr.exa_codigo = exg.exa_codigo and exr.mco_codigo = exg.mco_codigo ");
                                bufGuia.append("   join examematcoleta emc on exg.fil_codigo = emc.fil_codigo and exg.exa_codfilho = emc.exa_codigo and exg.mco_codfilho = emc.mco_codigo ");
                                bufGuia.append("   join requisicao req on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
                                bufGuia.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
                                bufGuia.append("  where exg.fil_codigo = ").append(filial);
                                bufGuia.append("    and exg.req_codigo = ").append(codigo);
                                bufGuia.append("    and exg.exa_codigo = '").append(rs.getString("exa_codigo")).append("' ");
                                bufGuia.append("    and exg.mco_codigo = ").append(rs.getInt("mco_codigo"));
                                bufGuia.append("    and exg.exa_codfilho = '").append(exame2.getCodigo()).append("' ");
                                bufGuia.append("    and exg.mco_codfilho = ").append(mat2.getCodigo());
                                ResultSet rsGuia = Conexao.executeQuery(Conexao.getStatement(), bufGuia.toString());
                                String guia = "";
                                java.sql.Date validadeGuia = null;
                                java.sql.Date dataGuia = null;
                                Boolean deveGuia = false;
                                Integer codigoMetodologia = null;
                                if (rsGuia.next()) {
                                    guia = rsGuia.getString("exg_guia");
                                    validadeGuia = rsGuia.getDate("exg_validadeguia");
                                    dataGuia = rsGuia.getDate("exg_dataguia");
                                    deveGuia = rsGuia.getString("exg_deveguia") == null ? rs.getBoolean("exr_deveguia") : rsGuia.getBoolean("exg_deveguia");
                                    codigoMetodologia = rsGuia.getString("codigoMetodo") == null ? null : Integer.valueOf(rsGuia.getInt("codigoMetodo"));
                                }
                                Registro r2 = new Registro(rs);
                                int p = ExameUtil.calculaPrecoExame(filial, exame2, mat2, convenio2, true, true, false, Integer.parseInt(codigo), null, codigoMetodologia);
                                r2.setValor("exa_codigo", exame2.getCodigo());
                                r2.setValor("mco_abreviatura", mat2.getAbreviatura());
                                r2.setValor("exa_descricao", exame2.getDescricao());
                                r2.setValor("mco_codigo", mat2.getCodigo());
                                r2.setValor("exr_situacao", rs.getString("exr_situacao"));
                                r2.setValor("exr_guia", guia);
                                r2.setValor("exr_validadeguia", Funcoes.formataData("dd/MM/yyyy", validadeGuia));
                                r2.setValor("exr_dataguia", Funcoes.formataData("dd/MM/yyyy", dataGuia));
                                r2.setValor("exr_deveguia", deveGuia);
                                r2.setValor("codigoexamepai", rs.getString("exa_codigo"));
                                r2.setValor("materialexamepai", rs.getInt("mco_codigo"));
                                r2.setValor("codigoAMB", ExameUtil.getCodigoAMB(filial, exame2.getCodigo(), mat2.getCodigo(), retorno.getInt("con_codigo"), codigoMetodologia));
                                r2.setValor("valortotalexame", Funcoes.formataDecimal(exame2.getValor().doubleValue()));
                                r2.setValor("gravardadosexame", false);
                                r2.setValor("agrupado", true);
                                r2.setValor("exr_naofaturar", exame2.getNaoFaturar() || rs.getBoolean("exr_naofaturar"));
                                DadosExameFaturamento exameFat2 = this.getExameFaturamento(exame2, mat2, convenio2, p, r2, rs);
                                if (exameFat2 == null) continue;
                                exameFat2.setFaturar(!rs.getBoolean("exr_naofaturar"));
                                exameFat2.setCodigoUsuarioNaoFaturar(rs.getBoolean("exr_naofaturar") ? Variaveis.login : "");
                                requisicao.adicionaExame(exameFat2);
                                registros.add(r2);
                            } while (rsAgrupa.next());
                            continue;
                        }
                        r = new Registro(rs);
                        mat = ExameUtil.getDadosMaterial(filial, r.getInt("mco_codigo"));
                        exame = ExameUtil.getDadosExame(filial, r.getString("exa_codigo"), mat);
                        convenio = ConvenioUtil.getDadosConvenios(filial, retorno.getInt("con_codigo"));
                        int p = ExameUtil.calculaPrecoExame(filial, exame, mat, convenio, false, true, false, Integer.parseInt(codigo), null, Integer.parseInt(exame.getCodMetodo()));
                        r.setValor("codigoAMB", ExameUtil.getCodigoAMB(filial, exame.getCodigo(), mat.getCodigo(), retorno.getInt("con_codigo"), Integer.parseInt(exame.getCodMetodo())));
                        r.setValor("valortotalexame", Funcoes.formataDecimal(exame.getValor().doubleValue()));
                        r.setValor("exr_validadeguia", Funcoes.formataData("dd/MM/yyyy", r.getDate("exr_validadeguia")));
                        r.setValor("exr_dataguia", Funcoes.formataData("dd/MM/yyyy", r.getDate("exr_dataguia")));
                        r.setValor("exr_deveguia", r.getBoolean("exr_deveguia"));
                        r.setValor("gravardadosexame", false);
                        r.setValor("agrupado", false);
                        r.setValor("exr_naofaturar", exame.getNaoFaturar() || r.getBoolean("exr_naofaturar"));
                        exameFat = this.getExameFaturamento(exame, mat, convenio, p, r, rs);
                        if (exameFat == null || exameFat == null) continue;
                        exameFat.setFaturar(!rs.getBoolean("exr_naofaturar"));
                        exameFat.setCodigoUsuarioNaoFaturar(rs.getBoolean("exr_naofaturar") ? Variaveis.login : "");
                        requisicao.adicionaExame(exameFat);
                        registros.add(r);
                    }
                    if (registros.size() > 0) {
                        retorno.setValor("examesrequisicao", registros.toArray(new Registro[registros.size()]));
                    } else {
                        retorno.setValor("examesrequisicao", null);
                    }
                    Calculos.calculaTotalRequisicao(requisicao);
                    retorno.setValor("valor", Funcoes.formataDecimal(requisicao.getValorTotal().doubleValue()));
                    break block27;
                }
                Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o encontrada.", 2);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaGuias (262)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private DadosExameFaturamento getExameFaturamento(DadosExames exame, DadosMaterial mat, DadosConvenios convenio, int p, Registro regExame, ResultSet rsExame) throws SQLException {
        if (p != 1 && p != 6 && p != 7 && p != 8) {
            DadosExameFaturamento dados = new DadosExameFaturamento(exame.getCodigo());
            dados.setValorMaterial(exame.getValorMaterial());
            dados.setValorExame(exame.getValorExame().add(exame.getValorMaterial()));
            dados.setValorCHExame(exame.getValorCH());
            dados.setValorCH(convenio != null ? new BigDecimal(String.valueOf(convenio.getCH())) : BigDecimal.ZERO);
            dados.setFaturar(true);
            if (convenio != null && convenio.getCobraMaterial()) {
                this.pegaMateriais(dados, exame);
            }
            return dados;
        }
        return null;
    }

    private void pegaMateriais(DadosExameFaturamento dados, DadosExames dadosExame) {
        if (dadosExame == null) {
            return;
        }
        ArrayList materiais = dadosExame.getMatUtilizado();
        if (materiais != null) {
            for (int i = 0; i < materiais.size(); ++i) {
                DadosMaterialUtilizado material = (DadosMaterialUtilizado)materiais.get(i);
                DadosMaterialFaturamento mat = new DadosMaterialFaturamento();
                mat.setCodigo(material.getCodigo());
                mat.setDescricao(material.getDescricao());
                mat.setValor(material.getValor());
                mat.setQuantidade(material.getQtde());
                dados.adicionaMaterial(mat);
            }
        }
    }

    @Override
    public void novo() {
        super.novo();
        this.textFilial.setText(Variaveis.filialPadrao);
        if (this.ACESSO_FILIAL) {
            ScreenUtil.requisitarFoco(this.textFilial);
        } else {
            ScreenUtil.requisitarFoco(this.textRequisicao);
        }
    }

    private void pesquisaRequisicao(String filial) {
        Hashtable resultado = Pesquisas.requisicao(this.getTopLevelAncestor(), filial, false, false, false);
        if (resultado != null) {
            this.textRequisicao.setText(resultado.get("req_codigo").toString());
            if (Funcoes.textoVazio(this.textFilial)) {
                this.textFilial.setText(Variaveis.filialPadrao);
            }
        }
        ScreenUtil.requisitarFoco(this.textRequisicao);
    }

    private void pesquisaFilial() {
        Hashtable resultado = Pesquisas.filial(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600200400");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.tableRequisicao.getSelectedRow() == -1 || this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow()) == null) {
            return;
        }
        Registro r = this.modeloRequisicao.getRegistro(this.tableRequisicao.getSelectedRow());
        this.modeloExame.limpar();
        this.modeloExame.addRegistros((Registro[])r.getValor("examesrequisicao"));
        this.modeloExame.fireTableDataChanged();
        this.detalhe.setRequisicao(r);
        this.controlaMenu();
        this.controlaBotoes(false);
    }

    @Override
    public void situacaoAlterada(int situacaoNova) {
        Dimension dim = null;
        dim = situacaoNova == 1 ? new Dimension(this.detalhe.getPreferredSize().width, this.detalhe.getLabelDimension().height + 50) : new Dimension(this.detalhe.getPreferredSize().width, 50);
        this.panelDetalhesBotoes.setMinimumSize(dim);
        this.panelDetalhesBotoes.setPreferredSize(dim);
        this.panelDetalhesBotoes.revalidate();
    }

    public JPanel getPanelLegenda() {
        JPanel pnlLegenda = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_NAO_FATURAR);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        pnlLegenda.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("N\u00e3o Faturar");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_DEVE_GUIA);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Deve Guia");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(EditorDadosFaturamento.COR_SEM_CONFERENCIA);
        pnlCorLegenda.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        ++c.gridx;
        pnlLegenda.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("Sem Confer\u00eancia");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        pnlLegenda.add((Component)new JLabel("  "), c);
        ++c.gridx;
        JLabel labelSublinhado = new JLabel("<html><center><font size = 3>-</font></center></html>");
        labelSublinhado.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
        labelSublinhado.setPreferredSize(new Dimension(10, 10));
        pnlLegenda.add((Component)labelSublinhado, c);
        lblLegenda = new JLabel("Multiguia");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        pnlLegenda.add((Component)lblLegenda, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        pnlLegenda.add((Component)new JLabel(), c);
        return pnlLegenda;
    }

    @Override
    protected void controlaCampos() {
        this.controlaCampos(false);
    }

    protected void controlaCampos(boolean isCarregandoDados) {
        this.textFilial.setEnabled(this.getStatus() == 2 && !isCarregandoDados);
        this.buttonFilial.setEnabled(this.getStatus() == 2 && !isCarregandoDados);
        this.textRequisicao.setEnabled(this.getStatus() == 2 && !isCarregandoDados);
        this.buttonRequisicao.setEnabled(this.getStatus() == 2 && !isCarregandoDados);
        this.buttonFechar.setEnabled(!isCarregandoDados);
        this.controlaMenu();
        this.controlaBotoes(isCarregandoDados);
    }

    @Override
    protected void limparCampos() {
        this.modeloRequisicao.limpar();
        this.modeloExame.limpar();
        this.textRequisicao.clear();
        this.textFilial.clear();
        this.detalhe.limpaDados();
    }

    @Override
    @Deprecated
    protected AbstractThreadBean pesquisar() {
        return null;
    }

    @Override
    @Deprecated
    protected AbstractThreadBean getBeanPreenchido() {
        return null;
    }

    @Override
    @Deprecated
    protected void preencherCampos(AbstractThreadBean bean) {
    }

    @Override
    @Deprecated
    protected String getCopiaFiliais() {
        return null;
    }

    @Override
    @Deprecated
    public boolean validaCampos() {
        return false;
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.controlaCampos(true);
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.controlaCampos(false);
    }
}

