/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.dados.faturamento.DadosExamePaiAgrupamento;
import jalis.comum.dados.faturamento.DadosFaturamento;
import jalis.comum.dados.faturamento.DadosTotalGeral;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.DialogNotaFiscalSaida;
import jalis.laboratorio.financeiro.NotaFiscalSaida;
import jalis.laboratorio.financeiro.faturamento.AlteraGuiasFaturamento;
import jalis.laboratorio.financeiro.faturamento.DialogAssociacoes;
import jalis.laboratorio.financeiro.faturamento.JanelaPreviaFaturamento;
import jalis.laboratorio.financeiro.faturamento.TelaAlterarValor;
import jalis.laboratorio.financeiro.faturamento.TelaDeveGuiaExame;
import jalis.laboratorio.financeiro.util.NotaFiscalFatura;
import jalis.laboratorio.resultados.DialogoResultadosAnteriores;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.faturamento.AlterarDataFatura;
import jalis.laboratorio.util.faturamento.AlterarMensagem;
import jalis.laboratorio.util.faturamento.BuscaFatura;
import jalis.laboratorio.util.faturamento.Calculos;
import jalis.laboratorio.util.faturamento.EditorDadosFaturamento;
import jalis.laboratorio.util.faturamento.ExamesNaoFaturar;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.laboratorio.util.faturamento.ImprimirFatura;
import jalis.laboratorio.util.faturamento.ImprimirResumoFatura;
import jalis.laboratorio.util.faturamento.LinhasTabela;
import jalis.laboratorio.util.faturamento.eletronico.AbstractFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.FabricaFaturaEletronica;
import jalis.laboratorio.util.faturamento.eletronico.JanelaProblemasFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.JanelaProblemasFaturamentoEletronicoBPA;
import jalis.laboratorio.util.faturamento.eletronico.Resuline;
import jalis.laboratorio.util.faturamento.eletronico.SLine;
import jalis.laboratorio.util.faturamento.eletronico.SantaCasaMiguelopolis;
import jalis.laboratorio.util.faturamento.eletronico.Util;
import jalis.laboratorio.util.faturamento.eletronico.VisualizaErros;
import jalis.laboratorio.util.faturamento.eletronico.VisualizaErrosBPA;
import jalis.laboratorio.util.impressao.ImprimirGuia;
import jalis.model.bean.financeiro.FaturaBean;
import jalis.model.bean.financeiro.FaturaReceberPagarBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.dao.cadastro.auxiliares.FilialDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.ConvenioEntidadeBean;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.SeriesVO;
import jalis.model.vo.financeiro.FaturaVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.service.cadastro.ConvenioEntidadeService;
import jalis.service.cadastro.financeiro.FormaPagamentoParcelaService;
import jalis.service.cadastro.financeiro.SeriesService;
import jalis.service.financeiro.FaturaReceberPagarService;
import jalis.service.financeiro.FaturaService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.service.financeiro.faturamento.ConferenciaFaturaService;
import jalis.util.ArraysUtil;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ConferenciaFatura
extends FrmPadrao
implements ActionListener,
ThreadFinalizadaListener {
    private static final String PARAMETROS_CONFERENCIA_FATURA = "ConferenciaFatura.ultimoFiltro";
    private final JPanel panelEsquerdo = new JPanel(new GridBagLayout());
    private final JPanel panelDireito = new JPanel(new GridBagLayout());
    private final JPanel panelDireitoExames = new JPanel();
    private final JPanel panelDireitoLegenda = new JPanel();
    private final JPanel panelDireitoValorRestanteFaturar = new JPanel(new FlowLayout(0));
    private final JPanel panelBotoes = new JPanel(new BorderLayout());
    private final JPanel panelBotoesE = new JPanel(new FlowLayout(0));
    private final JPanel panelBotoesD = new JPanel(new FlowLayout(2));
    private final JButton buttonOpcoes = new JButton("Op\u00e7\u00f5es \u25bc");
    private final JButton buttonFechar = new JButton("Fechar");
    private final JButton buttonSalvar = new JButton("Salvar");
    private final JButton buttonCancelar = new JButton("Cancelar");
    private final JButton buttonImprimir = new JButton("Imprimir \u25bc");
    private final JButton buttonEletronico = new JButton("Eletr\u00f4nico");
    private final JButton buttonNovo = new JButton("Novo");
    private final JButton buttonConsultar = new JButton("Consultar");
    private final JLabel labelFatura = new JLabel("Fatura:");
    private final JButton buttonNotasAssociadas = new JButton("Notas Associadas");
    private final JLabel labelValorRestante = new JLabel();
    private final TTextField txtFatura = new TTextField(5, 1);
    private final JButton buttonFatura = new JButton();
    private int status = 1;
    private boolean imprimirAgrupada = false;
    private boolean faturaSalva = true;
    private boolean faturaConferida = false;
    private boolean notaFiscalAssociada = false;
    private boolean executandoBusca = false;
    private final Date vencimentoFatura = null;
    private ArrayList<NotaFiscalBean> listaAssociacoes = null;
    private final JPopupMenu menu = new JPopupMenu();
    private final JMenuItem itemDataFatura = new JMenuItem("Alterar data de fatura");
    private final JMenuItem itemAdicional = new JMenuItem("Alterar adicional");
    private final JMenuItem itemDespesas = new JMenuItem("Alterar despesas de cobran\u00e7a");
    private final JMenuItem itemDesconto = new JMenuItem("Alterar desconto");
    private final JMenuItem itemMensagem = new JMenuItem("Alterar mensagem");
    private final JMenuItem itemDeveGuiaExame = new JMenuItem("Marcar/Desmarcar exame sem guia");
    private final JMenuItem itemMarcarFaturamento = new JMenuItem("Marcar exames para n\u00e3o faturar");
    private final JMenuItem itemAlterarGuiaExames = new JMenuItem("Altera a guia/validade guia");
    private final JMenuItem itemAlterarValor = new JMenuItem("Atualizar valor de exames");
    private final JMenuItem itemDeveGuia = new JMenuItem("Marcar/Desmarcar sem pedido/guia");
    private final JMenuItem itemAlterarVencimentoFatura = new JMenuItem("Altera o vencimento da fatura");
    private final JMenuItem itemVisualizarResultado = new JMenuItem("Visualizar resultados");
    private final JCheckBoxMenuItem itemCheckVerificarNaoConferidos = new JCheckBoxMenuItem("Verificar n\u00e3o conferidos");
    private final JPopupMenu menuImprimir = new JPopupMenu();
    private final JMenuItem itemImprimirFatura = ComponenteFactory.novoJMenuItem(this.menuImprimir, "Fatura", (ActionListener)this);
    private final JMenuItem itemImprimirNota = ComponenteFactory.novoJMenuItem("Nota fiscal", this);
    private final JMenu itemImprimirGuia = new JMenu("Guia");
    private final JMenu itemImprimirGuiaExamesSolicitados = new JMenu("Guia de exames solicitados");
    private final JMenuItem itemImprimirGuiaSelecionada = new JMenuItem("Requisi\u00e7\u00e3o selecionada");
    private final JMenuItem itemImprimirTodasGuias = new JMenuItem("Todas as requisi\u00e7\u00f5es");
    private final JMenuItem itemImprimirGuiaExameSelecionada = new JMenuItem("Requisi\u00e7\u00e3o selecionada");
    private final JMenuItem itemImprimirTodasGuiasExames = new JMenuItem("Todas as requisi\u00e7\u00f5es");
    private final JMenu itemImprimirResultado = new JMenu("Resultado");
    private final JMenuItem itemImprimirResultadoSelecionado = new JMenuItem("Requisi\u00e7\u00e3o selecionada");
    private final JMenuItem itemImprimirTodosResultados = new JMenuItem("Todas as requisi\u00e7\u00f5es");
    private final JPanel panelDireitoObs = new JPanel(new GridBagLayout());
    private final JTextArea textObs = new JTextArea();
    private final TitledBorder titledObs = new TitledBorder("Observa\u00e7\u00f5es do conv\u00eanio");
    private final ConferenciaFaturaService service;
    private List<Registro> requisicoesSemPedidoGuia = new ArrayList<Registro>();
    private List<DadosFaturamento> requisicoesComGuiaAlterada = new ArrayList<DadosFaturamento>();
    private List<DadosFaturamento> requisicoesComDataFaturaAlterada = new ArrayList<DadosFaturamento>();
    final Color foregroundObs = this.titledObs.getTitleColor();
    private boolean acessoAlterarTodosCamposFatEletronico = false;
    private Integer codigoConvenio = null;
    private static String impressoraSelecionada;
    Timer chamaAtencao = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ConferenciaFatura.this.titledObs.setTitleColor(ConferenciaFatura.this.titledObs.getTitleColor() == ConferenciaFatura.this.foregroundObs ? Color.red : ConferenciaFatura.this.foregroundObs);
            ConferenciaFatura.this.panelDireitoObs.revalidate();
            ConferenciaFatura.this.panelDireitoObs.repaint();
        }
    });
    private BigDecimal valorRestanteFatura = BigDecimal.ZERO;

    public ConferenciaFatura() {
        this.service = new ConferenciaFaturaService();
        try {
            String tmp;
            this.jbInit();
            String parametros = ParametrosUsuarios.getValor(PARAMETROS_CONFERENCIA_FATURA);
            if (!Funcoes.textoVazio(parametros) && !Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "verificarconferidos"))) {
                this.itemCheckVerificarNaoConferidos.setSelected(Boolean.valueOf(tmp));
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ConferenciaFatura");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelEsquerdo, "West");
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelDireito, "Center");
        this.panelDireitoObs.setBorder(this.titledObs);
        this.panelDireitoObs.setMinimumSize(new Dimension(80, 60));
        this.panelEsquerdo.setPreferredSize(new Dimension(150, 100));
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane sp = new JScrollPane(this.textObs);
        sp.setPreferredSize(new Dimension(80, 60));
        this.textObs.setFont(new Font(this.textObs.getFont().getName(), 0, 10));
        this.textObs.setEditable(false);
        this.textObs.setWrapStyleWord(true);
        this.textObs.setLineWrap(true);
        this.panelDireitoObs.add((Component)sp, c);
        p.add((Component)this.panelDireitoObs, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        p.add((Component)this.panelDireitoValorRestanteFaturar, c);
        ++c.gridy;
        p.add((Component)this.panelDireitoLegenda, c);
        this.panelDireitoObs.setVisible(false);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.panelDireito.add((Component)this.panelDireitoExames, c);
        ++c.gridy;
        c.weighty = 0.0;
        this.panelDireito.add((Component)p, c);
        this.panelBotoes.add((Component)this.panelBotoesE, "West");
        this.panelBotoes.add((Component)this.panelBotoesD, "East");
        this.panelBotoesD.add(this.buttonNovo);
        this.panelBotoesD.add(this.buttonSalvar);
        this.panelBotoesD.add(this.buttonCancelar);
        this.panelBotoesD.add(this.buttonImprimir);
        this.panelBotoesD.add(this.buttonEletronico);
        this.panelBotoesD.add(this.buttonFechar);
        this.panelBotoesE.add(this.buttonOpcoes);
        this.menu.add(this.itemAdicional);
        this.menu.add(this.itemDespesas);
        this.menu.add(this.itemDesconto);
        this.menu.add(this.itemMensagem);
        this.menu.add(this.itemDataFatura);
        this.menu.add(this.itemDeveGuia);
        this.menu.add(this.itemDeveGuiaExame);
        this.menu.add(this.itemMarcarFaturamento);
        this.menu.add(this.itemAlterarValor);
        this.menu.add(this.itemAlterarGuiaExames);
        this.menu.add(this.itemAlterarVencimentoFatura);
        this.menu.add(this.itemVisualizarResultado);
        this.menu.add(this.itemCheckVerificarNaoConferidos);
        this.menuImprimir.add(this.itemImprimirFatura);
        this.menuImprimir.add(this.itemImprimirNota);
        this.menuImprimir.add(this.itemImprimirGuia);
        this.menuImprimir.add(this.itemImprimirGuiaExamesSolicitados);
        this.menuImprimir.add(this.itemImprimirResultado);
        this.itemImprimirGuia.add(this.itemImprimirGuiaSelecionada);
        this.itemImprimirGuia.add(this.itemImprimirTodasGuias);
        this.itemImprimirGuiaExamesSolicitados.add(this.itemImprimirGuiaExameSelecionada);
        this.itemImprimirGuiaExamesSolicitados.add(this.itemImprimirTodasGuiasExames);
        this.itemImprimirResultado.add(this.itemImprimirResultadoSelecionado);
        this.itemImprimirResultado.add(this.itemImprimirTodosResultados);
        this.buttonSalvar.setVisible(Acesso.getAcesso(Long.parseLong("0600200201")));
        this.buttonImprimir.setVisible(Acesso.getAcesso(Long.parseLong("0600200201")) || Acesso.getAcesso(Long.parseLong("0600200210")));
        this.itemDesconto.setVisible(Acesso.getAcesso(Long.parseLong("0600200202")));
        this.itemAdicional.setVisible(Acesso.getAcesso(Long.parseLong("0600200203")));
        this.itemDespesas.setVisible(Acesso.getAcesso(Long.parseLong("0600200204")));
        this.itemMensagem.setVisible(Acesso.getAcesso(Long.parseLong("0600200205")));
        this.itemDataFatura.setVisible(Acesso.getAcesso(Long.parseLong("0600200206")));
        this.itemDeveGuia.setVisible(Acesso.getAcesso(Long.parseLong("0600200207")));
        this.itemDeveGuiaExame.setVisible(Acesso.getAcesso(Long.parseLong("0600200207")));
        this.itemMarcarFaturamento.setVisible(Acesso.getAcesso(Long.parseLong("0600200220")));
        this.itemAlterarValor.setVisible(Acesso.getAcesso(Long.parseLong("0600200208")));
        this.buttonEletronico.setVisible(Acesso.getAcesso(Long.parseLong("0600200209")));
        this.itemAlterarGuiaExames.setVisible(Acesso.getAcesso(Long.parseLong("0600200213")));
        this.itemAlterarVencimentoFatura.setVisible(Acesso.getAcesso(Long.parseLong("0600200214")));
        this.itemImprimirGuia.setVisible(Acesso.getAcesso(Long.parseLong("0600200215")));
        this.itemImprimirGuiaExamesSolicitados.setVisible(Acesso.getAcesso(Long.parseLong("0600200215")));
        this.acessoAlterarTodosCamposFatEletronico = Acesso.getAcesso(Long.parseLong("0600200216"));
        this.itemImprimirResultado.setVisible(Acesso.getAcesso(Long.parseLong("0600200218")));
        this.itemVisualizarResultado.setVisible(Acesso.getAcesso(Long.parseLong("0600200219")));
        this.itemImprimirFatura.setVisible(Acesso.getAcesso(Long.parseLong("0600200201")));
        this.itemImprimirNota.setVisible(Acesso.getAcesso(Long.parseLong("0600200210")));
        this.itemImprimirResultado.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                ConferenciaFatura.this.itemImprimirResultadoSelecionado.setEnabled(FuncoesGerais.pegaLinhaSelecionada(ConferenciaFatura.this.panelDireitoExames) > -1);
            }

            @Override
            @Deprecated
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            @Deprecated
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.itemImprimirGuia.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                ConferenciaFatura.this.itemImprimirGuiaSelecionada.setEnabled(FuncoesGerais.pegaLinhaSelecionada(ConferenciaFatura.this.panelDireitoExames) > -1);
            }

            @Override
            @Deprecated
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            @Deprecated
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.itemImprimirGuiaExamesSolicitados.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                ConferenciaFatura.this.itemImprimirGuiaExameSelecionada.setEnabled(FuncoesGerais.pegaLinhaSelecionada(ConferenciaFatura.this.panelDireitoExames) > -1);
            }

            @Override
            @Deprecated
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            @Deprecated
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.itemCheckVerificarNaoConferidos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String tmp = "<verificarconferidos>" + ConferenciaFatura.this.itemCheckVerificarNaoConferidos.isSelected() + "</verificarconferidos>";
                ParametrosUsuarios.setValor(ConferenciaFatura.PARAMETROS_CONFERENCIA_FATURA, tmp);
                ParametrosUsuarios.salvarParametros(true);
            }
        });
        this.itemMarcarFaturamento.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaFatura.this.marcarExameParaNaoFaturar();
                FuncoesGerais.repaintTabela(ConferenciaFatura.this.panelDireitoExames);
                ConferenciaFatura.this.faturaSalva = false;
            }
        });
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 1.0;
        cons.fill = 2;
        cons.anchor = 17;
        this.panelEsquerdo.add((Component)this.labelFatura, cons);
        cons.gridx = 1;
        cons.anchor = 13;
        cons.weightx = 0.0;
        cons.fill = 0;
        this.txtFatura.setPreferredSize(new Dimension(70, 20));
        this.txtFatura.setMinimumSize(new Dimension(70, 20));
        this.panelEsquerdo.add((Component)this.txtFatura, cons);
        cons.gridx = 2;
        this.buttonFatura.setPreferredSize(new Dimension(20, 20));
        this.buttonFatura.setMinimumSize(new Dimension(20, 20));
        this.panelEsquerdo.add((Component)this.buttonFatura, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 3;
        cons.anchor = 13;
        this.panelEsquerdo.add((Component)this.buttonConsultar, cons);
        cons.gridy = 2;
        cons.fill = 1;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        cons.gridwidth = 3;
        this.panelEsquerdo.add((Component)new JPanel(), cons);
        FuncoesGerais.montaLegenda(this.panelDireitoLegenda);
        Funcoes.criaBarraDescricao(this, "Confer\u00eancia", "Confer\u00eancia dos exames faturados", "financeiro/cons_req_faturadas.jpg");
        this.panelEsquerdo.setBorder(new TitledBorder("Filtro"));
        this.buttonFechar.setMnemonic('F');
        this.buttonConsultar.setMnemonic('t');
        this.buttonNovo.setMnemonic('N');
        this.buttonSalvar.setMnemonic('S');
        this.buttonImprimir.setMnemonic('I');
        this.buttonOpcoes.setMnemonic('p');
        this.buttonCancelar.setMnemonic('C');
        this.buttonEletronico.setMnemonic('E');
        Funcoes.imagemPesquisa(this.buttonFatura);
        this.buttonFatura.setFocusable(false);
        this.buttonConsultar.setMargin(new Insets(2, 2, 2, 2));
        this.controlaCampos();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConferenciaFatura.this.novo();
            }
        });
        this.buttonOpcoes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaFatura.this.menu.show(ConferenciaFatura.this.panelBotoesE, ConferenciaFatura.this.buttonOpcoes.getX(), ConferenciaFatura.this.buttonOpcoes.getY() + ConferenciaFatura.this.buttonOpcoes.getHeight());
            }
        });
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Laboratorio.getInstancia().setInterromperInfoRequisicao(false);
                ConferenciaFatura.this.setVisible(false);
            }
        });
        this.buttonConsultar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaFatura.this.pesquisaFaturamento();
                System.gc();
            }
        });
        this.buttonFatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaFatura.this.pesquisaFatura();
            }
        });
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaFatura.this.novo();
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.mensagem(ConferenciaFatura.this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                    ConferenciaFatura.this.limpaCampos();
                    ConferenciaFatura.this.status = 1;
                    ConferenciaFatura.this.controlaCampos();
                    ConferenciaFatura.this.buttonNovo.requestFocus();
                }
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
                if (!FuncoesGerais.haExamesFaturamento(ConferenciaFatura.this.panelDireitoExames)) {
                    Funcoes.mensagem(ConferenciaFatura.this, "Deve haver pelo menos um exame selecionado para salvar o faturamento.\nCaso deseje remover o faturamento, use a tela de \"Estorno\".", 2);
                    return;
                }
                int resp = Funcoes.mensagem(ConferenciaFatura.this, "Deseja marcar a fatura como conferida?", 4, true);
                if (ConferenciaFatura.this.faturaSalva = ConferenciaFatura.this.salvar(resp == 0, false)) {
                    ConferenciaFatura.this.controlaCampos();
                    if (ConferenciaFatura.this.faturaConferida) {
                        ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(ConferenciaFatura.this.panelDireitoExames).getDefaultRenderer(Object.class)).setCheckBoxVisivel(false);
                        ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(ConferenciaFatura.this.panelDireitoExames).getDefaultEditor(Object.class)).setCheckBoxVisivel(false);
                        FuncoesGerais.removeExamesDeselecionadosFaturamento(ConferenciaFatura.this.panelDireitoExames);
                        FuncoesGerais.repaintTabela(ConferenciaFatura.this.panelDireitoExames);
                    } else {
                        FuncoesGerais.removeExamesDeselecionadosFaturamento(ConferenciaFatura.this.panelDireitoExames);
                        FuncoesGerais.repaintTabela(ConferenciaFatura.this.panelDireitoExames);
                    }
                }
                System.gc();
            }
        });
        this.buttonEletronico.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                block81: {
                    block83: {
                        block80: {
                            block79: {
                                block77: {
                                    if (!FuncoesGerais.haExamesFaturamento(ConferenciaFatura.access$200(ConferenciaFatura.this))) {
                                        Funcoes.mensagem(ConferenciaFatura.this, "Nenhum exame selecionado para o faturamento eletr\u00f4nico.", 2);
                                        return;
                                    }
                                    conferido = false;
                                    validado = false;
                                    codigoConvenio = -1;
                                    buf = new StringBuilder();
                                    stTemp = Conexao.getStatement();
                                    fat = null;
                                    protocolo = "";
                                    situacoes = null;
                                    xml = null;
                                    try {
                                        if (Funcoes.textoVazio(ConferenciaFatura.access$2100(ConferenciaFatura.this).getText())) break block77;
                                        buf.append(" select con_codigo");
                                        buf.append("   from fatura ");
                                        buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                                        buf.append("    and fat_codigo = ").append(ConferenciaFatura.access$2100(ConferenciaFatura.this).getText());
                                        buf.append("    and fat_datacancelamento is null ");
                                        rs = Conexao.executeQuery(stTemp, buf.toString());
                                        if (rs.next()) {
                                            codigoConvenio = rs.getInt("con_codigo");
                                        }
                                        if (codigoConvenio <= -1) break block77;
                                        buf.delete(0, buf.length());
                                        buf.append("select con_faturaeletronica from convenios where fil_codigo = ");
                                        buf.append(Variaveis.filialPadrao);
                                        buf.append(" and con_codigo = ");
                                        buf.append(codigoConvenio);
                                        rs = Conexao.executeQuery(stTemp, buf);
                                        if (rs.next()) {
                                            validado = Util.validaConfiguracaoConvenio(rs.getString("con_faturaeletronica"));
                                        }
                                        if (!validado) break block77;
                                        xml = rs.getString("con_faturaeletronica");
                                        protocolo = StringUtil.getValor(xml, "protocolo");
                                        fat = FabricaFaturaEletronica.novoFaturamentoEletronico(protocolo);
                                        situacoes = fat.situacoesPermitidasExame(xml);
                                    }
                                    catch (Exception ex) {
                                        try {
                                            ErrorLogger.mostraMensagem(ConferenciaFatura.this, ex.getMessage(), ex.getStackTrace(), "ConferenciaFatura (257)");
                                        }
                                        catch (Throwable var12_13) {
                                            Conexao.fecharStatement(new Statement[]{stTemp});
                                            throw var12_13;
                                        }
                                        Conexao.fecharStatement(new Statement[]{stTemp});
                                    }
                                }
                                Conexao.fecharStatement(new Statement[]{stTemp});
                                if (!validado || fat == null) {
                                    Funcoes.mensagem(ConferenciaFatura.this, "O faturamento eletr\u00f4nico n\u00e3o pode ser conclu\u00eddo pois n\u00e3o existe uma configura\u00e7\u00e3o para o conv\u00eanio", 1);
                                    return;
                                }
                                ConferenciaFatura.access$2200(ConferenciaFatura.this).setEnabled(false);
                                reg = ((AbstractFaturamentoEletronico)fat).parseXMLConfiguracao(xml);
                                linhas = FuncoesGerais.pegaModeloFatura(ConferenciaFatura.access$200(ConferenciaFatura.this));
                                requisicoes = new ArrayList<DadosFaturamento>();
                                for (i = 0; i < linhas.getRowCount(); ++i) {
                                    if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento)) continue;
                                    requisicoes.add((DadosFaturamento)linhas.getValueAt(i, 1));
                                }
                                qtdeErros = 0;
                                ((AbstractFaturamentoEletronico)fat).verificaErrosFatura(requisicoes, reg);
                                for (i = 0; i < requisicoes.size(); ++i) {
                                    requisicao = requisicoes.get(i);
                                    if (!requisicao.haProblemas()) continue;
                                    ++qtdeErros;
                                }
                                if (qtdeErros > 0 && reg != null) {
                                    janela = null;
                                    janelaBPA = null;
                                    if (protocolo.equalsIgnoreCase("BPA")) {
                                        todososMedicosPossuemCbos = ConferenciaFatura.this.verificarSeTodosOsMedicosPossuemCbos(requisicoes);
                                        if (!todososMedicosPossuemCbos) {
                                            ConferenciaFatura.access$2200(ConferenciaFatura.this).setEnabled(true);
                                            return;
                                        }
                                        janelaBPA = new JanelaProblemasFaturamentoEletronicoBPA((Window)Laboratorio.getInstancia(), ConferenciaFatura.access$2300(ConferenciaFatura.this));
                                        janelaBPA.preencheValores(requisicoes, reg, (AbstractFaturamentoEletronico)fat);
                                        janelaBPA.setVisible(true);
                                        linhas.removeListenerLinhasRemovidas();
                                        rodape = null;
                                        for (i = 0; i < linhas.getRowCount(); ++i) {
                                            if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento)) {
                                                rodape = linhas.getValueAt(i, 1);
                                            }
                                            linhas.removeLinha(i--);
                                        }
                                        requisicoesAtualizadas = janelaBPA.getRequisicoes();
                                        for (i = 0; i < requisicoesAtualizadas.size(); ++i) {
                                            linhas.adicionaLinha(requisicoesAtualizadas.get(i));
                                        }
                                        linhas.adicionaLinha(rodape);
                                        FuncoesGerais.atualizaModeloFatura(ConferenciaFatura.access$200(ConferenciaFatura.this));
                                        if (janelaBPA.haProblemas()) {
                                            Funcoes.mensagem(ConferenciaFatura.this, "N\u00e3o \u00e9 poss\u00edvel gerar o faturamento eletr\u00f4nico, pois, ainda h\u00e1 erros a serem corrigidos.", 2);
                                            ConferenciaFatura.access$2200(ConferenciaFatura.this).setEnabled(true);
                                            return;
                                        }
                                    } else {
                                        janela = new JanelaProblemasFaturamentoEletronico((Window)Laboratorio.getInstancia(), ConferenciaFatura.access$2300(ConferenciaFatura.this), reg.getValor("versaoArquivo").toString());
                                        janela.preencheValores(requisicoes, reg, (AbstractFaturamentoEletronico)fat);
                                        janela.setVisible(true);
                                        linhas.removeListenerLinhasRemovidas();
                                        rodape = null;
                                        for (i = 0; i < linhas.getRowCount(); ++i) {
                                            if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento)) {
                                                rodape = linhas.getValueAt(i, 1);
                                            }
                                            linhas.removeLinha(i--);
                                        }
                                        requisicoesAtualizadas = janela.getRequisicoes();
                                        for (i = 0; i < requisicoesAtualizadas.size(); ++i) {
                                            linhas.adicionaLinha(requisicoesAtualizadas.get(i));
                                        }
                                        linhas.adicionaLinha(rodape);
                                        FuncoesGerais.atualizaModeloFatura(ConferenciaFatura.access$200(ConferenciaFatura.this));
                                        if (janela.haProblemas()) {
                                            Funcoes.mensagem(ConferenciaFatura.this, "N\u00e3o \u00e9 poss\u00edvel gerar o faturamento eletr\u00f4nico, pois, ainda h\u00e1 erros a serem corrigidos.", 2);
                                            ConferenciaFatura.access$2200(ConferenciaFatura.this).setEnabled(true);
                                            return;
                                        }
                                    }
                                }
                                telaEspera = SplashMensagem.getInstancia(ConferenciaFatura.this);
                                telaEspera.mostrar("Gerando faturamento eletr\u00f4nico. Aguarde...");
                                if (situacoes != null) {
                                    linhas = FuncoesGerais.pegaModeloFatura(ConferenciaFatura.access$200(ConferenciaFatura.this));
                                    removeuExame = false;
                                    if (linhas != null) {
                                        remover = false;
                                        for (i = 0; i < linhas.getRowCount(); ++i) {
                                            if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento)) continue;
                                            dados = (DadosFaturamento)linhas.getValueAt(i, 1);
                                            exames = dados.getExames();
                                            contagemRemovidos = 0;
                                            for (DadosExameFaturamento exame : exames) {
                                                if (!exame.getFaturar() || ArraysUtil.indice(situacoes, exame.getSituacaoExame()) >= 0) continue;
                                                if (!remover) {
                                                    v0 = remover = Funcoes.mensagem(ConferenciaFatura.this, "Alguns exames n\u00e3o podem ser faturados, pois a situa\u00e7\u00e3o atual do exame n\u00e3o pode ser faturada.\nDeseja remover esses exames do faturamento atual?", 4) == 0;
                                                }
                                                if (!remover) {
                                                    Funcoes.mensagem(ConferenciaFatura.this, "O faturamento foi cancelado por n\u00e3o atender \u00e0s situa\u00e7\u00f5es exigidas.", 1);
                                                    ConferenciaFatura.access$2200(ConferenciaFatura.this).setEnabled(true);
                                                    telaEspera.apagar();
                                                    return;
                                                }
                                                exame.setFaturar(false);
                                                removeuExame = true;
                                                ++contagemRemovidos;
                                                Calculos.calculaTotalRequisicao(dados);
                                            }
                                            if (contagemRemovidos != exames.size()) continue;
                                            dados.setFaturar(false);
                                        }
                                        if (removeuExame) {
                                            stCalculo = Conexao.getStatement();
                                            try {
                                                tabela = FuncoesGerais.pegaTabela(ConferenciaFatura.access$200(ConferenciaFatura.this));
                                                Calculos.calculaTotal(stCalculo, linhas.getRowCount() - 1, tabela, linhas);
                                                tabela.revalidate();
                                                tabela.repaint();
                                            }
                                            catch (Exception ex) {
                                                try {
                                                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "FaturaExames : 460");
                                                }
                                                catch (Throwable var24_60) {
                                                    Conexao.fecharStatement(new Statement[]{stCalculo});
                                                    throw var24_60;
                                                }
                                                Conexao.fecharStatement(new Statement[]{stCalculo});
                                            }
                                            Conexao.fecharStatement(new Statement[]{stCalculo});
                                        }
                                        if (remover) {
                                            Funcoes.mensagem(ConferenciaFatura.this, "Alguns exames foram desmarcados do faturamento, confira as requisi\u00e7\u00f5es antes de continuar.", 2);
                                            FuncoesGerais.repaintTabela(ConferenciaFatura.access$200(ConferenciaFatura.this));
                                            ConferenciaFatura.access$2200(ConferenciaFatura.this).setEnabled(true);
                                            telaEspera.apagar();
                                            return;
                                        }
                                    }
                                }
                                if (!ConferenciaFatura.access$2000(ConferenciaFatura.this) && (resp = Funcoes.mensagem(ConferenciaFatura.this, "Deseja marcar a fatura como conferida?", 4, true)) == 0) {
                                    ConferenciaFatura.access$802(ConferenciaFatura.this, ConferenciaFatura.access$1900(ConferenciaFatura.this, true, true));
                                    ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(ConferenciaFatura.access$200(ConferenciaFatura.this)).getDefaultRenderer(Object.class)).setCheckBoxVisivel(false);
                                    ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(ConferenciaFatura.access$200(ConferenciaFatura.this)).getDefaultEditor(Object.class)).setCheckBoxVisivel(false);
                                    FuncoesGerais.removeExamesDeselecionadosFaturamento(ConferenciaFatura.access$200(ConferenciaFatura.this));
                                    FuncoesGerais.repaintTabela(ConferenciaFatura.access$200(ConferenciaFatura.this));
                                    conferido = true;
                                }
                                if (!ConferenciaFatura.access$800(ConferenciaFatura.this) || Funcoes.textoVazio(ConferenciaFatura.access$2100(ConferenciaFatura.this).getText())) break block83;
                                st = Conexao.getStatement();
                                if (!validado) ** GOTO lbl307
                                if (!fat.solicitarDiretorioNoInicio()) ** GOTO lbl238
                                path = "";
                                file = ComponenteFactory.novoJFileChooser();
                                file.setFileSelectionMode(1);
                                if (file.showSaveDialog(ConferenciaFatura.this) != 0) break block79;
                                path = file.getSelectedFile().getAbsolutePath();
                            }
                            Conexao.fecharStatement(new Statement[]{st});
                            telaEspera.apagar();
                            ConferenciaFatura.access$2200(ConferenciaFatura.this).setEnabled(true);
                            return;
                            try {
                                arquivos = fat.criarArquivo(ConferenciaFatura.this.getTopLevelAncestor(), Integer.parseInt(ConferenciaFatura.access$2100(ConferenciaFatura.this).getText()), String.valueOf(codigoConvenio), path);
                                if (arquivos != null && arquivos.size() > 0) {
                                    contaArquivos = 0;
                                    for (ArquivoFaturamentoEletronico arquivo : arquivos) {
                                        if (Funcoes.textoVazio(arquivo.getXML())) continue;
                                        extensao = FabricaFaturaEletronica.getExtensaoArquivo(protocolo, xml);
                                        nomeArquivo = path + "/" + arquivo.getNome() + (extensao == null ? "" : "." + extensao);
                                        StringUtil.escreverArquivoTexto(nomeArquivo, arquivo.getXML(), fat.getCodificacaoArquivo());
                                        if (!protocolo.equalsIgnoreCase(SLine.getNomeProtocolo())) {
                                            Funcoes.mensagem(ConferenciaFatura.this, "Arquivo criado com sucesso.\n" + nomeArquivo, 2);
                                            continue;
                                        }
                                        ++contaArquivos;
                                    }
                                    if (protocolo.equalsIgnoreCase(SLine.getNomeProtocolo())) {
                                        if (contaArquivos == arquivos.size()) {
                                            Funcoes.mensagem(ConferenciaFatura.this, "Arquivo(s) criado(s) com sucesso.", 2);
                                        } else if (contaArquivos == 0) {
                                            Funcoes.mensagem(ConferenciaFatura.this, "Nenhum arquivo gerado.", 2);
                                        } else {
                                            Funcoes.mensagem(ConferenciaFatura.this, "N\u00e3o foi poss\u00edvel gerar todos os arquivos.", 2);
                                        }
                                    }
                                }
                                break block80;
lbl238:
                                // 1 sources

                                arquivos = fat.criarArquivo(ConferenciaFatura.this.getTopLevelAncestor(), Integer.parseInt(ConferenciaFatura.access$2100(ConferenciaFatura.this).getText()), String.valueOf(codigoConvenio), "");
                                if (!protocolo.equalsIgnoreCase(Resuline.getNomeProtocolo())) {
                                    if (arquivos != null && arquivos.size() > 0) {
                                        contaArquivos = 0;
                                        for (ArquivoFaturamentoEletronico arquivo : arquivos) {
                                            if (Funcoes.textoVazio(arquivo.getXML()) && (arquivo.getConteudo() == null || arquivo.getConteudo().length <= 0)) continue;
                                            file = ComponenteFactory.novoJFileChooser();
                                            extensao = FabricaFaturaEletronica.getExtensaoArquivo(protocolo, xml);
                                            if (extensao != null) {
                                                file.setFileFilter(ComponenteFactory.novoFileFilter("Arquivos de Faturamento", new String[]{extensao}));
                                            }
                                            file.setSelectedFile(new File(arquivo.getNome()));
                                            if (file.showSaveDialog(ConferenciaFatura.this) != 0) continue;
                                            path = null;
                                            path = extensao != null ? StringUtil.concatenarExtensao(file.getSelectedFile().getAbsolutePath(), "." + extensao) : file.getSelectedFile().getAbsolutePath();
                                            if (!Funcoes.textoVazio(arquivo.getXML())) {
                                                StringUtil.escreverArquivoTexto(path, arquivo.getXML(), fat.getCodificacaoArquivo());
                                            } else {
                                                StringUtil.escreverArquivo(path, arquivo.getConteudo());
                                            }
                                            if (!protocolo.equalsIgnoreCase(SLine.getNomeProtocolo())) {
                                                Funcoes.mensagem(ConferenciaFatura.this, "Arquivo criado com sucesso.\n" + path, 2);
                                                continue;
                                            }
                                            ++contaArquivos;
                                        }
                                        if (protocolo.equalsIgnoreCase(SLine.getNomeProtocolo())) {
                                            if (contaArquivos == arquivos.size()) {
                                                Funcoes.mensagem(ConferenciaFatura.this, "Arquivo(s) criado(s) com sucesso.", 2);
                                            } else if (contaArquivos == 0) {
                                                Funcoes.mensagem(ConferenciaFatura.this, "Nenhum arquivo gerado.", 2);
                                            } else {
                                                Funcoes.mensagem(ConferenciaFatura.this, "N\u00e3o foi poss\u00edvel gerar todos os arquivos.", 2);
                                            }
                                        }
                                    }
                                } else if (arquivos != null && arquivos.size() > 0) {
                                    contaArquivos = 0;
                                    for (ArquivoFaturamentoEletronico arquivo : arquivos) {
                                        if (Funcoes.textoVazio(arquivo.getXML()) && arquivo.getConteudo() == null) continue;
                                        if (arquivo.getNome().contains("xml")) {
                                            StringUtil.escreverArquivoTexto(arquivo.getNome(), arquivo.getXML(), fat.getCodificacaoArquivo());
                                        } else if (arquivo.getNome().contains("pdf")) {
                                            file = new File(arquivo.getNome());
                                            fileWriter = new FileOutputStream(file);
                                            fileWriter.write(arquivo.getConteudo());
                                            fileWriter.close();
                                            System.gc();
                                        }
                                        ++contaArquivos;
                                    }
                                    if (protocolo.equalsIgnoreCase(Resuline.getNomeProtocolo())) {
                                        if (contaArquivos == arquivos.size()) {
                                            Funcoes.mensagem(ConferenciaFatura.this, "Arquivo(s) criado(s) com sucesso.", 2);
                                        } else if (contaArquivos == 0) {
                                            Funcoes.mensagem(ConferenciaFatura.this, "Nenhum arquivo gerado.", 2);
                                        } else {
                                            Funcoes.mensagem(ConferenciaFatura.this, "N\u00e3o foi poss\u00edvel gerar todos os arquivos.", 2);
                                        }
                                    }
                                }
                                if (arquivos != null && arquivos.size() > 0 && !StringUtil.isEmpty(arquivos.get(0).getNome()) && protocolo.equalsIgnoreCase(SantaCasaMiguelopolis.getNomeProtocolo())) {
                                    Funcoes.mensagem(ConferenciaFatura.this, "Arquivo criado com sucesso.\n" + arquivos.get(0).getNome(), 2);
                                }
                                break block80;
lbl307:
                                // 1 sources

                                Funcoes.mensagem(ConferenciaFatura.this, "O conv\u00eanio selecionado n\u00e3o est\u00e1 habilitado para criar arquivos de faturamento", 1);
                            }
                            catch (Exception ex) {
                                try {
                                    ErrorLogger.mostraMensagem(ConferenciaFatura.this, ex.getMessage(), ex.getStackTrace(), "ConferenciaFatura (261)");
                                }
                                catch (Throwable var25_62) {
                                    Conexao.fecharStatement(new Statement[]{st});
                                    telaEspera.apagar();
                                    ConferenciaFatura.access$2200(ConferenciaFatura.this).setEnabled(true);
                                    throw var25_62;
                                }
                                Conexao.fecharStatement(new Statement[]{st});
                                telaEspera.apagar();
                                ConferenciaFatura.access$2200(ConferenciaFatura.this).setEnabled(true);
                                break block81;
                            }
                        }
                        Conexao.fecharStatement(new Statement[]{st});
                        telaEspera.apagar();
                        ConferenciaFatura.access$2200(ConferenciaFatura.this).setEnabled(true);
                        break block81;
                    }
                    telaEspera.apagar();
                }
                if (conferido) {
                    listaPreviasFaturamento = null;
                    try {
                        listaPreviasFaturamento = new FaturaReceberPagarService().getListaPreviasFaturamento(Variaveis.filialPadrao, String.valueOf(ConferenciaFatura.access$2100(ConferenciaFatura.this).getText()));
                    }
                    catch (ThreadDaoException e1) {
                        ErrorLogger.mostraMensagem(ConferenciaFatura.this, "N\u00e3o foi poss\u00edvel carregar lista de pr\u00e9vias de recebimento do faturamento.\n" + e1.getMessage(), e1.getStackTrace());
                        return;
                    }
                    total = null;
                    modeloFatura = FuncoesGerais.pegaTabela(ConferenciaFatura.access$200(ConferenciaFatura.this)).getModel();
                    if (!(modeloFatura.getValueAt(modeloFatura.getRowCount() - 1, 0) instanceof DadosTotalGeral)) {
                        Funcoes.mensagem(ConferenciaFatura.this, "N\u00e3o foi poss\u00edvel obter dados para faturamento", 1);
                        return;
                    }
                    total = (DadosTotalGeral)modeloFatura.getValueAt(modeloFatura.getRowCount() - 1, 0);
                    if (ParametrosGerais.isGerarPreviasFaturamento() && (listaPreviasFaturamento == null || listaPreviasFaturamento.size() == 0)) {
                        ConferenciaFatura.access$2400(ConferenciaFatura.this, codigoConvenio, total.getTotal().doubleValue());
                    }
                }
            }
        });
        this.buttonImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaFatura.this.itemImprimirFatura.setText(ConferenciaFatura.this.imprimirAgrupada ? "Fatura agrupada" : "Fatura");
                ConferenciaFatura.this.menuImprimir.show(ConferenciaFatura.this.panelBotoesD, ConferenciaFatura.this.buttonImprimir.getX(), ConferenciaFatura.this.buttonImprimir.getY() + ConferenciaFatura.this.buttonImprimir.getHeight());
            }
        });
        this.itemAdicional.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(ConferenciaFatura.this.panelDireitoExames);
                if (linhas != null && linhas.getValueAt(linhas.getRowCount() - 1, 0) instanceof DadosTotalGeral) {
                    DadosTotalGeral dados = (DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0);
                    FuncoesGerais.mudaValor((Frame)ConferenciaFatura.this.getTopLevelAncestor(), 1, dados);
                    FuncoesGerais.repaintTabela(ConferenciaFatura.this.panelDireitoExames);
                    ConferenciaFatura.this.atualizaLabelValorRestante(((DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0)).getTotal().doubleValue());
                    ConferenciaFatura.this.faturaSalva = false;
                }
            }
        });
        this.itemDesconto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(ConferenciaFatura.this.panelDireitoExames);
                if (linhas != null && linhas.getValueAt(linhas.getRowCount() - 1, 0) instanceof DadosTotalGeral) {
                    DadosTotalGeral dados = (DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0);
                    FuncoesGerais.mudaValor((Frame)ConferenciaFatura.this.getTopLevelAncestor(), 3, dados);
                    FuncoesGerais.repaintTabela(ConferenciaFatura.this.panelDireitoExames);
                    ConferenciaFatura.this.atualizaLabelValorRestante(((DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0)).getTotal().doubleValue());
                    ConferenciaFatura.this.faturaSalva = false;
                }
            }
        });
        this.itemDespesas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(ConferenciaFatura.this.panelDireitoExames);
                if (linhas != null && linhas.getValueAt(linhas.getRowCount() - 1, 0) instanceof DadosTotalGeral) {
                    DadosTotalGeral dados = (DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0);
                    FuncoesGerais.mudaValor((Frame)ConferenciaFatura.this.getTopLevelAncestor(), 2, dados);
                    FuncoesGerais.repaintTabela(ConferenciaFatura.this.panelDireitoExames);
                    ConferenciaFatura.this.atualizaLabelValorRestante(((DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0)).getTotal().doubleValue());
                    ConferenciaFatura.this.faturaSalva = false;
                }
            }
        });
        this.itemMensagem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(ConferenciaFatura.this.panelDireitoExames);
                if (linhas != null && linhas.getValueAt(linhas.getRowCount() - 1, 0) instanceof DadosTotalGeral) {
                    DadosTotalGeral dados = (DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0);
                    AlterarMensagem msg = new AlterarMensagem((Window)((Frame)ConferenciaFatura.this.getTopLevelAncestor()));
                    msg.setMensagem(dados.getMensagem());
                    msg.setVisible(true);
                    if (msg.isOK()) {
                        dados.setMensagem(msg.getMensagem());
                    }
                    FuncoesGerais.repaintTabela(ConferenciaFatura.this.panelDireitoExames);
                    ConferenciaFatura.this.faturaSalva = false;
                }
            }
        });
        this.itemDataFatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaFatura.this.alterarDataFatura();
            }
        });
        this.itemVisualizarResultado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer linha = FuncoesGerais.pegaLinhaSelecionada(ConferenciaFatura.this.panelDireitoExames);
                if (linha > -1) {
                    LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(ConferenciaFatura.this.panelDireitoExames);
                    int codigoRequisicao = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getRequisicao();
                    String codigoFilial = String.valueOf(((DadosFaturamento)linhas.getValueAt(linha, 1)).getCodigoFilial());
                    String nomePaciente = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getNomePaciente();
                    DialogoResultadosAnteriores dialogo = DialogoResultadosAnteriores.novaInstancia(ConferenciaFatura.this.getTopLevelAncestor());
                    if (dialogo != null) {
                        boolean mostrar = false;
                        mostrar = ParametrosGerais.isPesquisarAnterioresAutocopiaPaciente() ? dialogo.setRequisicaoAutocopia((Window)ConferenciaFatura.this.getTopLevelAncestor(), codigoFilial, nomePaciente, String.valueOf(codigoRequisicao)) : dialogo.setRequisicao((Window)ConferenciaFatura.this.getTopLevelAncestor(), codigoFilial, nomePaciente, String.valueOf(codigoRequisicao));
                        if (mostrar) {
                            dialogo.setVisible(true);
                        }
                    }
                }
            }
        });
        this.itemDeveGuia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaFatura.this.marcarDesmarcarPedidoGuia();
            }
        });
        this.itemAlterarValor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(ConferenciaFatura.this.panelDireitoExames);
                int linha = FuncoesGerais.pegaLinhaSelecionada(ConferenciaFatura.this.panelDireitoExames);
                if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento) {
                    TelaAlterarValor tela = new TelaAlterarValor((Frame)ConferenciaFatura.this.getTopLevelAncestor());
                    DadosFaturamento fat = (DadosFaturamento)linhas.getValueAt(linha, 1);
                    tela.setDadosFaturamento(fat);
                    tela.setVisible(true);
                    if (tela.ok()) {
                        Statement st = Conexao.getStatement();
                        try {
                            Calculos.calculaTotalRequisicao(fat);
                            Calculos.calculaTotal(st, linhas.getRowCount() - 1, FuncoesGerais.pegaTabela(ConferenciaFatura.this.panelDireitoExames), linhas);
                            ConferenciaFatura.this.atualizaLabelValorRestante(((DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0)).getTotal().doubleValue());
                            FuncoesGerais.repaintTabela(ConferenciaFatura.this.panelDireitoExames);
                            ConferenciaFatura.this.faturaSalva = false;
                        }
                        catch (Exception ex) {
                            ErrorLogger.mostraMensagem(ConferenciaFatura.this, ex.getMessage(), ex.getStackTrace(), "ConferenciaFatura");
                        }
                        Conexao.fecharStatement(st);
                    }
                }
            }
        });
        this.itemDeveGuiaExame.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaFatura.this.marcarDesmarcarExameSemGuia();
            }
        });
        this.itemAlterarGuiaExames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConferenciaFatura.this.alterarGuiaExames();
            }
        });
        this.itemAlterarVencimentoFatura.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DadosTotalGeral total = null;
                LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(ConferenciaFatura.this.panelDireitoExames);
                if (linhas != null && linhas.getValueAt(linhas.getRowCount() - 1, 0) instanceof DadosTotalGeral) {
                    total = (DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0);
                }
                if (total != null) {
                    AlterarVencimentoFatura alterar = new AlterarVencimentoFatura(Laboratorio.getInstancia(), total.getVencimento());
                    alterar.setVisible(true);
                    if (alterar.isOk()) {
                        total.setVencimento(alterar.getVencimento());
                        linhas.setValueAt(total, linhas.getRowCount() - 1, 0);
                        ConferenciaFatura.this.faturaSalva = false;
                        FuncoesGerais.repaintTabela(ConferenciaFatura.this.panelDireitoExames);
                    }
                }
            }
        });
        this.itemImprimirGuiaSelecionada.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread("Impress\u00e3o de guia - Jalis"){

                    @Override
                    public void run() {
                        ConferenciaFatura.this.imprimirGuia(false, 0);
                    }
                }.start();
            }
        });
        this.itemImprimirTodasGuias.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread("Impress\u00e3o de guia - Jalis"){

                    @Override
                    public void run() {
                        ConferenciaFatura.this.imprimirGuia(true, 0);
                    }
                }.start();
            }
        });
        this.itemImprimirResultadoSelecionado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread("Impress\u00e3o de resultado - Jalis"){

                    @Override
                    public void run() {
                        ConferenciaFatura.this.imprimirResultado(false);
                    }
                }.start();
            }
        });
        this.itemImprimirTodosResultados.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread("Impress\u00e3o de resultado - Jalis"){

                    @Override
                    public void run() {
                        int confirmacao = JOptionPane.showOptionDialog(ConferenciaFatura.this, "Ser\u00e3o impressos os resultados de todas as requisi\u00e7\u00f5es da fatura.\nDeseja continuar?", "Confirma Impress\u00e3o", 0, 3, ImagemUtils.carregaImagemJalis("dialog_question.gif"), new Object[]{"Sim", "N\u00e3o"}, "N\u00e3o");
                        if (confirmacao == 0) {
                            ConferenciaFatura.this.imprimirResultado(true);
                        }
                    }
                }.start();
            }
        });
        this.itemImprimirGuiaExameSelecionada.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread("Impress\u00e3o de guia - Jalis"){

                    @Override
                    public void run() {
                        ConferenciaFatura.this.imprimirGuia(false, 1);
                    }
                }.start();
            }
        });
        this.itemImprimirTodasGuiasExames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread("Impress\u00e3o de guia - Jalis"){

                    @Override
                    public void run() {
                        ConferenciaFatura.this.imprimirGuia(true, 1);
                    }
                }.start();
            }
        });
        this.buttonNotasAssociadas.setMnemonic('o');
        this.buttonNotasAssociadas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogAssociacoes.invocaTela((Window)ConferenciaFatura.this.getTopLevelAncestor(), ConferenciaFatura.this.listaAssociacoes);
            }
        });
    }

    protected boolean verificarSeTodosOsMedicosPossuemCbos(ArrayList<DadosFaturamento> requisicoes) {
        HashMap<String, String> medicosSemCBOS = new HashMap<String, String>();
        for (DadosFaturamento requisicao : requisicoes) {
            String crmDoMedico = requisicao.getCRMMedico();
            String ufDoMedico = requisicao.getUFMedico();
            String nomeDoMedico = requisicao.getNomeMedico();
            String xmlDoCbo = requisicao.getXmlCbo();
            if (!Funcoes.textoVazio(xmlDoCbo) || medicosSemCBOS.containsKey(crmDoMedico)) continue;
            medicosSemCBOS.put(crmDoMedico, crmDoMedico + " - " + ufDoMedico + " - " + nomeDoMedico);
        }
        if (!medicosSemCBOS.isEmpty() && null != medicosSemCBOS) {
            VisualizaErrosBPA.novaInstancia(Laboratorio.getInstancia(), "M\u00e9dicos sem CBOS informado.", medicosSemCBOS, true);
            return false;
        }
        return true;
    }

    private String getCodigosRequisicoesRemovidas() {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        ArrayList<String> requisicoes = new ArrayList<String>();
        for (int i = 0; i < linhas.getRowCount(); ++i) {
            DadosFaturamento dadosFatura;
            if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento) || (dadosFatura = (DadosFaturamento)linhas.getValueAt(i, 1)).getFaturar()) continue;
            requisicoes.add(String.valueOf(dadosFatura.getRequisicao()));
        }
        if (requisicoes.isEmpty()) {
            return null;
        }
        String retorno = StringUtil.implode(requisicoes.toArray(new String[requisicoes.size()]), ",");
        return retorno;
    }

    private void imprimirGuia(boolean imprimirTodas, int tipoGuia) {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        ArrayList<String> errosGeracao = new ArrayList<String>();
        if (imprimirTodas) {
            ImprimirGuia.validarImprimirGuias(tipoGuia, linhas, errosGeracao, false, this);
            if (!errosGeracao.isEmpty()) {
                VisualizaErros ve = VisualizaErros.novaInstancia(this.getTopLevelAncestor(), "Configura\u00e7\u00f5es incorretas para imprimir as guias verifique!", errosGeracao);
                if (ve != null) {
                    ve.dispose();
                }
            } else {
                ImprimirGuia.validarImprimirGuias(tipoGuia, linhas, errosGeracao, true, this);
            }
            FuncoesGerais.repaintTabela(this.panelDireitoExames);
        } else {
            Integer linha;
            Integer n = linha = imprimirTodas ? null : Integer.valueOf(FuncoesGerais.pegaLinhaSelecionada(this.panelDireitoExames));
            if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento) {
                ImprimirGuia.validarImprimirGuia(tipoGuia, linhas, errosGeracao, false, this, linha);
                if (!errosGeracao.isEmpty()) {
                    VisualizaErros ve = VisualizaErros.novaInstancia(this.getTopLevelAncestor(), "Configura\u00e7\u00f5es incorretas para imprimir as guias verifique!", errosGeracao);
                    if (ve != null) {
                        ve.dispose();
                    }
                } else {
                    ImprimirGuia.validarImprimirGuia(tipoGuia, linhas, errosGeracao, true, this, linha);
                }
                FuncoesGerais.repaintTabela(this.panelDireitoExames, linha);
            } else {
                Funcoes.mensagem(this, "Nenhuma requisi\u00e7\u00e3o selecionada.", 2);
            }
        }
        this.faturaSalva = false;
    }

    private void imprimirResultado(boolean imprimirTodos) {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        if (imprimirTodos) {
            for (int i = 0; i < linhas.getRowCount(); ++i) {
                if (!(linhas.getValueAt(i, 1) instanceof DadosFaturamento) || !((DadosFaturamento)linhas.getValueAt(i, 1)).getFaturar()) continue;
                int codigoRequisicao = ((DadosFaturamento)linhas.getValueAt(i, 1)).getRequisicao();
                String codigoFilial = String.valueOf(((DadosFaturamento)linhas.getValueAt(i, 1)).getCodigoFilial());
                try {
                    RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(impressoraSelecionada, this.getTopLevelAncestor(), codigoFilial, String.valueOf(codigoRequisicao), true, false, false);
                    if (!Funcoes.textoVazio(impressoraSelecionada)) continue;
                    impressoraSelecionada = retorno.getImpressoraSelecionada();
                    continue;
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConferenciaFatura (1879)");
                }
            }
            FuncoesGerais.repaintTabela(this.panelDireitoExames);
        } else {
            Integer linha;
            Integer n = linha = imprimirTodos ? null : Integer.valueOf(FuncoesGerais.pegaLinhaSelecionada(this.panelDireitoExames));
            if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento && ((DadosFaturamento)linhas.getValueAt(linha, 1)).getFaturar()) {
                ArrayList<DadosExameFaturamento> exames = null;
                ArrayList<String> arrayExames = null;
                ArrayList<String> arrayMateriais = null;
                DadosFaturamento dados = (DadosFaturamento)linhas.getValueAt(linha, 1);
                try {
                    ExamesNaoFaturar examesNaoFaturar = ExamesNaoFaturar.getNovaInstancia(this.getTopLevelAncestor());
                    examesNaoFaturar.setTitle("Selecionar exames");
                    examesNaoFaturar.setExames(String.valueOf(dados.getCodigoFilial()), dados.getExames());
                    examesNaoFaturar.setVisible(true);
                    if (!examesNaoFaturar.isOK()) {
                        return;
                    }
                    exames = examesNaoFaturar.getExamesDesmarcados();
                }
                catch (Exception e) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel selecionar os exames para impress\u00e3o", 1);
                    return;
                }
                if (exames != null) {
                    for (int i = 0; i < dados.getExamesCount(); ++i) {
                        DadosExameFaturamento auxExame = dados.getExame(i);
                        if (exames.contains(auxExame)) continue;
                        if (arrayExames == null) {
                            arrayExames = new ArrayList<String>();
                        }
                        if (arrayMateriais == null) {
                            arrayMateriais = new ArrayList<String>();
                        }
                        arrayExames.add(auxExame.getExamePai() != null ? auxExame.getExamePai().getCodigo() : auxExame.getCodigoExame());
                        arrayMateriais.add(String.valueOf(auxExame.getExamePai() != null ? auxExame.getExamePai().getMaterial() : auxExame.getCodigoMaterial().intValue()));
                    }
                }
                int codigoRequisicao = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getRequisicao();
                String codigoFilial = String.valueOf(((DadosFaturamento)linhas.getValueAt(linha, 1)).getCodigoFilial());
                try {
                    RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExames(impressoraSelecionada, this.getTopLevelAncestor(), codigoFilial, String.valueOf(codigoRequisicao), true, ParametrosGerais.getConferencia(), null, arrayExames != null ? arrayExames.toArray(new String[arrayExames.size()]) : null, arrayMateriais != null ? arrayMateriais.toArray(new String[arrayMateriais.size()]) : null, false, "", false, false, null, false, "", false, false, false);
                    if (Funcoes.textoVazio(impressoraSelecionada)) {
                        impressoraSelecionada = retorno.getImpressoraSelecionada();
                    }
                }
                catch (SQLException ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConferenciaFatura (1896)");
                }
                FuncoesGerais.repaintTabela(this.panelDireitoExames, linha);
            } else {
                Funcoes.mensagem(this, "Nenhuma requisi\u00e7\u00e3o selecionada para impress\u00e3o.", 2);
            }
        }
        this.faturaSalva = false;
    }

    private void novo() {
        this.limpaCampos();
        this.status = 2;
        this.controlaCampos();
        ScreenUtil.requisitarFoco(this.txtFatura);
    }

    private void limpaCampos() {
        Laboratorio.getInstancia().setInterromperInfoRequisicao(false);
        this.txtFatura.clear();
        this.faturaSalva = false;
        this.faturaConferida = false;
        this.notaFiscalAssociada = false;
        this.imprimirAgrupada = false;
        this.panelDireitoExames.removeAll();
        this.panelDireitoValorRestanteFaturar.removeAll();
        this.panelDireitoExames.repaint();
        this.panelDireitoValorRestanteFaturar.repaint();
        this.panelDireitoObs.setVisible(false);
        this.chamaAtencao.stop();
        this.codigoConvenio = null;
        this.valorRestanteFatura = BigDecimal.ZERO;
        if (this.listaAssociacoes != null) {
            this.listaAssociacoes.clear();
        }
    }

    private void controlaCampos() {
        boolean habilita;
        boolean bl = habilita = this.status == 2;
        boolean faturaCarregada = FuncoesGerais.pegaTabela(this.panelDireitoExames) == null ? false : FuncoesGerais.pegaTabela(this.panelDireitoExames).getModel().getRowCount() > 0;
        this.txtFatura.setEnabled(habilita && !this.executandoBusca && !faturaCarregada);
        this.buttonFatura.setEnabled(habilita && !this.executandoBusca && !faturaCarregada);
        this.buttonConsultar.setEnabled(habilita && !this.executandoBusca && !faturaCarregada);
        this.buttonNovo.setEnabled(!habilita && !this.executandoBusca || this.faturaConferida);
        this.buttonSalvar.setEnabled(habilita && !this.faturaConferida && !this.executandoBusca && faturaCarregada);
        this.buttonCancelar.setEnabled(habilita && !this.executandoBusca && !this.faturaConferida);
        this.buttonImprimir.setEnabled(habilita && !this.executandoBusca && faturaCarregada);
        this.buttonFechar.setEnabled(!habilita && !this.executandoBusca);
        this.buttonOpcoes.setEnabled(habilita && !this.faturaConferida && !this.executandoBusca);
        this.buttonEletronico.setEnabled(habilita && !this.executandoBusca && faturaCarregada);
        boolean temValorRestante = true;
        if (!Funcoes.textoVazio(this.txtFatura.getText()) && this.valorRestanteFatura != null) {
            temValorRestante = this.valorRestanteFatura.doubleValue() > 0.0;
        }
        this.itemImprimirNota.setEnabled(habilita && temValorRestante && !this.executandoBusca);
    }

    public static Long getModuloAcesso() {
        return Long.parseLong("0600200200");
    }

    @Override
    public void pressioneiF2() {
        if (this.txtFatura.hasFocus()) {
            this.buttonFatura.doClick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pesquisaFaturamento() {
        ResultSet rs;
        Statement st;
        StringBuilder buf;
        if (!Funcoes.isNumeric(this.txtFatura.getText())) {
            Funcoes.mensagem(this, "C\u00f3digo da fatura n\u00e3o informado", 1);
            this.txtFatura.grabFocus();
            return;
        }
        this.buttonConsultar.setEnabled(false);
        this.panelDireitoExames.removeAll();
        this.panelDireitoExames.setLayout(null);
        Laboratorio.getInstancia().setInterromperInfoRequisicao(true);
        BuscaFatura consulta = new BuscaFatura((Frame)this.getTopLevelAncestor(), this.panelDireitoExames, this.buttonConsultar, true, true, this.itemCheckVerificarNaoConferidos.isSelected(), this);
        consulta.setRequisicoesSemPedidoGuia(this.requisicoesSemPedidoGuia);
        consulta.setPararSeConferida(false);
        consulta.setCodigoFatura(this.txtFatura.getText());
        consulta.setAtualizaLabelValorRestante(this.labelValorRestante);
        consulta.addThreadListener(this);
        consulta.start();
        if (!Funcoes.textoVazio(this.txtFatura.getText())) {
            block20: {
                buf = new StringBuilder();
                buf.append("select a.con_codigo from fatura a ");
                buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
                buf.append("where a.fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                buf.append(" and a.fat_codigo = ");
                buf.append(this.txtFatura.getText());
                buf.append(" and a.fat_datacancelamento is null ");
                buf.append(" and b.con_faturaagrupada = true ");
                st = Conexao.getStatement();
                try {
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (!rs.next()) break block20;
                    this.imprimirAgrupada = true;
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaFatura (748)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
        if (!Funcoes.textoVazio(this.txtFatura.getText())) {
            block21: {
                buf = new StringBuilder();
                buf.append(" select fat.fat_dtconferencia ");
                buf.append("       ,nfi.nfi_situacao ");
                buf.append("       ,nfi.nfi_numerorps ");
                buf.append("       ,nfi.con_codigo ");
                buf.append("   from fatura fat ");
                buf.append("   left join faturanotafiscal fnf on fat.fil_codigo = fnf.fil_codigo and fat.fat_codigo = fnf.fat_codigo ");
                buf.append("   left join notafiscal nfi on fnf.fil_codigo = nfi.fil_codigo and fnf.nfi_codigo = nfi.nfi_codigo ");
                buf.append("         and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
                buf.append("         or   (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao IN ('").append("X").append("', '").append("A").append("', '").append("N").append("', '").append("O").append("', '").append("R").append("')))");
                buf.append("  where fat.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and fat.fat_codigo = ").append(this.txtFatura.getText());
                st = Conexao.getStatement();
                try {
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        this.faturaConferida = !DBUtil.campoNull(rs.getString("fat_dtconferencia"));
                        this.notaFiscalAssociada = !DBUtil.campoNull(rs.getString("nfi_situacao")) || !DBUtil.campoNull(rs.getString("nfi_numerorps"));
                        do {
                            if (DBUtil.campoNull(rs.getString("con_codigo"))) continue;
                            this.codigoConvenio = rs.getInt("con_codigo");
                        } while (rs.next());
                        break block21;
                    }
                    this.faturaConferida = false;
                    this.notaFiscalAssociada = false;
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaFatura (748)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
        StringBuilder bui = new StringBuilder();
        bui.append(" select distinct con.con_codigo, con.con_observ ");
        bui.append("   from convenios con ");
        bui.append("   join requisicao req on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        bui.append("   join faturarequisicao fre on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
        bui.append("  where fre.fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append("    and fre.fat_codigo = ").append(this.txtFatura.getText());
        StringBuilder buf2 = new StringBuilder();
        Statement st2 = Conexao.getStatement();
        try {
            ResultSet rs2 = Conexao.executeQuery(st2, bui);
            bui.setLength(0);
            while (rs2.next()) {
                if (Funcoes.textoVazio(rs2.getString("con_observ"))) continue;
                buf2.append(rs2.getString("con_observ")).append("\n\n");
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar as observa\u00e7\u00f5es dos conv\u00eanios.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st2);
                throw throwable;
            }
            Conexao.fecharStatement(st2);
        }
        Conexao.fecharStatement(st2);
        if (buf2.length() > 0) {
            this.textObs.setText(buf2.toString());
            ScreenUtil.posicionaTextoTopo(this.textObs);
            this.panelDireitoObs.setVisible(true);
            this.chamaAtencao.start();
        } else {
            this.panelDireitoObs.setVisible(false);
        }
        this.montaPanelValorRestanteFaturar();
        this.faturaSalva = true;
    }

    private void pesquisaFatura() {
        Hashtable resultado = Pesquisas.fatura(this.getTopLevelAncestor());
        if (resultado != null) {
            this.txtFatura.setText(resultado.get("fat_codigo").toString());
        }
        this.txtFatura.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean salvar(boolean conferir, boolean gerandoNota) {
        Statement st;
        SplashMensagem splash;
        boolean retorno;
        block48: {
            DadosTotalGeral total;
            StringBuilder buf;
            LinhasTabela modeloFatura;
            SeriesVO serie;
            block47: {
                retorno = true;
                serie = null;
                try {
                    serie = (SeriesVO)new SeriesService().getVO(Variaveis.filialPadrao, ParametrosLocais.getParametro("serie"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                if (conferir && serie == null) {
                    Funcoes.mensagem(this, "S\u00e9rie padr\u00e3o n\u00e3o configurada para a esta\u00e7\u00e3o.", 2);
                    return false;
                }
                modeloFatura = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
                if (!Funcoes.isNumeric(this.txtFatura.getText())) {
                    Funcoes.mensagem(this, "C\u00f3digo da fatura n\u00e3o informado", 1);
                    this.txtFatura.grabFocus();
                    return false;
                }
                if (modeloFatura == null || modeloFatura.getRowCount() == 1 && modeloFatura.getValueAt(0, 0) instanceof DadosTotalGeral) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 requisi\u00e7\u00f5es \u00e0 serem conferidas", 2);
                    return false;
                }
                if (!FuncoesGerais.haExamesFaturamento(this.panelDireitoExames)) {
                    Funcoes.mensagem(this, "Deve haver pelo menos um exame selecionado para salvar o faturamento.\nCaso deseje remover o faturamento, use a tela de \"Estorno\".", 2);
                    return false;
                }
                splash = SplashMensagem.getInstancia(this);
                splash.addThreadListener(this);
                st = Conexao.getStatement();
                buf = new StringBuilder();
                if (modeloFatura.getValueAt(modeloFatura.getRowCount() - 1, 0) instanceof DadosTotalGeral) {
                    total = (DadosTotalGeral)modeloFatura.getValueAt(modeloFatura.getRowCount() - 1, 0);
                    break block47;
                }
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel obter dados para faturamento", 1);
                boolean bl = false;
                Conexao.fecharStatement(st);
                splash.apagar();
                System.gc();
                return bl;
            }
            try {
                int i;
                String msg = "Aguarde, salvando dados do faturamento. ";
                splash.mostrar(msg);
                ArrayList<DadosFaturamento> requisicoesfaturadas = new ArrayList<DadosFaturamento>();
                for (i = 0; i < modeloFatura.getRowCount(); ++i) {
                    if (!(modeloFatura.getValueAt(i, 0) instanceof DadosFaturamento)) continue;
                    requisicoesfaturadas.add((DadosFaturamento)modeloFatura.getValueAt(i, 0));
                }
                this.service.processarRequisicoesSemPedidoGuia(this.requisicoesSemPedidoGuia);
                this.service.processarRequisicoesComGuiaAlterada(this.requisicoesComGuiaAlterada);
                this.service.processarExamesAlterados(requisicoesfaturadas);
                this.service.processarRequisicoesComDataDeFaturaAlterada(this.requisicoesComDataFaturaAlterada, requisicoesfaturadas, this.txtFatura.getText());
                buf.append("update fatura ");
                buf.append("   set fat_qtderequisicao = ").append(total.getQtdeRequisicoes());
                buf.append("      ,fat_qtdeexames = ").append(total.getQtdeExames());
                buf.append("      ,fat_qtdeguias = ").append(total.getQtdeGuias());
                buf.append("      ,fat_totalexames = ").append(Funcoes.limpaDecimal(String.valueOf(total.getTotalExames())));
                buf.append("      ,fat_totalexamesch = ").append(Funcoes.limpaDecimal(String.valueOf(total.getTotalExamesCH())));
                buf.append("      ,fat_totalmateriais = ").append(Funcoes.limpaDecimal(String.valueOf(total.getTotalMateriais())));
                buf.append("      ,fat_percdesconto = ").append(Funcoes.limpaDecimal(String.valueOf(total.getPercentualBonus())));
                buf.append("      ,fat_percacrescimo = ").append(Funcoes.limpaDecimal(String.valueOf(total.getPercentualAcrescimo())));
                buf.append("      ,fat_despcobranca = ").append(Funcoes.limpaDecimal(String.valueOf(total.getCobranca())));
                buf.append("      ,fat_adicional = ").append(Funcoes.limpaDecimal(String.valueOf(total.getAdicional())));
                buf.append("      ,fat_mensagem = '").append(total.getMensagem()).append("' ");
                buf.append("      ,fat_descricaoacrescimo = '").append(total.getDescricaoAcrescimo()).append("' ");
                buf.append("      ,fat_descricaodesconto = '").append(total.getDescricaoDesconto()).append("' ");
                buf.append("      ,fat_dtvenc = '").append(Funcoes.formataData("yyyy-MM-dd", total.getVencimento())).append("' ");
                if (conferir) {
                    buf.append(", usr_codconferencia = '");
                    buf.append(Variaveis.login);
                    buf.append("', fat_dtconferencia = current_timestamp ");
                }
                buf.append(" where fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                buf.append(" and fat_codigo = ");
                buf.append(this.txtFatura.getText());
                Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
                System.gc();
                for (i = 0; i < modeloFatura.getRowCount() - 1; ++i) {
                    DadosFaturamento dados = (DadosFaturamento)modeloFatura.getValueAt(i, 0);
                    if (!dados.isDadosAlterados()) continue;
                    for (int j = 0; j < dados.getExamesCount(); ++j) {
                        DadosExameFaturamento exame = dados.getExame(j);
                        if (exame.getFaturar()) continue;
                        buf.delete(0, buf.length());
                        buf.append("update examerequisicao set ");
                        if (FuncoesGerais.convenioRepasseFaturado(st, dados)) {
                            buf.append("  exr_datafaturarepasse = null ");
                            buf.append(" ,usr_codfaturarepasse = null ");
                            buf.append(" ,exr_datafatura = null ");
                            buf.append(" ,usr_codfatura = null ");
                        } else {
                            buf.append("  exr_datafatura = null ");
                            buf.append(" ,usr_codfatura = null ");
                        }
                        if (!exame.isConvenioRepasse()) {
                            buf.append(" ,exr_deveguia = ").append(exame.getDeveGuia());
                            buf.append(" ,exr_guia = ").append(exame.getCodigoGuia() == null ? null : "'" + exame.getCodigoGuia().trim() + "'");
                            if (exame.getValidadeGuia() != null) {
                                buf.append(" ,exr_validadeguia = '").append(exame.getValidadeGuia()).append("' ");
                            } else {
                                buf.append(" ,exr_validadeguia = null ");
                            }
                        }
                        buf.append(" where fil_codigo = ");
                        buf.append(dados.getCodigoFilial());
                        buf.append(" and req_codigo = ");
                        buf.append(dados.getRequisicao());
                        DadosExamePaiAgrupamento examePai = exame.getExamePai();
                        if (examePai != null) {
                            buf.append(" and exa_codigo = '");
                            buf.append(examePai.getCodigo());
                            buf.append("' and mco_codigo = ");
                            buf.append(String.valueOf(examePai.getMaterial()));
                        } else {
                            buf.append(" and exa_codigo = '");
                            buf.append(exame.getCodigoExame());
                            buf.append("' and mco_codigo = ");
                            buf.append(String.valueOf(exame.getCodigoMaterial()));
                        }
                        Conexao.executeUpdate(String.valueOf(dados.getCodigoFilial()), st, buf.toString());
                        if (examePai != null) {
                            ExportaFiliais.gravaRequisicao(dados.getCodigoFilial(), dados.getRequisicao(), examePai.getCodigo(), examePai.getMaterial(), "U", "U");
                            continue;
                        }
                        ExportaFiliais.gravaRequisicao(dados.getCodigoFilial(), dados.getRequisicao(), exame.getCodigoExame(), exame.getCodigoMaterial(), "U", "U");
                    }
                }
                String requisicoesExcluidas = this.getCodigosRequisicoesRemovidas();
                if (!Funcoes.textoVazio(requisicoesExcluidas)) {
                    buf.delete(0, buf.length());
                    buf.append("delete from faturarequisicao where fil_codigo = ");
                    buf.append(Variaveis.filialPadrao);
                    buf.append(" and req_codigo in (").append(requisicoesExcluidas).append(") ");
                    buf.append(" and fat_codigo = ");
                    buf.append(this.txtFatura.getText());
                    Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
                }
                for (int i2 = 0; i2 < modeloFatura.getRowCount() - 1; ++i2) {
                    DadosFaturamento dados = (DadosFaturamento)modeloFatura.getValueAt(i2, 0);
                    if (!dados.getFaturar()) continue;
                    splash.setText(msg + i2 * 100 / modeloFatura.getRowCount() + "%");
                    if (dados.isDadosAlterados()) {
                        buf.setLength(0);
                        buf.append("update faturarequisicao set ");
                        buf.append(" fre_total = ").append(Funcoes.limpaDecimal(String.valueOf(dados.getValorTotal())));
                        buf.append(",fre_totalch = ").append(Funcoes.limpaDecimal(String.valueOf(dados.getValorTotalCH())));
                        buf.append(",fre_totalexames = ").append(Funcoes.limpaDecimal(String.valueOf(dados.getValorTotalExames())));
                        buf.append(",fre_totalmateriais = ").append(Funcoes.limpaDecimal(String.valueOf(dados.getValorTotalMateriais())));
                        buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                        buf.append(" and fil_kodigo = ").append(String.valueOf(dados.getCodigoFilial()));
                        buf.append(" and fat_codigo = ").append(this.txtFatura.getText());
                        buf.append(" and req_codigo = ").append(dados.getRequisicao());
                        buf.append(" and con_codigo = ").append(dados.getCodigoConvenio());
                        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf.toString());
                    }
                    this.service.atualizarExamesNoBancoDeDados(dados, this.txtFatura.getText(), st);
                    if (!dados.isDadosAlterados()) continue;
                    buf.delete(0, buf.length());
                    buf.append(" update requisicao ");
                    if (dados.getCodigoConvenio() == dados.getCodigoConvenioPrincipal()) {
                        buf.append("      set req_guiaprincipal = ").append(dados.getGuiaPrincipal() == null ? null : "'" + dados.getGuiaPrincipal() + "'");
                    } else {
                        buf.append("    set req_guiarepasse = ").append(dados.getGuiaRepasse() == null ? null : "'" + dados.getGuiaRepasse() + "'");
                        buf.append("       ,req_guiaprincipalrepasse = ").append(dados.getGuiaPrincipal() == null ? null : "'" + dados.getGuiaPrincipal() + "'");
                        if (dados.getValidadeGuiaRepasse() == null) {
                            buf.append("       ,req_validadeguiarepasse = null");
                        } else {
                            buf.append("       ,req_validadeguiarepasse = '").append(dados.getValidadeGuiaRepasse()).append("' ");
                        }
                    }
                    buf.append(" where fil_codigo = ").append(dados.getCodigoFilial());
                    buf.append("   and req_codigo = ").append(dados.getRequisicao());
                    Conexao.executeUpdate(String.valueOf(dados.getCodigoFilial()), st, buf.toString());
                }
                if (conferir) {
                    ReceberPagarService service = new ReceberPagarService();
                    FaturaService serviceFatura = new FaturaService();
                    FaturaReceberPagarService serviceFaturaRecPag = new FaturaReceberPagarService();
                    Set<ConvenioEntidadeBean> listaConvenioEntidade = new ConvenioEntidadeService().getRepresentantesConvenio(Variaveis.filialPadrao, total.getCodigoConvenio().toString());
                    if (listaConvenioEntidade != null) {
                        Iterator<ConvenioEntidadeBean> it = listaConvenioEntidade.iterator();
                        UsuarioVO usuario = new UsuarioVO();
                        usuario.setCodigo(Variaveis.login);
                        FaturaBean fatura = (FaturaBean)serviceFatura.get(Variaveis.filialPadrao, total.getCodigoFatura().toString());
                        FilialVO filial = new FilialVO();
                        filial = (FilialVO)new FilialDao().getVO(Variaveis.filialPadrao);
                        while (it.hasNext()) {
                            ConvenioEntidadeBean convenioEntidade = it.next();
                            if (!convenioEntidade.getTipoParcela().equalsIgnoreCase("C") || fatura.getComissaoGerada()) continue;
                            fatura.setCodigoUsuarioComissao(usuario);
                            fatura.setDataComissao(new Date());
                            serviceFatura.gravaAutoCopiaSemCommit(fatura, 1, Variaveis.filialPadrao, null);
                            if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("E") || convenioEntidade.getTipoPagamento().equalsIgnoreCase("V")) {
                                ReceberPagarBean recpag = this.getReceberPagarBasicoComissao(null);
                                recpag.setFilial(filial);
                                recpag.setUsuario(usuario);
                                recpag.setSerie(serie);
                                recpag.setEntidade(convenioEntidade.getEntidade());
                                recpag.setValor(total.getTotal().multiply(BigDecimal.valueOf(convenioEntidade.getPercentualComissao())).divide(BigDecimal.valueOf(100.0).setScale(2, RoundingMode.HALF_UP), RoundingMode.HALF_UP).doubleValue());
                                recpag.setParcela(1);
                                recpag.setOrigem("C");
                                recpag.setObservacao("PAGAMENTO DE COMISS\u00c3O - FATURA C\u00d3D.: " + fatura.getCodigo() + " - COMISS\u00c3O GERADA PELA CONFER\u00caNCIA DA FATURA.");
                                recpag = FinanceiroUtil.atualizaTotalSemRecalculo(recpag);
                                if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("E")) {
                                    recpag.setDataVencimento(fatura.getDataEmissao());
                                    recpag.setDataCompetencia(fatura.getDataEmissao());
                                    recpag.setDataDocumento(fatura.getDataEmissao());
                                } else if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("V")) {
                                    recpag.setDataVencimento(fatura.getVencimento());
                                    recpag.setDataCompetencia(fatura.getVencimento());
                                    recpag.setDataDocumento(fatura.getVencimento());
                                }
                                service.gravaAutoCopiaSemCommit(recpag, 0, Variaveis.filialPadrao, null);
                                FaturaReceberPagarBean faturaRecPag = new FaturaReceberPagarBean();
                                faturaRecPag.setFilial(recpag.getFilial());
                                faturaRecPag.setFatura((FaturaVO)fatura.toVO());
                                faturaRecPag.setReceberPagar((ReceberPagarVO)recpag.toVO());
                                faturaRecPag.setTipo("C");
                                serviceFaturaRecPag.insert(faturaRecPag, null, Variaveis.filialPadrao, null);
                                continue;
                            }
                            Double valorComissao = total.getTotal().multiply(BigDecimal.valueOf(convenioEntidade.getPercentualComissao())).divide(BigDecimal.valueOf(100.0).setScale(2, RoundingMode.HALF_UP), RoundingMode.HALF_UP).doubleValue();
                            Set parcelas = new FormaPagamentoParcelaService().load(" where fil_codigo = " + Variaveis.filialPadrao + " and fpg_codigo = " + convenioEntidade.getFormaPagamento().getCodigo());
                            Date dataInicial = null;
                            if (convenioEntidade.getTipoPagamento().equalsIgnoreCase("A")) {
                                dataInicial = fatura.getVencimento();
                            } else {
                                Calendar calendar = Calendar.getInstance();
                                calendar.set(5, convenioEntidade.getDiaComissao());
                                calendar.add(2, 1);
                                dataInicial = calendar.getTime();
                            }
                            ArrayList<ReceberPagarBean> listaRecPag = FinanceiroUtil.gerarParcelas(valorComissao, valorComissao, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, dataInicial, "P", parcelas);
                            for (int i3 = 0; i3 < listaRecPag.size(); ++i3) {
                                ReceberPagarBean beanRecpag = listaRecPag.get(i3);
                                beanRecpag = this.getReceberPagarBasicoComissao(beanRecpag);
                                beanRecpag.setFilial(filial);
                                beanRecpag.setUsuario(usuario);
                                beanRecpag.setSerie(serie);
                                beanRecpag.setEntidade(convenioEntidade.getEntidade());
                                beanRecpag.setObservacao("PAGAMENTO DE COMISS\u00c3O - FATURA C\u00d3D.: " + fatura.getCodigo() + " - COMISS\u00c3O GERADA PELA CONFER\u00caNCIA DA FATURA.");
                                beanRecpag.setOrigem("C");
                                beanRecpag.setDataCompetencia(beanRecpag.getDataVencimento());
                                beanRecpag.setDataDocumento(beanRecpag.getDataVencimento());
                                service.gravaAutoCopiaSemCommit(beanRecpag, 0, Variaveis.filialPadrao, null);
                                FaturaReceberPagarBean faturaRecPag = new FaturaReceberPagarBean();
                                faturaRecPag.setFilial(beanRecpag.getFilial());
                                faturaRecPag.setFatura((FaturaVO)fatura.toVO());
                                faturaRecPag.setReceberPagar((ReceberPagarVO)beanRecpag.toVO());
                                faturaRecPag.setTipo("C");
                                serviceFaturaRecPag.insert(faturaRecPag, null, Variaveis.filialPadrao, null);
                            }
                        }
                    }
                }
                Conexao.arquivaSQL();
                this.faturaConferida = conferir;
                FuncoesGerais.repaintTabela(this.panelDireitoExames);
                this.montaPanelValorRestanteFaturar();
                splash.apagar();
                if (conferir && !gerandoNota) {
                    ArrayList<ReceberPagarVO> listaPreviasFaturamento = null;
                    try {
                        listaPreviasFaturamento = new FaturaReceberPagarService().getListaPreviasFaturamento(Variaveis.filialPadrao, String.valueOf(this.txtFatura.getText()));
                    }
                    catch (ThreadDaoException e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar lista de pr\u00e9vias de recebimento do faturamento.\n" + e.getMessage(), e.getStackTrace());
                        retorno = false;
                    }
                    if (ParametrosGerais.isGerarPreviasFaturamento() && (listaPreviasFaturamento == null || listaPreviasFaturamento.size() == 0) && this.invocaTelaGeracaoPreviasFaturamento(total.getCodigoConvenio(), total.getTotal().doubleValue())) {
                        Funcoes.mensagem(this, "A fatura foi conferida e as pr\u00e9vias foram geradas com sucesso.", 5);
                    }
                    break block48;
                }
                Funcoes.mensagem(this, "A fatura foi " + (conferir ? "conferida" : "salva") + " com sucesso.", 5);
            }
            catch (Exception ex) {
                try {
                    retorno = false;
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConferenciaFatura (887)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    splash.apagar();
                    System.gc();
                    throw throwable;
                }
                Conexao.fecharStatement(st);
                splash.apagar();
                System.gc();
            }
        }
        Conexao.fecharStatement(st);
        splash.apagar();
        System.gc();
        return retorno;
    }

    private boolean invocaTelaGeracaoPreviasFaturamento(Integer codigoConvenio, Double valorFatura) {
        JanelaPreviaFaturamento janela = JanelaPreviaFaturamento.getInstancia((Window)this.getTopLevelAncestor(), Integer.parseInt(this.txtFatura.getText()), codigoConvenio, valorFatura);
        janela.setVisible(true);
        return janela.getOK();
    }

    private ReceberPagarBean getReceberPagarBasicoComissao(ReceberPagarBean recpag) {
        if (recpag == null) {
            recpag = new ReceberPagarBean();
        }
        recpag.setSituacao("A");
        recpag.setDataHora(new Date());
        recpag.setTipo("P");
        recpag.setTipoDocumento("D");
        recpag.setTipoJuro("V");
        recpag.setPercentualMulta(0.0);
        recpag.setPercentualDesconto(0.0);
        recpag.setPercentualAcrescimo(0.0);
        recpag.setIrrfPercentual(0.0);
        recpag.setIssPercentual(0.0);
        recpag.setPisPercentual(0.0);
        recpag.setCsllPercentual(0.0);
        recpag.setCofinsPercentual(0.0);
        recpag.setInssPercentual(0.0);
        recpag.setValorMulta(0.0);
        recpag.setValorDesconto(0.0);
        recpag.setValorAcrescimo(0.0);
        recpag.setTaxa(0.0);
        recpag.setIrrfValor(0.0);
        recpag.setIssValor(0.0);
        recpag.setPisValor(0.0);
        recpag.setCsllValor(0.0);
        recpag.setCofinsValor(0.0);
        recpag.setInssValor(0.0);
        recpag.setPercentualJuro(0.0);
        recpag.setValorJuro(0.0);
        recpag.setNumeroDocumento(null);
        recpag.setCodigoDocumento(null);
        recpag.setDataProcessamento(new Date());
        recpag.setTipoCadastro("R");
        return recpag;
    }

    private boolean verificaDataInicioFim(Date novaData, int filialRequisicao, Date maior, Date menor) {
        if (novaData.after(menor) && novaData.before(maior)) {
            return true;
        }
        return novaData.compareTo(menor) == 0 || novaData.compareTo(maior) == 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.itemImprimirFatura) {
            this.imprimirFatura(this.imprimirAgrupada);
        } else if (e.getSource() == this.itemImprimirNota) {
            this.imprimirNota();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imprimirNota() {
        block36: {
            DadosTotalGeral dados;
            ArrayList<ReceberPagarBean> listaPreviasFaturamento;
            block37: {
                Double total;
                boolean[] conferidas;
                String[] faturas;
                int codigoConvenio;
                block34: {
                    Statement st;
                    block38: {
                        block33: {
                            boolean salvar;
                            LinhasTabela modeloFatura = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
                            if (modeloFatura == null || modeloFatura.getRowCount() == 0) {
                                Funcoes.mensagem(this, "Nenhuma fatura selecionada para impress\u00e3o", 2);
                                return;
                            }
                            BigDecimal valorRestante = this.getValorRestanteFatura();
                            if (valorRestante.doubleValue() == 0.0) {
                                Funcoes.mensagem(this, "N\u00e3o h\u00e1 valor restante a faturar.", 2);
                                return;
                            }
                            listaPreviasFaturamento = null;
                            try {
                                listaPreviasFaturamento = new FaturaReceberPagarService().getListaPreviasFaturamentoBean(Variaveis.filialPadrao, this.txtFatura.getText());
                            }
                            catch (Exception e) {
                                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar lista de pr\u00e9vias de recebimento do faturamento.\n" + e.getMessage(), e.getStackTrace());
                                return;
                            }
                            boolean bl = salvar = this.faturaConferida || Funcoes.mensagem(this, "Para gerar/imprimir a nota fiscal a fatura deve ser conferida.\nDeseja conferir a fatura?", 4) == 0;
                            if (!salvar) {
                                return;
                            }
                            if (!this.faturaSalva) {
                                this.faturaSalva = this.salvar(false, true);
                            } else {
                                this.faturaSalva = this.salvar(true, true);
                                this.controlaCampos();
                            }
                            this.controlaCampos();
                            this.buttonImprimir.setEnabled(false);
                            int codigoFatura = Integer.parseInt(this.txtFatura.getText());
                            if (!this.faturaSalva || codigoFatura <= -1) break block36;
                            NotaFiscalFatura f = NotaFiscalFatura.novainstancia(this.getTopLevelAncestor());
                            LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
                            if (linhas == null || !(linhas.getValueAt(linhas.getRowCount() - 1, 0) instanceof DadosTotalGeral)) {
                                return;
                            }
                            dados = (DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0);
                            codigoConvenio = -1;
                            st = Conexao.getStatement();
                            StringBuilder bui = new StringBuilder("select con_codigo from fatura where fil_codigo = ");
                            bui.append(Variaveis.filialPadrao);
                            bui.append(" and fat_codigo = ");
                            bui.append(this.txtFatura.getText());
                            try {
                                ResultSet rs = Conexao.executeQuery(st, bui.toString());
                                if (rs.next()) {
                                    codigoConvenio = rs.getInt("con_codigo");
                                }
                            }
                            catch (Exception e1) {
                                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "ConferenciaFatura: 1028");
                            }
                            valorRestante = this.getValorRestanteFatura();
                            if (valorRestante.doubleValue() == 0.0) {
                                Funcoes.mensagem(this, "N\u00e3o h\u00e1 valor restante a faturar.", 2);
                                return;
                            }
                            f.setFaturaAtual(String.valueOf(codigoFatura), Funcoes.formataData(new Date()), Funcoes.formataDecimal(valorRestante.doubleValue()));
                            f.setVisible(true);
                            if (!f.getOK()) break block37;
                            faturas = new String[]{String.valueOf(codigoFatura)};
                            conferidas = null;
                            total = dados.getTotal().doubleValue();
                            if (f.getOpcaoSelecionada() != 2) break block38;
                            faturas = f.getFaturasSelecionadas();
                            conferidas = new boolean[faturas.length];
                            FaturaService serviceFatura = new FaturaService();
                            try {
                                for (int i = 0; i < faturas.length; ++i) {
                                    conferidas[i] = serviceFatura.isFaturaConferida(Variaveis.filialPadrao, faturas[i]);
                                }
                            }
                            catch (Exception e) {
                                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar a situa\u00e7\u00e3o das faturas.\n" + e.getMessage(), e.getStackTrace(), "ConferenciaFatura: imprimiNota");
                                Conexao.fecharStatement(st);
                                return;
                            }
                            total = 0.0;
                            StringBuilder buf = new StringBuilder();
                            for (String s : faturas) {
                                if (buf.length() > 0) {
                                    buf.append(", ");
                                }
                                buf.append(s);
                            }
                            String tmp = buf.toString();
                            buf.setLength(0);
                            buf.append("select sum(fat_totalexames + fat_totalmateriais + fat_adicional + fat_despcobranca + ((fat_totalexames + fat_totalmateriais) * fat_percacrescimo / 100) - ((fat_totalexames + fat_totalmateriais) * fat_percdesconto / 100)) as total from fatura fat ");
                            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
                            buf.append(" and fat_codigo in (").append(tmp).append(")");
                            buf.append(" and fat.fat_datacancelamento is null ");
                            st = Conexao.getStatement();
                            try {
                                ResultSet rs = Conexao.executeQuery(st, buf);
                                if (!rs.next()) break block33;
                                total = rs.getDouble("total");
                            }
                            catch (Exception e) {
                                try {
                                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel calcular o valor da fatura.\n" + e.getMessage(), e.getStackTrace());
                                }
                                catch (Throwable throwable) {
                                    Conexao.fecharStatement(st);
                                    throw throwable;
                                }
                                Conexao.fecharStatement(st);
                                break block34;
                            }
                        }
                        Conexao.fecharStatement(st);
                        break block34;
                    }
                    try {
                        conferidas = new boolean[]{new FaturaService().isFaturaConferida(Variaveis.filialPadrao, faturas[0])};
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar a situa\u00e7\u00e3o das faturas.\n" + e.getMessage(), e.getStackTrace(), "ConferenciaFatura: imprimiNota");
                        Conexao.fecharStatement(st);
                        return;
                    }
                }
                DialogNotaFiscalSaida dialogNota = NotaFiscalSaida.novaInstancia((Window)this.getTopLevelAncestor(), false, listaPreviasFaturamento, Variaveis.filialPadrao);
                NotaFiscalSaida nota = null;
                if (dialogNota != null) {
                    nota = dialogNota.getNotaFiscalSaida();
                }
                if (nota != null) {
                    nota.setAcessos(600200211L, 600200212L);
                    nota.setDataEmissao(new Date());
                    nota.setCadastro("O", String.valueOf(codigoConvenio));
                    nota.setSubTotal(total);
                    nota.setFaturasRelacionadas(faturas);
                    nota.setFaturasConferidas(conferidas);
                    dialogNota.setVisible(true);
                }
                if (nota != null && !nota.isOk() && ParametrosGerais.isGerarPreviasFaturamento() && (listaPreviasFaturamento == null || listaPreviasFaturamento.size() == 0)) {
                    this.invocaTelaGeracaoPreviasFaturamento(dados.getCodigoConvenio(), dados.getTotal().doubleValue());
                }
                break block36;
            }
            if (ParametrosGerais.isGerarPreviasFaturamento() && (listaPreviasFaturamento == null || listaPreviasFaturamento.size() == 0)) {
                this.invocaTelaGeracaoPreviasFaturamento(dados.getCodigoConvenio(), dados.getTotal().doubleValue());
            }
        }
        this.buttonImprimir.setEnabled(true);
        if (!Funcoes.textoVazio(this.txtFatura.getText())) {
            Statement st;
            block35: {
                StringBuilder buf = new StringBuilder();
                buf.append(" select fat.fat_dtconferencia ");
                buf.append("       ,nfi.nfi_situacao ");
                buf.append("   from fatura fat ");
                buf.append("   left join faturanotafiscal fnf on fat.fil_codigo = fnf.fil_codigo and fat.fat_codigo = fnf.fat_codigo ");
                buf.append("   left join notafiscal nfi on fnf.fil_codigo = nfi.fil_codigo and fnf.nfi_codigo = nfi.nfi_codigo ");
                buf.append("                    and ((nfi.nfi_numerorps IS NULL and nfi.nfi_situacao IN ('").append("A").append("', '").append("I").append("')) ");
                buf.append("                      or (nfi.nfi_numerorps IS NOT NULL and nfi.nfi_situacao IN ('").append("X").append("', '").append("A").append("', '").append("N").append("', '").append("O").append("') ) ) ");
                buf.append("  where fat.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and fat.fat_codigo = ").append(this.txtFatura.getText());
                st = Conexao.getStatement();
                try {
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        this.faturaConferida = rs.getString("fat_dtconferencia") != null;
                        this.notaFiscalAssociada = rs.getString("nfi_situacao") != null;
                        break block35;
                    }
                    this.faturaConferida = false;
                    this.notaFiscalAssociada = false;
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConferenciaFatura (748)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ConferenciaFatura.this.faturaConferida) {
                    ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(ConferenciaFatura.this.panelDireitoExames).getDefaultRenderer(Object.class)).setCheckBoxVisivel(false);
                    ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(ConferenciaFatura.this.panelDireitoExames).getDefaultEditor(Object.class)).setCheckBoxVisivel(false);
                    FuncoesGerais.removeExamesDeselecionadosFaturamento(ConferenciaFatura.this.panelDireitoExames);
                    FuncoesGerais.repaintTabela(ConferenciaFatura.this.panelDireitoExames);
                }
            }
        });
        this.montaPanelValorRestanteFaturar();
        this.controlaCampos();
    }

    private BigDecimal getValorRestanteFatura() {
        this.valorRestanteFatura = BigDecimal.ZERO;
        try {
            this.valorRestanteFatura = new FaturaService().getValorRestanteFatura(Variaveis.filialPadrao.toString(), this.txtFatura.getText());
        }
        catch (SQLException e2) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar o valor restante a faturar.\n" + e2.getMessage(), e2.getStackTrace());
        }
        return this.valorRestanteFatura;
    }

    private void imprimirFatura(boolean agrupar) {
        LinhasTabela modeloFatura = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        if (modeloFatura == null || modeloFatura.getRowCount() == 0) {
            Funcoes.mensagem(this, "Nenhuma fatura selecionada para confer\u00eancia", 2);
            return;
        }
        boolean conferir = false;
        if (!this.faturaConferida) {
            conferir = Funcoes.mensagem(this, "Deseja marcar a fatura como conferida?", 4) == 0;
            this.faturaSalva = this.salvar(conferir, false);
        }
        StringBuilder buf = new StringBuilder();
        if (conferir) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(ConferenciaFatura.this.panelDireitoExames).getDefaultRenderer(Object.class)).setCheckBoxVisivel(false);
                    ((EditorDadosFaturamento)FuncoesGerais.pegaTabela(ConferenciaFatura.this.panelDireitoExames).getDefaultEditor(Object.class)).setCheckBoxVisivel(false);
                    FuncoesGerais.removeExamesDeselecionadosFaturamento(ConferenciaFatura.this.panelDireitoExames);
                    FuncoesGerais.repaintTabela(ConferenciaFatura.this.panelDireitoExames);
                }
            });
        }
        this.buttonImprimir.setEnabled(false);
        Statement st = Conexao.getStatement();
        try {
            int codigoConvenio = -1;
            if (buf.length() > 0) {
                Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
            }
            buf.setLength(0);
            buf.append("select con_codigo from fatura where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and fat_codigo = ");
            buf.append(this.txtFatura.getText());
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                codigoConvenio = rs.getInt("con_codigo");
            }
            rs.close();
            if (this.faturaSalva && !Funcoes.textoVazio(this.txtFatura.getText())) {
                if (codigoConvenio > -1) {
                    SplashMensagem telaEspera = new SplashMensagem();
                    telaEspera.addThreadListener(this);
                    telaEspera.mostrar("Gerando faturamento eletr\u00f4nico. Aguarde...");
                    ImprimirFatura.imprimir(Integer.parseInt(this.txtFatura.getText()), codigoConvenio, agrupar, true);
                    if (ConvenioUtil.isImprimirResumoFatura(Variaveis.filialPadrao, String.valueOf(codigoConvenio))) {
                        ImprimirResumoFatura.imprimir(Integer.parseInt(this.txtFatura.getText()), codigoConvenio);
                    }
                    telaEspera.apagar();
                } else {
                    Funcoes.mensagem(this, "Nenhum conv\u00eanio foi encontrado para imprimir a confer\u00eancia", 2);
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConferenciaFatura");
        }
        Conexao.fecharStatement(st);
        this.buttonImprimir.setEnabled(true);
    }

    @Override
    public void threadIniciada(EventObject e) {
        this.executandoBusca = true;
        this.controlaCampos();
    }

    @Override
    public void threadFinalizada(EventObject e) {
        this.executandoBusca = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConferenciaFatura.this.controlaCampos();
            }
        });
    }

    private void marcarDesmarcarPedidoGuia() {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        int linha = FuncoesGerais.pegaLinhaSelecionada(this.panelDireitoExames);
        if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento) {
            boolean deviaGuia = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getDeveGuia();
            boolean deveGuia = !((DadosFaturamento)linhas.getValueAt(linha, 1)).getDeveGuia();
            ((DadosFaturamento)linhas.getValueAt(linha, 1)).setDeveGuia(deveGuia);
            int filial = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getCodigoFilial();
            int codigoRequisicao = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getRequisicao();
            Registro selecionadoNaTela = new Registro();
            selecionadoNaTela.setValor("deviaGuia", deviaGuia);
            selecionadoNaTela.setValor("deveGuia", deveGuia);
            selecionadoNaTela.setValor("codigoFilial", filial);
            selecionadoNaTela.setValor("codigoRequisicao", codigoRequisicao);
            if (!this.requisicoesSemPedidoGuia.isEmpty()) {
                boolean atualizouRegistro = false;
                for (Registro reqSemPedidoGuia : this.requisicoesSemPedidoGuia) {
                    if (reqSemPedidoGuia.getInt("codigoFilial") != filial || reqSemPedidoGuia.getInt("codigoRequisicao") != codigoRequisicao) continue;
                    reqSemPedidoGuia.setValor("deviaGuia", deviaGuia);
                    reqSemPedidoGuia.setValor("deveGuia", deveGuia);
                    atualizouRegistro = true;
                    break;
                }
                if (!atualizouRegistro) {
                    this.requisicoesSemPedidoGuia.add(selecionadoNaTela);
                }
            } else {
                this.requisicoesSemPedidoGuia.add(selecionadoNaTela);
            }
            FuncoesGerais.repaintTabela(this.panelDireitoExames);
            this.faturaSalva = false;
        }
    }

    private void alterarGuiaExames() {
        Dialog telaAlteracao = null;
        ArrayList<DadosExameFaturamento> listaExames = null;
        DadosFaturamento dados = null;
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        int linha = FuncoesGerais.pegaLinhaSelecionada(this.panelDireitoExames);
        if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento) {
            dados = (DadosFaturamento)linhas.getValueAt(linha, 1);
            telaAlteracao = new AlteraGuiasFaturamento((Frame)Laboratorio.getInstancia(), dados.getCodigoConvenio() != dados.getCodigoConvenioPrincipal(), Acesso.getAcesso(Long.parseLong("0600200217")));
            ((AlteraGuiasFaturamento)telaAlteracao).setGuiasRequisicao(dados.getGuia(), dados.getGuiaPrincipal(), dados.isGuiaConferida());
            listaExames = dados.getExames();
            if (listaExames != null) {
                for (int i = 0; i < listaExames.size(); ++i) {
                    DadosExameFaturamento exame = listaExames.get(i);
                    ((AlteraGuiasFaturamento)telaAlteracao).adicionarExame(dados.getCodigoFilial(), dados.getCodigoConvenio(), exame);
                }
            }
        }
        if (telaAlteracao != null) {
            telaAlteracao.setVisible(true);
            if (((AbstractDialogoOKCancelar)telaAlteracao).getOK()) {
                if (!this.requisicoesComGuiaAlterada.contains(dados)) {
                    this.requisicoesComGuiaAlterada.add(dados);
                }
                boolean isConsiderarGuiasConferidas = ((AlteraGuiasFaturamento)telaAlteracao).getConsiderarGuiasConferidas();
                dados.setGuiaConferida(dados.isGuiaConferida() ? true : isConsiderarGuiasConferidas);
                dados.setGuia(((AlteraGuiasFaturamento)telaAlteracao).getGuiaRequisicao());
                dados.setGuiaPrincipal(((AlteraGuiasFaturamento)telaAlteracao).getGuiaPrincipalRequisicao());
                ArrayList<DadosExameFaturamento> listaExamesConfigurados = ((AlteraGuiasFaturamento)telaAlteracao).getExames();
                block1: for (int i = 0; i < listaExamesConfigurados.size(); ++i) {
                    DadosExameFaturamento exameAlterado = listaExamesConfigurados.get(i);
                    if (listaExames == null) continue;
                    for (int j = 0; j < listaExames.size(); ++j) {
                        DadosExameFaturamento exame = listaExames.get(i);
                        if (!exame.getCodigoExame().equalsIgnoreCase(exameAlterado.getCodigoExame())) continue;
                        exame.setCodigoGuia(exameAlterado.getCodigoGuia());
                        exame.setValidadeGuia(exameAlterado.getValidadeGuia());
                        exame.setDeveGuia(exameAlterado.getDeveGuia());
                        exame.setDataGuia(exameAlterado.getDataGuia());
                        continue block1;
                    }
                }
            }
            FuncoesGerais.repaintTabela(this.panelDireitoExames, linha);
            this.faturaSalva = false;
        }
    }

    private void marcarDesmarcarExameSemGuia() {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        int linha = FuncoesGerais.pegaLinhaSelecionada(this.panelDireitoExames);
        ArrayList<DadosExameFaturamento> listaExames = null;
        DadosFaturamento dados = null;
        if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento) {
            dados = (DadosFaturamento)linhas.getValueAt(linha, 1);
            listaExames = dados.getExames();
        }
        if (listaExames != null && listaExames.size() > 0) {
            TelaDeveGuiaExame telaDeveGuiaExame = new TelaDeveGuiaExame((Frame)Laboratorio.getInstancia(), listaExames);
            telaDeveGuiaExame.setVisible(true);
            if (telaDeveGuiaExame.getOK()) {
                FuncoesGerais.atualizaModeloFatura(this.panelDireitoExames);
                Registro selecionadoNaTela = new Registro();
                selecionadoNaTela.setValor("dadosFaturamento", dados);
                selecionadoNaTela.setValor("listaExames", listaExames);
            }
        } else {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Nenhuma requisi\u00e7\u00e3o selecionada.", 2);
        }
    }

    private void marcarExameParaNaoFaturar() {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        int linha = FuncoesGerais.pegaLinhaSelecionada(this.panelDireitoExames);
        if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento) {
            DadosFaturamento dados = (DadosFaturamento)linhas.getValueAt(linha, 1);
            try {
                boolean atualizarTotal = false;
                ExamesNaoFaturar examesNaoFaturar = ExamesNaoFaturar.getNovaInstancia(this.getTopLevelAncestor());
                examesNaoFaturar.setExames(String.valueOf(dados.getCodigoFilial()), dados.getExames());
                examesNaoFaturar.setVisible(true);
                if (!examesNaoFaturar.isOK()) {
                    return;
                }
                ArrayList<DadosExameFaturamento> examesDesmarcados = examesNaoFaturar.getExamesDesmarcados();
                for (DadosExameFaturamento auxExame : dados.getExames()) {
                    if (examesDesmarcados.contains(auxExame)) {
                        if (auxExame.getFaturar()) {
                            atualizarTotal = true;
                        }
                        auxExame.setMarcadoNaoFaturar(false);
                        auxExame.setFaturar(false);
                        continue;
                    }
                    if (!auxExame.getFaturar()) {
                        atualizarTotal = true;
                    }
                    auxExame.setMarcadoNaoFaturar(true);
                    auxExame.setFaturar(true);
                }
                dados.setFaturar(examesDesmarcados.size() < dados.getExamesCount());
                Calculos.calculaTotalRequisicao(dados);
                Calculos.calculaTotal(Conexao.getStatement(), linhas.getRowCount() - 1, FuncoesGerais.pegaTabela(this.panelDireitoExames), linhas);
                this.atualizaLabelValorRestante(((DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0)).getTotal().doubleValue());
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "FaturaExames (858)");
            }
        }
    }

    private void alterarDataFatura() {
        LinhasTabela linhas = FuncoesGerais.pegaModeloFatura(this.panelDireitoExames);
        int linha = FuncoesGerais.pegaLinhaSelecionada(this.panelDireitoExames);
        if (linhas != null && linha > -1 && linhas.getValueAt(linha, 1) instanceof DadosFaturamento) {
            int filialRequisicao = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getCodigoFilial();
            FaturaBean fatura = new FaturaBean();
            try {
                fatura = this.service.pesquisarFaturaPorCodigo(this.txtFatura.getText(), filialRequisicao);
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha ao recuperar Fatura no Banco de Dados.", ex.getStackTrace());
                return;
            }
            AlterarDataFatura msg = new AlterarDataFatura((Window)((Frame)this.getTopLevelAncestor()), fatura.getDataInicio(), fatura.getDataFim());
            Date dataFatura = ((DadosFaturamento)linhas.getValueAt(linha, 1)).getDataFaturaRequisicao();
            msg.setData(Funcoes.formataData(dataFatura));
            msg.setVisible(true);
            if (msg.isOK()) {
                dataFatura = Funcoes.stringToDate(msg.getData());
                boolean removeLinha = false;
                if (!this.verificaDataInicioFim(dataFatura, filialRequisicao, fatura.getDataFim(), fatura.getDataInicio())) {
                    if (Funcoes.mensagem(this, "A data de fatura informada n\u00e3o est\u00e1 no intervalo de datas selecionadas.\n Confirma a retirada da requisi\u00e7\u00e3o do faturamento?", 4) == 1) {
                        return;
                    }
                    removeLinha = true;
                    if (linhas.getRowCount() == 2) {
                        Funcoes.mensagem(this, "Fatura n\u00e3o pode ser vazia, o estorno deve ser realizado.", 2);
                        return;
                    }
                }
                DadosFaturamento fat = (DadosFaturamento)linhas.getValueAt(linha, 1);
                fat.setDataFaturaRequisicao(dataFatura);
                if (!this.requisicoesComDataFaturaAlterada.contains(fat)) {
                    this.requisicoesComDataFaturaAlterada.add(fat);
                }
                if (removeLinha) {
                    linhas.removeLinha(linha);
                }
            }
        }
        FuncoesGerais.repaintTabela(this.panelDireitoExames);
        this.atualizaLabelValorRestante(((DadosTotalGeral)linhas.getValueAt(linhas.getRowCount() - 1, 0)).getTotal().doubleValue());
        this.faturaSalva = false;
    }

    private void atualizaLabelValorRestante(double novoValor) {
        StringBuilder mensagem = new StringBuilder("Valor restante a faturar: R$ ");
        mensagem.append(Funcoes.formataDecimal(novoValor)).append(".");
        this.labelValorRestante.setText(mensagem.toString());
    }

    private void montaPanelValorRestanteFaturar() {
        this.panelDireitoValorRestanteFaturar.removeAll();
        BigDecimal valorRestante = this.getValorRestanteFatura();
        if (valorRestante != null) {
            this.atualizaLabelValorRestante(valorRestante.doubleValue());
            this.panelDireitoValorRestanteFaturar.add(this.labelValorRestante);
            this.listaAssociacoes = this.getNotasAssociadas();
            if (this.listaAssociacoes != null && this.listaAssociacoes.size() > 0) {
                this.panelDireitoValorRestanteFaturar.add(this.buttonNotasAssociadas);
            }
        }
        this.panelDireitoValorRestanteFaturar.revalidate();
        this.panelDireitoValorRestanteFaturar.repaint();
    }

    private ArrayList<NotaFiscalBean> getNotasAssociadas() {
        if (Funcoes.textoVazio(this.txtFatura) || this.codigoConvenio == null) {
            return null;
        }
        ArrayList<NotaFiscalBean> lista = null;
        try {
            lista = new NotaFiscalService().buscaNotasFiscaisCadastroFatura(Variaveis.filialPadrao, this.txtFatura.getText().trim(), this.codigoConvenio.toString(), "O", Conexao.getStatement());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar notas fiscais pelo cadastro.\n" + e.getMessage(), e.getStackTrace());
        }
        return lista;
    }

    static /* synthetic */ TTextField access$2100(ConferenciaFatura x0) {
        return x0.txtFatura;
    }

    static /* synthetic */ JButton access$2200(ConferenciaFatura x0) {
        return x0.buttonEletronico;
    }

    static /* synthetic */ boolean access$2300(ConferenciaFatura x0) {
        return x0.acessoAlterarTodosCamposFatEletronico;
    }

    static /* synthetic */ boolean access$800(ConferenciaFatura x0) {
        return x0.faturaSalva;
    }

    static /* synthetic */ boolean access$2400(ConferenciaFatura x0, Integer x1, Double x2) {
        return x0.invocaTelaGeracaoPreviasFaturamento(x1, x2);
    }

    class AlterarVencimentoFatura
    extends JDialog
    implements ActionListener {
        private final JLabel labelVencimento;
        private final TTextField textVencimento;
        private final JPanel panelBotoes;
        private final JButton buttonBuscaVencimento;
        private final JButton buttonOk;
        private final JButton buttonCancelar;
        private boolean isOk;
        private Date vencimento;

        public AlterarVencimentoFatura(Frame pai, Date vencimento) {
            super(pai, "Vencimento", true);
            this.labelVencimento = new JLabel("Vencimento");
            this.textVencimento = new TTextField(10, 4);
            this.panelBotoes = new JPanel(new FlowLayout(2));
            this.buttonBuscaVencimento = new JButton();
            this.buttonOk = new JButton("OK");
            this.buttonCancelar = new JButton("Cancelar");
            this.isOk = false;
            this.vencimento = null;
            this.montaTela();
            this.vencimento = vencimento;
            this.textVencimento.setText(Funcoes.formataData(vencimento));
            ScreenUtil.centralizar(this);
        }

        public AlterarVencimentoFatura(Dialog pai, Date vencimento) {
            super(pai, "Vencimento", true);
            this.labelVencimento = new JLabel("Vencimento");
            this.textVencimento = new TTextField(10, 4);
            this.panelBotoes = new JPanel(new FlowLayout(2));
            this.buttonBuscaVencimento = new JButton();
            this.buttonOk = new JButton("OK");
            this.buttonCancelar = new JButton("Cancelar");
            this.isOk = false;
            this.vencimento = null;
            this.montaTela();
            this.vencimento = vencimento;
            this.textVencimento.setText(Funcoes.formataData(vencimento));
            ScreenUtil.centralizar(pai);
        }

        public boolean isOk() {
            return this.isOk;
        }

        public void setVencimento(Date data) {
            if (data != null) {
                this.textVencimento.setText(Funcoes.formataData(data));
            }
        }

        public Date getVencimento() {
            return Funcoes.getData("dd/MM/yyyy", this.textVencimento.getText());
        }

        private void montaTela() {
            this.setSize(new Dimension(180, 100));
            this.setResizable(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)this.labelVencimento, c);
            ++c.gridy;
            this.textVencimento.setMinimumSize(new Dimension(90, 20));
            this.textVencimento.setPreferredSize(new Dimension(90, 20));
            this.add((Component)this.textVencimento, c);
            ++c.gridx;
            this.buttonBuscaVencimento.setMinimumSize(new Dimension(20, 20));
            this.buttonBuscaVencimento.setPreferredSize(new Dimension(20, 20));
            this.buttonBuscaVencimento.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonBuscaVencimento);
            this.add((Component)this.buttonBuscaVencimento, c);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 2;
            c.fill = 2;
            c.weightx = 1.0;
            this.add((Component)this.panelBotoes, c);
            this.panelBotoes.add(this.buttonOk);
            this.panelBotoes.add(this.buttonCancelar);
            this.buttonOk.setMnemonic('O');
            this.buttonCancelar.setMnemonic('C');
            this.buttonOk.addActionListener(this);
            this.buttonCancelar.addActionListener(this);
            this.buttonBuscaVencimento.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Funcoes.mostraData(AlterarVencimentoFatura.this.textVencimento, AlterarVencimentoFatura.this.buttonBuscaVencimento, (JPanel)AlterarVencimentoFatura.this.getContentPane(), true);
                }
            });
            this.textVencimento.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        AlterarVencimentoFatura.this.buttonBuscaVencimento.doClick();
                    }
                }
            });
            Funcoes.montaEnter((JComponent)this.getContentPane());
        }

        public boolean validaCampos() {
            return !Funcoes.textoVazio(this.textVencimento) && Funcoes.verificaData(this.textVencimento.getText());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.buttonOk) {
                if (this.validaCampos()) {
                    this.isOk = true;
                    this.vencimento = Funcoes.getData("dd/MM/yyyy", this.textVencimento.getText());
                    this.setVisible(false);
                } else {
                    this.isOk = false;
                    Funcoes.mensagem(this, "Informe uma data de vencimento.", 2);
                    ScreenUtil.requisitarFoco(this.textVencimento);
                }
            } else if (e.getSource() == this.buttonCancelar) {
                this.isOk = false;
                this.setVisible(false);
            }
        }
    }
}

