/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.detalhes.Detalhes;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.faturamento.ConvenioEntidade;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.model.bean.financeiro.FaturaBean;
import jalis.model.bean.financeiro.FaturaNotaFiscalBean;
import jalis.model.bean.financeiro.FaturaReceberPagarBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.bean.financeiro.ReceberPagarRPBean;
import jalis.model.dao.cadastro.auxiliares.FilialDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.SeriesVO;
import jalis.model.vo.financeiro.FaturaVO;
import jalis.model.vo.financeiro.ReceberPagarVO;
import jalis.service.cadastro.EntidadeService;
import jalis.service.cadastro.financeiro.SeriesService;
import jalis.service.financeiro.FaturaNotaFiscalService;
import jalis.service.financeiro.FaturaReceberPagarService;
import jalis.service.financeiro.FaturaService;
import jalis.service.financeiro.ReceberPagarRPService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;

public class Comissao
extends FrmCadPadrao {
    private JPanel panelFiltros = new JPanel(new GridBagLayout());
    private JPanel panelFaturas = new JPanel(new GridBagLayout());
    private JPanel panelDetalhes = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new GridBagLayout());
    private JPanel panelLegendas = new JPanel(new GridBagLayout());
    private CheckItemFiltro itemFilial = null;
    private CheckItemFiltro itemConvenio = null;
    private JLabel labelCampoData = new JLabel();
    private JLabel labelDataInicial = new JLabel();
    private JLabel labelDataFinal = new JLabel();
    private JLabel labelRefinarDados = new JLabel();
    private JLabel labelAux2 = new JLabel();
    private JLabel labelTotalComissao = new JLabel();
    private int POSICAO_COLUNA_NF = 0;
    private int POSICAO_COLUNA_CODIGO_CONVENIO = 1;
    private int POSICAO_COLUNA_FANTASIA_CONVENIO = 2;
    private int POSICAO_COLUNA_REPRESENTANTE = 3;
    private int POSICAO_COLUNA_PARCELA = 4;
    private int POSICAO_COLUNA_RECEBIDO = 5;
    private int POSICAO_COLUNA_COMISSAO = 6;
    private int POSICAO_COLUNA_SEL = 7;
    private int POSICAO_COLUNA_OBJETO = 8;
    private JComboBox comboCampoData = new JComboBox<String>(new String[]{"Emiss\u00e3o", "Vencimento", "Baixa"});
    private JComboBox comboRefinarDados = new JComboBox(new String[0]){

        public void addItem(Object anObject) {
            for (int i = 0; i < this.getItemCount(); ++i) {
                if (!this.getItemAt(i).equals(anObject)) continue;
                return;
            }
            super.addItem(anObject);
        }
    };
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private JButton buttonDataInicial = new JButton();
    private JButton buttonDataFinal = new JButton();
    private JButton buttonFiltrar = new JButton();
    private JButton buttonGerarTitulos = new JButton();
    private JButton buttonSelecionarTudo = new JButton();
    private JButton buttonLimparSelecao = new JButton();
    private JButton buttonInverterSelecao = new JButton();
    private JCheckBox checkGerados = new JCheckBox("Mostrar gerados", false);
    private DetalhesFatura detalhesFatura = new DetalhesFatura();
    private JTable tableFaturas = null;
    private ModeloGridTable modeloFaturas = null;
    private JScrollPane scrollFaturas;
    ArrayList<DadosFaturaComissao> listaFaturas = new ArrayList();
    private static final Color COR_JA_PAGO = ScreenUtil.clarearCor(Color.GREEN, 125);
    private static final Color COR_A_PAGAR = ScreenUtil.clarearCor(Color.RED, 125);
    private static final Long ACESSO_GERAR_TITULOS = Long.parseLong("0600200901");
    private boolean flagAlteracao = false;

    public Comissao() {
        Funcoes.criaBarraDescricao(this, "Comiss\u00e3o", "Controle de comiss\u00f5es de representantes", "financeiro/comissao.jpg");
        this.botaoEditar.setVisible(false);
        this.botaoExcluir.setVisible(false);
        this.botaoSalvar.setVisible(false);
        this.painelCentral.setLayout(new GridBagLayout());
        this.modeloFaturas = new ModeloGridTable(new String[]{"NF.", "Conv.", "Fantasia Conv\u00eanio", "Representante", "T\u00edtulo", "Recebido", "Comiss\u00e3o", "Sel", "Objeto"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                if (Comissao.this.modeloFaturas.getColumnNameSemCaracterEspecial(columnIndex).equalsIgnoreCase("Sel")) {
                    DadosFaturaComissao fat = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(rowIndex, Comissao.this.modeloFaturas.findColumn("Objeto"));
                    return fat.isComissaoGerada == false;
                }
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (Comissao.this.modeloFaturas.getColumnNameSemCaracterEspecial(columnIndex).equalsIgnoreCase("Sel")) {
                    return Boolean.class;
                }
                return super.getColumnClass(columnIndex);
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                try {
                    if (Comissao.this.tableFaturas != null) {
                        Comissao.this.tableFaturas.removeColumn(Comissao.this.tableFaturas.getColumn("Objeto"));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                try {
                    Comissao.this.tableFaturas.removeColumn(Comissao.this.tableFaturas.getColumn("Objeto"));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        };
        this.modeloFaturas.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int row;
                if (Comissao.this.flagAlteracao) {
                    return;
                }
                if (e.getColumn() == Comissao.this.POSICAO_COLUNA_SEL && (row = Comissao.this.tableFaturas.getSelectedRow()) >= 0) {
                    DadosFaturaComissao dadosFatura = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(row, Comissao.this.POSICAO_COLUNA_OBJETO);
                    Boolean valor = (Boolean)Comissao.this.modeloFaturas.getValueAt(row, Comissao.this.POSICAO_COLUNA_SEL);
                    for (int i = 0; i < Comissao.this.modeloFaturas.getRowCount(); ++i) {
                        if (((DadosFaturaComissao)((Comissao)Comissao.this).modeloFaturas.getValueAt((int)i, (int)((Comissao)Comissao.this).POSICAO_COLUNA_OBJETO)).isComissaoGerada.booleanValue()) continue;
                        DadosFaturaComissao faturaAux = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(i, Comissao.this.POSICAO_COLUNA_OBJETO);
                        if (!faturaAux.codigosFaturas.equalsIgnoreCase(dadosFatura.codigosFaturas)) continue;
                        faturaAux.selecionado = valor;
                        Comissao.this.flagAlteracao = true;
                        Comissao.this.modeloFaturas.setValueAt(valor, i, Comissao.this.POSICAO_COLUNA_SEL);
                        Comissao.this.flagAlteracao = false;
                    }
                }
            }
        });
        this.tableFaturas = new JTable(this.modeloFaturas);
        this.tableFaturas.removeColumn(this.tableFaturas.getColumn("Objeto"));
        this.tableFaturas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (Comissao.this.tableFaturas.getSelectedRow() >= 0) {
                    DadosFaturaComissao fatura = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(Comissao.this.tableFaturas.getSelectedRow(), Comissao.this.POSICAO_COLUNA_OBJETO);
                    Comissao.this.detalhesFatura.setValores(fatura.quantidadeRequisicoes, fatura.quantidadeExames, fatura.totalExamesFaturaRequisicao, fatura.totalMateriaisFaturaRequisicao, fatura.dataEmissaoFatura, fatura.dataVencimentoFatura, fatura.percentualComissao, fatura.dataBaixa, fatura.codigosFaturas, fatura.valorIss, fatura.valorCsll, fatura.valorIrrf, fatura.valorIssRetido, fatura.valorCofins, fatura.valorInss, fatura.valorPis);
                } else {
                    Comissao.this.detalhesFatura.limparDetalhes();
                }
            }
        });
        this.tableFaturas.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                int[] colunas = ((JTable)e.getSource()).getSelectedColumns();
                boolean colunaSelecionada = false;
                for (int i = 0; i < colunas.length; ++i) {
                    if (colunas[i] != Comissao.this.POSICAO_COLUNA_SEL) continue;
                    colunaSelecionada = true;
                    break;
                }
                if (e.getKeyCode() == 32 && !colunaSelecionada && (row = ((JTable)e.getSource()).getSelectedRow()) >= 0) {
                    DadosFaturaComissao dadosFatura = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(row, Comissao.this.POSICAO_COLUNA_OBJETO);
                    Boolean valor = (Boolean)Comissao.this.modeloFaturas.getValueAt(row, Comissao.this.POSICAO_COLUNA_SEL) == false;
                    if (dadosFatura.isComissaoGerada.booleanValue()) {
                        return;
                    }
                    for (int i = 0; i < Comissao.this.modeloFaturas.getRowCount(); ++i) {
                        DadosFaturaComissao faturaAux = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(i, Comissao.this.POSICAO_COLUNA_OBJETO);
                        if (!faturaAux.codigosFaturas.equalsIgnoreCase(dadosFatura.codigosFaturas)) continue;
                        Comissao.this.modeloFaturas.setValueAt(valor, i, Comissao.this.POSICAO_COLUNA_SEL);
                        faturaAux.selecionado = valor;
                    }
                }
            }
        });
        FaturaRenderer rendererFatura = new FaturaRenderer();
        this.tableFaturas.setDefaultRenderer(Object.class, rendererFatura);
        this.tableFaturas.setDefaultRenderer(Boolean.class, rendererFatura);
        this.modeloFaturas.setColumnSize(new int[]{60, 60, 0, 0, 60, 85, 85, 25, 0}, this.tableFaturas);
        this.tableFaturas.getTableHeader().addMouseListener(this.modeloFaturas);
        this.scrollFaturas = new JScrollPane(this.tableFaturas);
        this.buttonFiltrar.setMnemonic('i');
        this.buttonFiltrar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Comissao.this.buttonGerarTitulos.setEnabled(false);
                try {
                    SplashMensagem janelaEspera = SplashMensagem.getInstancia(Comissao.this);
                    janelaEspera.mostrar("Buscando comiss\u00f5es. Aguarde.");
                    Comissao.this.pesquisaComissoes();
                    Comissao.this.calculaTotalComissoes();
                    Comissao.this.controlaCampos();
                    janelaEspera.apagar();
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(Comissao.this, e1.getMessage(), e1.getStackTrace(), "Comissao (353)");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Comissao.this.buttonGerarTitulos.setEnabled(true);
                    }
                });
            }
        });
        this.comboRefinarDados.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (Comissao.this.comboRefinarDados.getSelectedIndex() == 0) {
                    Comissao.this.atualizarFaturas(null);
                } else {
                    Comissao.this.atualizarFaturas((String)Comissao.this.comboRefinarDados.getSelectedItem());
                }
                Comissao.this.calculaTotalComissoes();
            }
        });
        this.buttonSelecionarTudo.setText("Selecionar Todos");
        this.buttonSelecionarTudo.setMnemonic('S');
        this.buttonSelecionarTudo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Comissao.this.listaFaturas != null) {
                    for (int i = 0; i < Comissao.this.modeloFaturas.getRowCount(); ++i) {
                        DadosFaturaComissao fat = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(i, Comissao.this.modeloFaturas.findColumn("Objeto"));
                        if (fat.isComissaoGerada.booleanValue()) continue;
                        Comissao.this.modeloFaturas.setValueAt(true, i, Comissao.this.POSICAO_COLUNA_SEL);
                        DadosFaturaComissao fatura = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(i, Comissao.this.POSICAO_COLUNA_OBJETO);
                        fatura.selecionado = true;
                    }
                }
            }
        });
        this.buttonInverterSelecao.setText("Inverter Sele\u00e7\u00e3o");
        this.buttonInverterSelecao.setMnemonic('v');
        this.buttonInverterSelecao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Comissao.this.listaFaturas != null) {
                    for (int i = 0; i < Comissao.this.modeloFaturas.getRowCount(); ++i) {
                        DadosFaturaComissao fat = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(i, Comissao.this.modeloFaturas.findColumn("Objeto"));
                        if (fat.isComissaoGerada.booleanValue()) continue;
                        Boolean valor = (Boolean)Comissao.this.modeloFaturas.getValueAt(i, Comissao.this.POSICAO_COLUNA_SEL);
                        Comissao.this.modeloFaturas.setValueAt(valor == false, i, Comissao.this.POSICAO_COLUNA_SEL);
                        DadosFaturaComissao fatura = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(i, Comissao.this.POSICAO_COLUNA_OBJETO);
                        fatura.selecionado = valor == false;
                    }
                }
            }
        });
        this.buttonLimparSelecao.setText("Limpar Sele\u00e7\u00e3o");
        this.buttonLimparSelecao.setMnemonic('L');
        this.buttonLimparSelecao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Comissao.this.listaFaturas != null) {
                    for (int i = 0; i < Comissao.this.modeloFaturas.getRowCount(); ++i) {
                        Comissao.this.modeloFaturas.setValueAt(false, i, Comissao.this.POSICAO_COLUNA_SEL);
                        DadosFaturaComissao fatura = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(i, Comissao.this.POSICAO_COLUNA_OBJETO);
                        fatura.selecionado = false;
                    }
                }
            }
        });
        this.buttonGerarTitulos.setText("Gerar T\u00edtulos");
        this.buttonGerarTitulos.setMnemonic('G');
        this.buttonGerarTitulos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Comissao.this.buttonGerarTitulos.isEnabled()) {
                    return;
                }
                boolean haSelecionados = false;
                for (int i = 0; i < Comissao.this.modeloFaturas.getRowCount(); ++i) {
                    if (!((Boolean)Comissao.this.modeloFaturas.getValueAt(i, Comissao.this.POSICAO_COLUNA_SEL)).booleanValue()) continue;
                    haSelecionados = true;
                    break;
                }
                if (!haSelecionados) {
                    Funcoes.mensagem(Comissao.this, "Nenhuma fatura foi selecionada.\nSelecione as faturas cujas comiss\u00f5es ser\u00e3o geradas.", 2);
                    return;
                }
                Comissao.this.gerarTitulos();
                String cadastro = (String)Comissao.this.comboRefinarDados.getSelectedItem();
                Comissao.this.buttonFiltrar.doClick();
                if (cadastro == null || cadastro.equalsIgnoreCase("Todos")) {
                    Comissao.this.atualizarFaturas(null);
                } else {
                    Comissao.this.atualizarFaturas(cadastro);
                }
                Comissao.this.comboRefinarDados.setSelectedItem(cadastro);
                Comissao.this.calculaTotalComissoes();
            }
        });
        this.buttonDataInicial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(Comissao.this.textDataInicial, Comissao.this.buttonDataInicial, Comissao.this.panelFiltros, true);
            }
        });
        this.buttonDataFinal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(Comissao.this.textDataFinal, Comissao.this.buttonDataFinal, Comissao.this.panelFiltros, true);
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        Insets inOriginal = c.insets;
        Insets inEspaco = new Insets(inOriginal.top, 30, inOriginal.bottom, inOriginal.right);
        this.panelFiltros.setBorder(BorderFactory.createTitledBorder("Filtros"));
        this.panelFiltros.setLayout(new GridBagLayout());
        this.itemFilial = new CheckItemFiltro("Filial", "Filtrar", "Filtrando filiais", "");
        this.itemFilial.setDados("filiais_postocoleta", new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o Filial"}, new int[]{70, 0});
        this.itemFilial.setColunaHint(1);
        this.itemFilial.setTamanhoMinimoCheck(new Dimension(130, 20));
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.anchor = 17;
        this.panelFiltros.add((Component)this.itemFilial, c);
        c.gridx = 2;
        c.gridwidth = 3;
        c.insets = inEspaco;
        this.itemConvenio = new CheckItemFiltro("Conv\u00eanio", "Filtrar", "Filtrando conv\u00eanios", "fil_codigo = " + Variaveis.filialPadrao);
        this.itemConvenio.setDados("convenios", new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia Conv\u00eanio"}, new int[]{70, 0});
        this.itemConvenio.setColunaHint(1);
        this.itemConvenio.setTamanhoMinimoCheck(new Dimension(130, 20));
        this.panelFiltros.add((Component)this.itemConvenio, c);
        c.gridx = 5;
        this.panelFiltros.add((Component)this.checkGerados, c);
        c.gridx = 8;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.insets = inOriginal;
        c.fill = 2;
        this.panelFiltros.add((Component)new JLabel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.labelCampoData.setText("Campo Data:");
        this.labelCampoData.setMinimumSize(new Dimension(80, 20));
        this.labelCampoData.setPreferredSize(new Dimension(80, 20));
        this.panelFiltros.add((Component)this.labelCampoData, c);
        ++c.gridx;
        this.comboCampoData.setMinimumSize(new Dimension(100, 20));
        this.comboCampoData.setPreferredSize(new Dimension(100, 20));
        this.panelFiltros.add((Component)this.comboCampoData, c);
        ++c.gridx;
        c.insets = inEspaco;
        this.labelDataInicial.setText("Data Inicial:");
        this.panelFiltros.add((Component)this.labelDataInicial, c);
        ++c.gridx;
        c.insets = inOriginal;
        this.textDataInicial.setMinimumSize(new Dimension(85, 20));
        this.textDataInicial.setPreferredSize(new Dimension(85, 20));
        this.panelFiltros.add((Component)this.textDataInicial, c);
        ++c.gridx;
        this.buttonDataInicial.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonDataInicial);
        this.buttonDataInicial.setMinimumSize(new Dimension(20, 20));
        this.buttonDataInicial.setPreferredSize(new Dimension(20, 20));
        this.panelFiltros.add((Component)this.buttonDataInicial, c);
        ++c.gridx;
        c.insets = inEspaco;
        this.labelDataFinal.setText("Data Final:");
        this.panelFiltros.add((Component)this.labelDataFinal, c);
        ++c.gridx;
        c.insets = inOriginal;
        this.textDataFinal.setMinimumSize(new Dimension(85, 20));
        this.textDataFinal.setPreferredSize(new Dimension(85, 20));
        this.panelFiltros.add((Component)this.textDataFinal, c);
        ++c.gridx;
        this.buttonDataFinal.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonDataFinal);
        this.buttonDataFinal.setMinimumSize(new Dimension(20, 20));
        this.buttonDataFinal.setPreferredSize(new Dimension(20, 20));
        this.panelFiltros.add((Component)this.buttonDataFinal, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = inOriginal;
        this.buttonFiltrar.setText("Filtrar");
        this.panelFiltros.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, 0, 0, this.buttonFiltrar), c);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelFiltros, gridBagConstraints);
        this.panelFaturas.setBorder(BorderFactory.createTitledBorder("Comiss\u00f5es"));
        this.panelFaturas.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelFaturas.add((Component)this.scrollFaturas, gridBagConstraints);
        this.labelRefinarDados.setDisplayedMnemonic('R');
        this.labelRefinarDados.setLabelFor(this.comboRefinarDados);
        this.labelRefinarDados.setText("Representante:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelFaturas.add((Component)this.labelRefinarDados, gridBagConstraints);
        this.comboRefinarDados.setMinimumSize(new Dimension(180, 20));
        this.comboRefinarDados.setPreferredSize(new Dimension(180, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.panelFaturas.add((Component)this.comboRefinarDados, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridx;
        this.panelFaturas.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        this.panelFaturas.add((Component)new JLabel("Valor Total: "), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.labelTotalComissao.setText(Funcoes.formataDecimal(0.0));
        this.labelTotalComissao.setHorizontalAlignment(4);
        this.panelFaturas.add((Component)this.labelTotalComissao, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.painelCentral.add((Component)this.panelFaturas, gridBagConstraints);
        this.panelDetalhes.setLayout(new GridBagLayout());
        this.detalhesFatura.setMinimumSize(new Dimension(10, 60));
        this.detalhesFatura.setPreferredSize(new Dimension(10, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.panelDetalhes.add((Component)this.detalhesFatura, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelDetalhes, gridBagConstraints);
        this.panelBotoes.setLayout(new GridBagLayout());
        this.panelBotoes.setBorder(BorderFactory.createTitledBorder(""));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panelBotoes.add((Component)this.buttonSelecionarTudo, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.panelBotoes.add((Component)this.buttonLimparSelecao, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.panelBotoes.add((Component)this.buttonInverterSelecao, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelBotoes.add((Component)this.labelAux2, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.panelBotoes.add((Component)this.buttonGerarTitulos, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelBotoes, gridBagConstraints);
        this.panelLegendas.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.painelCentral.add((Component)this.panelLegendas, gridBagConstraints);
        this.montaPanelLegendas();
        this.controlaCampos();
        this.modeloFaturas.ordenarColuna(this.POSICAO_COLUNA_NF);
    }

    private void calculaTotalComissoes() {
        if (this.modeloFaturas != null) {
            BigDecimal total = BigDecimal.ZERO;
            for (int i = 0; i < this.modeloFaturas.getRowCount(); ++i) {
                DadosFaturaComissao aux = (DadosFaturaComissao)this.modeloFaturas.getValueAt(i, this.POSICAO_COLUNA_OBJETO);
                total = total.add(aux.valorComissao);
            }
            total = total.setScale(2, RoundingMode.HALF_UP);
            this.labelTotalComissao.setText(Funcoes.formataDecimal(total.doubleValue()));
        }
    }

    private void gerarTitulos() {
        ReceberPagarService service = new ReceberPagarService();
        FaturaService serviceFatura = new FaturaService();
        SeriesService serviceSerie = new SeriesService();
        FaturaReceberPagarService serviceFaturaRecPag = new FaturaReceberPagarService();
        ReceberPagarRPService serviceReceberPagarRP = new ReceberPagarRPService();
        boolean dataBaixa = this.comboCampoData.getSelectedItem().equals("Baixa");
        Date dataSelecionada = null;
        String opcao = null;
        opcao = dataBaixa ? (String)JOptionPane.showInputDialog(this, "Qual das datas da fatura deve ser usada\ncomo vencimento do t\u00edtulo?", "Escolha a data", 3, null, new String[]{"Emiss\u00e3o Fatura", "Vencimento Fatura", "Recebimento", "Data fixa..."}, "Emiss\u00e3o Fatura") : (String)JOptionPane.showInputDialog(this, "Qual das datas da fatura deve ser usada\ncomo vencimento do t\u00edtulo?", "Escolha a data", 3, null, new String[]{"Emiss\u00e3o Fatura", "Vencimento Fatura", "Data fixa..."}, "Emiss\u00e3o Fatura");
        if (opcao == null) {
            return;
        }
        if (opcao.equalsIgnoreCase("Data fixa...")) {
            DateDialog dialogData = new DateDialog(Laboratorio.getInstancia(), "Insira a data", "Data das comiss\u00f5es:");
            dialogData.setVisible(true);
            String data = dialogData.getRetorno();
            if (data == null) {
                return;
            }
            dataSelecionada = Funcoes.getData("dd/MM/yyyy", data);
        }
        SplashMensagem janelaEspera = SplashMensagem.getInstancia(this);
        janelaEspera.mostrar("Gerando comiss\u00f5es. Aguarde.");
        FilialVO filial = new FilialVO();
        try {
            filial = (FilialVO)new FilialDao().getVO(Variaveis.filialPadrao);
        }
        catch (ThreadDaoException e1) {
            Funcoes.mensagem(this, "Filial n\u00e3o identificada.", 2);
        }
        for (int i = 0; i < this.listaFaturas.size(); ++i) {
            DadosFaturaComissao fatura = this.listaFaturas.get(i);
            if (!fatura.selecionado.booleanValue()) continue;
            ReceberPagarBean recpag = new ReceberPagarBean();
            recpag.setFilial(filial);
            recpag.setSituacao("A");
            recpag.setDataHora(new Date());
            UsuarioVO usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            recpag.setUsuario(usuario);
            recpag.setTipo("P");
            recpag.setTipoDocumento("D");
            if (opcao.equalsIgnoreCase("Emiss\u00e3o Fatura")) {
                recpag.setDataVencimento(fatura.dataEmissaoFatura);
                recpag.setDataCompetencia(fatura.dataEmissaoFatura);
                recpag.setDataDocumento(fatura.dataEmissaoFatura);
            } else if (opcao.equalsIgnoreCase("Vencimento Fatura")) {
                recpag.setDataVencimento(fatura.dataVencimentoFatura);
                recpag.setDataCompetencia(fatura.dataVencimentoFatura);
                recpag.setDataDocumento(fatura.dataVencimentoFatura);
            } else if (opcao.equalsIgnoreCase("Recebimento")) {
                recpag.setDataVencimento(fatura.dataBaixa);
                recpag.setDataCompetencia(fatura.dataBaixa);
                recpag.setDataDocumento(fatura.dataBaixa);
            } else if (opcao.equalsIgnoreCase("Data fixa...")) {
                recpag.setDataVencimento(dataSelecionada);
                recpag.setDataCompetencia(dataSelecionada);
                recpag.setDataDocumento(dataSelecionada);
            }
            recpag.setTipoJuro("V");
            recpag.setValor(fatura.valorComissao.doubleValue());
            recpag.setPercentualMulta(0.0);
            recpag.setPercentualDesconto(0.0);
            recpag.setPercentualAcrescimo(0.0);
            recpag.setIrrfPercentual(0.0);
            recpag.setIssPercentual(0.0);
            recpag.setPisPercentual(0.0);
            recpag.setCsllPercentual(0.0);
            recpag.setCofinsPercentual(0.0);
            recpag.setInssPercentual(0.0);
            recpag.setValorMulta(0.0);
            recpag.setValorDesconto(0.0);
            recpag.setValorAcrescimo(0.0);
            recpag.setTaxa(0.0);
            recpag.setIrrfValor(0.0);
            recpag.setIssValor(0.0);
            recpag.setPisValor(0.0);
            recpag.setCsllValor(0.0);
            recpag.setCofinsValor(0.0);
            recpag.setInssValor(0.0);
            recpag.setPercentualJuro(0.0);
            recpag.setValorJuro(0.0);
            recpag.setOrigem("C");
            recpag = FinanceiroUtil.atualizaTotalSemRecalculo(recpag);
            recpag.setNumeroDocumento(null);
            recpag.setParcela(1);
            recpag.setCodigoDocumento(null);
            recpag.setDataProcessamento(new Date());
            recpag.setObservacao("PAGAMENTO DE COMISS\u00c3O - NF C\u00d3D.: " + fatura.codigoNotaFiscal + " - COMISS\u00c3O GERADA MANUALMENTE.");
            recpag.setTipoCadastro("R");
            try {
                Iterator it;
                HashSet series = (HashSet)serviceSerie.loadVO(" where fil_codigo = " + Variaveis.filialPadrao);
                if (series != null && (it = series.iterator()).hasNext()) {
                    recpag.setSerie((SeriesVO)it.next());
                }
            }
            catch (Exception e3) {
                Funcoes.mensagem(this, "S\u00e9rie n\u00e3o identificada. - " + e3.getMessage(), 2);
            }
            EntidadeVO entidade = null;
            try {
                entidade = (EntidadeVO)new EntidadeService().getVO(String.valueOf(filial.getCodigo()), String.valueOf(fatura.codigoCadastro));
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "Representante n\u00e3o identificado. - " + e.getMessage(), 2);
                continue;
            }
            recpag.setEntidade(entidade);
            if (fatura.codigoReceber != null && fatura.codigoReceber > 0) {
                ReceberPagarBean beanReceber = null;
                try {
                    beanReceber = (ReceberPagarBean)service.get(String.valueOf(fatura.codigoFilial), String.valueOf(fatura.codigoReceber));
                }
                catch (Exception e2) {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel carregar dados do recebimento. - " + e2.getMessage(), 2);
                }
                if (beanReceber == null) continue;
                if (beanReceber.getUsuarioComissao() != null && (fatura.comissaoAutomaticaGerada.booleanValue() || fatura.comissaoManualGerada.booleanValue())) {
                    Funcoes.mensagem(this, "A comiss\u00e3o do recebimento j\u00e1 foi gerada.\nN\u00e3o \u00e9 poss\u00edvel gerar novamente.", 2);
                    continue;
                }
                try {
                    service.gravaAutoCopiaSemCommit(recpag, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                    beanReceber.setUsuarioComissao(usuario);
                    beanReceber.setDataComissao(new Date());
                    service.updateComRetorno(beanReceber, 1, Variaveis.filialPadrao, this.getCopiaFiliais(), false);
                    ReceberPagarRPBean recPagRP = new ReceberPagarRPBean();
                    recPagRP.setFilialOrigem(beanReceber.getFilial());
                    recPagRP.setReceberPagarOrigem((ReceberPagarVO)beanReceber.toVO());
                    recPagRP.setFilialDestino(recpag.getFilial());
                    recPagRP.setReceberPagarDestino((ReceberPagarVO)recpag.toVO());
                    recPagRP.setTipo("C");
                    serviceReceberPagarRP.insert(recPagRP, null, Variaveis.filialPadrao, this.getCopiaFiliais());
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel gerar t\u00edtulo. - " + e.getMessage(), 2);
                }
            } else {
                Set<FaturaNotaFiscalBean> lista = null;
                if (fatura.codigoNotaFiscal != null && fatura.codigoNotaFiscal > 0) {
                    try {
                        lista = new FaturaNotaFiscalService().getFaturasNotaFiscal(String.valueOf(fatura.codigoFilial), String.valueOf(fatura.codigoNotaFiscal));
                    }
                    catch (Exception e2) {
                        Funcoes.mensagem(this, "Fatura n\u00e3o identificada. - " + e2.getMessage(), 2);
                    }
                } else {
                    FaturaNotaFiscalBean aux = new FaturaNotaFiscalBean();
                    aux.setFilial(filial);
                    StringTokenizer tokenizer = new StringTokenizer(fatura.codigosFaturas, ", ");
                    HashSet<FaturaNotaFiscalBean> set = new HashSet<FaturaNotaFiscalBean>();
                    while (tokenizer.hasMoreElements()) {
                        FaturaVO fat = new FaturaVO();
                        fat.setCodigo(Integer.parseInt(tokenizer.nextElement().toString()));
                        aux.setFatura(fat);
                        set.add(aux);
                    }
                    lista = set;
                }
                if (lista != null) {
                    Iterator<FaturaNotaFiscalBean> it = lista.iterator();
                    while (it.hasNext()) {
                        FaturaBean beanFatura = null;
                        FaturaNotaFiscalBean aux = it.next();
                        try {
                            beanFatura = (FaturaBean)serviceFatura.get(String.valueOf(aux.getFilial().getCodigo()), String.valueOf(aux.getFatura().getCodigo()));
                        }
                        catch (Exception e2) {
                            Funcoes.mensagem(this, "Fatura n\u00e3o identificada. - " + e2.getMessage(), 2);
                        }
                        if (beanFatura == null) continue;
                        beanFatura.setCodigoUsuarioComissao(usuario);
                        beanFatura.setDataComissao(new Date());
                        try {
                            service.gravaAutoCopiaSemCommit(recpag, 0, Variaveis.filialPadrao, this.getCopiaFiliais());
                            serviceFatura.gravaAutoCopiaSemCommit(beanFatura, 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                            FaturaReceberPagarBean faturaPag = new FaturaReceberPagarBean();
                            faturaPag.setFilial(beanFatura.getFilial());
                            faturaPag.setFatura((FaturaVO)beanFatura.toVO());
                            faturaPag.setReceberPagar((ReceberPagarVO)recpag.toVO());
                            faturaPag.setTipo("C");
                            serviceFaturaRecPag.insert(faturaPag, null, Variaveis.filialPadrao, this.getCopiaFiliais());
                        }
                        catch (Exception e) {
                            try {
                                Conexao.anulaSQL();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel gerar t\u00edtulo. - " + e.getMessage(), 2);
                        }
                    }
                }
            }
            try {
                Conexao.arquivaSQL();
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        janelaEspera.apagar();
    }

    private String getCopiaFiliais() {
        return null;
    }

    private void montaPanelLegendas() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.0;
        c.weighty = 0.0;
        JPanel pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_JA_PAGO);
        this.panelLegendas.add((Component)pnlCorLegenda, c);
        JLabel lblLegenda = new JLabel("T\u00edtulo j\u00e1 gerado");
        Font font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        this.panelLegendas.add((Component)lblLegenda, c);
        ++c.gridx;
        this.panelLegendas.add((Component)new JLabel("  "), c);
        pnlCorLegenda = new JPanel();
        pnlCorLegenda.setPreferredSize(new Dimension(10, 10));
        pnlCorLegenda.setBackground(COR_A_PAGAR);
        ++c.gridx;
        this.panelLegendas.add((Component)pnlCorLegenda, c);
        lblLegenda = new JLabel("T\u00edtulo n\u00e3o gerado");
        font = new Font(lblLegenda.getFont().getName(), 0, 10);
        lblLegenda.setFont(font);
        ++c.gridx;
        this.panelLegendas.add((Component)lblLegenda, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelLegendas.add((Component)new JLabel(""), c);
    }

    private void controlaCampos() {
        boolean habilitar = this.getStatus() == 2 || this.getStatus() == 3;
        this.itemFilial.setEnabled(habilitar);
        this.itemConvenio.setEnabled(habilitar);
        this.comboCampoData.setEnabled(habilitar);
        this.textDataInicial.setEnabled(habilitar);
        this.textDataFinal.setEnabled(habilitar);
        this.buttonFiltrar.setEnabled(habilitar);
        this.checkGerados.setEnabled(habilitar);
        this.buttonDataInicial.setEnabled(habilitar);
        this.buttonDataFinal.setEnabled(habilitar);
        this.tableFaturas.setEnabled(habilitar);
        this.comboRefinarDados.setEnabled(habilitar && this.modeloFaturas.getRowCount() > 0);
        this.buttonGerarTitulos.setEnabled(habilitar && Acesso.getAcesso(ACESSO_GERAR_TITULOS));
    }

    private void pesquisaComissoes() throws SQLException {
        ConvenioEntidade aux;
        int i;
        ArrayList<ConvenioEntidade> listaFaturamento = new ArrayList<ConvenioEntidade>();
        ArrayList<ConvenioEntidade> listaNotaFiscal = new ArrayList<ConvenioEntidade>();
        ArrayList<ConvenioEntidade> listaBaixa = new ArrayList<ConvenioEntidade>();
        String filial = null;
        if (this.itemFilial.getSelecionados() == null) {
            filial = Variaveis.filialPadrao;
        } else {
            if (this.itemFilial.getSelecionados().length > 1) {
                Funcoes.mensagem(this, "Somente uma filial pode ser selecionada.", 2);
                return;
            }
            filial = this.itemFilial.getSelecionados()[0];
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" select cen_tipoparcela as tipo ");
        buf.append("       ,con_codigo as convenio ");
        buf.append("       ,ent_codigo as entidade ");
        buf.append("   from convenioentidade ");
        buf.append("  where fil_codigo = ").append(filial);
        String[] convenio = this.itemConvenio.getSelecionados();
        if (convenio != null) {
            buf.append("  and con_codigo IN (");
            for (int i2 = 0; i2 < convenio.length; ++i2) {
                buf.append(convenio[i2]);
                if (i2 >= convenio.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        buf.append("  order by cen_tipoparcela ");
        buf.append("          ,con_codigo ");
        buf.append("          ,ent_codigo ");
        ResultSet rsConvenioEntidade = Conexao.executeQuery(Conexao.getStatement(), buf);
        while (rsConvenioEntidade.next()) {
            if (rsConvenioEntidade.getString("tipo").equalsIgnoreCase("C") || rsConvenioEntidade.getString("tipo").equalsIgnoreCase("N")) {
                listaFaturamento.add(new ConvenioEntidade(rsConvenioEntidade.getInt("convenio"), rsConvenioEntidade.getInt("entidade")));
                continue;
            }
            if (rsConvenioEntidade.getString("tipo").equalsIgnoreCase("F")) {
                listaNotaFiscal.add(new ConvenioEntidade(rsConvenioEntidade.getInt("convenio"), rsConvenioEntidade.getInt("entidade")));
                continue;
            }
            if (!rsConvenioEntidade.getString("tipo").equalsIgnoreCase("B")) continue;
            listaBaixa.add(new ConvenioEntidade(rsConvenioEntidade.getInt("convenio"), rsConvenioEntidade.getInt("entidade")));
        }
        if (listaFaturamento.size() == 0 && listaNotaFiscal.size() == 0 && listaBaixa.size() == 0) {
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados de comiss\u00f5es.", 2);
            this.controlaCampos();
            return;
        }
        buf.setLength(0);
        if (listaFaturamento.size() > 0) {
            buf.append("(select distinct nfi.nfi_codigo as codigoNotaFiscal ");
            buf.append("       ,nfi.nfi_numero as numeroNotaFiscal ");
            buf.append("       ,a.fil_codigo as codigoFilial ");
            buf.append("       ,con.con_codigo as codigoConvenio ");
            buf.append("       ,con.con_fantasia as fantasiaConvenio ");
            buf.append("       ,ent.ent_codigo as codigoEntidade ");
            buf.append("       ,ent.ent_razaosocial as razaoSocialCadastro ");
            buf.append("       ,SUM(CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg.rpg_valortotal, 0) ELSE 0 END) / COUNT(1) as valorTotalBaixa ");
            buf.append("       ,(a.fat_totalexames + a.fat_totalmateriais + a.fat_adicional + a.fat_despcobranca - ((a.fat_totalexames + a.fat_totalmateriais) * a.fat_percdesconto / 100)) * cen.cen_comissao / 100 as valorComissao ");
            buf.append("       ,SUM(CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg.rpg_issvalor, 0) ELSE 0 END) / COUNT(1) as valorIss ");
            buf.append("       ,SUM(CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg.rpg_csllvalor, 0) ELSE 0 END) / COUNT(1) as valorCsll ");
            buf.append("       ,SUM(CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg.rpg_irrfvalor, 0) ELSE 0 END) / COUNT(1) as valorIrrf ");
            buf.append("       ,SUM(CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg.rpg_issretidovalor, 0) ELSE 0 END) / COUNT(1) as valorIssRetido ");
            buf.append("       ,SUM(CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg.rpg_cofinsvalor, 0) ELSE 0 END) / COUNT(1) as valorCofins ");
            buf.append("       ,SUM(CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg.rpg_inssvalor, 0) ELSE 0 END) / COUNT(1) as valorInss ");
            buf.append("       ,SUM(CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg.rpg_pisvalor, 0) ELSE 0 END) / COUNT(1) as valorPis ");
            buf.append("       ,cen.cen_comissao as percentualComissao ");
            buf.append("       ,0 as quantidadeExames ");
            buf.append("       ,COUNT(1) as quantidadeRequisicoes ");
            buf.append("       ,SUM(fre.fre_totalmateriais) as totalMateriaisFaturaRequisicao ");
            buf.append("       ,SUM(fre.fre_totalexames) as totalExamesFaturaRequisicao ");
            buf.append("\t\t   ,cast(MAX(date_trunc('day', bxa.bxa_datahora)) as date) as dataBaixa ");
            buf.append("       ,MAX(rpg.rpg_codigo) as codigoReceber ");
            buf.append("       ,array_to_string(array_agg(distinct a.fat_codigo), ', ') as codigosFaturas ");
            buf.append("       ,'F' as tipoComissao ");
            buf.append("       ,((select COUNT(1) ");
            buf.append("           from faturareceberpagar frp ");
            buf.append("           join receberpagar       rpg on frp.fil_codigo = rpg.fil_codigo and frp.rpg_codigo = rpg.rpg_codigo ");
            buf.append("          where rpg.rpg_origem = '").append("C").append("' ");
            buf.append("            and rpg.rpg_tipo = '").append("P").append("' ");
            buf.append("            and frp.fil_codigo = a.fil_codigo ");
            buf.append("            and frp.fat_codigo = a.fat_codigo ");
            buf.append("            and frp.frp_tipo = '").append("C").append("' ");
            buf.append("            and rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("')) ");
            buf.append(" + ");
            buf.append("        (select COUNT(1) ");
            buf.append("           from receberpagarrp   rrp ");
            buf.append("           join receberpagar     rpg2 on rrp.fil_kodigo = rpg2.fil_codigo and rrp.rpg_kodigo = rpg2.rpg_codigo ");
            buf.append("          where rpg2.rpg_origem = '").append("C").append("' ");
            buf.append("            and rpg2.rpg_tipo = '").append("P").append("' ");
            buf.append("            and rpg2.ent_codigo = cen.ent_codigo ");
            buf.append("            and rrp.rrp_tipo = '").append("C").append("' ");
            buf.append("            and rrp.fil_codigo = a.fil_codigo ");
            buf.append("            and rrp.rpg_codigo IN (select rpg_codigo ");
            buf.append("                                     from receberpagar ");
            buf.append("                                    where fil_codigo = a.fil_codigo ");
            buf.append("                                      and nfi_codigo = nfi.nfi_codigo ");
            buf.append("                                      and rpg_origem = '").append("N").append("' ");
            buf.append("                                      and rpg_tipo = '").append("R").append("' ");
            buf.append("                                      and rpg_situacao <> '").append("C").append("') ");
            buf.append("            and rpg2.rpg_situacao <> '").append("X").append("')) > 0 as comissaoGerada ");
            buf.append("   from fatura a ");
            buf.append("   join faturarequisicao \t      fre on (a.fil_codigo = fre.fil_codigo and a.fat_codigo \t= fre.fat_codigo) ");
            buf.append("   join requisicao \t\t\t\t      req on (fre.fil_codigo = req.fil_codigo and fre.req_codigo = req.req_codigo) ");
            buf.append("   join convenios \t\t\t\t      con on (a.fil_codigo = con.fil_codigo and a.con_codigo \t= con.con_codigo) ");
            buf.append("   join convenioentidade \t      cen on (con.fil_codigo = cen.fil_codigo and con.con_codigo = cen.con_codigo) ");
            buf.append("   join entidade \t\t\t\t\t      ent on (cen.fil_codigo = ent.fil_codigo and cen.ent_codigo = ent.ent_codigo) ");
            buf.append("   left join faturanotafiscal   fnf on a.fil_codigo = fnf.fil_codigo and a.fat_codigo \t= fnf.fat_codigo ");
            buf.append("   left join notafiscal \t\t\t  nfi on fnf.fil_codigo = nfi.fil_codigo and fnf.nfi_codigo = nfi.nfi_codigo and nfi.usr_codcancelada IS NULL ");
            buf.append("   left join receberpagar       rpg on nfi.fil_codigo = rpg.fil_codigo and nfi.nfi_codigo = rpg.nfi_codigo and rpg.rpg_origem = '").append("N").append("' and rpg.rpg_tipo = '").append("R").append("' and rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("') ");
            buf.append("   left join baixareceberpagar  brp on rpg.fil_codigo = brp.fil_codigo and rpg.rpg_codigo = brp.rpg_codigo ");
            buf.append("   left join baixa \t\t\t\t\t\t  bxa on brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo and bxa.bxa_situacao = '").append("Q").append("' ");
            buf.append("  where a.fat_datacancelamento IS NULL ");
            buf.append("    and a.fil_codigo = ").append(filial);
            if (Funcoes.verificaData(this.textDataInicial.getText())) {
                buf.append(" and ").append(this.comboCampoData.getSelectedItem().equals("Emiss\u00e3o") ? "fat_dtemis" : (this.comboCampoData.getSelectedItem().equals("Vencimento") ? "fat_dtvenc" : "date_trunc('day', bxa_datahora)")).append(" >= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText()));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.textDataFinal.getText())) {
                buf.append(" and ").append(this.comboCampoData.getSelectedItem().equals("Emiss\u00e3o") ? "fat_dtemis" : (this.comboCampoData.getSelectedItem().equals("Vencimento") ? "fat_dtvenc" : "date_trunc('day', bxa_datahora)")).append(" <= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText()));
                buf.append("'");
            }
            buf.append(" and (cen.con_codigo, cen.ent_codigo) IN (select ");
            for (i = 0; i < listaFaturamento.size(); ++i) {
                aux = (ConvenioEntidade)listaFaturamento.get(i);
                buf.append(aux.codigoConvenio).append(", ").append(aux.codigoEntidade);
                if (i >= listaFaturamento.size() - 1) continue;
                buf.append(" UNION select ");
            }
            buf.append(") ");
            buf.append("  group by nfi.nfi_codigo ");
            buf.append("          ,nfi.nfi_numero ");
            buf.append("          ,a.fat_codigo ");
            buf.append("          ,a.fil_codigo ");
            buf.append("          ,con.con_codigo ");
            buf.append("          ,con.con_fantasia ");
            buf.append("          ,cen.cen_comissao ");
            buf.append("          ,ent.ent_razaosocial ");
            buf.append("          ,ent.ent_codigo ");
            buf.append("          ,nfi.nfi_valortotal ");
            buf.append("          ,nfi.nfi_issvalor ");
            buf.append("          ,cen.ent_codigo ");
            buf.append(" having CASE WHEN MAX(nfi.nfi_codigo) IS NOT NULL THEN nfi.nfi_codigo IS NOT NULL ELSE true END ");
            buf.append(" order by nfi.nfi_codigo, ent.ent_razaosocial) ");
        }
        if (listaBaixa.size() > 0) {
            if (buf.length() > 0) {
                buf.append(" UNION ");
            }
            buf.append("(select distinct nfi.nfi_codigo as codigoNotaFiscal ");
            buf.append("       ,nfi.nfi_numero as numeroNotaFiscal ");
            buf.append("       ,a.fil_codigo as codigoFilial ");
            buf.append("       ,con.con_codigo as codigoConvenio ");
            buf.append("       ,con.con_fantasia as fantasiaConvenio ");
            buf.append("       ,ent.ent_codigo as codigoEntidade ");
            buf.append("       ,ent.ent_razaosocial as razaoSocialCadastro ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(a.rpg_valortotal, 0) ELSE 0 END as valorTotalBaixa ");
            buf.append("       ,CASE WHEN a.rpg_codigo IS NOT NULL THEN ((COALESCE(a.rpg_valortotal, 0) - COALESCE(a.rpg_issvalor)) * cen.cen_comissao / 100) ELSE SUM((COALESCE(nfi.nfi_valortotal, 0) - COALESCE(nfi.nfi_issvalor, 0)) * cen.cen_comissao / 100) END as valorComissao ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(a.rpg_issvalor, 0) ELSE 0 END as valorIss ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(a.rpg_csllvalor, 0) ELSE 0 END as valorCsll ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(a.rpg_irrfvalor, 0) ELSE 0 END as valorIrrf ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(a.rpg_issretidovalor, 0) ELSE 0 END as valorIssRetido ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(a.rpg_cofinsvalor, 0) ELSE 0 END as valorCofins ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(a.rpg_inssvalor, 0) ELSE 0 END as valorInss ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(a.rpg_pisvalor, 0) ELSE 0 END as valorPis ");
            buf.append("       ,cen.cen_comissao as percentualComissao ");
            buf.append("       ,0 as quantidadeExames ");
            buf.append("       ,COUNT(1) as quantidadeRequisicoes ");
            buf.append("       ,SUM(fre.fre_totalmateriais) as totalMateriaisFaturaRequisicao ");
            buf.append("       ,SUM(fre.fre_totalexames) as totalExamesFaturaRequisicao ");
            buf.append("\t\t   ,cast(MAX(date_trunc('day', bxa.bxa_datahora)) as date) as dataBaixa ");
            buf.append("       ,a.rpg_codigo as codigoReceber ");
            buf.append("       ,array_to_string(array_agg(distinct fat.fat_codigo), ', ') as codigosFaturas ");
            buf.append("       ,'B' as tipoComissao ");
            buf.append("       ,(select COUNT(1) ");
            buf.append("           from receberpagarrp   rrp ");
            buf.append("           join receberpagar     rpg2 on rrp.fil_kodigo = rpg2.fil_codigo and rrp.rpg_kodigo = rpg2.rpg_codigo ");
            buf.append("          where rpg2.rpg_origem = '").append("C").append("' ");
            buf.append("            and rpg2.rpg_tipo = '").append("P").append("' ");
            buf.append("            and rpg2.ent_codigo = cen.ent_codigo ");
            buf.append("            and rrp.rrp_tipo = '").append("C").append("' ");
            buf.append("            and rrp.fil_codigo = a.fil_codigo ");
            buf.append("            and rrp.rpg_codigo = a.rpg_codigo ");
            buf.append("            and rpg2.rpg_situacao <> '").append("X").append("') > 0 as comissaoGerada ");
            buf.append("   from receberpagar     a ");
            buf.append("   join notafiscal       nfi on a.fil_codigo = nfi.fil_codigo and a.nfi_codigo = nfi.nfi_codigo ");
            buf.append("   join faturanotafiscal fnf on nfi.fil_codigo = fnf.fil_codigo and nfi.nfi_codigo = fnf.nfi_codigo ");
            buf.append("   join fatura           fat on fnf.fil_codigo = fat.fil_codigo and fnf.fat_codigo = fat.fat_codigo ");
            buf.append("   join faturarequisicao fre on fat.fil_codigo = fre.fil_codigo and fat.fat_codigo = fre.fat_codigo ");
            buf.append("   join requisicao \t\t\t req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
            buf.append("   join baixareceberpagar\tbrp on a.fil_codigo = brp.fil_codigo and a.rpg_codigo = brp.rpg_codigo ");
            buf.append("   join baixa \t\t\t\t\t\tbxa on brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo ");
            buf.append("   join convenios \t\t\t con on nfi.fil_codigo = con.fil_codigo and nfi.con_codigo = con.con_codigo ");
            buf.append("   join convenioentidade cen on con.fil_codigo = cen.fil_codigo and con.con_codigo = cen.con_codigo ");
            buf.append("   join entidade \t\t\t\t ent on cen.fil_codigo = ent.fil_codigo and cen.ent_codigo = ent.ent_codigo ");
            buf.append("  where fat.fat_datacancelamento IS NULL ");
            buf.append("    and nfi.usr_codcancelada IS NULL ");
            buf.append("    and a.rpg_tipo = '").append("R").append("' and a.rpg_situacao IN ('").append("Q").append("', '").append("A").append("') ");
            buf.append("    and bxa.bxa_situacao = '").append("Q").append("' ");
            buf.append("    and nfi.fil_codigo = ").append(filial);
            if (Funcoes.verificaData(this.textDataInicial.getText())) {
                buf.append(" and ").append(this.comboCampoData.getSelectedItem().equals("Emiss\u00e3o") ? "fat_dtemis" : (this.comboCampoData.getSelectedItem().equals("Vencimento") ? "fat_dtvenc" : "date_trunc('day', bxa_datahora)")).append(" >= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText()));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.textDataFinal.getText())) {
                buf.append(" and ").append(this.comboCampoData.getSelectedItem().equals("Emiss\u00e3o") ? "fat_dtemis" : (this.comboCampoData.getSelectedItem().equals("Vencimento") ? "fat_dtvenc" : "date_trunc('day', bxa_datahora)")).append(" <= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText()));
                buf.append("'");
            }
            buf.append(" and (cen.con_codigo, cen.ent_codigo) IN (select ");
            for (i = 0; i < listaBaixa.size(); ++i) {
                aux = (ConvenioEntidade)listaBaixa.get(i);
                buf.append(aux.codigoConvenio).append(", ").append(aux.codigoEntidade);
                if (i >= listaBaixa.size() - 1) continue;
                buf.append(" UNION select ");
            }
            buf.append(") ");
            buf.append("  group by nfi.nfi_codigo ");
            buf.append("          ,nfi.nfi_numero ");
            buf.append("          ,a.fil_codigo ");
            buf.append("          ,con.con_codigo ");
            buf.append("          ,con.con_fantasia ");
            buf.append("          ,bxa.bxa_codigo ");
            buf.append("          ,a.rpg_valortotal ");
            buf.append("          ,a.rpg_codigo ");
            buf.append("          ,cen.cen_comissao ");
            buf.append("          ,ent.ent_codigo ");
            buf.append("          ,ent.ent_razaosocial ");
            buf.append("          ,cen.ent_codigo ");
            buf.append(" order by nfi.nfi_codigo, ent.ent_razaosocial) ");
        }
        if (listaNotaFiscal.size() > 0) {
            if (buf.length() > 0) {
                buf.append(" UNION ");
            }
            buf.append("(select distinct a.nfi_codigo as codigoNotaFiscal ");
            buf.append("       ,a.nfi_numero as numeroNotaFiscal ");
            buf.append("       ,a.fil_codigo as codigoFilial ");
            buf.append("       ,con.con_codigo as codigoConvenio ");
            buf.append("       ,con.con_fantasia as fantasiaConvenio ");
            buf.append("       ,ent.ent_codigo as codigoEntidade ");
            buf.append("       ,ent.ent_razaosocial as razaoSocialCadastro ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg2.rpg_valortotal, 0) ELSE 0 END as valorTotalBaixa ");
            buf.append("       ,(COALESCE(a.nfi_valortotal, 0) - COALESCE(a.nfi_issvalor, 0)) * cen.cen_comissao / 100 as valorComissao ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg2.rpg_issvalor, 0) ELSE 0 END as valorIss ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg2.rpg_csllvalor, 0) ELSE 0 END as valorCsll ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg2.rpg_irrfvalor, 0) ELSE 0 END as valorIrrf ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg2.rpg_issretidovalor, 0) ELSE 0 END as valorIssRetido ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg2.rpg_cofinsvalor, 0) ELSE 0 END as valorCofins ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg2.rpg_inssvalor, 0) ELSE 0 END as valorInss ");
            buf.append("       ,CASE WHEN bxa.bxa_codigo IS NOT NULL THEN COALESCE(rpg2.rpg_pisvalor, 0) ELSE 0 END as valorPis ");
            buf.append("       ,cen.cen_comissao as percentualComissao ");
            buf.append("       ,0 as quantidadeExames ");
            buf.append("       ,COUNT(1) as quantidadeRequisicoes ");
            buf.append("       ,SUM(fre.fre_totalmateriais) as totalMateriaisFaturaRequisicao ");
            buf.append("       ,SUM(fre.fre_totalexames) as totalExamesFaturaRequisicao ");
            buf.append("\t\t   ,cast(MAX(date_trunc('day', bxa.bxa_datahora)) as date) as dataBaixa ");
            buf.append("       ,MAX(rpg2.rpg_codigo) as codigoReceber ");
            buf.append("       ,array_to_string(array_agg(distinct fat.fat_codigo), ', ') as codigosFaturas ");
            buf.append("       ,'N' as tipoComissao ");
            buf.append("       ,rpg.rpg_codigo IS NOT NULL as comissaoGerada ");
            buf.append("   from notafiscal       a ");
            buf.append("   join faturanotafiscal fnf on a.fil_codigo = fnf.fil_codigo and a.nfi_codigo = fnf.nfi_codigo ");
            buf.append("   join fatura           fat on fnf.fil_codigo = fat.fil_codigo and fnf.fat_codigo = fat.fat_codigo ");
            buf.append("   join faturarequisicao fre on fat.fil_codigo = fre.fil_codigo and fat.fat_codigo = fre.fat_codigo ");
            buf.append("   join requisicao \t\t\t req on fre.fil_kodigo = req.fil_codigo and fre.req_codigo = req.req_codigo ");
            buf.append("   join convenios \t\t\t con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
            buf.append("   join convenioentidade cen on con.fil_codigo = cen.fil_codigo and con.con_codigo = cen.con_codigo ");
            buf.append("   join entidade \t\t\t\t ent on cen.fil_codigo = ent.fil_codigo and cen.ent_codigo = ent.ent_codigo ");
            buf.append("   left join receberpagar      rpg on a.fil_codigo = rpg.fil_codigo and a.nfi_codigo = rpg.nfi_codigo and rpg.rpg_tipo = '").append("P").append("' and rpg.rpg_situacao IN ('").append("Q").append("', '").append("A").append("') and rpg.rpg_origem = '").append("C").append("' ");
            buf.append("   left join receberpagar      rpg2 on a.fil_codigo = rpg2.fil_codigo and a.nfi_codigo = rpg2.nfi_codigo and rpg2.rpg_tipo = '").append("R").append("' and rpg2.rpg_situacao IN ('").append("Q").append("', '").append("A").append("') and rpg2.rpg_origem = '").append("N").append("' ");
            buf.append("   left join baixareceberpagar brp on rpg2.fil_codigo = brp.fil_codigo and rpg2.rpg_codigo = brp.rpg_codigo ");
            buf.append("   left join baixa \t\t\t\t\t\t bxa on brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo and bxa.bxa_situacao = '").append("Q").append("' ");
            buf.append("  where fat.fat_datacancelamento IS NULL ");
            buf.append("    and a.usr_codcancelada IS NULL ");
            buf.append("    and a.fil_codigo = ").append(filial);
            if (Funcoes.verificaData(this.textDataInicial.getText())) {
                buf.append(" and ").append(this.comboCampoData.getSelectedItem().equals("Emiss\u00e3o") ? "fat_dtemis" : (this.comboCampoData.getSelectedItem().equals("Vencimento") ? "fat_dtvenc" : "date_trunc('day', bxa_datahora)")).append(" >= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", this.textDataInicial.getText()));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.textDataFinal.getText())) {
                buf.append(" and ").append(this.comboCampoData.getSelectedItem().equals("Emiss\u00e3o") ? "fat_dtemis" : (this.comboCampoData.getSelectedItem().equals("Vencimento") ? "fat_dtvenc" : "date_trunc('day', bxa_datahora)")).append(" <= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", this.textDataFinal.getText()));
                buf.append("'");
            }
            buf.append(" and (cen.con_codigo, cen.ent_codigo) IN (select ");
            for (i = 0; i < listaNotaFiscal.size(); ++i) {
                aux = (ConvenioEntidade)listaNotaFiscal.get(i);
                buf.append(aux.codigoConvenio).append(", ").append(aux.codigoEntidade);
                if (i >= listaNotaFiscal.size() - 1) continue;
                buf.append(" UNION select ");
            }
            buf.append(") ");
            buf.append("  group by a.nfi_codigo ");
            buf.append("          ,a.nfi_numero ");
            buf.append("          ,a.fil_codigo ");
            buf.append("          ,con.con_codigo ");
            buf.append("          ,con.con_fantasia ");
            buf.append("          ,bxa.bxa_codigo ");
            buf.append("          ,rpg2.rpg_valortotal ");
            buf.append("          ,rpg.rpg_codigo ");
            buf.append("          ,cen.cen_comissao ");
            buf.append("          ,ent.ent_razaosocial ");
            buf.append("          ,ent.ent_codigo ");
            buf.append("          ,a.nfi_valortotal ");
            buf.append("          ,cen.ent_codigo ");
            buf.append(" order by a.nfi_codigo, ent.ent_razaosocial) ");
        }
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        this.comboRefinarDados.removeAllItems();
        this.comboRefinarDados.addItem("Todos");
        this.listaFaturas.clear();
        while (rs.next()) {
            DadosFaturaComissao fatura = new DadosFaturaComissao();
            fatura.codigoFilial = rs.getInt("codigoFilial");
            fatura.codigoConvenio = rs.getInt("codigoConvenio");
            fatura.codigoNotaFiscal = rs.getInt("codigoNotaFiscal") == 0 ? null : Integer.valueOf(rs.getInt("codigoNotaFiscal"));
            fatura.numeroNotaFiscal = rs.getInt("numeroNotaFiscal") == 0 ? null : Integer.valueOf(rs.getInt("numeroNotaFiscal"));
            fatura.fantasiaConvenio = rs.getString("fantasiaConvenio");
            fatura.percentualComissao = rs.getDouble("percentualComissao");
            fatura.razaoSocialCadastro = rs.getString("razaoSocialCadastro");
            fatura.totalExamesFaturaRequisicao = rs.getDouble("totalExamesFaturaRequisicao");
            fatura.totalMateriaisFaturaRequisicao = rs.getDouble("totalMateriaisFaturaRequisicao");
            fatura.valorComissao = rs.getBigDecimal("valorComissao");
            fatura.quantidadeExames = this.getQuantidadeExamesFaturas(rs.getInt("codigoFilial"), rs.getString("codigosFaturas"));
            fatura.quantidadeRequisicoes = rs.getInt("quantidadeRequisicoes");
            fatura.codigoReceber = rs.getInt("codigoReceber") == 0 ? null : Integer.valueOf(rs.getInt("codigoReceber"));
            fatura.dataBaixa = rs.getDate("dataBaixa");
            fatura.valorTotalBaixa = rs.getDouble("valorTotalBaixa");
            fatura.codigosFaturas = rs.getString("codigosFaturas");
            fatura.isComissaoGerada = rs.getBoolean("comissaoGerada");
            fatura.codigoCadastro = rs.getInt("codigoEntidade");
            fatura.valorIss = rs.getDouble("valorIss");
            fatura.valorIssRetido = rs.getDouble("valorIssRetido");
            fatura.valorCsll = rs.getDouble("valorCsll");
            fatura.valorIrrf = rs.getDouble("valorIrrf");
            fatura.valorCofins = rs.getDouble("valorCofins");
            fatura.valorInss = rs.getDouble("valorInss");
            fatura.valorPis = rs.getDouble("valorPis");
            if (!this.checkGerados.isSelected() && fatura.isComissaoGerada.booleanValue()) continue;
            this.listaFaturas.add(fatura);
            this.comboRefinarDados.addItem(fatura.razaoSocialCadastro);
        }
        this.atualizarFaturas(null);
    }

    private int getQuantidadeExamesFaturas(int codigoFilial, String codigosFaturas) {
        StringBuilder aux = new StringBuilder();
        aux.append(" select SUM(fat_qtdeexames) as qtde ");
        aux.append("   from fatura ");
        aux.append("  where fil_codigo = ").append(codigoFilial);
        aux.append("    and fat_codigo IN (").append(codigosFaturas).append(") ");
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), aux);
            if (rs.next()) {
                return rs.getInt("qtde");
            }
            return 0;
        }
        catch (SQLException sqle) {
            return 0;
        }
    }

    private void atualizarFaturas(String razaoSocialCadastro) {
        this.modeloFaturas.clear();
        for (int i = 0; i < this.listaFaturas.size(); ++i) {
            DadosFaturaComissao fatura = this.listaFaturas.get(i);
            if (razaoSocialCadastro != null && !razaoSocialCadastro.equalsIgnoreCase(fatura.razaoSocialCadastro)) continue;
            Double valor = fatura.valorComissao.setScale(2, RoundingMode.HALF_UP).doubleValue();
            this.modeloFaturas.addLine(new Object[]{fatura.numeroNotaFiscal, fatura.codigoConvenio, fatura.fantasiaConvenio, fatura.razaoSocialCadastro, fatura.codigoReceber, Funcoes.formataDecimal(fatura.valorTotalBaixa), Funcoes.formataDecimal(valor), fatura.selecionado, fatura});
        }
        if (this.modeloFaturas.getColunaOrdenacao() != -1) {
            this.modeloFaturas.ordenarColunaSemTrocarSentido(this.modeloFaturas.getColunaOrdenacao());
        } else {
            this.modeloFaturas.ordenarColunaSemTrocarSentido(this.POSICAO_COLUNA_REPRESENTANTE);
        }
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void pressioneiF2() {
        if (this.textDataInicial.hasFocus()) {
            this.buttonDataInicial.doClick();
        } else if (this.textDataFinal.hasFocus()) {
            this.buttonDataFinal.doClick();
        }
    }

    private void limparCampos() {
        this.itemFilial.clear();
        this.itemConvenio.clear();
        this.comboCampoData.setSelectedIndex(0);
        this.textDataInicial.setText("");
        this.textDataFinal.setText("");
        this.modeloFaturas.clear();
        this.comboRefinarDados.removeAllItems();
        this.detalhesFatura.limparDetalhes();
        this.checkGerados.setSelected(false);
        this.listaFaturas.clear();
        while (this.modeloFaturas.getRowCount() > 0) {
            this.modeloFaturas.removeLine(0);
        }
        this.calculaTotalComissoes();
    }

    @Override
    public void editar() {
    }

    @Override
    public void excluir() {
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        if (this.itemFilial.isEnabled() && this.itemFilial.isFocusable()) {
            this.itemFilial.grabFocus();
        }
    }

    @Override
    public void salvar() {
    }

    @Override
    public boolean validaCampos() {
        return false;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600200900");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return "";
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return null;
    }

    class DateDialog
    extends JDialog
    implements ActionListener {
        JLabel labelMensagem;
        TTextField textData;
        JButton buttonCancelar;
        JButton buttonOk;
        JButton buttonData;
        String retorno;

        public DateDialog(Frame owner, String titulo, String mensagem) {
            super(owner, true);
            this.labelMensagem = new JLabel();
            this.textData = new TTextField(10, 4);
            this.buttonCancelar = new JButton("Cancelar");
            this.buttonOk = new JButton("OK");
            this.buttonData = new JButton();
            this.retorno = null;
            this.setTitle(titulo);
            this.labelMensagem.setText(mensagem);
            this.setLayout(new GridBagLayout());
            this.buttonCancelar.setMnemonic('C');
            this.buttonCancelar.addActionListener(this);
            this.buttonOk.setMnemonic('O');
            this.buttonOk.addActionListener(this);
            this.buttonData.setFocusable(false);
            Funcoes.imagemPesquisa(this.buttonData);
            this.buttonData.setMinimumSize(new Dimension(20, 20));
            this.buttonData.setPreferredSize(new Dimension(20, 20));
            this.buttonData.addActionListener(this);
            this.textData.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 113) {
                        DateDialog.this.buttonData.doClick();
                    }
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.gridy = 0;
            c.gridx = 0;
            c.weightx = 1.0;
            c.gridwidth = 2;
            c.fill = 2;
            this.add((Component)this.labelMensagem, c);
            ++c.gridy;
            c.gridwidth = 1;
            this.add((Component)this.textData, c);
            ++c.gridx;
            c.fill = 0;
            c.weightx = 0.0;
            this.add((Component)this.buttonData, c);
            JPanel panelBotoes = new JPanel(new FlowLayout(2));
            panelBotoes.add(this.buttonOk);
            panelBotoes.add(this.buttonCancelar);
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 2;
            c.fill = 2;
            this.add((Component)panelBotoes, c);
            Funcoes.montaEnter((JComponent)this.getContentPane());
            this.setMinimumSize(new Dimension(180, 110));
            this.setPreferredSize(new Dimension(180, 110));
            this.setResizable(false);
            ScreenUtil.centralizar(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.buttonCancelar) {
                this.retorno = null;
                this.dispose();
            } else if (e.getSource() == this.buttonOk) {
                if (Funcoes.textoVazio(this.textData) || !Funcoes.verificaData(this.textData.getText())) {
                    Funcoes.mensagem(this, "Insira uma data v\u00e1lida.", 2);
                    this.textData.clear();
                    ScreenUtil.requisitarFoco(this.textData);
                    return;
                }
                this.retorno = this.textData.getText();
                this.dispose();
            } else if (e.getSource() == this.buttonData) {
                Funcoes.mostraData(this.textData, this.buttonData, (JPanel)this.getContentPane(), true);
            }
        }

        public String getRetorno() {
            return this.retorno;
        }
    }

    class FaturaRenderer
    extends DefaultTableCellRenderer {
        @Override
        public synchronized Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            Component c = null;
            if (!(value instanceof Boolean)) {
                c = super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            } else {
                c = new JCheckBox();
                ((AbstractButton)c).setSelected((Boolean)value);
                ((AbstractButton)c).setHorizontalAlignment(0);
            }
            this.setValue(value);
            if (selected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (Comissao.this.modeloFaturas.getValueAt(row, Comissao.this.POSICAO_COLUNA_OBJETO) != null) {
                DadosFaturaComissao fatura = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(row, Comissao.this.POSICAO_COLUNA_OBJETO);
                if (!fatura.isComissaoGerada.booleanValue()) {
                    c.setBackground(COR_A_PAGAR);
                } else {
                    c.setBackground(COR_JA_PAGO);
                }
                if (selected && c.getBackground() != table.getSelectionBackground()) {
                    c.setBackground(ScreenUtil.escurecerCor(c.getBackground(), 30));
                }
            }
            if (focused) {
                Border border = selected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : UIManager.getBorder("Table.focusCellHighlightBorder");
                ((JComponent)c).setBorder(border);
                if (!selected && table.isCellEditable(row, column)) {
                    Color col = UIManager.getColor("Table.focusCellForeground");
                    if (col != null) {
                        c.setForeground(col);
                    }
                    if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                        c.setBackground(col);
                    }
                }
            } else {
                ((JComponent)c).setBorder(noFocusBorder);
            }
            if (value instanceof Boolean) {
                DadosFaturaComissao fat = (DadosFaturaComissao)Comissao.this.modeloFaturas.getValueAt(row, Comissao.this.modeloFaturas.findColumn("Objeto"));
                if (fat.isComissaoGerada.booleanValue()) {
                    c.setEnabled(false);
                } else {
                    c.setEnabled(true);
                }
            }
            return c;
        }
    }

    class DadosFaturaComissao {
        Integer codigoConvenio;
        String fantasiaConvenio;
        Double percentualComissao;
        String tipoParcela;
        String tipoPagamento;
        Integer codigoFormaPagamento;
        String descricaoFormaPagamento;
        Integer codigoCadastro;
        String fantasiaCadastro;
        String razaoSocialCadastro;
        String codigosFaturas;
        Integer codigoNotaFiscal;
        Integer numeroNotaFiscal;
        Double totalMateriaisFaturaRequisicao;
        Double totalExamesFaturaRequisicao;
        BigDecimal valorComissao;
        String codigoUsuarioComissao;
        Date dataComissao;
        Integer quantidadeExames;
        Integer quantidadeRequisicoes;
        Date dataEmissaoFatura;
        Date dataVencimentoFatura;
        Integer codigoFilial;
        Boolean isComissaoGerada = false;
        Integer codigoReceber;
        Integer codigoBaixa;
        Date dataBaixa;
        Double valorTotalBaixa;
        Double valorBaixaComissao;
        Boolean comissaoAutomaticaGerada = false;
        Boolean comissaoManualGerada = false;
        Double valorIss = 0.0;
        Double valorCsll = 0.0;
        Double valorIrrf = 0.0;
        Double valorIssRetido = 0.0;
        Double valorCofins = 0.0;
        Double valorInss = 0.0;
        Double valorPis = 0.0;
        Boolean selecionado = false;

        DadosFaturaComissao() {
        }

        public boolean equalsCadastro(String fantasiaCadastro) {
            return this.fantasiaCadastro.equalsIgnoreCase(fantasiaCadastro);
        }
    }

    private class DetalhesFatura
    extends Detalhes {
        private Integer qtdeRequisicoes;
        private Integer qtdeExames;
        private Double valorExames;
        private Double valorMateriais;
        private Double percComissao;
        private Date dataEmissao;
        private Date dataVencimento;
        private Date dataBaixa;
        private String codigosFaturas;
        private Double valorIss;
        private Double valorCsll;
        private Double valorIrrf;
        private Double valorIssRetido;
        private Double valorCofins;
        private Double valorInss;
        private Double valorPis;

        public DetalhesFatura() {
            super(1, 15);
            this.valorExames = 0.0;
            this.valorMateriais = 0.0;
            this.percComissao = 0.0;
            this.valorIss = 0.0;
            this.valorCsll = 0.0;
            this.valorIrrf = 0.0;
            this.valorIssRetido = 0.0;
            this.valorCofins = 0.0;
            this.valorInss = 0.0;
            this.valorPis = 0.0;
            this.qtdeRequisicoes = 0;
            this.qtdeExames = 0;
            this.valorExames = 0.0;
            this.valorMateriais = 0.0;
            this.percComissao = 0.0;
            this.dataEmissao = null;
            this.dataVencimento = null;
            this.dataBaixa = null;
            this.codigosFaturas = "";
            this.setFont(this.getFont().deriveFont(11.0f));
        }

        @Override
        public void montaExpandido() {
            this.setPreferredSize(new Dimension(10, 60));
            this.setMinimumSize(new Dimension(10, 60));
            super.montaExpandido();
        }

        @Override
        public void montaReduzido() {
            this.setPreferredSize(new Dimension(10, 20));
            this.setMinimumSize(new Dimension(10, 20));
            super.montaReduzido();
        }

        public void setValores(Integer qtdeRequisicoes, Integer qtdeExames, Double valorExames, Double valorMateriais, Date dataEmissao, Date dataVencimento, Double percComissao, Date dataBaixa, String codigosFaturas, Double valorIss, Double valorCsll, Double valorIrrf, Double valorIssRetido, Double valorCofins, Double valorInss, Double valorPis) {
            this.qtdeRequisicoes = qtdeRequisicoes;
            this.qtdeExames = qtdeExames;
            this.valorExames = valorExames;
            this.valorMateriais = valorMateriais;
            this.dataEmissao = dataEmissao;
            this.dataVencimento = dataVencimento;
            this.percComissao = percComissao;
            this.dataBaixa = dataBaixa;
            this.codigosFaturas = codigosFaturas;
            this.valorIss = valorIss;
            this.valorCsll = valorCsll;
            this.valorIrrf = valorIrrf;
            this.valorIssRetido = valorIssRetido;
            this.valorCofins = valorCofins;
            this.valorInss = valorInss;
            this.valorPis = valorPis;
            this.atualizarDados();
        }

        @Override
        protected void atualizarDados() {
            StringBuilder html = new StringBuilder();
            html.append("<html>");
            html.append("<table style='font-size:10pt'>");
            html.append("<tr>");
            if (this.getSituacao() == 1) {
                html.append("<td><b>Qtde. Requisi\u00e7\u00f5es:").append("</b></td>");
                html.append("<td align=\"right\" width=30>").append(this.qtdeRequisicoes == null ? "" : this.qtdeRequisicoes).append("</td>");
                html.append("<td width=6>-</td>");
                html.append("<td><b>Vl. Exames:").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorExames == null ? "" : Funcoes.formataDecimal("0.00", this.valorExames)).append("</td>");
                html.append("<td width=6>-</td>");
                html.append("<td><b>ISSQN:").append("</b></td>");
                html.append("<td align=\"right\" width=50>").append(this.valorIss == null ? "" : Funcoes.formataDecimal("0.00", this.valorIss)).append("</td>");
                html.append("<td width=6>-</td>");
                html.append("<td><b>CSLL:").append("</b></td>");
                html.append("<td align=\"right\" width=50>").append(this.valorCsll == null ? "" : Funcoes.formataDecimal("0.00", this.valorCsll)).append("</td>");
                html.append("<td width=6>-</td>");
                html.append("<td><b>IRRF:").append("</b></td>");
                html.append("<td align=\"right\" width=50>").append(this.valorIrrf == null ? "" : Funcoes.formataDecimal("0.00", this.valorIrrf)).append("</td>");
                html.append("</tr>");
                html.append("<tr>");
                html.append("<td><b>Qtde. Exames:").append("</b></td>");
                html.append("<td align=\"right\" width=30>").append(this.qtdeExames == null ? "" : this.qtdeExames).append("</td>");
                html.append("<td width=6>-</td>");
                html.append("<td><b>Vl. Materiais:").append("</b></td>");
                html.append("<td align=\"right\" width=60>").append(this.valorMateriais == null ? "" : Funcoes.formataDecimal("0.00", this.valorMateriais)).append("</td>");
                html.append("<td width=6>-</td>");
                html.append("<td><b>COFINS:").append("</b></td>");
                html.append("<td align=\"right\" width=50>").append(this.valorCofins == null ? "" : Funcoes.formataDecimal("0.00", this.valorCofins)).append("</td>");
                html.append("<td width=6>-</td>");
                html.append("<td><b>INSS:").append("</b></td>");
                html.append("<td align=\"right\" width=50>").append(this.valorInss == null ? "" : Funcoes.formataDecimal("0.00", this.valorInss)).append("</td>");
                html.append("<td width=6>-</td>");
                html.append("<td><b>PIS:").append("</b></td>");
                html.append("<td align=\"right\" width=50>").append(this.valorPis == null ? "" : Funcoes.formataDecimal("0.00", this.valorPis)).append("</td>");
                html.append("</tr>");
                html.append("<tr>");
                html.append("<td><b>% Comiss\u00e3o:").append("</b></td>");
                html.append("<td align=\"right\" width=30>").append(this.percComissao == null ? "" : Funcoes.formataDecimal("0.00", this.percComissao)).append("</td>");
                html.append("<td width=6>-</td>");
                html.append("<td><b>Dt. \u00dalt. Baixa:").append("</b></td>");
                html.append("<td align=\"right\" width=75>").append(this.dataBaixa == null ? "" : Funcoes.formataData("dd/MM/yyyy", this.dataBaixa)).append("</td>");
                html.append("<td width=6>-</td>");
                html.append("<td><b>ISS ret.:").append("</b></td>");
                html.append("<td align=\"right\" width=50>").append(this.valorIssRetido == null ? "" : Funcoes.formataDecimal("0.00", this.valorIssRetido)).append("</td>");
                html.append("<td width=6>-</td>");
                html.append("<td><b>Faturas:").append("</b></td>");
                html.append("<td align=\"left\" colspan=3>").append(this.codigosFaturas == null ? "" : this.codigosFaturas).append("</td>");
            } else {
                html.append("<td><b>Detalhes").append("</b></td>");
            }
            html.append("</tr>");
            html.append("</table>");
            html.append("</html>");
            this.setDetalhes(html.toString());
            this.repaint();
        }

        public void limparDetalhes() {
            this.setValores(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

