/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.financeiro.faturamento.DialogNotas;
import jalis.laboratorio.financeiro.faturamento.ObjetoExame;
import jalis.laboratorio.recepcao.selecionarimagem.SelecionarImagem;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.util.faturamento.eletronico.ArquivoFaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.FabricaFaturaEletronica;
import jalis.laboratorio.util.faturamento.eletronico.IPERGS;
import jalis.relatorio.Editor;
import jalis.relatorio.Gerador;
import jalis.service.recepcao.selecionarimagem.SelecionarImagemService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AuditoriaIPERGS
extends JPanel
implements ActionListener,
ListSelectionListener {
    private TTextField textNota = new TTextField(5, 1);
    private JButton buttonConfigurar = ComponenteFactory.novoJButton("Configurar", 'f', this);
    private JButton buttonPedidosAnexados = ComponenteFactory.novoJButton("Pedidos anexados", 'P', this);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir \u25bc", 'I', this);
    private JButton buttonGerarEletronico = ComponenteFactory.novoJButton("Gerar Eletr\u00f4nico", 'G', this);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Nota", "Filial", "Requisi\u00e7\u00e3o", "Paciente", "Conv\u00eanio", "Data Fat"});
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame"});
    private JTable tableRequisicoes = new JTable(this.modeloRequisicoes);
    private JTable tableExames = new JTable(this.modeloExames);
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPopupMenu menuImprimir = new JPopupMenu();
    private JMenuItem itemImprimirLaudo = ComponenteFactory.novoJMenuItem(this.menuImprimir, "Laudos", (ActionListener)this);
    private JMenuItem itemImprimirRelatorio = ComponenteFactory.novoJMenuItem(this.menuImprimir, "Relat\u00f3rio", (ActionListener)this);
    private final int COLUNA_NOTA = 0;
    private final int COLUNA_FILIAL = 1;
    private final int COLUNA_REQUISICAO = 2;
    private final int COLUNA_PACIENTE = 3;
    private final int COLUNA_CONVENIO = 4;
    private final int COLUNA_DATA_FATURA = 5;
    private final int COLUNA_MATRICULA = 6;
    private final int COLUNA_DATA_INICIO_FATURA = 7;
    private final int COLUNA_DATA_FIM_FATURA = 8;
    private final int COLUNA_EXAMES = 9;
    private final String[] CAMPOS_RELATORIO = new String[]{"numeroNota", "codigoRequisicao", "nomePaciente", "fantasiaConvenio", "dataFatura", "matriculaPaciente", "codigoExame", "abreviaturaMaterialColeta", "descricaoExame", "ambExame", "valorExame", "identificadorAuditoria", "codigoFilial", "descricaoFilial", "dataInicioFatura", "dataFimFatura"};

    public AuditoriaIPERGS() {
        this.montaTela();
    }

    private void montaTela() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (AuditoriaIPERGS.this.getParent() != null) {
                    AuditoriaIPERGS.this.getParent().removeAll();
                }
            }
        });
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Auditoria IPERGS", "Auditoria de notas para o IPERGS", "financeiro/auditoria_ipergs.jpg");
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonConfigurar, this.buttonPedidosAnexados), "West");
        this.panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonNovo, this.buttonImprimir, this.buttonGerarEletronico, this.buttonFechar), "East");
        this.textNota.addActionListener(this);
        JScrollPane scrollR = new JScrollPane(this.tableRequisicoes);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.fill = 2;
        c.weightx = 1.0;
        this.textNota.setPreferredSize(new Dimension(70, 20));
        this.panelCentro.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, 0, 1, new JLabel("Nota:"), this.textNota), c);
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.fill = 1;
        c.weighty = 1.0;
        JPanel p = ComponenteFactory.novoJPanel(new BorderLayout(), new Dimension(100, 200), new TitledBorder("Requisi\u00e7\u00f5es"));
        p.add((Component)scrollR, "Center");
        this.panelCentro.add((Component)p, c);
        c.gridx = 2;
        c.weightx = 0.3;
        JScrollPane scrollE = new JScrollPane(this.tableExames);
        scrollE.setPreferredSize(new Dimension(100, 200));
        JPanel p1 = ComponenteFactory.novoJPanel(new BorderLayout(), new Dimension(100, 150), new TitledBorder("Exames"));
        p1.add((Component)scrollE, "Center");
        this.panelCentro.add((Component)p1, c);
        this.modeloRequisicoes.setColumnSize(new int[]{70, 30, 80, 0, 100, 90}, this.tableRequisicoes);
        this.modeloExames.setColumnSize(new int[]{50, 40, 0}, this.tableExames);
        this.buttonConfigurar.setVisible(Acesso.getAcesso(AuditoriaIPERGS.getModuloAcessoConfigurar()));
        this.buttonPedidosAnexados.setVisible(Acesso.getAcesso(AuditoriaIPERGS.getModuloVisualizarImagens()));
        this.tableRequisicoes.getSelectionModel().addListSelectionListener(this);
        this.tableRequisicoes.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (AuditoriaIPERGS.this.tableRequisicoes.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(AuditoriaIPERGS.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    AuditoriaIPERGS.this.modeloRequisicoes.removeLine(AuditoriaIPERGS.this.tableRequisicoes.getSelectedRow());
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AuditoriaIPERGS.this.novo();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.textNota) {
            this.preencheNota();
        } else if (e.getSource() == this.buttonNovo) {
            this.novo();
        } else if (e.getSource() == this.buttonImprimir) {
            this.menuImprimir.show(this.buttonImprimir.getParent(), this.buttonImprimir.getX(), this.buttonImprimir.getY() + this.buttonImprimir.getHeight());
        } else if (e.getSource() == this.itemImprimirLaudo) {
            this.imprimirLaudos();
        } else if (e.getSource() == this.itemImprimirRelatorio) {
            this.imprimirRelatorio();
        } else if (e.getSource() == this.buttonConfigurar) {
            this.configurarRelatorio();
        } else if (e.getSource() == this.buttonGerarEletronico) {
            this.gerarEletronico();
        } else if (e.getSource() == this.buttonPedidosAnexados) {
            SelecionarImagem selecionarImagem = SelecionarImagem.novaInstancia(this.getTopLevelAncestor(), AuditoriaIPERGS.getCodigoIdentificadorJanela());
            int linhaSelecionada = this.tableRequisicoes.getSelectedRow();
            if (!Funcoes.objectIsNull(selecionarImagem) && linhaSelecionada >= 0) {
                String codigoFilial = this.modeloRequisicoes.getValueAt(linhaSelecionada, 1).toString();
                String codigoRequisicao = this.modeloRequisicoes.getValueAt(linhaSelecionada, 2).toString();
                if (!codigoFilial.isEmpty() && !codigoRequisicao.isEmpty()) {
                    selecionarImagem.setRequisicao(codigoFilial, codigoRequisicao, null);
                    selecionarImagem.setVisible(true);
                }
            }
        }
    }

    private void gerarEletronico() {
        IPERGS ipergs = (IPERGS)FabricaFaturaEletronica.novoFaturamentoEletronico(IPERGS.getNomeProtocolo());
        if (this.modeloRequisicoes.getRowCount() > 0) {
            String path = "";
            JFileChooser file = ComponenteFactory.novoJFileChooser();
            file.setFileSelectionMode(1);
            if (file.showSaveDialog(this) != 0) {
                return;
            }
            path = file.getSelectedFile().getAbsolutePath();
            if (this.verificarNotasSemImagensObrigatorias()) {
                return;
            }
            SplashMensagem splash = new SplashMensagem();
            splash.mostrar("Gerando dados. Aguarde...");
            int contaArquivos = 0;
            for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                ArrayList<ArquivoFaturamentoEletronico> arquivos = ipergs.criarArquivoNota(Variaveis.filialPadrao, this.modeloRequisicoes.getValueAt(i, 0).toString(), this.modeloRequisicoes.getValueAt(i, 1).toString(), this.modeloRequisicoes.getValueAt(i, 2).toString(), path);
                if (arquivos == null || arquivos.size() <= 0) continue;
                for (ArquivoFaturamentoEletronico arquivo : arquivos) {
                    if (Funcoes.textoVazio(arquivo.getXML())) continue;
                    String nomeArquivo = path + "/" + arquivo.getNome() + "." + FabricaFaturaEletronica.getExtensaoArquivo(IPERGS.getNomeProtocolo(), null);
                    try {
                        StringUtil.escreverArquivoTexto(nomeArquivo, arquivo.getXML());
                    }
                    catch (Exception e) {
                        Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel gravar o arquivo " + nomeArquivo + ".\nMensagem: " + e.getMessage(), 1);
                    }
                    ++contaArquivos;
                }
            }
            splash.apagar();
            if (contaArquivos > 0) {
                Funcoes.mensagem(this, "Arquivo(s) criado(s) com sucesso.", 2);
            }
        }
    }

    private boolean verificarNotasSemImagensObrigatorias() {
        SelecionarImagemService selecionarImagemService = new SelecionarImagemService();
        StringBuilder codigosRequisicoes = new StringBuilder();
        for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
            if (!codigosRequisicoes.toString().isEmpty()) {
                codigosRequisicoes.append(", ");
            }
            codigosRequisicoes.append(this.modeloRequisicoes.getValueAt(i, 2));
        }
        try {
            String[] tipoImagensObrigatorias = new String[]{"A", "P"};
            String codigosNotasSemImagensObrigatorias = selecionarImagemService.getCodigosNotasSemImagensObrigatorias(Variaveis.filialPadrao, codigosRequisicoes.toString(), tipoImagensObrigatorias);
            if (!codigosNotasSemImagensObrigatorias.isEmpty()) {
                StringBuilder mensagem = new StringBuilder();
                mensagem.append("Existem notas com documenta\u00e7\u00e3o insuficiente para auditoria. Notas com c\u00f3digo: ");
                mensagem.append(codigosNotasSemImagensObrigatorias).append(". Deseja continuar?");
                if (Funcoes.mensagem(this, mensagem.toString(), 4) == 1) {
                    return true;
                }
            }
        }
        catch (SQLException e) {
            StringBuilder mensagem = new StringBuilder();
            mensagem.append("N\u00e3o foi poss\u00edvel verificar as notas com pend\u00eancias de documentos.\n");
            mensagem.append(e.getMessage());
            ErrorLogger.mostraMensagem(this, mensagem.toString(), e.getStackTrace(), "AuditoriaIPERGS");
        }
        return false;
    }

    private void configurarRelatorio() {
        block12: {
            if (AuditoriaIPERGS.getModuloAcesso() == -1L) {
                return;
            }
            try {
                Statement st = Conexao.getStatement();
                StringBuilder buf = new StringBuilder("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(AuditoriaIPERGS.getModuloAcesso());
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                String modelo = "";
                if (rs.next()) {
                    modelo = rs.getString("rel_xml");
                }
                Editor editor = new Editor((JFrame)this.getTopLevelAncestor(), "Configurando relat\u00f3rio", true);
                editor.setCamposDoBanco(this.CAMPOS_RELATORIO);
                if (!Funcoes.textoVazio(modelo)) {
                    editor.setAtributos(rs.getString("rel_xml"));
                }
                editor.setVisible(true);
                if (!editor.ok()) break block12;
                buf.delete(0, buf.length());
                buf.append("select rel_codigo from relatoriosistema where rel_codigo = ");
                buf.append(AuditoriaIPERGS.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                buf.delete(0, buf.length());
                if (rs.next()) {
                    buf.append("update relatoriosistema set rel_xml = '");
                    buf.append(StringUtil.textoDB(editor.getAtributos()));
                    buf.append("' where rel_codigo = ");
                    buf.append(AuditoriaIPERGS.getModuloAcesso());
                } else {
                    buf.append("insert into relatoriosistema(rel_codigo, rel_xml) values (");
                    buf.append(AuditoriaIPERGS.getModuloAcesso());
                    buf.append(", '");
                    buf.append(StringUtil.textoDB(editor.getAtributos()));
                    buf.append("')");
                }
                try {
                    String[] filiaisIntegracao;
                    Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
                    for (String filial : filiaisIntegracao = IntegracaoUtil.filiaisParaIntegrar(st)) {
                        if (filial.equals(Variaveis.filialPadrao)) continue;
                        IntegracaoUtil.insereComandoLog(st, Variaveis.filialPadrao, filial, buf.toString());
                    }
                    Conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AuditoriaIPERGS");
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "AuditoriaIPERGS");
            }
        }
    }

    private boolean examePaiJaInserido(ObjetoExame exame, ArrayList<ObjetoExame> lista) {
        for (ObjetoExame o : lista) {
            if (!o.codigoPai.equals(exame.codigoPai) || o.codigoMaterialPai != exame.codigoMaterialPai) continue;
            return true;
        }
        return false;
    }

    private ArrayList<ObjetoExame> removerPaiRepetido(ArrayList<ObjetoExame> lista) {
        ArrayList<ObjetoExame> a = new ArrayList<ObjetoExame>();
        for (ObjetoExame o : lista) {
            if (this.examePaiJaInserido(o, lista)) continue;
            a.add(o);
        }
        return a;
    }

    private void imprimirLaudos() {
        if (this.modeloRequisicoes.getRowCount() > 0) {
            SplashMensagem splash = SplashMensagem.getInstancia(this);
            splash.mostrar("Imprimindo laudos...");
            for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                if (this.modeloRequisicoes.getValueAt(i, 9) == null) continue;
                ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(i, 9);
                String requisicao = this.modeloRequisicoes.getValueAt(i, 2).toString();
                ArrayList<ObjetoExame> listaSemRepetirPai = this.removerPaiRepetido(exames);
                ArrayList<String> codigosExames = new ArrayList<String>();
                ArrayList<String> codigosMateriais = new ArrayList<String>();
                for (ObjetoExame exm : listaSemRepetirPai) {
                    codigosExames.add(exm.codigoPai);
                    codigosMateriais.add(String.valueOf(exm.codigoMaterialPai));
                }
                try {
                    ImpressaoResultados.imprimirExames(null, this.getTopLevelAncestor(), Variaveis.filialPadrao, requisicao, true, null, codigosExames.toArray(new String[codigosExames.size()]), codigosMateriais.toArray(new String[codigosMateriais.size()]), false);
                    Conexao.arquivaSQL();
                    continue;
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "AuditoriaIPERGS: 185");
                }
            }
            splash.apagar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imprimirRelatorio() {
        if (this.modeloRequisicoes.getRowCount() > 0) {
            String identificadorAuditoria = JOptionPane.showInputDialog(this.getTopLevelAncestor(), "N\u00famero da auditoria", "N\u00famero", -1);
            if (Funcoes.textoVazio(identificadorAuditoria)) {
                Funcoes.mensagem(this, "O identificador da auditoria n\u00e3o foi informado", 1);
                return;
            }
            this.modeloRequisicoes.ordenarColuna(0, 1);
            ModeloGridTable modeloRelatorio = new ModeloGridTable(this.CAMPOS_RELATORIO);
            for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                Object[] o = new Object[modeloRelatorio.getColumnCount()];
                ArrayList exames = (ArrayList)this.modeloRequisicoes.getValueAt(i, 9);
                for (ObjetoExame exm : exames) {
                    int pos = this.indiceColuna(modeloRelatorio, "numeroNota");
                    o[pos] = this.modeloRequisicoes.getValueAt(i, 0);
                    pos = this.indiceColuna(modeloRelatorio, "codigoRequisicao");
                    o[pos] = this.modeloRequisicoes.getValueAt(i, 2);
                    pos = this.indiceColuna(modeloRelatorio, "nomePaciente");
                    o[pos] = this.modeloRequisicoes.getValueAt(i, 3);
                    pos = this.indiceColuna(modeloRelatorio, "fantasiaConvenio");
                    o[pos] = this.modeloRequisicoes.getValueAt(i, 4);
                    pos = this.indiceColuna(modeloRelatorio, "dataFatura");
                    o[pos] = Funcoes.stringToDate(this.modeloRequisicoes.getValueAt(i, 5).toString());
                    pos = this.indiceColuna(modeloRelatorio, "dataInicioFatura");
                    o[pos] = Funcoes.stringToDate(this.modeloRequisicoes.getValueAt(i, 7).toString());
                    pos = this.indiceColuna(modeloRelatorio, "dataFimFatura");
                    o[pos] = Funcoes.stringToDate(this.modeloRequisicoes.getValueAt(i, 8).toString());
                    pos = this.indiceColuna(modeloRelatorio, "matriculaPaciente");
                    o[pos] = this.modeloRequisicoes.getValueAt(i, 6);
                    pos = this.indiceColuna(modeloRelatorio, "codigoExame");
                    o[pos] = exm.codigo;
                    pos = this.indiceColuna(modeloRelatorio, "abreviaturaMaterialColeta");
                    o[pos] = exm.abrevMaterial;
                    pos = this.indiceColuna(modeloRelatorio, "descricaoExame");
                    o[pos] = exm.descricao;
                    pos = this.indiceColuna(modeloRelatorio, "ambExame");
                    o[pos] = exm.amb;
                    pos = this.indiceColuna(modeloRelatorio, "valorExame");
                    o[pos] = exm.valor;
                    pos = this.indiceColuna(modeloRelatorio, "identificadorAuditoria");
                    o[pos] = identificadorAuditoria;
                    pos = this.indiceColuna(modeloRelatorio, "codigoFilial");
                    o[pos] = this.modeloRequisicoes.getValueAt(i, 1);
                    pos = this.indiceColuna(modeloRelatorio, "descricaoFilial");
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select fil_descricao ");
                    buf.append("   from filiais_postocoleta ");
                    buf.append("  where fil_codigo = ").append(this.modeloRequisicoes.getValueAt(i, 1));
                    String descricao = null;
                    try {
                        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                        descricao = rs.next() ? rs.getString("fil_descricao") : Variaveis.descricaoFilialPadrao;
                    }
                    catch (Exception e) {
                        descricao = Variaveis.descricaoFilialPadrao;
                    }
                    o[pos] = descricao;
                    modeloRelatorio.addLine(o);
                    o = new Object[modeloRelatorio.getColumnCount()];
                }
            }
            if (modeloRelatorio.getRowCount() > 0) {
                Statement st;
                block11: {
                    st = Conexao.getStatement();
                    try {
                        StringBuilder buf = new StringBuilder();
                        buf.delete(0, buf.length());
                        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                        buf.append(AuditoriaIPERGS.getModuloAcesso());
                        ResultSet rs = Conexao.executeQuery(st, buf.toString());
                        if (!rs.next()) break block11;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                AuditoriaIPERGS.this.panelCentro.removeAll();
                                AuditoriaIPERGS.this.panelCentro.repaint();
                            }
                        });
                        gerador.executar(rs.getString("rel_xml"), modeloRelatorio);
                    }
                    catch (Exception e) {
                        try {
                            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "AuditoriaIPERGS: 363");
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            throw throwable;
                        }
                        Conexao.fecharStatement(st);
                    }
                }
                Conexao.fecharStatement(st);
            }
        }
    }

    private int indiceColuna(ModeloGridTable modelo, String coluna) {
        for (int i = 0; i < modelo.getColumnCount(); ++i) {
            if (!modelo.getColumnName(i).equalsIgnoreCase(coluna)) continue;
            return i;
        }
        return -1;
    }

    private void novo() {
        this.modeloRequisicoes.clear();
        this.modeloExames.clear();
        this.textNota.clear();
        ScreenUtil.requisitarFoco(this.textNota);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preencheNota() {
        Statement st;
        block21: {
            if (Funcoes.textoVazio(this.textNota.getText())) {
                this.textNota.clear();
                ScreenUtil.requisitarFoco(this.textNota);
                return;
            }
            boolean podeAdicionar = true;
            for (int i = 0; i < this.modeloRequisicoes.getRowCount(); ++i) {
                String nota = this.modeloRequisicoes.getValueAt(i, 0).toString();
                if (!nota.equalsIgnoreCase(this.textNota.getText())) continue;
                podeAdicionar = false;
                break;
            }
            if (!podeAdicionar) {
                Funcoes.mensagem(this, "A nota j\u00e1 foi adicionada.", 2);
                this.textNota.selectAll();
                ScreenUtil.requisitarFoco(this.textNota);
                return;
            }
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append(" select COUNT(distinct fer.fat_codigo) as qtde ");
            buf.append("   from faturaexamerequisicao fer ");
            buf.append("   join fatura fat on fer.fil_codigo = fat.fil_codigo and fer.fat_codigo = fat.fat_codigo ");
            buf.append("   join requisicao req on fer.fil_kodigo = req.fil_codigo and fer.req_codigo = req.req_codigo ");
            buf.append("   join examerequisicao exr on fer.fil_kodigo = exr.fil_codigo and fer.req_codigo = exr.req_codigo and fer.exa_codigo = exr.exa_codigo and fer.mco_codigo = exr.mco_codigo ");
            buf.append("  where fer.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and fer.fer_notaipergs = ").append(this.textNota.getText());
            buf.append("    and req.req_excluida = false ");
            buf.append("    and exr.exr_excluido = false ");
            buf.append("    and fat.fat_datacancelamento is null ");
            Integer codigoFatura = null;
            Integer codigoRequisicao = null;
            int qtde = 0;
            try {
                ResultSet rsQtde = Conexao.executeQuery(st, buf.toString());
                if (rsQtde.next()) {
                    qtde = rsQtde.getInt("qtde");
                }
            }
            catch (SQLException e1) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar notas do IPERGS.\n" + e1.getMessage(), e1.getStackTrace());
            }
            if (qtde == 0) {
                Funcoes.mensagem(this, "Nota n\u00e3o localizada", 2);
                this.textNota.selectAll();
                return;
            }
            if (qtde > 1) {
                DialogNotas dialogNotas = new DialogNotas((Frame)Laboratorio.getInstancia(), this.textNota.getText());
                dialogNotas.setVisible(true);
                if (dialogNotas.getOk()) {
                    codigoFatura = dialogNotas.getCodigoFatura();
                    codigoRequisicao = dialogNotas.getCodigoRequisicao();
                }
                if (codigoFatura == null || codigoRequisicao == null) {
                    Funcoes.mensagem(this, "Nenhuma nota selecionada.", 2);
                    this.textNota.selectAll();
                    return;
                }
            }
            try {
                buf.setLength(0);
                buf.append(" select a.* ");
                buf.append("       ,b.exa_descricao ");
                buf.append("       ,c.mco_abreviatura ");
                buf.append("       ,c.mco_codigo ");
                buf.append("       ,f.fat_dtemis ");
                buf.append("       ,g.pac_nome ");
                buf.append("       ,h.con_fantasia ");
                buf.append("       ,e.req_matricula ");
                buf.append("       ,a.fer_total ");
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append("       ,COALESCE(NULLIF(TRIM(dtm.dtm_codamb), ''), dtp.dtp_codamb) as dtp_codamb ");
                } else {
                    buf.append("       ,dtp.dtp_codamb ");
                }
                buf.append("       ,f.fat_dtinicio ");
                buf.append("       ,f.fat_dtfim ");
                buf.append("       ,a.exa_codigo ");
                buf.append("       ,a.mco_codigo ");
                buf.append("   from faturaexamerequisicao a ");
                buf.append("   left join exames b on a.fil_kodigo = b.fil_codigo and a.exa_codfilho = b.exa_codigo ");
                buf.append("   left join materialcoleta c on a.fil_kodigo = c.fil_codigo and a.mco_codfilho = c.mco_codigo ");
                buf.append("   left join examerequisicao d on a.fil_kodigo = d.fil_codigo and a.req_codigo = d.req_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
                buf.append("   left join requisicao e on d.fil_codigo = e.fil_codigo and d.req_codigo = e.req_codigo ");
                buf.append("   left join fatura f on a.fil_codigo = f.fil_codigo and a.fat_codigo = f.fat_codigo ");
                buf.append("   left join paciente g on e.fil_codigo = g.fil_codigo and e.pac_codigo = g.pac_codigo ");
                buf.append("   left join convenios h on e.fil_codigo = h.fil_codigo and e.con_codigo = h.con_codigo ");
                if (ParametrosGerais.getPrecoMetodologia()) {
                    buf.append("   left join detalhetabelaprecometodologia dtm on a.fil_kodigo = dtm.fil_codigo and a.exa_codigo = dtm.exa_codigo and a.mco_codigo = dtm.mco_codigo and h.tpe_codigo = dtm.tpe_codigo and d.met_codigo = dtm.met_codigo ");
                }
                buf.append("   left join detalhetabelapreco dtp on a.fil_kodigo = dtp.fil_codigo and a.exa_codigo = dtp.exa_codigo and a.mco_codigo = dtp.mco_codigo and h.tpe_codigo = dtp.tpe_codigo ");
                buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append("    and a.fer_notaipergs = ").append(this.textNota.getText());
                buf.append("    and e.req_excluida = false and d.exr_excluido = false ");
                buf.append("    and f.fat_datacancelamento is null ");
                if (codigoFatura != null) {
                    buf.append(" and a.fat_codigo = ").append(codigoFatura);
                }
                if (codigoRequisicao != null) {
                    buf.append(" and a.req_codigo = ").append(codigoRequisicao);
                }
                buf.append("  order by a.req_codigo, a.fer_ordem ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                ArrayList<ObjetoExame> exames = new ArrayList<ObjetoExame>();
                if (rs.next()) {
                    Object[] o = new Object[]{this.textNota.getText(), rs.getString("fil_kodigo"), rs.getString("req_codigo"), rs.getString("pac_nome"), rs.getString("con_fantasia"), Funcoes.formataData(rs.getDate("fat_dtemis")), rs.getString("req_matricula"), Funcoes.formataData(rs.getDate("fat_dtinicio")), Funcoes.formataData(rs.getDate("fat_dtfim"))};
                    do {
                        exames.add(new ObjetoExame(rs.getString("exa_codfilho"), rs.getString("exa_descricao"), rs.getString("mco_abreviatura"), rs.getInt("mco_codfilho"), rs.getString("dtp_codamb"), rs.getDouble("fer_total"), rs.getString("exa_codigo"), rs.getInt("mco_codigo")));
                    } while (rs.next());
                    this.modeloRequisicoes.addLine(ArraysUtil.concatenar(o, new Object[]{exames}));
                    this.tableRequisicoes.setRowSelectionInterval(this.modeloRequisicoes.getRowCount() - 1, this.modeloRequisicoes.getRowCount() - 1);
                    break block21;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Funcoes.mensagem(AuditoriaIPERGS.this, "Nota n\u00e3o localizada", 1);
                    }
                });
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.textNota.clear();
        this.textNota.grabFocus();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600200700");
    }

    public static long getModuloAcessoConfigurar() {
        return Long.parseLong("0600200701");
    }

    public static long getModuloVisualizarImagens() {
        return Long.parseLong("0600200702");
    }

    public static long getModuloAdicionarImagens() {
        return Long.parseLong("0600200703");
    }

    public static long getModuloExcluirImagens() {
        return Long.parseLong("0600200704");
    }

    public static int getCodigoIdentificadorJanela() {
        return 3;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.tableRequisicoes.getSelectedRow() > -1 && this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 9) != null) {
            this.modeloExames.clear();
            ArrayList a = (ArrayList)this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 9);
            for (ObjetoExame exm : a) {
                this.modeloExames.addLine(new String[]{exm.codigo, exm.abrevMaterial, exm.descricao, String.valueOf(exm.codigoMaterial)});
            }
        }
    }
}

