/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.ConvenioUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

class AlterarGuiaMatricula
extends AbstractDialogoOKCancelar {
    private final TTextField textGuia = new TTextField(20);
    private final TTextField textMatricula = new TTextField(20);
    private DadosConvenios convenio = null;

    public static AlterarGuiaMatricula novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new AlterarGuiaMatricula((Frame)owner, "Alterar matr\u00edcula/guia");
        }
        if (owner instanceof Dialog) {
            return new AlterarGuiaMatricula((Dialog)owner, "Alterar matr\u00edcula/guia");
        }
        return null;
    }

    public AlterarGuiaMatricula(Frame owner, String titulo) {
        super(owner, titulo);
        this.montaTela();
    }

    public AlterarGuiaMatricula(Dialog owner, String titulo) {
        super(owner, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(300, 140));
        this.setResizable(false);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panel.add((Component)ComponenteFactory.novoJLabel("Matr\u00edcula", 'M', null, this.textMatricula), c);
        c.gridy = 2;
        panel.add((Component)ComponenteFactory.novoJLabel("Guia", 'G', null, this.textGuia), c);
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 1;
        panel.add((Component)this.textMatricula, c);
        c.gridy = 3;
        panel.add((Component)this.textGuia, c);
        ScreenUtil.requisitarFoco(this.textMatricula);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConvenio(String codigoFilial, String codigoConvenio) {
        Statement st;
        block4: {
            st = Conexao.getStatement();
            try {
                this.convenio = ConvenioUtil.getDadosConvenios(codigoFilial, Integer.parseInt(codigoConvenio));
                this.textMatricula.setFormatterFactory(null);
                if (this.convenio.getMatricula().trim().length() <= 0) break block4;
                MaskFormatter format = new MaskFormatter(this.convenio.getMatricula());
                this.textMatricula.setFormatterFactory(new DefaultFormatterFactory(format));
                this.textMatricula.setValue(null);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "AlterarGuiaMatricula: 1254");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    public boolean acaoOk() {
        if (this.convenio != null) {
            if (Funcoes.textoVazio(this.textMatricula.getText()) && this.convenio.getExigeMatricula()) {
                Funcoes.mensagem(this, "A matr\u00edcula deve ser informada", 1);
                return false;
            }
            if (Funcoes.textoVazio(this.textGuia.getText()) && this.convenio.getExigeCodigoGuia()) {
                Funcoes.mensagem(this, "A guia deve ser informada", 1);
                return false;
            }
        }
        return true;
    }

    public String getGuia() {
        return this.textGuia.getText();
    }

    public String getMatricula() {
        return this.textMatricula.getText();
    }

    public void setGuia(String guia) {
        this.textGuia.setText(guia);
    }

    public void setMatricula(String matricula) {
        this.textMatricula.setText(matricula);
    }
}

