/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.faturamento;

import jalis.comum.Conexao;
import jalis.comum.dados.faturamento.DadosExameFaturamento;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AlteraGuiasFaturamento
extends AbstractDialogoOKCancelar {
    private static int COLUNA_CODIGO = 0;
    private static int COLUNA_DESCRICAO = 1;
    private static int COLUNA_MNEMONICO_MATERIAL = 2;
    private static int COLUNA_GUIA = 3;
    private static int COLUNA_DATA = 4;
    private static int COLUNA_VALIDADE = 5;
    private static int COLUNA_DEVEGUIA = 6;
    private static int COLUNA_QTDEEXAMESGUIA = 7;
    private static int COLUNA_EXIGEGUIA = 8;
    private static int COLUNA_EXIGEVALIDADE = 9;
    private static int COLUNA_VALIDADE_GUIA = 10;
    private static int COLUNA_CODIGO_MATERIAL = 11;
    private boolean isConvenioRepasse = true;
    private boolean isMostrarConsiderarGuiasConferidas = false;
    private final ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Exame", "Mat.", "Guia", "Data", "Validade", "Deve", "QtdeExamesGuia", "ExigirGuia"}){

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c) != null ? this.getValueAt(0, c).getClass() : (c == COLUNA_DEVEGUIA ? Boolean.class : String.class);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == COLUNA_DEVEGUIA;
        }
    };
    private final JTable tabela = new JTable(this.modelo);
    private final JButton buttonOKGuia = ComponenteFactory.novoJButton("OK", this);
    private final TTextField textGuiaExame = new TTextField(20, "[a-zA-Z0-9./-]+");
    private final TTextField textDataGuiaExame = new TTextField(10, 4);
    private final JButton buttonBuscaDataGuiaExame = ComponenteFactory.novoJButton(this, true);
    private final JButton buttonBuscaValidadePrincipal = ComponenteFactory.novoJButton(this, true);
    private final TTextField textValidadeGuiaExame = new TTextField(10, 4);
    private final JButton buttonBuscaValidadeGuiaExame = ComponenteFactory.novoJButton(this, true);
    private final JLabel labelGuia = new JLabel("Guia:");
    private final JLabel labelGuiaPrincipal = new JLabel("Guia Principal:");
    private final TTextField textGuia = new TTextField(20, "[a-zA-Z0-9./-]+");
    private final TTextField textGuiaPrincipal = new TTextField(20, "[a-zA-Z0-9./-]+");
    private JCheckBox checkConsiderarGuiasConferidas = new JCheckBox("Considerar guias como conferidas");
    private int linhaSendoAlterada = -1;
    private final HashMap<String, Integer> contagemGuias = new HashMap();

    public static AlteraGuiasFaturamento novaInstancia(Object pai, boolean isConvenioRepasse, boolean isMostrarConsiderarGuiasConferidas) {
        if (pai instanceof Frame) {
            return new AlteraGuiasFaturamento((Frame)pai, isConvenioRepasse, isMostrarConsiderarGuiasConferidas);
        }
        if (pai instanceof Dialog) {
            return new AlteraGuiasFaturamento((Dialog)pai, isConvenioRepasse, isMostrarConsiderarGuiasConferidas);
        }
        return null;
    }

    public AlteraGuiasFaturamento(Frame pai, boolean isConvenioRepasse, boolean isMostrarConsiderarGuiasConferidas) {
        super(pai, "Altera\u00e7\u00e3o de Guias/Datas");
        this.isConvenioRepasse = isConvenioRepasse;
        this.isMostrarConsiderarGuiasConferidas = isMostrarConsiderarGuiasConferidas;
        this.montaTela();
    }

    public AlteraGuiasFaturamento(Dialog pai, boolean isConvenioRepasse, boolean isMostrarConsiderarGuiasConferidas) {
        super(pai, "Altera\u00e7\u00e3o de Guias/Datas");
        this.isConvenioRepasse = isConvenioRepasse;
        this.isMostrarConsiderarGuiasConferidas = isMostrarConsiderarGuiasConferidas;
        this.montaTela();
    }

    private void montaTela() {
        this.setModal(true);
        this.tabela.removeColumn(this.tabela.getColumn("QtdeExamesGuia"));
        this.tabela.removeColumn(this.tabela.getColumn("ExigirGuia"));
        this.modelo.setColumnSize(new int[]{60, 0, 50, 100, 80, 80, 40, 0, 0}, this.tabela);
        this.tabela.setDefaultRenderer(Object.class, new DefaultTableCellRenderer());
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 1, 1, 1);
        panelCentro.add((Component)this.labelGuia, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.textGuia.setMinimumSize(new Dimension(200, 20));
        this.textGuia.setPreferredSize(new Dimension(200, 20));
        panelCentro.add((Component)this.textGuia, c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(3, 1, 1, 1);
        panelCentro.add((Component)this.labelGuiaPrincipal, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.textGuiaPrincipal.setMinimumSize(new Dimension(200, 20));
        this.textGuiaPrincipal.setPreferredSize(new Dimension(200, 20));
        panelCentro.add((Component)this.textGuiaPrincipal, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel p = ComponenteFactory.novoJPanelBorderLayout("Exames", null);
        p.setLayout(new GridBagLayout());
        p.setPreferredSize(new Dimension(100, 20));
        panelCentro.add((Component)p, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        p.add((Component)new JLabel("Guia"), c);
        ++c.gridx;
        p.add((Component)new JLabel("Data"), c);
        c.gridx += 2;
        p.add((Component)new JLabel("Validade"), c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.fill = 2;
        this.textGuiaExame.setPreferredSize(new Dimension(100, 20));
        this.textGuiaExame.setMinimumSize(new Dimension(100, 20));
        p.add((Component)this.textGuiaExame, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        c.gridwidth = 1;
        this.textDataGuiaExame.setPreferredSize(new Dimension(80, 20));
        this.textDataGuiaExame.setMinimumSize(new Dimension(80, 20));
        p.add((Component)this.textDataGuiaExame, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.buttonBuscaDataGuiaExame.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaDataGuiaExame.setMinimumSize(new Dimension(20, 20));
        p.add((Component)this.buttonBuscaDataGuiaExame, c);
        ++c.gridx;
        this.textValidadeGuiaExame.setPreferredSize(new Dimension(80, 20));
        this.textValidadeGuiaExame.setMinimumSize(new Dimension(80, 20));
        p.add((Component)this.textValidadeGuiaExame, c);
        ++c.gridx;
        this.buttonBuscaValidadeGuiaExame.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaValidadeGuiaExame.setMinimumSize(new Dimension(20, 20));
        p.add((Component)this.buttonBuscaValidadeGuiaExame, c);
        ++c.gridx;
        this.buttonOKGuia.setPreferredSize(new Dimension(40, 20));
        this.buttonOKGuia.setMinimumSize(new Dimension(40, 20));
        p.add((Component)this.buttonOKGuia, c);
        JScrollPane scroll = new JScrollPane(this.tabela);
        c.gridx = 0;
        c.gridwidth = 6;
        ++c.gridy;
        c.weighty = 1.0;
        c.fill = 1;
        p.add((Component)scroll, c);
        if (this.isMostrarConsiderarGuiasConferidas) {
            this.getPanelBotoesEsquerda().add(this.checkConsiderarGuiasConferidas);
        }
        this.textDataGuiaExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(AlteraGuiasFaturamento.this.textDataGuiaExame, AlteraGuiasFaturamento.this.buttonBuscaDataGuiaExame, (JPanel)AlteraGuiasFaturamento.this.buttonBuscaDataGuiaExame.getParent(), true);
                }
            }
        });
        this.textValidadeGuiaExame.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(AlteraGuiasFaturamento.this.textValidadeGuiaExame, AlteraGuiasFaturamento.this.buttonBuscaValidadeGuiaExame, (JPanel)AlteraGuiasFaturamento.this.buttonBuscaValidadeGuiaExame.getParent(), true);
                }
            }
        });
        this.tabela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32 && AlteraGuiasFaturamento.this.tabela.getSelectedRow() > -1) {
                    AlteraGuiasFaturamento.this.editarLinha(AlteraGuiasFaturamento.this.tabela.getSelectedRow());
                }
            }
        });
        this.tabela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (AlteraGuiasFaturamento.this.tabela.getSelectedRow() > -1 && e.getClickCount() == 2) {
                    AlteraGuiasFaturamento.this.editarLinha(AlteraGuiasFaturamento.this.tabela.getSelectedRow());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (AlteraGuiasFaturamento.this.modelo.getRowCount() > 0) {
                    AlteraGuiasFaturamento.this.tabela.setRowSelectionInterval(0, 0);
                }
                AlteraGuiasFaturamento.this.tabela.grabFocus();
            }
        });
        if (this.isConvenioRepasse) {
            p.setVisible(false);
            this.setSize(new Dimension(310, 130));
        } else {
            this.setSize(new Dimension(650, 400));
        }
        ScreenUtil.requisitarFoco(this.textGuia);
        ScreenUtil.requisitarFoco(this.textGuiaPrincipal);
        this.setLocationRelativeTo(this.getParent());
    }

    public String getGuiaRequisicao() {
        return this.textGuia.getText();
    }

    public String getGuiaPrincipalRequisicao() {
        return this.textGuiaPrincipal.getText();
    }

    public boolean getConsiderarGuiasConferidas() {
        return this.checkConsiderarGuiasConferidas.isSelected();
    }

    public void setGuiasRequisicao(String guia, String guiaPrincipal, boolean isGuiaConferida) {
        this.textGuia.setText(guia);
        this.textGuiaPrincipal.setText(guiaPrincipal);
        this.checkConsiderarGuiasConferidas.setEnabled(!isGuiaConferida);
    }

    @Override
    public boolean acaoOk() {
        boolean guiaVazia = false;
        boolean exigeGuias = (Boolean)this.modelo.getValueAt(0, COLUNA_EXIGEGUIA);
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (this.modelo.getValueAt(i, COLUNA_GUIA) != null && !Funcoes.textoVazio(this.modelo.getValueAt(i, COLUNA_GUIA).toString()) || ((Boolean)this.modelo.getValueAt(i, COLUNA_DEVEGUIA)).booleanValue()) continue;
            guiaVazia = true;
            break;
        }
        if (Funcoes.textoVazio(this.textGuia)) {
            guiaVazia = true;
        }
        if (guiaVazia && exigeGuias) {
            int resp = Funcoes.mensagem(this, "O conv\u00eanio exige guias.\nDeseja realmente deixar guias n\u00e3o informadas?", 4, true);
            return resp == 0;
        }
        boolean validadeVazia = false;
        boolean exigeValidade = (Boolean)this.modelo.getValueAt(0, COLUNA_EXIGEVALIDADE);
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (this.modelo.getValueAt(i, COLUNA_VALIDADE) != null && !Funcoes.textoVazio(this.modelo.getValueAt(i, COLUNA_VALIDADE).toString())) continue;
            validadeVazia = true;
            break;
        }
        if (validadeVazia && exigeValidade) {
            int resp = Funcoes.mensagem(this, "O conv\u00eanio exige validade das guias.\nDeseja realmente deixar validades n\u00e3o informadas?", 4, true);
            return resp == 0;
        }
        return true;
    }

    private void editarLinha(int linha) {
        if (linha > -1 && this.modelo.getRowCount() >= linha) {
            if (linha > 0) {
                if (this.modelo.getValueAt(linha - 1, COLUNA_GUIA) != null && !Funcoes.textoVazio(this.modelo.getValueAt(linha - 1, COLUNA_GUIA).toString()) && (this.modelo.getValueAt(linha, COLUNA_GUIA) == null || Funcoes.textoVazio(this.modelo.getValueAt(linha, COLUNA_GUIA).toString()))) {
                    this.textGuiaExame.setText(this.modelo.getValueAt(linha, COLUNA_GUIA).toString());
                } else if (this.modelo.getValueAt(linha, COLUNA_GUIA) != null && !Funcoes.textoVazio(this.modelo.getValueAt(linha, COLUNA_GUIA).toString())) {
                    this.textGuiaExame.setText(this.modelo.getValueAt(linha, COLUNA_GUIA).toString());
                }
                if (this.modelo.getValueAt(linha, COLUNA_DATA) != null && Funcoes.verificaData(this.modelo.getValueAt(linha, COLUNA_DATA).toString())) {
                    this.textDataGuiaExame.setText(this.modelo.getValueAt(linha, COLUNA_DATA).toString());
                }
                if (this.modelo.getValueAt(linha, COLUNA_VALIDADE) != null && Funcoes.verificaData(this.modelo.getValueAt(linha, COLUNA_VALIDADE).toString())) {
                    this.textValidadeGuiaExame.setText(this.modelo.getValueAt(linha, COLUNA_VALIDADE).toString());
                } else {
                    this.textValidadeGuiaExame.setText("");
                }
            } else {
                this.textGuiaExame.setText(this.modelo.getValueAt(linha, COLUNA_GUIA) == null ? "" : this.modelo.getValueAt(linha, COLUNA_GUIA).toString());
                if (this.modelo.getValueAt(linha, COLUNA_DATA) != null) {
                    this.textDataGuiaExame.setText(this.modelo.getValueAt(linha, COLUNA_DATA).toString());
                }
                if (this.modelo.getValueAt(linha, COLUNA_VALIDADE) != null) {
                    this.textValidadeGuiaExame.setText(this.modelo.getValueAt(linha, COLUNA_VALIDADE).toString());
                }
            }
            this.linhaSendoAlterada = linha;
            this.textGuiaExame.grabFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaDataGuiaExame) {
            Funcoes.mostraData(this.textDataGuiaExame, this.buttonBuscaDataGuiaExame, (JPanel)this.buttonBuscaDataGuiaExame.getParent(), true);
        } else if (e.getSource() == this.buttonBuscaValidadeGuiaExame) {
            Funcoes.mostraData(this.textValidadeGuiaExame, this.buttonBuscaValidadeGuiaExame, (JPanel)this.buttonBuscaValidadeGuiaExame.getParent(), true);
        } else if (e.getSource() == this.buttonOKGuia) {
            this.adicionarGuia();
        } else {
            super.actionPerformed(e);
        }
    }

    private void adicionarGuia() {
        HashMap<String, Integer> listaGuias = new HashMap<String, Integer>();
        int qtdeGuias = 0;
        int qtdeGuiaInformada = 0;
        if (this.linhaSendoAlterada > -1) {
            int qtdeMaxGuias = (Integer)this.modelo.getValueAt(this.linhaSendoAlterada, COLUNA_QTDEEXAMESGUIA);
            boolean exigeGuias = (Boolean)this.modelo.getValueAt(this.linhaSendoAlterada, COLUNA_EXIGEGUIA);
            int resp = 1;
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                if (i == this.linhaSendoAlterada) {
                    listaGuias.put(this.textGuiaExame.getText(), listaGuias.get(this.textGuiaExame.getText()) == null ? 1 : (Integer)listaGuias.get(this.textGuiaExame.getText()) + 1);
                    continue;
                }
                listaGuias.put((String)this.modelo.getValueAt(i, COLUNA_GUIA), (listaGuias.get(this.modelo.getValueAt(i, COLUNA_GUIA)) == null ? 0 : (Integer)listaGuias.get(this.modelo.getValueAt(i, COLUNA_GUIA))) + 1);
            }
            qtdeGuiaInformada = (Integer)listaGuias.get(this.textGuiaExame.getText());
            if (qtdeMaxGuias > 0 && exigeGuias) {
                Iterator it = listaGuias.entrySet().iterator();
                StringBuilder erros = new StringBuilder();
                while (it.hasNext()) {
                    Map.Entry aux = it.next();
                    if ((Integer)aux.getValue() > qtdeMaxGuias && ((String)aux.getKey()).equalsIgnoreCase(this.textGuiaExame.getText()) && !Funcoes.textoVazio((String)aux.getKey())) {
                        Funcoes.mensagem(this, "A guia informada excede o n\u00famero de exames por guia.", 2);
                        this.textGuiaExame.selectAll();
                        this.textGuiaExame.requestFocus();
                        return;
                    }
                    if ((Integer)aux.getValue() <= qtdeMaxGuias || ((String)aux.getKey()).equalsIgnoreCase(this.textGuiaExame.getText())) continue;
                    if (erros.length() > 0) {
                        erros.append("\n");
                    }
                    erros.append("A guia \"").append((String)aux.getKey()).append("\" excede o n\u00famero de exames por guia.");
                }
                if (erros.length() > 0) {
                    Funcoes.mensagem(this, erros.toString(), 2);
                }
                int n = qtdeGuias = this.linhaSendoAlterada + 1 + qtdeMaxGuias > this.modelo.getRowCount() ? this.modelo.getRowCount() - this.linhaSendoAlterada - 1 : qtdeMaxGuias - qtdeGuiaInformada;
                if (qtdeGuias > 0) {
                    resp = Funcoes.mensagem(this, "Deseja replicar as informa\u00e7\u00f5es de guia, data e validade no(s) pr\u00f3ximo(s) " + qtdeGuias + " exame(s)?", 4, true);
                }
                for (int i = 1; i <= qtdeGuias && resp == 0; ++i) {
                    this.modelo.setValueAt(this.textGuiaExame.getText(), this.linhaSendoAlterada + i, COLUNA_GUIA);
                    this.modelo.setValueAt(this.textDataGuiaExame.getText(), this.linhaSendoAlterada + i, COLUNA_DATA);
                    this.modelo.setValueAt(this.textValidadeGuiaExame.getText(), this.linhaSendoAlterada + i, COLUNA_VALIDADE);
                }
            } else if (qtdeMaxGuias == 0) {
                Integer qtdExamePorGuia = (Integer)listaGuias.get(this.textGuiaExame.getText());
                String dataLinhaEditada = (String)this.modelo.getValueAt(this.linhaSendoAlterada, 4);
                if (qtdExamePorGuia > 1 && !Funcoes.textoVazio(this.textDataGuiaExame.getText()) && !dataLinhaEditada.equals(this.textDataGuiaExame.getText())) {
                    boolean ok;
                    Set<String> examesGuia = this.getObterExameGuia();
                    boolean bl = ok = Funcoes.mensagem(this, "Deseja alterar a data e validade para os exames que possuem a mesma guia?\nExames que ser\u00e3o alterados:\n" + Arrays.toString(examesGuia.toArray()), 4) == 0;
                    if (ok) {
                        for (String exa : examesGuia) {
                            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                                String exame = (String)this.modelo.getValueAt(i, 0);
                                if (!exame.equalsIgnoreCase(exa)) continue;
                                this.modelo.setValueAt(this.textDataGuiaExame.getText(), i, COLUNA_DATA);
                                this.modelo.setValueAt(this.textValidadeGuiaExame.getText(), i, COLUNA_VALIDADE);
                            }
                        }
                    }
                }
            }
            if (this.linhaSendoAlterada == -1) {
                return;
            }
            this.modelo.setValueAt(this.textGuiaExame.getText(), this.linhaSendoAlterada, COLUNA_GUIA);
            this.modelo.setValueAt(this.textDataGuiaExame.getText(), this.linhaSendoAlterada, COLUNA_DATA);
            this.modelo.setValueAt(this.textValidadeGuiaExame.getText(), this.linhaSendoAlterada, COLUNA_VALIDADE);
            this.linhaSendoAlterada = -1;
            this.textGuiaExame.clear();
            this.textValidadeGuiaExame.clear();
            this.textDataGuiaExame.clear();
            ScreenUtil.requisitarFoco(this.tabela);
        }
    }

    private Set<String> getObterExameGuia() {
        HashSet<String> exames = new HashSet<String>();
        if (this.linhaSendoAlterada > -1) {
            exames.add((String)this.modelo.getValueAt(this.linhaSendoAlterada, 0));
        }
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            String guia = (String)this.modelo.getValueAt(i, 3);
            if (!guia.equalsIgnoreCase(this.textGuiaExame.getText())) continue;
            exames.add((String)this.modelo.getValueAt(i, 0));
        }
        return exames;
    }

    public void adicionarExame(Integer codigoFilial, Integer codigoConvenio, DadosExameFaturamento exame) {
        if (exame == null) {
            return;
        }
        if (!this.achaExame(exame.getCodigoExame(), exame.getCodigoMaterial())) {
            int qtdeExames = 0;
            boolean exigeGuia = false;
            boolean exigeValidade = false;
            StringBuilder buf = new StringBuilder();
            buf.append(" select con_examesporguia ");
            buf.append("       ,con_codigoguia ");
            buf.append("       ,con_validadeguia ");
            buf.append("   from convenios ");
            buf.append("  where fil_codigo = ").append(codigoFilial);
            buf.append("    and con_codigo = ").append(codigoConvenio);
            try {
                ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs.next()) {
                    qtdeExames = rs.getInt("con_examesporguia");
                    exigeGuia = rs.getBoolean("con_codigoguia");
                    exigeValidade = rs.getBoolean("con_validadeguia");
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.modelo.addLine(new Object[]{exame.getCodigoExame(), exame.getNomeExame(), exame.getAbreviaturaMaterial(), exame.getCodigoGuia(), exame.getDataGuia() == null ? "" : Funcoes.formataData(exame.getDataGuia()), exame.getValidadeGuia() == null ? "" : Funcoes.formataData(exame.getValidadeGuia()), new Boolean(exame.getDeveGuia()), qtdeExames, exigeGuia, exigeValidade, exame.getValidadeGuia() == null ? "" : Funcoes.formataData(exame.getValidadeGuia()), exame.getCodigoMaterial()});
        }
    }

    public void adicionarExame(String codigoExame, String nomeExame, String codigoGuia, Date dataGuia, Boolean deveGuia, Integer qtdeExamesGuia, Boolean exigeGuia, Boolean exigeValidade, Date validadeGuia, String mnemonicoMaterial, Integer codigoMaterial) {
        if (!this.achaExame(codigoExame, codigoMaterial)) {
            this.modelo.addLine(new Object[]{codigoExame, nomeExame, mnemonicoMaterial, codigoGuia, dataGuia == null ? "" : Funcoes.formataData(dataGuia), validadeGuia == null ? "" : Funcoes.formataData(validadeGuia), deveGuia, qtdeExamesGuia, exigeGuia, exigeValidade, validadeGuia == null ? "" : Funcoes.formataData(validadeGuia), codigoMaterial});
        }
    }

    private boolean achaExame(String codigo, Integer codigoMaterial) {
        if (codigo != null && codigoMaterial != null) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, COLUNA_CODIGO).toString().equalsIgnoreCase(codigo) || !this.modelo.getValueAt(i, COLUNA_CODIGO_MATERIAL).toString().equalsIgnoreCase(codigoMaterial.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList<DadosExameFaturamento> getExames() {
        ArrayList<DadosExameFaturamento> exames = new ArrayList<DadosExameFaturamento>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            DadosExameFaturamento exame = new DadosExameFaturamento(this.modelo.getValueAt(i, COLUNA_CODIGO).toString());
            exame.setCodigoMaterial(Integer.parseInt(this.modelo.getValueAt(i, COLUNA_CODIGO_MATERIAL).toString()));
            exame.setCodigoGuia(this.modelo.getValueAt(i, COLUNA_GUIA) == null ? null : this.modelo.getValueAt(i, COLUNA_GUIA).toString());
            exame.setDeveGuia(this.modelo.getValueAt(i, COLUNA_DEVEGUIA) instanceof Boolean ? (Boolean)this.modelo.getValueAt(i, COLUNA_DEVEGUIA) : false);
            exame.setDataGuia(this.modelo.getValueAt(i, COLUNA_DATA) != null && Funcoes.verificaData(this.modelo.getValueAt(i, COLUNA_DATA).toString()) ? Funcoes.stringToDate(this.modelo.getValueAt(i, COLUNA_DATA).toString()) : null);
            exame.setValidadeGuia(this.modelo.getValueAt(i, COLUNA_VALIDADE) != null && Funcoes.verificaData(this.modelo.getValueAt(i, COLUNA_VALIDADE).toString()) ? Funcoes.stringToDate(this.modelo.getValueAt(i, COLUNA_VALIDADE).toString()) : null);
            exames.add(exame);
        }
        return exames;
    }
}

