/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.contas;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class HistoricoPadrao
extends FrmCadPadrao {
    private JLabel jLabel1;
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private JLabel jLabel2;
    private JCheckBox checkPermiteDescrever = new JCheckBox("Permite descrever");
    private String retornoParaPesquisa = "";

    public HistoricoPadrao() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "HistoricoPadrao");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("HistoricoPadrao");
        this.jLabel1 = new JLabel();
        this.txtCodigo = new TTextField(5, 1);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(80);
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2 = new JLabel();
        this.setLabelDescricao("Cadastro de hist\u00f3ricos padr\u00f5es para lan\u00e7amentos de contas");
        this.setLabelFormulario("Cadastro de hist\u00f3ricos padr\u00f5es");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/hist_padrao.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(72, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(72, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.checkPermiteDescrever.setBounds(new Rectangle(72, 49, 200, 20));
        this.checkPermiteDescrever.setName("checkPermiteDescrever");
        this.controlaCampos();
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.checkPermiteDescrever, null);
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (HistoricoPadrao.this.txtCodigo.getText().trim().length() > 0) {
                    Statement st = HistoricoPadrao.this.getStatement();
                    try {
                        if (st != null) {
                            StringBuilder bui = new StringBuilder("select hpa_codigo, hpa_descricao from historicopadrao where fil_codigo = ");
                            bui.append(Variaveis.filialPadrao);
                            bui.append(" and hpa_codigo = ");
                            bui.append(HistoricoPadrao.this.txtCodigo.getTextDB());
                            ResultSet rs = Conexao.executeQuery(st, bui.toString());
                            if (rs != null && rs.next()) {
                                HistoricoPadrao.this.txtDescricao.setText(rs.getString("hpa_descricao"));
                                if (HistoricoPadrao.this.getStatus() == 2) {
                                    HistoricoPadrao.this.setStatus(3);
                                }
                                HistoricoPadrao.this.txtCodigo.setEnabled(false);
                            } else if (HistoricoPadrao.this.getStatus() == 3) {
                                Funcoes.mensagem(HistoricoPadrao.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                HistoricoPadrao.this.setStatus(1);
                                HistoricoPadrao.this.controlaCampos();
                            }
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(HistoricoPadrao.this, sqlex.getMessage(), sqlex.getStackTrace(), "HistoricoPadrao");
                    }
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(HistoricoPadrao.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600100301"));
        this.setModuloEdita(Long.parseLong("0600100302"));
        this.setModuloApaga(Long.parseLong("0600100303"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.historicoPadrao(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (resultado != null) {
            this.txtCodigo.setText(resultado.get("hpa_codigo").toString());
            this.txtDescricao.setText(resultado.get("hpa_descricao").toString());
            String auxPermiteDescrever = resultado.get("hpa_permitedescrever").toString();
            if (auxPermiteDescrever.equalsIgnoreCase("sim")) {
                this.checkPermiteDescrever.setSelected(true);
            } else {
                this.checkPermiteDescrever.setSelected(false);
            }
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("historicopadrao", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("hpa_codigo", 0, false, true, this.txtCodigo.getTextDB());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaHistoricoPadrao());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "HistoricoPadrao");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtDescricao.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                String codigo = this.txtCodigo.getText();
                if (this.getStatus() == 2) {
                    codigo = DBUtil.getSequencia(statement, "historicopadrao", true);
                }
                SalvaDados salvar = new SalvaDados("historicopadrao", this.getStatus() == 2 ? 0 : 2);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("hpa_codigo", 0, false, true, codigo);
                salvar.adicionaCampo("hpa_descricao", 0, true, false, this.txtDescricao.getTextDB());
                salvar.adicionaCampo("hpa_permitedescrever", 4, false, false, this.checkPermiteDescrever.isSelected());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaHistoricoPadrao(), "historicopadrao", Integer.parseInt(codigo));
                this.retornoParaPesquisa = codigo;
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "HistoricoPadrao");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkPermiteDescrever.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.setText("");
        this.txtDescricao.setText("");
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtCodigo.getText()) && this.getStatus() == 3) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
            this.txtCodigo.grabFocus();
            return false;
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        return true;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600100300");
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "hpa_codigo";
    }
}

