/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.contas;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.financeiro.ContaCorrenteBean;
import jalis.model.dao.cadastro.financeiro.ContaCorrenteDao;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.HistoricoPadraoVO;
import jalis.model.vo.cadastro.financeiro.AgenciaVO;
import jalis.model.vo.cadastro.financeiro.BancoVO;
import jalis.model.vo.cadastro.financeiro.CentroCustoVO;
import jalis.model.vo.cadastro.financeiro.PlanoContaVO;
import jalis.service.cadastro.financeiro.CentroCustoService;
import jalis.service.cadastro.financeiro.ContaCorrenteService;
import jalis.service.cadastro.financeiro.PlanoContaService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class Conta
extends FrmCadPadrao
implements BuscaBeanPreenchido {
    private JLabel labelCodigo = new JLabel("C\u00f3digo:");
    private TTextField txtCodigo = new TTextField(5, 1);
    private TTextField txtConta = new TTextField(20);
    private TTextField txtTitular = new TTextField(100);
    private JLabel labelTipo = new JLabel("Tipo:");
    private JLabel labelAgencia = new JLabel("Banco/Ag\u00eancia:");
    private JComboBox comboTipo = new JComboBox<String>(new String[]{"Conta corrente", "Caixa"});
    private TTextField txtCodigoAgencia = new TTextField(10);
    private TTextField txtCodigoBanco = new TTextField(5, 1);
    private TTextField txtDescricaoAgencia = new TTextField();
    private JButton buttonBuscaAgencia = new JButton();
    private TTextField txtCodigoHistorico = new TTextField(5, 1);
    private JButton buttonBuscaHistorico = new JButton();
    private TTextField txtDescricaoHistorico = new TTextField();
    private JLabel labelHistorico = new JLabel("Hist\u00f3rico:");
    private JCheckBox checkInativa = new JCheckBox("Conta inativa");
    private JPanel panelSaldo = new JPanel(null);
    private JLabel labelSaldo = new JLabel("Saldo:");
    private JLabel labelDataSaldo = new JLabel("Data:");
    private JLabel labelConta = new JLabel("Conta:");
    private JLabel labelTitular = new JLabel("Titular:");
    private TTextField txtSaldo = new TTextField(12, 2, 2);
    private TTextField txtDataSaldo = new TTextField(10, 4);
    private JButton buttonBuscaDataSaldo = new JButton();
    private JLabel labelCentroDebito = new JLabel("D\u00e9bito:");
    private JLabel labelCentroCredito = new JLabel("Cr\u00e9dito:");
    private JLabel labelPlanoDespesa = new JLabel("Despesa:");
    private JLabel labelPlanoReceita = new JLabel("Receita:");
    private TTextField txtCentroDebito = new TTextField(5, 1);
    private JLabel labelDescricaoCentroDebito = new JLabel("");
    private TTextField txtCentroCredito = new TTextField(5, 1);
    private JLabel labelDescricaoCentroCredito = new JLabel("");
    private TTextField txtPlanoDespesa = new TTextField(5, 1);
    private JLabel labelDescricaoPlanoDespesa = new JLabel("");
    private TTextField txtPlanoReceita = new TTextField(5, 1);
    private JLabel labelDescricaoPlanoReceita = new JLabel("");
    private JButton buttonBuscaCentroDebito = new JButton();
    private JButton buttonBuscaCentroCredito = new JButton();
    private JButton buttonBuscaPlanoDespesa = new JButton();
    private JButton buttonBuscaPlanoReceita = new JButton();
    private JPanel panelApropriacoes = new JPanel();
    private final int TIPO_NAO_CONFIGURADO = 0;
    private final int TIPO_CONTA_CORRENTE = 1;
    private final int TIPO_CONTA_CAIXA = 2;
    private int tipoConta = 0;
    private String retornoParaPesquisa = "";

    public Conta() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Conta");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("Conta");
        this.setLabelDescricao("Cadastro de contas correntes e contas caixa");
        this.setLabelFormulario("Cadastro de contas");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/contas.jpg"));
        ScreenUtil.setBorda(new Component[]{this.labelDescricaoCentroCredito, this.labelDescricaoCentroDebito, this.labelDescricaoPlanoReceita, this.labelDescricaoPlanoDespesa}, new TitledBorder(""));
        this.panelSaldo.setBorder(new TitledBorder("Saldo inicial"));
        this.panelSaldo.setLayout(new GridBagLayout());
        this.panelApropriacoes.setBorder(new TitledBorder("Apropria\u00e7\u00f5es da Conta Caixa"));
        this.panelApropriacoes.setLayout(new GridBagLayout());
        this.panelApropriacoes.setVisible(false);
        Funcoes.imagemPesquisa(this.buttonBuscaAgencia);
        this.buttonBuscaAgencia.setName("buttonBuscaAgencia");
        Funcoes.imagemPesquisa(this.buttonBuscaHistorico);
        this.buttonBuscaHistorico.setName("buttonBuscaHistorico");
        Funcoes.imagemPesquisa(this.buttonBuscaDataSaldo);
        this.buttonBuscaDataSaldo.setName("buttonBuscaDataSaldo");
        Funcoes.imagemPesquisa(this.buttonBuscaCentroCredito);
        this.buttonBuscaCentroCredito.setName("buttonBuscaCentroCredito");
        Funcoes.imagemPesquisa(this.buttonBuscaCentroDebito);
        this.buttonBuscaCentroDebito.setName("buttonBuscaCentroDebito");
        Funcoes.imagemPesquisa(this.buttonBuscaPlanoReceita);
        this.buttonBuscaPlanoReceita.setName("buttonBuscaPlanoReceita");
        Funcoes.imagemPesquisa(this.buttonBuscaPlanoDespesa);
        this.buttonBuscaPlanoDespesa.setName("buttonBuscaPlanoDespesa");
        Dimension d = new Dimension(150, 20);
        this.comboTipo.setPreferredSize(d);
        this.comboTipo.setName("comboTipo");
        this.comboTipo.setMinimumSize(d);
        this.txtConta.setPreferredSize(d);
        this.txtConta.setName("txtConta");
        this.txtConta.setMinimumSize(d);
        d = new Dimension(350, 20);
        this.txtDescricaoAgencia.setPreferredSize(d);
        this.txtDescricaoAgencia.setName("txtDescricaoAgencia");
        this.txtDescricaoAgencia.setMinimumSize(d);
        this.txtDescricaoAgencia.setFocusable(false);
        this.txtDescricaoAgencia.setEditable(false);
        d = new Dimension(75, 20);
        this.txtCodigo.setPreferredSize(d);
        this.txtCodigo.setName("txtCodigo");
        this.txtCodigo.setMinimumSize(d);
        this.txtCodigoAgencia.setPreferredSize(d);
        this.txtCodigoAgencia.setName("txtCodigoAgencia");
        this.txtCodigoAgencia.setMinimumSize(d);
        this.txtCodigoBanco.setPreferredSize(d);
        this.txtCodigoBanco.setName("txtCodigoBanco");
        this.txtCodigoBanco.setMinimumSize(d);
        this.txtCodigoHistorico.setPreferredSize(d);
        this.txtCodigoHistorico.setName("txtCodigoHistorico");
        this.txtCodigoHistorico.setMinimumSize(d);
        d = new Dimension(50, 20);
        this.txtCentroCredito.setPreferredSize(d);
        this.txtCentroCredito.setName("txtCentroCredito");
        this.txtCentroCredito.setMinimumSize(d);
        this.txtCentroDebito.setPreferredSize(d);
        this.txtCentroDebito.setName("txtCentroDebito");
        this.txtCentroDebito.setMinimumSize(d);
        this.txtPlanoReceita.setPreferredSize(d);
        this.txtPlanoReceita.setName("txtPlanoReceita");
        this.txtPlanoReceita.setMinimumSize(d);
        this.txtPlanoDespesa.setPreferredSize(d);
        this.txtPlanoDespesa.setName("txtPlanoDespesa");
        this.txtPlanoDespesa.setMinimumSize(d);
        d = new Dimension(85, 20);
        this.txtDataSaldo.setPreferredSize(d);
        this.txtDataSaldo.setName("txtDataSaldo");
        this.txtDataSaldo.setMinimumSize(d);
        this.txtSaldo.setPreferredSize(d);
        this.txtSaldo.setName("txtSaldo");
        this.txtSaldo.setMinimumSize(d);
        d = new Dimension(520, 20);
        this.txtTitular.setPreferredSize(d);
        this.txtTitular.setName("txtTitular");
        this.txtTitular.setMinimumSize(d);
        d = new Dimension(20, 20);
        this.buttonBuscaAgencia.setPreferredSize(d);
        this.buttonBuscaAgencia.setName("buttonBuscaAgencia");
        this.buttonBuscaAgencia.setMinimumSize(d);
        this.buttonBuscaAgencia.setFocusable(false);
        this.buttonBuscaHistorico.setPreferredSize(d);
        this.buttonBuscaHistorico.setName("buttonBuscaHistorico");
        this.buttonBuscaHistorico.setMinimumSize(d);
        this.buttonBuscaHistorico.setFocusable(false);
        this.buttonBuscaDataSaldo.setPreferredSize(d);
        this.buttonBuscaDataSaldo.setName("buttonBuscaDataSaldo");
        this.buttonBuscaDataSaldo.setMinimumSize(d);
        this.buttonBuscaDataSaldo.setFocusable(false);
        this.buttonBuscaCentroCredito.setPreferredSize(d);
        this.buttonBuscaCentroCredito.setName("buttonBuscaCentroCredito");
        this.buttonBuscaCentroCredito.setMinimumSize(d);
        this.buttonBuscaCentroCredito.setFocusable(false);
        this.buttonBuscaCentroDebito.setPreferredSize(d);
        this.buttonBuscaCentroDebito.setName("buttonBuscaCentroDebito");
        this.buttonBuscaCentroDebito.setMinimumSize(d);
        this.buttonBuscaCentroDebito.setFocusable(false);
        this.buttonBuscaPlanoReceita.setPreferredSize(d);
        this.buttonBuscaPlanoReceita.setName("buttonBuscaPlanoReceita");
        this.buttonBuscaPlanoReceita.setMinimumSize(d);
        this.buttonBuscaPlanoReceita.setFocusable(false);
        this.buttonBuscaPlanoDespesa.setPreferredSize(d);
        this.buttonBuscaPlanoDespesa.setName("buttonBuscaPlanoDespesa");
        this.buttonBuscaPlanoDespesa.setMinimumSize(d);
        this.buttonBuscaPlanoDespesa.setFocusable(false);
        this.labelDescricaoCentroCredito.setPreferredSize(d);
        this.labelDescricaoCentroCredito.setMinimumSize(d);
        this.labelDescricaoCentroDebito.setPreferredSize(d);
        this.labelDescricaoCentroDebito.setMinimumSize(d);
        this.labelDescricaoPlanoReceita.setPreferredSize(d);
        this.labelDescricaoPlanoReceita.setMinimumSize(d);
        this.labelDescricaoPlanoDespesa.setPreferredSize(d);
        this.labelDescricaoPlanoDespesa.setMinimumSize(d);
        d = new Dimension(425, 20);
        this.txtDescricaoHistorico.setPreferredSize(d);
        this.txtDescricaoHistorico.setName("txtDescricaoHistorico");
        this.txtDescricaoHistorico.setMinimumSize(d);
        this.txtDescricaoHistorico.setFocusable(false);
        this.txtDescricaoHistorico.setEditable(false);
        this.painelCentral.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.painelCentral.add((Component)this.labelCodigo, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.txtCodigo, c);
        ++c.gridy;
        c.gridx = 0;
        this.painelCentral.add((Component)this.labelTipo, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.comboTipo, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.labelConta, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.txtConta, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.labelAgencia, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.txtCodigoBanco, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.painelCentral.add((Component)this.txtCodigoAgencia, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.buttonBuscaAgencia, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.txtDescricaoAgencia, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.labelTitular, c);
        ++c.gridx;
        c.gridwidth = 5;
        this.painelCentral.add((Component)this.txtTitular, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.painelCentral.add((Component)this.labelHistorico, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.txtCodigoHistorico, c);
        ++c.gridx;
        this.painelCentral.add((Component)this.buttonBuscaHistorico, c);
        ++c.gridx;
        c.gridwidth = 3;
        this.painelCentral.add((Component)this.txtDescricaoHistorico, c);
        ++c.gridy;
        c.gridx = 1;
        this.painelCentral.add((Component)this.checkInativa, c);
        this.checkInativa.setName("checkInativa");
        ++c.gridy;
        c.gridx = 0;
        JPanel aux1 = new JPanel();
        d = new Dimension(10, 10);
        aux1.setPreferredSize(d);
        aux1.setMinimumSize(d);
        this.painelCentral.add((Component)aux1, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 5;
        this.painelCentral.add((Component)this.panelSaldo, c);
        ++c.gridy;
        c.gridx = 0;
        JPanel aux3 = new JPanel();
        d = new Dimension(10, 10);
        aux3.setPreferredSize(d);
        aux3.setMinimumSize(d);
        this.painelCentral.add((Component)aux3, c);
        ++c.gridy;
        c.gridx = 1;
        c.gridwidth = 6;
        c.fill = 2;
        this.painelCentral.add((Component)this.panelApropriacoes, c);
        ++c.gridy;
        c.gridx = 7;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.painelCentral.add((Component)new JPanel(), c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelSaldo.add((Component)this.labelSaldo, c);
        ++c.gridx;
        this.panelSaldo.add((Component)this.txtSaldo, c);
        ++c.gridx;
        JPanel aux2 = new JPanel();
        d = new Dimension(20, 20);
        aux2.setPreferredSize(d);
        aux2.setMinimumSize(d);
        this.panelSaldo.add((Component)aux2, c);
        ++c.gridx;
        this.panelSaldo.add((Component)this.labelDataSaldo, c);
        ++c.gridx;
        this.panelSaldo.add((Component)this.txtDataSaldo, c);
        ++c.gridx;
        this.panelSaldo.add((Component)this.buttonBuscaDataSaldo, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.panelSaldo.add((Component)new JLabel(), c);
        c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 0, 1, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        this.panelApropriacoes.add((Component)new JLabel("Centro de Custo"), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.panelApropriacoes.add((Component)this.labelCentroCredito, c);
        ++c.gridx;
        this.panelApropriacoes.add((Component)this.txtCentroCredito, c);
        ++c.gridx;
        this.panelApropriacoes.add((Component)this.buttonBuscaCentroCredito, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelApropriacoes.add((Component)this.labelDescricaoCentroCredito, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelApropriacoes.add((Component)this.labelCentroDebito, c);
        ++c.gridx;
        this.panelApropriacoes.add((Component)this.txtCentroDebito, c);
        ++c.gridx;
        this.panelApropriacoes.add((Component)this.buttonBuscaCentroDebito, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelApropriacoes.add((Component)this.labelDescricaoCentroDebito, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        JPanel aux4 = new JPanel();
        d = new Dimension(10, 10);
        aux4.setPreferredSize(d);
        aux4.setMinimumSize(d);
        this.panelApropriacoes.add((Component)aux4, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 3;
        this.panelApropriacoes.add((Component)new JLabel("Plano de Contas"), c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.panelApropriacoes.add((Component)this.labelPlanoReceita, c);
        ++c.gridx;
        this.panelApropriacoes.add((Component)this.txtPlanoReceita, c);
        ++c.gridx;
        this.panelApropriacoes.add((Component)this.buttonBuscaPlanoReceita, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelApropriacoes.add((Component)this.labelDescricaoPlanoReceita, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelApropriacoes.add((Component)this.labelPlanoDespesa, c);
        ++c.gridx;
        this.panelApropriacoes.add((Component)this.txtPlanoDespesa, c);
        ++c.gridx;
        this.panelApropriacoes.add((Component)this.buttonBuscaPlanoDespesa, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.panelApropriacoes.add((Component)this.labelDescricaoPlanoDespesa, c);
        this.controlaCampos();
        this.buttonBuscaAgencia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Conta.this.buscaAgencia();
            }
        });
        this.buttonBuscaHistorico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Conta.this.buscaHistorico();
            }
        });
        this.buttonBuscaDataSaldo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Conta.this.buscaDataSaldo();
            }
        });
        this.comboTipo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (Conta.this.comboTipo.getSelectedItem().equals(Tipos.tipoContaCorrente("X"))) {
                    Conta.this.tipoConta = 2;
                } else if (Conta.this.comboTipo.getSelectedItem().equals(Tipos.tipoContaCorrente("C"))) {
                    Conta.this.tipoConta = 1;
                } else {
                    Conta.this.tipoConta = 0;
                }
                Conta.this.controlaCampos();
            }
        });
        this.txtSaldo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (Conta.this.txtSaldo.isFocusable()) {
                    Conta.this.txtSaldo.selectAll();
                }
            }
        });
        this.txtDataSaldo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (Conta.this.txtDataSaldo.isFocusable()) {
                    Conta.this.txtDataSaldo.selectAll();
                }
            }
        });
        FocusAdapter focusLostBancoAgencia = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (!Funcoes.textoVazio(Conta.this.txtCodigoBanco) && !Funcoes.textoVazio(Conta.this.txtCodigoAgencia) && (st = Conexao.getStatement()) != null) {
                    try {
                        StringBuffer buf = new StringBuffer("select age_descricao from agencia where fil_codigo = ");
                        buf.append(Variaveis.filialPadrao);
                        buf.append(" and upper(age_codigo) = upper('");
                        buf.append(Conta.this.txtCodigoAgencia.getText());
                        buf.append("') and bac_codigo=");
                        buf.append(Conta.this.txtCodigoBanco.getText());
                        ResultSet rs = Conexao.executeQuery(st, buf.toString());
                        if (rs.next()) {
                            Conta.this.txtDescricaoAgencia.setText(rs.getString("age_descricao"));
                        } else {
                            Conta.this.txtDescricaoAgencia.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Conta.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        Conta.this.setStatus(1);
                        Conta.this.controlaCampos();
                    }
                }
            }
        };
        this.txtCodigoBanco.addFocusListener(focusLostBancoAgencia);
        this.txtCodigoAgencia.addFocusListener(focusLostBancoAgencia);
        this.txtCodigoHistorico.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (!Funcoes.textoVazio(Conta.this.txtCodigoHistorico.getText()) && (st = Conexao.getStatement()) != null) {
                    try {
                        StringBuffer buf = new StringBuffer("select hpa_descricao from historicopadrao where fil_codigo = ");
                        buf.append(Variaveis.filialPadrao);
                        buf.append(" and hpa_codigo = ");
                        buf.append(Conta.this.txtCodigoHistorico.getText());
                        ResultSet rs = Conexao.executeQuery(st, buf.toString());
                        if (rs.next()) {
                            Conta.this.txtDescricaoHistorico.setText(rs.getString("hpa_descricao"));
                        } else {
                            Conta.this.txtDescricaoHistorico.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Conta.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        Conta.this.setStatus(1);
                        Conta.this.controlaCampos();
                    }
                }
            }
        });
        ActionListener actionListenerCentroCusto = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CentroCustoVO vo = (CentroCustoVO)Conta.this.buscaCentroCusto();
                if (vo != null && vo.getConta().split("\\.").length != ParametrosGerais.getMascaraCentroCusto().split("\\.").length) {
                    Funcoes.mensagem(Conta.this, "Somente Centros de Custo do \u00faltimo n\u00edvel podem ser selecionadas.", 2);
                    return;
                }
                if (vo != null) {
                    if (e.getSource() == Conta.this.buttonBuscaCentroCredito) {
                        Conta.this.txtCentroCredito.setText(vo.getReduzido().toString());
                        Conta.this.labelDescricaoCentroCredito.setText(vo.getDescricao());
                    } else if (e.getSource() == Conta.this.buttonBuscaCentroDebito) {
                        Conta.this.txtCentroDebito.setText(vo.getReduzido().toString());
                        Conta.this.labelDescricaoCentroDebito.setText(vo.getDescricao());
                    }
                }
            }
        };
        ActionListener actionListenerPlanoConta = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlanoContaVO vo = (PlanoContaVO)Conta.this.buscaPlanoConta();
                if (vo != null && vo.getConta().split("\\.").length != ParametrosGerais.getMascaraPlanoConta().split("\\.").length) {
                    Funcoes.mensagem(Conta.this, "Somente Contas do \u00faltimo n\u00edvel podem ser selecionadas.", 2);
                    return;
                }
                if (vo != null) {
                    if (e.getSource() == Conta.this.buttonBuscaPlanoReceita) {
                        Conta.this.txtPlanoReceita.setText(vo.getReduzido().toString());
                        Conta.this.labelDescricaoPlanoReceita.setText(vo.getDescricao());
                    } else if (e.getSource() == Conta.this.buttonBuscaPlanoDespesa) {
                        Conta.this.txtPlanoDespesa.setText(vo.getReduzido().toString());
                        Conta.this.labelDescricaoPlanoDespesa.setText(vo.getDescricao());
                    }
                }
            }
        };
        this.buttonBuscaCentroCredito.addActionListener(actionListenerCentroCusto);
        this.buttonBuscaCentroDebito.addActionListener(actionListenerCentroCusto);
        this.buttonBuscaPlanoReceita.addActionListener(actionListenerPlanoConta);
        this.buttonBuscaPlanoDespesa.addActionListener(actionListenerPlanoConta);
        KeyAdapter keyAdapterCentro = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AbstractThreadVO vo;
                if (e.getKeyCode() == 113 && (vo = Conta.this.buscaCentroCusto()) != null) {
                    if (e.getSource() == Conta.this.txtCentroCredito) {
                        Conta.this.txtCentroCredito.setText(((CentroCustoVO)vo).getReduzido().toString());
                        Conta.this.labelDescricaoCentroCredito.setText(((CentroCustoVO)vo).getDescricao());
                    } else if (e.getSource() == Conta.this.txtCentroDebito) {
                        Conta.this.txtCentroDebito.setText(((CentroCustoVO)vo).getReduzido().toString());
                        Conta.this.labelDescricaoCentroDebito.setText(((CentroCustoVO)vo).getDescricao());
                    }
                }
            }
        };
        KeyAdapter keyAdapterPlano = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                AbstractThreadVO vo;
                if (e.getKeyCode() == 113 && (vo = Conta.this.buscaPlanoConta()) != null) {
                    if (e.getSource() == Conta.this.txtPlanoReceita) {
                        Conta.this.txtPlanoReceita.setText(((PlanoContaVO)vo).getReduzido().toString());
                        Conta.this.labelDescricaoPlanoReceita.setText(((PlanoContaVO)vo).getDescricao());
                    } else if (e.getSource() == Conta.this.txtPlanoDespesa) {
                        Conta.this.txtPlanoDespesa.setText(((PlanoContaVO)vo).getReduzido().toString());
                        Conta.this.labelDescricaoPlanoDespesa.setText(((PlanoContaVO)vo).getDescricao());
                    }
                }
            }
        };
        this.txtCentroCredito.addKeyListener(keyAdapterCentro);
        this.txtCentroDebito.addKeyListener(keyAdapterCentro);
        this.txtPlanoReceita.addKeyListener(keyAdapterPlano);
        this.txtPlanoDespesa.addKeyListener(keyAdapterPlano);
        FocusAdapter focusAdapterCentro = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractThreadVO centro = null;
                if (!Funcoes.textoVazio((TTextField)e.getSource())) {
                    centro = Conta.this.buscaCentroCusto(((TTextField)e.getSource()).getText());
                    if (centro != null) {
                        if (e.getSource() == Conta.this.txtCentroCredito) {
                            Conta.this.labelDescricaoCentroCredito.setText(((CentroCustoVO)centro).getDescricao());
                        } else if (e.getSource() == Conta.this.txtCentroDebito) {
                            Conta.this.labelDescricaoCentroDebito.setText(((CentroCustoVO)centro).getDescricao());
                        }
                    } else if (e.getSource() == Conta.this.txtCentroCredito) {
                        Conta.this.labelDescricaoCentroCredito.setText("N\u00e3o cadastrado");
                    } else if (e.getSource() == Conta.this.txtCentroDebito) {
                        Conta.this.labelDescricaoCentroDebito.setText("N\u00e3o cadastrado");
                    }
                } else if (e.getSource() == Conta.this.txtCentroCredito) {
                    Conta.this.labelDescricaoCentroCredito.setText("");
                } else if (e.getSource() == Conta.this.txtCentroDebito) {
                    Conta.this.labelDescricaoCentroDebito.setText("");
                }
            }
        };
        FocusAdapter focusAdapterPlano = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AbstractThreadVO plano = null;
                if (!Funcoes.textoVazio((TTextField)e.getSource())) {
                    plano = Conta.this.buscaPlanoConta(((TTextField)e.getSource()).getText());
                    if (plano != null) {
                        if (e.getSource() == Conta.this.txtPlanoReceita) {
                            Conta.this.labelDescricaoPlanoReceita.setText(((PlanoContaVO)plano).getDescricao());
                        } else if (e.getSource() == Conta.this.txtPlanoDespesa) {
                            Conta.this.labelDescricaoPlanoDespesa.setText(((PlanoContaVO)plano).getDescricao());
                        }
                    } else if (e.getSource() == Conta.this.txtPlanoReceita) {
                        Conta.this.labelDescricaoPlanoReceita.setText("N\u00e3o cadastrado");
                    } else if (e.getSource() == Conta.this.txtPlanoDespesa) {
                        Conta.this.labelDescricaoPlanoDespesa.setText("N\u00e3o cadastrado");
                    }
                } else if (e.getSource() == Conta.this.txtPlanoReceita) {
                    Conta.this.labelDescricaoPlanoReceita.setText("");
                } else if (e.getSource() == Conta.this.txtPlanoDespesa) {
                    Conta.this.labelDescricaoPlanoDespesa.setText("");
                }
            }
        };
        this.txtCentroCredito.addFocusListener(focusAdapterCentro);
        this.txtCentroDebito.addFocusListener(focusAdapterCentro);
        this.txtPlanoReceita.addFocusListener(focusAdapterPlano);
        this.txtPlanoDespesa.addFocusListener(focusAdapterPlano);
    }

    public AbstractThreadVO buscaCentroCusto(String codigo) {
        CentroCustoVO vo = null;
        try {
            vo = (CentroCustoVO)new CentroCustoService().getVO(Variaveis.filialPadrao, codigo);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Conta:669");
        }
        return vo;
    }

    public AbstractThreadVO buscaCentroCusto() {
        AbstractThreadVO vo = new CentroCustoService().pesquisaVO(this.getTopLevelAncestor(), new CentroCustoVO(), "Pesquisando Centros de Custo", true);
        return vo;
    }

    public AbstractThreadVO buscaPlanoConta(String codigo) {
        PlanoContaVO vo = null;
        try {
            vo = (PlanoContaVO)new PlanoContaService().getVO(Variaveis.filialPadrao, codigo);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Conta:686");
        }
        return vo;
    }

    public AbstractThreadVO buscaPlanoConta() {
        AbstractThreadVO vo = new PlanoContaService().pesquisaVO(this.getTopLevelAncestor(), new PlanoContaVO(), "Pesquisando Planos de Conta", true);
        return vo;
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Conta.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600100401"));
        this.setModuloEdita(Long.parseLong("0600100402"));
        this.setModuloApaga(Long.parseLong("0600100403"));
    }

    private AbstractThreadBean pesquisar() {
        Hashtable resultado = Pesquisas.contaCorrente(this.getTopLevelAncestor(), "", false, false);
        ContaCorrenteBean bean = null;
        if (resultado != null) {
            try {
                bean = (ContaCorrenteBean)new ContaCorrenteDao().getBean(Variaveis.filialPadrao, resultado.get("cco_reduzido").toString());
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar a conta corrente. " + e.getMessage(), e.getStackTrace());
            }
            return bean;
        }
        return null;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        ContaCorrenteBean bean = (ContaCorrenteBean)this.pesquisar();
        if (bean != null) {
            this.preencherCampos(bean);
            this.setStatus(3);
            this.controlaCampos();
            if (this.comboTipo.isFocusable()) {
                this.comboTipo.grabFocus();
            }
        }
    }

    public void preencherCampos(ContaCorrenteBean bean) {
        if (bean != null) {
            this.txtCodigo.setText(bean.getReduzido().toString());
            this.comboTipo.setSelectedItem(Tipos.tipoContaCorrente(bean.getTipo()));
            this.txtConta.setText(bean.getConta());
            if (bean.getAgencia() != null) {
                this.txtCodigoAgencia.setText(bean.getAgencia().getCodigo());
                this.txtDescricaoAgencia.setText(bean.getAgencia().getDescricao());
            }
            if (bean.getBanco() != null) {
                this.txtCodigoBanco.setText(bean.getBanco().getCodigo().toString());
            }
            this.txtTitular.setText(bean.getTitular());
            if (bean.getHistoricoPadrao() != null) {
                this.txtCodigoHistorico.setText(bean.getHistoricoPadrao().getCodigo().toString());
                this.txtDescricaoHistorico.setText(bean.getHistoricoPadrao().getDescricao());
            }
            this.checkInativa.setSelected(bean.getInativa());
            this.txtSaldo.setText(Funcoes.formataDecimal(this.txtSaldo.getMaskDecimal(), bean.getSaldoInicial() == null ? new Double(0.0) : bean.getSaldoInicial()));
            this.txtDataSaldo.setText(Funcoes.formataData("dd/MM/yyyy", bean.getDataSaldoInicial()));
            if (bean.getCentroCredito() != null) {
                this.txtCentroCredito.setText(bean.getCentroCredito().getReduzido().toString());
                this.labelDescricaoCentroCredito.setText(bean.getCentroCredito().getDescricao());
            }
            if (bean.getCentroDebito() != null) {
                this.txtCentroDebito.setText(bean.getCentroDebito().getReduzido().toString());
                this.labelDescricaoCentroDebito.setText(bean.getCentroDebito().getDescricao());
            }
            if (bean.getPlanoReceita() != null) {
                this.txtPlanoReceita.setText(bean.getPlanoReceita().getReduzido().toString());
                this.labelDescricaoPlanoReceita.setText(bean.getPlanoReceita().getDescricao());
            }
            if (bean.getPlanoDespesa() != null) {
                this.txtPlanoDespesa.setText(bean.getPlanoDespesa().getReduzido().toString());
                this.labelDescricaoPlanoDespesa.setText(bean.getPlanoDespesa().getDescricao());
            }
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        ContaCorrenteBean beanDelete = (ContaCorrenteBean)this.pesquisar();
        if (beanDelete != null) {
            if (!this.existeOutrasContasAtivas()) {
                Funcoes.mensagem(this, "A conta n\u00e3o pode ser exclu\u00edda, pois o sistema precisa de pelo menos uma conta caixa", 1);
            } else if (Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
                try {
                    new ContaCorrenteService().gravaAutoCopiaSemCommit(beanDelete, 2, Variaveis.filialPadrao, ParametrosGerais.getCopiaContas());
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "Conta:excluir:855");
                }
                this.setStatus(1);
                this.controlaCampos();
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.txtSaldo.setText("0,00");
        this.txtDataSaldo.setText(Funcoes.formataData("dd/MM/yyyy", new Date()));
        if (this.comboTipo.isFocusable()) {
            this.comboTipo.grabFocus();
        }
        this.tipoConta = 1;
        this.controlaCampos();
    }

    @Override
    public void salvar() {
        ContaCorrenteBean bean;
        if (this.validaCampos() && (bean = (ContaCorrenteBean)this.getBeanPreenchido()) != null) {
            try {
                new ContaCorrenteService().gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, ParametrosGerais.getCopiaContas());
                this.retornoParaPesquisa = bean.getReduzido().toString();
                Conexao.arquivaSQL();
                this.limparCampos();
                this.setStatus(1);
                this.controlaCampos();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e1.getMessage(), e1.getStackTrace());
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "Conta:salvar:882");
            }
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(false);
        this.txtConta.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtTitular.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.comboTipo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodigoHistorico.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.checkInativa.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaHistorico.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtSaldo.setEnabled(this.getStatus() == 2);
        this.txtDataSaldo.setEnabled(this.getStatus() == 2);
        this.buttonBuscaDataSaldo.setEnabled(this.getStatus() == 2);
        this.txtCodigoAgencia.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.tipoConta != 2);
        this.txtCodigoBanco.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.tipoConta != 2);
        this.buttonBuscaAgencia.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.tipoConta != 2);
        this.txtCentroDebito.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.tipoConta == 2);
        this.txtCentroCredito.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.tipoConta == 2);
        this.txtPlanoDespesa.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.tipoConta == 2);
        this.txtPlanoReceita.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.tipoConta == 2);
        this.buttonBuscaCentroDebito.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.tipoConta == 2);
        this.buttonBuscaCentroCredito.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.tipoConta == 2);
        this.buttonBuscaPlanoDespesa.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.tipoConta == 2);
        this.buttonBuscaPlanoReceita.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.tipoConta == 2);
        this.txtDescricaoAgencia.setEnabled((this.getStatus() == 3 || this.getStatus() == 2) && this.tipoConta == 2);
    }

    private void limparCampos() {
        this.txtCodigo.clear();
        this.txtConta.clear();
        this.txtTitular.clear();
        this.comboTipo.setSelectedIndex(0);
        this.txtCodigoAgencia.clear();
        this.txtCodigoBanco.clear();
        this.txtCodigoHistorico.clear();
        this.checkInativa.setSelected(false);
        this.txtSaldo.clear();
        this.txtDataSaldo.clear();
        this.txtDescricaoAgencia.clear();
        this.txtDescricaoHistorico.clear();
    }

    @Override
    public boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtCodigo.getText()) && this.getStatus() == 3) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
            this.txtCodigo.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtConta.getText())) {
            Funcoes.mensagem(this, "Campo conta n\u00e3o informado", 1);
            this.txtConta.selectAll();
            this.txtConta.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtTitular.getText())) {
            Funcoes.mensagem(this, "Campo titular n\u00e3o informado", 1);
            this.txtTitular.selectAll();
            this.txtTitular.grabFocus();
            return false;
        }
        if (this.comboTipo.getSelectedItem().equals(Tipos.tipoContaCorrente("C")) && (Funcoes.textoVazio(this.txtCodigoAgencia.getText()) || Funcoes.textoVazio(this.txtCodigoBanco.getText()))) {
            Funcoes.mensagem(this, "Campo ag\u00eancia n\u00e3o informado", 1);
            this.txtCodigoAgencia.selectAll();
            this.txtCodigoAgencia.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.txtCodigoAgencia.getText()) && !Funcoes.textoVazio(this.txtCodigoBanco.getText()) && this.txtDescricaoAgencia.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Ag\u00eancia n\u00e3o localizada", 1);
            this.txtCodigoAgencia.selectAll();
            this.txtCodigoAgencia.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodigoHistorico.getText())) {
            Funcoes.mensagem(this, "Campo hist\u00f3rico n\u00e3o informado", 1);
            this.txtCodigoHistorico.selectAll();
            this.txtCodigoHistorico.grabFocus();
            return false;
        }
        if (!Funcoes.textoVazio(this.txtCodigoHistorico.getText()) && this.txtDescricaoHistorico.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Hist\u00f3rico n\u00e3o localizado", 1);
            this.txtCodigoHistorico.selectAll();
            this.txtCodigoHistorico.grabFocus();
            return false;
        }
        if (this.checkInativa.isSelected() && !this.existeOutrasContasAtivas()) {
            Funcoes.mensagem(this, "A conta n\u00e3o pode ser inativa, pois o sistema precisa de pelo menos uma conta caixa ativa", 1);
            return false;
        }
        if (Funcoes.textoVazio(this.txtSaldo)) {
            Funcoes.mensagem(this, "Deve ser inserido um valor de Saldo Inicial.", 2);
            return false;
        }
        if (Funcoes.textoVazio(this.txtDataSaldo)) {
            Funcoes.mensagem(this, "A data do Saldo Inicial deve ser preenchida.", 2);
            return false;
        }
        if (Funcoes.getData("dd/MM/yyyy", this.txtDataSaldo.getText()).compareTo(new Date()) > 0) {
            Funcoes.mensagem(this, "A data do Saldo Inicial deve ser menor ou igual \u00e0 data atual.", 2);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existeOutrasContasAtivas() {
        boolean retorno = true;
        if (this.comboTipo.getSelectedIndex() == 0) {
            return true;
        }
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder("select count(*) from contacorrente where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and cco_inativa = false ");
            buf.append(" and cco_tipo = '").append("X").append("' ");
            buf.append(" and cco_reduzido != ").append(this.txtCodigo.getTextDB());
            ResultSet rs = Conexao.executeQuery(st, buf);
            retorno = rs.next() && rs.getInt(1) > 0;
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "Conta (519)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600100400");
    }

    private void buscaAgencia() {
        Hashtable resultado = Pesquisas.agencia(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodigoAgencia.setText(resultado.get("age_codigo").toString());
            this.txtCodigoBanco.setText(resultado.get("bac_codigo").toString());
        }
        this.txtCodigoBanco.requestFocus();
    }

    private void buscaHistorico() {
        Hashtable resultado = Pesquisas.historicoPadrao(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodigoHistorico.setText(resultado.get("hpa_codigo").toString());
        }
        this.txtCodigoHistorico.requestFocus();
    }

    private void buscaDataSaldo() {
        Funcoes.mostraData(this.txtDataSaldo, this.buttonBuscaDataSaldo, this.panelSaldo, true);
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCodigoAgencia.hasFocus() || this.txtCodigoBanco.hasFocus()) {
            this.buscaAgencia();
        } else if (this.txtCodigoHistorico.hasFocus()) {
            this.buscaHistorico();
        } else if (this.txtDataSaldo.hasFocus()) {
            this.buscaDataSaldo();
        }
    }

    public AbstractThreadBean getBeanPreenchido() {
        ContaCorrenteBean bean = new ContaCorrenteBean();
        BancoVO banco = new BancoVO();
        banco.setCodigo(Funcoes.textoVazio(this.txtCodigoBanco) ? null : Integer.valueOf(Integer.parseInt(this.txtCodigoBanco.getText())));
        AgenciaVO agencia = new AgenciaVO();
        agencia.setBanco(banco);
        agencia.setCodigo(this.txtCodigoAgencia.getText());
        FilialVO filial = new FilialVO();
        filial.setCodigo(Integer.parseInt(Variaveis.filialPadrao));
        HistoricoPadraoVO historicoPadrao = new HistoricoPadraoVO();
        historicoPadrao.setCodigo(Integer.parseInt(this.txtCodigoHistorico.getText()));
        CentroCustoVO centroDebito = new CentroCustoVO();
        centroDebito.setReduzido(Funcoes.textoVazio(this.txtCentroDebito) ? null : Integer.valueOf(Integer.parseInt(this.txtCentroDebito.getText())));
        CentroCustoVO centroCredito = new CentroCustoVO();
        centroCredito.setReduzido(Funcoes.textoVazio(this.txtCentroCredito) ? null : Integer.valueOf(Integer.parseInt(this.txtCentroCredito.getText())));
        PlanoContaVO planoDespesa = new PlanoContaVO();
        planoDespesa.setReduzido(Funcoes.textoVazio(this.txtPlanoDespesa) ? null : Integer.valueOf(Integer.parseInt(this.txtPlanoDespesa.getText())));
        PlanoContaVO planoReceita = new PlanoContaVO();
        planoReceita.setReduzido(Funcoes.textoVazio(this.txtPlanoReceita) ? null : Integer.valueOf(Integer.parseInt(this.txtPlanoReceita.getText())));
        bean.setReduzido(Funcoes.textoVazio(this.txtCodigo) ? null : Integer.valueOf(Integer.parseInt(this.txtCodigo.getText())));
        bean.setAgencia(agencia);
        bean.setBanco(banco);
        bean.setConta(this.txtConta.getText());
        bean.setFilial(filial);
        bean.setHistoricoPadrao(historicoPadrao);
        bean.setInativa(this.checkInativa.isSelected());
        bean.setTipo(Tipos.getTipoContaCorrente(this.comboTipo.getSelectedItem().toString()));
        bean.setTitular(this.txtTitular.getText());
        bean.setSaldoInicial(Double.valueOf(Funcoes.textoVazio(this.txtSaldo.getText()) ? this.txtSaldo.getMaskDecimal() : Funcoes.limpaDecimal(this.txtSaldo.getText())));
        bean.setDataSaldoInicial(this.txtDataSaldo.getText() == null ? new Date() : Funcoes.stringToDate(this.txtDataSaldo.getText()));
        bean.setCentroCredito(centroCredito);
        bean.setCentroDebito(centroDebito);
        bean.setPlanoReceita(planoReceita);
        bean.setPlanoDespesa(planoDespesa);
        return bean;
    }

    @Override
    public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
        return this.getBeanPreenchido();
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "cco_reduzido";
    }
}

