/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro.contas;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;

public class Agencia
extends FrmCadPadrao {
    private JLabel jLabel1;
    private TTextField txtCodigo;
    private TTextField txtDescricao;
    private JLabel jLabel2;
    private JLabel labelBanco;
    private TTextField txtCodigoBanco;
    private JButton buttonBuscaBanco;
    private TTextField txtDescricaoBanco;
    private String retornoParaPesquisa = "";

    public Agencia() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Agencia");
        }
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
    }

    public void jbInit() throws Exception {
        this.setName("Agencia");
        this.jLabel1 = new JLabel();
        this.txtCodigo = new TTextField(10);
        this.txtCodigo.setName("txtCodigo");
        this.txtDescricao = new TTextField(100);
        this.txtDescricao.setName("txtDescricao");
        this.jLabel2 = new JLabel();
        this.labelBanco = new JLabel();
        this.txtCodigoBanco = new TTextField(5, 1);
        this.txtCodigoBanco.setName("txtCodigoBanco");
        this.buttonBuscaBanco = new JButton();
        this.txtDescricaoBanco = new TTextField();
        this.setLabelDescricao("Cadastro de ag\u00eancias banc\u00e1rias");
        this.setLabelFormulario("Cadastro de ag\u00eancias");
        this.setIcone(ImagemUtils.carregaImagemJalis("cadastros/agencia.jpg"));
        this.jLabel1.setDisplayedMnemonic('D');
        this.jLabel1.setLabelFor(this.txtCodigo);
        this.jLabel1.setText("C\u00f3digo:");
        this.jLabel1.setBounds(new Rectangle(7, 9, 55, 14));
        this.txtCodigo.setText("");
        this.txtCodigo.setBounds(new Rectangle(72, 7, 69, 20));
        this.txtDescricao.setBounds(new Rectangle(72, 28, 400, 20));
        this.txtDescricao.setText("");
        this.jLabel2.setBounds(new Rectangle(7, 30, 63, 14));
        this.jLabel2.setText("Descri\u00e7\u00e3o:");
        this.jLabel2.setLabelFor(this.txtDescricao);
        this.jLabel2.setDisplayedMnemonic('R');
        this.labelBanco.setBounds(new Rectangle(7, 51, 63, 14));
        this.txtCodigoBanco.setBounds(new Rectangle(72, 49, 69, 20));
        this.buttonBuscaBanco.setBounds(new Rectangle(142, 49, 20, 20));
        this.txtDescricaoBanco.setBounds(new Rectangle(163, 49, 309, 20));
        this.txtDescricaoBanco.setEditable(false);
        this.txtDescricaoBanco.setFocusable(false);
        this.labelBanco.setText("Banco:");
        Funcoes.imagemPesquisa(this.buttonBuscaBanco);
        this.buttonBuscaBanco.setMargin(new Insets(2, 2, 2, 2));
        this.buttonBuscaBanco.setFocusable(false);
        this.controlaCampos();
        this.painelCentral.add((Component)this.jLabel1, null);
        this.painelCentral.add((Component)this.jLabel2, null);
        this.painelCentral.add((Component)this.txtCodigo, null);
        this.painelCentral.add((Component)this.txtDescricao, null);
        this.painelCentral.add((Component)this.labelBanco, null);
        this.painelCentral.add((Component)this.txtCodigoBanco, null);
        this.painelCentral.add((Component)this.buttonBuscaBanco, null);
        this.painelCentral.add((Component)this.txtDescricaoBanco, null);
        this.buttonBuscaBanco.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Agencia.this.buscaBanco();
            }
        });
        this.txtCodigo.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Agencia.this.txtCodigo.getText().trim().length() > 0) {
                    Statement st = Agencia.this.getStatement();
                    try {
                        if (st != null) {
                            StringBuffer buf = new StringBuffer("select a.age_codigo, a.age_descricao, b.bac_codigo, b.bac_descricao ");
                            buf.append("from agencia a ");
                            buf.append("left join banco b on a.fil_codigo = b.fil_codigo and a.bac_codigo = b.bac_codigo ");
                            buf.append("where a.fil_codigo = ");
                            buf.append(Variaveis.filialPadrao);
                            buf.append(" and upper(a.age_codigo) = upper('");
                            buf.append(Agencia.this.txtCodigo.getTextDB());
                            buf.append("')");
                            ResultSet rs = Conexao.executeQuery(st, buf.toString());
                            if (rs != null && rs.next()) {
                                Agencia.this.txtDescricao.setText(rs.getString("age_descricao"));
                                Agencia.this.txtCodigoBanco.setText(rs.getString("bac_codigo"));
                                Agencia.this.txtDescricaoBanco.setText(rs.getString("bac_descricao"));
                                if (Agencia.this.getStatus() == 2) {
                                    Agencia.this.setStatus(3);
                                }
                                Agencia.this.txtCodigo.setEnabled(false);
                            } else if (Agencia.this.getStatus() == 3) {
                                Funcoes.mensagem(Agencia.this, "C\u00f3digo n\u00e3o localizado, edi\u00e7\u00e3o n\u00e3o permitida", 5);
                                Agencia.this.setStatus(1);
                                Agencia.this.controlaCampos();
                            }
                        }
                        if (st != null) {
                            st.close();
                        }
                    }
                    catch (SQLException sqlex) {
                        ErrorLogger.mostraMensagem(Agencia.this.getTopLevelAncestor(), sqlex.getMessage(), sqlex.getStackTrace(), "Agencia");
                    }
                }
            }
        });
        this.txtCodigoBanco.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Statement st;
                if (Agencia.this.txtCodigoBanco.getText().trim().length() > 0 && (st = Conexao.getStatement()) != null) {
                    try {
                        ResultSet rs = Conexao.executeQuery(st, "select bac_descricao from banco where fil_codigo = " + Variaveis.filialPadrao + " and  bac_codigo=" + Agencia.this.txtCodigoBanco.getText());
                        if (rs.next()) {
                            Agencia.this.txtDescricaoBanco.setText(rs.getString("bac_descricao"));
                        } else {
                            Agencia.this.txtDescricaoBanco.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (SQLException sqlex) {
                        Funcoes.mensagem(Agencia.this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:", 5);
                        Agencia.this.setStatus(1);
                        Agencia.this.controlaCampos();
                    }
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.setModuloAcesso(Agencia.getModuloAcesso());
        this.setModuloInsere(Long.parseLong("0600100201"));
        this.setModuloEdita(Long.parseLong("0600100202"));
        this.setModuloApaga(Long.parseLong("0600100203"));
    }

    private boolean pesquisar() {
        boolean retorno;
        Hashtable resultado = Pesquisas.agencia(this.getTopLevelAncestor(), false);
        boolean bl = retorno = resultado != null;
        if (retorno) {
            this.txtCodigo.setText(resultado.get("age_codigo").toString());
        }
        this.txtCodigo.requestFocus();
        return retorno;
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        if (this.pesquisar()) {
            this.setStatus(3);
            this.controlaCampos();
            this.txtCodigo.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.limparCampos();
        if (this.pesquisar() && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setStatus(1);
            this.controlaCampos();
            try {
                Statement statement = Conexao.getStatement();
                if (statement != null) {
                    SalvaDados salvar = new SalvaDados("agencia", 1);
                    salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvar.adicionaCampo("age_codigo", 0, false, true, this.txtCodigo.getTextDB());
                    DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaAgencia());
                    Conexao.arquivaSQL();
                }
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Agencia");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.limparCampos();
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.txtCodigo.grabFocus();
    }

    @Override
    public void salvar() {
        Statement statement;
        if (this.validaCampos() && (statement = Conexao.getStatement()) != null) {
            try {
                SalvaDados salvar = new SalvaDados("agencia", this.getStatus() == 2 ? 0 : 2);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("age_codigo", 0, false, true, this.txtCodigo.getTextDB());
                salvar.adicionaCampo("age_descricao", 0, true, false, this.txtDescricao.getTextDB());
                salvar.adicionaCampo("bac_codigo", 2, false, false, this.txtCodigoBanco.getText());
                DBUtil.gravaAutoCopia(statement, salvar, "fil_codigo", ParametrosGerais.getCopiaAgencia());
                this.retornoParaPesquisa = this.txtCodigo.getText();
                Conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    Conexao.anulaSQL();
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "Agencia");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    private void controlaCampos() {
        this.txtCodigo.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtDescricao.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.txtCodigoBanco.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
        this.buttonBuscaBanco.setEnabled(this.getStatus() == 3 || this.getStatus() == 2);
    }

    private void limparCampos() {
        this.txtCodigo.clear();
        this.txtDescricao.clear();
        this.txtCodigoBanco.clear();
        this.txtDescricaoBanco.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validaCampos() {
        if (this.getStatus() == 2) {
            Statement st = Conexao.getStatement();
            try (ResultSet rs = null;){
                rs = Conexao.executeQuery(st, "select age_codigo from agencia where fil_codigo = " + Variaveis.filialPadrao + " and upper(age_codigo) = upper('" + this.txtCodigo.getTextDB().trim() + "')");
                if (rs != null && !DBUtil.resultIsEmpty(rs)) {
                    Funcoes.mensagem(this, "Ag\u00eancia j\u00e1 cadastrada", 1);
                    this.txtCodigo.grabFocus();
                    boolean bl = false;
                    return bl;
                }
            }
            catch (SQLException sqlex) {
                Funcoes.mensagem(this, "Situa\u00e7\u00e3o inesperada.\nMensagem apresentada:" + sqlex.getMessage(), 1);
                this.txtCodigo.grabFocus();
                return false;
            }
        }
        if (this.txtCodigo.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo c\u00f3digo n\u00e3o informado", 1);
            this.txtCodigo.grabFocus();
            return false;
        }
        if (this.txtDescricao.getText().trim().length() == 0) {
            Funcoes.mensagem(this, "Campo descri\u00e7\u00e3o n\u00e3o informado", 1);
            this.txtDescricao.selectAll();
            this.txtDescricao.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodigoBanco.getText())) {
            Funcoes.mensagem(this, "Campo banco n\u00e3o informado", 1);
            this.txtCodigoBanco.selectAll();
            this.txtCodigoBanco.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtCodigoBanco.getText())) return true;
        if (!this.txtDescricaoBanco.getText().equals("N\u00e3o cadastrado")) return true;
        Funcoes.mensagem(this, "Banco n\u00e3o localizado", 1);
        this.txtCodigoBanco.selectAll();
        this.txtCodigoBanco.grabFocus();
        return false;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600100200");
    }

    private void buscaBanco() {
        Hashtable resultado = Pesquisas.banco(this.getTopLevelAncestor(), true);
        if (resultado != null) {
            this.txtCodigoBanco.setText(resultado.get("bac_codigo").toString());
        }
        this.txtCodigoBanco.requestFocus();
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCodigoBanco.hasFocus()) {
            this.buscaBanco();
        }
    }

    @Override
    public String getRetornoParaPesquisa() {
        return this.retornoParaPesquisa;
    }

    @Override
    public String getCampoRetornoParaPesquisa() {
        return "age_codigo";
    }
}

