/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.financeiro.lancamentos.componente.BuscaBeanPreenchido;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.service.financeiro.ReceberPagarService;
import jalis.util.Funcoes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

class ParcelaPlanoCusto
extends AbstractDialogoOKCancelar
implements BuscaBeanPreenchido {
    private PanelPlanoContaCentroCusto plc = null;
    private JEditorPane editor = new JEditorPane();
    private ReceberPagarBean bean = null;
    private JLabel labelDadosParcela = new JLabel();

    public ParcelaPlanoCusto(Dialog owner, String filial) {
        super(owner, "Plano de contas/Centros de custo");
        this.plc = new PanelPlanoContaCentroCusto(this, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, -1L, -1L, filial);
        this.montaTela(owner);
    }

    public ParcelaPlanoCusto(Frame owner, String filial) {
        super(owner, "Plano de contas/Centros de custo");
        this.plc = new PanelPlanoContaCentroCusto(this, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, -1L, -1L, filial);
        this.montaTela(owner);
    }

    public static ParcelaPlanoCusto novaInstancia(Object pai, String filial) {
        if (pai instanceof Frame) {
            return new ParcelaPlanoCusto((Frame)pai, filial);
        }
        if (pai instanceof Dialog) {
            return new ParcelaPlanoCusto((Dialog)pai, filial);
        }
        return null;
    }

    private void montaTela(Object owner) {
        this.setSize(new Dimension(750, 400));
        this.setLocationRelativeTo((Component)owner);
        this.getPanelCentral().setLayout(new BorderLayout());
        JTabbedPane tab = new JTabbedPane();
        tab.addTab("Plano/Centro", this.plc);
        tab.addTab("Resumo Fatura", new JScrollPane(this.editor));
        this.labelDadosParcela.setPreferredSize(new Dimension(100, 60));
        this.getPanelCentral().add((Component)this.labelDadosParcela, "North");
        this.getPanelCentral().add((Component)tab, "Center");
    }

    public void setReceberPagar(ReceberPagarBean bean) {
        this.bean = bean;
        if (bean != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("<html><table cellspacing=0>");
            buf.append("<tr>");
            buf.append("<td>Parcela:</td><td>").append(bean.getParcela()).append("</td><td> </td>");
            buf.append("<td>Vl. Bruto:</td><td>").append(Funcoes.formataDecimal(bean.getValor())).append("</td><td> </td>");
            buf.append("<td>ISSQN:</td><td>").append(Funcoes.formataDecimal(bean.getIssValor() == null ? 0.0 : bean.getIssValor())).append("</td><td> </td>");
            buf.append("<td>CSLL:</td><td>").append(Funcoes.formataDecimal(bean.getCsllValor() == null ? 0.0 : bean.getCsllValor())).append("</td><td> </td>");
            buf.append("<td>IRRF:</td><td>").append(Funcoes.formataDecimal(bean.getIrrfValor() == null ? 0.0 : bean.getIrrfValor())).append("</td><td> </td>");
            buf.append("<td>ISS ret.:</td><td>").append(Funcoes.formataDecimal(bean.getIssRetidoValor() == null ? 0.0 : bean.getIssRetidoValor())).append("</td>");
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append("<td>Emiss\u00e3o:</td><td>").append(Funcoes.formataData(bean.getDataHora())).append("</td><td> </td>");
            buf.append("<td>Vl. L\u00edquido:</td><td>").append(Funcoes.formataDecimal(bean.getValorTotal())).append("</td><td> </td>");
            buf.append("<td>COFINS:</td><td>").append(Funcoes.formataDecimal(bean.getCofinsValor() == null ? 0.0 : bean.getCofinsValor())).append("</td><td> </td>");
            buf.append("<td>INSS:</td><td>").append(Funcoes.formataDecimal(bean.getInssValor() == null ? 0.0 : bean.getInssValor())).append("</td><td> </td>");
            buf.append("<td>PIS:</td><td>").append(Funcoes.formataDecimal(bean.getPisValor() == null ? 0.0 : bean.getPisValor())).append("</td><td> </td>");
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append("<td>Vencimento:</td><td>").append(Funcoes.formataData(bean.getDataVencimento())).append("</td>");
            buf.append("</tr>");
            buf.append("</table></html>");
            this.labelDadosParcela.setText(buf.toString());
        }
    }

    @Override
    public AbstractThreadBean buscaBeanPreenchido(PanelPlanoContaCentroCusto source) {
        return this.bean;
    }

    public ArrayList<AbstractThreadBean> getPlanoConta() {
        return this.plc.getPlanoContas();
    }

    public ArrayList<AbstractThreadBean> getCentroCusto() {
        return this.plc.getCentrosCusto();
    }

    public void setPlanoContas(Set plano) {
        if (plano != null) {
            this.plc.setPlanoContas(plano);
        }
    }

    public void setCentroCusto(Set centro) {
        if (centro != null) {
            this.plc.setCentrosCusto(centro);
        }
    }

    public void setService(ReceberPagarService s) {
        this.plc.setService(s);
    }

    public void setResumo(String html) {
        if (html != null) {
            this.editor.setContentType("text/html");
            this.editor.setText(html);
            this.editor.setEditable(false);
            this.editor.setCaretPosition(0);
        }
    }

    public void atualizarPlanosCustos() {
        this.plc.atualizar(this.bean);
    }
}

