/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.financeiro.AlteraNumeroTitulo;
import jalis.laboratorio.financeiro.AssociarFaturasNota;
import jalis.laboratorio.financeiro.CronometroRegressivo;
import jalis.laboratorio.financeiro.DialogNotaFiscalSaida;
import jalis.laboratorio.financeiro.ParcelaPlanoCusto;
import jalis.laboratorio.financeiro.TextFieldImposto;
import jalis.laboratorio.financeiro.faturamento.DialogComposicao;
import jalis.laboratorio.financeiro.faturamento.ImprimirNotaFiscalPessoaFisica;
import jalis.laboratorio.financeiro.faturamento.integracao.SistemaEmissaoNFSe;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.IntegracaoEnotas;
import jalis.laboratorio.financeiro.faturamento.integracao.enotas.dto.ConfiguracaoEnotasDto;
import jalis.laboratorio.financeiro.lancamentos.componente.PanelPlanoContaCentroCusto;
import jalis.laboratorio.financeiro.util.TipoServico;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.laboratorio.util.faturamento.FuncoesGerais;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.cadastro.financeiro.ServicoBean;
import jalis.model.bean.financeiro.FaturaBean;
import jalis.model.bean.financeiro.FaturaNotaFiscalBean;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.NotaFiscalServicoBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.bean.recepcao.RequisicaoBean;
import jalis.model.bean.recepcao.RequisicaoLanctoCaixaBean;
import jalis.model.utils.ThreadDaoException;
import jalis.model.vo.AbstractThreadVO;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.model.vo.cadastro.EntidadeVO;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.CidadeVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.cadastro.financeiro.FormaPagamentoVO;
import jalis.model.vo.cadastro.financeiro.SeriesVO;
import jalis.model.vo.cadastro.financeiro.ServicoVO;
import jalis.model.vo.financeiro.FaturaVO;
import jalis.model.vo.financeiro.NotaFiscalVO;
import jalis.model.vo.recepcao.ExameRequisicaoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.cadastro.EntidadeService;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.PacienteService;
import jalis.service.cadastro.financeiro.CentroCustoService;
import jalis.service.cadastro.financeiro.FormaPagamentoParcelaService;
import jalis.service.cadastro.financeiro.FormaPagamentoService;
import jalis.service.cadastro.financeiro.PlanoContaService;
import jalis.service.cadastro.financeiro.SeriesService;
import jalis.service.cadastro.financeiro.ServicoService;
import jalis.service.financeiro.FaturaReceberPagarService;
import jalis.service.financeiro.LancamentoService;
import jalis.service.financeiro.NotaFiscalService;
import jalis.service.financeiro.ReceberPagarService;
import jalis.service.financeiro.RequisicaoNotaFiscalService;
import jalis.service.recepcao.RequisicaoLanctoCaixaService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TAvisoLabel;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.postgresql.PGConnection;
import org.postgresql.largeobject.LargeObject;
import org.postgresql.largeobject.LargeObjectManager;

public class NotaFiscalSaida
extends JPanel
implements ActionListener,
FocusListener,
ClipboardOwner {
    public static final int TIPO_TELA_DIALOG_JURIDICA = 1;
    public static final int TIPO_TELA_DIALOG_FISICA = 2;
    public static final int TIPO_TELA_PANEL_JURIDICA = 3;
    private final int COLUNA_PARCELA_PARCELA = 0;
    private final int COLUNA_PARCELA_VENCIMENTO = 1;
    private final int COLUNA_PARCELA_VALOR_BRUTO = 2;
    private final int COLUNA_PARCELA_VALOR_LIQUIDO = 3;
    private final int COLUNA_PARCELA_BEAN = 4;
    private boolean isPesquisandoFilial = false;
    private final String CAMPO_OBSERVACAO = "campoObs";
    private SistemaEmissaoNFSe sistemaEmissaoNFSe = Laboratorio.sistemaEmissorNFSe;
    NotaFiscalBean beanNota = new NotaFiscalBean();
    NotaFiscalService serviceNota = new NotaFiscalService();
    ConvenioService serviceConvenio = new ConvenioService();
    EntidadeService serviceEntidade = new EntidadeService();
    PacienteService servicePaciente = new PacienteService();
    SeriesService serviceSerie = new SeriesService();
    ServicoService serviceServico = new ServicoService();
    FormaPagamentoService serviceFormaPagamento = new FormaPagamentoService();
    FormaPagamentoParcelaService serviceFormaPagamentoParcela = new FormaPagamentoParcelaService();
    JButton buttonEditar = ComponenteFactory.novoJButton("Editar", 'E', this);
    JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    JButton buttonNovo = ComponenteFactory.novoJButton("Novo", 'N', this);
    JButton buttonAssociarFaturas = ComponenteFactory.novoJButton("Associar Faturas", 'A', this);
    JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this);
    JButton buttonOpcoesNfse = ComponenteFactory.novoJButton("Op\u00e7\u00f5es NFSe", 'O', this);
    JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this);
    JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    JButton buttonBuscaSerie = ComponenteFactory.novoJButton(this, true);
    JButton buttonBuscaDataEmissao = ComponenteFactory.novoJButton(this, true);
    JButton buttonBuscaCadastro = ComponenteFactory.novoJButton(this, true);
    JButton buttonImpostos = ComponenteFactory.novoJButton("Impostos \u25ba", 'm', this);
    JButton buttonBuscaServico = ComponenteFactory.novoJButton(this, true);
    JButton buttonBuscaForma = ComponenteFactory.novoJButton(this, true);
    JButton buttonBuscaDataParcela = ComponenteFactory.novoJButton(this, true);
    JButton buttonOKParcela = ComponenteFactory.novoJButton("OK", this);
    JButton buttonSincronizar = ComponenteFactory.novoJButton("Sincronizar", this);
    TTextField textCodigoSerie = new TTextField(2);
    TTextField textNumeroNota = new TTextField(8, 1);
    TTextField textDataEmissao = new TTextField(10, 4);
    TTextField textCodigoCadastro = new TTextField(12, 1);
    TTextField textValorIrrf = new TTextField(10, 2);
    TTextField textValorIss = new TTextField(10, 2);
    TTextField textValorPis = new TTextField(10, 2);
    TTextField textValorCsll = new TTextField(10, 2);
    TTextField textValorCofins = new TTextField(10, 2);
    TTextField textValorInss = new TTextField(10, 2);
    TTextField textValorIssRetido = new TTextField(10, 2);
    TTextField textValorInssRetido = new TTextField(10, 2);
    TTextField textValorCofinsRetido = new TTextField(10, 2);
    TTextField textValorCsllRetido = new TTextField(10, 2);
    TTextField textValorIrrfRetido = new TTextField(10, 2);
    TTextField textValorPisRetido = new TTextField(10, 2);
    TTextField textCodigoServico = new TTextField(5, 1);
    TTextField textCodigoForma = new TTextField(5, 1);
    TTextField textParcela = new TTextField(3, 1);
    TTextField textDataParcela = new TTextField(10, 4);
    TTextField textValorParcela = new TTextField(10, 2);
    TTextField textSubTotal = new TTextField(10, 2);
    TextFieldImposto textPercIrrf = new TextFieldImposto(10, 2, 4);
    TextFieldImposto textPercIss = new TextFieldImposto(10, 2, 4);
    TextFieldImposto textPercPis = new TextFieldImposto(10, 2, 4);
    TextFieldImposto textPercCsll = new TextFieldImposto(10, 2, 4);
    TextFieldImposto textPercCofins = new TextFieldImposto(10, 2, 4);
    TextFieldImposto textPercInss = new TextFieldImposto(10, 2, 4);
    TextFieldImposto textPercIssRetido = new TextFieldImposto(10, 2, 4);
    TextFieldImposto textPercInssRetido = new TextFieldImposto(10, 2, 4);
    TextFieldImposto textPercCofinsRetido = new TextFieldImposto(10, 2, 4);
    TextFieldImposto textPercCsllRetido = new TextFieldImposto(10, 2, 4);
    TextFieldImposto textPercIrrfRetido = new TextFieldImposto(10, 2, 4);
    TextFieldImposto textPercPisRetido = new TextFieldImposto(10, 2, 4);
    private Border titled = BorderFactory.createTitledBorder("");
    private static TTextField textFilial = new TTextField(8, 1);
    private JButton buttonBuscaFilial = ComponenteFactory.novoJButton(this, true);
    private JLabel labelFilial = ComponenteFactory.novoJLabel("Filial:", 'f', null, textFilial);
    private JLabel labelValorFilial = ComponenteFactory.novoJLabel("", new Dimension(100, 20), this.titled);
    JLabel labelSerie = ComponenteFactory.novoJLabel("S\u00e9rie:", 'r', null, this.textCodigoSerie);
    JLabel labelDescSerie = new JLabel();
    JLabel labelDataHora = new JLabel();
    JLabel labelNumeroNota = new JLabel("N\u00famero:");
    JLabel labelDataEmissao = new JLabel("Data emiss\u00e3o:");
    JLabel labelTipoCadastro = new JLabel("Cadastro:");
    JLabel labelCadastro = new JLabel();
    JLabel labelIrrf = new JLabel("IRRF:");
    JLabel labelIss = new JLabel("ISSQN:");
    JLabel labelPis = new JLabel("PIS:");
    JLabel labelCsll = new JLabel("CSLL:");
    JLabel labelCofins = new JLabel("COFINS:");
    JLabel labelInss = new JLabel("INSS:");
    JLabel labelIssRetido = new JLabel("ISS Ret.:");
    JLabel labelInssRetido = new JLabel("INSS Ret.:");
    JLabel labelCofinsRetido = new JLabel("COFINS Ret.:");
    JLabel labelCsllRetido = new JLabel("CSLL Ret.:");
    JLabel labelIrrfRetido = new JLabel("IRRF Ret.:");
    JLabel labelPisRetido = new JLabel("PIS Ret.:");
    JLabel labelImpostosSobre = new JLabel("", 0);
    JLabel labelTotalImpostos = ComponenteFactory.novoJLabel("", new Dimension(65, 20), new TitledBorder(""));
    JLabel labelTotal = ComponenteFactory.novoJLabel("", new Dimension(80, 20), new TitledBorder(""));
    JLabel labelServico = new JLabel("Servi\u00e7o:");
    JLabel labelDescServico = new JLabel();
    JLabel labelForma = ComponenteFactory.novoJLabel("Forma Pagto:", 'g', null, this.textCodigoForma);
    JLabel labelDescForma = new JLabel();
    JLabel labelParcela = new JLabel("Parcela");
    JLabel labelVencimentoParcela = new JLabel("Vencimento");
    JLabel labelValorParcela = new JLabel("Valor");
    JLabel labelComposicao = new JLabel("[Composi\u00e7\u00e3o]");
    TAvisoLabel labelDescStatusNota = new TAvisoLabel();
    JLabel labelStatusNota = new JLabel("Status: ");
    JPanel panelImpostos = new JPanel(new GridBagLayout());
    JPanel panelServicos = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Servi\u00e7os"));
    JPanel panelParcelas = ComponenteFactory.novoJPanel(new GridBagLayout(), new TitledBorder("Parcelas"));
    JComboBox comboTipoCadastro = new JComboBox<TipoCadastro>(new TipoCadastro[]{TipoCadastro.PACIENTE, TipoCadastro.CONVENIO, TipoCadastro.EMPRESA});
    ModeloGridTable modeloParcela = new ModeloGridTable(new String[]{"Parc.", "Vencimento", "Bruto", "L\u00edquido"});
    JTable tableParcela = new JTable(this.modeloParcela);
    JPopupMenu menuComposicao = new JPopupMenu();
    JMenuItem itemComposicaoMostrar = new JMenuItem("Mostrar Composi\u00e7\u00e3o");
    JMenuItem itemComposicaoMostrarECopiar = new JMenuItem("Mostrar Composi\u00e7\u00e3o e Copiar p/ Observa\u00e7\u00e3o");
    JMenuItem itemComposicaoCopiar = new JMenuItem("Copiar Composi\u00e7\u00e3o p/ \u00c1rea de Transfer\u00eancia");
    JPopupMenu menuOpcoesNfse = new JPopupMenu();
    JMenuItem itemEnviarEmail = new JMenuItem("Enviar E-mail");
    JMenuItem itemBaixarXML = new JMenuItem("Baixar XML");
    JMenuItem itemBaixarPDF = new JMenuItem("Baixar PDF");
    private JMenu menuDadosAutomaticos = new JMenu("Dados autom\u00e1ticos");
    private JMenuItem itemDescricaoExames = new JMenuItem("Descri\u00e7\u00e3o dos exames");
    private JMenuItem itemDescricaoExamesAmb = new JMenuItem("Descri\u00e7\u00e3o dos exames + AMB");
    private JMenuItem itemDescricaoExamesValor = new JMenuItem("Descri\u00e7\u00e3o dos exames + valores em reais");
    private JMenuItem itemDescricaoExamesAmbValor = new JMenuItem("Descri\u00e7\u00e3o dos exames + AMB + valores em reais");
    private JMenuItem itemNumeroRequisicao = new JMenuItem("N\u00famero da requisi\u00e7\u00e3o");
    private JMenuItem itemFormaPagamento = new JMenuItem("Forma de pagamento");
    private JMenuItem itemNomePacienteCPFNascimento = new JMenuItem("Nome do paciente + CPF/Data de nascimento");
    JTextArea textObs = new JTextArea(new TTextAreaDocument(500));
    JPopupMenu pop = new JPopupMenu();
    JMenuItem itemParcela = ComponenteFactory.novoJMenuItem(this.pop, "Editar parcela", (ActionListener)this);
    JMenuItem itemPlano = ComponenteFactory.novoJMenuItem(this.pop, "Editar plano de contas/centro de custos", (ActionListener)this);
    JMenuItem itemNumeroTipo = ComponenteFactory.novoJMenuItem(this.pop, "Editar o n\u00famero e tipo do t\u00edtulo da parcela", (ActionListener)this);
    private String[] faturasAnexas = null;
    private boolean[] faturasConferidas = null;
    private int status = 1;
    private String resumo = "";
    private AbstractThreadVO cadastroVO = null;
    private Set<LancamentoBean> lancamentosPagamentos = null;
    private String nomePagador = null;
    private String cpfPagador = null;
    private static int tipoTela = 3;
    private static NotaFiscalBean retorno = null;
    private ServicoVO servico = null;
    private String filaImpressaoNfse = null;
    private static boolean isNotaFiscalEletronicaAtivada = false;
    private static boolean isOK = false;
    private static boolean isAguardando = false;
    private static boolean isEmailEnviado = false;
    private List<RequisicaoBean> requisicoesBean = null;
    private Set<FaturaNotaFiscalBean> listaFaturasAssociadas = null;
    private Timer timerTela = null;
    private Timer timer = null;
    private int intervaloFecharTela = 60000;
    private CronometroRegressivo cron = null;
    private static DialogNotaFiscalSaida dialog = null;
    private int contadorTimer = 0;
    private boolean acessoEnviarEmail = Acesso.getAcesso(NotaFiscalSaida.getAcessoEmail());
    private ArrayList<ReceberPagarBean> listaPreviasFaturamento = null;
    private String filialAtual = null;
    private ArrayList<NotaFiscalBean> notasPendentes = null;
    private boolean isCadastroValidado = true;
    private Window telaPai = null;
    private static SeriesVO serie = null;
    public boolean verificaButtonServicoClickado = false;

    public static DialogNotaFiscalSaida novaInstancia(Window pai, boolean isPessoaFisica, ArrayList<ReceberPagarBean> listaPreviasFaturamento) {
        return NotaFiscalSaida.novaInstancia(pai, isPessoaFisica, listaPreviasFaturamento, Variaveis.filialPadrao);
    }

    public static DialogNotaFiscalSaida novaInstancia(Window pai, boolean isPessoaFisica, ArrayList<ReceberPagarBean> listaPreviasFaturamento, String filial) {
        tipoTela = isPessoaFisica ? 2 : 1;
        retorno = null;
        textFilial.setText(filial);
        try {
            serie = (SeriesVO)new SeriesService().getVO(filial, ParametrosLocais.getParametro("serie"));
            if (serie == null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A s\u00e9rie padr\u00e3o n\u00e3o est\u00e1 configurada para a esta\u00e7\u00e3o.", 2);
                return null;
            }
            if (NotaFiscalSaida.isNotaFiscalEletronicaAtivada(serie) && Funcoes.textoVazio(ParametrosLocais.getParametro("tempoRetornoNfse"))) {
                ParametrosLocais.setParametro(ParametrosLocais.getParametro("tempoRetornoNfse"), "0");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return null;
        }
        dialog = new DialogNotaFiscalSaida(pai, "Nota fiscal de sa\u00edda");
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setSize(new Dimension(780, 550));
        dialog.setLocationRelativeTo(pai);
        NotaFiscalSaida notaSaida = new NotaFiscalSaida(dialog, serie, listaPreviasFaturamento, filial);
        dialog.setNotaFiscalSaida(notaSaida);
        dialog.setContentPane(notaSaida);
        notaSaida.setBorder(ScreenUtil.criarBordaVazia());
        dialog.validate();
        return dialog;
    }

    private static boolean isNotaFiscalEletronicaAtivada(SeriesVO serie) {
        isNotaFiscalEletronicaAtivada = NotaFiscalService.isGerarNotaFiscalEletronica(serie);
        return isNotaFiscalEletronicaAtivada;
    }

    private static boolean enviarEmailAtivo() {
        if (Funcoes.textoVazio(textFilial.getText())) {
            return false;
        }
        FilialBean filialBean = null;
        try {
            filialBean = (FilialBean)new FilialService().get(textFilial.getText());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar dados da filial.\n" + e.getMessage(), e.getStackTrace());
        }
        return filialBean != null && filialBean.getEmailNFSe() != false;
    }

    public static DialogNotaFiscalSaida novaInstancia(Window pai, NotaFiscalBean nota, Integer codigoRequisicao, boolean isPessoaFisica, ArrayList<ReceberPagarBean> listaPreviasFaturamento, String filial) {
        tipoTela = isPessoaFisica ? 2 : 1;
        retorno = nota;
        SeriesVO serie = null;
        try {
            serie = (SeriesVO)new SeriesService().getVO(nota.getFilial().getCodigo().toString(), ParametrosLocais.getParametro("serie"));
            if (serie == null) {
                throw new Exception("A s\u00e9rie padr\u00e3o n\u00e3o est\u00e1 configurada para a esta\u00e7\u00e3o.");
            }
            if (NotaFiscalSaida.isNotaFiscalEletronicaAtivada(serie) && Funcoes.textoVazio(ParametrosLocais.getParametro("tempoRetornoNfse"))) {
                ParametrosLocais.setParametro(ParametrosLocais.getParametro("tempoRetornoNfse"), "0");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
            return null;
        }
        dialog = new DialogNotaFiscalSaida(pai, "Nota fiscal de sa\u00edda ");
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setSize(new Dimension(740, 550));
        dialog.setLocationRelativeTo(pai);
        NotaFiscalSaida notaSaida = new NotaFiscalSaida(dialog, serie, listaPreviasFaturamento, filial);
        notaSaida.setSubTotal(nota.getSubTotal());
        notaSaida.preencheDados(nota, codigoRequisicao, listaPreviasFaturamento);
        dialog.setNotaFiscalSaida(notaSaida);
        dialog.setContentPane(notaSaida);
        notaSaida.setBorder(ScreenUtil.criarBordaVazia());
        dialog.validate();
        return dialog;
    }

    private void preencheDados(NotaFiscalBean nota, Integer codigoRequisicao, ArrayList<ReceberPagarBean> listaPrevias) {
        if (nota == null) {
            return;
        }
        retorno = nota;
        textFilial.setText(String.valueOf(nota.getFilial().getCodigo()));
        this.labelValorFilial.setText(nota.getFilial().getDescricao());
        this.labelDataHora.setText(nota.getUsuario().getCodigo() + " em " + Funcoes.formataData("dd/MM/yyyy", nota.getDataHora()));
        this.textCodigoSerie.setText(nota.getSerie().getCodigo());
        this.labelDescSerie.setText(nota.getSerie().getDescricao());
        this.textDataEmissao.setText(Funcoes.formataData("dd/MM/yyyy", nota.getDataEmissao()));
        String tipoCadastro = Tipos.tipoCadastro(nota.getTipoCadastro());
        for (int i = 0; i < this.comboTipoCadastro.getItemCount(); ++i) {
            if (!this.comboTipoCadastro.getItemAt(i).toString().equalsIgnoreCase(tipoCadastro)) continue;
            this.comboTipoCadastro.setSelectedIndex(i);
            break;
        }
        if (tipoTela == 2) {
            this.textCodigoCadastro.setText(nota.getPaciente().getCodigo().toString());
            this.labelCadastro.setText(nota.getPaciente().getNome());
            this.cadastroVO = nota.getPaciente();
        } else if (nota.getConvenio() != null) {
            this.comboTipoCadastro.setSelectedItem("O");
            this.textCodigoCadastro.setText(nota.getConvenio().getCodigo().toString());
            this.labelCadastro.setText(nota.getConvenio().getFantasia());
            this.cadastroVO = nota.getConvenio();
        } else if (nota.getEntidade() != null) {
            this.comboTipoCadastro.setSelectedItem(nota.getEntidade().getTipo());
            this.textCodigoCadastro.setText(nota.getEntidade().getCodigo().toString());
            this.labelCadastro.setText(nota.getEntidade().getRazaoSocial());
            this.cadastroVO = nota.getEntidade();
        }
        this.textObs.setText(nota.getObservacao());
        if (nota.getNumero() != null) {
            this.textNumeroNota.setText(nota.getNumero().toString());
        }
        NotaFiscalSaida.isNotaFiscalEletronicaAtivada(nota.getSerie());
        if (isNotaFiscalEletronicaAtivada) {
            this.alteraStatusLabel(nota);
        }
        this.textCodigoServico.setText(nota.getServico().getServico().getCodigo().toString());
        this.labelDescServico.setText(nota.getServico().getServico().getDescricao());
        this.servico = nota.getServico().getServico();
        if (codigoRequisicao != null) {
            HashMap<String, Object> chaves = new HashMap<String, Object>();
            chaves.put("fil_codigo", nota.getFilial().getCodigo());
            chaves.put("req_codigo", codigoRequisicao);
            try {
                RequisicaoBean requisicaoBean = (RequisicaoBean)new RequisicaoService().getBean(chaves);
                List<RequisicaoBean> requisicoes = Arrays.asList(requisicaoBean);
                this.setRequisicaoBean(requisicoes);
                Set<RequisicaoLanctoCaixaBean> reqLanctos = new RequisicaoLanctoCaixaService().getBeans(chaves);
                if (reqLanctos != null) {
                    this.lancamentosPagamentos = new HashSet<LancamentoBean>();
                    for (RequisicaoLanctoCaixaBean aux : reqLanctos) {
                        this.lancamentosPagamentos.add((LancamentoBean)new LancamentoService().get(aux.getFilial().getCodigo().toString(), aux.getLancamento().getCodigo().toString(), aux.getLancamento().getEstacao().getCodigo().toString()));
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar os lan\u00e7amentos de caixa.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        this.textSubTotal.setText(Funcoes.formataDecimal(nota.getSubTotal()));
        this.atualizaImpostos(nota);
        this.textCodigoForma.setText(nota.getFormaPagamento().getCodigo().toString());
        this.labelDescForma.setText(nota.getFormaPagamento().getDescricao());
        if (nota.getParcelas() != null) {
            for (ReceberPagarBean aux : nota.getParcelas()) {
                this.modeloParcela.addLine(new Object[]{aux.getParcela(), Funcoes.formataData(aux.getDataVencimento()), Funcoes.formataDecimal(aux.getValor()), Funcoes.formataDecimal(aux.getValorTotal()), aux});
            }
            this.modeloParcela.ordenarColuna(0);
        }
        HashSet<FaturaNotaFiscalBean> listaFaturasAux = new HashSet<FaturaNotaFiscalBean>();
        for (FaturaNotaFiscalBean fatura : nota.getFaturasNotaFiscal()) {
            ArrayList<ReceberPagarBean> listaPreviasFaturamento = null;
            try {
                listaPreviasFaturamento = new FaturaReceberPagarService().getListaPreviasFaturamentoBean(fatura.getFatura().getFilial().getCodigo().toString(), fatura.getFatura().getCodigo().toString());
            }
            catch (Exception e1) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar lista de pr\u00e9vias de recebimento do faturamento.\n" + e1.getMessage(), e1.getStackTrace());
                return;
            }
            fatura.setListaPrevias(listaPreviasFaturamento);
            listaFaturasAux.add(fatura);
        }
        this.listaFaturasAssociadas = listaFaturasAux != null && listaFaturasAux.size() > 0 ? listaFaturasAux : null;
        if (nota.getNumero() != null) {
            this.setStatus(1);
            this.controlaCampos();
        }
        this.controlaCamposNfse();
        this.bloquearMudancaSerieNotaFiscal(nota);
    }

    private void bloquearMudancaSerieNotaFiscal(NotaFiscalBean nota) {
        if (nota != null) {
            if (!(nota == null || nota.getSituacao() == null || nota.getSituacao().equalsIgnoreCase("R") || nota.getSituacao().equalsIgnoreCase("X") || nota.getSituacao().equalsIgnoreCase("O"))) {
                this.textCodigoSerie.setEnabled(false);
                this.buttonBuscaSerie.setEnabled(false);
                ScreenUtil.requisitarFoco(this.textDataEmissao);
            } else {
                this.validaBloqueioMudancaSerieNotaFiscal(nota.getSerie());
            }
        }
    }

    private void validaBloqueioMudancaSerieNotaFiscal(SeriesVO serie) {
        boolean possuiAcesso = false;
        if (tipoTela == 2) {
            possuiAcesso = Acesso.getAcesso(ImprimirNotaFiscalPessoaFisica.getBloqueiaAlteracaoSerie());
        } else if (tipoTela == 3 || tipoTela == 1) {
            possuiAcesso = Acesso.getAcesso(NotaFiscalSaida.getBloqueiaAlteracaoSerie());
        }
        if (possuiAcesso) {
            if (serie != null) {
                this.textCodigoSerie.setEnabled(false);
                this.buttonBuscaSerie.setEnabled(false);
                ScreenUtil.requisitarFoco(this.textDataEmissao);
            } else {
                this.textCodigoSerie.setEnabled(true);
                this.buttonBuscaSerie.setEnabled(true);
            }
        }
    }

    public NotaFiscalBean getRetorno() {
        return retorno;
    }

    public int getIntervaloFecharTela() {
        return this.intervaloFecharTela;
    }

    public void setFaturasConferidas(boolean[] faturasConferidas) {
        this.faturasConferidas = faturasConferidas;
    }

    private NotaFiscalSaida(Frame owner, SeriesVO serie, ArrayList<ReceberPagarBean> listaPreviasFaturamento) {
        this.montaTela();
        this.limparCampos(true);
        this.preencheDados(serie);
        this.listaPreviasFaturamento = listaPreviasFaturamento;
    }

    private NotaFiscalSaida(Dialog owner, SeriesVO serie, ArrayList<ReceberPagarBean> listaPreviasFaturamento, String filial) {
        this.montaTela();
        this.limparCampos(true);
        this.preencheDados(serie);
        textFilial.setText(filial);
        this.listaPreviasFaturamento = listaPreviasFaturamento;
    }

    public NotaFiscalSaida() {
        tipoTela = 3;
        try {
            serie = (SeriesVO)new SeriesService().getVO(Variaveis.filialPadrao, ParametrosLocais.getParametro("serie"));
            if (NotaFiscalSaida.isNotaFiscalEletronicaAtivada(serie) && Funcoes.textoVazio(ParametrosLocais.getParametro("tempoRetornoNfse"))) {
                ParametrosLocais.setParametro(ParametrosLocais.getParametro("tempoRetornoNfse"), "0");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        this.limparCampos(true);
        this.montaTela();
    }

    private void abrirPopupComposicao() {
        Point p = this.labelComposicao.getLocation();
        p.x += this.labelComposicao.getWidth() / 2;
        p.y -= 36;
        this.menuComposicao.show(this.labelComposicao, p.x, p.y);
    }

    private void abrirPopupOpcoesNfse() {
        Point p = this.buttonOpcoesNfse.getLocation();
        p.x = this.buttonOpcoesNfse.getWidth();
        p.y -= this.menuOpcoesNfse.getHeight();
        this.menuOpcoesNfse.show(this.buttonOpcoesNfse, p.x, p.y);
    }

    public static long getModuloAcesso() {
        return 100729472L;
    }

    public static long getAcessoEmail() {
        return 100729473L;
    }

    public static long getBloqueiaAlteracaoSerie() {
        return 100729474L;
    }

    private void montaListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (NotaFiscalSaida.this.getParent() != null) {
                    NotaFiscalSaida.this.getParent().removeAll();
                }
            }
        });
        this.itemComposicaoCopiar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringSelection sel = new StringSelection(NotaFiscalSaida.this.getComposicao(NotaFiscalSaida.this.getBeanPreenchido()));
                Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                clip.setContents(sel, NotaFiscalSaida.this);
            }
        });
        this.itemComposicaoMostrar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogComposicao.invocaTela((Window)NotaFiscalSaida.this.getTopLevelAncestor(), NotaFiscalSaida.this.getBeanPreenchido());
            }
        });
        this.itemComposicaoMostrarECopiar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogComposicao.invocaTela((Window)NotaFiscalSaida.this.getTopLevelAncestor(), NotaFiscalSaida.this.getBeanPreenchido());
                String composicao = NotaFiscalSaida.this.getComposicao(NotaFiscalSaida.this.getBeanPreenchido());
                NotaFiscalSaida.this.textObs.setText(composicao + " " + NotaFiscalSaida.this.textObs.getText());
            }
        });
        this.tableParcela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    if (NotaFiscalSaida.this.tableParcela.getSelectedRow() > -1) {
                        int x = NotaFiscalSaida.this.tableParcela.getColumnModel().getColumn(NotaFiscalSaida.this.tableParcela.getSelectedColumn()).getWidth();
                        int y = NotaFiscalSaida.this.tableParcela.getSelectedRow() * 18;
                        NotaFiscalSaida.this.pop.show(NotaFiscalSaida.this.tableParcela, x, y);
                    }
                } else if (e.getKeyCode() == 127) {
                    Funcoes.mensagem(NotaFiscalSaida.this, "N\u00e3o \u00e9 poss\u00edvel excluir parcelas.\nPara alterar o parcelamento, altere a forma de pagamento.", 2);
                }
            }
        });
        this.tableParcela.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    NotaFiscalSaida.this.editarParcelas(NotaFiscalSaida.this.tableParcela.getSelectedRow());
                }
            }
        });
        this.textCodigoSerie.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    NotaFiscalSaida.this.pesquisaSerie();
                }
            }
        });
        textFilial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    NotaFiscalSaida.this.buscaFilial();
                }
            }
        });
        this.textCodigoServico.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    NotaFiscalSaida.this.pesquisaServico();
                }
            }
        });
        this.textCodigoForma.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    NotaFiscalSaida.this.pesquisaFormaPagto();
                }
            }
        });
        this.textCodigoCadastro.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    NotaFiscalSaida.this.pesquisaCadastro();
                }
            }
        });
        this.textDataEmissao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(NotaFiscalSaida.this.textDataEmissao, NotaFiscalSaida.this.buttonBuscaDataEmissao, (JPanel)NotaFiscalSaida.this.textDataEmissao.getParent(), true);
                }
            }
        });
        this.textDataParcela.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(NotaFiscalSaida.this.textDataParcela, NotaFiscalSaida.this.buttonBuscaDataParcela, (JPanel)NotaFiscalSaida.this.textDataParcela.getParent(), true);
                }
            }
        });
        this.labelComposicao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NotaFiscalSaida.this.abrirPopupComposicao();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                NotaFiscalSaida.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                NotaFiscalSaida.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        textFilial.addFocusListener(this);
        this.textCodigoForma.addFocusListener(this);
        this.textCodigoCadastro.addFocusListener(this);
        this.textCodigoSerie.addFocusListener(this);
        this.textCodigoServico.addFocusListener(this);
        this.textParcela.addFocusListener(this);
        this.textSubTotal.addFocusListener(this);
        this.textPercCofins.addFocusListener(this);
        this.textPercCsll.addFocusListener(this);
        this.textPercInss.addFocusListener(this);
        this.textPercIrrf.addFocusListener(this);
        this.textPercIss.addFocusListener(this);
        this.textPercPis.addFocusListener(this);
        this.textPercIssRetido.addFocusListener(this);
        this.textPercInssRetido.addFocusListener(this);
        this.textPercCofinsRetido.addFocusListener(this);
        this.textPercCsllRetido.addFocusListener(this);
        this.textPercIrrfRetido.addFocusListener(this);
        this.textPercPisRetido.addFocusListener(this);
    }

    private void montaTela() {
        this.setLayout(new BorderLayout());
        textFilial.setText(Variaveis.filialPadrao);
        this.getDescricaoFilial(textFilial.getText());
        this.montaListeners();
        this.setStatus(tipoTela == 2 || tipoTela == 1 ? 2 : 1);
        if (tipoTela == 2) {
            this.comboTipoCadastro.setSelectedItem((Object)TipoCadastro.PACIENTE);
        } else {
            this.comboTipoCadastro.setSelectedItem((Object)TipoCadastro.CONVENIO);
        }
        JPanel panelCentral = new JPanel(new GridBagLayout());
        this.add((Component)panelCentral, "Center");
        panelCentral.setBorder(ScreenUtil.criarBordaVazia());
        JPanel panelBotoes = new JPanel(new BorderLayout());
        this.add((Component)panelBotoes, "South");
        if (tipoTela == 3) {
            panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonNovo, this.buttonEditar, this.buttonSalvar, this.buttonSincronizar, this.buttonCancelar, this.buttonFechar), "East");
        } else if (tipoTela == 1) {
            panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonSalvar, this.buttonCancelar, this.buttonFechar), "East");
        } else {
            panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonSalvar, this.buttonCancelar), "East");
        }
        panelBotoes.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, this.buttonImprimir, this.buttonOpcoesNfse, this.buttonAssociarFaturas), "West");
        if (tipoTela == 2) {
            Funcoes.criaBarraDescricao(this, "Nota Fiscal de Pessoa F\u00edsica", "Emiss\u00e3o e impress\u00e3o de notas fiscais de pessoa f\u00edsica", "financeiro/nota_fiscal_fisica.jpg");
        } else {
            Funcoes.criaBarraDescricao(this, "Nota Fiscal de Pessoa Jur\u00eddica", "Emiss\u00e3o e impress\u00e3o de notas fiscais de pessoa jur\u00eddica", "financeiro/imprimir_nota_fiscal.jpg");
        }
        ScreenUtil.setBorda(new Component[]{this.labelDescSerie, this.labelDataHora, this.labelCadastro, this.labelDescForma, this.labelDescServico}, new TitledBorder(""));
        try {
            if (!new PlanoContaService().haPlanosContas(textFilial.getText()) && !new CentroCustoService().haCentrosCusto(textFilial.getText())) {
                this.pop.remove(this.itemPlano);
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar informa\u00e7\u00f5es sobre plano de contas e centro de custo.", e.getStackTrace());
        }
        this.modeloParcela.setColumnSize(new int[]{40, 90, 0, 0}, this.tableParcela);
        this.textCodigoSerie.setUpperCase(true);
        this.menuComposicao.add(this.itemComposicaoMostrar);
        this.menuComposicao.add(this.itemComposicaoMostrarECopiar);
        this.menuComposicao.add(this.itemComposicaoCopiar);
        this.menuOpcoesNfse.add(this.itemEnviarEmail);
        this.menuOpcoesNfse.add(this.itemBaixarXML);
        this.menuOpcoesNfse.add(this.itemBaixarPDF);
        this.itemEnviarEmail.addActionListener(this);
        this.itemBaixarXML.addActionListener(this);
        this.itemBaixarPDF.addActionListener(this);
        if (tipoTela == 2) {
            this.menuOpcoesNfse.add(this.menuDadosAutomaticos);
            this.menuDadosAutomaticos.add(this.itemDescricaoExames);
            this.menuDadosAutomaticos.add(this.itemDescricaoExamesAmb);
            this.menuDadosAutomaticos.add(this.itemDescricaoExamesValor);
            this.menuDadosAutomaticos.add(this.itemDescricaoExamesAmbValor);
            this.menuDadosAutomaticos.add(this.itemNumeroRequisicao);
            this.menuDadosAutomaticos.add(this.itemFormaPagamento);
            this.menuDadosAutomaticos.add(this.itemNomePacienteCPFNascimento);
            this.itemDescricaoExames.addActionListener(this);
            this.itemDescricaoExamesAmb.addActionListener(this);
            this.itemDescricaoExamesValor.addActionListener(this);
            this.itemDescricaoExamesAmbValor.addActionListener(this);
            this.itemNumeroRequisicao.addActionListener(this);
            this.itemFormaPagamento.addActionListener(this);
            this.itemNomePacienteCPFNascimento.addActionListener(this);
        }
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        if (tipoTela == 3) {
            panelCentral.add((Component)this.labelFilial, c);
            ++c.gridx;
            textFilial.setPreferredSize(new Dimension(90, 20));
            textFilial.setMinimumSize(new Dimension(90, 20));
            ScreenUtil.requisitarFoco(textFilial);
            panelCentral.add((Component)textFilial, c);
            ++c.gridx;
            this.buttonBuscaFilial.setPreferredSize(new Dimension(20, 20));
            this.buttonBuscaFilial.setMinimumSize(new Dimension(20, 20));
            panelCentral.add((Component)this.buttonBuscaFilial, c);
            ++c.gridx;
            c.gridwidth = 4;
            c.fill = 2;
            this.labelValorFilial.setPreferredSize(new Dimension(90, 20));
            this.labelValorFilial.setMinimumSize(new Dimension(90, 20));
            panelCentral.add((Component)this.labelValorFilial, c);
            c.gridx = 0;
            c.gridy = 1;
        }
        c.fill = 17;
        panelCentral.add((Component)this.labelSerie, c);
        ++c.gridx;
        this.textCodigoSerie.setPreferredSize(new Dimension(90, 20));
        this.textCodigoSerie.setMinimumSize(new Dimension(90, 20));
        panelCentral.add((Component)this.textCodigoSerie, c);
        ++c.gridx;
        this.buttonBuscaSerie.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaSerie.setMinimumSize(new Dimension(20, 20));
        panelCentral.add((Component)this.buttonBuscaSerie, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.insets = new Insets(0, 0, 0, 2);
        this.labelDescSerie.setPreferredSize(new Dimension(20, 20));
        this.labelDescSerie.setMinimumSize(new Dimension(20, 20));
        panelCentral.add((Component)this.labelDescSerie, c);
        c.gridx += 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 2;
        this.labelDataHora.setPreferredSize(new Dimension(200, 20));
        this.labelDataHora.setMinimumSize(new Dimension(200, 20));
        panelCentral.add((Component)this.labelDataHora, c);
        ++c.gridy;
        c.gridx = 0;
        c.insets = new Insets(2, 0, 0, 0);
        this.labelDataEmissao.setLabelFor(this.textDataEmissao);
        this.labelDataEmissao.setDisplayedMnemonic('D');
        panelCentral.add((Component)this.labelDataEmissao, c);
        ++c.gridx;
        this.textDataEmissao.setPreferredSize(new Dimension(90, 20));
        this.textDataEmissao.setMinimumSize(new Dimension(90, 20));
        panelCentral.add((Component)this.textDataEmissao, c);
        ++c.gridx;
        this.buttonBuscaDataEmissao.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaDataEmissao.setMinimumSize(new Dimension(20, 20));
        panelCentral.add((Component)this.buttonBuscaDataEmissao, c);
        c.gridx += 3;
        this.labelStatusNota.setPreferredSize(new Dimension(30, 20));
        this.labelStatusNota.setHorizontalAlignment(4);
        panelCentral.add((Component)this.labelStatusNota, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.fill = 2;
        this.labelDescStatusNota.setPreferredSize(new Dimension(300, 20));
        this.labelDescStatusNota.setMinimumSize(new Dimension(300, 20));
        this.labelDescStatusNota.setBorder(new TitledBorder(""));
        panelCentral.add((Component)this.labelDescStatusNota, c);
        c.gridx -= 3;
        c.fill = 0;
        c.insets = new Insets(2, 20, 0, 0);
        this.labelNumeroNota.setLabelFor(this.textNumeroNota);
        this.labelNumeroNota.setDisplayedMnemonic('p');
        panelCentral.add((Component)this.labelNumeroNota, c);
        ++c.gridx;
        c.insets = new Insets(2, 0, 0, 0);
        c.gridwidth = 2;
        c.weightx = 0.0;
        this.textNumeroNota.setPreferredSize(new Dimension(70, 20));
        this.textNumeroNota.setMinimumSize(new Dimension(70, 20));
        panelCentral.add((Component)this.textNumeroNota, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelTipoCadastro.setLabelFor(this.comboTipoCadastro);
        this.labelTipoCadastro.setDisplayedMnemonic('a');
        panelCentral.add((Component)this.labelTipoCadastro, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.comboTipoCadastro.setPreferredSize(new Dimension(110, 20));
        this.comboTipoCadastro.setMinimumSize(new Dimension(110, 20));
        panelCentral.add((Component)this.comboTipoCadastro, c);
        c.gridx += 2;
        c.gridwidth = 1;
        this.textCodigoCadastro.setPreferredSize(new Dimension(70, 20));
        this.textCodigoCadastro.setMinimumSize(new Dimension(70, 20));
        panelCentral.add((Component)this.textCodigoCadastro, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.buttonBuscaCadastro.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaCadastro.setMinimumSize(new Dimension(20, 20));
        panelCentral.add((Component)this.buttonBuscaCadastro, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 3;
        this.labelCadastro.setMinimumSize(new Dimension(20, 20));
        this.labelCadastro.setPreferredSize(new Dimension(20, 20));
        panelCentral.add((Component)this.labelCadastro, c);
        JPanel panelServico = new JPanel(new GridBagLayout());
        panelServico.setBorder(new TitledBorder(""));
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 17;
        g.gridx = 0;
        g.gridy = 0;
        this.labelServico.setLabelFor(this.textCodigoServico);
        this.labelServico.setDisplayedMnemonic('v');
        panelServico.add((Component)this.labelServico, g);
        ++g.gridx;
        this.textCodigoServico.setPreferredSize(new Dimension(70, 20));
        this.textCodigoServico.setMinimumSize(new Dimension(70, 20));
        panelServico.add((Component)this.textCodigoServico, g);
        ++g.gridx;
        this.buttonBuscaServico.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaServico.setMinimumSize(new Dimension(20, 20));
        panelServico.add((Component)this.buttonBuscaServico, g);
        ++g.gridx;
        g.fill = 2;
        g.weightx = 1.0;
        this.labelDescServico.setPreferredSize(new Dimension(20, 20));
        this.labelDescServico.setMinimumSize(new Dimension(20, 20));
        panelServico.add((Component)this.labelDescServico, g);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 7;
        c.fill = 2;
        c.insets = new Insets(5, 0, 5, 0);
        panelCentral.add((Component)panelServico, c);
        JPanel panelTotais = new JPanel(new BorderLayout());
        this.textSubTotal.setPreferredSize(new Dimension(90, 20));
        this.labelTotalImpostos.setHorizontalAlignment(4);
        this.labelTotal.setHorizontalAlignment(4);
        panelTotais.add((Component)ComponenteFactory.novoJPanelFlowLayout(0, 0, 0, new JLabel("Vl. Bruto:"), this.textSubTotal, new JLabel("   Impostos:"), this.labelTotalImpostos, new JLabel("   Vl. L\u00edquido:"), this.labelTotal), "West");
        this.buttonImpostos.setPreferredSize(new Dimension(120, 20));
        this.buttonImpostos.setFocusable(false);
        panelTotais.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, 0, 0, this.buttonImpostos), "East");
        ++c.gridy;
        c.insets = new Insets(0, 0, 5, 0);
        panelCentral.add((Component)panelTotais, c);
        Dimension d = new Dimension(80, 20);
        this.labelImpostosSobre.setPreferredSize(new Dimension(100, 20));
        this.textPercIrrf.setPreferredSize(d);
        this.textPercIrrf.setMinimumSize(d);
        this.textPercPis.setPreferredSize(d);
        this.textPercPis.setMinimumSize(d);
        this.textPercCsll.setPreferredSize(d);
        this.textPercCsll.setMinimumSize(d);
        this.textPercCofins.setPreferredSize(d);
        this.textPercCofins.setMinimumSize(d);
        this.textPercInss.setPreferredSize(d);
        this.textPercInss.setMinimumSize(d);
        this.textPercIss.setPreferredSize(d);
        this.textPercIss.setMinimumSize(d);
        this.textPercIssRetido.setPreferredSize(d);
        this.textPercIssRetido.setMinimumSize(d);
        this.textPercInssRetido.setMinimumSize(d);
        this.textPercCofinsRetido.setMinimumSize(d);
        this.textPercCsllRetido.setMinimumSize(d);
        this.textPercIrrfRetido.setMinimumSize(d);
        this.textPercPisRetido.setMinimumSize(d);
        g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 1;
        g.insets = new Insets(0, 10, 0, 0);
        this.panelImpostos.add((Component)new JLabel("Base c\u00e1lculo", 0), g);
        ++g.gridy;
        this.panelImpostos.add((Component)this.labelImpostosSobre, g);
        ++g.gridy;
        Font auxFont = this.labelComposicao.getFont();
        auxFont = auxFont.deriveFont(0, 10.0f);
        this.labelComposicao.setForeground(Color.RED);
        this.labelComposicao.setFont(auxFont);
        this.labelComposicao.setHorizontalAlignment(0);
        this.panelImpostos.add((Component)this.labelComposicao, g);
        this.panelImpostos.setBackground(ConstantesGerais.COR_FUNDO_CREME);
        this.panelImpostos.setPreferredSize(new Dimension(110, 160));
        g.gridy = 0;
        g.gridx = 1;
        c.weightx = 0.0;
        g.insets = new Insets(0, 20, 0, 0);
        g.fill = 2;
        this.panelImpostos.add((Component)this.labelCofins, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.labelCsll, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.labelInss, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.labelIrrf, g);
        g.gridy = 2;
        g.gridx = 1;
        g.insets = new Insets(10, 20, 0, 0);
        this.panelImpostos.add((Component)this.labelIss, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.labelPis, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.labelIssRetido, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.labelInssRetido, g);
        g.gridy = 4;
        g.gridx = 1;
        g.insets = new Insets(10, 20, 0, 0);
        this.panelImpostos.add((Component)this.labelCofinsRetido, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.labelCsllRetido, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.labelIrrfRetido, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.labelPisRetido, g);
        g.gridy = 0;
        g.gridx = 2;
        g.gridwidth = 1;
        g.insets = new Insets(0, 0, 0, 0);
        g.fill = 0;
        this.panelImpostos.add((Component)this.textPercCofins, g);
        ++g.gridx;
        this.panelImpostos.add((Component)new JLabel("%"), g);
        g.gridx += 2;
        this.panelImpostos.add((Component)this.textPercCsll, g);
        ++g.gridx;
        this.panelImpostos.add((Component)new JLabel("%"), g);
        g.gridx += 2;
        this.panelImpostos.add((Component)this.textPercInss, g);
        ++g.gridx;
        this.panelImpostos.add((Component)new JLabel("%"), g);
        g.gridx += 2;
        this.panelImpostos.add((Component)this.textPercIrrf, g);
        ++g.gridx;
        this.panelImpostos.add((Component)new JLabel("%"), g);
        g.gridy = 2;
        g.gridx = 2;
        g.insets = new Insets(10, 0, 0, 0);
        this.panelImpostos.add((Component)this.textPercIss, g);
        ++g.gridx;
        this.panelImpostos.add((Component)new JLabel("%"), g);
        g.gridx += 2;
        this.panelImpostos.add((Component)this.textPercPis, g);
        ++g.gridx;
        this.panelImpostos.add((Component)new JLabel("%"), g);
        g.gridx += 2;
        this.panelImpostos.add((Component)this.textPercIssRetido, g);
        ++g.gridx;
        this.panelImpostos.add((Component)new JLabel("%"), g);
        g.gridx += 2;
        g.fill = 2;
        this.panelImpostos.add((Component)this.textPercInssRetido, g);
        ++g.gridx;
        this.panelImpostos.add((Component)new JLabel("%"), g);
        g.gridy = 4;
        g.gridx = 2;
        g.insets = new Insets(10, 0, 0, 0);
        this.panelImpostos.add((Component)this.textPercCofinsRetido, g);
        ++g.gridx;
        this.panelImpostos.add((Component)new JLabel("%"), g);
        g.gridx += 2;
        this.panelImpostos.add((Component)this.textPercCsllRetido, g);
        ++g.gridx;
        this.panelImpostos.add((Component)new JLabel("%"), g);
        g.gridx += 2;
        this.panelImpostos.add((Component)this.textPercIrrfRetido, g);
        ++g.gridx;
        this.panelImpostos.add((Component)new JLabel("%"), g);
        g.gridx += 2;
        this.panelImpostos.add((Component)this.textPercPisRetido, g);
        ++g.gridx;
        this.panelImpostos.add((Component)new JLabel("%"), g);
        g.gridy = 1;
        g.gridx = 1;
        g.gridwidth = 3;
        g.insets = new Insets(0, 20, 0, 0);
        g.fill = 2;
        this.panelImpostos.add((Component)this.textValorCofins, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.textValorCsll, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.textValorInss, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.textValorIrrf, g);
        g.gridx += 3;
        g.weightx = 1.0;
        g.gridwidth = 1;
        this.panelImpostos.add((Component)new JLabel(), g);
        g.gridy = 3;
        g.gridx = 1;
        g.gridwidth = 3;
        g.weightx = 0.0;
        g.fill = 2;
        this.panelImpostos.add((Component)this.textValorIss, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.textValorPis, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.textValorIssRetido, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.textValorInssRetido, g);
        g.gridy = 5;
        g.gridx = 1;
        g.gridwidth = 3;
        g.weightx = 0.0;
        this.panelImpostos.add((Component)this.textValorCofinsRetido, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.textValorCsllRetido, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.textValorIrrfRetido, g);
        g.gridx += 3;
        this.panelImpostos.add((Component)this.textValorPisRetido, g);
        g.gridx += 3;
        g.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 7;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        panelCentral.add((Component)this.panelImpostos, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panelCentral.add((Component)this.labelForma, c);
        JPanel p = new JPanel(new GridBagLayout());
        g = new GridBagConstraints();
        this.textCodigoForma.setPreferredSize(new Dimension(69, 20));
        this.buttonBuscaForma.setPreferredSize(new Dimension(20, 20));
        this.labelDescForma.setPreferredSize(new Dimension(20, 20));
        g.gridx = 0;
        g.gridy = 0;
        p.add((Component)this.textCodigoForma, g);
        ++g.gridx;
        p.add((Component)this.buttonBuscaForma, g);
        ++g.gridx;
        g.weightx = 1.0;
        g.fill = 2;
        p.add((Component)this.labelDescForma, g);
        c.gridx = 1;
        c.gridwidth = 6;
        c.weightx = 1.0;
        panelCentral.add((Component)p, c);
        JPanel panelTemp = ComponenteFactory.novoJPanel(new BorderLayout(), null);
        p = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Parcelas"));
        this.montaPanelParcela(p);
        panelTemp.add((Component)p, "West");
        JPanel panelObs = ComponenteFactory.novoJPanel(new BorderLayout(), new TitledBorder("Observa\u00e7\u00e3o"));
        FilialVO filial = null;
        try {
            filial = (FilialVO)new FilialService().getVO(textFilial.getText());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        String configuracaoNfse = filial.getConfigNfse();
        int qtdeCaracteresCampoObservacao = 500;
        if (!Funcoes.textoVazio(configuracaoNfse) && !Funcoes.textoVazio(StringUtil.getValor(configuracaoNfse, "campoObs"))) {
            qtdeCaracteresCampoObservacao = Integer.parseInt(StringUtil.getValor(configuracaoNfse, "campoObs"));
        }
        this.textObs = new JTextArea(new TTextAreaDocument(qtdeCaracteresCampoObservacao));
        panelObs.add((Component)new JScrollPane(this.textObs), "Center");
        panelTemp.add((Component)panelObs, "Center");
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.gridwidth = 7;
        c.fill = 1;
        panelCentral.add((Component)panelTemp, c);
        this.textObs.setLineWrap(true);
        this.textObs.setWrapStyleWord(true);
        this.textValorIrrf.setEditable(false);
        this.textValorIss.setEditable(false);
        this.textValorPis.setEditable(false);
        this.textValorCsll.setEditable(false);
        this.textValorCofins.setEditable(false);
        this.textValorInss.setEditable(false);
        this.textValorIssRetido.setEditable(false);
        this.textValorInssRetido.setEditable(false);
        this.textValorCofinsRetido.setEditable(false);
        this.textValorCsllRetido.setEditable(false);
        this.textValorIrrfRetido.setEditable(false);
        this.textValorPisRetido.setEditable(false);
        this.textValorIrrf.setFocusable(false);
        this.textValorIss.setFocusable(false);
        this.textValorPis.setFocusable(false);
        this.textValorCsll.setFocusable(false);
        this.textValorCofins.setFocusable(false);
        this.textValorInss.setFocusable(false);
        this.textValorIssRetido.setFocusable(false);
        this.textValorInssRetido.setFocusable(false);
        this.textValorCofinsRetido.setFocusable(false);
        this.textValorCsllRetido.setFocusable(false);
        this.textValorIrrfRetido.setFocusable(false);
        this.textValorPisRetido.setFocusable(false);
        this.comboTipoCadastro.setEnabled(tipoTela != 2);
        this.textCodigoCadastro.setEnabled(tipoTela != 2);
        this.buttonBuscaCadastro.setEnabled(tipoTela != 2);
        this.labelForma.setVisible(tipoTela != 2);
        this.textCodigoForma.setVisible(tipoTela != 2);
        this.buttonBuscaForma.setVisible(tipoTela != 2);
        this.labelDescForma.setVisible(tipoTela != 2);
        this.textParcela.setEnabled(tipoTela != 2);
        this.textDataParcela.setEnabled(tipoTela != 2);
        this.buttonBuscaDataParcela.setEnabled(tipoTela != 2);
        this.textValorParcela.setEnabled(tipoTela != 2);
        this.buttonOKParcela.setEnabled(tipoTela != 2);
        this.buttonSincronizar.setVisible(false);
        this.controlaCamposNfse();
        this.inicializaParametroFecharTela();
        if (isNotaFiscalEletronicaAtivada) {
            this.inicializaCronometro();
        }
        isOK = false;
        isAguardando = false;
        this.controlaCampos();
        Funcoes.montaEnter((JComponent)this);
    }

    public void alterarBarraDescricao(String textoFormulario, String textoDescricao, String pathIcone) {
        Funcoes.criaBarraDescricao(this, textoFormulario, textoDescricao, pathIcone);
    }

    private void validaSeriePadraoBloqueioAcesso() {
        try {
            serie = (SeriesVO)new SeriesService().getVO(textFilial.getText(), ParametrosLocais.getParametro("serie"));
            if (serie == null) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "A s\u00e9rie padr\u00e3o n\u00e3o est\u00e1 configurada para a esta\u00e7\u00e3o.", 1);
                return;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        if (serie != null && serie.isRelacionarNfse().booleanValue() && !serie.isImprimirNota().booleanValue()) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "S\u00e9rie padr\u00e3o n\u00e3o gera nota fiscal eletr\u00f4nica.", 2);
            return;
        }
        this.preencheDados(serie);
        this.validaBloqueioMudancaSerieNotaFiscal(serie);
    }

    private void controlaCamposNfse() {
        if (isNotaFiscalEletronicaAtivada) {
            this.labelNumeroNota.setVisible(false);
            this.textNumeroNota.setVisible(false);
            this.labelStatusNota.setVisible(true);
            this.labelDescStatusNota.setVisible(true);
        } else {
            this.labelNumeroNota.setVisible(true);
            this.textNumeroNota.setVisible(true);
            this.labelStatusNota.setVisible(false);
            this.labelDescStatusNota.setVisible(false);
        }
    }

    private void inicializaParametroFecharTela() {
        if (Funcoes.textoVazio(ParametrosLocais.getParametro("tempoRetornoNfse"))) {
            ParametrosLocais.setParametro("tempoRetornoNfse", "0");
        }
        if (isNotaFiscalEletronicaAtivada && !Funcoes.textoVazio(ParametrosLocais.getParametro("tempoRetornoNfse")) && Integer.parseInt(ParametrosLocais.getParametro("tempoRetornoNfse")) > 0) {
            this.intervaloFecharTela = Integer.parseInt(ParametrosLocais.getParametro("tempoRetornoNfse")) * 1000;
        }
    }

    protected synchronized void atualizaTela() {
        NotaFiscalBean notaBean = retorno;
        NotaFiscalBean notaAux = null;
        try {
            if (notaBean != null && notaBean.getCodigo() != null && (notaAux = (NotaFiscalBean)new NotaFiscalService().get(String.valueOf(notaBean.getFilial().getCodigo()), notaBean.getCodigo().toString())) != null) {
                retorno = notaAux;
            }
        }
        catch (Exception e2) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar nota fiscal eletr\u00f4nica " + e2.getMessage(), e2.getStackTrace());
        }
        if (notaAux == null && notaBean != null) {
            notaAux = notaBean;
        }
        if (notaAux != null) {
            this.alteraStatusLabel(notaAux);
            if (notaAux.getSituacao().equalsIgnoreCase("A")) {
                this.cron.parar();
                if (tipoTela != 1 && tipoTela != 3) {
                    this.buttonCancelar.setText("Fechar");
                    this.buttonCancelar.setMnemonic('F');
                }
                this.controlaCampos();
                this.imprimir(notaAux);
                NotaFiscalBean beanNota = notaAux;
                if (NotaFiscalSaida.enviarEmailAtivo() && !isEmailEnviado) {
                    SwingUtilities.invokeLater(() -> {
                        if (!NotaFiscalService.enviarEmailNFSe(beanNota)) {
                            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel enviar o email.\n Verifique os dados do cadastro tomador.", 2);
                        } else {
                            isEmailEnviado = true;
                        }
                    });
                }
            } else if (notaAux.getSituacao().equalsIgnoreCase("E") || notaAux.getSituacao().equalsIgnoreCase("N") || notaAux.getSituacao().equalsIgnoreCase("R") || notaAux.getSituacao().equalsIgnoreCase("O")) {
                if (tipoTela != 1 && tipoTela != 3) {
                    this.buttonCancelar.setText("Cancelar");
                    this.buttonCancelar.setMnemonic('C');
                }
                this.cron.parar();
                isOK = false;
                isAguardando = false;
                this.inicializaCronometro();
                this.controlaCampos();
            } else {
                this.labelDescStatusNota.setAviso(null);
            }
        }
    }

    private void alteraStatusLabel(NotaFiscalBean notaAux) {
        boolean isEletronica;
        this.labelDescStatusNota.setAviso(null);
        this.labelDescStatusNota.setForeground(null);
        boolean bl = isEletronica = notaAux.getSerie().isRelacionarNfse() == false;
        if (notaAux.getSituacao().equalsIgnoreCase("A")) {
            SwingUtilities.invokeLater(() -> this.alertaLabel(this.labelDescStatusNota, Tipos.tipoSituacaoNotaFiscal(notaAux.getSituacao(), isEletronica) + " [Nota: " + notaAux.getNumero() + "] ", Color.blue, 800));
            isOK = true;
            isAguardando = false;
        } else if (notaAux.getSituacao().equalsIgnoreCase("S")) {
            this.labelDescStatusNota.setForeground(null);
            this.labelDescStatusNota.setText(Tipos.tipoSituacaoNotaFiscal(notaAux.getSituacao(), isEletronica) + " [RPS: " + notaAux.getNumeroRps() + "] ");
            this.labelDescStatusNota.setQuebrarLinha(true);
            if (notaAux.getSituacao().equalsIgnoreCase("C")) {
                this.labelDescStatusNota.setAviso(Funcoes.formataData("dd/MM/yyyy HH:mm", notaAux.getDataStatusNfse()) + " - " + notaAux.getMotivoCancelamento(), 1);
            } else {
                this.labelDescStatusNota.setAviso(Funcoes.formataData("dd/MM/yyyy HH:mm", notaAux.getDataStatusNfse()) + " - " + notaAux.getMotivoNfse(), 1);
            }
            this.buttonSalvar.setEnabled(false);
            this.buttonSincronizar.setVisible(true);
            this.buttonSincronizar.setEnabled(true);
            this.buttonSincronizar.setText("Atualizar");
        } else if (!notaAux.getSituacao().equalsIgnoreCase("X")) {
            this.labelDescStatusNota.setForeground(null);
            this.labelDescStatusNota.setText(Tipos.tipoSituacaoNotaFiscal(notaAux.getSituacao(), isEletronica) + " [RPS: " + notaAux.getNumeroRps() + "] ");
            this.labelDescStatusNota.setQuebrarLinha(true);
            if (notaAux.getSituacao().equalsIgnoreCase("C")) {
                this.labelDescStatusNota.setAviso(Funcoes.formataData("dd/MM/yyyy HH:mm", notaAux.getDataStatusNfse()) + " - " + notaAux.getMotivoCancelamento(), 1);
                this.buttonSalvar.setEnabled(false);
            } else {
                this.labelDescStatusNota.setAviso(Funcoes.formataData("dd/MM/yyyy HH:mm", notaAux.getDataStatusNfse()) + " - " + notaAux.getMotivoNfse(), 1);
                this.buttonSalvar.setText("Reenviar");
            }
        } else {
            if (isNotaFiscalEletronicaAtivada && notaAux.getSituacao().equalsIgnoreCase("X") && this.getStatus() == 3) {
                this.buttonSalvar.setText("Reenviar");
            }
            this.habilitarBotaoSincronizar(notaAux);
            if (tipoTela == 2) {
                this.buttonSalvar.setVisible(true);
            }
            this.labelDescStatusNota.setForeground(null);
            this.labelDescStatusNota.setText(Tipos.tipoSituacaoNotaFiscal(notaAux.getSituacao(), isEletronica) + " [RPS: " + notaAux.getNumeroRps() + "] ");
            this.labelDescStatusNota.setQuebrarLinha(true);
        }
    }

    private void habilitarBotaoSincronizar(NotaFiscalBean notaAux) {
        if (Boolean.TRUE.equals(isNotaFiscalEletronicaAtivada && this.situacaoPermiteSincronizar(notaAux.getSituacao()) != false && (this.getStatus() == 3 || this.getStatus() == 1) && this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.ENOTAS && notaAux.getNumero() == null) && notaAux.getNumeroRps() == null) {
            this.buttonSalvar.setEnabled(false);
            this.buttonSincronizar.setVisible(true);
            this.buttonSincronizar.setEnabled(true);
            this.buttonSincronizar.setText("Atualizar");
        }
        this.buttonSalvar.setEnabled(!this.buttonSincronizar.isEnabled());
    }

    private Boolean situacaoPermiteSincronizar(String situacao) {
        return situacao != null && (!situacao.equalsIgnoreCase("A") || !situacao.equalsIgnoreCase("C") || !situacao.equalsIgnoreCase("R"));
    }

    private void alertaLabel(final JLabel label, String msg, final Color cor, int tempo) {
        label.setText(msg);
        label.setForeground(cor);
        this.timer = new Timer(tempo, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotaFiscalSaida.this.contadorTimer <= 10) {
                    if (NotaFiscalSaida.this.contadorTimer % 2 == 0) {
                        label.setForeground(cor);
                    } else {
                        label.setForeground(null);
                    }
                    NotaFiscalSaida.this.contadorTimer++;
                } else {
                    NotaFiscalSaida.this.labelDescStatusNota.setForeground(cor);
                    NotaFiscalSaida.this.timer.stop();
                    NotaFiscalSaida.this.contadorTimer = 0;
                }
            }
        });
        this.timer.start();
    }

    private void montaPanelParcela(JPanel panel) {
        panel.setLayout(new BorderLayout());
        JPanel topo = new JPanel(new GridBagLayout());
        GridBagConstraints g = new GridBagConstraints();
        g.anchor = 17;
        g.gridx = 0;
        g.gridy = 0;
        this.labelParcela.setDisplayedMnemonic('l');
        this.labelParcela.setLabelFor(this.textParcela);
        topo.add((Component)this.labelParcela, g);
        g.gridx = 1;
        this.labelVencimentoParcela.setDisplayedMnemonic('n');
        this.labelVencimentoParcela.setLabelFor(this.textDataParcela);
        topo.add((Component)this.labelVencimentoParcela, g);
        g.gridx = 3;
        topo.add((Component)this.labelValorParcela, g);
        g.gridy = 1;
        g.gridx = 0;
        this.textParcela.setPreferredSize(new Dimension(50, 20));
        topo.add((Component)this.textParcela, g);
        g.gridx = 1;
        this.textDataParcela.setPreferredSize(new Dimension(85, 20));
        topo.add((Component)this.textDataParcela, g);
        g.gridx = 2;
        this.buttonBuscaDataParcela.setPreferredSize(new Dimension(20, 20));
        topo.add((Component)this.buttonBuscaDataParcela, g);
        g.gridx = 3;
        this.textValorParcela.setPreferredSize(new Dimension(80, 20));
        topo.add((Component)this.textValorParcela, g);
        g.gridx = 4;
        this.buttonOKParcela.setPreferredSize(new Dimension(40, 20));
        this.buttonOKParcela.setMnemonic('O');
        topo.add((Component)this.buttonOKParcela, g);
        g.weightx = 1.0;
        topo.add((Component)new JLabel(), g);
        panel.add((Component)topo, "North");
        JScrollPane e = new JScrollPane(this.tableParcela);
        e.setPreferredSize(new Dimension(300, 20));
        panel.add((Component)e, "Center");
        panel.setVisible(tipoTela != 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaFilial) {
            this.buscaFilial();
        } else if (e.getSource() == this.buttonCancelar) {
            this.cancelar();
        } else if (e.getSource() == this.buttonImpostos) {
            this.mostrarImpostos();
        } else if (e.getSource() == this.buttonBuscaDataEmissao) {
            Funcoes.mostraData(this.textDataEmissao, this.buttonBuscaDataEmissao, (JPanel)this.textDataEmissao.getParent(), true);
        } else if (e.getSource() == this.buttonBuscaDataParcela) {
            Funcoes.mostraData(this.textDataParcela, this.buttonBuscaDataParcela, (JPanel)this.textDataParcela.getParent(), true);
        } else if (e.getSource() == this.buttonBuscaSerie) {
            this.pesquisaSerie();
        } else if (e.getSource() == this.buttonBuscaServico) {
            this.verificaButtonServicoClickado = true;
            this.pesquisaServico();
        } else if (e.getSource() == this.buttonBuscaForma) {
            this.pesquisaFormaPagto();
        } else if (e.getSource() == this.buttonBuscaCadastro) {
            this.pesquisaCadastro();
        } else if (e.getSource() == this.buttonOKParcela) {
            this.okParcela();
        } else if (e.getSource() == this.buttonSalvar) {
            this.salvar(!isNotaFiscalEletronicaAtivada);
        } else if (e.getSource() == this.buttonImprimir) {
            this.imprimir(retorno);
        } else if (e.getSource() == this.itemEnviarEmail) {
            final NotaFiscalBean notaAux = retorno;
            new Thread(){

                @Override
                public void run() {
                    NotaFiscalService cfr_ignored_0 = NotaFiscalSaida.this.serviceNota;
                    if (!NotaFiscalService.enviarEmailNFSe(notaAux)) {
                        Funcoes.mensagem(NotaFiscalSaida.this, "O envio e-mail de nota fiscal eletr\u00f4nica n\u00e3o est\u00e1 ativado.", 2);
                    } else {
                        Funcoes.mensagem(NotaFiscalSaida.this, "A NFS-e foi enviada para o email com sucesso.", 2);
                    }
                }
            }.start();
        } else if (e.getSource() == this.itemParcela) {
            this.editarParcelas(this.tableParcela.getSelectedRow());
        } else if (e.getSource() == this.itemPlano) {
            this.editarPlanoCusto(this.tableParcela.getSelectedRow());
        } else if (e.getSource() == this.itemNumeroTipo) {
            this.editarNumeroTitulo(this.tableParcela.getSelectedRow());
        } else if (e.getSource() == this.buttonNovo) {
            this.setStatus(2);
            this.novo();
        } else if (e.getSource() == this.buttonAssociarFaturas) {
            this.associarFaturas();
        } else if (e.getSource() == this.buttonFechar) {
            this.fechar();
        } else if (e.getSource() == this.buttonEditar) {
            if (retorno != null && retorno.getNumeroRps() != null && retorno.getCodigo() != null) {
                try {
                    NotaFiscalBean notaBean = (NotaFiscalBean)new NotaFiscalService().get(retorno.getFilial().getCodigo().toString(), retorno.getCodigo().toString());
                    this.limparCampos(false);
                    this.preencheDados(notaBean, null, this.listaPreviasFaturamento);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            this.setStatus(3);
            ScreenUtil.requisitarFoco(textFilial);
            isAguardando = retorno != null && retorno.getNumeroRps() != null;
            this.controlaCampos();
        } else if (e.getSource() == this.buttonSincronizar) {
            this.consultarNotaFiscal();
            this.habilitarBotaoSincronizar(this.beanNota);
        } else if (e.getSource() == this.buttonOpcoesNfse) {
            this.abrirPopupOpcoesNfse();
        } else if (e.getSource() == this.itemBaixarXML) {
            if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.NEOGRID) {
                this.baixarXML();
            } else {
                this.baixarZIP();
            }
        } else if (e.getSource() == this.itemBaixarPDF) {
            this.baixarPDF();
        } else if (e.getSource() == this.itemDescricaoExames) {
            this.inserirObsDescricaoExames();
        } else if (e.getSource() == this.itemDescricaoExamesAmb) {
            this.inserirObsDescricaoExamesAmb();
        } else if (e.getSource() == this.itemDescricaoExamesAmbValor) {
            this.inserirObsDescricaoExamesAmbValor();
        } else if (e.getSource() == this.itemDescricaoExamesValor) {
            this.inserirObsDescricaoExamesValor();
        } else if (e.getSource() == this.itemFormaPagamento) {
            this.inserirObsFormaPagamento();
        } else if (e.getSource() == this.itemNomePacienteCPFNascimento) {
            this.inserirObsPacienteCPFNascimento();
        } else if (e.getSource() == this.itemNumeroRequisicao) {
            this.inserirObsNumeroRequisicao();
        }
    }

    private void consultarNotaFiscal() {
        NotaFiscalBean bean = this.getBeanPreenchido();
        if (bean != null && this.validaCampos(bean)) {
            NotaFiscalBean beanNota = bean;
            if (this.sistemaEmissaoNFSe.equals((Object)SistemaEmissaoNFSe.ENOTAS)) {
                IntegracaoEnotas integracao = new IntegracaoEnotas(beanNota);
                try {
                    if (!Funcoes.textoVazio(beanNota.getChaveNfse())) {
                        SplashMensagem splash = SplashMensagem.getInstancia(Laboratorio.getInstancia());
                        if (tipoTela != 3) {
                            splash = SplashMensagem.getInstancia(dialog);
                        }
                        splash.mostrar("Consultando nota fiscal. Por favor aguarde..");
                        String situacao = beanNota.getSituacao();
                        if (situacao.equals("S")) {
                            NotaFiscalService notaService = new NotaFiscalService();
                            String mensagem = notaService.atualizarSolicitacaoCancelamentoNFSe(beanNota);
                            if (!Funcoes.textoVazio(mensagem)) {
                                Conexao.arquivaSQL();
                                Funcoes.mensagem(Laboratorio.getInstancia(), mensagem, 5);
                            }
                        } else {
                            integracao.notaFiscalAutorizada(beanNota.getChaveNfse());
                        }
                        splash.apagar();
                        this.alteraStatusLabel(beanNota);
                        this.setStatus(1);
                        this.controlaCampos();
                    }
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                    return;
                }
            }
        }
    }

    private void inserirObsDescricaoExamesAmbValor() {
        if (!this.requisicoesBean.isEmpty()) {
            StringBuilder buf = new StringBuilder(" Exame(s): ");
            for (RequisicaoBean requisicaoBean : this.requisicoesBean) {
                ArrayList listaExames = (ArrayList)requisicaoBean.getExames();
                if (listaExames == null) continue;
                for (ExameRequisicaoVO exame : listaExames) {
                    if (!Boolean.FALSE.equals(exame.getExcluido())) continue;
                    buf.append(exame.getExame().getDescricao());
                    String amb = this.getCodigoAmb(requisicaoBean, exame);
                    buf.append(!Funcoes.textoVazio(amb) ? " - AMB: ".concat(amb) : "");
                    buf.append(" (R$ ").append(Funcoes.formataDecimal(exame.getValorExame())).append(")").append(", ");
                }
            }
            buf = buf.replace(buf.length() - 2, buf.length(), "");
            buf.append(".");
            this.textObs.setText(this.textObs.getText() + buf.toString());
        }
    }

    private void inserirObsNumeroRequisicao() {
        if (!this.requisicoesBean.isEmpty()) {
            StringBuilder mensagem = new StringBuilder(this.textObs.getText());
            Optional<FilialVO> filial = this.requisicoesBean.stream().map(r -> r.getFilial()).findAny();
            mensagem.append(" Filial: ").append(filial.get().getCodigo());
            mensagem.append(this.requisicoesBean.size() > 1 ? ", requisi\u00e7\u00f5es: " : ", requisi\u00e7\u00e3o: ");
            for (RequisicaoBean requisicaoBean : this.requisicoesBean) {
                mensagem.append(requisicaoBean.getCodigo()).append(", ");
            }
            mensagem = mensagem.replace(mensagem.length() - 2, mensagem.length(), "");
            mensagem.append(".");
            this.textObs.setText(this.textObs.getText() + mensagem.toString());
        }
    }

    private void inserirObsPacienteCPFNascimento() {
        for (RequisicaoBean requisicaoBean : this.requisicoesBean) {
            if (requisicaoBean == null || requisicaoBean.getPaciente() == null) continue;
            this.textObs.setText(this.textObs.getText() + " Paciente: " + requisicaoBean.getPaciente().getNome() + (!Funcoes.textoVazio(requisicaoBean.getPaciente().getCpf()) ? ", CPF: " + requisicaoBean.getPaciente().getCpf() : ", data de nascimento: " + Funcoes.formataData(requisicaoBean.getPaciente().getDataNascimento())) + ".");
        }
    }

    private void inserirObsFormaPagamento() {
        if (this.lancamentosPagamentos != null && this.lancamentosPagamentos.size() > 0) {
            StringBuilder buf = new StringBuilder();
            Iterator<LancamentoBean> itLanctos = this.lancamentosPagamentos.iterator();
            int i = 0;
            while (itLanctos.hasNext()) {
                if (i > 0) {
                    buf.append(", ");
                } else {
                    buf.append(" Forma de pagamento: ");
                }
                LancamentoBean lancto = itLanctos.next();
                buf.append("R$ ").append(Funcoes.formataDecimal(lancto.getValorTotal())).append(" (").append(Tipos.tipoPagamento(lancto.getTipoPagamento())).append(")");
                ++i;
            }
            this.textObs.setText(this.textObs.getText() + buf.toString() + ".");
        }
    }

    private void inserirObsDescricaoExamesValor() {
        if (!this.requisicoesBean.isEmpty()) {
            StringBuilder buf = new StringBuilder(" Exame(s): ");
            for (RequisicaoBean requisicaoBean : this.requisicoesBean) {
                ArrayList listaExames = (ArrayList)requisicaoBean.getExames();
                if (listaExames == null) continue;
                for (ExameRequisicaoVO exame : listaExames) {
                    if (!Boolean.FALSE.equals(exame.getExcluido())) continue;
                    buf.append(exame.getExame().getDescricao());
                    buf.append(" (R$ ").append(Funcoes.formataDecimal(exame.getValorExame())).append(")").append(", ");
                }
            }
            buf = buf.replace(buf.length() - 2, buf.length(), "");
            buf.append(".");
            this.textObs.setText(this.textObs.getText() + buf.toString());
        }
    }

    private void inserirObsDescricaoExamesAmb() {
        if (!this.requisicoesBean.isEmpty()) {
            StringBuilder buf = new StringBuilder(" Exame(s): ");
            for (RequisicaoBean requisicaoBean : this.requisicoesBean) {
                ArrayList listaExames = (ArrayList)requisicaoBean.getExames();
                if (listaExames == null) continue;
                for (ExameRequisicaoVO exame : listaExames) {
                    if (!Boolean.FALSE.equals(exame.getExcluido())) continue;
                    buf.append(exame.getExame().getDescricao());
                    String amb = this.getCodigoAmb(requisicaoBean, exame);
                    buf.append(!Funcoes.textoVazio(amb) ? " - AMB: ".concat(amb) : "");
                    buf.append(", ");
                }
            }
            buf = buf.replace(buf.length() - 2, buf.length(), "");
            buf.append(".");
            this.textObs.setText(this.textObs.getText() + buf.toString());
        }
    }

    private String getCodigoAmb(RequisicaoBean requisicaoBean, ExameRequisicaoVO exame) {
        String amb = "";
        try {
            amb = ExameUtil.getCodigoAMB(String.valueOf(requisicaoBean.getFilial().getCodigo()), exame.getExame().getCodigo(), exame.getMaterial().getCodigo(), requisicaoBean.getConvenio().getCodigo(), exame.getMetodologia().getCodigo());
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar o c\u00f3digo AMB. Filial = " + requisicaoBean.getFilial().getCodigo() + ", requisi\u00e7\u00e3o = " + requisicaoBean.getCodigo() + ", exame = " + exame.getExame().getCodigo() + ", material = " + exame.getMaterial().getCodigo() + ".\n" + e.getMessage(), e.getStackTrace());
        }
        return amb;
    }

    private void inserirObsDescricaoExames() {
        if (!this.requisicoesBean.isEmpty()) {
            StringBuilder buf = new StringBuilder(" Exame(s): ");
            for (RequisicaoBean requisicaoBean : this.requisicoesBean) {
                ArrayList listaExames = (ArrayList)requisicaoBean.getExames();
                if (listaExames == null) continue;
                for (ExameRequisicaoVO exame : listaExames) {
                    if (!Boolean.FALSE.equals(exame.getExcluido())) continue;
                    buf.append(exame.getExame().getDescricao()).append(", ");
                }
            }
            buf = buf.replace(buf.length() - 2, buf.length(), "");
            buf.append(".");
            this.textObs.setText(this.textObs.getText() + buf.toString());
        }
    }

    private void baixarXML() {
        NotaFiscalBean notaAux = retorno;
        try {
            String caminho;
            byte[] xml = this.getObjetoBD(notaAux.getXmlNfse());
            if (xml != null && (caminho = this.getDestinoSalvarArquivo("Arquivo XML", ".xml")) != null) {
                if (!caminho.endsWith(".xml")) {
                    caminho = caminho + ".xml";
                }
                if (this.salvarArquivo(caminho, xml)) {
                    Funcoes.mensagem(this, "O arquivo foi salvo com sucesso.", 5);
                } else {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel salvar o arquivo.", 2);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void baixarZIP() {
        NotaFiscalBean notaAux = retorno;
        try {
            String caminho;
            byte[] zip = this.getObjetoBD(notaAux.getXmlNfse());
            if (zip != null && (caminho = this.getDestinoSalvarArquivo("Arquivo ZIP", ".zip")) != null) {
                if (!caminho.endsWith(".zip")) {
                    caminho = caminho + ".zip";
                }
                if (this.salvarArquivo(caminho, zip)) {
                    Funcoes.mensagem(this, "O arquivo foi salvo com sucesso.", 5);
                } else {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel salvar o arquivo.", 2);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void baixarPDF() {
        NotaFiscalBean notaAux = retorno;
        try {
            String caminho;
            byte[] xml = this.getObjetoBD(notaAux.getPdfRps());
            if (xml != null && (caminho = this.getDestinoSalvarArquivo("Arquivo PDF", ".pdf")) != null) {
                if (!caminho.endsWith(".pdf")) {
                    caminho = caminho + ".pdf";
                }
                if (this.salvarArquivo(caminho, xml)) {
                    Funcoes.mensagem(this, "O arquivo foi salvo com sucesso.", 5);
                } else {
                    Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel salvar o arquivo.", 2);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar o PDF.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean salvarArquivo(String caminho, byte[] dados) {
        File arquivo = new File(caminho);
        FileOutputStream fos = null;
        try {
            arquivo.createNewFile();
            fos = new FileOutputStream(arquivo);
            fos.write(dados, 0, dados.length);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel salvar arquivo.\n" + e.getMessage(), e.getStackTrace());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            arquivo = null;
            System.gc();
        }
    }

    private String getDestinoSalvarArquivo(String descricaoArquivo, String extensaoArquivo) {
        JFileChooser file = ComponenteFactory.novoJFileChooser();
        file.setFileFilter(ComponenteFactory.novoFileFilter(descricaoArquivo, extensaoArquivo));
        if (file.showSaveDialog(this) == 0) {
            return file.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private byte[] getObjetoBD(Long oid) throws SQLException {
        LargeObjectManager lobj = ((PGConnection)Conexao.getConnection()).getLargeObjectAPI();
        LargeObject obj = lobj.open(oid.longValue(), 262144);
        byte[] retorno = new byte[obj.size()];
        obj.read(retorno, 0, obj.size());
        obj.close();
        return retorno;
    }

    private void mostrarImpostos() {
        this.panelImpostos.setVisible(!this.panelImpostos.isVisible());
        if (this.panelImpostos.isVisible()) {
            this.buttonImpostos.setText("Impostos \u25c4");
        } else {
            this.buttonImpostos.setText("Impostos \u25ba");
        }
    }

    private int getStatus() {
        return this.status;
    }

    public void setAcessos(long acessoAlterarNumero, long acessoAlterarImpostos) {
        this.textNumeroNota.setEditable(Acesso.getAcesso(acessoAlterarNumero));
        this.buttonImpostos.setVisible(Acesso.getAcesso(acessoAlterarImpostos));
    }

    public void setFilial(String filial) {
        if (Funcoes.textoVazio(textFilial)) {
            textFilial.setText(filial);
        }
    }

    private void setStatus(int status) {
        this.status = status;
    }

    private void limparCampos(boolean isLimparFilial) {
        this.panelImpostos.setVisible(false);
        this.notasPendentes = null;
        if (isLimparFilial) {
            textFilial.clear();
            this.labelValorFilial.setText("");
            this.textDataEmissao.clear();
            this.textNumeroNota.clear();
            this.labelDescStatusNota.setText("");
        }
        this.labelDescStatusNota.setText("");
        this.labelDescStatusNota.setAviso(null);
        this.labelDataHora.setText("");
        this.textCodigoCadastro.clear();
        this.textCodigoSerie.clear();
        this.textValorIrrf.clear();
        this.textValorIss.clear();
        this.textValorPis.clear();
        this.textValorCsll.clear();
        this.textValorCofins.clear();
        this.textValorInss.clear();
        this.textValorIssRetido.clear();
        this.textValorInssRetido.clear();
        this.textValorCofinsRetido.clear();
        this.textValorCsllRetido.clear();
        this.textValorIrrfRetido.clear();
        this.textValorPisRetido.clear();
        this.textCodigoServico.clear();
        this.textCodigoForma.clear();
        this.textParcela.clear();
        this.textDataParcela.clear();
        this.textValorParcela.clear();
        this.textPercIrrf.clear();
        this.textPercIss.clear();
        this.textPercPis.clear();
        this.textPercCsll.clear();
        this.textPercCofins.clear();
        this.textPercInss.clear();
        this.textPercIssRetido.clear();
        this.textPercInssRetido.clear();
        this.textPercCofinsRetido.clear();
        this.textPercCsllRetido.clear();
        this.textPercIrrfRetido.clear();
        this.textPercPisRetido.clear();
        this.buttonSalvar.setText("Salvar");
        this.buttonSincronizar.setVisible(false);
        this.modeloParcela.clear();
        this.textObs.setText("");
        this.labelDescSerie.setText("");
        this.labelDescForma.setText("");
        this.labelDescServico.setText("");
        this.labelCadastro.setText("");
        this.textSubTotal.setText(Funcoes.formataDecimal(0));
        this.labelTotalImpostos.setText(Funcoes.formataDecimal(0));
        this.labelTotal.setText(Funcoes.formataDecimal(0));
        if (tipoTela == 3 && isLimparFilial) {
            this.textDataEmissao.clear();
            this.labelDataHora.setText("");
            this.labelDescStatusNota.setAviso(null);
        }
        this.labelStatusNota.setForeground(null);
        if (this.listaFaturasAssociadas != null && this.listaFaturasAssociadas.size() > 0) {
            this.listaFaturasAssociadas.clear();
        }
        if (this.cron != null) {
            this.inicializaCronometro();
        }
        if (isNotaFiscalEletronicaAtivada) {
            this.inicializaParametroFecharTela();
        }
        if (tipoTela == 3) {
            retorno = null;
        }
        this.servico = null;
        isOK = false;
        isAguardando = false;
    }

    protected boolean cancelar() {
        if (retorno != null && retorno.getSituacao().equals("A") || this.getMensagem()) {
            if (tipoTela == 3 && this.getStatus() == 2 && !isAguardando && !isOK) {
                retorno = null;
            }
            this.setStatus(1);
            this.controlaCampos();
            if (tipoTela == 3) {
                this.limparCampos(false);
            }
            if (retorno != null && retorno.getSituacao().equalsIgnoreCase("A")) {
                this.inicializaCronometro();
            }
            if (this.getTopLevelAncestor() != Laboratorio.getInstancia()) {
                this.fechar();
            }
            return true;
        }
        return false;
    }

    private boolean getMensagem() {
        if (this.buttonCancelar.getText().equalsIgnoreCase("Fechar")) {
            return true;
        }
        if (retorno != null && !StringUtil.isEmpty(retorno.getStatusNfse()) && retorno.getSituacao().equals("X")) {
            return Funcoes.mensagem(this, "Nota fiscal enviada e aguardando retorno.", 2) == 0;
        }
        return Funcoes.mensagem(this, "Confirma o cancelamento da nota fiscal?", 4) == 0;
    }

    private void inicializaCronometro() {
        if (this.cron != null) {
            this.cron.parar();
        }
        this.cron = new CronometroRegressivo(this.intervaloFecharTela / 1000, -1, this.labelDescStatusNota, this, dialog);
    }

    protected void fechar() {
        boolean podeFechar = true;
        if (this.getStatus() != 1) {
            podeFechar = this.cancelar();
        }
        if (podeFechar) {
            this.limparCampos(true);
            if (this.getTopLevelAncestor() == Laboratorio.getInstancia()) {
                this.setVisible(false);
            } else if (this.getTopLevelAncestor() == null) {
                this.setVisible(false);
            } else {
                this.getTopLevelAncestor().setVisible(false);
            }
            if (this.cron != null && this.cron.isAtivo()) {
                this.cron.parar();
            }
        }
    }

    private void preencheDados(SeriesVO serie) {
        if (Funcoes.textoVazio(this.labelDataEmissao.getText())) {
            this.labelDataHora.setText(Variaveis.login + " em " + Funcoes.formataData("dd/MM/yyyy", new Date()));
        }
        if (serie != null) {
            if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.ENOTAS && serie.isRelacionarNfse().booleanValue() && !serie.isImprimirNota().booleanValue()) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "S\u00e9rie padr\u00e3o n\u00e3o gera nota fiscal eletr\u00f4nica.", 2);
                ScreenUtil.requisitarFoco(this.textCodigoSerie);
            }
            this.textCodigoSerie.setText(serie.getCodigo());
            this.labelDescSerie.setText(serie.getDescricao());
        }
        this.controlaCamposNfse();
        this.validaBloqueioMudancaSerieNotaFiscal(serie);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() instanceof TTextField) {
            ((TTextField)e.getSource()).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == textFilial) {
            if (Funcoes.textoVazio(textFilial)) {
                ScreenUtil.requisitarFoco(textFilial);
                return;
            }
            if (Funcoes.textoVazio(this.filialAtual)) {
                this.filialAtual = textFilial.getText();
            }
            if (!Funcoes.textoVazio(textFilial)) {
                this.getDescricaoFilial(textFilial.getText());
            }
            if (!this.isPesquisandoFilial && this.getStatus() == 3 && !Funcoes.textoVazio(this.labelValorFilial.getText()) && Funcoes.textoVazio(this.textCodigoSerie)) {
                this.editar();
            }
            if (!this.filialAtual.equalsIgnoreCase(textFilial.getText())) {
                this.limparCampos(false);
                this.filialAtual = textFilial.getText();
            }
        } else if (e.getSource() == this.textCodigoCadastro) {
            this.buscaCadastro(this.textCodigoCadastro.getText());
        } else if (e.getSource() == this.textCodigoSerie) {
            this.buscaSerie(this.textCodigoSerie.getText());
        } else if (e.getSource() == this.textCodigoServico) {
            if (Funcoes.textoVazio(this.textCodigoServico.getText())) {
                ScreenUtil.requisitarFoco(this.textCodigoCadastro);
                this.verificaButtonServicoClickado = false;
                return;
            }
            this.buscaServico(this.textCodigoServico.getText());
            if (!this.validaCampos()) {
                return;
            }
            this.calcularImpostos();
        } else if (e.getSource() == this.textCodigoForma) {
            this.buscaFormaPagamento(this.textCodigoForma.getText());
            try {
                this.calcularParcelasAutomatico();
            }
            catch (Exception e1) {
                ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "NotaFiscalSaida: 526");
            }
        } else if (e.getSource() == this.textParcela) {
            int pos;
            if (Funcoes.isNumeric(this.textParcela.getText()) && (pos = this.modeloParcela.localizar(0, this.textParcela.getText())) > -1) {
                this.editarParcelas(pos);
            }
        } else if (e.getSource() == this.textPercCofins || e.getSource() == this.textPercCsll || e.getSource() == this.textPercInss || e.getSource() == this.textPercIrrf || e.getSource() == this.textPercIss || e.getSource() == this.textPercPis || e.getSource() == this.textPercIssRetido || e.getSource() == this.textPercInssRetido || e.getSource() == this.textPercCofinsRetido || e.getSource() == this.textPercCsllRetido || e.getSource() == this.textPercIrrfRetido || e.getSource() == this.textPercPisRetido) {
            this.servicosAlterados(true);
            this.calcularImpostos();
        } else if (e.getSource() == this.textSubTotal) {
            this.servicosAlterados();
        }
    }

    private void calcularImpostos() {
        NotaFiscalBean b = this.getBeanPreenchido();
        this.serviceNota.calculaImpostosAlterados(b);
        this.atualizaImpostos(b);
    }

    private void pegaValorImpostos() {
        NotaFiscalBean bean = this.getBeanPreenchido();
        if (bean.getSerie() != null) {
            this.serviceNota.pegaValorImpostos(bean, true);
        }
        this.atualizaImpostos(bean);
    }

    private void atualizaImpostos(NotaFiscalBean bean) {
        this.textPercInss.setPercentualOriginal(bean.getInssPercentual());
        this.textPercCofins.setPercentualOriginal(bean.getCofinsPercentual());
        this.textPercCsll.setPercentualOriginal(bean.getCsllPercentual());
        this.textPercIrrf.setPercentualOriginal(bean.getIrrfPercentual());
        this.textPercIss.setPercentualOriginal(bean.getIssPercentual());
        this.textPercPis.setPercentualOriginal(bean.getPisPercentual());
        this.textPercIssRetido.setPercentualOriginal(bean.getPercentualISSRetido());
        this.textPercInssRetido.setPercentualOriginal(bean.getPercentualInssRetido());
        this.textPercCofinsRetido.setPercentualOriginal(bean.getPercentualCofinsRetido());
        this.textPercCsllRetido.setPercentualOriginal(bean.getPercentualCsllRetido());
        this.textPercIrrfRetido.setPercentualOriginal(bean.getPercentualIrrfRetido());
        this.textPercPisRetido.setPercentualOriginal(bean.getPercentualPisRetido());
        this.preencheCampoImposto(this.textPercInss, bean.getInssPercentual());
        this.preencheCampoImposto(this.textPercCofins, bean.getCofinsPercentual());
        this.preencheCampoImposto(this.textPercCsll, bean.getCsllPercentual());
        this.preencheCampoImposto(this.textPercIrrf, bean.getIrrfPercentual());
        this.preencheCampoImposto(this.textPercIss, bean.getIssPercentual());
        this.preencheCampoImposto(this.textPercPis, bean.getPisPercentual());
        this.preencheCampoImposto(this.textPercIssRetido, bean.getPercentualISSRetido());
        this.preencheCampoImposto(this.textPercInssRetido, bean.getPercentualInssRetido());
        this.preencheCampoImposto(this.textPercCofinsRetido, bean.getPercentualCofinsRetido());
        this.preencheCampoImposto(this.textPercCsllRetido, bean.getPercentualCsllRetido());
        this.preencheCampoImposto(this.textPercIrrfRetido, bean.getPercentualIrrfRetido());
        this.preencheCampoImposto(this.textPercPisRetido, bean.getPercentualPisRetido());
        this.preencheCampoImposto(this.textValorInss, bean.getInssValor());
        this.preencheCampoImposto(this.textValorCofins, bean.getCofinsValor());
        this.preencheCampoImposto(this.textValorCsll, bean.getCsllValor());
        this.preencheCampoImposto(this.textValorIrrf, bean.getIrrfValor());
        this.preencheCampoImposto(this.textValorIss, bean.getIssValor());
        this.preencheCampoImposto(this.textValorPis, bean.getPisValor());
        this.preencheCampoImposto(this.textValorIssRetido, bean.getValorISSRetido());
        this.preencheCampoImposto(this.textValorInssRetido, bean.getValorInssRetido());
        this.preencheCampoImposto(this.textValorCofinsRetido, bean.getValorCofinsRetido());
        this.preencheCampoImposto(this.textValorCsllRetido, bean.getValorCsllRetido());
        this.preencheCampoImposto(this.textValorIrrfRetido, bean.getValorIrrfRetido());
        this.preencheCampoImposto(this.textValorPisRetido, bean.getValorPisRetido());
        double totalImpostos = bean.getValorISSRetido() + bean.getValorInssRetido() + bean.getValorCofinsRetido() + bean.getValorCsllRetido() + bean.getValorIrrfRetido() + bean.getValorPisRetido();
        double total = bean.getSubTotal() - totalImpostos;
        this.labelImpostosSobre.setText(Funcoes.formataDecimal(bean.getImpostoAcumulado()));
        this.labelTotalImpostos.setText(Funcoes.formataDecimal(totalImpostos));
        this.textSubTotal.setText(Funcoes.formataDecimal(bean.getSubTotal()));
        this.labelTotal.setText(Funcoes.formataDecimal(total));
    }

    private void preencheCampoImposto(TTextField campo, Double perc) {
        if (campo != null) {
            if (perc != null) {
                campo.setText(Funcoes.formataDecimal(campo.getMaskDecimal(), perc));
            } else {
                campo.setText(Funcoes.formataDecimal(campo.getMaskDecimal(), 0.0));
            }
        }
    }

    private void buscaSerie(String codigo) {
        if (Funcoes.textoVazio(textFilial.getText())) {
            Funcoes.mensagem(this, "Filial n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(textFilial);
            return;
        }
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoSerie.setText("");
            this.labelDescSerie.setText("");
            return;
        }
        try {
            SeriesVO serie = (SeriesVO)this.serviceSerie.getVO(textFilial.getText(), codigo);
            if (serie != null) {
                if (!serie.isRelacionarNfse().booleanValue() && serie.isImprimirNota().booleanValue()) {
                    Funcoes.mensagem(this, "S\u00e9rie n\u00e3o gera nota fiscal eletr\u00f4nica.", 2);
                    this.textCodigoSerie.setText("");
                    ScreenUtil.requisitarFoco(this.textCodigoSerie);
                    return;
                }
                this.textCodigoSerie.setText(serie.getCodigo());
                this.labelDescSerie.setText(serie.getDescricao());
                if (!isNotaFiscalEletronicaAtivada) {
                    this.textNumeroNota.setText(String.valueOf(this.serviceNota.pegaNumeroProximaNota(serie)));
                }
                NotaFiscalSaida.serie = serie;
            } else {
                this.labelDescSerie.setText("N\u00e3o cadastrado");
            }
            NotaFiscalSaida.isNotaFiscalEletronicaAtivada(serie);
            this.controlaCamposNfse();
            this.controlaCampos();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void buscaCadastro(String codigo) {
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoCadastro.setText("");
            this.labelCadastro.setText("");
            return;
        }
        if (this.comboTipoCadastro.getSelectedIndex() < 0) {
            return;
        }
        try {
            this.cadastroVO = null;
            String tipo = this.getTipoCadastroSelecionado();
            if (tipo.equalsIgnoreCase("O")) {
                ConvenioVO convenio = (ConvenioVO)this.serviceConvenio.getVO(textFilial.getText(), codigo);
                if (convenio != null) {
                    if (this.verificaPendencia(convenio)) {
                        this.textCodigoCadastro.setText("");
                        this.labelCadastro.setText("");
                        ScreenUtil.requisitarFoco(this.textCodigoCadastro);
                        this.isCadastroValidado = false;
                        return;
                    }
                    this.textCodigoCadastro.setText(Integer.toString(convenio.getCodigo()));
                    this.labelCadastro.setText(convenio.getFantasia());
                    this.cadastroVO = convenio;
                }
            } else if (tipo.equalsIgnoreCase("P") || tipo.equalsIgnoreCase("E")) {
                PacienteVO paciente = (PacienteVO)this.servicePaciente.getVO(textFilial.getText(), codigo);
                if (paciente != null) {
                    if (this.verificaPendencia(paciente)) {
                        this.textCodigoCadastro.setText("");
                        this.labelCadastro.setText("");
                        ScreenUtil.requisitarFoco(this.textCodigoCadastro);
                        this.isCadastroValidado = false;
                        return;
                    }
                    this.textCodigoCadastro.setText(Integer.toString(paciente.getCodigo()));
                    this.labelCadastro.setText(paciente.getNome());
                    this.cadastroVO = paciente;
                }
            } else {
                EntidadeVO entidade = (EntidadeVO)this.serviceEntidade.getVO(textFilial.getText(), codigo);
                if (entidade != null) {
                    if (this.verificaPendencia(entidade)) {
                        this.textCodigoCadastro.setText("");
                        this.labelCadastro.setText("");
                        ScreenUtil.requisitarFoco(this.textCodigoCadastro);
                        this.isCadastroValidado = false;
                        return;
                    }
                    if (!entidade.getTipo().equalsIgnoreCase(tipo)) {
                        this.labelCadastro.setText("N\u00e3o cadastrado");
                    } else {
                        this.textCodigoCadastro.setText(Integer.toString(entidade.getCodigo()));
                        this.labelCadastro.setText(entidade.getFantasia());
                        this.cadastroVO = entidade;
                    }
                }
            }
            if (!this.isCadastroValidado && Funcoes.textoVazio(this.labelCadastro.getText())) {
                this.labelCadastro.setText("N\u00e3o cadastrado");
                ScreenUtil.requisitarFoco(this.textCodigoCadastro);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscal:555");
        }
    }

    private boolean verificaPendencia(AbstractThreadVO cadastro) {
        if (cadastro == null) {
            return false;
        }
        try {
            if (cadastro instanceof EntidadeVO) {
                this.notasPendentes = this.serviceNota.getNotasFiscaisPendentes(((EntidadeVO)cadastro).getFilial().getCodigo(), ((EntidadeVO)cadastro).getCpfCnpj());
            } else if (cadastro instanceof ConvenioVO) {
                this.notasPendentes = this.serviceNota.getNotasFiscaisPendentes(((ConvenioVO)cadastro).getFilial().getCodigo(), ((ConvenioVO)cadastro).getCnpj());
            } else if (cadastro instanceof PacienteVO) {
                this.notasPendentes = this.serviceNota.getNotasFiscaisPendentes(((PacienteVO)cadastro).getFilial().getCodigo(), ((PacienteVO)cadastro).getCpf());
            }
            if (this.notasPendentes != null && !this.notasPendentes.isEmpty()) {
                StringBuilder buf = new StringBuilder("O cadastro informado possui notas pendentes.\nResolva as notas anteriores para prosseguir!\n");
                boolean isMesmoCadastro = true;
                if (this.notasPendentes.size() > 1 && retorno != null) {
                    for (NotaFiscalBean bean : this.notasPendentes) {
                        if (retorno != null && bean.getCodigo().equals(retorno.getCodigo())) {
                            isMesmoCadastro = true;
                            continue;
                        }
                        isMesmoCadastro = false;
                        buf.append("S\u00e9rie: ").append(bean.getSerie().getCodigo());
                        buf.append("  \nRPS: ").append(bean.getNumeroRps());
                        buf.append("  \nValor: ").append(bean.getValor());
                        buf.append("  \nSitua\u00e7\u00e3o: ").append(Tipos.tipoSituacaoNotaFiscal(bean.getSituacao(), this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.ENOTAS));
                        buf.append("  \nData: ").append(Funcoes.formataData(bean.getDataEmissao()));
                        buf.append("\n----------------");
                    }
                }
                if (!isMesmoCadastro) {
                    Funcoes.mensagem(this, buf.toString(), 2);
                    return true;
                }
                return false;
            }
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar notas pendentes.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
        return false;
    }

    private void buscaServico(String codigo) {
        if (Funcoes.textoVazio(textFilial.getText())) {
            Funcoes.mensagem(this, "Filial n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(textFilial);
            return;
        }
        if (Funcoes.textoVazio(codigo)) {
            this.textCodigoServico.setText("");
            this.labelDescServico.setText("");
            return;
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("fil_codigo", textFilial.getText());
            map.put("svc_codigo", codigo);
            this.servico = (ServicoVO)this.serviceServico.getVO(map);
            if (!this.tipoServicoValido()) {
                return;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalSaida:583");
        }
    }

    private boolean tipoServicoValido() {
        if (this.servico != null) {
            String mensagemValidacao = "Servi\u00e7o n\u00e3o pode ser utilizado em Nota Fiscal de Pessoa ";
            TipoServico tipoServico = null;
            tipoServico = Funcoes.textoVazio(this.servico.getTipoServico()) ? TipoServico.PESSOA_FISICA_E_JURIDICA : TipoServico.codigoToTipoServico(this.servico.getTipoServico());
            if (tipoTela == 2 && tipoServico.equals((Object)TipoServico.PESSOA_JURIDICA)) {
                mensagemValidacao = mensagemValidacao + "F\u00edsica.";
                Funcoes.mensagem(this, mensagemValidacao, 2);
                ScreenUtil.requisitarFoco(this.textCodigoServico);
                return false;
            }
            if (tipoTela != 2 && tipoServico.equals((Object)TipoServico.PESSOA_FISICA)) {
                mensagemValidacao = mensagemValidacao + "Jur\u00eddica.";
                Funcoes.mensagem(this, mensagemValidacao, 2);
                ScreenUtil.requisitarFoco(this.textCodigoServico);
                return false;
            }
            this.textCodigoServico.setText(String.valueOf(this.servico.getCodigo()));
            this.labelDescServico.setText(this.servico.getDescricao());
            this.servicosAlterados();
        } else {
            this.labelDescServico.setText("N\u00e3o cadastrado");
            ScreenUtil.requisitarFoco(this.textCodigoServico);
        }
        return true;
    }

    private void buscaFormaPagamento(String codigo) {
        if (codigo == null || Funcoes.textoVazio(codigo)) {
            this.textCodigoForma.setText("");
            this.labelDescForma.setText("");
            return;
        }
        try {
            FormaPagamentoVO forma = (FormaPagamentoVO)this.serviceFormaPagamento.getVO(textFilial.getText(), codigo);
            if (forma != null) {
                this.textCodigoForma.setText(String.valueOf(forma.getCodigo()));
                this.labelDescForma.setText(forma.getDescricao());
            } else {
                this.labelDescForma.setText("N\u00e3o cadastrado");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalSaida:615");
        }
    }

    private String getTipoCadastroSelecionado() {
        return ((TipoCadastro)((Object)this.comboTipoCadastro.getSelectedItem())).tipo;
    }

    private void pesquisaSerie() {
        if (Funcoes.textoVazio(textFilial.getText())) {
            Funcoes.mensagem(this, "Filial n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(textFilial);
            return;
        }
        try {
            this.textCodigoSerie.setText("");
            this.labelDescSerie.setText("");
            SeriesVO serie = (SeriesVO)this.serviceSerie.pesquisaVO(this.getTopLevelAncestor(), new SeriesVO(), "Pesquisando s\u00e9ries", true, textFilial.getText());
            if (serie != null) {
                if (serie.isRelacionarNfse().booleanValue() && !serie.isImprimirNota().booleanValue()) {
                    Funcoes.mensagem(this, "S\u00e9rie n\u00e3o gera nota fiscal eletr\u00f4nica.", 2);
                    ScreenUtil.requisitarFoco(this.textCodigoSerie);
                    return;
                }
                this.textCodigoSerie.setText(serie.getCodigo());
                this.labelDescSerie.setText(serie.getDescricao());
            } else {
                this.labelDescSerie.setText("N\u00e3o cadastrado");
            }
            ScreenUtil.requisitarFoco(this.textCodigoSerie);
            NotaFiscalSaida.isNotaFiscalEletronicaAtivada(serie);
            this.controlaCamposNfse();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalSaida:620");
        }
    }

    private void buscaFilial() {
        this.isPesquisandoFilial = true;
        Hashtable table = Pesquisas.filial(this.getTopLevelAncestor(), false);
        if (table != null) {
            textFilial.setText(table.get("fil_codigo").toString());
            this.isPesquisandoFilial = false;
        }
    }

    private void getDescricaoFilial(String filial) {
        if (Funcoes.textoVazio(filial)) {
            return;
        }
        try {
            filial = StringUtil.removeZerosEsquerda(filial);
            textFilial.setText(filial);
            String descricao = DBUtil.getDescricao("fil_codigo", "fil_descricao", filial, "filiais_postocoleta", true);
            if (!Funcoes.textoVazio(descricao)) {
                this.labelValorFilial.setText(descricao);
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da filial.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void pesquisaServico() {
        try {
            this.textCodigoServico.setText("");
            this.labelDescServico.setText("");
            String tipoServico = tipoTela == 2 ? TipoServico.PESSOA_FISICA.getCodigo() : TipoServico.PESSOA_JURIDICA.getCodigo();
            this.servico = (ServicoVO)this.serviceServico.pesquisaVO(this.getTopLevelAncestor(), new ServicoVO(), "Pesquisando servi\u00e7os", true, textFilial.getText(), tipoServico);
            if (this.servico != null) {
                this.textCodigoServico.setText(String.valueOf(this.servico.getCodigo()));
                this.labelDescServico.setText(this.servico.getDescricao());
                this.servicosAlterados();
                this.verificaButtonServicoClickado = false;
            } else {
                this.labelDescServico.setText("N\u00e3o cadastrado");
            }
            ScreenUtil.requisitarFoco(this.textCodigoServico);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalSaida:639");
        }
    }

    private void pesquisaFormaPagto() {
        try {
            this.textCodigoForma.setText("");
            this.labelDescForma.setText("");
            FormaPagamentoVO forma = (FormaPagamentoVO)this.serviceFormaPagamento.pesquisaVO(this.getTopLevelAncestor(), new FormaPagamentoVO(), "Pesquisando formas de pagamento", true, textFilial.getText());
            if (forma != null) {
                this.textCodigoForma.setText(String.valueOf(forma.getCodigo()));
                this.labelDescForma.setText(forma.getDescricao());
            } else {
                this.labelDescForma.setText("N\u00e3o cadastrado");
            }
            ScreenUtil.requisitarFoco(this.textCodigoForma);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalSaida:659");
        }
    }

    private void pesquisaCadastro() {
        try {
            this.textCodigoCadastro.setText("");
            this.labelCadastro.setText("");
            if (this.comboTipoCadastro.getSelectedIndex() < 0) {
                return;
            }
            String tipo = this.getTipoCadastroSelecionado();
            if (tipo.equalsIgnoreCase("O")) {
                ConvenioVO convenio = (ConvenioVO)this.serviceConvenio.pesquisaVO(this.getTopLevelAncestor(), new ConvenioVO(), "Pesquisando Conv\u00eanios", textFilial.getText(), true);
                if (convenio != null) {
                    this.textCodigoCadastro.setText(Integer.toString(convenio.getCodigo()));
                    this.labelCadastro.setText(convenio.getFantasia());
                }
            } else if (tipo.equalsIgnoreCase("P")) {
                PacienteVO paciente = (PacienteVO)this.servicePaciente.pesquisaVO(this.getTopLevelAncestor(), new PacienteVO(), "Pesquisando Pacientes", true, textFilial.getText());
                if (paciente != null) {
                    this.textCodigoCadastro.setText(Integer.toString(paciente.getCodigo()));
                    this.labelCadastro.setText(paciente.getNome());
                }
            } else {
                String titulo = "";
                int tipoTelaModulo = 4;
                if (tipo.equalsIgnoreCase("C")) {
                    titulo = "Pesquisando Coletadores";
                    tipoTelaModulo = 3;
                } else if (tipo.equalsIgnoreCase("F")) {
                    titulo = "Pesquisando Fornecedores";
                    tipoTelaModulo = 1;
                } else if (tipo.equalsIgnoreCase("U")) {
                    titulo = "Pesquisando Funcion\u00e1rios";
                    tipoTelaModulo = 2;
                } else {
                    titulo = "Pesquisando Representantes";
                }
                EntidadeVO entidade = (EntidadeVO)this.serviceEntidade.pesquisaVO((Object)this.getTopLevelAncestor(), (AbstractThreadVO)new EntidadeVO(), titulo, tipoTelaModulo, tipo, true, textFilial.getText());
                if (entidade != null) {
                    if (!entidade.getTipo().equalsIgnoreCase(tipo)) {
                        this.labelCadastro.setText("N\u00e3o cadastrado");
                    } else {
                        this.textCodigoCadastro.setText(Integer.toString(entidade.getCodigo()));
                        this.labelCadastro.setText(entidade.getFantasia());
                    }
                }
            }
            ScreenUtil.requisitarFoco(this.textCodigoCadastro);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalSaida:739");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calcularParcelasAutomatico() throws Exception {
        if (!Funcoes.textoVazio(this.textCodigoForma.getText()) && !this.labelDescForma.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            if (Funcoes.textoVazio(this.textCodigoSerie.getText()) || this.labelDescSerie.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
                Funcoes.mensagem(this, "A s\u00e9rie est\u00e1 incorreta", 2);
                return;
            }
            if (!isNotaFiscalEletronicaAtivada && !Funcoes.isNumeric(this.textNumeroNota.getText())) {
                Funcoes.mensagem(this, "N\u00famero da nota incorreto", 2);
                return;
            }
            if (!Funcoes.verificaData(this.textDataEmissao.getText())) {
                this.textDataEmissao.setText(Funcoes.formataData(new Date()));
            }
            FilialVO filial = new FilialVO();
            filial.setCodigo(Integer.parseInt(textFilial.getText()));
            ArrayList<ReceberPagarBean> parcelas = this.serviceNota.gerarParcelas(this.getBeanPreenchido(), this.serviceFormaPagamentoParcela.load(" where fil_codigo = " + String.valueOf(filial.getCodigo()) + " and fpg_codigo = " + this.textCodigoForma.getText() + " order by fpp_parcela "));
            this.adicionarParcelasGrid(parcelas);
            if (parcelas.get(0).getCodigo() != null) {
                retorno.setParcelas(new HashSet<ReceberPagarBean>(parcelas));
            }
            Statement st = Conexao.getStatement();
            try {
                if (this.faturasAnexas != null) {
                    this.resumo = FuncoesGerais.criaResumoFatura(st, textFilial.getText(), this.modeloParcela.getRowCount(), true, this.faturasAnexas);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalSaida: 1046");
            }
            finally {
                Conexao.fecharStatement(new PreparedStatement[0]);
            }
        }
    }

    private void editarNumeroTitulo(int linha) {
        if (linha > -1 && linha < this.modeloParcela.getRowCount()) {
            ReceberPagarBean b = (ReceberPagarBean)this.modeloParcela.getValueAt(linha, 4);
            AlteraNumeroTitulo janela = new AlteraNumeroTitulo((Frame)this.getTopLevelAncestor(), b);
            janela.setVisible(true);
            if (janela.isOk()) {
                this.modeloParcela.setValueAt(janela.getTitulo(), linha, 4);
            }
        }
    }

    private void editarParcelas(int linha) {
        if (linha > -1 && linha < this.modeloParcela.getRowCount()) {
            ReceberPagarBean b = (ReceberPagarBean)this.modeloParcela.getValueAt(linha, 4);
            this.textParcela.setText(String.valueOf(b.getParcela()));
            this.textDataParcela.setText(Funcoes.formataData(b.getDataVencimento()));
            this.textValorParcela.setText(Funcoes.formataDecimal(b.getValorTotal()));
            this.textParcela.setEnabled(false);
            ScreenUtil.requisitarFoco(this.textDataParcela);
        }
    }

    private void servicosAlterados() {
        this.servicosAlterados(false);
    }

    private void servicosAlterados(boolean isAtualizaSubTotal) {
        try {
            NotaFiscalBean b = this.getBeanPreenchido();
            this.serviceNota.servicosAlterados(b);
            this.setSubTotal(b.getSubTotal());
            this.serviceNota.pegaValorImpostos(b, true);
            this.serviceNota.calculaImpostosAlterados(b);
            if (!isAtualizaSubTotal) {
                this.atualizaImpostos(b);
            }
            this.adicionarParcelasGrid(b);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalSaida: 1144");
        }
    }

    private void adicionarParcelasGrid(NotaFiscalBean bean) {
        this.modeloParcela.clear();
        this.adicionarParcelasGrid(new ArrayList<ReceberPagarBean>(bean.getParcelas()));
    }

    private void adicionarParcelasGrid(ArrayList<ReceberPagarBean> parcelas) {
        this.modeloParcela.clear();
        for (ReceberPagarBean r : parcelas) {
            this.modeloParcela.addLine(new Object[]{String.valueOf(r.getParcela()), Funcoes.formataData(r.getDataVencimento()), Funcoes.formataDecimal(r.getValor()), Funcoes.formataDecimal(r.getValorTotal()), r});
        }
        this.modeloParcela.ordenarColuna(0, 1);
    }

    private void okParcela() {
        boolean recalculaValores = false;
        if (Funcoes.isNumeric(this.textParcela.getText()) && Funcoes.isNumeric(this.textValorParcela.getText()) && Funcoes.verificaData(this.textDataParcela.getText())) {
            int parcela = Integer.parseInt(this.textParcela.getText());
            BigDecimal novoValor = new BigDecimal(this.textValorParcela.getText());
            novoValor = novoValor.setScale(2, RoundingMode.HALF_UP);
            ReceberPagarBean aux2 = null;
            ArrayList<ReceberPagarBean> arrayRecPag = new ArrayList<ReceberPagarBean>();
            BigDecimal diferencaValores = null;
            for (int i = 0; i < this.modeloParcela.getRowCount(); ++i) {
                arrayRecPag.add((ReceberPagarBean)this.modeloParcela.getValueAt(i, 4));
            }
            for (ReceberPagarBean aux2 : arrayRecPag) {
                if (aux2.getParcela() != parcela) continue;
                diferencaValores = BigDecimal.valueOf(aux2.getValorTotal()).subtract(novoValor);
                diferencaValores = diferencaValores.setScale(2, RoundingMode.HALF_UP);
                PanelPlanoContaCentroCusto panelPlanoCentro = new PanelPlanoContaCentroCusto(aux2, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, aux2.getFilial().getCodigo().toString());
                panelPlanoCentro.setPlanoContas(aux2.getPlanosContas());
                panelPlanoCentro.setCentrosCusto(aux2.getCentrosCusto());
                if (aux2.getTipo().equalsIgnoreCase("R")) {
                    panelPlanoCentro.setTipoDebitoCredito("C");
                } else {
                    panelPlanoCentro.setTipoDebitoCredito("D");
                }
                BigDecimal auxValorPlano = BigDecimal.valueOf(aux2.getValor());
                auxValorPlano = auxValorPlano.subtract(diferencaValores);
                auxValorPlano = auxValorPlano.setScale(2, RoundingMode.HALF_UP);
                aux2.setValor(auxValorPlano.doubleValue());
                ConvenioVO convenio = null;
                String tipo = this.getTipoCadastroSelecionado();
                if (tipo.equalsIgnoreCase("O")) {
                    try {
                        convenio = (ConvenioVO)new ConvenioService().getVO(textFilial.getText(), this.textCodigoCadastro.getText());
                    }
                    catch (Exception e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados do conv\u00eanio.\n" + e.getMessage(), e.getStackTrace());
                    }
                }
                if ((aux2 = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes((AbstractThreadBean)aux2, panelPlanoCentro, 2, convenio)).getValorTotal().doubleValue() != novoValor.doubleValue()) {
                    recalculaValores = true;
                }
                aux2.setValorTotal(novoValor.doubleValue());
                aux2.setDataVencimento(Funcoes.stringToDate(this.textDataParcela.getText()));
                break;
            }
            if (this.modeloParcela.getRowCount() - 1 > 0 && recalculaValores) {
                Object[] mensagens = new String[]{"Todas", "Subsequentes"};
                int opcao = JOptionPane.showOptionDialog(this, "Deseja ratear a diferen\u00e7a sobre todas as outras parcelas ou sobre as parcelas subsequentes?", "Ratear diferen\u00e7a", 0, 2, null, mensagens, mensagens[0]);
                BigDecimal divDiferencaValores = null;
                if (opcao == 0) {
                    if (diferencaValores != null) {
                        divDiferencaValores = diferencaValores.divide(new BigDecimal(this.modeloParcela.getRowCount() - 1), RoundingMode.HALF_UP);
                        diferencaValores = diferencaValores.subtract(divDiferencaValores.multiply(new BigDecimal(this.modeloParcela.getRowCount() - 1)));
                    }
                } else if (diferencaValores != null) {
                    divDiferencaValores = diferencaValores.divide(new BigDecimal(this.modeloParcela.getRowCount() - parcela), RoundingMode.HALF_UP);
                    diferencaValores = diferencaValores.subtract(divDiferencaValores.multiply(new BigDecimal(this.modeloParcela.getRowCount() - parcela)));
                }
                if (divDiferencaValores != null) {
                    divDiferencaValores = divDiferencaValores.setScale(2, RoundingMode.HALF_UP);
                }
                if (diferencaValores != null) {
                    diferencaValores = diferencaValores.setScale(2, RoundingMode.HALF_UP);
                }
                Iterator<Object> it = arrayRecPag.iterator();
                boolean addDif = true;
                while (it.hasNext()) {
                    aux2 = (ReceberPagarBean)it.next();
                    if ((opcao != 0 || aux2.getParcela() == parcela) && (opcao != 1 || aux2.getParcela() <= parcela)) continue;
                    PanelPlanoContaCentroCusto panelPlanoCentro = new PanelPlanoContaCentroCusto(aux2, PanelPlanoContaCentroCusto.TIPO_RECEBER_PAGAR, 0L, 0L, aux2.getFilial().getCodigo().toString());
                    panelPlanoCentro.setPlanoContas(aux2.getPlanosContas());
                    panelPlanoCentro.setCentrosCusto(aux2.getCentrosCusto());
                    if (aux2.getTipo().equalsIgnoreCase("R")) {
                        panelPlanoCentro.setTipoDebitoCredito("C");
                    } else {
                        panelPlanoCentro.setTipoDebitoCredito("D");
                    }
                    BigDecimal auxValorPlano = BigDecimal.valueOf(aux2.getValor());
                    auxValorPlano = !addDif ? auxValorPlano.add(divDiferencaValores) : auxValorPlano.add(divDiferencaValores).add(diferencaValores);
                    auxValorPlano = auxValorPlano.setScale(2, RoundingMode.HALF_UP);
                    BigDecimal auxValorTotal = BigDecimal.valueOf(aux2.getValorTotal());
                    auxValorTotal = !addDif ? auxValorTotal.add(divDiferencaValores) : auxValorTotal.add(divDiferencaValores).add(diferencaValores);
                    auxValorTotal = auxValorTotal.setScale(2, RoundingMode.HALF_UP);
                    aux2.setValor(auxValorPlano.doubleValue());
                    ConvenioVO convenio = null;
                    String tipo = this.getTipoCadastroSelecionado();
                    if (tipo.equalsIgnoreCase("O")) {
                        try {
                            convenio = (ConvenioVO)new ConvenioService().getVO(textFilial.getText(), this.textCodigoCadastro.getText());
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados do conv\u00eanio.\n" + e.getMessage(), e.getStackTrace());
                        }
                    }
                    aux2 = (ReceberPagarBean)FinanceiroUtil.gerarApropriacoes((AbstractThreadBean)aux2, panelPlanoCentro, 2, convenio);
                    aux2.setValor(auxValorPlano.doubleValue());
                    aux2.setValorTotal(auxValorTotal.doubleValue());
                    if (!addDif) continue;
                    addDif = false;
                }
            }
            this.textParcela.clear();
            this.textDataParcela.clear();
            this.textValorParcela.clear();
            this.textParcela.setEnabled(true);
            this.textValorParcela.setEnabled(true);
            if (!this.textParcela.isEnabled()) {
                this.textParcela.setEnabled(true);
            }
            this.adicionarParcelasGrid(arrayRecPag);
        }
    }

    public NotaFiscalBean getBeanPreenchido() {
        String tipo;
        UsuarioVO usuario;
        FilialVO filial;
        NotaFiscalBean bean;
        block50: {
            bean = retorno == null ? new NotaFiscalBean() : retorno;
            filial = null;
            if (bean.getFilial() == null) {
                try {
                    filial = (FilialVO)new FilialService().getVO(textFilial.getText());
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar filial padr\u00e3o para anota: " + e.getMessage(), e.getStackTrace());
                    e.printStackTrace();
                }
            } else {
                filial = bean.getFilial();
            }
            if (!Funcoes.textoVazio(this.textCodigoSerie.getText())) {
                SeriesVO serie = null;
                try {
                    serie = (SeriesVO)new SeriesService().getVO(textFilial.getText(), this.textCodigoSerie.getText().trim());
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar s\u00e9rie.\n" + e.getMessage(), e.getStackTrace());
                }
                bean.setSerie(serie);
            }
            if (!Funcoes.textoVazio(this.textCodigoForma.getText())) {
                FormaPagamentoVO forma = new FormaPagamentoVO();
                forma.setFilial(filial);
                forma.setCodigo(Integer.parseInt(this.textCodigoForma.getText()));
                bean.setFormaPagamento(forma);
            }
            usuario = new UsuarioVO();
            usuario.setCodigo(Variaveis.login);
            bean.setFilial(filial);
            bean.setDataHora(bean.getDataHora() == null ? new Date() : bean.getDataHora());
            if (!Funcoes.textoVazio(this.textDataEmissao)) {
                bean.setDataEmissao(Funcoes.verificaData(this.textDataEmissao.getText()) ? Funcoes.stringToDate(this.textDataEmissao.getText()) : new Date());
            }
            if (tipoTela == 2) {
                bean.setTipo("F");
            } else {
                bean.setTipo("S");
            }
            if (tipoTela == 2) {
                bean.setLancamentosRequisicao(bean.getLancamentosRequisicao() == null ? this.lancamentosPagamentos : bean.getLancamentosRequisicao());
                if (bean.getTipoCadastro() != null && bean.getTipoCadastro().equals("P") && (Funcoes.textoVazio(bean.getNomePagador()) || Funcoes.textoVazio(bean.getCpfPagador()))) {
                    if (!Funcoes.textoVazio(this.nomePagador) && !Funcoes.textoVazio(this.cpfPagador)) {
                        bean.setNomePagador(!Funcoes.textoVazio(bean.getNomePagador()) ? bean.getNomePagador() : this.nomePagador);
                        bean.setCpfPagador(!Funcoes.textoVazio(bean.getCpfPagador()) ? bean.getCpfPagador() : this.cpfPagador);
                    } else if (!Funcoes.textoVazio(bean.getPaciente().getCpfPagador()) && !Funcoes.textoVazio(bean.getPaciente().getNomePagador())) {
                        bean.setNomePagador(!Funcoes.textoVazio(bean.getPaciente().getNomePagador()) ? bean.getPaciente().getNomePagador() : bean.getPaciente().getNome());
                        bean.setCpfPagador(!Funcoes.textoVazio(bean.getPaciente().getCpfPagador()) ? bean.getPaciente().getCpfPagador() : bean.getPaciente().getCpf());
                    } else {
                        Funcoes.mensagem(this, "Informe os dados de pagador.", 2);
                        return null;
                    }
                }
                if (this.lancamentosPagamentos != null) {
                    FormaPagamentoVO pgto = new FormaPagamentoVO();
                    StringBuilder buf = new StringBuilder();
                    buf.append(" select fpg_codigo as codigo ");
                    buf.append("   from formapagtoparcelas ");
                    buf.append("  where fil_codigo = ").append(textFilial.getText());
                    buf.append("  group by fpg_codigo ");
                    buf.append(" having COUNT(1) = ").append(this.lancamentosPagamentos.size());
                    buf.append("  order by fpg_codigo ");
                    try {
                        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                        if (rs.next()) {
                            pgto.setFilial(filial);
                            pgto.setCodigo(rs.getInt("codigo"));
                            bean.setFormaPagamento(pgto);
                            break block50;
                        }
                        buf.setLength(0);
                        buf.append(" select fpg_codigo as codigo ");
                        buf.append("   from formapagtoparcelas ");
                        buf.append("  where fil_codigo = ").append(textFilial.getText());
                        buf.append("  group by fpg_codigo ");
                        buf.append(" having COUNT(1) = 1 ");
                        buf.append("  order by fpg_codigo ");
                        rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                        if (rs.next()) {
                            pgto.setFilial(filial);
                            pgto.setCodigo(rs.getInt("codigo"));
                            bean.setFormaPagamento(pgto);
                            break block50;
                        }
                        Funcoes.mensagem(this, "N\u00e3o h\u00e1 formas de pagamentos cadastradas no sistema.", 2);
                        return null;
                    }
                    catch (Exception sqle) {
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Forma de pagamento n\u00e3o identificada." + sqle.getMessage(), sqle.getStackTrace());
                    }
                }
            }
        }
        if (!Funcoes.textoVazio(this.textNumeroNota) && !isNotaFiscalEletronicaAtivada) {
            bean.setNumero(Long.parseLong(this.textNumeroNota.getText()));
        }
        if (!Funcoes.textoVazio(this.textObs.getText())) {
            bean.setObservacao(StringUtil.tratarUnicode(this.textObs.getText(), true, true));
        }
        bean.setUsuario(bean.getUsuario() == null ? usuario : bean.getUsuario());
        if (!Funcoes.textoVazio(this.labelTotal.getText()) && Double.parseDouble(Funcoes.limpaDecimal(this.labelTotal.getText())) > 0.0) {
            bean.setValor(Funcoes.isNumeric(this.labelTotal.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.labelTotal.getText())) : 0.0);
        } else if (bean.getValor() == null) {
            bean.setValor(0.0);
        }
        if (!Funcoes.textoVazio(this.textSubTotal.getText()) && Double.parseDouble(this.textSubTotal.getText()) > 0.0) {
            bean.setSubTotal(Double.parseDouble(Funcoes.limpaDecimal(this.textSubTotal.getText())));
        } else {
            bean.setSubTotal(0.0);
        }
        if (bean.getSituacao() == null && serie.isRelacionarNfse().booleanValue()) {
            bean.setSituacao("A");
        } else {
            if (Funcoes.textoVazio(bean.getSituacao())) {
                bean.setSituacao("X");
            }
            bean.setNotaEnviada(true);
        }
        String tipoCadastro = null;
        tipoCadastro = bean.getTipoCadastro() == null || tipoTela == 2 && !bean.getTipoCadastro().equals("P") ? ((TipoCadastro)((Object)this.comboTipoCadastro.getSelectedItem())).tipo : bean.getTipoCadastro();
        bean.setTipoCadastro(tipoCadastro);
        if (Funcoes.isNumeric(this.textCodigoCadastro.getText()) && !this.labelCadastro.getText().equals("N\u00e3o cadastrado") && this.cadastroVO != null) {
            if (tipoCadastro.equals("P") || tipoCadastro.equals("E")) {
                bean.setPaciente((PacienteVO)this.cadastroVO);
            } else if (tipoCadastro.equals("O")) {
                bean.setConvenio((ConvenioVO)this.cadastroVO);
            } else {
                bean.setEntidade((EntidadeVO)this.cadastroVO);
            }
        }
        if (this.servico != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("fil_codigo", this.servico.getFilial().getCodigo());
            map.put("svc_codigo", this.servico.getCodigo());
            ServicoBean aux = null;
            try {
                aux = (ServicoBean)new ServicoService().getBean(map);
            }
            catch (ThreadDaoException e) {
                ErrorLogger.mostraMensagem(this, "Servi\u00e7o n\u00e3o identificado.\n" + e.getMessage(), e.getStackTrace());
                return null;
            }
            NotaFiscalServicoBean notaServico = new NotaFiscalServicoBean();
            notaServico.setFilial(filial);
            notaServico.setNotaFiscal((NotaFiscalVO)bean.toVO());
            notaServico.setServico(this.servico);
            notaServico.setValor(bean.getSubTotal());
            notaServico.setNaturezaOperacao(aux.getNaturezaOperacao());
            notaServico.setTipoTributacao(aux.getTipoTributacao());
            notaServico.setTributacaoMunicipal(aux.getCodigoTributacaoMunicipio());
            bean.setServico(notaServico);
        }
        HashSet<ReceberPagarBean> receberPagar = new HashSet<ReceberPagarBean>();
        for (int i = 0; i < this.modeloParcela.getRowCount(); ++i) {
            if (!(this.modeloParcela.getValueAt(i, 4) instanceof ReceberPagarBean)) continue;
            receberPagar.add((ReceberPagarBean)this.modeloParcela.getValueAt(i, 4));
        }
        bean.setParcelas(receberPagar);
        HashSet<FaturaNotaFiscalBean> faturasNF = new HashSet<FaturaNotaFiscalBean>();
        if (this.faturasAnexas != null && this.faturasAnexas.length > 0) {
            for (String f : this.faturasAnexas) {
                FaturaBean fat = new FaturaBean();
                fat.setFilial(filial);
                fat.setCodigo(Integer.parseInt(f));
                FaturaNotaFiscalBean fatNF = new FaturaNotaFiscalBean();
                fatNF.setFilial(filial);
                fatNF.setFatura((FaturaVO)fat.toVO());
                fatNF.setNotaFiscal((NotaFiscalVO)bean.toVO());
                faturasNF.add(fatNF);
            }
        }
        if (this.listaFaturasAssociadas != null) {
            for (FaturaNotaFiscalBean fatura : this.listaFaturasAssociadas) {
                faturasNF.add(fatura);
            }
        }
        if (faturasNF != null && faturasNF.size() > 0) {
            bean.setFaturasNotaFiscal(faturasNF);
        }
        bean.setCofinsPercentual(Funcoes.isNumeric(this.textPercCofins.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPercCofins.getText())) : 0.0);
        bean.setCofinsValor(Funcoes.isNumeric(this.textValorCofins.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorCofins.getText())) : 0.0);
        bean.setIrrfPercentual(Funcoes.isNumeric(this.textPercIrrf.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPercIrrf.getText())) : 0.0);
        bean.setIrrfValor(Funcoes.isNumeric(this.textValorIrrf.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorIrrf.getText())) : 0.0);
        bean.setInssPercentual(Funcoes.isNumeric(this.textPercInss.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPercInss.getText())) : 0.0);
        bean.setInssValor(Funcoes.isNumeric(this.textValorInss.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorInss.getText())) : 0.0);
        bean.setCsllPercentual(Funcoes.isNumeric(this.textPercCsll.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPercCsll.getText())) : 0.0);
        bean.setCsllValor(Funcoes.isNumeric(this.textValorCsll.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorCsll.getText())) : 0.0);
        bean.setIssPercentual(Funcoes.isNumeric(this.textPercIss.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPercIss.getText())) : 0.0);
        bean.setIssValor(Funcoes.isNumeric(this.textValorIss.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorIss.getText())) : 0.0);
        bean.setPisPercentual(Funcoes.isNumeric(this.textPercPis.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPercPis.getText())) : 0.0);
        bean.setPisValor(Funcoes.isNumeric(this.textValorPis.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorPis.getText())) : 0.0);
        bean.setPercentualISSRetido(Funcoes.isNumeric(this.textPercIssRetido.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPercIssRetido.getText())) : 0.0);
        bean.setValorISSRetido(Funcoes.isNumeric(this.textValorIssRetido.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorIssRetido.getText())) : 0.0);
        bean.setPercentualInssRetido(Funcoes.isNumeric(this.textPercInssRetido.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPercInssRetido.getText())) : 0.0);
        bean.setValorInssRetido(Funcoes.isNumeric(this.textValorInssRetido.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorInssRetido.getText())) : 0.0);
        bean.setPercentualCofinsRetido(Funcoes.isNumeric(this.textPercCofinsRetido.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPercCofinsRetido.getText())) : 0.0);
        bean.setValorCofinsRetido(Funcoes.isNumeric(this.textValorCofinsRetido.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorCofinsRetido.getText())) : 0.0);
        bean.setPercentualCsllRetido(Funcoes.isNumeric(this.textPercCsllRetido.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPercCsllRetido.getText())) : 0.0);
        bean.setValorCsllRetido(Funcoes.isNumeric(this.textValorCsllRetido.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorCsllRetido.getText())) : 0.0);
        bean.setPercentualIrrfRetido(Funcoes.isNumeric(this.textPercIrrfRetido.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPercIrrfRetido.getText())) : 0.0);
        bean.setValorIrrfRetido(Funcoes.isNumeric(this.textValorIrrfRetido.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorIrrfRetido.getText())) : 0.0);
        bean.setPercentualPisRetido(Funcoes.isNumeric(this.textPercPisRetido.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textPercPisRetido.getText())) : 0.0);
        bean.setValorPisRetido(Funcoes.isNumeric(this.textValorPisRetido.getText()) ? Double.parseDouble(Funcoes.limpaDecimal(this.textValorPisRetido.getText())) : 0.0);
        bean.setInssPercentualOriginal(this.textPercInss.getPercentualOriginal());
        bean.setCofinsPercentualOriginal(this.textPercCofins.getPercentualOriginal());
        bean.setCsllPercentualOriginal(this.textPercCsll.getPercentualOriginal());
        bean.setIrrfPercentualOriginal(this.textPercIrrf.getPercentualOriginal());
        bean.setIssPercentualOriginal(this.textPercIss.getPercentualOriginal());
        bean.setPisPercentualOriginal(this.textPercPis.getPercentualOriginal());
        bean.setPercentualIssRetidoOriginal(this.textPercIssRetido.getPercentualOriginal());
        bean.setPercentualInssRetidoOriginal(this.textPercInssRetido.getPercentualOriginal());
        bean.setPercentualCofinsRetidoOriginal(this.textPercCofinsRetido.getPercentualOriginal());
        bean.setPercentualCsllRetidoOriginal(this.textPercCsllRetido.getPercentualOriginal());
        bean.setPercentualIrrfRetidoOriginal(this.textPercIrrfRetido.getPercentualOriginal());
        bean.setPercentualPisRetidoOriginal(this.textPercPisRetido.getPercentualOriginal());
        if (Funcoes.isNumeric(this.labelImpostosSobre.getText())) {
            bean.setImpostoAcumulado(Double.parseDouble(Funcoes.limpaDecimal(this.labelImpostosSobre.getText())));
        }
        if ((tipo = this.getTipoCadastroSelecionado()).equalsIgnoreCase("O") && !Funcoes.textoVazio(this.textCodigoCadastro)) {
            try {
                ConvenioVO convenio = (ConvenioVO)new ConvenioService().getVO(textFilial.getText(), this.textCodigoCadastro.getText());
                bean.setConvenio(convenio);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Conv\u00eanio n\u00e3o identificado.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        retorno = bean;
        return bean;
    }

    public void setSubTotal(Double subtotal) {
        if (subtotal != null) {
            this.textSubTotal.setText(Funcoes.formataDecimal(subtotal));
        }
        if (Funcoes.isNumeric(this.textCodigoCadastro.getText()) && !this.labelCadastro.getText().equals("N\u00e3o cadastrado") && Funcoes.isNumeric(this.textSubTotal.getText())) {
            NotaFiscalBean bean = this.getBeanPreenchido();
            this.serviceNota.pegaValorImpostos(bean, true);
            this.serviceNota.calculaImpostosAlterados(bean);
            this.calcularImpostos();
        }
    }

    public void setCadastro(String tipoCadastro, String codigo) {
        for (int i = 0; i < this.comboTipoCadastro.getItemCount(); ++i) {
            if (!((TipoCadastro)((Object)this.comboTipoCadastro.getItemAt(i))).tipo.equals(tipoCadastro)) continue;
            this.comboTipoCadastro.setSelectedIndex(i);
            break;
        }
        this.textCodigoCadastro.setText(codigo);
        this.buscaCadastro(this.textCodigoCadastro.getText());
        if (Funcoes.isNumeric(this.textCodigoCadastro.getText()) && !this.labelCadastro.getText().equals("N\u00e3o cadastrado") && Funcoes.isNumeric(this.textSubTotal.getText())) {
            NotaFiscalBean bean = this.getBeanPreenchido();
            this.serviceNota.pegaValorImpostos(bean, true);
            this.serviceNota.calculaImpostosAlterados(bean);
            this.atualizaImpostos(bean);
        }
    }

    public boolean isCadastroValidado() {
        return this.isCadastroValidado;
    }

    private void imprimir(NotaFiscalBean bean) {
        int resp;
        if (!isOK && (resp = Funcoes.mensagem(this, "A nota fiscal deve ser salva antes de imprimir.\nDeseja salvar a nota fiscal?", 4)) == 0) {
            bean = this.salvar(false);
        }
        if (isOK) {
            boolean impressaoOk = false;
            try {
                impressaoOk = this.serviceNota.imprimirNotaServico((NotaFiscalVO)bean.toVO());
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel imprimir a Nota Fiscal.\n" + e.getMessage(), e.getStackTrace());
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (impressaoOk) {
                if (this.intervaloFecharTela == 0 && this.buttonFechar.isEnabled()) {
                    this.buttonFechar.doClick();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel imprimir Nota Fiscal. N\u00e3o foi encontrado modelo de layout.", 2);
            }
        }
    }

    private NotaFiscalBean salvar(boolean fecharTela) {
        NotaFiscalBean notaBean;
        IntegracaoEnotas integracao;
        ConfiguracaoEnotasDto config;
        NotaFiscalBean bean = this.getBeanPreenchido();
        String[] aux = StringUtil.getValor(ParametrosGerais.getFiliaisIntegracao(), "filiaisIntegracao").split(",");
        if (bean != null && !Arrays.asList(aux).contains(String.valueOf(bean.getFilial().getCodigo()))) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Filial n\u00e3o permitida para a emiss\u00e3o de nota fiscal.", 2);
            return null;
        }
        if (this.sistemaEmissaoNFSe != null && this.sistemaEmissaoNFSe.equals((Object)SistemaEmissaoNFSe.ENOTAS) && bean != null && (config = (integracao = new IntegracaoEnotas(notaBean = bean)).getConfiguracaoEnotas(notaBean.getFilial().getCodigo())).getEnderecoAPI().contains("thread")) {
            Funcoes.mensagem(this, "Configura\u00e7\u00e3o inv\u00e1lida do Endere\u00e7o da API", 2);
            bean = null;
        }
        if (bean != null && this.validaCampos(bean)) {
            SplashMensagem splash = null;
            NotaFiscalBean beanNota = bean;
            try {
                NotaFiscalBean notaUsada = null;
                if (!isNotaFiscalEletronicaAtivada && (notaUsada = this.serviceNota.verificaNumeroSerieNotaFiscalDisponivel(beanNota.getFilial().getCodigo().toString(), beanNota.getNumero().toString(), beanNota.getSerie().getCodigo())) != null) {
                    StringBuilder buf = new StringBuilder();
                    buf.append("H\u00e1 uma nota fiscal de sa\u00edda com o n\u00famero: ").append(notaUsada.getNumero());
                    buf.append(", s\u00e9rie: ").append(notaUsada.getSerie().getCodigo());
                    buf.append(" (c\u00f3digo: ").append(notaUsada.getCodigo()).append(")\n");
                    buf.append("com a situa\u00e7\u00e3o: \"").append(Tipos.tipoSituacaoNotaFiscal(notaUsada.getSituacao(), notaUsada.getNumeroRps() != null)).append("\".\n");
                    if (notaUsada.getSituacao().equalsIgnoreCase("A")) {
                        buf.append("Para utilizar novamente essa numera\u00e7\u00e3o, deve-se ESTORNAR a nota.\nPor favor, verifique.");
                    } else {
                        buf.append("N\u00e3o \u00e9 poss\u00edvel reutilizar essa numera\u00e7\u00e3o.");
                    }
                    Funcoes.mensagem(this, buf.toString(), 2);
                    return null;
                }
                String idExterno = "";
                if (isNotaFiscalEletronicaAtivada) {
                    isAguardando = true;
                    if (tipoTela != 3 && tipoTela != 1) {
                        this.buttonCancelar.setText("Fechar");
                        this.buttonCancelar.setMnemonic('F');
                    }
                    this.serviceNota.serieAlterada(beanNota, textFilial.getText());
                    if (isNotaFiscalEletronicaAtivada && beanNota.getCodigo() == null) {
                        this.serviceNota.insert(beanNota, null, textFilial.getText(), "", this.faturasAnexas, this.faturasConferidas);
                        Conexao.arquivaSQL();
                    }
                    splash = tipoTela == 3 ? SplashMensagem.getInstancia(Laboratorio.getInstancia()) : SplashMensagem.getInstancia(dialog);
                    splash.mostrar("Gerando nota fiscal. Por favor aguarde..");
                    if (!beanNota.getSerie().isImprimirNota().booleanValue() && !beanNota.getSerie().isRelacionarNfse().booleanValue()) {
                        idExterno = this.serviceNota.gerarNotaFiscalEletronica(beanNota, textFilial.getText());
                    }
                    if (splash != null) {
                        splash.apagar();
                    }
                    this.serviceNota.corrigirObsRpsSerieAlterada(beanNota, textFilial.getText());
                    if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.ENOTAS) {
                        if (beanNota.getCodigo() != null) {
                            this.serviceNota.update(beanNota, beanNota.getCodigo(), textFilial.getText(), null);
                        } else {
                            this.serviceNota.insert(beanNota, null, textFilial.getText(), "", this.faturasAnexas, this.faturasConferidas);
                        }
                        this.alteraStatusLabel(beanNota);
                        Conexao.arquivaSQL();
                    }
                    this.alteraStatusLabel(beanNota);
                    Conexao.arquivaSQL();
                }
                if (!Funcoes.textoVazio(idExterno)) {
                    this.alteraStatusLabel(beanNota);
                    if (!isNotaFiscalEletronicaAtivada) {
                        if (beanNota.getCodigo() != null) {
                            this.serviceNota.update(beanNota, beanNota.getCodigo(), textFilial.getText(), null);
                        } else {
                            this.serviceNota.insert(beanNota, null, textFilial.getText(), "", this.faturasAnexas, this.faturasConferidas);
                        }
                    }
                    this.salvarOuAtualizarRequisicaoNotaFiscal(beanNota);
                    ReceberPagarService serviceRecPag = new ReceberPagarService();
                    Date dataCancelamento = new Date();
                    if (this.listaPreviasFaturamento != null) {
                        for (ReceberPagarBean recBean : this.listaPreviasFaturamento) {
                            serviceRecPag.cancelarReceberPagar(recBean.getFilial().getCodigo().toString(), recBean.getCodigo().toString(), dataCancelamento, Variaveis.login);
                        }
                    }
                    Conexao.arquivaSQL();
                    if (isNotaFiscalEletronicaAtivada && tipoTela != 3) {
                        this.labelDescStatusNota.setAviso(null);
                        this.inicializaParametroFecharTela();
                        if (this.cron == null) {
                            this.inicializaCronometro();
                        }
                        this.cron.executarCronometro();
                    }
                    if (!isNotaFiscalEletronicaAtivada) {
                        isOK = true;
                    }
                    isAguardando = false;
                } else {
                    isOK = false;
                    isAguardando = false;
                    Conexao.anulaSQL();
                }
                if (fecharTela || this.intervaloFecharTela == 0) {
                    if (isNotaFiscalEletronicaAtivada && this.cron != null) {
                        this.cron.parar();
                    }
                    if (this.getTopLevelAncestor() == Laboratorio.getInstancia()) {
                        this.setStatus(1);
                        this.controlaCampos();
                    } else {
                        this.getTopLevelAncestor().setVisible(false);
                    }
                } else {
                    this.alteraStatusLabel(beanNota);
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                this.anularSQL();
                if (splash != null) {
                    splash.apagar();
                }
                isOK = false;
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "NotaFiscalSaida: 1217");
            }
        }
        return retorno;
    }

    private void salvarOuAtualizarRequisicaoNotaFiscal(NotaFiscalBean beanNota) throws Exception {
        if (this.requisicoesBean != null && !this.requisicoesBean.isEmpty()) {
            if (this.sistemaEmissaoNFSe == SistemaEmissaoNFSe.ENOTAS) {
                this.requisicoesBean.forEach(req -> new RequisicaoNotaFiscalService().insert(beanNota, (RequisicaoBean)req));
            } else if (beanNota.getNumeroRps() == null && this.getStatus() == 2) {
                this.requisicoesBean.forEach(req -> new RequisicaoNotaFiscalService().insert(beanNota, (RequisicaoBean)req));
            } else {
                for (RequisicaoBean req2 : this.requisicoesBean) {
                    new RequisicaoNotaFiscalService().update(beanNota, req2, textFilial.getText(), null);
                }
            }
            Conexao.arquivaSQL();
        }
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void controlaCampos() {
        boolean enabled = !(this.getStatus() != 3 && this.getStatus() != 2 || isNotaFiscalEletronicaAtivada && isOK || isAguardando);
        boolean enableJuridica = tipoTela == 1 || tipoTela == 3;
        String situacao = retorno != null && !Funcoes.textoVazio(retorno.getSituacao()) ? retorno.getSituacao() : " ";
        this.itemEnviarEmail.setVisible(this.acessoEnviarEmail && NotaFiscalSaida.enviarEmailAtivo());
        this.comboTipoCadastro.setEnabled(false);
        this.textCodigoCadastro.setEnabled(enabled && tipoTela == 3);
        this.buttonBuscaCadastro.setEnabled(enabled && tipoTela == 3);
        this.textSubTotal.setEnabled(enabled && tipoTela == 3);
        this.textCodigoSerie.setEnabled(enabled);
        this.textNumeroNota.setEnabled(enabled && serie != null && serie.isImprimirNota() != false && serie.isRelacionarNfse() != false);
        this.textDataEmissao.setEnabled(enabled);
        this.textValorIrrf.setEnabled(enabled);
        this.textValorIss.setEnabled(enabled);
        this.textValorPis.setEnabled(enabled);
        this.textValorCsll.setEnabled(enabled);
        this.textValorCofins.setEnabled(enabled);
        this.textValorInss.setEnabled(enabled);
        this.textValorIssRetido.setEnabled(enabled);
        this.textValorInssRetido.setEnabled(enabled);
        this.textValorCofinsRetido.setEnabled(enabled);
        this.textValorCsllRetido.setEnabled(enabled);
        this.textValorIrrfRetido.setEnabled(enabled);
        this.textValorPisRetido.setEnabled(enabled);
        this.textCodigoServico.setEnabled(enabled);
        this.textCodigoForma.setEnabled(enabled);
        this.textParcela.setEnabled(enabled);
        this.textDataParcela.setEnabled(enabled);
        this.textValorParcela.setEnabled(enabled);
        this.textPercIrrf.setEnabled(enabled);
        this.textPercIss.setEnabled(enabled);
        this.textPercPis.setEnabled(enabled);
        this.textPercCsll.setEnabled(enabled);
        this.textPercCofins.setEnabled(enabled);
        this.textPercInss.setEnabled(enabled);
        this.textPercIssRetido.setEnabled(enabled);
        this.textPercInssRetido.setEnabled(enabled);
        this.textPercCofinsRetido.setEnabled(enabled);
        this.textPercCsllRetido.setEnabled(enabled);
        this.textPercIrrfRetido.setEnabled(enabled);
        this.textPercPisRetido.setEnabled(enabled);
        this.buttonAssociarFaturas.setEnabled(enabled);
        this.buttonBuscaSerie.setEnabled(enabled);
        this.buttonBuscaDataEmissao.setEnabled(enabled);
        this.buttonBuscaServico.setEnabled(enabled);
        this.buttonBuscaForma.setEnabled(enabled);
        this.buttonBuscaDataParcela.setEnabled(enabled);
        this.buttonOKParcela.setEnabled(enabled);
        textFilial.setEnabled(tipoTela == 3 && this.getStatus() != 1);
        this.buttonBuscaFilial.setEnabled(tipoTela == 3 && this.getStatus() != 1);
        this.buttonNovo.setEnabled((isOK || !isAguardando) && this.getStatus() == 1);
        this.buttonEditar.setEnabled(!isOK && !isAguardando && this.getStatus() == 1);
        if (situacao.equals("A") || situacao.equals("C") || situacao.equals("S")) {
            this.buttonEditar.setEnabled(false);
        }
        if (retorno != null && retorno.getNumeroRps() != null && situacao.equalsIgnoreCase("A")) {
            this.buttonSincronizar.setVisible(false);
        }
        if (retorno != null && retorno.getNumeroRps() != null && situacao.equalsIgnoreCase("X") && this.getStatus() == 3 && tipoTela == 3) {
            this.buttonSalvar.setVisible(true);
            this.buttonSalvar.setText("Reenviar");
        }
        if (retorno != null && retorno.getNumeroRps() == null && this.getStatus() == 2) {
            this.buttonSalvar.setText("Salvar");
        }
        if (tipoTela != 3) {
            this.buttonSalvar.setVisible(true);
        }
        if (isOK && this.getStatus() == 1 && (situacao.equalsIgnoreCase("R") || situacao.equalsIgnoreCase("D"))) {
            this.buttonSalvar.setEnabled(false);
        }
        if (situacao.equalsIgnoreCase("A") && isOK) {
            this.buttonSalvar.setEnabled(false);
        }
        if (this.getStatus() == 2) {
            this.buttonSalvar.setText("Salvar");
            this.buttonSalvar.setEnabled(true);
        }
        this.buttonCancelar.setEnabled(enableJuridica && !isAguardando && !isOK && this.getStatus() != 1 || !enableJuridica);
        this.buttonAssociarFaturas.setEnabled(!isAguardando);
        this.buttonImprimir.setEnabled(isOK && !isAguardando && this.getStatus() == 1);
        this.buttonFechar.setEnabled(this.getStatus() == 1 || isAguardando || isOK);
        this.buttonAssociarFaturas.setVisible(tipoTela == 3);
        this.buttonAssociarFaturas.setEnabled(this.getStatus() == 2 && !isAguardando);
        this.tableParcela.setEnabled(enabled);
        this.textObs.setEnabled(enabled);
        this.buttonOpcoesNfse.setEnabled(!isAguardando);
        boolean podeEnviarEmail = new EmailUtil().podeEnviarEmailNotaFiscal(Funcoes.textoVazio(textFilial) ? Variaveis.filialPadrao : textFilial.getText()) && retorno != null && retorno.getNumero() != null;
        this.itemEnviarEmail.setVisible(podeEnviarEmail);
        boolean podeBaixarXML = isNotaFiscalEletronicaAtivada && retorno != null && retorno.getXmlNfse() != null;
        this.itemBaixarXML.setVisible(podeBaixarXML);
        boolean podeBaixarPDF = isNotaFiscalEletronicaAtivada && retorno != null && retorno.getPdfRps() != null;
        this.itemBaixarPDF.setVisible(podeBaixarPDF);
        this.buttonOpcoesNfse.setVisible(tipoTela == 2 || podeEnviarEmail || podeBaixarXML || podeBaixarPDF);
        if (this.situacaoPermiteEdicao()) {
            this.buttonSalvar.setEnabled(false);
            this.buttonEditar.setEnabled(false);
        }
    }

    private boolean situacaoPermiteEdicao() {
        return retorno != null && !Funcoes.textoVazio(retorno.getChaveNfse()) && !retorno.getSituacao().equals("X") && !retorno.getSituacao().equals("A") && !retorno.getSituacao().equals("D") && !retorno.getSituacao().equals("C") && !retorno.getSituacao().equals("S");
    }

    private boolean validaCampos(NotaFiscalBean bean) {
        PacienteVO paciente;
        if (!this.validaCampos()) {
            return false;
        }
        if (bean != null && !this.validarImpostos(bean)) {
            return false;
        }
        if (bean == null || bean.getServico() == null || bean.getServico().getServico() == null) {
            Funcoes.mensagem(this, "Servi\u00e7o n\u00e3o informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoServico);
            return false;
        }
        if (this.modeloParcela.getRowCount() == 0 && tipoTela != 2) {
            Funcoes.mensagem(this, "Forma de pagamento n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoForma);
            return false;
        }
        if (this.getSomaParcelas() != Double.parseDouble(Funcoes.limpaDecimal(this.labelTotal.getText())) && tipoTela != 2) {
            Funcoes.mensagem(this, "A soma das parcelas \u00e9 diferente do valor da nota.", 2);
            ScreenUtil.requisitarFoco(this.textParcela);
            return false;
        }
        if (bean.getValor() <= 0.0) {
            Funcoes.mensagem(this, "O valor l\u00edquido da nota deve ser maior que zero.", 2);
            ScreenUtil.requisitarFoco(this.textParcela);
            return false;
        }
        if (!Funcoes.textoVazio(this.textSubTotal.getText()) && Double.parseDouble(this.textSubTotal.getText()) <= 0.0) {
            Funcoes.mensagem(this, "O valor l\u00edquido da nota deve ser maior que zero.", 2);
            ScreenUtil.requisitarFoco(this.textSubTotal);
            return false;
        }
        if (bean != null && this.sistemaEmissaoNFSe != SistemaEmissaoNFSe.ENOTAS) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel gerar a nota fiscal.\nVerifique as configura\u00e7\u00f5es", 2);
            ScreenUtil.requisitarFoco(this.textCodigoSerie);
            return false;
        }
        if (bean != null && bean.getPaciente() != null && tipoTela == 2 && (paciente = bean.getPaciente()).getCidade() != null && paciente.getCidade().getCodigoIbge() == null) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel enviar a Nota Fiscal.\nN\u00e3o foi encontrado o C\u00f3digo do IBGE no cadastro da Cidade.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoCadastro);
            return false;
        }
        return this.camposValidos(bean);
    }

    private boolean camposValidos(NotaFiscalBean bean) {
        String cep;
        CidadeVO cidade;
        ConvenioVO convenio = null;
        PacienteVO paciente = null;
        if (bean != null && tipoTela != 2) {
            convenio = bean.getConvenio();
        } else if (bean != null && tipoTela == 2) {
            paciente = bean.getPaciente();
        }
        String cepCadastro = paciente != null ? paciente.getCep() : convenio.getCep();
        CidadeVO cidadeVO = cidade = paciente != null ? paciente.getCidade() : convenio.getCidade();
        if (cidade != null && cidade.getCodigoIbge() == null) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel enviar a Nota Fiscal.\nN\u00e3o foi encontrado o C\u00f3digo do IBGE no cadastro da Cidade.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoCadastro);
            return false;
        }
        if (convenio != null && Funcoes.textoVazio(convenio.getCnpj())) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel enviar a Nota Fiscal.\nN\u00e3o foi encontrado o CNPJ no cadastro do Convenio.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoCadastro);
            return false;
        }
        if (!Funcoes.textoVazio(cepCadastro) && (cep = cepCadastro.replace("-", "")).length() != 8) {
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel enviar a Nota Fiscal.\nCEP inv\u00e1lido no cadastro do Convenio.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoCadastro);
            return false;
        }
        return true;
    }

    private boolean validaCampos() {
        if (!this.verificaButtonServicoClickado && Funcoes.textoVazio(this.textCodigoServico.getText())) {
            Funcoes.mensagem(this, "Servi\u00e7o n\u00e3o informado", 2);
            ScreenUtil.requisitarFoco(this.textCodigoServico);
            this.verificaButtonServicoClickado = false;
            return false;
        }
        if (Funcoes.textoVazio(textFilial.getText())) {
            Funcoes.mensagem(this, "Filial n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(textFilial);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoSerie.getText())) {
            Funcoes.mensagem(this, "S\u00e9rie n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoSerie);
            return false;
        }
        if (this.sistemaEmissaoNFSe != null && this.sistemaEmissaoNFSe != SistemaEmissaoNFSe.ENOTAS && Funcoes.textoVazio(this.textNumeroNota.getText())) {
            Funcoes.mensagem(this, "N\u00famero da nota fiscal n\u00e3o informado.", 2);
            ScreenUtil.requisitarFoco(this.textNumeroNota);
            return false;
        }
        if (Funcoes.textoVazio(this.textDataEmissao.getText())) {
            Funcoes.mensagem(this, "Data de emiss\u00e3o n\u00e3o informada.", 2);
            ScreenUtil.requisitarFoco(this.textDataEmissao);
            return false;
        }
        if (!Funcoes.textoVazio(this.textDataEmissao.getText()) && !Funcoes.verificaData(this.textDataEmissao.getText())) {
            Funcoes.mensagem(this, "Data de emiss\u00e3o inv\u00e1lida.", 2);
            ScreenUtil.requisitarFoco(this.textDataEmissao);
            return false;
        }
        if (Funcoes.textoVazio(this.textCodigoCadastro.getText()) || this.labelCadastro.getText().equals("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "Cadastro n\u00e3o informado.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoCadastro);
            return false;
        }
        if (!Funcoes.textoVazio(this.textCodigoSerie.getText()) && this.labelDescSerie.getText().equalsIgnoreCase("N\u00e3o cadastrado")) {
            Funcoes.mensagem(this, "S\u00e9rie n\u00e3o localizada.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoSerie);
            return false;
        }
        return true;
    }

    private boolean validarImpostos(NotaFiscalBean bean) {
        if (bean.getCofinsPercentual() < 0.0) {
            Funcoes.mensagem(this, "O percentual de COFINS deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercCofins);
            return false;
        }
        if (bean.getCofinsValor() < 0.0) {
            Funcoes.mensagem(this, "O valor de COFINS \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorCofins);
            return false;
        }
        if (bean.getCsllPercentual() < 0.0) {
            Funcoes.mensagem(this, "O percentual de CSLL deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercCsll);
            return false;
        }
        if (bean.getCsllValor() < 0.0) {
            Funcoes.mensagem(this, "O valor de CSLL \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorCofins);
            return false;
        }
        if (bean.getInssPercentual() < 0.0) {
            Funcoes.mensagem(this, "O percentual de INSS deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercInss);
            return false;
        }
        if (bean.getInssValor() < 0.0) {
            Funcoes.mensagem(this, "O valor de INSS \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorInss);
            return false;
        }
        if (bean.getInssPercentual() < 0.0) {
            Funcoes.mensagem(this, "O percentual de INSS deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercInss);
            return false;
        }
        if (bean.getInssValor() < 0.0) {
            Funcoes.mensagem(this, "O valor de INSS \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorInss);
            return false;
        }
        if (bean.getIrrfPercentual() < 0.0) {
            Funcoes.mensagem(this, "O percentual de IRRF deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercIrrf);
            return false;
        }
        if (bean.getIrrfValor() < 0.0) {
            Funcoes.mensagem(this, "O valor de IRRF \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorIrrf);
            return false;
        }
        if (bean.getIssPercentual() < 0.0) {
            Funcoes.mensagem(this, "O percentual de ISS deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercIss);
            return false;
        }
        if (bean.getIssValor() < 0.0) {
            Funcoes.mensagem(this, "O valor de ISS \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorIss);
            return false;
        }
        if (bean.getPisPercentual() < 0.0) {
            Funcoes.mensagem(this, "O percentual de PIS deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercPis);
            return false;
        }
        if (bean.getPisValor() < 0.0) {
            Funcoes.mensagem(this, "O valor de PIS \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorPis);
            return false;
        }
        if (bean.getPercentualISSRetido() < 0.0) {
            Funcoes.mensagem(this, "O percentual de ISS RETIDO deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercIssRetido);
            return false;
        }
        if (bean.getValorISSRetido() < 0.0) {
            Funcoes.mensagem(this, "O valor de ISS RETIDO \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorIssRetido);
            return false;
        }
        if (bean.getPercentualInssRetido() < 0.0) {
            Funcoes.mensagem(this, "O percentual de INSS RETIDO deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercInssRetido);
            return false;
        }
        if (bean.getValorISSRetido() < 0.0) {
            Funcoes.mensagem(this, "O valor de ISS RETIDO \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorInssRetido);
            return false;
        }
        if (bean.getPercentualCofinsRetido() < 0.0) {
            Funcoes.mensagem(this, "O percentual de COFINS RETIDO deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercCofinsRetido);
            return false;
        }
        if (bean.getValorCofinsRetido() < 0.0) {
            Funcoes.mensagem(this, "O valor de COFINS RETIDO \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorCofinsRetido);
            return false;
        }
        if (bean.getPercentualCsllRetido() < 0.0) {
            Funcoes.mensagem(this, "O percentual de CSLL RETIDO deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercCsllRetido);
            return false;
        }
        if (bean.getValorCsllRetido() < 0.0) {
            Funcoes.mensagem(this, "O valor de CSLL RETIDO \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorCsllRetido);
            return false;
        }
        if (bean.getPercentualIrrfRetido() < 0.0) {
            Funcoes.mensagem(this, "O percentual de IRRF RETIDO deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercIrrfRetido);
            return false;
        }
        if (bean.getValorIrrfRetido() < 0.0) {
            Funcoes.mensagem(this, "O valor de IRRF RETIDO \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorIrrfRetido);
            return false;
        }
        if (bean.getPercentualPisRetido() < 0.0) {
            Funcoes.mensagem(this, "O percentual de PIS RETIDO deve ser maior ou igual a zero.", 2);
            ScreenUtil.requisitarFoco(this.textPercPisRetido);
            return false;
        }
        if (bean.getValorPisRetido() < 0.0) {
            Funcoes.mensagem(this, "O valor de PIS RETIDO \u00e9 menor que zero. Verifique se h\u00e1 impostos acumulados.", 2);
            ScreenUtil.requisitarFoco(this.textValorPisRetido);
            return false;
        }
        if (bean.getIssValor() > 0.0 && bean.getValorISSRetido() > 0.0) {
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel informar valor de ISS devido e retido na mesma nota fiscal.", 2);
            ScreenUtil.requisitarFoco(this.textValorIss);
            return false;
        }
        return true;
    }

    public Double getSomaParcelas() {
        NotaFiscalBean notaAux = this.getBeanPreenchido();
        if (notaAux == null) {
            return 0.0;
        }
        Iterator it = notaAux.getParcelas().iterator();
        BigDecimal soma = new BigDecimal(0).setScale(4, RoundingMode.HALF_UP);
        while (it.hasNext()) {
            ReceberPagarBean bean = (ReceberPagarBean)it.next();
            soma = soma.add(BigDecimal.valueOf(bean.getValorTotal()).setScale(4, RoundingMode.HALF_UP));
        }
        soma = soma.setScale(2, RoundingMode.HALF_UP);
        return soma.doubleValue();
    }

    public void setDataEmissao(Date data) {
        if (data != null) {
            this.textDataEmissao.setText(Funcoes.formataData(data));
        }
    }

    public void setFaturasRelacionadas(String ... faturas) {
        this.faturasAnexas = faturas;
    }

    private void editarPlanoCusto(int linha) {
        if (this.modeloParcela.getValueAt(linha, 4) != null && this.modeloParcela.getValueAt(linha, 4) instanceof ReceberPagarBean) {
            ParcelaPlanoCusto plc = ParcelaPlanoCusto.novaInstancia(this.getTopLevelAncestor(), textFilial.getText());
            ReceberPagarBean bean = (ReceberPagarBean)this.modeloParcela.getValueAt(linha, 4);
            ReceberPagarService service = new ReceberPagarService();
            if (plc != null) {
                plc.setReceberPagar(bean);
                plc.setService(service);
                plc.setPlanoContas(bean.getPlanosContas());
                plc.setCentroCusto(bean.getCentrosCusto());
                plc.setResumo(this.resumo);
                plc.atualizarPlanosCustos();
                plc.setVisible(true);
                if (plc.getOK()) {
                    ReceberPagarBean b = (ReceberPagarBean)this.modeloParcela.getValueAt(linha, 4);
                    if (plc.getPlanoConta() != null) {
                        b.setPlanosContas(new HashSet<AbstractThreadBean>(plc.getPlanoConta()));
                    } else {
                        b.setPlanosContas(null);
                    }
                    if (plc.getCentroCusto() != null) {
                        b.setCentrosCusto(new HashSet<AbstractThreadBean>(plc.getCentroCusto()));
                    } else {
                        b.setCentrosCusto(null);
                    }
                }
            }
        }
    }

    public String getComposicao(NotaFiscalBean bean) {
        StringBuilder composicao = new StringBuilder();
        ArrayList<NotaFiscalVO> setComposicao = new NotaFiscalService().getComposicaoImpostosNota(bean);
        for (NotaFiscalVO aux : setComposicao) {
            if (composicao.length() > 0) {
                composicao.append(", ");
            }
            composicao.append(aux.getNumero());
        }
        if (composicao.length() == 0) {
            composicao.append(" ");
        }
        return composicao.toString();
    }

    @Override
    @Deprecated
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setLancamentosPagamentos(Set lancamentosPagamentos) {
        this.lancamentosPagamentos = lancamentosPagamentos;
    }

    public void setRequisicaoBean(List<RequisicaoBean> requisicoesBean) {
        this.requisicoesBean = requisicoesBean;
    }

    private List<RequisicaoBean> getRequisicoesBean() {
        return this.requisicoesBean;
    }

    public void setNomePagador(String nomePagador) {
        this.nomePagador = nomePagador;
    }

    public void setCpfPagador(String cpfPagador) {
        this.cpfPagador = cpfPagador;
    }

    private void novo() {
        this.limparCampos(false);
        textFilial.setText(Variaveis.filialPadrao);
        this.getDescricaoFilial(textFilial.getText());
        this.controlaCampos();
        this.textDataEmissao.setText(Funcoes.formataData(new Date()));
        ScreenUtil.requisitarFoco(textFilial);
        this.validaSeriePadraoBloqueioAcesso();
    }

    private void associarFaturas() {
        if (!this.validaCampos()) {
            return;
        }
        NotaFiscalBean notaBean = this.getBeanPreenchido();
        if (notaBean.getConvenio() == null) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar o conv\u00eanio da nota fiscal.", 2);
            ScreenUtil.requisitarFoco(this.textCodigoCadastro);
            return;
        }
        if (notaBean.getValor() == null || notaBean.getValor() == 0.0) {
            Funcoes.mensagem(this, "\u00c9 necess\u00e1rio informar o valor da nota fiscal.", 2);
            ScreenUtil.requisitarFoco(this.textSubTotal);
            return;
        }
        AssociarFaturasNota telaAssociar = AssociarFaturasNota.novaInstancia((Window)this.getTopLevelAncestor(), notaBean, this.listaFaturasAssociadas);
        telaAssociar.setVisible(true);
        if (telaAssociar.getOK()) {
            this.listaFaturasAssociadas = telaAssociar.getFaturasAssociadas();
        }
    }

    private void editar() {
        block5: {
            NotaFiscalVO notaVO = (NotaFiscalVO)new NotaFiscalService().pesquisaNotaFiscalPessoaJuridica(this.getTopLevelAncestor(), new NotaFiscalVO(), "Pesquisando notas fiscais de pessoa jur\u00eddica", textFilial.getText());
            if (notaVO != null) {
                try {
                    NotaFiscalBean notaBean = (NotaFiscalBean)new NotaFiscalService().get(notaVO.getFilial().getCodigo().toString(), notaVO.getCodigo().toString());
                    if (notaBean != null) {
                        this.preencheDados(notaBean, null, this.listaPreviasFaturamento);
                        break block5;
                    }
                    this.setStatus(1);
                    textFilial.setEnabled(true);
                    this.buttonBuscaFilial.setEnabled(true);
                    ScreenUtil.requisitarFoco(textFilial);
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel carregar os dados da nota fiscal.\n" + e.getMessage(), e.getStackTrace());
                }
            } else {
                this.setStatus(1);
                textFilial.setEnabled(true);
                this.buttonBuscaFilial.setEnabled(true);
                ScreenUtil.requisitarFoco(textFilial);
            }
        }
        isAguardando = false;
        this.controlaCampos();
    }

    public boolean isOk() {
        return isOK;
    }

    private static enum TipoCadastro {
        FUNCIONARIO("U", Tipos.tipoCadastro("U")),
        FORNECEDOR("F", Tipos.tipoCadastro("F")),
        COLETADOR("C", Tipos.tipoCadastro("C")),
        REPRESENTANTE("R", Tipos.tipoCadastro("R")),
        PACIENTE("P", Tipos.tipoCadastro("P")),
        EMPRESA("E", Tipos.tipoCadastro("E")),
        CONVENIO("O", Tipos.tipoCadastro("O"));

        private String tipo = "";
        private String descricao = "";

        private TipoCadastro(String tipo, String descricao) {
            this.tipo = tipo;
            this.descricao = descricao;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String getTipo() {
            return this.tipo;
        }

        public String toString() {
            return this.descricao;
        }
    }
}

