/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro;

import jalis.laboratorio.financeiro.NotaFiscalSaida;
import jalis.util.TAvisoLabel;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JDialog;

class CronometroRegressivo {
    private Timer cronometro;
    private Calendar calendario = Calendar.getInstance();
    private TAvisoLabel campo = null;
    private final byte contagem;
    public static final byte PROGRESSIVA = 1;
    public static final byte REGRESSIVA = -1;
    private TimerTask tarefa = null;
    private SimpleDateFormat meuFormato = new SimpleDateFormat("ss");
    NotaFiscalSaida telaNotaSaida = null;
    JDialog dialogNotaSaida = null;
    private final int limite = 3;
    private int contador = 0;
    private boolean isExecutando = false;

    public CronometroRegressivo(int segundos, byte tipoContagem, TAvisoLabel campo, NotaFiscalSaida telaNota, JDialog dialog) {
        this.cronometro = new Timer();
        this.contagem = tipoContagem;
        this.campo = campo;
        this.telaNotaSaida = telaNota;
        this.dialogNotaSaida = dialog;
        this.calendario.set(0, 0, 0, 0, 0, segundos);
    }

    public void executarCronometro() {
        this.tarefa = new TimerTask(){

            @Override
            public void run() {
                boolean isTempoFinalizado;
                String aux = CronometroRegressivo.this.getTime();
                CronometroRegressivo.this.isExecutando = true;
                int intervalo = -1;
                boolean bl = isTempoFinalizado = aux != null ? aux.equals("00") : false;
                if (CronometroRegressivo.this.telaNotaSaida != null && CronometroRegressivo.this.telaNotaSaida.getRetorno() != null && CronometroRegressivo.this.telaNotaSaida.getRetorno().getSituacao().equalsIgnoreCase("X")) {
                    CronometroRegressivo.this.campo.setForeground(Color.red);
                    CronometroRegressivo.this.campo.setText("Aguardando confirma\u00e7\u00e3o [" + aux + " seg.]");
                }
                if (CronometroRegressivo.this.telaNotaSaida != null && CronometroRegressivo.this.contador == 3) {
                    CronometroRegressivo.this.telaNotaSaida.atualizaTela();
                    CronometroRegressivo.this.contador = 0;
                }
                CronometroRegressivo.this.contador++;
                if (CronometroRegressivo.this.telaNotaSaida != null && CronometroRegressivo.this.telaNotaSaida.getRetorno() != null) {
                    intervalo = CronometroRegressivo.this.telaNotaSaida.getIntervaloFecharTela();
                }
                if (isTempoFinalizado && intervalo > 0) {
                    if (CronometroRegressivo.this.dialogNotaSaida != null) {
                        CronometroRegressivo.this.dialogNotaSaida.setVisible(false);
                    }
                    if (CronometroRegressivo.this.telaNotaSaida != null) {
                        CronometroRegressivo.this.telaNotaSaida.setVisible(false);
                    }
                    CronometroRegressivo.this.parar();
                    CronometroRegressivo.this.isExecutando = false;
                }
                if (CronometroRegressivo.this.telaNotaSaida != null && CronometroRegressivo.this.telaNotaSaida.getRetorno() != null && CronometroRegressivo.this.telaNotaSaida.getRetorno().getSituacao().equalsIgnoreCase("A")) {
                    CronometroRegressivo.this.parar();
                    CronometroRegressivo.this.telaNotaSaida.atualizaTela();
                    CronometroRegressivo.this.isExecutando = false;
                }
            }
        };
        this.cronometro.scheduleAtFixedRate(this.tarefa, 0L, 1000L);
    }

    private String getTime() {
        this.calendario.add(13, this.contagem);
        return this.meuFormato.format(this.calendario.getTime());
    }

    public void parar() {
        if (this.tarefa != null) {
            this.tarefa.cancel();
        }
    }

    public boolean isAtivo() {
        return this.isExecutando;
    }
}

