/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.financeiro.Exame;
import jalis.laboratorio.financeiro.Exames;
import jalis.laboratorio.financeiro.SolicitarMotivoContraSenha;
import jalis.laboratorio.recepcao.ContrassenhaDesconto;
import jalis.service.financeiro.ContrasSenhaService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class Contrassenha
extends FrmPadrao {
    JPanel panelBotoes = new JPanel(new FlowLayout(2));
    JPanel panelCentro = new JPanel(null);
    JButton buttonNovo = new JButton("Novo");
    JButton buttonGerar = new JButton("Gerar contrassenha");
    JButton buttonFechar = new JButton("Fechar");
    JLabel labelSenha = new JLabel("Senha:");
    TTextField txtSenha = new TTextField(18, 1);
    JLabel labelPaciente = new JLabel("Paciente:");
    TTextField txtCodPaciente = new TTextField(15, 1);
    JButton buttonBuscaPaciente = new JButton();
    JLabel labelValorPaciente = new JLabel();
    JLabel labelDesconto = new JLabel("Desconto:");
    JLabel labelValorDesconto = new JLabel();
    JLabel labelPercentual = new JLabel("%");
    JTable tableRequisicao = new JTable();
    JTable tableExame = new JTable();
    JScrollPane scrollRequisicao = new JScrollPane(this.tableRequisicao);
    JScrollPane scrollExame = new JScrollPane(this.tableExame);
    ModeloGridTable modeloRequisicao = new ModeloGridTable(new String[]{"C\u00f3digo", "Data", "Conv\u00eanio"});
    ModeloGridTable modeloExame = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Descri\u00e7\u00e3o"});
    JPanel panelRequisicao = new JPanel(new BorderLayout());
    JPanel panelExame = new JPanel(new BorderLayout());
    JPanel panelPagamento = new JPanel(null);
    JLabel labelTotal = new JLabel("Total:");
    JLabel labelPago = new JLabel("Pago:");
    JLabel labelPgDesconto = new JLabel("Desconto:");
    JLabel labelAcrescimo = new JLabel("Acr\u00e9scimo:");
    JLabel labelValorTotal = new JLabel();
    JLabel labelValorPago = new JLabel();
    JLabel labelValorPgDesconto = new JLabel();
    JLabel labelValorPercentualDesconto = new JLabel();
    JLabel labelValorAcrescimo = new JLabel();
    JLabel labelValorPercentualAcrescimo = new JLabel();
    JLabel labelPercentual1 = new JLabel("%");
    JLabel labelPercentual2 = new JLabel("%");
    final int COLUNA_EXAMES = 3;
    final int COLUNA_TOTAL = 4;
    final int COLUNA_PAGO = 5;
    final int COLUNA_DESCONTO = 7;
    final int COLUNA_VALORDESCONTO = 6;
    final int COLUNA_ACRESCIMO = 9;
    final int COLUNA_VALORACRESCIMO = 8;
    int status = 1;

    public Contrassenha() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ContrassenhaExames");
        }
    }

    public void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonGerar);
        this.panelBotoes.add(this.buttonFechar);
        this.panelCentro.add(this.labelSenha);
        this.panelCentro.add(this.txtSenha);
        this.panelCentro.add(this.labelPaciente);
        this.panelCentro.add(this.txtCodPaciente);
        this.panelCentro.add(this.buttonBuscaPaciente);
        this.panelCentro.add(this.labelValorPaciente);
        this.panelCentro.add(this.labelDesconto);
        this.panelCentro.add(this.labelValorDesconto);
        this.panelCentro.add(this.labelPercentual);
        this.panelCentro.add(this.panelRequisicao);
        this.panelCentro.add(this.panelExame);
        this.panelCentro.add(this.panelPagamento);
        this.panelRequisicao.add((Component)this.scrollRequisicao, "Center");
        this.panelExame.add((Component)this.scrollExame, "Center");
        this.panelPagamento.add(this.labelTotal);
        this.panelPagamento.add(this.labelPago);
        this.panelPagamento.add(this.labelPgDesconto);
        this.panelPagamento.add(this.labelAcrescimo);
        this.panelPagamento.add(this.labelValorTotal);
        this.panelPagamento.add(this.labelValorPago);
        this.panelPagamento.add(this.labelValorPgDesconto);
        this.panelPagamento.add(this.labelValorPercentualDesconto);
        this.panelPagamento.add(this.labelValorAcrescimo);
        this.panelPagamento.add(this.labelValorPercentualAcrescimo);
        this.panelPagamento.add(this.labelPercentual1);
        this.panelPagamento.add(this.labelPercentual2);
        this.panelRequisicao.setBorder(BorderFactory.createTitledBorder("Requisi\u00e7\u00f5es"));
        this.panelExame.setBorder(BorderFactory.createTitledBorder("Exames"));
        this.panelPagamento.setBorder(BorderFactory.createTitledBorder("Pagamentos"));
        Funcoes.criaBarraDescricao(this, "Contrassenha de Exames", "Valida\u00e7\u00e3o de contrassenha de desconto", "contra_senha_on.jpg");
        this.labelSenha.setBounds(new Rectangle(5, 10, 69, 14));
        this.txtSenha.setBounds(new Rectangle(75, 8, 150, 20));
        this.labelPaciente.setBounds(new Rectangle(5, 31, 150, 14));
        this.txtCodPaciente.setBounds(new Rectangle(75, 29, 100, 20));
        this.buttonBuscaPaciente.setBounds(new Rectangle(176, 29, 20, 20));
        this.labelValorPaciente.setBounds(new Rectangle(197, 29, 250, 20));
        this.labelDesconto.setBounds(new Rectangle(5, 52, 69, 14));
        this.labelValorDesconto.setBounds(new Rectangle(75, 50, 69, 20));
        this.labelPercentual.setBounds(new Rectangle(145, 52, 20, 14));
        this.labelTotal.setBounds(new Rectangle(5, 20, 69, 14));
        this.labelPago.setBounds(new Rectangle(5, 41, 69, 14));
        this.labelPgDesconto.setBounds(new Rectangle(130, 20, 69, 14));
        this.labelAcrescimo.setBounds(new Rectangle(130, 41, 69, 14));
        this.labelValorTotal.setBounds(new Rectangle(65, 18, 60, 20));
        this.labelValorPago.setBounds(new Rectangle(65, 39, 60, 20));
        this.labelValorPgDesconto.setBounds(new Rectangle(200, 18, 50, 20));
        this.labelValorPercentualDesconto.setBounds(new Rectangle(271, 18, 50, 20));
        this.labelValorAcrescimo.setBounds(new Rectangle(200, 39, 50, 20));
        this.labelValorPercentualAcrescimo.setBounds(new Rectangle(271, 39, 50, 20));
        this.labelPercentual1.setBounds(new Rectangle(251, 20, 10, 14));
        this.labelPercentual2.setBounds(new Rectangle(251, 41, 10, 14));
        this.buttonNovo.setMnemonic('N');
        this.buttonGerar.setMnemonic('G');
        this.buttonFechar.setMnemonic('F');
        this.buttonBuscaPaciente.setFocusable(false);
        this.labelValorDesconto.setHorizontalAlignment(4);
        this.labelValorTotal.setHorizontalAlignment(4);
        this.labelValorPago.setHorizontalAlignment(4);
        this.labelValorPgDesconto.setHorizontalAlignment(4);
        this.labelValorPercentualDesconto.setHorizontalAlignment(4);
        this.labelValorAcrescimo.setHorizontalAlignment(4);
        this.labelValorPercentualAcrescimo.setHorizontalAlignment(4);
        this.tableRequisicao.setModel(this.modeloRequisicao);
        this.tableExame.setModel(this.modeloExame);
        this.modeloExame.setColumnSize(new int[]{60, 60, 0}, this.tableExame);
        this.modeloRequisicao.setColumnSize(new int[]{80, 90, 0}, this.tableRequisicao);
        Funcoes.imagemPesquisa(this.buttonBuscaPaciente);
        this.posicionaComponentes();
        this.controlaCampos();
        ScreenUtil.setBorda(new Component[]{this.labelValorPaciente, this.labelValorDesconto, this.labelValorTotal, this.labelValorPago, this.labelValorPgDesconto, this.labelValorPercentualDesconto, this.labelValorAcrescimo, this.labelValorPercentualAcrescimo}, BorderFactory.createTitledBorder(""));
        this.panelCentro.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Contrassenha.this.posicionaComponentes();
            }
        });
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Contrassenha.this.setVisible(false);
            }
        });
        this.buttonBuscaPaciente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Contrassenha.this.buscaPaciente();
            }
        });
        this.buttonGerar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(Contrassenha.this.txtSenha.getText())) {
                    Contrassenha.this.buttonGerar.setEnabled(false);
                    String motivo = "";
                    SolicitarMotivoContraSenha m = new SolicitarMotivoContraSenha((Frame)Contrassenha.this.getTopLevelAncestor());
                    m.setVisible(true);
                    if (!m.ok()) {
                        Contrassenha.this.buttonGerar.setEnabled(true);
                        return;
                    }
                    motivo = m.getObs();
                    String contra = ContrassenhaDesconto.gerarContraSenha(Contrassenha.this.txtSenha.getText());
                    Funcoes.mensagem(Contrassenha.this, "Contrassenha: " + contra, 5);
                    try {
                        Statement st = Conexao.getStatement();
                        StringBuilder buf = new StringBuilder("insert into contrasenha(fil_codigo, cse_codigo, cse_desconto, cse_datahora, ");
                        buf.append("cse_motivo, usr_codigo) values (");
                        buf.append(Variaveis.filialPadrao);
                        buf.append(", ");
                        buf.append(DBUtil.getSequencia(st, "contrasenha", true));
                        buf.append(", ");
                        if (Funcoes.isNumeric(Contrassenha.this.labelValorDesconto.getText())) {
                            buf.append(Funcoes.limpaDecimal(Contrassenha.this.labelValorDesconto.getText()));
                        } else {
                            buf.append("0");
                        }
                        buf.append(", current_timestamp, '");
                        buf.append(StringUtil.textoDB(motivo));
                        buf.append("', '");
                        buf.append(Variaveis.login);
                        buf.append("')");
                        Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
                        Conexao.arquivaSQL();
                    }
                    catch (Exception ex) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(Contrassenha.this, ex.getMessage(), ex.getStackTrace(), "ContrassenhaExames");
                    }
                    Contrassenha.this.buttonGerar.setEnabled(true);
                }
            }
        });
        this.txtCodPaciente.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(Contrassenha.this.txtCodPaciente.getText())) {
                    return;
                }
                if (!Contrassenha.this.txtSenha.getText().startsWith("1")) {
                    Contrassenha.this.buscaDados();
                }
            }
        });
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Contrassenha.this.limpaCampos();
                Contrassenha.this.status = 2;
                Contrassenha.this.txtSenha.requestFocus();
                Contrassenha.this.controlaCampos();
            }
        });
        this.tableRequisicao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (Contrassenha.this.tableRequisicao.getSelectedRow() > -1) {
                    Contrassenha.this.mostraInfoExame(Contrassenha.this.tableRequisicao.getSelectedRow());
                }
            }
        });
        this.tableRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (Contrassenha.this.tableRequisicao.getSelectedRow() > -1) {
                    Contrassenha.this.mostraInfoExame(Contrassenha.this.tableRequisicao.getSelectedRow());
                }
            }
        });
        this.tableRequisicao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (Contrassenha.this.tableRequisicao.getSelectedRow() > -1) {
                    Contrassenha.this.mostraInfoExame(Contrassenha.this.tableRequisicao.getSelectedRow());
                }
            }
        });
        this.txtSenha.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(Contrassenha.this.txtSenha.getText()) && Contrassenha.this.txtSenha.getText().length() >= 10) {
                    String senha = Contrassenha.this.txtSenha.getText();
                    if (senha.startsWith("1")) {
                        String paciente = senha.substring(1, 5) + senha.substring(7);
                        if (Funcoes.isNumeric(paciente)) {
                            Contrassenha.this.txtCodPaciente.setText(String.valueOf(Integer.parseInt(paciente)));
                        }
                        Contrassenha.this.buscaDados();
                    } else {
                        Contrassenha.this.txtCodPaciente.clear();
                    }
                    Contrassenha.this.txtCodPaciente.setEnabled(Funcoes.textoVazio(Contrassenha.this.txtCodPaciente.getText()));
                    if (Contrassenha.this.txtCodPaciente.isEnabled()) {
                        Contrassenha.this.txtCodPaciente.requestFocus();
                    }
                    Contrassenha.this.buttonBuscaPaciente.setEnabled(Funcoes.textoVazio(Contrassenha.this.txtCodPaciente.getText()));
                    if (Funcoes.isNumeric(senha.substring(5, 7))) {
                        Contrassenha.this.labelValorDesconto.setText(String.valueOf(Integer.parseInt(senha.substring(5, 7))));
                    }
                }
                Contrassenha.this.controlaCampos();
            }
        });
    }

    private void posicionaComponentes() {
        this.labelValorPaciente.setBounds(new Rectangle(197, 29, this.panelCentro.getWidth() - 202, 20));
        this.panelRequisicao.setBounds(new Rectangle(5, 75, this.panelCentro.getWidth() / 2 - 5, this.panelCentro.getHeight() - 79));
        this.panelExame.setBounds(new Rectangle(this.panelCentro.getWidth() / 2, 75, this.panelCentro.getWidth() / 2 - 5, this.panelCentro.getHeight() - 75 - 100));
        this.panelPagamento.setBounds(new Rectangle(this.panelCentro.getWidth() / 2, this.panelExame.getY() + this.panelExame.getHeight() + 1, this.panelCentro.getWidth() / 2 - 5, 95));
        this.panelRequisicao.revalidate();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0600500000");
    }

    public void defineAcessos() {
        this.buttonGerar.setVisible(Acesso.getAcesso(Long.parseLong("0600500001")));
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCodPaciente.hasFocus()) {
            this.buscaPaciente();
        }
    }

    private void buscaPaciente() {
        Hashtable resultado = Pesquisas.paciente(this.getTopLevelAncestor(), Variaveis.filialPadrao, true, false, false, false);
        if (resultado != null) {
            this.txtCodPaciente.setText(resultado.get("pac_codigo").toString());
        }
        this.txtCodPaciente.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDados() {
        if (Funcoes.textoVazio(this.txtCodPaciente.getText())) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.modeloExame.clear();
        this.modeloRequisicao.clear();
        try {
            Statement st = Conexao.getStatement();
            Statement stExm = Conexao.getStatement();
            String paciente = new ContrasSenhaService().retornaPacienteNome(Variaveis.filialPadrao, this.txtCodPaciente.getText());
            if (!Funcoes.textoVazio(paciente)) {
                this.labelValorPaciente.setText(paciente);
                StringBuffer buf = new StringBuffer("");
                buf.append("select a.req_codigo, a.req_data, a.con_codigo, b.con_fantasia, ");
                buf.append("a.req_total, a.req_totpago, a.req_desconto, a.req_vlrdesconto, a.req_acrescimo, a.req_vlracrescimo ");
                buf.append("from requisicao a ");
                buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
                buf.append("where a.fil_codigo = ");
                buf.append(Variaveis.filialPadrao);
                buf.append(" and a.pac_codigo = ");
                buf.append(this.txtCodPaciente.getText());
                buf.append(" and a.req_excluida = false ");
                buf.append(" order by a.req_codigo ");
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    do {
                        String requisicao = rs.getString("req_codigo");
                        buf.delete(0, buf.length());
                        buf.append("select a.exa_codigo, b.exa_descricao, a.mco_codigo from examerequisicao a ");
                        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and upper(a.exa_codigo) = upper(b.exa_codigo) ");
                        buf.append("where a.fil_codigo = ");
                        buf.append(Variaveis.filialPadrao);
                        buf.append(" and a.req_codigo = ");
                        buf.append(requisicao);
                        buf.append(" and a.exr_excluido = false ");
                        buf.append(" order by a.exa_codigo ");
                        Exames e = new Exames();
                        try (ResultSet rsExm = null;){
                            rsExm = stExm.executeQuery(buf.toString());
                            while (rsExm.next()) {
                                DadosMaterial m = ExameUtil.getDadosMaterial(Variaveis.filialPadrao, rsExm.getInt("mco_codigo"));
                                e.addExame(new Exame(rsExm.getString("exa_codigo"), rsExm.getString("exa_descricao"), m.getDescricao()));
                            }
                        }
                        this.modeloRequisicao.addLine(new Object[]{requisicao, Funcoes.formataData(rs.getDate("req_data")), rs.getString("con_fantasia"), e, Funcoes.formataDecimal(DBUtil.campoNull(rs.getString("req_total")) ? 0.0 : rs.getDouble("req_total")), Funcoes.formataDecimal(DBUtil.campoNull(rs.getString("req_totpago")) ? 0.0 : rs.getDouble("req_totpago")), Funcoes.formataDecimal(DBUtil.campoNull(rs.getString("req_desconto")) ? 0.0 : rs.getDouble("req_desconto")), Funcoes.formataDecimal(DBUtil.campoNull(rs.getString("req_vlrdesconto")) ? 0.0 : rs.getDouble("req_vlrdesconto")), Funcoes.formataDecimal(DBUtil.campoNull(rs.getString("req_acrescimo")) ? 0.0 : rs.getDouble("req_acrescimo")), Funcoes.formataDecimal(DBUtil.campoNull(rs.getString("req_vlracrescimo")) ? 0.0 : rs.getDouble("req_vlracrescimo"))});
                    } while (rs.next());
                    if (this.tableRequisicao.getRowCount() > 0) {
                        this.tableRequisicao.setRowSelectionInterval(0, 0);
                    }
                    this.tableRequisicao.requestFocus();
                }
            } else {
                Funcoes.mensagem(this, "Paciente n\u00e3o localizado", 1);
                this.txtCodPaciente.grabFocus();
            }
            this.controlaCampos();
            st.close();
            stExm.close();
        }
        catch (SQLException exsql) {
            ErrorLogger.mostraMensagem(this, exsql.getMessage(), exsql.getStackTrace(), "ContrassenhaExames");
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void mostraInfoExame(int linha) {
        if (linha > this.modeloRequisicao.getRowCount()) {
            return;
        }
        Exames exames = (Exames)this.modeloRequisicao.getValueAt(linha, 3);
        this.labelValorTotal.setText(this.modeloRequisicao.getValueAt(linha, 4).toString());
        this.labelValorPago.setText(this.modeloRequisicao.getValueAt(linha, 5).toString());
        this.labelValorPgDesconto.setText(this.modeloRequisicao.getValueAt(linha, 6).toString());
        this.labelValorPercentualDesconto.setText(this.modeloRequisicao.getValueAt(linha, 7).toString());
        this.labelValorAcrescimo.setText(this.modeloRequisicao.getValueAt(linha, 8).toString());
        this.labelValorPercentualAcrescimo.setText(this.modeloRequisicao.getValueAt(linha, 9).toString());
        if (Funcoes.isNumeric(this.labelValorTotal.getText()) && Funcoes.isNumeric(this.labelValorPago.getText()) && Double.parseDouble(Funcoes.limpaDecimal(this.labelValorTotal.getText())) > Double.parseDouble(this.labelValorPago.getText().replaceAll(",", "."))) {
            this.labelValorPago.setOpaque(true);
            this.labelValorPago.setBackground(Color.red);
        } else {
            this.labelValorPago.setOpaque(false);
            this.labelValorPago.setBackground(this.labelValorTotal.getBackground());
        }
        this.modeloExame.clear();
        for (int i = 0; i < exames.getExamesCount(); ++i) {
            Exame e = exames.getExame(i);
            this.modeloExame.addLine(new String[]{e.getCodigo(), e.getMaterial(), e.getDescricao()});
        }
    }

    private void limpaCampos() {
        this.txtSenha.clear();
        this.txtCodPaciente.clear();
        this.labelValorPaciente.setText("");
        this.labelValorDesconto.setText("");
        this.labelValorTotal.setText("");
        this.labelValorPago.setText("");
        this.labelValorPgDesconto.setText("");
        this.labelValorPercentualDesconto.setText("");
        this.labelValorAcrescimo.setText("");
        this.labelValorPercentualAcrescimo.setText("");
        this.modeloRequisicao.clear();
        this.modeloExame.clear();
        this.controlaCampos();
    }

    private void controlaCampos() {
        this.buttonGerar.setEnabled(!Funcoes.textoVazio(this.txtSenha.getText()) && !this.labelValorDesconto.getText().isEmpty() && Long.parseLong(this.labelValorDesconto.getText()) > 0L);
        this.txtSenha.setEnabled(this.status == 2);
        this.txtCodPaciente.setEnabled(this.status == 2);
        this.buttonBuscaPaciente.setEnabled(this.status == 2);
    }
}

