/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.financeiro;

import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.financeiro.faturamento.JanelaPreviaFaturamento;
import jalis.model.bean.financeiro.FaturaNotaFiscalBean;
import jalis.model.bean.financeiro.NotaFiscalBean;
import jalis.model.bean.financeiro.ReceberPagarBean;
import jalis.model.vo.financeiro.FaturaVO;
import jalis.service.financeiro.FaturaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AssociarFaturasNota
extends AbstractDialogoOKCancelar {
    private static final int COLUNA_CODIGO_FATURA = 0;
    private static final int COLUNA_FANTASIA_CONVENIO = 1;
    private static final int COLUNA_VALOR_TOTAL = 2;
    private static final int COLUNA_VALOR_RESTANTE = 3;
    private static final int COLUNA_VALOR_FATURAR = 4;
    private static final int COLUNA_VALOR_DIFERENCA = 5;
    private static final int COLUNA_OBJETO_FATURA = 6;
    private static final int COLUNA_JANELA_PREVIA = 7;
    private NotaFiscalBean notaBean = null;
    private JLabel labelFatura = new JLabel("Fatura:");
    private JLabel labelValorTotal = new JLabel("Total Fatura:");
    private JLabel labelValorRestante = new JLabel("Restante Total:");
    private JLabel labelValorFaturar = new JLabel("Valor Faturar:");
    private JLabel labelValorNota = new JLabel("Valor Bruto Nota Fiscal:");
    private JLabel labelTotalFaturar = new JLabel("Total a Faturar:");
    private JLabel labelRestanteFaturar = new JLabel("Saldo a Faturar:");
    private JLabel labelDiferenca = new JLabel("Restante:");
    private JLabel labelDescConvenio = new JLabel();
    private JLabel labelVlrTotalFatura = new JLabel();
    private JLabel labelVlrRestanteFatura = new JLabel();
    private JLabel labelVlrNota = new JLabel();
    private JLabel labelVlrTotalFaturar = new JLabel();
    private JLabel labelVlrRestanteFaturar = new JLabel();
    private JLabel labelVlrDiferenca = new JLabel();
    private TTextField textFatura = new TTextField(10, 1);
    private TTextField textFaturar = new TTextField(10, 2);
    private JButton buttonBuscaFatura = new JButton();
    private JButton buttonOkFatura = new JButton("OK");
    private JPanel panelRodape = new JPanel(new GridBagLayout());
    private JPanel panelFaturas = new JPanel(new BorderLayout());
    private JPanel panelPrevias = new JPanel(new BorderLayout());
    private ModeloGridTable modeloFaturas = new ModeloGridTable(new String[]{"Fatura", "Conv\u00eanio", "Total Fatura", "Restante Total", "Valor Faturar", "Restante"});
    private JTable tableFaturas = new JTable(this.modeloFaturas);
    private JScrollPane scrollFaturas = new JScrollPane(this.tableFaturas);
    private FaturaVO faturaAux = null;
    private JanelaPreviaFaturamento janelaPreviaFaturamento = null;

    public static AssociarFaturasNota novaInstancia(Window pai, NotaFiscalBean notaFiscal, Set<FaturaNotaFiscalBean> listaFaturas) {
        if (pai instanceof Dialog) {
            return new AssociarFaturasNota((Dialog)pai, notaFiscal, listaFaturas);
        }
        return new AssociarFaturasNota((Frame)pai, notaFiscal, listaFaturas);
    }

    private AssociarFaturasNota(Dialog pai, NotaFiscalBean notaFiscal, Set<FaturaNotaFiscalBean> listaFaturas) {
        super(pai, "Associando faturas com a nota fiscal");
        this.notaBean = notaFiscal;
        this.montaTela();
        this.preencheDadosNota(listaFaturas);
    }

    private AssociarFaturasNota(Frame pai, NotaFiscalBean notaFiscal, Set<FaturaNotaFiscalBean> listaFaturas) {
        super(pai, "Associando faturas com a nota fiscal");
        this.notaBean = notaFiscal;
        this.montaTela();
        this.preencheDadosNota(listaFaturas);
    }

    private void montaTela() {
        JPanel painelCentral = this.getPanelCentral();
        painelCentral.setLayout(new GridBagLayout());
        painelCentral.setBorder(new EmptyBorder(1, 1, 1, 1));
        ScreenUtil.setBorda(new Component[]{this.labelDescConvenio, this.labelVlrTotalFatura, this.labelVlrRestanteFatura, this.labelVlrNota, this.labelVlrTotalFaturar, this.labelVlrRestanteFaturar, this.labelVlrDiferenca}, new TitledBorder(""));
        Dimension dimValores = new Dimension(100, 20);
        Dimension dimValoresRodape = new Dimension(75, 20);
        Dimension dimBusca = new Dimension(20, 20);
        Dimension dimOk = new Dimension(50, 20);
        Insets insetsNormal = new Insets(1, 1, 0, 0);
        Insets insetsEspaco = new Insets(1, 20, 0, 0);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = insetsNormal;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.labelFatura.setDisplayedMnemonic('F');
        this.labelFatura.setLabelFor(this.textFatura);
        painelCentral.add((Component)this.labelFatura, c);
        ++c.gridx;
        painelCentral.add((Component)this.textFatura, c);
        ++c.gridx;
        Funcoes.imagemPesquisa(this.buttonBuscaFatura);
        this.buttonBuscaFatura.setFocusable(false);
        this.buttonBuscaFatura.addActionListener(this);
        painelCentral.add((Component)this.buttonBuscaFatura, c);
        ++c.gridx;
        c.gridwidth = 7;
        c.weightx = 1.0;
        c.fill = 2;
        painelCentral.add((Component)this.labelDescConvenio, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        painelCentral.add((Component)this.labelValorTotal, c);
        ++c.gridx;
        this.labelVlrTotalFatura.setHorizontalAlignment(4);
        painelCentral.add((Component)this.labelVlrTotalFatura, c);
        c.gridx += 2;
        painelCentral.add((Component)this.labelValorRestante, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        this.labelVlrRestanteFatura.setHorizontalAlignment(4);
        painelCentral.add((Component)this.labelVlrRestanteFatura, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = insetsEspaco;
        this.labelValorFaturar.setDisplayedMnemonic('V');
        this.labelValorFaturar.setLabelFor(this.textFaturar);
        painelCentral.add((Component)this.labelValorFaturar, c);
        ++c.gridx;
        c.insets = insetsNormal;
        painelCentral.add((Component)this.textFaturar, c);
        ++c.gridx;
        c.insets = insetsEspaco;
        c.fill = 0;
        painelCentral.add((Component)this.labelDiferenca, c);
        ++c.gridx;
        c.insets = insetsNormal;
        c.fill = 2;
        this.labelVlrDiferenca.setHorizontalAlignment(4);
        painelCentral.add((Component)this.labelVlrDiferenca, c);
        ++c.gridx;
        this.buttonOkFatura.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkFatura.setMnemonic('K');
        this.buttonOkFatura.addActionListener(this);
        painelCentral.add((Component)this.buttonOkFatura, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        painelCentral.add((Component)this.panelFaturas, c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        painelCentral.add((Component)this.panelRodape, c);
        c = new GridBagConstraints();
        c.anchor = 13;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.panelRodape.add((Component)new JLabel(), c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        this.panelRodape.add((Component)this.labelValorNota, c);
        ++c.gridx;
        this.labelVlrNota.setHorizontalAlignment(4);
        this.panelRodape.add((Component)this.labelVlrNota, c);
        ++c.gridx;
        c.insets = insetsEspaco;
        this.panelRodape.add((Component)this.labelRestanteFaturar, c);
        ++c.gridx;
        c.insets = insetsNormal;
        this.labelVlrRestanteFaturar.setHorizontalAlignment(4);
        this.panelRodape.add((Component)this.labelVlrRestanteFaturar, c);
        ++c.gridx;
        c.insets = insetsEspaco;
        this.panelRodape.add((Component)this.labelTotalFaturar, c);
        ++c.gridx;
        c.insets = insetsNormal;
        this.labelVlrTotalFaturar.setHorizontalAlignment(4);
        this.panelRodape.add((Component)this.labelVlrTotalFaturar, c);
        this.setTamanho(this.textFatura, dimValores);
        this.setTamanho(this.buttonBuscaFatura, dimBusca);
        this.setTamanho(this.labelDescConvenio, dimBusca);
        this.setTamanho(this.labelVlrTotalFatura, dimValores);
        this.setTamanho(this.labelVlrRestanteFatura, dimValores);
        this.setTamanho(this.textFaturar, dimValores);
        this.setTamanho(this.labelVlrNota, dimValoresRodape);
        this.setTamanho(this.labelVlrTotalFaturar, dimValoresRodape);
        this.setTamanho(this.labelVlrRestanteFaturar, dimValoresRodape);
        this.setTamanho(this.labelVlrDiferenca, dimValores);
        this.setTamanho(this.buttonOkFatura, dimOk);
        this.modeloFaturas.setColumnSize(new int[]{80, 0, 100, 100, 100, 100}, this.tableFaturas);
        this.textFatura.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    AssociarFaturasNota.this.buttonBuscaFatura.doClick();
                }
            }
        });
        this.textFatura.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Funcoes.textoVazio(AssociarFaturasNota.this.textFatura)) {
                    AssociarFaturasNota.this.faturaAux = null;
                    AssociarFaturasNota.this.preencheDadosFatura();
                } else {
                    AssociarFaturasNota.this.carregaDadosFatura(Variaveis.filialPadrao, AssociarFaturasNota.this.textFatura.getText(), null);
                }
            }
        });
        this.textFaturar.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                AssociarFaturasNota.this.atualizaValorDiferenca();
            }
        });
        this.tableFaturas.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 127 && (row = AssociarFaturasNota.this.tableFaturas.getSelectedRow()) > -1) {
                    AssociarFaturasNota.this.modeloFaturas.removeLine(row);
                    AssociarFaturasNota.this.atualizaTotalFaturar();
                    AssociarFaturasNota.this.atualizaRestanteFaturar();
                    ScreenUtil.requisitarFoco(AssociarFaturasNota.this.textFatura);
                }
            }
        });
        this.tableFaturas.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = AssociarFaturasNota.this.tableFaturas.getSelectedRow();
                if (row > -1) {
                    JanelaPreviaFaturamento janelaPrevia = (JanelaPreviaFaturamento)AssociarFaturasNota.this.modeloFaturas.getValueAt(row, 7);
                    int codigoFatura = Integer.parseInt(AssociarFaturasNota.this.modeloFaturas.getValueAt(row, 0).toString());
                    double valorRestante = Double.parseDouble(Funcoes.limpaDecimal(AssociarFaturasNota.this.modeloFaturas.getValueAt(row, 3).toString()));
                    double valorFaturar = Double.parseDouble(Funcoes.limpaDecimal(AssociarFaturasNota.this.modeloFaturas.getValueAt(row, 4).toString()));
                    if (janelaPrevia != null) {
                        AssociarFaturasNota.this.apresentaPanelPrevias(janelaPrevia, codigoFatura, valorRestante - valorFaturar);
                    }
                } else {
                    AssociarFaturasNota.this.apresentaPanelPrevias(null, 0, 0.0);
                }
            }
        });
        this.montaPanelFaturas();
        this.setResizable(false);
        if (ParametrosGerais.isGerarPreviasFaturamento()) {
            this.setSize(820, 500);
        } else {
            this.setSize(820, 300);
        }
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textFatura);
    }

    private void montaPanelFaturas() {
        this.panelFaturas.setBorder(new TitledBorder("Faturas"));
        this.panelFaturas.add((Component)this.scrollFaturas, "Center");
        if (ParametrosGerais.isGerarPreviasFaturamento()) {
            this.panelFaturas.add((Component)this.panelPrevias, "South");
            this.montaPanelPrevias();
        }
    }

    private void montaPanelPrevias() {
        this.panelPrevias.setPreferredSize(new Dimension(20, 200));
        this.panelPrevias.setMinimumSize(new Dimension(20, 200));
        this.panelPrevias.setVisible(false);
    }

    private void apresentaPanelPrevias(JanelaPreviaFaturamento janelaPrevia, int codigoFatura, double valor) {
        if (!ParametrosGerais.isGerarPreviasFaturamento()) {
            return;
        }
        this.panelPrevias.removeAll();
        if (janelaPrevia != null) {
            this.panelPrevias.setBorder(new TitledBorder("Pr\u00e9vias da fatura " + codigoFatura + " - VALOR DAS PR\u00c9VIAS = " + Funcoes.formataDecimal(valor)));
            JPanel painelCentral = janelaPrevia.getPanelCentral();
            this.panelPrevias.add((Component)painelCentral, "Center");
            this.panelPrevias.setVisible(true);
            painelCentral.repaint();
        } else {
            this.panelPrevias.setVisible(false);
        }
        this.panelFaturas.revalidate();
    }

    private void preencheDadosNota(Set<FaturaNotaFiscalBean> listaFaturas) {
        if (this.notaBean == null) {
            return;
        }
        this.labelVlrNota.setText(Funcoes.formataDecimal(this.notaBean.getSubTotal()));
        this.labelVlrRestanteFaturar.setText(Funcoes.formataDecimal(this.notaBean.getSubTotal()));
        this.labelVlrTotalFaturar.setText(Funcoes.formataDecimal(0));
        if (listaFaturas != null) {
            FaturaService serviceFatura = new FaturaService();
            for (FaturaNotaFiscalBean fatura : listaFaturas) {
                BigDecimal restante = BigDecimal.ZERO;
                if (fatura.getNotaFiscal() != null) {
                    try {
                        restante = serviceFatura.getValorRestanteFatura(fatura.getFilial().getCodigo().toString(), fatura.getFatura().getCodigo().toString());
                    }
                    catch (SQLException e) {
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar o valor restante da fatura.\n" + e.getMessage(), e.getStackTrace());
                    }
                    restante = restante.add(new BigDecimal("" + fatura.getValorFatura()));
                } else {
                    restante = fatura.getFatura().getValorRestanteFaturar();
                }
                JanelaPreviaFaturamento janelaPrevia = null;
                if (restante.doubleValue() > 0.0) {
                    janelaPrevia = JanelaPreviaFaturamento.getInstancia(this, fatura.getFatura().getCodigo(), fatura.getFatura().getConvenio().getCodigo(), fatura.getValorFatura());
                    janelaPrevia.setListaPrevias(fatura.getListaPrevias());
                    janelaPrevia.setFormaPagamento(fatura.getFormaPagamento());
                    janelaPrevia.setServico(fatura.getServico());
                }
                this.modeloFaturas.addLine(new Object[]{fatura.getFatura().getCodigo(), fatura.getFatura().getConvenio().getFantasia(), Funcoes.formataDecimal(fatura.getFatura().getValorTotal() + fatura.getFatura().getValorTotalMateriais()), Funcoes.formataDecimal(restante.doubleValue()), Funcoes.formataDecimal(fatura.getValorFatura()), Funcoes.formataDecimal(restante.doubleValue() - fatura.getValorFatura()), fatura.getFatura(), janelaPrevia});
            }
        }
        this.atualizaTotalFaturar();
        this.atualizaRestanteFaturar();
    }

    private void setTamanho(JComponent comp, Dimension dim) {
        comp.setPreferredSize(dim);
        comp.setMinimumSize(dim);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.buttonBuscaFatura) {
            this.pesquisaFaturas();
        } else if (e.getSource() == this.buttonOkFatura) {
            this.adicionaFatura();
        }
    }

    private void pesquisaFaturas() {
        Hashtable fatura = new FaturaService().pesquisaFaturasConvenio(this, this.notaBean.getConvenio().getCodigo().toString(), this.notaBean.getConvenio().getFantasia());
        if (fatura != null) {
            this.carregaDadosFatura(Variaveis.filialPadrao, fatura.get("codigo").toString(), new BigDecimal("" + Funcoes.limpaDecimal(fatura.get("valorrestante").toString())));
        } else {
            this.faturaAux = null;
        }
    }

    private void carregaDadosFatura(String codigoFilial, String codigoFatura, BigDecimal valorRestante) {
        try {
            this.faturaAux = (FaturaVO)new FaturaService().getVO(codigoFilial, codigoFatura);
            if (this.faturaAux != null) {
                if (this.faturaAux.getConvenio().getCodigo().intValue() != this.notaBean.getConvenio().getCodigo().intValue()) {
                    Funcoes.mensagem(this, "A fatura n\u00e3o pertence ao conv\u00eanio \"" + this.notaBean.getConvenio().getFantasia() + "\".", 2);
                    this.faturaAux = null;
                } else if (this.faturaAux.getDataCancelamento() != null) {
                    Funcoes.mensagem(this, "A fatura foi cancelada.", 2);
                    this.faturaAux = null;
                } else if (this.faturaAux.getDataConferencia() == null) {
                    Funcoes.mensagem(this, "A fatura n\u00e3o foi conferida.", 2);
                    this.faturaAux = null;
                } else if (valorRestante != null) {
                    this.faturaAux.setValorRestanteFaturar(valorRestante);
                } else {
                    valorRestante = new FaturaService().getValorRestanteFatura(codigoFilial, codigoFatura);
                    if (valorRestante.doubleValue() == 0.0) {
                        Funcoes.mensagem(this, "A fatura n\u00e3o possui valor restante.", 2);
                        this.faturaAux = null;
                    } else {
                        this.faturaAux.setValorRestanteFaturar(valorRestante);
                    }
                }
            }
            this.preencheDadosFatura();
        }
        catch (Exception e) {
            this.faturaAux = null;
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar dados da fatura.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void preencheDadosFatura() {
        if (this.faturaAux == null) {
            this.textFatura.clear();
            this.labelDescConvenio.setText("");
            this.labelVlrTotalFatura.setText("");
            this.labelVlrRestanteFatura.setText("");
            this.textFaturar.clear();
            this.labelVlrDiferenca.setText("");
        } else {
            double restanteNota = Double.parseDouble(Funcoes.limpaDecimal(this.labelVlrRestanteFaturar.getText()));
            double restanteFatura = this.faturaAux.getValorRestanteFaturar().doubleValue();
            double valorFaturar = restanteFatura < restanteNota ? restanteFatura : restanteNota;
            this.textFatura.setText(this.faturaAux.getCodigo().toString());
            this.labelDescConvenio.setText(this.faturaAux.getConvenio().getFantasia());
            this.labelVlrTotalFatura.setText(Funcoes.formataDecimal(this.faturaAux.getValorTotalExames() + this.faturaAux.getValorTotalMateriais()));
            this.labelVlrRestanteFatura.setText(Funcoes.formataDecimal(this.faturaAux.getValorRestanteFaturar().doubleValue()));
            this.textFaturar.setText(Funcoes.formataDecimal(valorFaturar));
            this.labelVlrDiferenca.setText(Funcoes.formataDecimal(this.faturaAux.getValorRestanteFaturar().doubleValue() - valorFaturar));
        }
    }

    private void adicionaFatura() {
        if (this.faturaAux == null) {
            Funcoes.mensagem(this, "A fatura deve ser selecionada.", 2);
            ScreenUtil.requisitarFoco(this.textFatura);
            this.textFaturar.selectAll();
            return;
        }
        if (Funcoes.textoVazio(this.textFaturar)) {
            Funcoes.mensagem(this, "O valor a faturar deve ser informado.", 2);
            ScreenUtil.requisitarFoco(this.textFaturar);
            this.textFaturar.selectAll();
            return;
        }
        double valorFaturar = Double.valueOf(this.textFaturar.getText());
        if (valorFaturar == 0.0) {
            Funcoes.mensagem(this, "O valor a faturar deve ser maior que zero.", 2);
            ScreenUtil.requisitarFoco(this.textFaturar);
            this.textFaturar.selectAll();
            return;
        }
        if (valorFaturar > this.faturaAux.getValorRestanteFaturar().doubleValue()) {
            Funcoes.mensagem(this, "O valor a faturar deve ser menor ou igual ao valor restante da fatura.", 2);
            ScreenUtil.requisitarFoco(this.textFaturar);
            this.textFaturar.selectAll();
            return;
        }
        Double totalFaturarNovo = this.getTotalFaturar(valorFaturar);
        if (totalFaturarNovo > this.notaBean.getSubTotal()) {
            Double totalFaturar = this.getTotalFaturar(null);
            Double restante = this.notaBean.getSubTotal() - totalFaturar;
            Funcoes.mensagem(this, "O valor total a faturar ultrapassar\u00e1 o valor bruto da nota.\nValor restante a faturar \u00e9: R$ " + Funcoes.formataDecimal(restante) + ".", 2);
            ScreenUtil.requisitarFoco(this.textFaturar);
            this.textFaturar.selectAll();
            return;
        }
        if (this.verificaFaturaAdicionada()) {
            Funcoes.mensagem(this, "A fatura j\u00e1 foi adicionada.", 2);
            ScreenUtil.requisitarFoco(this.textFatura);
            this.textFatura.selectAll();
            return;
        }
        JanelaPreviaFaturamento janelaPrevia = null;
        if (valorFaturar < this.faturaAux.getValorRestanteFaturar().doubleValue()) {
            janelaPrevia = JanelaPreviaFaturamento.getInstancia(this, this.faturaAux.getCodigo(), this.faturaAux.getConvenio().getCodigo(), this.faturaAux.getValorRestanteFaturar().doubleValue() - valorFaturar);
        }
        this.modeloFaturas.addLine(new Object[]{this.faturaAux.getCodigo(), this.faturaAux.getConvenio().getFantasia(), Funcoes.formataDecimal(this.faturaAux.getValorTotal() + this.faturaAux.getValorTotalMateriais()), Funcoes.formataDecimal(this.faturaAux.getValorRestanteFaturar().doubleValue()), Funcoes.formataDecimal(valorFaturar), Funcoes.formataDecimal(this.faturaAux.getValorRestanteFaturar().doubleValue() - valorFaturar), this.faturaAux, janelaPrevia});
        this.faturaAux = null;
        this.preencheDadosFatura();
        this.atualizaTotalFaturar();
        this.atualizaRestanteFaturar();
        ScreenUtil.requisitarFoco(this.textFatura);
    }

    private boolean verificaFaturaAdicionada() {
        if (this.faturaAux == null) {
            return false;
        }
        for (int i = 0; i < this.modeloFaturas.getRowCount(); ++i) {
            FaturaVO fatura = (FaturaVO)this.modeloFaturas.getValueAt(i, 6);
            if (fatura == null || fatura.getCodigo().intValue() != this.faturaAux.getCodigo().intValue()) continue;
            return true;
        }
        return false;
    }

    private void atualizaTotalFaturar() {
        Double totalFaturar = this.getTotalFaturar(null);
        this.labelVlrTotalFaturar.setText(Funcoes.formataDecimal(totalFaturar));
    }

    private void atualizaRestanteFaturar() {
        Double restanteFaturar = this.getRestanteFaturar(null);
        this.labelVlrRestanteFaturar.setText(Funcoes.formataDecimal(restanteFaturar));
    }

    private Double getTotalFaturar(Double valorAdicionando) {
        Double totalFaturar = 0.0;
        for (int i = 0; i < this.modeloFaturas.getRowCount(); ++i) {
            double valorFaturar = Double.parseDouble(Funcoes.limpaDecimal(this.modeloFaturas.getValueAt(i, 4).toString()));
            totalFaturar = totalFaturar + valorFaturar;
        }
        if (valorAdicionando != null) {
            totalFaturar = totalFaturar + valorAdicionando;
        }
        return totalFaturar;
    }

    private Double getRestanteFaturar(Double valorAdicionando) {
        Double restanteFaturar = 0.0;
        for (int i = 0; i < this.modeloFaturas.getRowCount(); ++i) {
            double valorFaturar = Double.parseDouble(Funcoes.limpaDecimal(this.modeloFaturas.getValueAt(i, 4).toString()));
            restanteFaturar = restanteFaturar + valorFaturar;
        }
        if (valorAdicionando != null) {
            restanteFaturar = restanteFaturar + valorAdicionando;
        }
        return this.notaBean.getSubTotal() - restanteFaturar;
    }

    private void atualizaValorDiferenca() {
        if (!Funcoes.textoVazio(this.labelVlrRestanteFatura.getText()) || !Funcoes.textoVazio(this.textFatura)) {
            double valorRestante = Double.parseDouble(Funcoes.limpaDecimal(this.labelVlrRestanteFatura.getText()));
            double valorFatura = Double.parseDouble(this.textFaturar.getText());
            this.labelVlrDiferenca.setText(Funcoes.formataDecimal(valorRestante - valorFatura));
        }
    }

    @Override
    protected boolean acaoOk() {
        Double totalFaturar = this.getTotalFaturar(null);
        Double valorBrutoNota = this.notaBean.getSubTotal();
        if (totalFaturar.doubleValue() != valorBrutoNota.doubleValue()) {
            Funcoes.mensagem(this, "O valor a faturar deve ser igual ao valor bruto da nota fiscal.", 2);
            ScreenUtil.requisitarFoco(this.textFatura);
            return false;
        }
        if (ParametrosGerais.isGerarPreviasFaturamento()) {
            for (int i = 0; i < this.modeloFaturas.getRowCount(); ++i) {
                JanelaPreviaFaturamento janelaPrevia;
                int codigoFatura = Integer.parseInt(this.modeloFaturas.getValueAt(i, 0).toString());
                double valorRestante = Double.parseDouble(Funcoes.limpaDecimal(this.modeloFaturas.getValueAt(i, 3).toString()));
                double valorFaturar = Double.parseDouble(Funcoes.limpaDecimal(this.modeloFaturas.getValueAt(i, 4).toString()));
                if (!(valorFaturar < valorRestante) || (janelaPrevia = (JanelaPreviaFaturamento)this.modeloFaturas.getValueAt(i, 7)) != null && janelaPrevia.getListaPrevias() != null) continue;
                Funcoes.mensagem(this, "As pr\u00e9vias de faturamento devem ser geradas para a fatura " + codigoFatura + ".", 2);
                ScreenUtil.requisitarFoco(this.tableFaturas);
                this.tableFaturas.getSelectionModel().setSelectionInterval(i, i);
                return false;
            }
        }
        return true;
    }

    public Set<FaturaNotaFiscalBean> getFaturasAssociadas() {
        HashSet<FaturaNotaFiscalBean> listaFaturas = new HashSet<FaturaNotaFiscalBean>();
        for (int i = 0; i < this.modeloFaturas.getRowCount(); ++i) {
            JanelaPreviaFaturamento janelaPrevia = (JanelaPreviaFaturamento)this.modeloFaturas.getValueAt(i, 7);
            FaturaNotaFiscalBean fatura = new FaturaNotaFiscalBean();
            fatura.setFilial(this.notaBean.getFilial());
            fatura.setFatura((FaturaVO)this.modeloFaturas.getValueAt(i, 6));
            fatura.setValorFatura(Double.parseDouble(Funcoes.limpaDecimal(this.modeloFaturas.getValueAt(i, 4).toString())));
            if (janelaPrevia != null) {
                fatura.setFormaPagamento(janelaPrevia.getFormaPagamento());
                fatura.setServico(janelaPrevia.getServico());
                ArrayList<ReceberPagarBean> listaPrevias = null;
                if (janelaPrevia != null) {
                    listaPrevias = janelaPrevia.getListaPrevias();
                }
                fatura.setListaPrevias(listaPrevias);
            }
            listaFaturas.add(fatura);
        }
        return listaFaturas;
    }
}

