/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.util;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.integracao.DadosIntegracaoFilial;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.util.JanelaExportaRequisicaoIntegracao;
import jalis.laboratorio.exportacao.util.JanelaMonitoramentoExportacao;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import javax.swing.JLabel;

public class JanelaMonitoramentoIntegracaoOffline
extends JanelaMonitoramentoExportacao {
    private JLabel labelTotalEnviar = null;
    private JLabel labelArquivoAtual = null;
    private JLabel labelTempoEstimado = null;
    private JLabel labelUltimoArquivoRecebido = null;
    private JLabel labelUltimoArquivoGerado = null;
    private JLabel labelUltimoLogRecebido = null;
    private JLabel labelTempoProximaComunicacao = null;
    private static JLabel labelVlrTotalEnviar = null;
    private static JLabel labelVlrArquivoAtual = null;
    private static JLabel labelVlrTempoEstimado = null;
    private static JLabel labelVlrUltimoArquivoRecebido = null;
    private static JLabel labelVlrUltimoArquivoGerado = null;
    private static JLabel labelVlrUltimoLogRecebido = null;
    private static JLabel labelVlrTempoProximaComunicacao = new JLabel();
    private static int totalEnviar = 0;
    private static int logAtual = 0;
    private static long tempoEntreIteracoes = -1L;
    private static long tempoProximaComunicacao = -1L;
    private static long ultimoArquivoEnviado = 0L;
    private static long ultimoArquivoRecebido = 0L;
    private static long ultimoLogEnviado = 0L;
    private static long ultimoLogRecebido = 0L;
    private static JanelaMonitoramentoExportacao.Cronometro cronometro = null;

    public static JanelaMonitoramentoIntegracaoOffline getInstancia(Window pai) {
        if (pai == null || pai instanceof Dialog) {
            return new JanelaMonitoramentoIntegracaoOffline((Dialog)pai);
        }
        if (pai instanceof Frame) {
            return new JanelaMonitoramentoIntegracaoOffline((Frame)pai);
        }
        return null;
    }

    private JanelaMonitoramentoIntegracaoOffline(Dialog pai) {
        super(pai, 3);
    }

    private JanelaMonitoramentoIntegracaoOffline(Frame pai) {
        super(pai, 3);
    }

    @Override
    protected void montaPanelInformacoes() {
        this.labelTotalEnviar = new JLabel("Arquivos para enviar:");
        this.labelArquivoAtual = new JLabel("Enviando arquivo:");
        this.labelTempoEstimado = new JLabel("Tempo de envio estimado:");
        this.labelUltimoArquivoGerado = new JLabel("\u00daltimo arquivo gerado:");
        this.labelUltimoArquivoRecebido = new JLabel("\u00daltimo arquivo processado:");
        this.labelUltimoLogRecebido = new JLabel("\u00daltimo log processado:");
        this.labelTempoProximaComunicacao = new JLabel("Pr\u00f3xima comunica\u00e7\u00e3o em:");
        labelVlrTotalEnviar = new JLabel();
        labelVlrArquivoAtual = new JLabel();
        labelVlrTempoEstimado = new JLabel();
        labelVlrUltimoArquivoGerado = new JLabel();
        labelVlrUltimoArquivoRecebido = new JLabel();
        labelVlrUltimoLogRecebido = new JLabel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.fill = 2;
        this.labelTotalEnviar.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelTotalEnviar, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.getPanelInformacoes().add((Component)labelVlrTotalEnviar, c);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.labelArquivoAtual.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelArquivoAtual, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.getPanelInformacoes().add((Component)labelVlrArquivoAtual, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelTempoEstimado.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelTempoEstimado, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.getPanelInformacoes().add((Component)labelVlrTempoEstimado, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelTempoEstimado.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelUltimoArquivoGerado, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.getPanelInformacoes().add((Component)labelVlrUltimoArquivoGerado, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelTempoEstimado.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelUltimoArquivoRecebido, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.getPanelInformacoes().add((Component)labelVlrUltimoArquivoRecebido, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelTempoEstimado.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelUltimoLogRecebido, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.getPanelInformacoes().add((Component)labelVlrUltimoLogRecebido, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridwidth = 1;
        this.labelTempoProximaComunicacao.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelTempoProximaComunicacao, c);
        ++c.gridx;
        labelVlrTempoProximaComunicacao.setForeground(Color.RED);
        this.getPanelInformacoes().add((Component)labelVlrTempoProximaComunicacao, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.getPanelInformacoes().add((Component)new JLabel("."), c);
        this.atualizaLabelTotalEnviar();
        this.atualizaLabelArquivoAtual();
        this.atualizaLabelTempoEstimado();
        this.atualizaLabelTempoProximaComunicacao("00:00:00");
        if (Funcoes.textoVazio(this.operacaoAtual)) {
            this.atualizaOperacaoAtual(this.operacaoAtual);
        }
        this.setUsarThread(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void atualizarDadosThread() {
        Statement st;
        block5: {
            st = Conexao.getStatement();
            try {
                DadosIntegracaoFilial[] dadosFiliais = IntegracaoUtil.buscaFiliais(st, false);
                if (dadosFiliais == null) break block5;
                for (DadosIntegracaoFilial dadosFilial : dadosFiliais) {
                    if (dadosFilial.getCodigo() != Integer.parseInt(Variaveis.filialPadrao)) continue;
                    labelVlrUltimoArquivoRecebido.setText("<html><font color = red>" + dadosFilial.getUltimaIntegracaoRecebida() + "</font></html>");
                    labelVlrUltimoArquivoGerado.setText("<html><font color = red>" + this.getUltimoArquivoGerado() + "</font></html>");
                    labelVlrUltimoLogRecebido.setText("<html><font color = red>" + dadosFilial.getUltimoLogIntegracaoRecebido() + "</font></html>");
                }
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel atualizar os dados da integra\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUltimoArquivoGerado() {
        Statement st;
        block4: {
            long l;
            StringBuilder buf = new StringBuilder();
            buf.append(" select max(off_codigoarquivo) as arquivo ");
            buf.append("   from logoffline ");
            buf.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block4;
                l = rs.getLong("arquivo");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar o \u00faltimo arquivo gerado.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return l;
        }
        Conexao.fecharStatement(st);
        return 0L;
    }

    @Override
    protected Dimension getTamanhoJanela() {
        return new Dimension(400, 325);
    }

    @Override
    public void atualizaQuantidadeParaEnviar(int totalEnviar) {
        JanelaMonitoramentoIntegracaoOffline.totalEnviar = totalEnviar;
        this.atualizaLabelTotalEnviar();
    }

    private void atualizaLabelTotalEnviar() {
        labelVlrTotalEnviar.setText("<html><font color = red>" + totalEnviar + "</font></html>");
    }

    @Override
    public void atualizaLogAtual(int logAtual) {
        JanelaMonitoramentoIntegracaoOffline.logAtual = logAtual;
        this.atualizaLabelArquivoAtual();
    }

    private void atualizaLabelArquivoAtual() {
        labelVlrArquivoAtual.setText("<html><font color = red>" + logAtual + "</font></html>");
    }

    @Override
    public void atualizaTempoEntreIteracoes(long tempoEntreIteracoes) {
        JanelaMonitoramentoIntegracaoOffline.tempoEntreIteracoes = tempoEntreIteracoes;
        this.atualizaLabelTempoEstimado();
    }

    private void atualizaLabelTempoEstimado() {
        if (labelVlrTempoEstimado == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<html><b><font color = RED>").append(this.getTempoEstimado()).append("</font></b>.</html>");
        labelVlrTempoEstimado.setText(buf.toString());
    }

    private String getTempoEstimado() {
        if (tempoEntreIteracoes == -1L) {
            return "(calculando...)";
        }
        if (tempoEntreIteracoes == 0L) {
            return "00:00:00";
        }
        long tempo = (long)(totalEnviar - logAtual) * tempoEntreIteracoes;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Funcoes.getData("yyyy-MM-dd", "2000-01-01"));
        calendar.add(14, (int)tempo);
        return Funcoes.formataData("HH:mm:ss", calendar.getTime());
    }

    @Override
    @Deprecated
    public void atualizaValorSinal(int valorSinal) {
    }

    @Override
    @Deprecated
    public void atualizaQuantidadeLogEnvio(int qtdeLogEnvio) {
    }

    private void atualizaLabelTempoProximaComunicacao(String tempo) {
        if (labelVlrTempoProximaComunicacao == null) {
            return;
        }
        labelVlrTempoProximaComunicacao.setText(tempo);
    }

    @Override
    public void atualizaTempoProximaIteracao(long tempoProximoProcesso) {
        tempoProximaComunicacao = tempoProximoProcesso;
        if (this.getMonitorExportacao().getLogAtual() == this.getMonitorExportacao().getQuantidadeLogEnvio()) {
            if (cronometro != null) {
                cronometro.parar();
            }
            if (tempoProximaComunicacao > 0L) {
                cronometro = new JanelaMonitoramentoExportacao.Cronometro(tempoProximaComunicacao, -1, labelVlrTempoProximaComunicacao);
                cronometro.executarCronometro();
            } else {
                this.atualizaLabelTempoProximaComunicacao("00:00:00");
            }
        } else if (cronometro != null) {
            cronometro.parar();
            cronometro = null;
            this.atualizaLabelTempoProximaComunicacao("00:00:00");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource().equals(this.buttonExportarRequisicao)) {
            this.exportarRequisicao();
        }
    }

    private void exportarRequisicao() {
        JanelaExportaRequisicaoIntegracao exportaRequisicaoIntegracao = new JanelaExportaRequisicaoIntegracao(this);
        exportaRequisicaoIntegracao.setModal(true);
        exportaRequisicaoIntegracao.setVisible(true);
    }
}

