/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.util;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.util.JanelaMonitoramentoExportacao;
import jalis.util.Funcoes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Calendar;
import javax.swing.JLabel;

public class JanelaMonitoramentoExportacaoWeb
extends JanelaMonitoramentoExportacao {
    private JLabel labelTotalEnviar = null;
    private JLabel labelEnviando = null;
    private JLabel labelTempoEstimado = null;
    private static JLabel labelTotalEnviarVlr = null;
    private static JLabel labelEnviandoVlr = null;
    private static JLabel labelTempoEstimadoVlr = null;
    private static long tempoProximaIteracao = 0L;
    private static JanelaMonitoramentoExportacao.Cronometro cro = null;

    public JanelaMonitoramentoExportacaoWeb(Dialog janelaPai, int tipoJanela) {
        super(janelaPai, tipoJanela);
    }

    public JanelaMonitoramentoExportacaoWeb(Frame janelaPai, int tipoJanela) {
        super(janelaPai, tipoJanela);
    }

    @Override
    protected void montaPanelInformacoes() {
        this.labelTotalEnviar = new JLabel("Total para enviar: ");
        this.labelEnviando = new JLabel("Enviando: ");
        this.labelTempoEstimado = new JLabel("Tempo estimado (total): ");
        labelTotalEnviarVlr = new JLabel("0");
        labelEnviandoVlr = new JLabel("0/0");
        labelTempoEstimadoVlr = new JLabel("00:00:00");
        this.setTipoJanela(2);
        GridBagConstraints bagConstraints = new GridBagConstraints();
        bagConstraints.fill = 2;
        bagConstraints.anchor = 17;
        bagConstraints.insets = new Insets(3, 1, 0, 1);
        bagConstraints.gridx = 0;
        bagConstraints.gridy = 0;
        bagConstraints.gridwidth = 1;
        bagConstraints.weightx = 0.0;
        labelTotalEnviarVlr.setPreferredSize(new Dimension(50, 15));
        labelTotalEnviarVlr.setForeground(Color.RED);
        this.getPanelInformacoes().add((Component)this.labelTotalEnviar, bagConstraints);
        ++bagConstraints.gridx;
        bagConstraints.weightx = 1.0;
        this.getPanelInformacoes().add((Component)labelTotalEnviarVlr, bagConstraints);
        labelEnviandoVlr.setPreferredSize(new Dimension(50, 15));
        labelEnviandoVlr.setForeground(Color.RED);
        ++bagConstraints.gridy;
        bagConstraints.gridx = 0;
        bagConstraints.weightx = 0.0;
        this.getPanelInformacoes().add((Component)this.labelEnviando, bagConstraints);
        ++bagConstraints.gridx;
        bagConstraints.weightx = 1.0;
        this.getPanelInformacoes().add((Component)labelEnviandoVlr, bagConstraints);
        labelTempoEstimadoVlr.setPreferredSize(new Dimension(50, 15));
        labelTempoEstimadoVlr.setForeground(Color.RED);
        ++bagConstraints.gridy;
        bagConstraints.gridx = 0;
        bagConstraints.weightx = 0.0;
        this.getPanelInformacoes().add((Component)this.labelTempoEstimado, bagConstraints);
        ++bagConstraints.gridx;
        bagConstraints.weightx = 1.0;
        this.getPanelInformacoes().add((Component)labelTempoEstimadoVlr, bagConstraints);
        ++bagConstraints.gridy;
        bagConstraints.weighty = 1.0;
        bagConstraints.fill = 1;
        this.getPanelInformacoes().add((Component)new JLabel(), bagConstraints);
    }

    @Override
    protected void atualizarDadosThread() {
    }

    @Override
    protected Dimension getTamanhoJanela() {
        return new Dimension(400, 285);
    }

    @Override
    public void atualizaQuantidadeParaEnviar(int totalEnviar) {
        labelTotalEnviarVlr.setText("" + this.getMonitorExportacao().getQuantidadeParaEnviar());
    }

    @Override
    public void atualizaLogAtual(int logAtual) {
        if (Laboratorio.isNovaWeb()) {
            labelEnviandoVlr.setText("" + this.getMonitorExportacao().getLogAtual());
        } else {
            labelEnviandoVlr.setText(logAtual + "/" + this.getMonitorExportacao().getQuantidadeLogEnvio() + "\n");
        }
    }

    @Override
    public void atualizaValorSinal(int valorSinal) {
    }

    @Override
    public void atualizaTempoEntreIteracoes(long tempoEntreIteracoes) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Funcoes.getData("yyyy-MM-dd HH:mm:ss", "2000-01-01 00:00:00"));
        calendar.add(14, (int)(tempoEntreIteracoes * (long)this.getMonitorExportacao().getQuantidadeParaEnviar()));
        labelTempoEstimadoVlr.setText(Funcoes.formataData("HH:mm:ss", calendar.getTime()));
    }

    @Override
    public void atualizaOperacaoAtual(String operacaoAtual) {
        if (operacaoAtual != null) {
            super.atualizaOperacaoAtual(this.definirDescricaoOperacao(operacaoAtual));
        }
    }

    private String definirDescricaoOperacao(String operacaoAtual) {
        String[] tags = operacaoAtual.split(">");
        String tagInicial = null;
        if (tags != null && tags.length > 0) {
            if (tags[0] != null) {
                tagInicial = tags[0].replaceAll("<", "");
            }
            if (tagInicial == null) {
                return "";
            }
            if (tagInicial.equalsIgnoreCase("configuracao")) {
                operacaoAtual = "Exportando configura\u00e7\u00f5es.";
            } else if (tagInicial.equalsIgnoreCase("convenios")) {
                operacaoAtual = "Exportando conv\u00eanios.";
            } else if (tagInicial.equalsIgnoreCase("destinos")) {
                operacaoAtual = "Exportando destinos.";
            } else if (tagInicial.equalsIgnoreCase("entidade")) {
                operacaoAtual = "Exportando entidades.";
            } else if (tagInicial.equalsIgnoreCase("exames")) {
                operacaoAtual = "Exportando exames.";
            } else if (tagInicial.equalsIgnoreCase("medicos")) {
                operacaoAtual = "Exportando m\u00e9dico.";
            } else if (tagInicial.equalsIgnoreCase("medicosexames")) {
                operacaoAtual = "Exportando m\u00e9dicos e exames.";
            } else if (tagInicial.equalsIgnoreCase("mensagensconvenio")) {
                operacaoAtual = "Exportando mensagens.";
            } else if (tagInicial.equalsIgnoreCase("pacienteentidade")) {
                operacaoAtual = "Exportando pacientes e entidades.";
            } else if (tagInicial.equalsIgnoreCase("paciente")) {
                operacaoAtual = "Exportando pacientes.";
            } else if (tagInicial.equalsIgnoreCase("requisicao")) {
                operacaoAtual = "Exportando requisi\u00e7\u00f5es.";
            } else if (tagInicial.equalsIgnoreCase("requisicaoexame")) {
                operacaoAtual = "Exportando requisi\u00e7\u00f5es e exames.";
            } else if (tagInicial.equalsIgnoreCase("requisicaoexameimagem")) {
                operacaoAtual = "Exportando requisi\u00e7\u00f5es, exames e imagens.";
            } else if (tagInicial.equalsIgnoreCase("usuario")) {
                operacaoAtual = "Exportando usu\u00e1rios.";
            } else if (!Funcoes.textoVazio(tagInicial)) {
                operacaoAtual = tagInicial + ".";
            }
        } else {
            operacaoAtual = "Exportando ...";
        }
        return operacaoAtual;
    }

    @Override
    public void atualizaQuantidadeLogEnvio(int qtdeLogEnvio) {
    }

    @Override
    public void atualizaTempoProximaIteracao(long tempoProximaIteracao) {
    }
}

