/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.util;

import jalis.laboratorio.exportacao.util.JanelaMonitoramentoExportacao;
import jalis.util.Funcoes;
import jalis.util.sms.SmsSender;
import jalis.util.sms.SmsSenderAPI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.util.Calendar;
import javax.swing.JLabel;

public class JanelaMonitoramentoExportacaoSms
extends JanelaMonitoramentoExportacao {
    private JLabel labelTotalEnviar = null;
    private JLabel labelQtdeLogsEnvio = null;
    private JLabel labelLogAtual = null;
    private JLabel labelTempoEstimado = null;
    private JLabel labelQualidadeSinal = null;
    private JLabel labelTempoProximaIteracao;
    private static JLabel labelVlrTotalEnviar = null;
    private static JLabel labelVlrQtdeLogsEnvio = null;
    private static JLabel labelVlrLogAtual = null;
    private static JLabel labelVlrTempoEstimado = null;
    private static JLabel labelVlrQualidadeSinal = null;
    private static JLabel labelVlrTempoProximaIteracao = new JLabel("00:00:00");
    private static int totalEnviar = 0;
    private static int qtdeLogsEnvio = 0;
    private static int logAtual = 0;
    private static int valorSinal = 0;
    private static long tempoEntreIteracoes = -1L;
    private static long tempoProximaIteacao = -1L;
    private static SmsSender smsSender = null;
    private static SmsSenderAPI smsSenderApi = null;
    private static long tempoProximaIteracao = 0L;
    private static JanelaMonitoramentoExportacao.Cronometro cronometro = null;

    public static JanelaMonitoramentoExportacaoSms getInstancia(Window pai, int tipoJanela) {
        if (pai == null || pai instanceof Dialog) {
            return new JanelaMonitoramentoExportacaoSms((Dialog)pai, tipoJanela);
        }
        if (pai instanceof Frame) {
            return new JanelaMonitoramentoExportacaoSms((Frame)pai, tipoJanela);
        }
        return null;
    }

    private JanelaMonitoramentoExportacaoSms(Dialog pai, int tipoJanela) {
        super(pai, tipoJanela);
    }

    private JanelaMonitoramentoExportacaoSms(Frame pai, int tipoJanela) {
        super(pai, tipoJanela);
    }

    @Override
    protected void montaPanelInformacoes() {
        this.labelTotalEnviar = new JLabel("Total para enviar:");
        this.labelQtdeLogsEnvio = new JLabel("Total para processar:");
        this.labelLogAtual = new JLabel("Processando log:");
        this.labelTempoEstimado = new JLabel("Tempo estimado:");
        this.labelQualidadeSinal = new JLabel("Qualidade do sinal:");
        this.labelTempoProximaIteracao = new JLabel("Tempo pr\u00f3ximo envio:");
        labelVlrTotalEnviar = new JLabel();
        labelVlrQtdeLogsEnvio = new JLabel();
        labelVlrLogAtual = new JLabel();
        labelVlrTempoEstimado = new JLabel();
        labelVlrQualidadeSinal = new JLabel();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(1, 1, 0, 1);
        c.weighty = 0.0;
        c.fill = 2;
        this.labelTotalEnviar.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelTotalEnviar, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.getPanelInformacoes().add((Component)labelVlrTotalEnviar, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelQtdeLogsEnvio.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelQtdeLogsEnvio, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.getPanelInformacoes().add((Component)labelVlrQtdeLogsEnvio, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelLogAtual.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelLogAtual, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.getPanelInformacoes().add((Component)labelVlrLogAtual, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelTempoEstimado.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelTempoEstimado, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.getPanelInformacoes().add((Component)labelVlrTempoEstimado, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelQualidadeSinal.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelQualidadeSinal, c);
        ++c.gridx;
        c.gridwidth = 2;
        this.getPanelInformacoes().add((Component)labelVlrQualidadeSinal, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.labelTempoProximaIteracao.setOpaque(true);
        this.getPanelInformacoes().add((Component)this.labelTempoProximaIteracao, c);
        ++c.gridx;
        labelVlrTempoProximaIteracao.setForeground(Color.RED);
        this.getPanelInformacoes().add((Component)labelVlrTempoProximaIteracao, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.getPanelInformacoes().add((Component)new JLabel("."), c);
        this.atualizaLabelTotalEnviar();
        this.atualizaLabelQtdeLogsEnvio();
        this.atualizaLabelLogAtual();
        this.atualizaLabelTempoEstimado();
        this.atualizaLabelQualidadeSinal();
    }

    private void atualizaLabelTotalEnviar() {
        if (labelVlrTotalEnviar == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<html><b><font color = RED>").append(totalEnviar).append("</font></b>.</html>");
        labelVlrTotalEnviar.setText(buf.toString());
    }

    private void atualizaLabelQtdeLogsEnvio() {
        if (labelVlrQtdeLogsEnvio == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<html><b><font color = RED>").append(qtdeLogsEnvio).append("</font></b>.</html>");
        labelVlrQtdeLogsEnvio.setText(buf.toString());
    }

    private void atualizaLabelLogAtual() {
        if (labelVlrLogAtual == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<html><b><font color = RED>").append(logAtual).append("</font></b>.</html>");
        labelVlrLogAtual.setText(buf.toString());
    }

    private void atualizaLabelTempoEstimado() {
        if (labelVlrTempoEstimado == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<html><b><font color = RED>").append(this.getTempoEstimado()).append("</font></b>.</html>");
        labelVlrTempoEstimado.setText(buf.toString());
    }

    private void atualizaLabelQualidadeSinal() {
        if (labelVlrQualidadeSinal == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<html><b><font color = RED>").append(this.getQualidadeSinal()).append("</font></b>.</html>");
        labelVlrQualidadeSinal.setText(buf.toString());
    }

    private void atualizaLabelTempoProximaIteracao(String tempo) {
        if (labelVlrTempoProximaIteracao == null) {
            return;
        }
        labelVlrTempoProximaIteracao.setText(tempo);
    }

    private String getTempoEstimado() {
        if (tempoEntreIteracoes == -1L) {
            return "(calculando...)";
        }
        if (tempoEntreIteracoes == 0L) {
            return "00:00:00";
        }
        long tempo = (long)totalEnviar * tempoEntreIteracoes;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(Funcoes.getData("yyyy-MM-dd", "2000-01-01"));
        calendar.add(14, (int)tempo);
        return Funcoes.formataData("HH:mm:ss", calendar.getTime());
    }

    private String getQualidadeSinal() {
        if (smsSender != null || smsSenderApi != null) {
            if (valorSinal == 0) {
                return "\u00d3tima";
            }
            if (valorSinal == 1) {
                return "Boa";
            }
            if (valorSinal >= 2 && valorSinal <= 30) {
                return "Regular";
            }
            if (valorSinal >= 31) {
                return "P\u00e9ssima";
            }
            if (valorSinal == 99) {
                return "Sem sinal";
            }
            return "Aguarde...";
        }
        return "Sem informa\u00e7\u00e3o";
    }

    @Override
    public void atualizaQuantidadeParaEnviar(int totalEnviar) {
        JanelaMonitoramentoExportacaoSms.totalEnviar = totalEnviar;
        this.atualizaLabelTotalEnviar();
    }

    @Override
    public void atualizaLogAtual(int logAtual) {
        JanelaMonitoramentoExportacaoSms.logAtual = logAtual;
        this.atualizaLabelLogAtual();
    }

    @Override
    public void atualizaValorSinal(int valorSinal) {
        JanelaMonitoramentoExportacaoSms.valorSinal = valorSinal;
        this.atualizaLabelQualidadeSinal();
    }

    @Override
    public void atualizaTempoEntreIteracoes(long tempoEntreIteracoes) {
        JanelaMonitoramentoExportacaoSms.tempoEntreIteracoes = tempoEntreIteracoes;
        this.atualizaLabelTempoEstimado();
    }

    @Override
    public void atualizaQuantidadeLogEnvio(int qtdeLogEnvio) {
        qtdeLogsEnvio = qtdeLogEnvio;
        this.atualizaLabelQtdeLogsEnvio();
    }

    @Override
    protected void atualizarDadosThread() {
    }

    @Override
    protected Dimension getTamanhoJanela() {
        return new Dimension(350, 310);
    }

    @Override
    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        this.atualizaLabelQualidadeSinal();
    }

    @Override
    public void atualizaTempoProximaIteracao(long tempoProximoProcesso) {
        tempoProximaIteracao = tempoProximoProcesso;
        if (this.getMonitorExportacao().getLogAtual() == this.getMonitorExportacao().getQuantidadeLogEnvio()) {
            if (cronometro != null) {
                cronometro.parar();
            }
            if (tempoProximaIteracao > 0L) {
                cronometro = new JanelaMonitoramentoExportacao.Cronometro(tempoProximaIteracao, -1, labelVlrTempoProximaIteracao);
                cronometro.executarCronometro();
            } else {
                this.atualizaLabelTempoProximaIteracao("00:00:00");
            }
        } else if (cronometro != null) {
            cronometro.parar();
            cronometro = null;
            this.atualizaLabelTempoProximaIteracao("00:00:00");
        }
    }

    public void setSmsSender(SmsSender sender) {
        smsSender = sender;
    }

    public void setSmsSenderApi(SmsSenderAPI sender) {
        smsSenderApi = sender;
    }
}

