/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.util;

import jalis.laboratorio.exportacao.util.ExportacaoMonitor;
import jalis.laboratorio.exportacao.util.JanelaMonitoramentoExportacao;
import jalis.laboratorio.exportacao.util.JanelaMonitoramentoExportacaoEmail;
import jalis.util.Funcoes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.Date;
import javax.swing.JLabel;

public class JanelaMonitoramentoExportacaoAplicativo
extends JanelaMonitoramentoExportacao {
    private JLabel labelTotalEnviar;
    private JLabel labelTempoIteracao;
    private JLabel labelLogAtual;
    private JLabel labelTempoEstimado;
    private JLabel lbValorTotalEnviar;
    private JLabel lbValorLogAtual;
    private JLabel lbValorTempoEstimado;
    private static JLabel lbValorTempoProximaIteracao = new JLabel("00:00:00");
    private int valorTotalEnviar = 0;
    private int valorLogAtual = 0;
    private String tempoEstimado = "";
    private static long tempoProximaIteracao = 0L;
    private static JanelaMonitoramentoExportacao.Cronometro cro;
    private ExportacaoMonitor monitor = null;

    public JanelaMonitoramentoExportacaoAplicativo(Dialog janelaPai, int tipoJanela) {
        super(janelaPai, tipoJanela);
    }

    public JanelaMonitoramentoExportacaoAplicativo(Frame janelaPai, int tipoJanela) {
        super(janelaPai, tipoJanela);
    }

    public static JanelaMonitoramentoExportacaoEmail getInstancia(Window pai, int tipoJanela) {
        if (pai instanceof Frame) {
            return new JanelaMonitoramentoExportacaoEmail((Frame)pai, tipoJanela);
        }
        if (pai instanceof Dialog) {
            return new JanelaMonitoramentoExportacaoEmail((Dialog)pai, tipoJanela);
        }
        return null;
    }

    @Override
    protected void montaPanelInformacoes() {
        this.setSize(400, 300);
        this.labelTotalEnviar = new JLabel("Total para enviar: ");
        this.labelLogAtual = new JLabel("Log atual: ");
        this.labelTempoEstimado = new JLabel("Tempo estimado: ");
        this.labelTempoIteracao = new JLabel("Tempo para pr\u00f3xima itera\u00e7\u00e3o: ");
        this.lbValorTotalEnviar = new JLabel();
        this.lbValorLogAtual = new JLabel();
        this.lbValorTempoEstimado = new JLabel();
        this.getPanelInformacoes().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 2.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.getPanelInformacoes().add((Component)this.labelTotalEnviar, c);
        ++c.gridy;
        this.getPanelInformacoes().add((Component)this.labelLogAtual, c);
        ++c.gridy;
        this.getPanelInformacoes().add((Component)this.labelTempoEstimado, c);
        ++c.gridy;
        this.getPanelInformacoes().add((Component)this.labelTempoIteracao, c);
        c.gridx = 1;
        c.gridy = 0;
        Dimension din = new Dimension(200, 20);
        this.lbValorTotalEnviar.setPreferredSize(din);
        this.lbValorTotalEnviar.setMinimumSize(din);
        this.lbValorTotalEnviar.setMaximumSize(din);
        this.lbValorTotalEnviar.setForeground(Color.RED);
        this.getPanelInformacoes().add((Component)this.lbValorTotalEnviar, c);
        ++c.gridy;
        this.lbValorLogAtual.setPreferredSize(din);
        this.lbValorLogAtual.setMinimumSize(din);
        this.lbValorLogAtual.setMaximumSize(din);
        this.lbValorLogAtual.setForeground(Color.RED);
        this.getPanelInformacoes().add((Component)this.lbValorLogAtual, c);
        ++c.gridy;
        this.lbValorTempoEstimado.setPreferredSize(din);
        this.lbValorTempoEstimado.setMinimumSize(din);
        this.lbValorTempoEstimado.setMaximumSize(din);
        this.lbValorTempoEstimado.setForeground(Color.RED);
        this.getPanelInformacoes().add((Component)this.lbValorTempoEstimado, c);
        ++c.gridy;
        lbValorTempoProximaIteracao.setPreferredSize(din);
        lbValorTempoProximaIteracao.setMinimumSize(din);
        lbValorTempoProximaIteracao.setMaximumSize(din);
        lbValorTempoProximaIteracao.setForeground(Color.RED);
        this.getPanelInformacoes().add((Component)lbValorTempoProximaIteracao, c);
        this.atualizaCampos();
    }

    public void atualizaCampos() {
        if (this.valorTotalEnviar == 0 && this.monitor != null) {
            int n = this.valorTotalEnviar = this.monitor.getQuantidadeParaEnviar() > 0 ? this.monitor.getQuantidadeParaEnviar() : 0;
        }
        if (this.valorLogAtual == 0 && this.monitor != null) {
            int n = this.valorLogAtual = this.monitor.getLogAtual() > 0 ? this.monitor.getLogAtual() : 0;
        }
        if (Funcoes.textoVazio(this.tempoEstimado) && this.monitor != null) {
            this.tempoEstimado = this.monitor.getTempoEntreIteracoes() > 0L ? this.getTempoEstimado(this.monitor.getTempoEntreIteracoes()) : "00:00:00";
        }
        this.lbValorTotalEnviar.setText(String.valueOf(this.valorTotalEnviar));
        this.lbValorTotalEnviar.setOpaque(true);
        this.lbValorLogAtual.setText(String.valueOf(this.valorLogAtual));
        this.lbValorLogAtual.setOpaque(true);
        this.lbValorTempoEstimado.setText(Funcoes.textoVazio(this.tempoEstimado) ? "00:00:00" : this.tempoEstimado);
        this.lbValorTempoEstimado.setOpaque(true);
    }

    @Override
    protected void atualizarDadosThread() {
    }

    @Override
    protected Dimension getTamanhoJanela() {
        return this.getSize();
    }

    @Override
    public void atualizaQuantidadeParaEnviar(int totalEnviar) {
        this.valorTotalEnviar = totalEnviar;
        this.atualizaCampos();
    }

    @Override
    public void atualizaLogAtual(int logAtual) {
        this.valorLogAtual = logAtual;
        this.atualizaCampos();
    }

    @Override
    public void atualizaValorSinal(int valorSinal) {
    }

    @Override
    public void atualizaQuantidadeLogEnvio(int qtdeLogEnvio) {
    }

    @Override
    public void atualizaTempoEntreIteracoes(long tempoEntreIteracoes) {
        this.tempoEstimado = this.getTempoEstimado(tempoEntreIteracoes * (long)(this.valorTotalEnviar - this.valorLogAtual));
        this.atualizaCampos();
    }

    public String getTempoEstimado(long tempo) {
        return Funcoes.formataHora(new Date(tempo), "GMT", true);
    }

    @Override
    public void atualizaTempoProximaIteracao(long tempoProximoProcesso) {
        tempoProximaIteracao = tempoProximoProcesso;
        if (this.getMonitorExportacao().getLogAtual() == this.getMonitorExportacao().getQuantidadeLogEnvio()) {
            if (cro != null) {
                cro.parar();
            }
            if (tempoProximaIteracao > 0L) {
                cro = new JanelaMonitoramentoExportacao.Cronometro(tempoProximaIteracao, -1, lbValorTempoProximaIteracao);
                cro.executarCronometro();
            } else {
                lbValorTempoProximaIteracao.setText("00:00:00");
            }
        } else if (cro != null) {
            cro.parar();
            cro = null;
            lbValorTempoProximaIteracao.setText("00:00:00");
        }
    }
}

