/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.util;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.util.ExportacaoListener;
import jalis.laboratorio.exportacao.util.ExportacaoMonitor;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public abstract class JanelaMonitoramentoExportacao
extends JDialog
implements ActionListener,
ExportacaoListener {
    public static final int TIPO_JANELA_SMS = 0;
    public static final int TIPO_JANELA_EMAIL = 1;
    public static final int TIPO_JANELA_WEB = 2;
    public static final int TIPO_JANELA_INTEGRACAO_OFFLINE = 3;
    public static final int TIPO_JANELA_APLICATIVO = 4;
    private JPanel panelInformacoes = new JPanel(new GridBagLayout());
    private JPanel panelConsole = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelBotoesEsquerda = new JPanel(new FlowLayout(0));
    private JPanel panelBotoesDireita = new JPanel(new FlowLayout(2));
    private JTextArea areaConsole = new JTextArea();
    private JScrollPane scrollConsole = new JScrollPane();
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonLimparConsole = new JButton("Limpar console");
    protected JButton buttonExportarRequisicao = new JButton("Exportar Requisi\u00e7\u00e3o");
    private int tipoJanela = -1;
    private ExportacaoMonitor monitor = null;
    private ThreadMonitoramento threadAtualizacao = null;
    private boolean isUsarThread = false;
    protected String operacaoAtual = null;

    protected abstract void montaPanelInformacoes();

    protected abstract void atualizarDadosThread();

    protected abstract Dimension getTamanhoJanela();

    @Override
    public abstract void atualizaQuantidadeParaEnviar(int var1);

    @Override
    public abstract void atualizaLogAtual(int var1);

    @Override
    public abstract void atualizaValorSinal(int var1);

    @Override
    public abstract void atualizaTempoEntreIteracoes(long var1);

    @Override
    public abstract void atualizaQuantidadeLogEnvio(int var1);

    public JanelaMonitoramentoExportacao(Dialog janelaPai, int tipoJanela) {
        super(janelaPai, JanelaMonitoramentoExportacao.getTituloTela(tipoJanela), true);
        this.setTipoJanela(tipoJanela);
        this.montaTela(tipoJanela);
    }

    public JanelaMonitoramentoExportacao(Frame janelaPai, int tipoJanela) {
        super(janelaPai, JanelaMonitoramentoExportacao.getTituloTela(tipoJanela), true);
        this.setTipoJanela(tipoJanela);
        this.montaTela(tipoJanela);
    }

    protected int getTipoJanela() {
        return this.tipoJanela;
    }

    protected void setTipoJanela(int tipoJanela) {
        this.tipoJanela = tipoJanela;
    }

    protected ExportacaoMonitor getMonitorExportacao() {
        return this.monitor;
    }

    @Override
    public void setMonitorExportacao(ExportacaoMonitor monitor) {
        this.monitor = monitor;
        if (this.monitor != null) {
            monitor.addExportacaoListener(this);
        }
    }

    protected JPanel getPanelInformacoes() {
        return this.panelInformacoes;
    }

    protected void montaTela(int tipoJanela) {
        JPanel panelPrincipal = (JPanel)this.getContentPane();
        panelPrincipal.removeAll();
        panelPrincipal.setLayout(new GridBagLayout());
        this.montaPanelInformacoes();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 1;
        this.panelInformacoes.setBorder(new TitledBorder("Informa\u00e7\u00f5es"));
        panelPrincipal.add((Component)this.panelInformacoes, c);
        ++c.gridy;
        c.weighty = 1.0;
        panelPrincipal.add((Component)this.panelConsole, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        panelPrincipal.add((Component)this.panelBotoes, c);
        this.scrollConsole.setViewportView(this.areaConsole);
        this.scrollConsole.setPreferredSize(new Dimension(20, 100));
        this.scrollConsole.setMinimumSize(new Dimension(20, 100));
        this.panelConsole.setBorder(new TitledBorder("Console"));
        this.panelConsole.add((Component)this.scrollConsole, "Center");
        this.areaConsole.setEditable(false);
        this.panelBotoes.add((Component)this.panelBotoesEsquerda, "West");
        this.panelBotoes.add((Component)this.panelBotoesDireita, "East");
        this.panelBotoesDireita.add(this.buttonFechar);
        this.panelBotoesEsquerda.add(this.buttonLimparConsole);
        if (tipoJanela == 3) {
            this.panelBotoesEsquerda.add(this.buttonExportarRequisicao);
        }
        this.buttonFechar.setMnemonic('F');
        this.buttonLimparConsole.setMnemonic('L');
        this.buttonExportarRequisicao.setMnemonic('E');
        this.adicionaListeners();
        this.setSize(this.getTamanhoJanela());
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    private void adicionaListeners() {
        this.buttonFechar.addActionListener(this);
        this.buttonLimparConsole.addActionListener(this);
        this.buttonExportarRequisicao.addActionListener(this);
    }

    private void iniciaThreadAtualizacao() {
        if (this.threadAtualizacao != null) {
            this.threadAtualizacao.setThreadFinalizada(true);
        }
        this.threadAtualizacao = new ThreadMonitoramento(this.tipoJanela);
        this.threadAtualizacao.start();
    }

    private static String getTituloTela(int tipoJanela) {
        switch (tipoJanela) {
            case 0: {
                return "Envio de SMS";
            }
            case 1: {
                return "Envio de e-mail";
            }
            case 2: {
                return "Envio de requisi\u00e7\u00f5es para Web";
            }
            case 3: {
                return "Envio de arquivos de integra\u00e7\u00e3o";
            }
            case 4: {
                return "Envio de mensagens de aplicativo";
            }
        }
        return "";
    }

    @Override
    public void atualizaOperacaoAtual(String operacaoAtual) {
        this.operacaoAtual = operacaoAtual;
        this.areaConsole.append(operacaoAtual);
        this.areaConsole.append("\n");
        this.areaConsole.setCaretPosition(this.areaConsole.getDocument().getLength());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.fechar();
        } else if (e.getSource() == this.buttonLimparConsole) {
            this.limparConsole();
        }
    }

    private void limparConsole() {
        this.areaConsole.setText("");
    }

    private void fechar() {
        if (this.threadAtualizacao != null) {
            this.threadAtualizacao.setThreadFinalizada(true);
        }
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean isVisible) {
        if (isVisible && this.isUsarThread) {
            this.iniciaThreadAtualizacao();
        }
        super.setVisible(isVisible);
    }

    public void setUsarThread(boolean isUsarThread) {
        this.isUsarThread = isUsarThread;
    }

    class Cronometro {
        private Timer cronometro;
        private Calendar calendario = Calendar.getInstance();
        private final byte contagem;
        public static final byte PROGRESSIVA = 1;
        public static final byte REGRESSIVA = -1;
        private TimerTask tarefa = null;
        private JComponent componente = null;
        private Date novaData = null;
        private boolean isExecutando = false;
        private boolean isParar = false;

        public Cronometro(long tempoMilisegundo, byte tipoContagem, JComponent componente) {
            this.cronometro = new Timer();
            this.contagem = tipoContagem;
            this.componente = componente;
            this.novaData = new Date(tempoMilisegundo);
            this.calendario.setTime(this.novaData);
        }

        public void executarCronometro() {
            this.tarefa = new TimerTask(){

                @Override
                public void run() {
                    if (Cronometro.this.isParar) {
                        return;
                    }
                    String aux = Cronometro.this.getTime();
                    Cronometro.this.isExecutando = true;
                    if (Cronometro.this.componente instanceof JLabel) {
                        ((JLabel)Cronometro.this.componente).setText(aux);
                    }
                    if (aux.equalsIgnoreCase("00:00:00")) {
                        Cronometro.this.parar();
                        Cronometro.this.isExecutando = false;
                    }
                }
            };
            this.cronometro.scheduleAtFixedRate(this.tarefa, 0L, 1000L);
        }

        private String getTime() {
            this.calendario.add(13, this.contagem);
            return Funcoes.formataHora(this.calendario.getTime(), "GMT", true);
        }

        public void parar() {
            this.isParar = true;
            if (this.tarefa != null) {
                this.tarefa.cancel();
            }
        }

        public void iniciar() {
            if (this.tarefa != null) {
                this.tarefa.run();
            }
        }

        public boolean isExecutando() {
            return this.isExecutando;
        }
    }

    class ThreadMonitoramento
    extends Thread {
        private final int TEMPO_THREAD_MONITORAMENTO = 5000;
        private boolean isThreadFinalizada;

        public ThreadMonitoramento(int tipoTela) {
            super("Thread Janela Monitoramento");
            this.TEMPO_THREAD_MONITORAMENTO = 5000;
            this.isThreadFinalizada = false;
            this.setPriority(1);
        }

        @Override
        public void run() {
            while (!this.isThreadFinalizada) {
                JanelaMonitoramentoExportacao.this.atualizarDadosThread();
                try {
                    ThreadMonitoramento.sleep(5000L);
                }
                catch (InterruptedException e) {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel colocar a thread de monitoramento em espera.\n" + e.getMessage(), e.getStackTrace());
                    break;
                }
            }
        }

        public boolean getThreadFinalizada() {
            return this.isThreadFinalizada;
        }

        public void setThreadFinalizada(boolean isThreadFinalizada) {
            this.isThreadFinalizada = isThreadFinalizada;
        }
    }
}

