/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.util;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.integracao.apijalisintegracao.ComunicacaoAPI;
import jalis.integracao.apijalisintegracao.ComunicacaoFactory;
import jalis.integracao.apijalisintegracao.dto.ComandoPendenciaDTO;
import jalis.integracao.apijalisintegracao.dto.IntegracaoDTO;
import jalis.integracao.apijalisintegracao.dto.RespostaIntegracaoDTO;
import jalis.integracao.servidor.ProcessarDependencia;
import jalis.integracao.servidor.Servidor2;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.bean.recepcao.RequisicaoLanctoCaixaBean;
import jalis.service.integracaoaplicativo.IntegracaoAplicativoService;
import jalis.service.recepcao.RequisicaoLanctoCaixaService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class JanelaExportaRequisicaoIntegracao
extends JDialog
implements ActionListener,
KeyListener {
    private static final String CONCLUIDO = "\nConclu\u00eddo.";
    private static final String EXPORTANDO = "\nExportando...";
    private JPanel panelConsole = new JPanel(new BorderLayout());
    private JPanel panelRequisicao = new JPanel(new GridBagLayout());
    private JPanel panelBotoes = new JPanel(new BorderLayout());
    private JPanel panelBotoesEsquerda = new JPanel(new FlowLayout(0));
    private JPanel panelBotoesDireita = new JPanel(new FlowLayout(2));
    private JLabel labelRequisicao = new JLabel("C\u00f3digo:");
    private JLabel labelCodRequisicao = new JLabel();
    private JLabel labelDesRequisicao = new JLabel();
    private JButton buttonExportar = new JButton("Exportar");
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonBuscaRequisicao = new JButton();
    private JScrollPane scrollConsole = new JScrollPane();
    private JTextArea areaConsole = new JTextArea();

    public JanelaExportaRequisicaoIntegracao(JDialog janelaPai) {
        super(janelaPai, "Exportar Requisi\u00e7\u00e3o", true);
        JPanel panelPrincipal = (JPanel)this.getContentPane();
        panelPrincipal.setLayout(new GridBagLayout());
        Funcoes.imagemPesquisa(this.buttonBuscaRequisicao);
        ScreenUtil.setBorda(new JComponent[]{this.labelCodRequisicao, this.labelDesRequisicao}, new TitledBorder(""));
        this.buttonFechar.addActionListener(this);
        this.buttonExportar.addActionListener(this);
        this.buttonBuscaRequisicao.addActionListener(this);
        this.buttonFechar.setMnemonic('F');
        this.buttonExportar.setMnemonic('E');
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 17;
        this.panelRequisicao.setBorder(new TitledBorder("Requisi\u00e7\u00e3o"));
        this.panelRequisicao.add((Component)this.labelRequisicao, c);
        ++c.gridx;
        this.labelCodRequisicao.setPreferredSize(new Dimension(100, 20));
        this.labelCodRequisicao.setMinimumSize(new Dimension(100, 20));
        this.panelRequisicao.add((Component)this.labelCodRequisicao, c);
        ++c.gridx;
        this.buttonBuscaRequisicao.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaRequisicao.setMinimumSize(new Dimension(20, 20));
        this.panelRequisicao.add((Component)this.buttonBuscaRequisicao, c);
        c.insets = new Insets(0, 1, 0, 0);
        c.weightx = 1.0;
        ++c.gridx;
        c.fill = 2;
        this.labelDesRequisicao.setPreferredSize(new Dimension(20, 20));
        this.labelDesRequisicao.setMinimumSize(new Dimension(20, 20));
        this.panelRequisicao.add((Component)this.labelDesRequisicao, c);
        c.insets = new Insets(0, 0, 0, 0);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.anchor = 17;
        c2.gridheight = 1;
        c2.gridwidth = 1;
        c2.gridx = 0;
        c2.gridy = 0;
        c2.insets = new Insets(0, 0, 0, 0);
        c2.weightx = 1.0;
        c2.weighty = 0.0;
        c2.fill = 2;
        panelPrincipal.add((Component)this.panelRequisicao, c2);
        ++c2.gridy;
        c2.weighty = 1.0;
        c2.fill = 1;
        panelPrincipal.add((Component)this.panelConsole, c2);
        ++c2.gridy;
        c2.weighty = 0.0;
        c2.fill = 2;
        panelPrincipal.add((Component)this.panelBotoes, c2);
        this.panelConsole.setBorder(new TitledBorder("Console"));
        this.panelConsole.add((Component)this.scrollConsole, "Center");
        this.scrollConsole.setViewportView(this.areaConsole);
        this.scrollConsole.setPreferredSize(new Dimension(20, 100));
        this.scrollConsole.setMinimumSize(new Dimension(20, 100));
        this.panelConsole.setBorder(new TitledBorder("Console"));
        this.panelConsole.add((Component)this.scrollConsole, "Center");
        this.areaConsole.setEditable(false);
        this.panelBotoes.add((Component)this.panelBotoesEsquerda, "West");
        this.panelBotoes.add((Component)this.panelBotoesDireita, "East");
        this.panelBotoesDireita.add(this.buttonExportar);
        this.panelBotoesDireita.add(this.buttonFechar);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaExportaRequisicaoIntegracao.this.pesquisarRequisicao();
                }
            }
        });
        this.buttonBuscaRequisicao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    JanelaExportaRequisicaoIntegracao.this.pesquisarRequisicao();
                }
            }
        });
        this.setSize(new Dimension(400, 325));
        this.setResizable(false);
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.buttonBuscaRequisicao);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.buttonFechar)) {
            this.dispose();
        } else if (e.getSource().equals(this.buttonExportar)) {
            if (!Funcoes.textoVazio(this.labelCodRequisicao.getText())) {
                this.exportar(this.labelCodRequisicao.getText());
            }
        } else if (e.getSource().equals(this.buttonBuscaRequisicao)) {
            this.pesquisarRequisicao();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String exportar(String codRequisicao) {
        Statement st = Conexao.getStatement();
        ArrayList<String> sqlFinal = new ArrayList<String>();
        try {
            String sql = null;
            this.areaConsole.setText("");
            Integer[] guias = RecepcaoUtil.verificaMultiGuias(Variaveis.filialPadrao, codRequisicao, true);
            this.areaConsole.append("Exportando dados da requisi\u00e7\u00e3o.");
            this.areaConsole.append(EXPORTANDO);
            for (Integer req : guias) {
                sql = DBUtil.getInsertDeSelect(st, this.getSelectPaciente(req));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelectMedicamentosPaciente(req));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeSelect(st, this.getSelect(req, "requisicao"));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelect(req, "requisicaotaxa"));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelect(req, "requisicaomedicamento"));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelect(req, "requisicaocid10"));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelect(req, "requisicaousuario"));
                this.concatenaSql(sqlFinal, sql);
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", Variaveis.filialPadrao);
                chaves.put("req_codigo", req);
                Set<RequisicaoLanctoCaixaBean> requisicaoLanctoCaixaBean = new RequisicaoLanctoCaixaService().getBeans(chaves);
                if (requisicaoLanctoCaixaBean != null && !requisicaoLanctoCaixaBean.isEmpty()) {
                    for (RequisicaoLanctoCaixaBean bean : requisicaoLanctoCaixaBean) {
                        sql = DBUtil.getInsertDeVariosSelect(st, this.getSelectLanctoCaixa(bean.getLancamento().getCodigo().toString()));
                        this.concatenaSql(sqlFinal, sql);
                    }
                }
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelect(req, "requisicaolanctocaixa"));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelect(req, "examerequisicao"));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelectExameRequisicaoSituacoes(req));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelect(req, "examerequisicaoguiaagrupada"));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelect(req, "materialexamerequis"));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelect(req, "examerequisicaorecipiente"));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelect(req, "interfaceexamerequisicao"));
                this.concatenaSql(sqlFinal, sql);
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelect(req, "interfaceexamerequisicaodesm"));
                this.concatenaSql(sqlFinal, sql);
            }
            for (Integer req : guias) {
                sql = DBUtil.getInsertDeVariosSelect(st, this.getSelect(req, "requisicaorequisicao"));
                this.concatenaSql(sqlFinal, sql);
            }
            this.enviarParaAPI(st, sqlFinal);
            this.areaConsole.append(CONCLUIDO);
            this.buttonExportar.setEnabled(false);
        }
        catch (Exception e) {
            this.areaConsole.append("\n" + e.getMessage());
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        finally {
            try {
                st.close();
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        return ((Object)sqlFinal).toString();
    }

    private void enviarParaAPI(Statement st, List<String> comandos) throws Exception {
        if (!comandos.isEmpty()) {
            String filial = String.valueOf(Variaveis.estacaoFilialIntegracao);
            String parCliente = IntegracaoUtil.carregarParCliente(st);
            String ipIntegracao = ParametrosGerais.getIpIntegracao();
            String authCript = new IntegracaoAplicativoService().encript(parCliente);
            ComunicacaoAPI comunicacao = ComunicacaoFactory.getComunicacaoAutenticada(ipIntegracao, authCript, filial);
            comunicacao.notificouQuantidadeLogsParaEnviar(filial, comandos.size(), ConstantesGerais.NRVERSAO);
            IntegracaoDTO prioridade = new IntegracaoDTO(Variaveis.estacaoFilialIntegracao, -1L, 0L, comandos.size());
            prioridade.adicionarComandos(comandos);
            RespostaIntegracaoDTO respostaIntegracao = comunicacao.enviarPrioridadeIntegracao(prioridade);
            this.debug(respostaIntegracao.mensagemRespostaAPI());
            boolean processou = this.processouDependencia(comunicacao, respostaIntegracao);
            while (processou) {
                respostaIntegracao = comunicacao.enviarPrioridadeIntegracao(prioridade);
                processou = this.processouDependencia(comunicacao, respostaIntegracao);
            }
        }
    }

    private boolean processouDependencia(ComunicacaoAPI comunicacao, RespostaIntegracaoDTO respostaIntegracao) throws Exception {
        boolean processou = false;
        String filial = String.valueOf(Variaveis.estacaoFilialIntegracao);
        if (respostaIntegracao.isFilialBloqueada()) {
            String mensagem = "Filial " + filial + " bloqueada na API";
            throw new Exception(mensagem);
        }
        if (!respostaIntegracao.isOk()) {
            if (!respostaIntegracao.getDependencias().isEmpty()) {
                ComandoPendenciaDTO comandoPendencia = ProcessarDependencia.executar(filial, respostaIntegracao.getDependencias());
                RespostaIntegracaoDTO respostaDependencia = null;
                if (!comandoPendencia.getComandos().isEmpty()) {
                    do {
                        respostaDependencia = comunicacao.enviarComandoPendencia(comandoPendencia);
                        processou = respostaDependencia.isOk();
                        this.debug("Resp. comando dependencia: " + respostaDependencia.mensagemRespostaAPI());
                        if (respostaDependencia.getDependencias().isEmpty()) continue;
                        comandoPendencia = ProcessarDependencia.executar(filial, respostaIntegracao.getDependencias());
                    } while (!respostaDependencia.getDependencias().isEmpty());
                } else {
                    String mensagem = "Falha na gera\u00e7\u00e3o dos comandos de pendencias";
                    this.debug(respostaIntegracao.mensagemRespostaAPI());
                    throw new Exception("Falha na gera\u00e7\u00e3o dos comandos de pendencias");
                }
            }
            if (!Funcoes.textoVazio(respostaIntegracao.getMensagemErro())) {
                this.debug("API respondeu erro: " + respostaIntegracao.getMensagemErro());
                throw new Exception(respostaIntegracao.getMensagemErro());
            }
        }
        return processou;
    }

    private void concatenaSql(List<String> sqlFinal, String sql) {
        if (!Funcoes.textoVazio(sql)) {
            sql = sql + " ;";
            sqlFinal.add(sql);
        }
    }

    private String getSelectLanctoCaixa(String lcxCodigo) {
        return "select * from lanctocaixa where lcx_codigo = " + lcxCodigo + " and fil_codigo = " + Variaveis.filialPadrao;
    }

    private String getSelect(Integer codRequisicao, String tabela) {
        return "select * from " + tabela + " where req_codigo = " + codRequisicao + " and fil_codigo = " + Variaveis.filialPadrao;
    }

    private String getSelectExameRequisicaoSituacoes(Integer codRequisicao) {
        return "select fil_codigo, exa_codigo, mco_codigo, req_codigo, usr_codigo, ers_situacao, ers_datahora from examerequisicaosituacoes where fil_codigo = " + Variaveis.filialPadrao + " and req_codigo = " + codRequisicao + ";";
    }

    private String getSelectPaciente(Integer codRequisicao) {
        return "select a.* from paciente a join requisicao b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo where b.req_codigo = " + codRequisicao + " and b.fil_codigo = " + Variaveis.filialPadrao;
    }

    private String getSelectMedicamentosPaciente(Integer codRequisicao) {
        return "select a.* from pacientemedicamento a join requisicao req on req.fil_codigo = a.fil_codigo and req.pac_codigo = a.pac_codigo where req.req_codigo = " + codRequisicao + " and req.fil_codigo = " + Variaveis.filialPadrao;
    }

    private void pesquisarRequisicao() {
        Hashtable resultado = Pesquisas.requisicao(this, Variaveis.filialPadrao, false, Acesso.getAcesso(Long.parseLong("0200500178")), Acesso.getAcesso(Long.parseLong("0200500179")));
        if (resultado != null) {
            this.labelCodRequisicao.setText(resultado.get("req_codigo").toString());
            this.labelDesRequisicao.setText(resultado.get("pac_nome").toString());
            this.buttonExportar.setEnabled(true);
            ScreenUtil.requisitarFoco(this.buttonExportar);
            this.areaConsole.setText("");
        } else {
            this.labelCodRequisicao.setText("");
            this.labelDesRequisicao.setText("");
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 113) {
            this.pesquisarRequisicao();
        }
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    private void debug(String mensagem) {
        if (Servidor2.debug) {
            System.out.println(mensagem);
        }
    }
}

