/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.util;

import jalis.laboratorio.exportacao.util.ExportacaoListener;
import jalis.util.Funcoes;
import java.util.ArrayList;

public class ExportacaoMonitor {
    private int qtdeEnviar = 0;
    private int qtdeLogEnvio = 0;
    private int logAtual = 0;
    private int valorSinal = 0;
    private long tempoEntreIteracoes = 0L;
    private long tempoProximaIteracao = 0L;
    private String operacaoAtual = "";
    private ArrayList<ExportacaoListener> listeners = new ArrayList();

    public long getTempoProximaIteracao() {
        return this.tempoProximaIteracao;
    }

    public void setTempoProximaIteracao(long tempoProximaIntegracao) {
        this.tempoProximaIteracao = tempoProximaIntegracao;
        this.fireTempoProximaIteracaoAlterado(tempoProximaIntegracao);
    }

    public int getQuantidadeParaEnviar() {
        return this.qtdeEnviar;
    }

    public int getQuantidadeLogEnvio() {
        return this.qtdeLogEnvio;
    }

    public int getLogAtual() {
        return this.logAtual;
    }

    public String getOperacaoAtual() {
        return this.operacaoAtual;
    }

    public int getValorSinal() {
        return this.valorSinal;
    }

    public long getTempoEntreIteracoes() {
        return this.tempoEntreIteracoes;
    }

    public void setTempoEntreIteracoes(long tempoEntreIteracoes) {
        this.tempoEntreIteracoes = tempoEntreIteracoes;
        this.fireTempoEntreIteracoesAlterado(tempoEntreIteracoes);
    }

    public void setQuantidadeParaEnviar(int qtdeEnviar) {
        this.qtdeEnviar = qtdeEnviar < 0 ? 0 : qtdeEnviar;
        this.fireQuantidadeParaEnviarAlterada(qtdeEnviar);
    }

    public void setQuantidadeLogEnvio(int qtdeLogEnvio) {
        this.qtdeLogEnvio = qtdeLogEnvio < 0 ? 0 : qtdeLogEnvio;
        this.fireQuantidadeLogEnvioAlterada(qtdeLogEnvio);
    }

    public void setLogAtual(int logAtual) {
        this.logAtual = logAtual < 0 ? 0 : logAtual;
        this.fireLogAtualAlterado(logAtual);
    }

    public void setOperacaoAtual(String operacaoAtual) {
        this.operacaoAtual = Funcoes.textoVazio(operacaoAtual) ? "" : operacaoAtual;
        this.fireOperacaoAtualAlterada(operacaoAtual);
    }

    public void setValorSinal(int valorSinal) {
        this.valorSinal = valorSinal;
        this.fireValorSinalAlterado(valorSinal);
    }

    private void fireValorSinalAlterado(int valorSinal) {
        if (this.listeners != null) {
            for (ExportacaoListener aux : this.listeners) {
                aux.atualizaValorSinal(valorSinal);
            }
        }
    }

    private void fireOperacaoAtualAlterada(String operacaoAtual) {
        if (this.listeners != null) {
            for (ExportacaoListener aux : this.listeners) {
                aux.atualizaOperacaoAtual(operacaoAtual);
            }
        }
    }

    private void fireQuantidadeParaEnviarAlterada(int qtdeEnviar) {
        if (this.listeners != null) {
            for (ExportacaoListener aux : this.listeners) {
                aux.atualizaQuantidadeParaEnviar(qtdeEnviar);
            }
        }
    }

    private void fireQuantidadeLogEnvioAlterada(int qtdelogEnvio) {
        if (this.listeners != null) {
            for (ExportacaoListener aux : this.listeners) {
                aux.atualizaQuantidadeLogEnvio(this.qtdeLogEnvio);
            }
        }
    }

    private void fireLogAtualAlterado(int logAtual) {
        if (this.listeners != null) {
            for (ExportacaoListener aux : this.listeners) {
                aux.atualizaLogAtual(logAtual);
            }
        }
    }

    private void fireTempoEntreIteracoesAlterado(long tempoEntreIteracoes) {
        if (this.listeners != null) {
            for (ExportacaoListener aux : this.listeners) {
                aux.atualizaTempoEntreIteracoes(tempoEntreIteracoes);
            }
        }
    }

    private void fireTempoProximaIteracaoAlterado(long tempoProxima) {
        if (this.listeners != null) {
            for (ExportacaoListener aux : this.listeners) {
                aux.atualizaTempoProximaIteracao(tempoProxima);
            }
        }
    }

    public void addExportacaoListener(ExportacaoListener listener) {
        boolean jaAdicionou = false;
        for (ExportacaoListener aux : this.listeners) {
            if (aux != listener) continue;
            jaAdicionou = true;
            break;
        }
        if (!jaAdicionou) {
            this.listeners.add(listener);
            listener.setMonitorExportacao(this);
        }
    }

    public void removeAllListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
    }
}

