/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.thread;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.integracaohospitais.sistemas.sigh.IntegracaoHospitalSigh;
import jalis.integracaohospitais.util.FabricaIntegracaoHospital;
import jalis.integracaohospitais.util.ProtocoloIntegracaoHospital;
import jalis.integracaohospitais.util.salux.service.SaluxService;
import jalis.integracaooperadoras.sistemas.AbstractIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.FabricaIntegracaoOperadora;
import jalis.integracaooperadoras.sistemas.ipmsaude.IPMSaudeService;
import jalis.integracaooperadoras.sistemas.ipmsaude.IntegracaoOperadoraIPMSaude;
import jalis.integracaooperadoras.sistemas.mksaude.IntegracaoOperadoraMKSaude;
import jalis.integracaooperadoras.sistemas.simus.IntegracaoOperadoraSimus;
import jalis.integracaooperadoras.sistemas.sline.model.SLineService;
import jalis.integracaooperadoras.sistemas.sline.model.SLineVO;
import jalis.integracaooperadoras.sistemas.unimed.guaxupe.IntegracaoOperadoraGuaxupe;
import jalis.integracaooperadoras.sistemas.unimed.pr.IntegracaoOperadoraPR;
import jalis.integracaooperadoras.sistemas.unimed.sinos.IntegracaoOperadoraUnimedValeSinos;
import jalis.integracaooperadoras.sistemas.unimed.sinos.ValeDosSinosDTO;
import jalis.integracaooperadoras.sistemas.unimed.vtrp.IntegracaoOperadoraUnimedVTRP;
import jalis.integracaooperadoras.sistemas.upy.IntegracaoOperadoraUpy;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb2;
import jalis.laboratorio.exportacao.thread.ThreadInterfaceExportacao;
import jalis.laboratorio.interfaceamento.resultados.Exportacao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.service.cadastro.ConvenioService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThreadInterfaceExportacaoWebIntegracao
extends Thread {
    private static final int QTDE_LOGS_LIMPAR_MEMORIA = 120;
    private static ConcurrentLinkedQueue<HashMap<Object, Object>> logsInterface = new ConcurrentLinkedQueue();
    private int qtdeExportada = 0;
    public static boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.setName("Thread Interface Exporta\u00e7\u00e3o, Classe - > ThreadInterfaceExportacaoWebIntegracao");
        while (true) {
            ConcurrentLinkedQueue<HashMap<Object, Object>> concurrentLinkedQueue = logsInterface;
            synchronized (concurrentLinkedQueue) {
                Iterator<HashMap<Object, Object>> i = logsInterface.iterator();
                HashMap<Object, Object> mapParams = null;
                while (i.hasNext()) {
                    try {
                        Conexao.arquivaSQL();
                        mapParams = i.next();
                        this.processaInterfaceSalvarExportar(mapParams);
                        i.remove();
                        Conexao.arquivaSQL();
                        if (++this.qtdeExportada >= 120) {
                            System.gc();
                            this.qtdeExportada = 0;
                            Thread.sleep(50L);
                        }
                    }
                    catch (Exception e) {
                        try {
                            Conexao.anulaSQL();
                            Conexao.executePerformance(mapParams.get("fil_codigo").toString(), Conexao.getStatement(), mapParams.get("roolback").toString(), true);
                            Conexao.arquivaSQL();
                            ThreadInterfaceExportacao.stopThread();
                            ThreadInterfaceExportacaoWebIntegracao.stopThread();
                            e.printStackTrace();
                            ErrorLogger.mostraMensagem(null, " N\u00e3o foi poss\u00edvel finaliza o processamento da thread ThreadInterfaceExportacaoWebIntegracao ", e.getStackTrace());
                            break;
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public boolean exportando() {
        return logsInterface.isEmpty();
    }

    public static boolean exportandoLogs() {
        return logsInterface.isEmpty();
    }

    public int getQuantidadeExportacao() {
        return logsInterface.size();
    }

    public static int getQuantidadeLogs() {
        return logsInterface.size();
    }

    public static void stopThread() {
        logsInterface.clear();
    }

    private void processaInterfaceSalvarExportar(HashMap<Object, Object> mapParams) throws Exception {
        Variaveis.exportandoInterface = true;
        Statement st = Conexao.getStatement();
        String xmlAssinado = null;
        if (mapParams.get("assinarXml") != null && Boolean.valueOf(mapParams.get("assinarXml").toString()).booleanValue()) {
            xmlAssinado = ResultadosUtil.assinarXML(st, this.getFilial(mapParams), StringUtil.textoDB(this.getResultado(mapParams)), this.getRequisicao(mapParams), this.getExame(mapParams), this.getMaterial(mapParams), mapParams.get("pac_nome").toString(), mapParams.get("pac_sexo").toString(), Funcoes.formataData("dd-MM-yyyy", BDUtil.getDataNacimentoPacienteSemSynchronized(this.getFilial(mapParams), this.getRequisicao(mapParams))), (Date)mapParams.get("dataAssinatura"));
            ResultadosUtil.gravarHashResultadoPerformance(st, this.getFilial(mapParams), this.getRequisicao(mapParams), this.getExame(mapParams), this.getMaterial(mapParams), mapParams.get("pac_nome").toString(), xmlAssinado != null ? xmlAssinado : this.getResultado(mapParams), (List)mapParams.get("componentes"));
            StringBuffer query = new StringBuffer();
            query.append("update examerequisicao set ");
            query.append("exr_resultado = ").append(DBUtil.bdText(xmlAssinado != null ? xmlAssinado : this.getResultado(mapParams)));
            query.append(", exr_datacertificado = '").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", (Date)mapParams.get("dataAssinatura"))).append("' ");
            query.append(" where fil_codigo = ");
            query.append(this.getFilial(mapParams));
            query.append(" and req_codigo = ");
            query.append(this.getRequisicao(mapParams));
            query.append(" and exa_codigo = '");
            query.append(this.getExame(mapParams));
            query.append("' and mco_codigo = ");
            query.append(this.getMaterial(mapParams));
            Conexao.executeUpdatePerformance(this.getFilial(mapParams), st, query.toString());
        } else {
            String tipoIntegracaoOperadoraConvenio;
            if (mapParams.get("baseWeb") != null && !this.getBaseWeb(mapParams).isEmpty()) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("situacaoExameRequisicao");
                list.add(mapParams.get("situacao").toString());
                if (mapParams.get("situacao").toString().equals("C")) {
                    list.add("nomeAssinaturaExameRequisicao");
                    list.add(Variaveis.nomeUsuario);
                    list.add("assinaturaExameRequisicao");
                    list.add(Variaveis.login);
                }
                Exportacao.alterarExameRequisicaoWeb(false, st, this.getFilial(mapParams), this.getRequisicao(mapParams), this.getExame(mapParams), this.getMaterial(mapParams), this.getBaseWeb(mapParams), list.toArray(new String[list.size()]));
            }
            BDUtil.setExmSituacaoEAssinaturaPerformance(st, this.getFilial(mapParams), this.getInterface(mapParams), this.getRequisicao(mapParams), this.getExame(mapParams), String.valueOf(this.getMaterial(mapParams)), this.getRecipiente(mapParams), 8, this.getUsuario(mapParams));
            BDUtil.setExmSituacaoTodosFilhosPerformance(st, this.getFilial(mapParams), this.getInterface(mapParams), this.getRequisicao(mapParams), this.getExame(mapParams), String.valueOf(this.getMaterial(mapParams)), this.getRecipiente(mapParams), 8);
            if (mapParams.get("insertexportapdf") != null && !mapParams.get("insertexportapdf").toString().isEmpty() && !this.verificaSeJaPossuiLog(mapParams)) {
                st.execute(mapParams.get("insertexportapdf").toString());
            }
            ExportaWeb2.atualizaPaginaOrdemExameWeb(st, this.getFilial(mapParams), this.getRequisicao(mapParams), this.getExame(mapParams), this.getMaterial(mapParams), this.getBaseWeb(mapParams));
            Util.gravaAlteracaoExameRequisicao(st, this.getFilial(mapParams), this.getRequisicao(mapParams), this.getExame(mapParams), String.valueOf(this.getMaterial(mapParams)));
            ExportaFiliais.gravaRequisicao(Integer.parseInt(this.getFilial(mapParams)), Long.parseLong(this.getRequisicao(mapParams)), this.getExame(mapParams), Integer.parseInt(this.getMaterial(mapParams)), "U", "U");
            SMSUtil.criaLogSmsComDadosRequisicao(this.getFilial(mapParams), this.getRequisicao(mapParams), ExportaSMS.TipoSMS.RESULTADO, st, Conexao.getStatement());
            EmailUtil.criaLogEmail(this.getFilial(mapParams), this.getRequisicao(mapParams), null, EmailUtil.TipoEmail.RESULTADO, true, st);
            PushUtil.criaLogPushComDadosRequisicao(this.getFilial(mapParams), this.getRequisicao(mapParams), TipoPush.RESULTADO, st, Conexao.getStatement());
            WhatsAppUtil.criaLogWhatsappComDadosRequisicao(this.getFilial(mapParams), this.getRequisicao(mapParams), TipoWhatsapp.RESULTADO, st, Conexao.getStatement());
            String integracaoHospital = BDUtil.getCodigoIntegracaoHospitalRequisicao(this.getFilial(mapParams), this.getRequisicao(mapParams));
            if (ParametrosGerais.getProtocoloIntegracaoHospital() != null) {
                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SIGH) {
                    IntegracaoHospitalSigh integracaoSig;
                    boolean cobranca;
                    if (ParametrosGerais.getEventoGeradorIntegracaoHospital().equalsIgnoreCase("R") && IntegracaoHospitalSigh.validaExportacaoRequisicaoSituacaoI(this.getFilial(mapParams), this.getRequisicao(mapParams), this.getExame(mapParams), this.getMaterial(mapParams)) && !(cobranca = (integracaoSig = (IntegracaoHospitalSigh)FabricaIntegracaoHospital.novaIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), ParametrosLocais.getParametro("xmlHospital"))).getCobrancaContaPaciente(this.getFilial(mapParams), this.getConvenio(mapParams)))) {
                        IntegracaoHospitalSigh.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), this.getFilial(mapParams), "I", "filial", this.getFilial(mapParams), "codReq", this.getRequisicao(mapParams), "codExa", this.getExame(mapParams), "codMat", String.valueOf(this.getMaterial(mapParams)));
                    }
                    if (integracaoHospital != null) {
                        IntegracaoHospitalSigh.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), this.getFilial(mapParams), "O", "filial", this.getFilial(mapParams), "codReq", this.getRequisicao(mapParams), "codExa", this.getExame(mapParams), "codMat", String.valueOf(this.getMaterial(mapParams)));
                    }
                }
                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.MV && !Funcoes.textoVazio(integracaoHospital)) {
                    AbstractIntegracaoHospital.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), Variaveis.filialPadrao, "R", "filial", this.getFilial(mapParams), "codReq", this.getRequisicao(mapParams), "codExa", this.getExame(mapParams), "codMat", String.valueOf(this.getMaterial(mapParams)));
                }
                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.TASY && !Funcoes.textoVazio(integracaoHospital)) {
                    AbstractIntegracaoHospital.insereIntegracaoHospital(ParametrosGerais.getProtocoloIntegracaoHospital(), Variaveis.filialPadrao, "R", "filial", this.getFilial(mapParams), "codReq", this.getRequisicao(mapParams), "codExa", this.getExame(mapParams), "codMat", String.valueOf(this.getMaterial(mapParams)));
                }
                if (ParametrosGerais.getProtocoloIntegracaoHospital() == ProtocoloIntegracaoHospital.SALUX && !Funcoes.textoVazio(integracaoHospital)) {
                    String codMaterial;
                    String codExame;
                    Integer sequencialExame;
                    SaluxService service = new SaluxService();
                    String codFilial = this.getFilial(mapParams);
                    String codRequisicao = this.getRequisicao(mapParams);
                    String idSolicitacao = service.getIdSolicitacaoSalux(codFilial, codRequisicao);
                    if (service.convenioIntegradoSalux(codFilial, this.getConvenio(mapParams)) && !Funcoes.textoVazio(idSolicitacao) && mapParams.get("situacao").toString().equals("C") && (sequencialExame = service.getSequencialExame(codFilial, codRequisicao, codExame = this.getExame(mapParams), String.valueOf(codMaterial = String.valueOf(this.getMaterial(mapParams))))) > 0) {
                        String tipoOperacao = service.resultadoRetificado(codFilial, codRequisicao, codExame, String.valueOf(codMaterial)) ? "A" : "L";
                        service.insereIntegracaoHospitalResultado(codFilial, tipoOperacao, codRequisicao, codExame, String.valueOf(codMaterial), idSolicitacao, String.valueOf(sequencialExame));
                    }
                }
            }
            if (mapParams.containsKey("iSGerarOperadoraSaude") && Boolean.parseBoolean(mapParams.get("iSGerarOperadoraSaude").toString()) && !Funcoes.textoVazio(tipoIntegracaoOperadoraConvenio = new ConvenioService().getTipoIntegracaoOperadoraSaude(this.getFilial(mapParams), this.getConvenio(mapParams)))) {
                if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("U")) {
                    IntegracaoOperadoraUpy.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.getFilial(mapParams), this.getConvenio(mapParams), this.getRequisicao(mapParams), this.getPaciente(mapParams), this.getExame(mapParams), this.getMaterial(mapParams), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"codreq", this.getRequisicao(mapParams), "codexa", this.getExame(mapParams), "codmat", String.valueOf(this.getMaterial(mapParams))});
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("V")) {
                    IntegracaoOperadoraUnimedVTRP.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.getFilial(mapParams), this.getConvenio(mapParams), this.getRequisicao(mapParams), this.getPaciente(mapParams), this.getExame(mapParams), this.getMaterial(mapParams), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"codreq", this.getRequisicao(mapParams), "codexa", this.getExame(mapParams), "codmat", String.valueOf(this.getMaterial(mapParams))});
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("M")) {
                    IntegracaoOperadoraMKSaude.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.getFilial(mapParams), this.getConvenio(mapParams), this.getRequisicao(mapParams), this.getPaciente(mapParams), this.getExame(mapParams), this.getMaterial(mapParams), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_LAUDO.toString(), new String[]{"codreq", this.getRequisicao(mapParams), "codexa", this.getExame(mapParams), "codmat", String.valueOf(this.getMaterial(mapParams))});
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("S")) {
                    ValeDosSinosDTO valeDosSinosDTO = new ValeDosSinosDTO(this.getFilial(mapParams), this.getConvenio(mapParams), this.getRequisicao(mapParams), this.getPaciente(mapParams), this.getExame(mapParams), this.getMaterial(mapParams));
                    IntegracaoOperadoraUnimedValeSinos.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), valeDosSinosDTO, AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_LAUDO.toString(), new String[]{"codreq", this.getRequisicao(mapParams), "codexa", this.getExame(mapParams), "codmat", String.valueOf(this.getMaterial(mapParams))});
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals("P")) {
                    IPMSaudeService ipmSaudeService = new IPMSaudeService();
                    Registro dadosReq = ipmSaudeService.getInformacaoRequisicao(this.getFilial(mapParams), this.getConvenio(mapParams));
                    if (!(Funcoes.objectIsNull(dadosReq) || Funcoes.textoVazio(dadosReq.getString("req_codigoipm")) || Funcoes.textoVazio(dadosReq.getString("exr_codigoipm")))) {
                        IntegracaoOperadoraIPMSaude.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.getFilial(mapParams), this.getConvenio(mapParams), this.getRequisicao(mapParams), this.getPaciente(mapParams), this.getExame(mapParams), this.getMaterial(mapParams), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", this.getFilial(mapParams), "codreq", this.getRequisicao(mapParams), "codexa", this.getExame(mapParams), "codmat", this.getMaterial(mapParams), "codGuia", dadosReq.getString("req_guia")});
                    }
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SIMUS.getCodigo())) {
                    IntegracaoOperadoraSimus.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.getFilial(mapParams), this.getConvenio(mapParams), this.getRequisicao(mapParams), this.getPaciente(mapParams), this.getExame(mapParams), this.getMaterial(mapParams), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"filial", this.getFilial(mapParams), "codreq", this.getRequisicao(mapParams), "codexa", this.getExame(mapParams), "codmat", this.getMaterial(mapParams)});
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDPR.getCodigo())) {
                    IntegracaoOperadoraPR.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.getFilial(mapParams), this.getConvenio(mapParams), this.getRequisicao(mapParams), this.getPaciente(mapParams), this.getExame(mapParams), this.getMaterial(mapParams), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"codreq", this.getRequisicao(mapParams), "codexa", this.getExame(mapParams), "codmat", String.valueOf(this.getMaterial(mapParams))});
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.UNIMEDGUAXUPE.getCodigo())) {
                    IntegracaoOperadoraGuaxupe.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.getFilial(mapParams), this.getConvenio(mapParams), this.getRequisicao(mapParams), this.getPaciente(mapParams), this.getExame(mapParams), this.getMaterial(mapParams), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), new String[]{"codreq", this.getRequisicao(mapParams), "codexa", this.getExame(mapParams), "codmat", String.valueOf(this.getMaterial(mapParams))});
                } else if (FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio).getCodigo().equals(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.SLINE.getCodigo())) {
                    SLineVO vo = new SLineVO.SlineVoBuilder().filial(this.getFilial(mapParams)).requisicao(this.getRequisicao(mapParams)).convenio(this.getConvenio(mapParams)).paciente(this.getPaciente(mapParams)).exame(this.getExame(mapParams)).material(this.getMaterial(mapParams)).build();
                    new SLineService().inserirIntegracaoOperadora(vo);
                } else {
                    AbstractIntegracaoOperadora.insereIntegracaoOperadora(FabricaIntegracaoOperadora.ProtocoloIntegracaoOperadora.getProtocoloCodigo(tipoIntegracaoOperadoraConvenio), this.getFilial(mapParams), this.getConvenio(mapParams), AbstractIntegracaoOperadora.TipoOperacaoIntegracaoOperadora.ENVIO_RESULTADO.toString(), "filial", this.getFilial(mapParams), "codreq", this.getRequisicao(mapParams), "codexa", this.getExame(mapParams), "codmat", String.valueOf(this.getMaterial(mapParams)));
                }
            }
        }
        Variaveis.exportandoInterface = false;
    }

    private boolean verificaSeJaPossuiLog(HashMap<Object, Object> mapParams) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from exportapdf where fil_codigo = " + this.getFilial(mapParams));
        sql.append(" and req_codigo = " + this.getRequisicao(mapParams));
        sql.append(" and exa_codigo = '" + this.getExame(mapParams)).append("'");
        sql.append(" and mco_codigo = " + this.getMaterial(mapParams));
        sql.append(" and rec_codigo = " + this.getRecipiente(mapParams));
        return Conexao.getStatement().executeQuery(sql.toString()).next();
    }

    private String getConvenio(HashMap<Object, Object> mapParams) {
        return mapParams.get("con_codigo").toString();
    }

    private String getResultado(HashMap<Object, Object> mapParams) {
        return mapParams.get("resultado").toString();
    }

    private String getMetodologia(HashMap<Object, Object> mapParams) {
        return mapParams.get("met_codigo").toString();
    }

    private String getIdade(HashMap<Object, Object> mapParams) {
        return mapParams.get("req_idade").toString();
    }

    private String getLayout(HashMap<Object, Object> mapParams) {
        return mapParams.get("lay_codigo").toString();
    }

    private String getInterface(HashMap<Object, Object> mapParams) {
        return mapParams.get("int_codigo").toString();
    }

    private String getRecipiente(HashMap<Object, Object> mapParams) {
        return mapParams.get("rec_codigo").toString();
    }

    private String getUsuario(HashMap<Object, Object> mapParams) {
        return mapParams.get("usr_codigo") != null ? mapParams.get("usr_codigo").toString() : Variaveis.login;
    }

    private String getAnoMes(HashMap<Object, Object> mapParams) {
        return mapParams.get("req_anomes").toString();
    }

    private String getBaseWeb(HashMap<Object, Object> mapParams) {
        return mapParams.get("baseWeb") != null ? mapParams.get("baseWeb").toString() : "";
    }

    private String getMaterial(HashMap<Object, Object> mapParams) {
        return mapParams.get("mco_codigo").toString();
    }

    private String getPaciente(HashMap<Object, Object> mapParams) {
        return mapParams.get("pac_codigo").toString();
    }

    private String getExame(HashMap<Object, Object> mapParams) {
        return mapParams.get("exa_codigo").toString();
    }

    private String getRequisicao(HashMap<Object, Object> mapParams) {
        return mapParams.get("req_codigo").toString();
    }

    private String getFilial(HashMap<Object, Object> mapParams) {
        return mapParams.get("fil_codigo").toString();
    }

    public static void addLog(HashMap<Object, Object> log) {
        if (log != null) {
            logsInterface.add(log);
        }
    }
}

