/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.thread;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.thread.BeanExportaValidadosInterfaceWeb;
import jalis.laboratorio.exportacao.thread.ThreadInterfaceExportacaoWebIntegracao;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.resultados.EditarResultado;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JFrame;

public class ThreadInterfaceExportacao
extends Thread {
    private static final int QTDE_LOGS_LIMPAR_MEMORIA = 120;
    private static ConcurrentLinkedQueue<BeanExportaValidadosInterfaceWeb> logs = new ConcurrentLinkedQueue();
    private int qtdeExportada = 0;
    private static int qtdeSendoExportada = 0;
    private static Set<Object[]> examesNaoExportados = new HashSet<Object[]>();
    public static boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static int maxTentativas;
    private static int qtTentativas;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.setName("Thread Interface Exporta\u00e7\u00e3o, Classe - > ThreadInterfaceExportacao");
        while (true) {
            ConcurrentLinkedQueue<BeanExportaValidadosInterfaceWeb> concurrentLinkedQueue = logs;
            synchronized (concurrentLinkedQueue) {
                Iterator<BeanExportaValidadosInterfaceWeb> i = logs.iterator();
                int n = qtTentativas = logs.size() > 0 ? maxTentativas : qtTentativas - 1;
                while (i.hasNext()) {
                    Variaveis.exportandoInterface = true;
                    try {
                        ++qtdeSendoExportada;
                        BeanExportaValidadosInterfaceWeb editarResultadoBean = i.next();
                        EditarResultado editarResultado = new EditarResultado(editarResultadoBean.parent, Conexao.getStatement(), editarResultadoBean.fil_codigo, editarResultadoBean.int_codigo, editarResultadoBean.isValidarExportados, editarResultadoBean.req_codigo, editarResultadoBean.exa_codigo, editarResultadoBean.mco_codigo, editarResultadoBean.rec_codigo, editarResultadoBean.pac_nome, editarResultadoBean.pac_sexo, editarResultadoBean.usr_codigo, editarResultadoBean.equipamento, editarResultadoBean.permiteSalvar, editarResultadoBean.exportando, editarResultadoBean.metCodigo, true, editarResultadoBean.codigo_paciente);
                        editarResultado.acaoSalvarEExportarPerfomance();
                        if (!Funcoes.textoVazio(editarResultado.getRetornoExportacao()) && editarResultadoBean.exame != null) {
                            examesNaoExportados.add(editarResultadoBean.exame);
                        }
                        i.remove();
                        editarResultado.dispose();
                        Laboratorio.getInstancia().removeDisposeListener(editarResultado);
                        if (++this.qtdeExportada >= 120) {
                            System.gc();
                            this.qtdeExportada = 0;
                            Thread.sleep(50L);
                        }
                        Variaveis.exportandoInterface = false;
                    }
                    catch (Exception e) {
                        try {
                            Conexao.anulaSQL();
                            ThreadInterfaceExportacaoWebIntegracao.stopThread();
                            ThreadInterfaceExportacao.stopThread();
                            e.printStackTrace();
                            ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel processamento da thread ThreadInterfaceExportacao ", e.getStackTrace());
                            break;
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (qtTentativas == 0) {
                    ThreadInterfaceExportacao.stopThread();
                    break;
                }
            }
        }
    }

    private void addLog(BeanExportaValidadosInterfaceWeb log) {
        if (log != null) {
            logs.add(log);
        }
    }

    public void addLog(JFrame parent, String fil_codigo, String int_codigo, boolean isValidarExportados, String req_codigo, String exa_codigo, String mco_codigo, String rec_codigo, String pac_nome, String pac_sexo, String usr_codigo, AbstractInterfaceamento equipamento, boolean permiteSalvar, boolean exportando, String metCodigo, Object[] exame, String codigo_paciente) {
        this.addLog(new BeanExportaValidadosInterfaceWeb(parent, fil_codigo, int_codigo, isValidarExportados, req_codigo, exa_codigo, mco_codigo, rec_codigo, pac_nome, pac_sexo, usr_codigo, equipamento, permiteSalvar, exportando, metCodigo, exame, codigo_paciente));
    }

    public boolean exportando() {
        return logs.isEmpty();
    }

    public static boolean exportandoLogs() {
        return logs.isEmpty();
    }

    public int getQuantidadeExportacao() {
        return logs.size();
    }

    public static int getQuantidadeLogs() {
        return logs.size();
    }

    public static void stopThread() {
        logs.clear();
        qtdeSendoExportada = 0;
        examesNaoExportados.clear();
    }

    public static int getQtdeSendoExportada() {
        return qtdeSendoExportada;
    }

    public static Set<Object[]> getExamesNaoExportados() {
        return examesNaoExportados;
    }

    public void recuperacaoAutomaticaInterface() {
        new Thread("Recupera\u00e7\u00e3o autom\u00e1tica exporta\u00e7\u00e3o interface"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (Variaveis.equipamentos != null && !Variaveis.equipamentos.isEmpty()) {
                    Statement st = Conexao.getStatement();
                    try {
                        boolean exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
                        StringBuilder query = new StringBuilder();
                        query.append("select a.usr_codigo,a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, ");
                        query.append("a.ier_situacao, a.ier_xmlvalores, b.req_anomes, b.req_idade, ");
                        query.append("c.pac_nome, c.pac_codigo, c.pac_sexo, d.mco_abreviatura, a.ier_rackpos, ");
                        query.append("(b.req_urgente or (coalesce(e.exr_urgente, false))) as req_urgente, ");
                        query.append("a.int_codigo, f.met_codigo,");
                        if (exr_codigoapoiado) {
                            query.append("  ( case when (erc.ere_codigoapoiado is not null) then cast(erc.ere_codigoapoiado as varchar) else cast(e.exr_codigoapoiado as varchar) end) as exr_codigoapoiado,  ");
                        }
                        query.append(" pegaAlternativoExameInterface(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as emi_alternativo, ");
                        query.append(" pegaDataEntregaExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo) as exr_dataentregaprev ");
                        if (ParametrosGerais.isAgruparGuiasInterface()) {
                            query.append(", pegaCodigoMultiguiaMae(a.fil_codigo, a.req_codigo) as multiguia ");
                        }
                        query.append(", (SELECT  ARRAY (select rec_kodigo from interfaceexamerequisicaodesm");
                        query.append(" where fil_codigo = a.fil_codigo and req_codigo = a.req_codigo and rec_codigo = a.rec_codigo and exa_codigo = a.exa_codigo and mco_codigo = a.mco_codigo and int_codigo = a.int_codigo)) as tubosFilhos ");
                        query.append("from interfaceexamerequisicao a ");
                        query.append("join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
                        query.append("join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
                        query.append("join examerequisicao e on a.fil_codigo=e.fil_codigo and a.req_codigo=e.req_codigo and a.exa_codigo=e.exa_codigo and a.mco_codigo=e.mco_codigo ");
                        if (exr_codigoapoiado) {
                            query.append(" left join examerequisicaorecipiente erc on erc.fil_codigo = b.fil_codigo and erc.req_codigo = b.req_codigo and erc.rec_kodigo = a.rec_codigo and erc.exa_codigo = a.exa_codigo and erc.mco_codigo = a.mco_codigo ");
                        }
                        query.append("left join examematinterface f on a.fil_codigo=f.fil_codigo and a.exa_codigo=f.exa_codigo and a.mco_codigo=f.mco_codigo and a.int_codigo=f.int_codigo ");
                        query.append("join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
                        query.append("where ").append(BDUtil.montaSQLEquipamentoFilial());
                        query.append("  and a.ier_situacao = ").append(11);
                        try (ResultSet resultSet = null;){
                            resultSet = st.executeQuery(query.toString());
                            if (resultSet.next()) {
                                do {
                                    BeanExportaValidadosInterfaceWeb log = new BeanExportaValidadosInterfaceWeb(null, resultSet.getString("fil_codigo"), resultSet.getString("int_codigo"), false, resultSet.getString("req_codigo"), resultSet.getString("exa_codigo"), resultSet.getString("mco_codigo"), resultSet.getString("rec_codigo"), resultSet.getString("pac_nome"), resultSet.getString("pac_sexo"), resultSet.getString("usr_codigo"), null, true, false, resultSet.getString("met_codigo"), null, resultSet.getString("pac_codigo"));
                                    ThreadInterfaceExportacao.this.addLog(log);
                                    Conexao.arquivaSQL();
                                } while (resultSet.next());
                            }
                        }
                    }
                    catch (Exception e) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar resultados exportados e pendentes.", e.getStackTrace());
                    }
                    finally {
                        try {
                            st.close();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                try {
                    Thread.sleep(950L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    static {
        qtTentativas = maxTentativas = 3;
    }
}

