/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.thread;

import jalis.comum.ConexaoTemporaria;
import jalis.integracaohospitais.sistemas.AbstractIntegracaoHospital;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.ids.DadosErrosIntegracaoIds;
import jalis.laboratorio.exportacao.ids.ErrosIntegracaoIds;
import jalis.laboratorio.exportacao.thread.ObjetoIDS;
import jalis.laboratorio.resultados.IntegracaoIDSSaude;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThreadExportacaoIds
extends Thread {
    private static final int QTDE_LOGS_LIMPAR_MEMORIA = 50;
    private static ConcurrentLinkedQueue<ObjetoIDS> logs = new ConcurrentLinkedQueue();
    private boolean parar = false;
    private int qtdeExportada = 0;
    public static final boolean DEBUG = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");
    private static boolean isEnviar = true;
    private ErrosIntegracaoIds errosIntegracaoIds = null;
    private DadosErrosIntegracaoIds dadosErrosIntegracaoIds = new DadosErrosIntegracaoIds();
    private static boolean isEstacao = false;

    public ThreadExportacaoIds() {
        this.setPriority(1);
        this.setName("Thread-IDS");
        logs.addAll(this.carregarLogs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.setName("Thread Exportacao IDS");
        while (!this.parar) {
            if (!logs.isEmpty()) {
                this.debug("Qtde para enviar: " + logs.size());
            }
            if (!isEnviar && logs.isEmpty()) {
                this.aguardar(500);
                continue;
            }
            ConcurrentLinkedQueue<ObjetoIDS> concurrentLinkedQueue = logs;
            synchronized (concurrentLinkedQueue) {
                Iterator<ObjetoIDS> i = logs.iterator();
                if (i.hasNext()) {
                    this.dadosErrosIntegracaoIds = new DadosErrosIntegracaoIds();
                    this.errosIntegracaoIds.integracaoIniciada();
                    if (isEstacao) {
                        Laboratorio.setIconeIntegracaoHospital(AbstractIntegracaoHospital.ICONE_EXECUTANDO);
                        Laboratorio.setHintIntegracaoHospital("Integrando dados da operadora IDS");
                    }
                }
                while (i.hasNext()) {
                    block19: {
                        ObjetoIDS o = i.next();
                        try {
                            IntegracaoIDSSaude integracaoIDSSaude = new IntegracaoIDSSaude();
                            StringBuilder erro = integracaoIDSSaude.enviaResultadoIdsSaude(o.filial, o.codigo, o.registro);
                            this.dadosErrosIntegracaoIds.errosProcesso.addAll(integracaoIDSSaude.getDadosErrosIntegracaoIds().errosProcesso);
                            if (erro != null && erro.length() > 0) {
                                ThreadExportacaoIds.geraLogErro(null, erro);
                            }
                            i.remove();
                            if (erro != null) {
                                erro.setLength(0);
                            }
                            this.aguardar(80);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ThreadExportacaoIds.geraLogErro(e, null);
                            isEnviar = false;
                            this.errosIntegracaoIds.integracaoFinalizada();
                            if (!isEstacao) break block19;
                            Laboratorio.setIconeIntegracaoHospital(AbstractIntegracaoHospital.ICONE_PARADO);
                            Laboratorio.setHintIntegracaoHospital(null);
                        }
                    }
                    if (++this.qtdeExportada < 50) continue;
                    this.qtdeExportada = 0;
                }
                this.errosIntegracaoIds.integracaoFinalizada();
                if (isEstacao) {
                    Laboratorio.setIconeIntegracaoHospital(AbstractIntegracaoHospital.ICONE_PARADO);
                    Laboratorio.setHintIntegracaoHospital(null);
                }
                if (this.dadosErrosIntegracaoIds.haErros() && isEstacao) {
                    Laboratorio.setIconeIntegracaoHospital(AbstractIntegracaoHospital.ICONE_ERRO);
                    Laboratorio.setHintIntegracaoHospital("N\u00e3o foi poss\u00edvel integrar os dados da operadora IDS");
                }
                try {
                    ConexaoTemporaria.arquivaSQL();
                }
                catch (SQLException e) {
                    try {
                        ConexaoTemporaria.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, "Falha ao arquivar os dados da Integrea\u00e7\u00e3o com IDS", e.getStackTrace());
                }
                this.aguardar(60000);
                logs.addAll(this.carregarLogs());
            }
        }
    }

    private void aguardar(int tempo) {
        try {
            Thread.sleep(tempo);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void enviar() {
        isEnviar = true;
    }

    public static void pausarEnvio() {
        isEnviar = false;
    }

    public boolean exportando() {
        return logs.isEmpty();
    }

    public void parar() {
        this.parar = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ObjetoIDS> carregarLogs() {
        PreparedStatement pst = null;
        ResultSet rs = null;
        Statement st = null;
        ArrayList<ObjetoIDS> retorno = new ArrayList<ObjetoIDS>();
        try {
            String sql = "select ids_codigo, fil_codigo, req_codigo, exa_codigo, mco_codigo from logids where ids_exportado = false and (ids_situacao = '' or ids_situacao is null) order by ids_datahora, fil_codigo, req_codigo limit 20 ";
            pst = ConexaoTemporaria.getPreparedStatement("select ids_codigo, fil_codigo, req_codigo, exa_codigo, mco_codigo from logids where ids_exportado = false and (ids_situacao = '' or ids_situacao is null) order by ids_datahora, fil_codigo, req_codigo limit 20 ");
            st = ConexaoTemporaria.getStatement();
            rs = pst.executeQuery();
            while (rs.next()) {
                ObjetoIDS o = new ObjetoIDS();
                o.filial = rs.getInt("fil_codigo");
                o.codigo = rs.getInt("ids_codigo");
                o.registro = IntegracaoIDSSaude.carregarDados(rs.getString("fil_codigo"), rs.getString("req_codigo"), rs.getString("exa_codigo"), rs.getString("mco_codigo"));
                retorno.add(o);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ConexaoTemporaria.fecharStatement(st);
                throw throwable;
            }
            ConexaoTemporaria.fecharStatement(st);
        }
        ConexaoTemporaria.fecharStatement(st);
        return retorno;
    }

    private static void geraLogErro(Exception e, StringBuilder erro) {
        StringBuilder erroPilha = erro;
        if (e != null) {
            erroPilha = new StringBuilder();
            for (StackTraceElement st : e.getStackTrace()) {
                erroPilha.append(String.format("%s %s.%s(%s) ", st.getFileName(), st.getClassName(), st.getMethodName(), st.getLineNumber())).append("\n");
            }
        }
        try {
            StringUtil.escreverArquivoTexto(ThreadExportacaoIds.nomeArquivoErro(), erroPilha.toString());
        }
        catch (Exception e1) {
            Funcoes.mensagem(null, "N\u00e3o foi poss\u00edvel gravar o log de eventos", 1);
        }
    }

    private static String nomeArquivoErro() {
        Date dt = new Date();
        StringBuilder nome = new StringBuilder();
        nome.append(System.getProperty("user.home"));
        nome.append("/ErroIntegracaoIds_");
        nome.append(Funcoes.formataData("yyyyMMdd_HHmmss", dt));
        nome.append(".log");
        return nome.toString();
    }

    public void setInstanciaErrosIntegracaoIds(ErrosIntegracaoIds errosIntegracaoIds) {
        this.errosIntegracaoIds = errosIntegracaoIds;
    }

    public DadosErrosIntegracaoIds getDadosErrosIntegracaIds() {
        return this.dadosErrosIntegracaoIds;
    }

    public static Boolean getIsEstacao() {
        return isEstacao;
    }

    public static void setIsEstacao(Boolean isEstacao) {
        ThreadExportacaoIds.isEstacao = isEstacao;
    }

    private void debug(String mensagem) {
        if (DEBUG) {
            System.out.println(mensagem);
        }
    }
}

