/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.thread;

import jalis.comum.Conexao;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.BeanThreadExportaWebRequisicaoHtmlPdf;
import jalis.laboratorio.recepcao.util.DataColeta;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThreadExportaWebRequisicao
extends Thread {
    private static ConcurrentLinkedQueue<BeanThreadExportaWebRequisicaoHtmlPdf> logs = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.setName("Thread Exporta Web Tela de Requisicao");
        while (true) {
            ConcurrentLinkedQueue<BeanThreadExportaWebRequisicaoHtmlPdf> concurrentLinkedQueue = logs;
            synchronized (concurrentLinkedQueue) {
                Iterator<BeanThreadExportaWebRequisicaoHtmlPdf> i = logs.iterator();
                while (i.hasNext()) {
                    BeanThreadExportaWebRequisicaoHtmlPdf beanCriaPdfWeb = i.next();
                    try {
                        Statement st = Conexao.getStatement();
                        this.threadExportaWebRequisicaoHtmlPdf(st, beanCriaPdfWeb.getRequisicao(), beanCriaPdfWeb.getResultado(), beanCriaPdfWeb.getSituacao(), beanCriaPdfWeb.getAssinatura(), beanCriaPdfWeb.getNomeAssinatura(), beanCriaPdfWeb.getOperacao(), beanCriaPdfWeb.getDadosCabecalho(), beanCriaPdfWeb.getDadosExames(), beanCriaPdfWeb.getDadosMaterial(), beanCriaPdfWeb.getDataColeta(), beanCriaPdfWeb.isResultadoPdf(), beanCriaPdfWeb.getBaseWeb(), beanCriaPdfWeb.getTipoOperacao(), beanCriaPdfWeb.getFilial(), beanCriaPdfWeb.getPegaAnoIdadeThread(), beanCriaPdfWeb.getVlrIdade(), beanCriaPdfWeb.getTextCodDestinoThread(), beanCriaPdfWeb.getTextCodigoConvenioThread());
                        i.remove();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void threadExportaWebRequisicaoHtmlPdf(Statement st, String requisicao, String resultado, String situacao, String assinatura, String nomeAssinatura, String operacao, Map<String, Object> dadosCabecalho, DadosExames d, DadosMaterial m, DataColeta dc, boolean resultadoPdf, String baseWeb, String tipoOperacao, String codigoFilial, String pegaAnoIdadeThread, String vlrIdade, String textCodDestinoThread, String textCodigoConvenioThread) throws SQLException, Exception {
        String[] comandoExameRequisicao = new String[32];
        comandoExameRequisicao[0] = "codigoBase";
        comandoExameRequisicao[1] = baseWeb;
        comandoExameRequisicao[2] = "codigoRequisicao";
        comandoExameRequisicao[3] = IntegracaoUtil.formataCodigoRequisicao(codigoFilial, requisicao, st);
        comandoExameRequisicao[4] = "codigoExameRequisicao";
        comandoExameRequisicao[5] = d.getCodigo();
        comandoExameRequisicao[6] = "materialExameRequisicao";
        comandoExameRequisicao[7] = String.valueOf(m.getCodigo());
        comandoExameRequisicao[8] = "descricaoMaterialExameRequisicao";
        comandoExameRequisicao[9] = m.getDescricao();
        comandoExameRequisicao[10] = "dataColetaExameRequisicao";
        comandoExameRequisicao[11] = dc.getSituacao() != DataColeta.FALTA_MATERIAL ? dc.getData() : "";
        comandoExameRequisicao[12] = "horaColetaExameRequisicao";
        comandoExameRequisicao[13] = dc.getSituacao() != DataColeta.FALTA_MATERIAL ? dc.getHora() : "";
        comandoExameRequisicao[14] = "paginaExameRequisicao";
        comandoExameRequisicao[15] = "null";
        comandoExameRequisicao[16] = "ordemExameRequisicao";
        comandoExameRequisicao[17] = "null";
        comandoExameRequisicao[18] = "situacaoExameRequisicao";
        comandoExameRequisicao[19] = situacao != null && situacao.equals("A") ? situacao : (dc.getSituacao() == DataColeta.FALTA_MATERIAL ? "F" : (dc.getSituacao() == DataColeta.A_COLETAR ? "T" : (situacao == null ? "" : situacao)));
        comandoExameRequisicao[20] = "assinaturaExameRequisicao";
        comandoExameRequisicao[21] = assinatura;
        comandoExameRequisicao[22] = "nomeAssinaturaExameRequisicao";
        comandoExameRequisicao[23] = nomeAssinatura;
        comandoExameRequisicao[24] = "resultadoExameRequisicao";
        String rst = "";
        Map<String, Object> map = null;
        if (resultadoPdf) {
            comandoExameRequisicao[25] = "";
            comandoExameRequisicao[29] = "";
        } else {
            if (!Funcoes.textoVazio(resultado)) {
                map = ResultadosUtil.geraResultadoParaWeb(st, codigoFilial, requisicao, d.getCodigo(), String.valueOf(m.getCodigo()), resultado, false, -1, true, dadosCabecalho);
                rst = map != null && map.get("laudo") != null ? (String)map.get("laudo") : "";
            }
            comandoExameRequisicao[25] = rst;
        }
        comandoExameRequisicao[26] = "dataEnvioExameRequisicao";
        comandoExameRequisicao[27] = "current_timestamp";
        comandoExameRequisicao[28] = "resultadoTextoExameRequisicao";
        if (!resultadoPdf) {
            String resultadoTexto;
            comandoExameRequisicao[29] = resultadoTexto = ResultadosUtil.geraResultadoTextoParaWeb(st, codigoFilial, textCodigoConvenioThread, textCodDestinoThread, Integer.valueOf(vlrIdade), pegaAnoIdadeThread, d.getCodigo(), m.getCodigo(), d.getCodMetodo(), resultado);
        }
        DBUtil.insereExportaWebSoInsert(st, codigoFilial, "requisicaoexame", tipoOperacao, "", true, comandoExameRequisicao);
        Map imagens = null;
        if (!resultadoPdf) {
            String[] comandoExcluiImagens = new String[]{"codigoBase", baseWeb, "codigoRequisicao", IntegracaoUtil.formataCodigoRequisicao(codigoFilial, requisicao, st), "codigoExameRequisicao", d.getCodigo(), "materialExameRequisicao", String.valueOf(m.getCodigo())};
            DBUtil.insereExportaWebSoInsert(st, codigoFilial, "requisicaoexameimagem", "D", "", true, comandoExcluiImagens);
        }
        if (!resultadoPdf && map != null && !(imagens = (Map)map.get("imagens")).isEmpty()) {
            String[] comandoInserirImagens = new String[12];
            comandoInserirImagens[0] = "codigoBase";
            comandoInserirImagens[2] = "codigoRequisicao";
            comandoInserirImagens[4] = "codigoExameRequisicao";
            comandoInserirImagens[6] = "materialExameRequisicao";
            comandoInserirImagens[8] = "codigoImagemExame";
            comandoInserirImagens[10] = "imagemExame";
            for (Integer i : imagens.keySet()) {
                comandoInserirImagens[1] = baseWeb;
                comandoInserirImagens[3] = IntegracaoUtil.formataCodigoRequisicao(codigoFilial, requisicao, st);
                comandoInserirImagens[5] = d.getCodigo();
                comandoInserirImagens[7] = String.valueOf(m.getCodigo());
                comandoInserirImagens[9] = i.toString();
                comandoInserirImagens[11] = (String)imagens.get(i);
                DBUtil.insereExportaWebSoInsert(st, codigoFilial, "requisicaoexameimagem", "I", "", false, comandoInserirImagens);
            }
        }
    }

    public static void addLog(BeanThreadExportaWebRequisicaoHtmlPdf log) {
        logs.add(log);
    }

    public boolean exportando() {
        return logs.isEmpty();
    }

    public int getQuantidadeExportacao() {
        return logs.size();
    }

    public void parar() {
    }
}

