/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.thread;

import jalis.comum.Conexao;
import jalis.comum.ConexaoWeb;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.BeanCriaPdfWeb;
import jalis.laboratorio.exportacao.thread.ComandoLog;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.exportacao.thread.ExportaWeb2;
import jalis.model.bean.configuracao.UsuarioBean;
import jalis.service.configuracao.UsuarioService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThreadCriaPdfWeb
extends Thread {
    private static final int QTDE_LOGS_LIMPAR_MEMORIA = 50;
    private static ConcurrentLinkedQueue<BeanCriaPdfWeb> logs = new ConcurrentLinkedQueue();
    private boolean parar = false;
    private int qtdeExportada = 0;
    public static boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.setName("Thread Cria PDF Web");
        while (!this.parar) {
            ConcurrentLinkedQueue<BeanCriaPdfWeb> concurrentLinkedQueue = logs;
            synchronized (concurrentLinkedQueue) {
                Iterator<BeanCriaPdfWeb> i = logs.iterator();
                while (i.hasNext()) {
                    BeanCriaPdfWeb beanCriaPdfWeb = i.next();
                    try {
                        this.addCriaPdfThread(beanCriaPdfWeb.getFilialOrigemThread(), beanCriaPdfWeb.getTipoOperacaoThread(), beanCriaPdfWeb.getFiliaisThread(), beanCriaPdfWeb.getCodigoFilialTread(), beanCriaPdfWeb.getCodigoLogThread(), beanCriaPdfWeb.getOperacaoThread(), beanCriaPdfWeb.isGerarResultadoPDF());
                        i.remove();
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.parar = true;
                    }
                    if (++this.qtdeExportada < 50) continue;
                    System.gc();
                    this.qtdeExportada = 0;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addLog(BeanCriaPdfWeb log) {
        logs.add(log);
    }

    public boolean exportando() {
        return logs.isEmpty();
    }

    public int getQuantidadeExportacao() {
        return logs.size();
    }

    public void parar() {
        this.parar = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void addCriaPdfThread(String filialOrigemThread, String tipoOperacaoThread, String filiaisThread, String codigoFilialTread, String codigoLogThread, String operacaoThread, boolean gerarResultadoPDF) throws SQLException {
        Statement statementThread = Conexao.getStatement();
        try {
            if (ExportaWeb2.isGerarPdfResultado(statementThread, codigoFilialTread)) {
                String requisicaoXml;
                Variaveis.exportandoParaWeb = true;
                List<Object> logs = new ArrayList();
                if (Laboratorio.isNovaWeb()) {
                    if (gerarResultadoPDF) {
                        logs = ExportaWeb2.geraPdfExportaWeb2(codigoFilialTread, codigoLogThread, operacaoThread, tipoOperacaoThread);
                    }
                } else {
                    ConexaoWeb conexaoWeb = new ConexaoWeb();
                    Statement statement = conexaoWeb.getStatement();
                    logs = ExportaWeb.geraPdfExportaWeb1(statementThread, statement, operacaoThread, tipoOperacaoThread, codigoFilialTread);
                    conexaoWeb.shutdown();
                }
                for (ComandoLog comandoLog : logs) {
                    if (comandoLog == null) continue;
                    DBUtil.insereExportaWeb(statementThread, filialOrigemThread, comandoLog.getTabela(), comandoLog.getTipoOperacao(), filiaisThread, false, true, comandoLog.camposComandoLog());
                    Thread.sleep(30L);
                }
                if (!(logs == null || logs.isEmpty() || Funcoes.textoVazio(StringUtil.getValor(operacaoThread, "codigoRequisicao")) || Funcoes.textoVazio(StringUtil.getValor(operacaoThread, "materialExameRequisicao")) || Funcoes.textoVazio(StringUtil.getValor(operacaoThread, "codigoExameRequisicao")))) {
                    StringBuilder sqlRemoveLogExportacao = new StringBuilder();
                    sqlRemoveLogExportacao.append("delete from exportapdf where est_codigo = ").append(Variaveis.codigoEstacao);
                    sqlRemoveLogExportacao.append(" and fil_codigo = ").append(filialOrigemThread);
                    String string = StringUtil.getValor(operacaoThread, "codigoRequisicao");
                    if (!Funcoes.textoVazio(string) && string.length() <= ParametrosGerais.getDigitosTuboRequisicao()) {
                        sqlRemoveLogExportacao.append(" and req_codigo = ").append(StringUtil.getValor(operacaoThread, "codigoRequisicao"));
                    } else {
                        sqlRemoveLogExportacao.append(" and req_codigo = ").append(StringUtil.getValor(operacaoThread, "codigoRequisicao").substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial()));
                    }
                    sqlRemoveLogExportacao.append(" and exa_codigo = '").append(StringUtil.getValor(operacaoThread, "codigoExameRequisicao")).append("'");
                    sqlRemoveLogExportacao.append(" and mco_codigo = ").append(StringUtil.getValor(operacaoThread, "materialExameRequisicao"));
                    statementThread.execute(sqlRemoveLogExportacao.toString());
                }
                if (!Funcoes.textoVazio(operacaoThread) && !Funcoes.textoVazio(requisicaoXml = StringUtil.getValor(operacaoThread, "codigoRequisicao"))) {
                    void var11_23;
                    String string = "";
                    if (requisicaoXml.length() > ParametrosGerais.getDigitosTuboRequisicao()) {
                        String string2 = StringUtil.removeZerosEsquerda(requisicaoXml.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial()));
                    } else {
                        String string3 = requisicaoXml;
                    }
                    String codigoExame = StringUtil.getValor(operacaoThread, "codigoExameRequisicao");
                    String codigoMaterial = StringUtil.getValor(operacaoThread, "materialExameRequisicao");
                    String codigoBase = StringUtil.getValor(operacaoThread, "codigoBase");
                    if (!(Funcoes.textoVazio(filialOrigemThread) || Funcoes.textoVazio((String)var11_23) || Funcoes.textoVazio(codigoExame) || Funcoes.textoVazio(codigoMaterial) || Funcoes.textoVazio(codigoBase))) {
                        ExportaWeb2.atualizaPaginaOrdemExameWeb(null, filialOrigemThread, (String)var11_23, codigoExame, codigoMaterial, codigoBase);
                    }
                }
                Conexao.arquivaSQL();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.parar = true;
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException e1) {
                this.parar = true;
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel processar thread exporta web", e.getStackTrace());
        }
        finally {
            Variaveis.exportandoParaWeb = false;
            if (statementThread != null) {
                try {
                    statementThread.close();
                }
                catch (Exception e) {
                    this.parar = true;
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    public void gerarPdfPendentes() {
        new Thread(){

            @Override
            public void run() {
                try {
                    ResultSet resultSet = Conexao.executeQuery(Conexao.getStatement(), "select * from exportapdf where est_codigo = " + Variaveis.codigoEstacao);
                    if (resultSet.next()) {
                        do {
                            ResultSet dados;
                            if ((dados = Conexao.executeQuery(Conexao.getStatement(), "select exr_situacao,usr_codassina from examerequisicao where fil_codigo = " + resultSet.getString("fil_codigo") + " and req_codigo = " + resultSet.getString("req_codigo") + " and exa_codigo = '" + resultSet.getString("exa_codigo") + "'  and mco_codigo = " + resultSet.getString("mco_codigo"))).next()) {
                                ArrayList<String> tmp = new ArrayList<String>();
                                tmp.add("codigoRequisicao");
                                tmp.add(IntegracaoUtil.formataCodigoRequisicao(resultSet.getString("fil_codigo"), resultSet.getString("req_codigo"), Conexao.getStatement()));
                                tmp.add("codigoBase");
                                tmp.add(ExportaWeb.getCodigoBaseWeb(Conexao.getStatement(), resultSet.getString("fil_codigo")));
                                tmp.add("codigoExameRequisicao");
                                tmp.add(resultSet.getString("exa_codigo"));
                                tmp.add("materialExameRequisicao");
                                tmp.add(resultSet.getString("mco_codigo"));
                                tmp.add("dataEnvioExameRequisicao");
                                tmp.add("current_timestamp");
                                tmp.add("situacaoExameRequisicao");
                                tmp.add(dados.getString("exr_situacao"));
                                UsuarioBean usuarioEstacao = null;
                                if (!Funcoes.textoVazio(dados.getString("usr_codassina"))) {
                                    usuarioEstacao = (UsuarioBean)new UsuarioService().get(dados.getString("usr_codassina"));
                                }
                                tmp.add("nomeAssinaturaExameRequisicao");
                                if (usuarioEstacao != null && !Funcoes.textoVazio(usuarioEstacao.getNome())) {
                                    tmp.add(usuarioEstacao.getNome());
                                } else {
                                    tmp.add("");
                                }
                                tmp.add("assinaturaExameRequisicao");
                                tmp.add(dados.getString("usr_codassina"));
                                DBUtil.insereExportaWeb(resultSet.getString("fil_codigo"), Conexao.getStatement(), "requisicaoexame", "A", true, tmp.toArray(new String[tmp.size()]));
                            }
                            dados.close();
                        } while (resultSet.next());
                        resultSet.close();
                        Conexao.arquivaSQL();
                    }
                }
                catch (Exception e) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel gerar Pdfs pendentes de resultado", e.getStackTrace());
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }
}

