/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.exportacao.thread;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.BeanCriaHtmlWeb;
import jalis.laboratorio.exportacao.thread.ExportaWeb2;
import jalis.laboratorio.impressao.ImpressaoUtil;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThreadCriaHtmlWeb
extends Thread {
    private static final int QTDE_LOGS_LIMPAR_MEMORIA = 50;
    private static ConcurrentLinkedQueue<BeanCriaHtmlWeb> logs = new ConcurrentLinkedQueue();
    private boolean parar = false;
    private int qtdeExportada = 0;
    public static boolean debug = Funcoes.arquivoExiste(System.getProperty("user.home") + System.getProperty("file.separator") + "debug.jalis");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.setName("Thread Cria HTML Web");
        while (!this.parar) {
            ConcurrentLinkedQueue<BeanCriaHtmlWeb> concurrentLinkedQueue = logs;
            synchronized (concurrentLinkedQueue) {
                Iterator<BeanCriaHtmlWeb> i = logs.iterator();
                while (i.hasNext()) {
                    BeanCriaHtmlWeb beanCriaHtmlWeb = i.next();
                    try {
                        this.addCriaHtmlThread(beanCriaHtmlWeb.getFilial(), beanCriaHtmlWeb.getRequisicao(), beanCriaHtmlWeb.getCodigoExame(), beanCriaHtmlWeb.getCodigoMaterial(), beanCriaHtmlWeb.getCodigoBase());
                        i.remove();
                        if (++this.qtdeExportada >= 50 || this.qtdeExportada < 50 && logs.size() == 0) {
                            System.gc();
                            this.qtdeExportada = 0;
                            Thread.sleep(35L);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.parar = true;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void addLog(BeanCriaHtmlWeb log) {
        logs.add(log);
    }

    public boolean exportando() {
        return logs.isEmpty();
    }

    public int getQuantidadeExportacao() {
        return logs.size();
    }

    public void parar() {
        this.parar = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCriaHtmlThread(String filial, String requisicao, String codigoExame, String codigoMaterial, String codigoBase) throws SQLException {
        Statement statementThread = Conexao.getStatement();
        try {
            if (!ExportaWeb2.isGerarPdfResultado(statementThread, filial)) {
                Variaveis.exportandoParaWeb = true;
                ThreadCriaHtmlWeb.atualizaPaginaOrdemExameHtmlWeb(statementThread, filial, requisicao, codigoExame, codigoMaterial, codigoBase, true);
                if (!(Funcoes.textoVazio(codigoExame) || Funcoes.textoVazio(codigoMaterial) || Funcoes.textoVazio(filial) || Funcoes.textoVazio(requisicao))) {
                    StringBuilder sqlRemoveLogExportacao = new StringBuilder();
                    sqlRemoveLogExportacao.append("delete from exportapdf where est_codigo = ").append(Variaveis.codigoEstacao);
                    sqlRemoveLogExportacao.append(" and fil_codigo = ").append(filial);
                    sqlRemoveLogExportacao.append(" and req_codigo = ").append(requisicao);
                    sqlRemoveLogExportacao.append(" and exa_codigo = '").append(codigoExame).append("'");
                    sqlRemoveLogExportacao.append(" and mco_codigo = ").append(codigoMaterial);
                    statementThread.execute(sqlRemoveLogExportacao.toString());
                }
                Conexao.arquivaSQL();
            }
        }
        catch (Exception e) {
            this.parar = true;
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException e1) {
                this.parar = true;
            }
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel processar thread exporta web html", e.getStackTrace());
        }
        finally {
            Variaveis.exportandoParaWeb = false;
            if (statementThread != null) {
                try {
                    statementThread.close();
                }
                catch (Exception e) {
                    this.parar = true;
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
                }
            }
        }
    }

    private static void atualizaPaginaOrdemExameHtmlWeb(Statement st, String filial, String requisicao, String codigoExame, String codigoMaterial, String codigoBase, boolean insertSemVerificacaoPdf) throws Exception {
        ArrayList<Registro> exames = new ArrayList<Registro>();
        ArrayList<ArrayList> comandosMultiplasPaginas = new ArrayList<ArrayList>();
        boolean isNaoTemExame = Funcoes.textoVazio(codigoExame) || Funcoes.textoVazio(codigoMaterial);
        int contagemTotal = 0;
        int contagemProntos = 0;
        String situacaoRequisicao = "0";
        StringBuilder bufC = new StringBuilder("select count(exa_codigo) from examerequisicao ");
        bufC.append("where fil_codigo = ").append(filial);
        bufC.append("  and req_codigo = ").append(requisicao);
        bufC.append("  and not exr_excluido ");
        ResultSet rsConta = Conexao.executeQueryPerformance(st, bufC);
        if (rsConta.next()) {
            contagemTotal = rsConta.getInt(1);
        }
        bufC.setLength(0);
        bufC.append("select count(exa_codigo) from examerequisicao ");
        bufC.append("where fil_codigo = ").append(filial);
        bufC.append("  and req_codigo = ").append(requisicao);
        bufC.append("  and not exr_excluido ");
        bufC.append("  and exr_situacao in ('").append("I").append("', ");
        bufC.append("  \t\t\t\t\t\t\t\t     '").append("E").append("', ");
        bufC.append("  \t\t\t\t\t\t\t\t     '").append("A").append("' ");
        bufC.append("  \t\t\t\t\t\t\t\t     , '").append("C").append("' ");
        if (!ParametrosGerais.getConferencia()) {
            bufC.append("  \t\t\t\t\t\t\t\t     , '").append("L").append("' ");
        }
        bufC.append("  \t\t\t\t\t\t\t\t     )");
        rsConta = Conexao.executeQueryPerformance(st, bufC);
        if (rsConta.next()) {
            contagemProntos = rsConta.getInt(1);
        }
        if (contagemProntos > 0 && contagemProntos != contagemTotal) {
            situacaoRequisicao = "2";
        } else if (contagemProntos == contagemTotal) {
            situacaoRequisicao = "1";
        }
        StringBuilder bui = new StringBuilder("select b.exa_codigo, b.exa_descricao, b.exa_salvaparcial, a.exr_situacao, pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, ");
        bui.append("a.exr_datadigita, a.exr_dataassina, a.exr_dataimpresso, a.exr_datamaterial, a.exr_vlrexame, a.exr_vlrmaterial, a.exr_descricaomaterial, a.exr_naofaturar, ");
        bui.append("a.usr_coddigitador, a.usr_codassina, a.usr_codimpressao, usr.usr_nome, ");
        bui.append("c.mco_codigo, c.mco_descricao, c.mco_abreviatura, d.prz_codigo, d.emc_solicitarjejum, d.emc_pagina, ");
        bui.append(" d.emc_ordem, (a.exr_datafatura is not null) as faturado ");
        if (ParametrosGerais.getOrdenarSetor()) {
            bui.append(", e.set_codigo ");
        } else {
            bui.append(", 1 as set_codigo");
        }
        bui.append(" from examerequisicao a left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        bui.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
        bui.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
        bui.append("left join usuario usr on a.usr_codassina = usr.usr_codigo ");
        if (ParametrosGerais.getOrdenarSetor()) {
            bui.append("left join examesetor e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo ");
        }
        bui.append("where a.fil_codigo = ");
        bui.append(filial);
        bui.append(" and a.req_codigo = ");
        bui.append(requisicao);
        bui.append(" and a.exr_excluido = false ");
        if (ParametrosGerais.getOrdenarSetor()) {
            bui.append(" and e.ese_default = true");
        }
        bui.append(" order by ");
        if (ParametrosGerais.getOrdenarSetor()) {
            bui.append("e.set_codigo, ");
        }
        bui.append("d.emc_pagina, d.emc_ordem, a.exa_codigo, a.mco_codigo ");
        ResultSet rs = Conexao.executeQueryPerformance(st, bui.toString());
        Map<String, Object> dadosCabecalho = ExameUtil.getDadosCabecalhoRequisicao(Conexao.getStatement(), Conexao.getStatement(), filial, requisicao, false, false, null);
        int qtdeExames = 0;
        while (rs.next()) {
            ++qtdeExames;
        }
        if (rs.first()) {
            do {
                exames.add(new Registro(rs));
            } while (rs.next());
        }
        ArrayList list = new ArrayList(exames);
        Collections.sort(list, new Comparator<Registro>(){

            @Override
            public int compare(Registro a, Registro b) {
                int j;
                boolean setor = !ParametrosGerais.getOrdenarSetor() || ParametrosGerais.getOrdenarSetor() && a.getInt("set_codigo") == b.getInt("set_codigo");
                int i = a.getInt("emc_pagina");
                if (i < (j = b.getInt("emc_pagina")) && setor) {
                    return -1;
                }
                if (i > j && setor) {
                    return 1;
                }
                if (ParametrosGerais.getOrdenarSetor()) {
                    if (a.getInt("set_codigo") < b.getInt("set_codigo")) {
                        return -1;
                    }
                    if (a.getInt("set_codigo") > b.getInt("set_codigo")) {
                        return 1;
                    }
                    return 0;
                }
                i = a.getInt("emc_ordem");
                if (i < (j = b.getInt("emc_ordem"))) {
                    return -1;
                }
                if (i > j) {
                    return 1;
                }
                return 0;
            }
        });
        bui.delete(0, bui.length());
        bui.append("select a.des_codigo, ");
        bui.append("b.pac_codigo, b.pac_nome, b.pac_datanasc, b.pac_sexo, ");
        bui.append("c.med_conselho, c.med_crm, c.med_nome, ");
        bui.append("d.con_codigo, d.con_razao, a.req_anomes, a.req_idade ");
        bui.append("from requisicao a left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
        bui.append("left join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and upper(a.med_uf) = upper(c.med_uf) ");
        bui.append("left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
        bui.append("where a.req_codigo = ");
        bui.append(requisicao);
        bui.append(" and a.fil_codigo = ");
        bui.append(filial);
        bui.append(" and a.req_excluida = false ");
        rs = Conexao.executeQueryPerformance(st, bui.toString());
        if (rs.next()) {
            Registro dadosRequisicao = new Registro(rs);
            String codigoLayout = ExameUtil.getCodigoLayout(filial, rs.getString("con_codigo"), rs.getString("des_codigo"));
            String cabecalho = ThreadCriaHtmlWeb.getCabecalhoRodape(st, filial, codigoLayout);
            int distanciaExames = ImpressaoUtil.distanciaEntreExames(cabecalho);
            int alturaRodapeExame = StringUtil.getInt(cabecalho, "alturaRodapeExame");
            boolean exibirRodapeExame = StringUtil.getBoolean(cabecalho, "exibirRodapeExame");
            ArrayList exms = new ArrayList();
            ArrayList exmesPagina = new ArrayList();
            ArrayList imagens = new ArrayList();
            ArrayList apagarImagens = new ArrayList();
            int alturaUtil = ImpressaoUtil.alturaUtilPagina(cabecalho);
            int pagina = 0;
            int ultimaPagina = 0;
            int webPagina = 0;
            int webOrdem = 1;
            int alturaLivre = alturaUtil;
            int ultimoSetor = -1;
            for (Registro registro : list) {
                if (registro.nulo("exr_datadigita") || registro.getString("exr_situacao").equals("P")) continue;
                boolean apenasFaturamento = registro.getString("exr_situacao").equals("A");
                int setor = registro.getInt("set_codigo");
                if (ultimoSetor == -1) {
                    ultimoSetor = setor;
                }
                ArrayList<String> tmp = new ArrayList<String>();
                ArrayList<String> tmpPagina = new ArrayList<String>();
                tmp.add("codigoRequisicao");
                tmp.add(IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st));
                tmp.add("codigoBase");
                tmp.add(codigoBase);
                tmp.add("codigoExameRequisicao");
                tmp.add(registro.getString("exa_codigo"));
                tmp.add("materialExameRequisicao");
                tmp.add(registro.getString("mco_codigo"));
                tmp.add("situacaoExameRequisicao");
                tmp.add(registro.getString("exr_situacao"));
                tmpPagina.add("codigoBase");
                tmpPagina.add(codigoBase);
                tmpPagina.add("codigoRequisicao");
                tmpPagina.add(IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st));
                tmpPagina.add("codigoExameRequisicaoResultadoPagina");
                tmpPagina.add(registro.getString("exa_codigo"));
                tmpPagina.add("codigoMaterialExameRequisicaoResultadoPagina");
                tmpPagina.add(registro.getString("mco_codigo"));
                boolean isVariasPaginas = false;
                if (!apenasFaturamento) {
                    pagina = registro.getInt("emc_pagina");
                    String resultado = registro.getString("exr_resultado");
                    String versaoXML = StringUtil.getValor(resultado, "versao");
                    boolean reposicionarComponentesPorPagina = versaoXML.equals("1.0") || StringUtil.getValor(resultado, "reposicionarComponentes").trim().length() == 0 ? true : StringUtil.getBoolean(resultado, "reposicionarComponentes");
                    String[] resultadosPorPagina = new String[]{resultado};
                    int qtdePaginasResultado = ImpressaoUtil.contaPaginasResultado(resultado);
                    boolean bl = isVariasPaginas = qtdePaginasResultado > 1;
                    if (qtdePaginasResultado > 1) {
                        resultadosPorPagina = new String[qtdePaginasResultado];
                        for (int p = 1; p <= qtdePaginasResultado; ++p) {
                            resultadosPorPagina[p - 1] = ImpressaoUtil.removerComponentesOutraPagina(resultado, p);
                        }
                    }
                    String[] removerPaginas = new String[12];
                    removerPaginas[0] = "codigoRequisicao";
                    removerPaginas[1] = IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st);
                    removerPaginas[2] = "codigoBase";
                    removerPaginas[3] = codigoBase;
                    removerPaginas[4] = "codigoExameRequisicao";
                    removerPaginas[5] = registro.getString("exa_codigo");
                    removerPaginas[6] = "materialExameRequisicao";
                    removerPaginas[7] = registro.getString("mco_codigo");
                    removerPaginas[8] = "contadorPaginaExameRequisicao";
                    removerPaginas[9] = "> 0";
                    if (insertSemVerificacaoPdf) {
                        DBUtil.insereExportaWebSoInsert(st, Variaveis.filialPadrao, "requisicaoexame", "D", "", false, removerPaginas);
                    } else {
                        DBUtil.insereExportaWeb(filial, st, "requisicaoexame", "D", false, removerPaginas);
                    }
                    int contadorPaginaExame = 0;
                    for (int i = 0; i < qtdePaginasResultado; ++i) {
                        Map<String, Object> map;
                        ResultSet rs2;
                        StringBuilder buf;
                        ArrayList<String> tmp2Pagina;
                        ArrayList tmp2;
                        String resultadoPorPagina = resultadosPorPagina[i];
                        int alturaResultado = ImpressaoUtil.alturaResultado(resultadoPorPagina) + (exibirRodapeExame ? alturaRodapeExame : 0);
                        if (pagina == -1 || pagina != ultimaPagina || alturaResultado > alturaLivre || setor != ultimoSetor) {
                            ++webPagina;
                            webOrdem = 1;
                            ultimoSetor = setor;
                            if (qtdePaginasResultado > 1) {
                                Map<String, Object> map2;
                                tmp2 = (ArrayList)tmp.clone();
                                tmp2Pagina = new ArrayList<String>();
                                tmp2.add("paginaExameRequisicao");
                                tmp2.add(apenasFaturamento ? "-1" : String.valueOf(webPagina));
                                tmp2.add("ordemExameRequisicao");
                                tmp2.add(apenasFaturamento ? "-1" : String.valueOf(webOrdem));
                                tmp2.add("contadorPaginaExameRequisicao");
                                tmp2.add(String.valueOf(i));
                                buf = new StringBuilder("select b.mco_descricao, a.exr_datamaterial, a.exr_situacao, a.exr_dataassina, a.usr_codassina, c.usr_nome ");
                                buf.append("from examerequisicao a ");
                                buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
                                buf.append("left join usuario c on a.usr_codassina = c.usr_codigo ");
                                buf.append(" where a.fil_codigo = ").append(filial);
                                buf.append(" and a.req_codigo = ").append(requisicao);
                                buf.append(" and a.exa_codigo = '").append(StringUtil.textoDB(registro.getString("exa_codigo"))).append("' ");
                                buf.append(" and a.mco_codigo = ").append(registro.getString("mco_codigo"));
                                rs2 = Conexao.executeQueryPerformance(st, buf);
                                if (rs2.next()) {
                                    tmp2.add("descricaoMaterialExameRequisicao");
                                    tmp2.add(rs2.getString("mco_descricao"));
                                    tmp2.add("dataColetaExameRequisicao");
                                    tmp2.add(!DBUtil.campoNull(rs2.getString("exr_datamaterial")) ? Funcoes.formataData("dd/MM/yyyy", rs2.getDate("exr_datamaterial")) : "");
                                    tmp2.add("horaColetaExameRequisicao");
                                    tmp2.add(!DBUtil.campoNull(rs2.getString("exr_datamaterial")) ? Funcoes.formataHora(rs2.getDate("exr_datamaterial"), false) : "");
                                    tmp2.add("situacaoExameRequisicao");
                                    tmp2.add(rs2.getString("exr_situacao"));
                                    tmp2.add("assinaturaExameRequisicao");
                                    tmp2.add(!DBUtil.campoNull(rs2.getString("exr_dataassina")) ? rs2.getString("usr_codassina") : "");
                                    tmp2.add("nomeAssinaturaExameRequisicao");
                                    tmp2.add(!DBUtil.campoNull(rs2.getString("exr_dataassina")) ? rs2.getString("usr_nome") : "");
                                    tmp2.add("dataEnvioExameRequisicao");
                                    tmp2.add("current_timestamp");
                                    tmp2.add("codigoUsuarioConferenciaExameRequisicao");
                                    tmp2.add(!DBUtil.campoNull(rs2.getString("exr_dataassina")) ? rs2.getString("usr_codassina") : "");
                                    tmp2Pagina.add("codigoBase");
                                    tmp2Pagina.add(codigoBase);
                                    tmp2Pagina.add("codigoRequisicao");
                                    tmp2Pagina.add(IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st));
                                    tmp2Pagina.add("codigoExameRequisicaoResultadoPagina");
                                    tmp2Pagina.add(registro.getString("exa_codigo"));
                                    tmp2Pagina.add("codigoMaterialExameRequisicaoResultadoPagina");
                                    tmp2Pagina.add(registro.getString("mco_codigo"));
                                    tmp2Pagina.add("contadorPaginaRequisicaoExameResultadoPagina");
                                    tmp2Pagina.add("" + String.valueOf(i));
                                }
                                exmesPagina.add(tmp2Pagina);
                                if ((isNaoTemExame || registro.getString("exa_codigo").equalsIgnoreCase(codigoExame) && registro.getString("mco_codigo").equalsIgnoreCase(codigoMaterial)) && (map2 = ResultadosUtil.geraResultadoParaWeb(st, filial, requisicao, registro.getString("exa_codigo"), registro.getString("mco_codigo"), resultadoPorPagina, false, contadorPaginaExame, i + 1 == qtdePaginasResultado, dadosCabecalho)) != null) {
                                    tmp2Pagina.add("resultadoHtmlRequisicaoExameResultadoPagina");
                                    tmp2Pagina.add(map2.get("laudo").toString());
                                    if (map2.get("imagens") != null) {
                                        contadorPaginaExame = ((Map)map2.get("imagens")).size();
                                    }
                                    tmp2.add("resultadoExameRequisicao");
                                    tmp2.add(map2.get("laudo").toString());
                                    tmp2.add("resultadoTextoExameRequisicao");
                                    tmp2.add(ResultadosUtil.geraResultadoTextoParaWeb(st, filial, dadosRequisicao.getString("con_codigo"), dadosRequisicao.getString("des_codigo"), dadosRequisicao.getInt("req_idade"), dadosRequisicao.getString("req_anomes"), registro.getString("exa_codigo"), registro.getInt("mco_codigo"), registro.getString("met_codigo"), resultadoPorPagina));
                                    if (map2.get("imagens") != null) {
                                        Map tmpImagens = null;
                                        ArrayList<String> comandosImagem = new ArrayList<String>();
                                        comandosImagem.add("codigoBase");
                                        comandosImagem.add(codigoBase);
                                        comandosImagem.add("codigoRequisicao");
                                        comandosImagem.add(IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st));
                                        comandosImagem.add("codigoExameRequisicao");
                                        comandosImagem.add(registro.getString("exa_codigo"));
                                        comandosImagem.add("materialExameRequisicao");
                                        comandosImagem.add(registro.getString("mco_codigo"));
                                        apagarImagens.add(comandosImagem);
                                        Map map3 = tmpImagens = map2 != null ? (Map)map2.get("imagens") : null;
                                        if (tmpImagens != null && !tmpImagens.isEmpty()) {
                                            for (Integer idImagem : tmpImagens.keySet()) {
                                                comandosImagem.clear();
                                                comandosImagem.add("codigoBase");
                                                comandosImagem.add(codigoBase);
                                                comandosImagem.add("codigoRequisicao");
                                                comandosImagem.add(IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st));
                                                comandosImagem.add("codigoExameRequisicao");
                                                comandosImagem.add(registro.getString("exa_codigo"));
                                                comandosImagem.add("materialExameRequisicao");
                                                comandosImagem.add(registro.getString("mco_codigo"));
                                                comandosImagem.add("codigoImagemExame");
                                                comandosImagem.add(idImagem.toString());
                                                comandosImagem.add("imagemExame");
                                                comandosImagem.add((String)tmpImagens.get(idImagem));
                                                imagens.add(comandosImagem);
                                            }
                                        }
                                    }
                                }
                                if (i == qtdePaginasResultado - 1) {
                                    exms.add(tmp2);
                                    exmesPagina.add(tmp2Pagina);
                                }
                                comandosMultiplasPaginas.add(tmp2);
                            } else {
                                tmp.add("situacaoExameRequisicao");
                                tmp.add(registro.getString("exr_situacao"));
                                tmp.add("assinaturaExameRequisicao");
                                tmp.add(!DBUtil.campoNull(registro.getString("exr_dataassina")) ? registro.getString("usr_codassina") : "");
                                tmp.add("nomeAssinaturaExameRequisicao");
                                tmp.add(!DBUtil.campoNull(registro.getString("exr_dataassina")) ? registro.getString("usr_nome") : "");
                                tmp.add("dataEnvioExameRequisicao");
                                tmp.add("current_timestamp");
                                tmp.add("codigoUsuarioConferenciaExameRequisicao");
                                tmp.add(!DBUtil.campoNull(registro.getString("exr_dataassina")) ? registro.getString("usr_codassina") : "");
                                tmpPagina.add("contadorPaginaRequisicaoExameResultadoPagina");
                                tmpPagina.add("" + String.valueOf(i));
                                if ((isNaoTemExame || registro.getString("exa_codigo").equalsIgnoreCase(codigoExame) && registro.getString("mco_codigo").equalsIgnoreCase(codigoMaterial)) && (map = ResultadosUtil.geraResultadoParaWeb(st, filial, requisicao, registro.getString("exa_codigo"), registro.getString("mco_codigo"), resultadoPorPagina, false, contadorPaginaExame, i + 1 == qtdePaginasResultado, dadosCabecalho)) != null) {
                                    tmpPagina.add("resultadoHtmlRequisicaoExameResultadoPagina");
                                    tmpPagina.add(map.get("laudo").toString());
                                }
                            }
                            alturaLivre = versaoXML.equals("1.0") || reposicionarComponentesPorPagina ? alturaUtil - alturaResultado : 0;
                        } else {
                            ++webOrdem;
                            if (qtdePaginasResultado > 1) {
                                Map<String, Object> map4;
                                tmp2 = (ArrayList)tmp.clone();
                                tmp2Pagina = new ArrayList();
                                tmp2.add("paginaExameRequisicao");
                                tmp2.add(apenasFaturamento ? "-1" : String.valueOf(webPagina));
                                tmp2.add("ordemExameRequisicao");
                                tmp2.add(apenasFaturamento ? "-1" : String.valueOf(webOrdem));
                                tmp2.add("contadorPaginaExameRequisicao");
                                tmp2.add(String.valueOf(i));
                                tmpPagina.addAll(tmp2);
                                buf = new StringBuilder("select b.mco_descricao, a.exr_datamaterial, a.exr_situacao, a.exr_dataassina, a.usr_codassina, c.usr_nome ");
                                buf.append("from examerequisicao a ");
                                buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
                                buf.append("left join usuario c on a.usr_codassina = c.usr_codigo ");
                                buf.append(" where a.fil_codigo = ").append(filial);
                                buf.append(" and a.req_codigo = ").append(requisicao);
                                buf.append(" and a.exa_codigo = '").append(StringUtil.textoDB(registro.getString("exa_codigo"))).append("' ");
                                buf.append(" and a.mco_codigo = ").append(registro.getString("mco_codigo"));
                                rs2 = Conexao.executeQueryPerformance(st, buf);
                                if (rs2.next()) {
                                    tmp2.add("descricaoMaterialExameRequisicao");
                                    tmp2.add(rs2.getString("mco_descricao"));
                                    tmp2.add("dataColetaExameRequisicao");
                                    tmp2.add(!DBUtil.campoNull(rs2.getString("exr_datamaterial")) ? Funcoes.formataData("dd/MM/yyyy", rs2.getDate("exr_datamaterial")) : "");
                                    tmp2.add("horaColetaExameRequisicao");
                                    tmp2.add(!DBUtil.campoNull(rs2.getString("exr_datamaterial")) ? Funcoes.formataHora(rs2.getDate("exr_datamaterial"), false) : "");
                                    tmp2.add("situacaoExameRequisicao");
                                    tmp2.add(rs2.getString("exr_situacao"));
                                    tmp2.add("assinaturaExameRequisicao");
                                    tmp2.add(!DBUtil.campoNull(rs2.getString("exr_dataassina")) ? rs2.getString("usr_codassina") : "");
                                    tmp2.add("nomeAssinaturaExameRequisicao");
                                    tmp2.add(!DBUtil.campoNull(rs2.getString("exr_dataassina")) ? rs2.getString("usr_nome") : "");
                                    tmp2.add("dataEnvioExameRequisicao");
                                    tmp2.add("current_timestamp");
                                    tmp2.add("codigoUsuarioConferenciaExameRequisicao");
                                    tmp2.add(!DBUtil.campoNull(rs2.getString("exr_dataassina")) ? rs2.getString("usr_codassina") : "");
                                    tmp2Pagina.add("codigoBase");
                                    tmp2Pagina.add(codigoBase);
                                    tmp2Pagina.add("codigoRequisicao");
                                    tmp2Pagina.add(IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st));
                                    tmp2Pagina.add("codigoExameRequisicaoResultadoPagina");
                                    tmp2Pagina.add(registro.getString("exa_codigo"));
                                    tmp2Pagina.add("codigoMaterialExameRequisicaoResultadoPagina");
                                    tmp2Pagina.add(registro.getString("mco_codigo"));
                                    tmp2Pagina.add("contadorPaginaRequisicaoExameResultadoPagina");
                                    tmp2Pagina.add("" + String.valueOf(i));
                                    tmpPagina.addAll(tmp2Pagina);
                                    exmesPagina.add(tmp2Pagina);
                                }
                                if ((isNaoTemExame || registro.getString("exa_codigo").equalsIgnoreCase(codigoExame) && registro.getString("mco_codigo").equalsIgnoreCase(codigoMaterial)) && (map4 = ResultadosUtil.geraResultadoParaWeb(st, filial, requisicao, registro.getString("exa_codigo"), registro.getString("mco_codigo"), resultadoPorPagina, false, contadorPaginaExame, i + 1 == qtdePaginasResultado, dadosCabecalho)) != null) {
                                    tmp2Pagina.add("resultadoHtmlRequisicaoExameResultadoPagina");
                                    tmp2Pagina.add(map4.get("laudo").toString());
                                    tmp2.add("resultadoExameRequisicao");
                                    tmp2.add(map4.get("laudo").toString());
                                    tmp2.add("resultadoTextoExameRequisicao");
                                    tmp2.add(ResultadosUtil.geraResultadoTextoParaWeb(st, filial, dadosRequisicao.getString("con_codigo"), dadosRequisicao.getString("des_codigo"), dadosRequisicao.getInt("req_idade"), dadosRequisicao.getString("req_anomes"), registro.getString("exa_codigo"), registro.getInt("mco_codigo"), registro.getString("met_codigo"), resultadoPorPagina));
                                }
                                if (i == qtdePaginasResultado - 1) {
                                    exms.add(tmp2);
                                }
                                comandosMultiplasPaginas.add(tmp2);
                            } else {
                                tmp.add("situacaoExameRequisicao");
                                tmp.add(registro.getString("exr_situacao"));
                                tmp.add("assinaturaExameRequisicao");
                                tmp.add(!DBUtil.campoNull(registro.getString("exr_dataassina")) ? registro.getString("usr_codassina") : "");
                                tmp.add("nomeAssinaturaExameRequisicao");
                                tmp.add(!DBUtil.campoNull(registro.getString("exr_dataassina")) ? registro.getString("usr_nome") : "");
                                tmp.add("dataEnvioExameRequisicao");
                                tmp.add("current_timestamp");
                                tmp.add("codigoUsuarioConferenciaExameRequisicao");
                                tmp.add(!DBUtil.campoNull(registro.getString("exr_dataassina")) ? registro.getString("usr_codassina") : "");
                                tmpPagina.add("contadorPaginaRequisicaoExameResultadoPagina");
                                tmpPagina.add("" + String.valueOf(i));
                                if ((isNaoTemExame || registro.getString("exa_codigo").equalsIgnoreCase(codigoExame) && registro.getString("mco_codigo").equalsIgnoreCase(codigoMaterial)) && (map = ResultadosUtil.geraResultadoParaWeb(st, filial, requisicao, registro.getString("exa_codigo"), registro.getString("mco_codigo"), resultadoPorPagina, false, contadorPaginaExame, i + 1 == qtdePaginasResultado, dadosCabecalho)) != null) {
                                    tmpPagina.add("resultadoHtmlRequisicaoExameResultadoPagina");
                                    tmpPagina.add(map.get("laudo").toString());
                                }
                            }
                            alturaLivre = versaoXML.equals("1.0") || reposicionarComponentesPorPagina ? (alturaLivre -= alturaResultado) : 0;
                        }
                        ultimaPagina = pagina;
                    }
                    if (alturaLivre - distanciaExames > 0) {
                        alturaLivre -= distanciaExames;
                    }
                    ultimaPagina = pagina;
                }
                tmp.add("paginaExameRequisicao");
                tmp.add(apenasFaturamento ? "-1" : String.valueOf(webPagina));
                tmp.add("ordemExameRequisicao");
                tmp.add(apenasFaturamento ? "-1" : String.valueOf(webOrdem));
                tmp.add("contadorPaginaExameRequisicao");
                tmp.add("0");
                exms.add(tmp);
                if (isVariasPaginas) continue;
                exmesPagina.add(tmpPagina);
            }
            for (ArrayList arrayList : exms) {
                if (insertSemVerificacaoPdf) {
                    DBUtil.insereExportaWebSoInsert(st, Variaveis.filialPadrao, "requisicaoexame", "A", "", false, arrayList.toArray(new String[arrayList.size()]));
                    continue;
                }
                DBUtil.insereExportaWeb(st, "requisicaoexame", "A", false, arrayList.toArray(new String[arrayList.size()]));
            }
            for (ArrayList arrayList : exmesPagina) {
                if (insertSemVerificacaoPdf) {
                    DBUtil.insereExportaWebSoInsert(st, Variaveis.filialPadrao, "requisicaoexameresultadopagina", "I", "", false, arrayList.toArray(new String[arrayList.size()]));
                    continue;
                }
                DBUtil.insereExportaWeb(st, "requisicaoexameresultadopagina", "I", false, arrayList.toArray(new String[arrayList.size()]));
            }
            for (ArrayList arrayList : comandosMultiplasPaginas) {
                if (insertSemVerificacaoPdf) {
                    DBUtil.insereExportaWebSoInsert(st, Variaveis.filialPadrao, "requisicaoexame", "I", "", false, arrayList.toArray(new String[arrayList.size()]));
                    continue;
                }
                DBUtil.insereExportaWeb(st, "requisicaoexame", "I", false, arrayList.toArray(new String[arrayList.size()]));
            }
            for (ArrayList arrayList : apagarImagens) {
                if (insertSemVerificacaoPdf) {
                    DBUtil.insereExportaWebSoInsert(st, Variaveis.filialPadrao, "requisicaoexameimagem", "D", "", false, arrayList.toArray(new String[arrayList.size()]));
                    continue;
                }
                DBUtil.insereExportaWeb(st, "requisicaoexameimagem", "D", arrayList.toArray(new String[arrayList.size()]));
            }
            for (ArrayList arrayList : imagens) {
                if (insertSemVerificacaoPdf) {
                    DBUtil.insereExportaWebSoInsert(st, Variaveis.filialPadrao, "requisicaoexameimagem", "I", "", false, arrayList.toArray(new String[arrayList.size()]));
                    continue;
                }
                DBUtil.insereExportaWeb(st, "requisicaoexameimagem", "I", arrayList.toArray(new String[arrayList.size()]));
            }
        }
        String[] sitRequisicao = new String[]{"codigoRequisicao", IntegracaoUtil.formataCodigoRequisicao(filial, requisicao, st), "codigoBase", codigoBase, "situacaoRequisicao", situacaoRequisicao};
        if (insertSemVerificacaoPdf) {
            DBUtil.insereExportaWebSoInsert(st, Variaveis.filialPadrao, "requisicao", "A", "", false, sitRequisicao);
        } else {
            DBUtil.insereExportaWeb(st, "requisicao", "A", false, sitRequisicao);
        }
    }

    private static String getCabecalhoRodape(Statement st, String filial, String codigoLayout) throws Exception {
        StringBuilder bui = new StringBuilder("select lay_cabec, lay_laudoweb from layout where fil_codigo = ");
        bui.append(filial);
        bui.append(" and lay_codigo = ");
        bui.append(codigoLayout);
        ResultSet rs = Conexao.executeQueryPerformance(st, bui.toString());
        if (rs.next()) {
            return !DBUtil.campoNull(rs.getString("lay_laudoweb")) && !Funcoes.textoVazio(rs.getString("lay_laudoweb")) ? rs.getString("lay_laudoweb") : rs.getString("lay_cabec");
        }
        return "";
    }
}

